-----------------------------------
-- Crystal Warrior Dynamis
-----------------------------------
local m = Module:new("base_cw_dynamis")

cexi                         = cexi or {}
cexi.crystal_warrior         = cexi.crystal_warrior or {}
cexi.crystal_warrior.dynamis = cexi.crystal_warrior.dynamis or {}

cexi.crystal_warrior.dynamis.timeExtensions =
{
    [xi.ki.CRIMSON_GRANULES_OF_TIME]   = 1,
    [xi.ki.AZURE_GRANULES_OF_TIME]     = 2,
    [xi.ki.AMBER_GRANULES_OF_TIME]     = 3,
    [xi.ki.ALABASTER_GRANULES_OF_TIME] = 4,
    [xi.ki.OBSIDIAN_GRANULES_OF_TIME]  = 5,
}

cexi.crystal_warrior.dynamis.applyBonus = function(player, keyItem)
    local effect  = player:getStatusEffect(xi.effect.DYNAMIS)
    local current = player:getCharVar("[VENTURE]DYNAMIS_TE")
    local bonus   = utils.mask.countBits(current)

    if keyItem ~= nil then
        local result = utils.mask.setBit(current, cexi.crystal_warrior.dynamis.timeExtensions[keyItem], true)
        bonus        = utils.mask.countBits(result)
        player:setCharVar("[VENTURE]DYNAMIS_TE", result)
    end

    player:setMod(xi.mod.ATTP,      bonus * 5)
    player:setMod(xi.mod.ACC,       bonus * 5)
    player:setMod(xi.mod.MATT,      bonus * 5)
    player:setMod(xi.mod.MACC,      bonus * 5)
    player:setMod(xi.mod.MPHEAL,    bonus * 2)

    effect:addMod(xi.mod.ATTP,      bonus * 5)
    effect:addMod(xi.mod.ACC,       bonus * 5)
    effect:addMod(xi.mod.MATT,      bonus * 5)
    effect:addMod(xi.mod.MACC,      bonus * 5)
    effect:addMod(xi.mod.MPHEAL,    bonus * 2)

    return bonus
end

return m
