-----------------------------------
-- Announcement Utils
-----------------------------------
local m = Module:new("base_cw_announcement")

cexi                                          = cexi or {}
cexi.crystal_warrior                          = cexi.crystal_warrior or {}
cexi.crystal_warrior.announcement             = cexi.crystal_warrior.announcement or {}

local openingDecoration = "\129\154"
local closingDecoration = "\129\154"

-- World First Announcement Function
cexi.crystal_warrior.announcement.worldFirst = function(player, varName, worldMessage, noAnimation)
    local worldFirst = string.format("WF_%s", varName)
    local worldTime  = string.format("WT_%s", varName)

    if
        -- Record hasn't been set yet and player is not GM
        GetVolatileServerVariable(worldFirst) == 0 and
        player:getGMLevel() == 0
    then 
        local decoratedMessage = string.format("%s %s %s", openingDecoration, worldMessage, closingDecoration)
        player:printToArea(decoratedMessage, xi.msg.channel.SYSTEM_3, 0, "") -- Sends announcement via ZMQ to all processes and zones

        -- Write out World First (WF) and World First Time (WT) to server vars)
        SetVolatileServerVariable(worldFirst, player:getID())
        SetVolatileServerVariable(worldTime, os.time())

        -- Summon big swirly starry animation which lingers on the players client in the location
        -- where this event happened. It will linger in that area for anyone that saw it until
        -- they zone.
        if noAnimation == nil then
            player:independentAnimation(player, 12, 3)
        end
    end
end

-- We can use this shorthand to create announcements on the fly that fit the char limit
-- eg. !exec cexi.wf(target,"VAR_NAME","Player is the first player to do something")
cexi.wf = cexi.crystal_warrior.announcement.worldFirst

return m
