-----------------------------------
-- Dynamis Augments
-----------------------------------
local m = Module:new("base_augments_dynamis_augments")

cexi                           = cexi or {}
cexi.augments                  = cexi.augments or {}

local ARCH_ORC_ESSENCE     =   1
local ARCH_QUADAV_ESSENCE  =   2
local ARCH_YAGUDO_ESSENCE  =   4
local ARCH_GOBLIN_ESSENCE  =   8

local ARCH_AHRIMAN_ESSENCE =  16
local ARCH_LORD_ESSENCE    =  32

local ARCH_MORBOL_ESSENCE  =  64
local ARCH_DRAGON_ESSENCE  = 128
local ARCH_GIGAS_ESSENCE   = 256
local ARCH_AVATAR_ESSENCE  = 512

local ARCH_CITIES          =   7

local FORGOTTEN_THOUGHT = 3493
local FORGOTTEN_HOPE    = 3494
local FORGOTTEN_TOUCH   = 3495
local FORGOTTEN_JOURNEY = 3496
local FORGOTTEN_STEP    = 3497
local FORGOTTEN_ANY     = 'ANY'

cexi.augments.dynamis_augments =
{

-- --------------------------------------------------------------------
--                              Armor                                --
-- --------------------------------------------------------------------

-- --------------------------------------------------------------------
--                              Hands                                --
-- --------------------------------------------------------------------

-- WAR
    [14909] =
    {
        name = 'War. Mufflers +1',
        job  = xi.job.WAR,
        item = FORGOTTEN_TOUCH,
        reqs = ARCH_MORBOL_ESSENCE,
        augs =
        {
            { 153, nil, nil, nil, 0, 0, 0, 1, 1, 1, 2 },        -- Shield Mastery: 1~3
            { 363, nil,   0, 0, 0, 1, 1, 1, 2, 2, 3 },          -- Chance of block: 1~4
            {  49, nil, nil, 0, 0, 0, 1, 1, 1, 2, 3 },          -- Haste: 1~4%
        },
    },
    
-- MNK

    [14910] =
    {
        name = 'Mel. Gloves +1',
        job  = xi.job.MNK,
        item = FORGOTTEN_TOUCH,
        reqs = ARCH_MORBOL_ESSENCE,
        augs =
        {
            { 551, 0,     0, 1, 1, 2, 2, 3, 3, 4, 5 },          -- STR/VIT: 1~6
            {  68, nil, nil, 0, 1, 1, 2, 2, 3, 4, 5 },          -- ACC/ATK: 1~6
            { 333, nil,   0, 1, 1, 2, 2, 3, 3, 4, 5 },          -- Conserve TP: 1~6
        },
    },
    
-- WHM

    [14911] =
    {
        name = 'Clr. Mitts +1',
        job  = xi.job.WHM,
        item = FORGOTTEN_TOUCH,
        reqs = ARCH_MORBOL_ESSENCE,
        augs =
        {
            { 288,   0,   1, 2, 3, 4, 5, 6, 7, 8, 9 },          -- Divine Magic Skill: 1~10
            {  55, nil,   0, 0, 0, 1, 1, 1, 2, 2, 3 },          -- Magic Damage Taken: -1~4
            {  37, nil,   0, 1, 1, 2, 2, 3, 3, 4, 5 },          -- Magic Evasion: 1~6
        },
    },

-- BLM

    [14912] =
    {
        name = 'Src. Gloves +1',
        job  = xi.job.BLM,
        item = FORGOTTEN_TOUCH,
        reqs = ARCH_MORBOL_ESSENCE,
        augs =
        {
            { 516,   0, 0, 1, 1, 2, 3, 4, 5, 6, 7 },          -- INT: 1~8
            { 334, nil, 0, 0, 1, 2, 2, 3, 3, 4, 5 },          -- Magic Burst: 1~6
            { 343,   0, 0, 1, 2, 2, 2, 3, 3, 4, 5 },          -- Drain and Aspir Potency: 1~6
        },
    },
    
-- RDM

    [14913] =
    {
        name = 'Dls. Gloves +1',
        job  = xi.job.RDM,
        item = FORGOTTEN_TOUCH,
        reqs = ARCH_MORBOL_ESSENCE,
        augs =
        {
            {  140, nil, nil, 0, 0, 0, 1, 1, 1, 1, 2 },          -- Fast Cast: 1~3%
            {   55, nil, nil, 0, 0, 0, 1, 1, 1, 1, 2 },          -- Magic Damage Taken: -1~3
            { 1248, nil,   0, 0, 1, 2, 3, 4, 5, 6, 7 },          -- Enhancing Magic Duration: 1~8
        },
    },
    
-- THF

    [14914] =
    {
        name = 'Asn. Armlets +1',
        job  = xi.job.THF,
        item = FORGOTTEN_TOUCH,
        reqs = ARCH_MORBOL_ESSENCE,
        augs =
        {
            { 68,   0,   0, 1, 2, 2, 3, 4, 5, 6, 7 },          -- Accuracy/Attack: 1~8
            { 31,   0,   0, 1, 1, 2, 3, 4, 5, 6, 7 },          -- Evasion: 1~8
            { 71, nil,   0, 0, 0, 1, 1, 1, 2, 2, 3 },          -- Damage Taken: -1~4%
        },
    },

-- PLD

    [14915] =
    {
        name = 'Vlr. Gauntlets +1',
        job  = xi.job.PLD,
        item = FORGOTTEN_TOUCH,
        reqs = ARCH_MORBOL_ESSENCE,
        augs =
        {
            { 142, nil,   0, 0, 1, 2, 2, 2, 3, 3, 4 },           -- Store TP: 1~5
            {  49, nil, nil, 0, 0, 0, 1, 1, 1, 1, 2 },           -- Haste: 1~3%
            { 356,   0,   0, 0, 1, 1, 2, 3, 3, 4, 4 },           -- Potency of Cure Received: 1~5%
        },
    },
    
-- DRK

    [14916] =
    {
        name = 'Abs. Gauntlets +1',
        job  = xi.job.DRK,
        item = FORGOTTEN_TOUCH,
        reqs = ARCH_MORBOL_ESSENCE,
        augs =
        {
            { 133, 0, 0, 1, 1, 2,  3,  4,  5,  6,  7 },           -- MAB: 1~8
            { 343, 0, 0, 1, 1, 2,  3,  4,  5,  6,  7 },           -- Drain and Aspir Potency: 1~8
            { 237, 1, 3, 5, 7, 9, 11, 14, 19, 24, 29 },           -- Occult Acumen: 1~30
        },
    },
    
-- BST

    [14917] =
    {
        name = 'Mst. Gloves +1',
        job  = xi.job.BST,
        item = FORGOTTEN_TOUCH,
        reqs = ARCH_MORBOL_ESSENCE,
        augs =
        {
            { 1806,   0,   0, 1, 1, 2, 3, 4, 5, 6, 7 },           -- Pet: STR/DEX/VIT: 1~8
            {  111, nil, nil, 0, 0, 0, 1, 1, 1, 1, 2 },           -- Pet: Haste: 1~3%
            {  115, nil,   0, 0, 1, 1, 2, 2, 3, 3, 4 },           -- Pet: Store TP: 1~5
        },
    },
    
-- BRD

    [14918] =
    {
        name = 'Brd. Cuffs +1',
        job  = xi.job.BRD,
        item = FORGOTTEN_TOUCH,
        reqs = ARCH_MORBOL_ESSENCE,
        augs =
        {
            { 140, nil, nil, nil,   0, 0, 0, 1, 1, 1, 2 },      -- Fast Cast: 1~3%
            { 137, nil, nil, nil, nil, 0, 0, 0, 0, 1, 1 },      -- Regen: 1~2
            {  55, nil, nil,   0,   0, 0, 1, 1, 2, 2, 3 },      -- Magic Damage Taken: -1~4
        },
    },

-- RNG

    [14919] =
    {
        name = 'Sct. Bracers +1',
        job  = xi.job.RNG,
        item = FORGOTTEN_TOUCH,
        reqs = ARCH_MORBOL_ESSENCE,
        augs =
        {
            { 515, nil, 0, 0, 0, 1, 1, 1, 2, 2, 3 },            -- AGI: 1~4
            { 131, nil, 0, 1, 1, 2, 2, 3, 3, 4, 5 },            -- MAB/Magic Accuracy: 1~6
            { 333,   0, 1, 2, 3, 4, 5, 6, 7, 8, 9 },            -- Conserve TP: 1~10
        },
    },

-- SAM

    [14920] =
    {
        name = 'Sao. Kote +1',
        job  = xi.job.SAM,
        item = FORGOTTEN_TOUCH,
        reqs = ARCH_MORBOL_ESSENCE,
        augs =
        {
            { 142, nil,   0,   0, 0, 1, 1, 1, 2, 3, 3 },        -- Store TP: 1~4
            {  49, nil, nil,   0, 0, 0, 1, 1, 1, 1, 2 },        -- Haste: 1~3%
            {  54, nil, nil, nil, 0, 0, 0, 1, 1, 1, 2 },        -- Physical Damage Taken: -1~3%
        },
    },
    
-- NIN

    [14921] =
    {
        name = 'Kog. Tekko +1',
        job  = xi.job.NIN,
        item = FORGOTTEN_TOUCH,
        reqs = ARCH_MORBOL_ESSENCE,
        augs =
        {
            {  68,   0, 0, 1, 1, 2, 3, 4, 5, 6, 7 },           -- Acc/Atk: 1~8
            {  31, nil, 0, 0, 1, 1, 2, 2, 3, 4, 5 },           -- Evasion: 1~6
            {  71, nil, 0, 0, 0, 1, 1, 1, 2, 2, 3 },           -- Damage Taken: -1~4
        },
    },

-- DRG

    [14922] =
    {
        name = 'Wym. Fng. Gnt. +1',
        job  = xi.job.DRG,
        item = FORGOTTEN_TOUCH,
        reqs = ARCH_MORBOL_ESSENCE,
        augs =
        {
            {  49, nil, nil, nil, 0, 0, 0, 1, 1, 1, 2 },        -- Haste: 1~3%
            {  71, nil, nil,   0, 0, 1, 1, 1, 1, 2, 2 },        -- Damage Taken: -1~3
            { 110, nil,   0,   0, 1, 1, 2, 2, 3, 3, 4 },        -- Pet: Regen: 1~5
        },
    },
    
-- SMN

    [14923] =
    {
        name = 'Smn. Bracers +1',
        job  = xi.job.SMN,
        item = FORGOTTEN_TOUCH,
        reqs = ARCH_MORBOL_ESSENCE,
        augs =
        {
            {  71, nil, nil,  0,  0, 0, 0, 1, 1, 1, 2 },        -- Damage Taken: -1~3
            { 796,   0,   1,  1,  1, 2, 3, 4, 5, 6, 7 },        -- All elemental resists: 1~8
            { 369, nil, nil, nil, 0, 0, 0, 1, 1, 1, 2 },        -- Avatar: Blood Pact Dmg: 1~3
        },
    },
    
-- BLU

    [15026] =
    {
        name = 'Mrg. Bazubands +1',
        job  = xi.job.BLU,
        item = FORGOTTEN_TOUCH,
        reqs = ARCH_MORBOL_ESSENCE,
        augs =
        {
            { 551, nil, 0, 0, 1, 1, 2, 2, 3, 4, 5 },        -- STR/VIT: 1~6
            {  68,   0, 0, 1, 1, 2, 3, 4, 5, 6, 7 },        -- Acc/Atk: 1~8
            {  49, nil, 0, 0, 1, 1, 2, 2, 3, 3, 4 },        -- Haste: 1~5%
        },
    },

-- COR

    [15029] =
    {
        name = 'Comm. Gants +1',
        job  = xi.job.COR,
        item = FORGOTTEN_TOUCH,
        reqs = ARCH_MORBOL_ESSENCE,
        augs =
        {
            { 515,   0,   0, 1, 1, 2, 2, 3, 3, 4, 5 },        -- AGI: 1~6
            { 131, nil,   0, 0, 1, 1, 2, 2, 3, 3, 4 },        -- MAB/Magic Accuracy: 1~5
            { 325, nil, nil, 0, 0, 0, 0, 1, 1, 1, 2 },        -- Quick Draw ability delay: -1~3
        },
    },
    
-- PUP

    [15032] =
    {
        name = 'Pantin Dastanas +1',
        job  = xi.job.PUP,
        item = FORGOTTEN_TOUCH,
        reqs = ARCH_MORBOL_ESSENCE,
        augs =
        {
            {  550, nil, 0, 0, 1, 2, 3, 4, 5, 6, 7 },        -- STR/DEX: 1~8
            {   31,   0, 0, 1, 1, 2, 3, 4, 5, 6, 7 },        -- Evasion: 1~8
            { 1806, nil, 0, 0, 1, 2, 3, 4, 5, 6, 7 },        -- Pet: STR/DEX/VIT: 1~8
        },
    },

-- DNC

    [15039] =
    {
        name = 'Etoile Bangles +1',
        job  = xi.job.DNC,
        item = FORGOTTEN_TOUCH,
        reqs = ARCH_MORBOL_ESSENCE,
        augs =
        {
            {  31,   0, 0, 1, 1, 2, 3, 4, 5, 6, 7 },        -- Evasion: 1~8
            { 145, nil, 0, 0, 1, 1, 1, 2, 2, 3, 3 },        -- Counter: 1~4
            {  71, nil, 0, 0, 0, 1, 1, 1, 2, 2, 3 },        -- Damage Taken: -1~4%
        },
    },
    
-- SCH

    [15041] =
    {
        name = 'Argute Bracers +1',
        job  = xi.job.SCH,
        item = FORGOTTEN_TOUCH,
        reqs = ARCH_MORBOL_ESSENCE,
        augs =
        {
            {  140, nil, nil, 0, 0, 0, 1, 1, 1, 1, 2 },        -- Fast Cast: 1~3%
            { 1251,   0,   1, 2, 3, 4, 5, 6, 7, 8, 9 },        -- Enfeebling Magic Duration: 1~10
            {  371, nil, nil, 0, 0, 0, 1, 1, 1, 1, 2 },        -- Regen Potency: 1~3
        },
    },

-- GEO

    [27017] =
    {
        name = 'Bagua Mitaines +1',
        job  = xi.job.GEO,
        item = FORGOTTEN_TOUCH,
        reqs = ARCH_MORBOL_ESSENCE,
        augs =
        {
            { 140, nil, nil,   0, 0, 0, 1, 1, 1, 2, 2 },        -- Fast Cast: 1~3%
            { 134, nil, nil, nil, 0, 0, 0, 1, 1, 1, 2 },        -- Magic Defense Bonus: 1~3
            {  71, nil,   0,   0, 0, 1, 1, 1, 2, 2, 3 },        -- Damage Taken: -1~4
        },
    },
    
-- RUN

    [27019] =
    {
        name = 'Futhark Mitons +1',
        job  = xi.job.RUN,
        item = FORGOTTEN_TOUCH,
        reqs = ARCH_MORBOL_ESSENCE,
        augs =
        {
            { 551,   0,   0, 0, 1, 2, 3, 4, 5, 6, 7 },        -- STR/VIT: 1~8
            { 134, nil, nil, 0, 0, 1, 1, 2, 2, 3, 3 },        -- Magic Defense Bonus: 1~4
            {  49, nil,   0, 0, 0, 1, 1, 1, 2, 2, 3 },        -- Haste: 1~4%
        },
    },

-- --------------------------------------------------------------------
--                              Legs                                 --
-- --------------------------------------------------------------------
    
-- WAR

    [15580] =
    {
        name = 'War. Cuisses +1',
        job  = xi.job.WAR,
        item = FORGOTTEN_JOURNEY,
        reqs = ARCH_GIGAS_ESSENCE,
        augs =
        {
            {  68,   0,   1, 2, 3, 4, 5, 6, 7, 8, 9 },          -- ACC/ATK: 1~10
            {  54, nil,   0, 0, 0, 1, 1, 1, 2, 2, 3 },          -- Physical Damage Taken: -1~4
            {  49, nil,   0, 0, 0, 1, 1, 1, 2, 2, 3 },          -- Haste: 1~4%
        },
    },
    
-- MNK

    [15581] =
    {
        name = 'Mel. Hose +1',
        job  = xi.job.MNK,
        item = FORGOTTEN_JOURNEY,
        reqs = ARCH_GIGAS_ESSENCE,
        augs =
        {
            { 151,   0,   1,   1, 2, 2, 2, 3, 3, 4, 5 },          -- Martial Arts: 1~6
            { 194, nil, nil, nil, 0, 0, 1, 1, 2, 3, 4 },          -- Kick Attacks: 1~5
            {  54, nil, nil,   0, 0, 1, 1, 1, 2, 2, 3 },          -- Physical Damage Taken: -1~4%
        },
    },
    
-- WHM

    [15582] =
    {
        name = 'Clr. Pantaln. +1',
        job  = xi.job.WHM,
        item = FORGOTTEN_JOURNEY,
        reqs = ARCH_GIGAS_ESSENCE,
        augs =
        {
            { 329,   0,   0,   1, 1, 2, 2, 3, 3, 4, 5 },          -- Cure Potency: 1~6
            { 290,   0,   1,   2, 3, 4, 5, 6, 7, 8, 9 },          -- Enhancing Magic Skill: 1~10
            {  71, nil, nil, nil, 0, 0, 1, 1, 2, 2, 3 },          -- Damage Taken: -1~4%
        },
    },

-- BLM

    [15583] =
    {
        name = 'Src. Tonban +1',
        job  = xi.job.BLM,
        item = FORGOTTEN_JOURNEY,
        reqs = ARCH_GIGAS_ESSENCE,
        augs =
        {
            { 292,   0,   0, 1, 1, 2, 3, 4, 5, 6, 7 },          -- Elemental Magic Skill: 1~8
            {  57, nil,   0, 0, 1, 2, 3, 4, 5, 6, 7 },          -- Magic Crit. Rate: 1~8
            { 335, nil, nil, 0, 1, 2, 3, 4, 5, 6, 7 },          -- Magic Crit. Dmg.: 1~8
        },
    },
    
-- RDM

    [15584] =
    {
        name = 'Dls. Tights +1',
        job  = xi.job.RDM,
        item = FORGOTTEN_JOURNEY,
        reqs = ARCH_GIGAS_ESSENCE,
        augs =
        {
            { 558,   0, 0, 1, 1, 2, 3, 4, 5, 6, 7 },          -- STR/INT: 1~8
            { 334,   0, 0, 1, 1, 2, 2, 3, 3, 4, 5 },          -- Magic Burst Dmg.: 1~6
            {  49, nil, 0, 0, 1, 2, 2, 2, 3, 3, 4 },          -- Haste: 1~5
        },
    },
    
-- THF

    [15585] =
    {
        name = 'Asn. Culottes +1',
        job  = xi.job.THF,
        item = FORGOTTEN_JOURNEY,
        reqs = ARCH_GIGAS_ESSENCE,
        augs =
        {
            { 37,   0,   0, 0, 1, 1, 2, 3, 3, 4, 5 },          -- Magic Evasion: 1~6
            { 44, nil,   0, 0, 0, 1, 1, 1, 2, 2, 3 },          -- Store TP/Subtle Blow: 1~4
            { 49, nil, nil, 0, 0, 0, 1, 1, 2, 2, 3 },          -- Haste: 1~4%
        },
    },

-- PLD

    [15586] =
    {
        name = 'Vlr. Breeches +1',
        job  = xi.job.PLD,
        item = FORGOTTEN_JOURNEY,
        reqs = ARCH_GIGAS_ESSENCE,
        augs =
        {
            {  260,   0,   1, 2, 3, 4, 5, 6, 7, 9, 11 },           -- Great Sword Skill: 1~12
            {   49, nil, nil, 0, 0, 0, 1, 1, 1, 1,  2 },           -- Haste: 1~3%
            { 1472, nil, nil, 0, 0, 0, 1, 1, 1, 1,  2 },           -- Parry Rate: 1~3
        },
    },
    
-- DRK

    [15587] =
    {
        name = 'Abs. Flanchard +1',
        job  = xi.job.DRK,
        item = FORGOTTEN_JOURNEY,
        reqs = ARCH_GIGAS_ESSENCE,
        augs =
        {
            {  68,   0,   1, 2, 3, 4, 5, 6, 7, 8, 9 },           -- Acc/Atk: 1~10
            { 142, nil, nil, 0, 0, 0, 1, 1, 2, 2, 3 },           -- Store TP: 1~4
            {  55, nil,   0, 0, 1, 1, 2, 2, 3, 3, 4 },           -- Magic Damage Taken: -1~5%
        },
    },
    
-- BST

    [15588] =
    {
        name = 'Mst. Trousers +1',
        job  = xi.job.BST,
        item = FORGOTTEN_JOURNEY,
        reqs = ARCH_GIGAS_ESSENCE,
        augs =
        {
            { 143, nil, nil, nil, nil, 0, 0, 1, 1, 2, 2 },           -- Double Attack: 1~3%
            {  49, nil,   0,   0,   1, 1, 2, 2, 3, 3, 4 },           -- Haste: 1~5%
            { 112, nil, nil,   0,   0, 1, 1, 1, 2, 2, 3 },           -- Pet: Damage Taken: -1~4%
        },
    },
    
-- BRD

    [15589] =
    {
        name = 'Brd. Cannions +1',
        job  = xi.job.BRD,
        item = FORGOTTEN_JOURNEY,
        reqs = ARCH_GIGAS_ESSENCE,
        augs =
        {
            {  35,   0,   0, 1, 1, 2, 2, 3, 3, 4, 5 },      -- Magic Accuracy: 1~6
            { 329, nil,   0, 0, 1, 1, 2, 2, 3, 3, 4 },      -- Cure Potency: 1~5%
            {  71, nil, nil, 0, 0, 1, 1, 2, 2, 2, 3 },      -- Damage Taken: -1~4%
        },
    },

-- RNG

    [15590] =
    {
        name = 'Sct. Braccae +1',
        job  = xi.job.RNG,
        item = FORGOTTEN_JOURNEY,
        reqs = ARCH_GIGAS_ESSENCE,
        augs =
        {
            { 559,   0,   0,   1, 1, 2, 3, 4, 5, 6, 7 },            -- STR/MND: 1~8
            {  29,   0,   1,   1, 2, 3, 4, 5, 6, 7, 8 },            -- Ranged Attack: 1~9
            { 139, nil, nil, nil, 0, 0, 0, 1, 1, 1, 2 },            -- Rapid Shot: 1~3
        },
    },

-- SAM

    [15591] =
    {
        name = 'Sao. Haidate +1',
        job  = xi.job.SAM,
        item = FORGOTTEN_JOURNEY,
        reqs = ARCH_GIGAS_ESSENCE,
        augs =
        {
            { 198,   0, 0, 1, 1, 2, 2, 3, 3, 4, 4 },        -- Zanshin: 1~5
            {  49, nil, 0, 0, 0, 1, 1, 1, 2, 2, 3 },        -- Haste: 1~4%
            {  54, nil, 0, 0, 1, 1, 2, 2, 3, 3, 4 },        -- Physical Damage Taken: -1~5%
        },
    },
    
-- NIN

    [15592] =
    {
        name = 'Kog. Hakama +1',
        job  = xi.job.NIN,
        item = FORGOTTEN_JOURNEY,
        reqs = ARCH_GIGAS_ESSENCE,
        augs =
        {
            { 553,   0,   0, 1, 2, 2, 2, 3, 4, 4, 5 },           -- DEX/AGI: 1~6
            { 145, nil,   0, 0, 1, 1, 2, 2, 3, 4, 5 },           -- Counter: 1~6
            {  71, nil, nil, 0, 0, 1, 1, 2, 2, 3, 4 },           -- Damage Taken: -1~5
        },
    },

-- DRG

    [15593] =
    {
        name = 'Wym. Brais +1',
        job  = xi.job.DRG,
        item = FORGOTTEN_JOURNEY,
        reqs = ARCH_GIGAS_ESSENCE,
        augs =
        {
            { 110, nil,   0,   0, 1, 1, 2, 2, 3, 3, 4 },        -- Store TP: 1~5
            {  49, nil, nil, nil, 0, 0, 0, 1, 1, 1, 2 },        -- Haste: 1~3%
            {  71, nil, nil,   0, 0, 1, 1, 1, 1, 2, 2 },        -- Damage Taken: -1~3
        },
    },
    
-- SMN

    [15594] =
    {
        name = 'Smn. Spats +1',
        job  = xi.job.SMN,
        item = FORGOTTEN_JOURNEY,
        reqs = ARCH_GIGAS_ESSENCE,
        augs =
        {
            { 294,   0, 1, 2, 3, 4, 5, 6, 7, 8, 9 },        -- Summoning Magic Skill: 1~10
            { 233,   0, 0, 1, 1, 2, 3, 4, 5, 6, 7 },        -- Blood Boon: 1~8
            { 127, nil, 0, 0, 0, 1, 1, 1, 2, 2, 3 },        -- Pet: Magic Damage Taken: -1~4%
        },
    },
    
-- BLU

    [16347] =
    {
        name = 'Mirage Shalwar +1',
        job  = xi.job.BLU,
        item = FORGOTTEN_JOURNEY,
        reqs = ARCH_GIGAS_ESSENCE,
        augs =
        {
            { 559,   0,   0, 1, 1, 2, 2, 3, 3, 4, 5 },        -- STR/MND: 1~6
            {  37, nil,   0, 0, 1, 1, 2, 2, 3, 4, 5 },        -- Magic Evasion: 1~6
            {  49, nil, nil, 0, 0, 0, 0, 1, 1, 1, 2 },        -- Haste: 1~3%
        },
    },

-- COR

    [16350] =
    {
        name = 'Comm. Trews +1',
        job  = xi.job.COR,
        item = FORGOTTEN_JOURNEY,
        reqs = ARCH_GIGAS_ESSENCE,
        augs =
        {
            { 69,   0,   0, 1, 1, 2, 3, 4, 5, 6, 7 },        -- Ranged Accuracy/Ranged Attack: 1~8
            { 37, nil,   0, 0, 1, 1, 2, 2, 3, 4, 5 },        -- Magic Evasion: 1~6
            { 49, nil, nil, 0, 0, 0, 0, 1, 1, 1, 2 },        -- Haste: 1~3%
        },
    },
    
-- PUP

    [16353] =
    {
        name = 'Pantin Churidars +1',
        job  = xi.job.PUP,
        item = FORGOTTEN_JOURNEY,
        reqs = ARCH_GIGAS_ESSENCE,
        augs =
        {
            {   49, nil, 0, 0, 0, 1, 1, 1, 2, 2, 3 },        -- Haste: 1~4%
            { 1797,   0, 1, 2, 3, 4, 5, 6, 7, 8, 9 },        -- Pet: MND: 1~10
            {  280, nil, 0, 0, 1, 1, 2, 2, 3, 4, 5 },        -- Automaton: Magic Skill: 1~6
        },
    },

-- DNC

    [16361] =
    {
        name = 'Etoile Tights +1',
        job  = xi.job.DNC,
        item = FORGOTTEN_JOURNEY,
        reqs = ARCH_GIGAS_ESSENCE,
        augs =
        {
            {   68,   0,   0, 1, 1, 2, 3, 4, 5, 6, 7 },        -- Acc/Atk: 1~8
            {   44, nil,   0, 0, 1, 1, 2, 2, 3, 3, 4 },        -- Store TP/Subtle Blow: 1~5
            { 1472, nil, nil, 0, 0, 0, 0, 1, 1, 1, 2 },        -- Parry Rate: 1~3
        },
    },
    
-- SCH

    [16363] =
    {
        name = 'Argute Pants +1',
        job  = xi.job.SCH,
        item = FORGOTTEN_JOURNEY,
        reqs = ARCH_GIGAS_ESSENCE,
        augs =
        {
            {  35,   0, 1, 2, 3, 4, 5, 6, 7, 8, 9 },        -- Magic Accuracy: 1~10
            { 133, nil, 0, 0, 1, 1, 2, 2, 3, 3, 4 },        -- Magic Attack Bonus: 1~5
            { 343,   0, 0, 1, 1, 2, 2, 3, 4, 5, 6 },        -- Drain and Aspir Potency: 1~7
        },
    },

-- GEO

    [27193] =
    {
        name = 'Bagua Pants +1',
        job  = xi.job.GEO,
        item = FORGOTTEN_JOURNEY,
        reqs = ARCH_GIGAS_ESSENCE,
        augs =
        {
            { 554, nil,   0,   0, 1, 2, 3, 4, 5, 6, 7 },        -- INT/MND: 1~8
            { 301, nil, nil,   0, 1, 2, 3, 4, 5, 6, 7 },        -- Handbell Skill: 1~8
            { 141,   0,   0,   1, 1, 2, 3, 4, 5, 6, 7 },        -- Conserve MP: 1~8
        },
    },
    
-- RUN

    [27195] =
    {
        name = 'Futhark Trousers +1',
        job  = xi.job.RUN,
        item = FORGOTTEN_JOURNEY,
        reqs = ARCH_GIGAS_ESSENCE,
        augs =
        {
            {  23,   0,   0, 1, 1, 2, 3, 4, 5, 6, 7 },        -- Accuracy: 1~8
            { 142, nil,   0, 0, 1, 1, 2, 2, 3, 3, 4 },        -- Store TP: 1~5
            {  49, nil, nil, 0, 0, 0, 1, 1, 2, 2, 3 },        -- Haste: 1~4%
        },
    },    
    
    
-- --------------------------------------------------------------------
--                              Feet                                 --
-- --------------------------------------------------------------------

-- WAR

    [15665] =
    {
        name = 'War. Calligae +1',
        job  = xi.job.WAR,
        item = FORGOTTEN_STEP,
        reqs = ARCH_DRAGON_ESSENCE,
        augs =
        {
            {  68,   0,   0, 1, 1, 2, 3, 4,  5,  6,  7 },          -- Acc/Atk: 1~8
            { 286,   0,   1, 2, 3, 4, 6, 8, 10, 12, 14 },          -- Shield Skill: 1~15
            {  49, nil, nil, 0, 0, 0, 1, 1,  1,  1,  2 },          -- Haste: 1~3%
        },
    },

-- MNK

    [15666] =
    {
        name = 'Mel. Gaiters +1',
        job  = xi.job.MNK,
        item = FORGOTTEN_STEP,
        reqs = ARCH_DRAGON_ESSENCE,
        augs =
        {
            {  23,   0, 0, 1, 1, 2, 3, 4, 5, 6, 7 },          -- Acc: 1~8
            { 145, nil, 0, 0, 1, 1, 1, 2, 2, 3, 3 },          -- Counter: 1~4
            {  49, nil, 0, 0, 0, 1, 1, 1, 2, 2, 3 },          -- Haste: 1~4%
        },
    },
    
-- WHM

    [15667] =
    {
        name = 'Clr. Duckbills +1',
        job  = xi.job.WHM,
        item = FORGOTTEN_STEP,
        reqs = ARCH_DRAGON_ESSENCE,
        augs =
        {
            {  559, nil, 0, 0, 1, 1, 2, 2, 3, 3, 4 },          -- STR/MND: 1~5
            {  267,   0, 0, 1, 1, 2, 3, 4, 5, 6, 7 },          -- Club Skill: 1~8
            { 1248,   0, 0, 1, 1, 2, 3, 4, 5, 6, 7 },          -- Enhancing Magic Effect Duration: 1~8%
        },
    },

-- BLM

    [15668] =
    {
        name = 'Src. Sabots +1',
        job  = xi.job.BLM,
        item = FORGOTTEN_STEP,
        reqs = ARCH_DRAGON_ESSENCE,
        augs =
        {
            { 133, nil, nil,   0, 0, 0, 1, 1, 1, 1, 2 },          -- MAB: 1~3
            { 334, nil, nil, nil, 0, 0, 0, 1, 1, 1, 2 },          -- Magic Burst: 1~3
            {  57,   0,   0,   1, 1, 2, 3, 4, 5, 6, 7 },          -- Magic Critical Hit Rate: 1~8%
        },
    },

-- RDM

    [15669] =
    {
        name = 'Dls. Boots +1',
        job  = xi.job.RDM,
        item = FORGOTTEN_STEP,
        reqs = ARCH_DRAGON_ESSENCE,
        augs =
        {
            { 140, nil, nil, nil, 0, 0, 1, 1, 2, 2, 3 },          -- Fast Cast: 1~4%
            {  35, nil,   0,   0, 0, 1, 1, 1, 2, 2, 3 },          -- Magic Accuracy: 1~4
            { 343,   0,   0,   1, 1, 2, 2, 3, 3, 4, 5 },          -- Drain and Aspir Potency: 1~6
        },
    },

-- THF

    [15670] =
    {
        name = 'Asn. Poulaines +1',
        job  = xi.job.THF,
        item = FORGOTTEN_STEP,
        reqs = ARCH_DRAGON_ESSENCE,
        augs =
        {
            {   31,   0,   0, 0, 1, 2, 2, 3, 4, 4, 5 },        -- Evasion: 1~6
            { 1472, nil,   0, 0, 0, 1, 1, 1, 1, 2, 2 },        -- Parry Rate: 1~3%
            {   49, nil, nil, 0, 0, 0, 1, 1, 1, 1, 2 },        -- Haste: 1~3%
        },
    },

-- PLD

    [15671] =
    {
        name = 'Vlr. Leggings +1',
        job  = xi.job.PLD,
        item = FORGOTTEN_STEP,
        reqs = ARCH_DRAGON_ESSENCE,
        augs =
        {
            { 514,   0,   1, 2, 3, 4, 5, 6, 7, 9, 11 },        -- VIT: 1~12
            {  39, nil,   0, 0, 0, 1, 1, 1, 1, 2,  2 },        -- Enmity: 1~3
            { 153, nil, nil, 0, 0, 0, 1, 1, 1, 1,  2 },        -- Shield Mastery: 1~3
        },
    },

-- DRK

    [15672] =
    {
        name = 'Abs. Sollerets +1',
        job  = xi.job.DRK,
        item = FORGOTTEN_STEP,
        reqs = ARCH_DRAGON_ESSENCE,
        augs =
        {
            { 140, nil, nil, 0, 0, 0, 1, 1, 1, 1, 2 },          -- Fast Cast: 1~3%
            {  35,   0,   0, 1, 1, 2, 2, 3, 3, 4, 5 },          -- Magic Accuracy: 1~6
            { 334,   0,   1, 2, 3, 4, 5, 6, 7, 8, 9 },          -- Magic Burst: 1~10
        },
    },
    
-- BST

    [15673] =
    {
        name = 'Mst. Gaiters +1',
        job  = xi.job.BST,
        item = FORGOTTEN_STEP,
        reqs = ARCH_DRAGON_ESSENCE,
        augs =
        {
            { 555, 0, 0, 1, 1, 2, 3, 4, 5, 6,  7 },          -- MND/CHR: 1~8
            { 124, 0, 1, 2, 3, 4, 5, 6, 7, 9, 11 },          -- Pet: Acc, R.Acc, Atk., R.Atk.: 1~12
            { 122, 0, 1, 2, 3, 4, 5, 6, 7, 8,  9 },          -- Pet: TP Bonus: 20~200
        },
    },
    
-- BRD

    [15674] =
    {
        name = 'Brd. Slippers +1',
        job  = xi.job.BRD,
        item = FORGOTTEN_STEP,
        reqs = ARCH_DRAGON_ESSENCE,
        augs =
        {
            { 518,   0,   0,   1, 1, 2, 3, 4, 5, 6, 7 },          -- CHR: 1~8
            { 337, nil, nil, nil, 0, 0, 1, 1, 1, 1, 2 },          -- Song Recast Delay: -1~3
            { 297, nil,   0,   0, 1, 2, 3, 4, 5, 6, 7 },          -- String Instrument Skill: 1~8
        },
    },
    
-- RNG

    [15675] =
    {
        name = 'Sct. Socks +1',
        job  = xi.job.RNG,
        item = FORGOTTEN_STEP,
        reqs = ARCH_DRAGON_ESSENCE,
        augs =
        {
            { 559, nil,   0, 0, 1, 1, 2, 2, 3, 4, 5 },          -- STR/MND: 1~6
            { 211, nil, nil, 0, 0, 0, 1, 1, 1, 1, 2 },          -- Snapshot: 1~3
            { 333,   0,   0, 1, 1, 2, 2, 3, 3, 4, 5 },          -- Conserve TP: 1~6
        },
    },

-- SAM

    [15676] =
    {
        name = 'Sao. Sune-Ate +1',
        job  = xi.job.SAM,
        item = FORGOTTEN_STEP,
        reqs = ARCH_DRAGON_ESSENCE,
        augs =
        {
            {  198, nil,   0,   0, 0, 1, 1, 1, 2, 2, 2 },        -- Zanshin: 1~3
            { 1472, nil, nil,   0, 0, 0, 1, 1, 1, 2, 2 },        -- Parry Rate: 1~3%
            {   49, nil, nil, nil, 0, 0, 0, 1, 1, 1, 2 },        -- Haste: 1~3%
        },
    },    

-- NIN

    [15677] =
    {
        name = 'Kog. Kyahan +1',
        job  = xi.job.NIN,
        item = FORGOTTEN_STEP,
        reqs = ARCH_DRAGON_ESSENCE,
        augs =
        {
            {  37,   0,   1, 1, 2, 2, 2, 3, 3, 4, 5 },        -- Magic Evasion: 1~6
            { 251, nil, nil, 0, 0, 0, 1, 1, 1, 1, 2 },        -- Daken: 1~3%
            {  49, nil,   0, 0, 0, 1, 1, 1, 2, 2, 3 },        -- Haste: 1~4%
        },
    },
 
-- DRG

    [15678] =
    {
        name = 'Wym. Greaves +1',
        job  = xi.job.DRG,
        item = FORGOTTEN_STEP,
        reqs = ARCH_DRAGON_ESSENCE,
        augs =
        {
            {  68,    0,   0, 0, 1, 2, 3, 4, 5, 6, 7 },        -- Acc/Atk: 1~8
            { 1472, nil,   0, 0, 0, 1, 1, 1, 1, 2, 2 },        -- Parry Rate: 1~3%
            {   49, nil, nil, 0, 0, 0, 1, 1, 1, 1, 2 },        -- Haste: 1~3%
        },
    },
    
-- SMN

    [15679] =
    {
        name = 'Smn. Pigaches +1',
        job  = xi.job.SMN,
        item = FORGOTTEN_STEP,
        reqs = ARCH_DRAGON_ESSENCE,
        augs =
        {
            { 329,   0,   1, 1, 2, 2, 2, 3, 3, 4, 5 },        -- Cure Potency: 1~6
            { 140, nil,   0, 1, 1, 2, 2, 2, 3, 3, 4 },        -- Fast Cast: 1~5%
            { 109, nil, nil, 0, 0, 0, 1, 1, 1, 1, 2 },        -- Pet: Dbl.Atk. Crit.hit rate: 1~3%
        },
    },
    
-- BLU

    [11383] =
    {
        name = 'Mirage Charuqs +1',
        job  = xi.job.BLU,
        item = FORGOTTEN_STEP,
        reqs = ARCH_DRAGON_ESSENCE,
        augs =
        {
            {   71, nil,   0,   0, 0, 1, 1, 1, 2, 2, 2 },        -- Damage Taken: -1~3
            { 1472, nil, nil,   0, 0, 0, 1, 1, 1, 2, 2 },        -- Parry Rate: 1~3%
            {   49, nil, nil, nil, 0, 0, 0, 1, 1, 1, 2 },        -- Haste: 1~3%
        },
    },

-- COR

    [11386] =
    {
        name = 'Comm. Bottes +1',
        job  = xi.job.COR,
        item = FORGOTTEN_STEP,
        reqs = ARCH_DRAGON_ESSENCE,
        augs =
        {
            { 1472, nil,   0,   0, 0, 1, 1, 1, 2, 3, 3 },        -- Parry Rate: 1~4%
            {   49, nil, nil,   0, 0, 0, 1, 1, 1, 1, 2 },        -- Haste: 1~3%
            {  340, nil, nil, nil, 0, 0, 0, 1, 1, 1, 2 },        -- Phantom Roll ability delay: -1~3
        },
    },

-- PUP

    [11389] =
    {
        name = 'Ptn. Babouches +1',
        job  = xi.job.PUP,
        item = FORGOTTEN_STEP,
        reqs = ARCH_DRAGON_ESSENCE,
        augs =
        {
            {   49, nil, nil, 0, 0, 0, 1, 1, 1, 1, 2 },        -- Haste: 1~3%
            { 1796,   0,   1, 2, 3, 4, 5, 6, 7, 8, 9 },        -- Pet: INT: 1~10
            {  112, nil, nil, 0, 0, 0, 1, 1, 1, 1, 2 },        -- Pet: Damage Taken: -1~3
        },
    },
    
-- DNC

    [11397] =
    {
        name = 'Etoile Toe Shoes +1',
        job  = xi.job.DNC,
        item = FORGOTTEN_STEP,
        reqs = ARCH_DRAGON_ESSENCE,
        augs =
        {
            { 557, 0, 0, 1, 1, 2, 2, 3, 4, 5,  6 },        -- STR/CHR: 1~7
            { 333, 0, 1, 2, 3, 4, 5, 6, 7, 8,  9 },        -- Conserve TP: 1~10
            {  25, 0, 1, 2, 3, 4, 5, 6, 7, 9, 11 },        -- Attack: 1~12
        },
    },
    
-- SCH

    [11399] =
    {
        name = 'Argute Loafers +1',
        job  = xi.job.SCH,
        item = FORGOTTEN_STEP,
        reqs = ARCH_DRAGON_ESSENCE,
        augs =
        {
            { 329, nil,   0,   0, 1, 1, 1, 2, 2, 2, 3 },        -- Cure Potency: 1~4
            { 140, nil, nil, nil, 0, 0, 1, 1, 2, 2, 3 },        -- Fast Cast: 1~4%
            { 141,   0,   0,   1, 1, 2, 2, 3, 3, 4, 5 },        -- Conserve MP: 1~6
        },
    },

-- GEO

    [27369] =
    {
        name = 'Bagua Sandals +1',
        job  = xi.job.GEO,
        item = FORGOTTEN_STEP,
        reqs = ARCH_DRAGON_ESSENCE,
        augs =
        {
            { 554,   0,   0, 1, 1, 2, 2, 3, 3, 4, 5 },        -- INT/MND: 1~6
            {  40, nil,   0, 0, 1, 1, 2, 2, 3, 3, 4 },        -- Enmity: -1~5
            {  54, nil, nil, 0, 0, 1, 1, 2, 2, 3, 4 },        -- Physical Damage Taken: -1~5
        },
    },
    
-- RUN

    [27371] =
    {
        name = 'Futhark Boots +1',
        job  = xi.job.RUN,
        item = FORGOTTEN_STEP,
        reqs = ARCH_DRAGON_ESSENCE,
        augs =
        {
            { 514,    0, 1, 2, 3, 4, 5, 6, 7, 8, 9 },        -- VIT: 1~10
            {  37,    0, 0, 1, 1, 2, 3, 4, 5, 6, 7 },        -- Magic Evasion: 1~8
            { 1472, nil, 0, 0, 0, 1, 1, 1, 2, 2, 3 },        -- Parry Rate: 1~4%
        },
    },    

-- --------------------------------------------------------------------
--                          Accessories                              --
-- --------------------------------------------------------------------

    [15871] =
    {
        name = 'Warrior\'s Stone',
        job  = xi.job.WAR,
        item = FORGOTTEN_ANY,
        reqs = ARCH_CITIES,
        augs =
        {
            {   1,   0,   1, 2, 3, 4, 5, 6, 7, 8, 9 },          -- HP: 1-10
            {  49, nil,   0, 0, 1, 1, 2, 2, 3, 3, 4 },          -- Haste: 1~5%
            { 363, nil, nil, 0, 0, 1, 1, 2, 2, 3, 3 },          -- Chance of successful block: 1~4
        },
    },

    [15478] =
    {
        name = 'Melee Cape',
        job  = xi.job.MNK,
        item = FORGOTTEN_ANY,
        reqs = ARCH_CITIES,
        augs =
        {
            {   1,   0,   1, 2, 3, 4, 5, 6, 7, 8, 9 },          -- HP: 1-10
            {  68, nil,   0, 0, 1, 2, 3, 4, 5, 6, 7 },          -- Acc/Atk: 1~8
            { 145, nil, nil, 0, 0, 0, 0, 1, 1, 1, 2 },          -- Counter: 1~3
        },
    },

    [15872] =
    {
        name = 'Cleric\'s Belt',
        job  = xi.job.WHM,
        item = FORGOTTEN_ANY,
        reqs = ARCH_CITIES,
        augs =
        {
            {   9,   0,   1,   2,   3, 4, 5, 6, 7, 8, 9 },      -- MP: 1-10
            { 134, nil, nil, nil, nil, 0, 0, 1, 1, 2, 2 },      -- Magic Defense Bonus: 1~3
            { 329, nil,   0,   0,   1, 1, 2, 2, 3, 3, 4 },      -- Cure Potency: 1~5
        },
    },

    [15874] =
    {
        name = 'Sorcerer\'s Belt',
        job  = xi.job.BLM,
        item = FORGOTTEN_ANY,
        reqs = ARCH_CITIES,
        augs =
        {
            {   9,   0,   1, 2, 3, 4, 5, 6, 7, 8, 9 },          -- MP: 1-10
            { 292, nil,   0, 0, 1, 2, 3, 3, 4, 5, 5 },          -- Elemental Magic Skill: 1~6
            { 133, nil, nil, 0, 0, 0, 0, 1, 1, 1, 2 },          -- Magic Attack Bonus: 1~3
        },
    },

    [15873] =
    {
        name = 'Duelist\'s Belt',
        job  = xi.job.RDM,
        item = FORGOTTEN_ANY,
        reqs = ARCH_CITIES,
        augs =
        {
            {    9,   0, 1, 2, 3, 4, 5, 6, 7, 8, 9 },           -- MP: 1-10
            {  291,   0, 0, 1, 1, 2, 2, 3, 3, 4, 5 },           -- Enfeebling Magic Skill: 1~6
            { 1251, nil, 0, 0, 1, 1, 2, 2, 3, 3, 4 },           -- Enfeebling Magic Duration: 1~5
        },
    },


    [15480] =
    {
        name = 'Assassin\'s Cape',
        job  = xi.job.THF,
        item = FORGOTTEN_ANY,
        reqs = ARCH_CITIES,
        augs =
        {
            {   1,   0,   1,   2,   3, 4, 5, 6, 7, 8, 9 },      -- HP: 1-10
            {  31,   0,   1,   2,   3, 4, 5, 6, 7, 8, 8 },      -- Evasion: 1~9
            { 328, nil, nil, nil, nil, 0, 0, 0, 0, 0, 1 },      -- Critical Hit Damage: 1~2
        },
    },

    [15481] =
    {
        name = 'Valor Cape',
        job  = xi.job.PLD,
        item = FORGOTTEN_ANY,
        reqs = ARCH_CITIES,
        augs =
        {
            {   1,   0,   1,   2,   3, 4, 5, 6, 7, 8, 9 },      -- HP: 1-10
            { 287,   0,   0,   1,   2, 2, 3, 4, 5, 6, 7 },      -- Parry Skill: 1~8
            { 363, nil, nil, nil, nil, 0, 0, 0, 0, 0, 1 },      -- Chance of successful block: 1~2
        },
    },

    [15479] =
    {
        name = 'Abyss Cape',
        job  = xi.job.DRK,
        item = FORGOTTEN_ANY,
        reqs = ARCH_CITIES,
        augs =
        {
            {   1,   0, 1, 2, 3, 4, 5, 6, 7, 8, 9 },            -- HP: 1-10
            { 516, nil, 0, 0, 1, 1, 2, 2, 3, 3, 4 },            -- INT: 1~5
            {  25,   0, 0, 1, 1, 2, 2, 3, 4, 5, 6 },            -- Attack: 1~7
        },
    },

    [15875] =
    {
        name = 'Monster Belt',
        job  = xi.job.BST,
        item = FORGOTTEN_ANY,
        reqs = ARCH_CITIES,
        augs =
        {
            {  17,   0, 1, 2, 3, 4, 5, 6, 7, 8, 9 },            -- HP/MP: 1-10
            {  49, nil, 0, 0, 1, 1, 2, 2, 3, 3, 4 },            -- Haste: 1~5%
            { 124,   0, 0, 1, 1, 2, 3, 4, 5, 6, 7 },            -- Pet: Acc R.Acc Atk. R.Atk: 1~8
        },
    },

    [15482] =
    {
        name = 'Bard\'s Cape',
        job  = xi.job.BRD,
        item = FORGOTTEN_ANY,
        reqs = ARCH_CITIES,
        augs =
        {
            {  17,   0,   1,   2, 3, 4, 5, 6, 7, 8, 9 },        -- HP/MP: 1-10
            { 142, nil,   0,   0, 0, 0, 1, 1, 2, 3, 4 },        -- Store TP: 1~5
            {  25, nil, nil, nil, 0, 0, 0, 1, 1, 1, 2 },        -- Magic Accuracy: 1~3
        },
    },

    [15876] =
    {
        name = 'Scout\'s Belt',
        job  = xi.job.RNG,
        item = FORGOTTEN_ANY,
        reqs = ARCH_CITIES,
        augs =
        {
            {   1,   0,   1,   2,   3, 4, 5, 6, 7, 8, 9 },      -- HP: 1-10
            { 142, nil, nil, nil, nil, 0, 0, 0, 1, 1, 2 },      -- Store TP: 1~3
            {  40, nil, nil,   0,   0, 0, 0, 1, 1, 2, 2 },      -- Enmity: 1~3
        },
    },

    [15484] =
    {
        name = 'Summoner\'s Cape',
        job  = xi.job.SMN,
        item = FORGOTTEN_ANY,
        reqs = ARCH_CITIES,
        augs =
        {
            {   9,   0,   1,   2,   3, 4, 5, 6, 7, 8, 9 },      -- MP: 1-10
            { 108, nil, nil,   0,   0, 0, 1, 2, 3, 4, 4 },      -- Pet: Mag.Acc. Mag.Atk.Bns.: 1~5
            { 320, nil, nil, nil, nil, 0, 0, 0, 0, 0, 1 },      -- Blood Pact ability delay: 1~2
        },
    },

    [15879] =
    {
        name = 'Sao. Koshi-Ate',
        job  = xi.job.SAM,
        item = FORGOTTEN_ANY,
        reqs = ARCH_CITIES,
        augs =
        {
            {   1,   0, 1, 2, 3, 4, 5, 6, 7, 8, 9 },            -- HP: 1-10
            { 142, nil, 0, 0, 1, 1, 2, 2, 3, 3, 4 },            -- Store TP: 1~5
            {  29,   0, 0, 1, 1, 2, 2, 3, 3, 4, 4 },            -- Ranged Attack: 1~5
        },
    },

    [15877] =
    {
        name = 'Koga Sarashi',
        job  = xi.job.NIN,
        item = FORGOTTEN_ANY,
        reqs = ARCH_CITIES,
        augs =
        {
            {   1,   0,   1,   2,   3, 4, 5, 6, 7, 8, 9 },      -- HP: 1-10
            { 129,   0,   1,   2,   3, 3, 4, 5, 6, 7, 8 },      -- Accuracy/Ranged Accuracy: 1~9
            { 251, nil, nil, nil, nil, 0, 0, 0, 0, 0, 1 },      -- Daken: 1~2
        },
    },

    [15878] =
    {
        name = 'Wyrm Belt',
        job  = xi.job.DRG,
        item = FORGOTTEN_ANY,
        reqs = ARCH_CITIES,
        augs =
        {
            {  17,   0,   1,   2, 3, 4, 5, 6, 7, 8, 9 },        -- HP/MP: 1-10
            {  49, nil,   0,   0, 0, 1, 2, 2, 3, 3, 4 },        -- Haste: 1~5%
            { 112, nil, nil, nil, 0, 0, 0, 1, 1, 2, 2 },        -- Pet: Damage Taken: 1~3
        },
    },

    [16244] =
    {
        name = 'Mirage Mantle',
        job  = xi.job.BLU,
        item = FORGOTTEN_ANY,
        reqs = ARCH_CITIES,
        augs =
        {
            {  17,   0, 1, 2, 3, 4, 5, 6, 7, 8, 9 },            -- HP/MP: 1-10
            { 299,   0, 1, 1, 2, 2, 3, 3, 4, 5, 6 },            -- Blue Magic Skill: 1~7
            { 142, nil, 0, 0, 1, 1, 2, 2, 3, 3, 4 },            -- Store TP: 1~5
        },
    },

    [15920] =
    {
        name = 'Commodore Belt',
        job  = xi.job.COR,
        item = FORGOTTEN_ANY,
        reqs = ARCH_CITIES,
        augs =
        {
            {  17,   0,   1,   2,   3, 4, 5, 6, 7, 8, 9 },      -- HP/MP: 1-10
            { 515, nil, nil,   0,   0, 0, 1, 1, 2, 2, 3 },      -- AGI: 1~4
            { 133, nil, nil, nil, nil, 0, 0, 1, 1, 2, 2 },      -- Magic Attack Bonus: 1~3
        },
    },

    [16245] =
    {
        name = 'Pantin Cape',
        job  = xi.job.PUP,
        item = FORGOTTEN_ANY,
        reqs = ARCH_CITIES,
        augs =
        {
            {  17,   0, 1, 2, 3, 4, 5, 6, 7, 8, 9 },            -- HP/MP: 1-10
            {  31,   0, 0, 1, 1, 2, 2, 3, 4, 5, 6 },            -- Evasion: 1~7
            { 109, nil, 0, 0, 1, 1, 2, 2, 3, 3, 4 },            -- Dbl.Atk. Crit.hit rate: 1~5
        },
    },

    [16248] =
    {
        name = 'Etoile Cape',
        job  = xi.job.DNC,
        item = FORGOTTEN_ANY,
        reqs = ARCH_CITIES,
        augs =
        {
            {   1,   0,   1,   2, 3, 4, 5, 6, 7, 8, 9 },        -- HP: 1-10
            {  25,   0,   1,   2, 3, 4, 5, 5, 6, 7, 8 },        -- Attack: 1~9
            { 332, nil, nil, nil, 0, 0, 0, 1, 1, 1, 2 },        -- Skillchain Damage: 1~3
        },
    },

    [15925] =
    {
        name = 'Argute Belt',
        job  = xi.job.SCH,
        item = FORGOTTEN_ANY,
        reqs = ARCH_CITIES,
        augs =
        {
            {    9,   0,   1, 2, 3, 4, 5, 6, 7, 8, 9 },         -- MP: 1-10
            {   80, nil, nil, 0, 0, 1, 1, 2, 2, 3, 3 },         -- Magic Accuracy/Magic Damage: 1~4
            { 1248, nil,   0, 0, 1, 1, 2, 2, 3, 3, 4 },         -- Enhancing Magic Duration: 1~5
        },
    },

    [26323] =
    {
        name = 'Bagua Sash',
        job  = xi.job.GEO,
        item = FORGOTTEN_ANY,
        reqs = ARCH_CITIES,
        augs =
        {
            {   9,   0,   1,   2,   3, 4, 5, 6, 7, 8, 9 },      -- MP: 1-10
            { 141,   0,   1,   2,   3, 3, 4, 5, 6, 7, 7 },      -- Conserve MP: 1~8
            { 110, nil, nil, nil, nil, 0, 0, 0, 0, 0, 1 },      -- Pet: Regen: 1~2
        },
    },

    [26240] =
    {
        name = 'Futhark Cape',
        job  = xi.job.RUN,
        item = FORGOTTEN_ANY,
        reqs = ARCH_CITIES,
        augs =
        {
            {   17,   0,   1,   2,   3, 4, 5, 6, 7, 8, 9 },     -- HP/MP: 1-10
            {  134, nil, nil,   0,   0, 0, 0, 1, 1, 2, 2 },     -- Magic Defense Bonus: 1~3
            { 1472, nil, nil, nil, nil, 0, 0, 0, 1, 1, 2 },     -- Parry Rate: 1~3
        },
    },
}

cexi.augments.dynamis_slot =
{
    [FORGOTTEN_THOUGHT] = 1,
    [FORGOTTEN_HOPE]    = 2,
    [FORGOTTEN_TOUCH]   = 3,
    [FORGOTTEN_JOURNEY] = 4,
    [FORGOTTEN_STEP]    = 5,
    [FORGOTTEN_ANY]     = 6,
}

cexi.augments.dynamis_jobs = {}

for itemID, itemInfo in pairs(cexi.augments.dynamis_augments) do
    local jobName = xi.jobNames[itemInfo.job][1]
    local slot    = cexi.augments.dynamis_slot[itemInfo.item]

    cexi.augments.dynamis_jobs[jobName] = cexi.augments.dynamis_jobs[jobName] or {}
    table.insert(cexi.augments.dynamis_jobs[jobName], { itemInfo.name, itemID, slot })
end

for _, jobItems in pairs(cexi.augments.dynamis_jobs) do
    table.sort(jobItems, function(a, b)
        return a[3] < b[3]
    end)
end

cexi.augments.dynamisGetTier = function(itemID, augs)
    for augTier = 1, 10 do
        local pass = true

        for slot = 1, 3 do
            if augs[slot][1] == nil then
                pass = false
            else
                local augID  = augs[slot][1]
                local augVal = augs[slot][2]

                if
                    cexi.augments.dynamis_augments[itemID].augs[slot][1]           ~= augs[slot][1] or
                    cexi.augments.dynamis_augments[itemID].augs[slot][augTier + 1] ~= augs[slot][2]
                then
                    pass = false
                end
            end
        end

        if pass then
            return augTier
        end
    end

    return 0
end

return m
