-----------------------------------
-- CW Armor Augments
-----------------------------------
local m = Module:new("base_augments_cw_armor")

cexi                           = cexi or {}
cexi.augments                  = cexi.augments or {}
cexi.augments.crystal_warrior =
{
    -----------------------------------
    -- Warrior(Sakpata Set)
    -----------------------------------
    [23757] =
    {
        name = "Sakpata's Helm",
        job  = xi.job.WAR,
        slot = "Head",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [23764] =
    {
        name = "Sakpata's Plate",
        job  = xi.job.WAR,
        slot = "Body",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [23771] =
    {
        name = "Sakpata's Gauntlets",
        job  = xi.job.WAR,
        slot = "Hands",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [23778] =
    {
        name = "Sakpata's Cuisses",
        job  = xi.job.WAR,
        slot = "Legs",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [23785] =
    {
        name = "Sakpata's Leggings",
        job  = xi.job.WAR,
        slot = "Feet",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },

    -----------------------------------
    -- Monk(Naga Set)
    -----------------------------------
    [26793] =
    {
        name = "Naga Somen",
        job  = xi.job.MNK,
        slot = "Head",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [26949] =
    {
        name = "Naga Samue",
        job  = xi.job.MNK,
        slot = "Body",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [27099] =
    {
        name = "Naga Tekko",
        job  = xi.job.MNK,
        slot = "Hands",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [27284] =
    {
        name = "Naga Hakama",
        job  = xi.job.MNK,
        slot = "Legs",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [27459] =
    {
        name = "Naga Kyahan",
        job  = xi.job.MNK,
        slot = "Feet",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },

    -----------------------------------
    -- WhiteMage(Bunzi Set)
    -----------------------------------
    [23760] =
    {
        name = "Bunzi's Hat",
        job  = xi.job.WHM,
        slot = "Head",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [23767] =
    {
        name = "Bunzi's Robe",
        job  = xi.job.WHM,
        slot = "Body",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [23774] =
    {
        name = "Bunzi's Gloves",
        job  = xi.job.WHM,
        slot = "Hands",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [23781] =
    {
        name = "Bunzi's Pants",
        job  = xi.job.WHM,
        slot = "Legs",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [23788] =
    {
        name = "Bunzi's Sabots",
        job  = xi.job.WHM,
        slot = "Feet",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },

    -----------------------------------
    -- BlackMage(Vanya Set)
    -----------------------------------
    [26797] =
    {
        name = "Vanya Hood",
        job  = xi.job.BLM,
        slot = "Head",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [26953] =
    {
        name = "Vanya Robe",
        job  = xi.job.BLM,
        slot = "Body",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [27103] =
    {
        name = "Vanya Cuffs",
        job  = xi.job.BLM,
        slot = "Hands",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [27288] =
    {
        name = "Vanya Slops",
        job  = xi.job.BLM,
        slot = "Legs",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [27463] =
    {
        name = "Vanya Clogs",
        job  = xi.job.BLM,
        slot = "Feet",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },

    -----------------------------------
    -- RedMage(Malignance Set)
    -----------------------------------
    [23732] =
    {
        name = "Malignance Chapeau",
        job  = xi.job.RDM,
        slot = "Head",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [23733] =
    {
        name = "Malignance Tabard",
        job  = xi.job.RDM,
        slot = "Body",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [23734] =
    {
        name = "Malignance Gloves",
        job  = xi.job.RDM,
        slot = "Hands",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },

    [23735] =
    {
        name = "Malignance Tights",
        job  = xi.job.RDM,
        slot = "Legs",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [23736] =
    {
        name = "Malignance Boots",
        job  = xi.job.RDM,
        slot = "Feet",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },

    -----------------------------------
    -- Thief(Adhemar Set)
    -----------------------------------
    [25613] =
    {
        name = "Adhemar Bonnet",
        job  = xi.job.THF,
        slot = "Head",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [25686] =
    {
        name = "Adhemar Jacket",
        job  = xi.job.THF,
        slot = "Body",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [27117] =
    {
        name = "Adhemar Wristbands",
        job  = xi.job.THF,
        slot = "Hands",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [27302] =
    {
        name = "Adhemar Kecks",
        job  = xi.job.THF,
        slot = "Legs",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [27473] =
    {
        name = "Adhemar Gamashes",
        job  = xi.job.THF,
        slot = "Feet",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },

    -----------------------------------
    -- Paladin (Founder Set)
    -----------------------------------
    [27764] =
    {
        name = "Founder's Corona",
        job  = xi.job.PLD,
        slot = "Head",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [27910] =
    {
        name = "Founder's Breastplate",
        job  = xi.job.PLD,
        slot = "Body",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [28049] =
    {
        name = "Founder's Gauntlets",
        job  = xi.job.PLD,
        slot = "Hands",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [28191] =
    {
        name = "Founder's Hose",
        job  = xi.job.PLD,
        slot = "Legs",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [28330] =
    {
        name = "Founder's Greaves",
        job  = xi.job.PLD,
        slot = "Feet",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },

    -----------------------------------
    -- Dark Knight (Gleti Set)
    -----------------------------------
    [23756] =
    {
        name = "Gleti's Mask",
        job  = xi.job.DRK,
        slot = "Head",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [23763] =
    {
        name = "Gleti's Cuirass",
        job  = xi.job.DRK,
        slot = "Body",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [23770] =
    {
        name = "Gleti's Gauntlets",
        job  = xi.job.DRK,
        slot = "Hands",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [23777] =
    {
        name = "Gleti's Breeches",
        job  = xi.job.DRK,
        slot = "Legs",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [23784] =
    {
        name = "Gleti's Boots",
        job  = xi.job.DRK,
        slot = "Feet",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },

    -----------------------------------
    -- Beastmaster (Valorous Set)
    -----------------------------------
    [25641] =
    {
        name = "Valorous Mask",
        job  = xi.job.BST,
        slot = "Head",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [25717] =
    {
        name = "Valorous Mail",
        job  = xi.job.BST,
        slot = "Body",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [27139] =
    {
        name = "Valorous Mitts",
        job  = xi.job.BST,
        slot = "Hands",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [25841] =
    {
        name = "Valorous Hose",
        job  = xi.job.BST,
        slot = "Legs",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [27495] =
    {
        name = "Valorous Greaves",
        job  = xi.job.BST,
        slot = "Feet",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },

    -----------------------------------
    -- Bard (Pursuer Set)
    -----------------------------------
    [26795] =
    {
        name = "Pursuer's Beret",
        job  = xi.job.BRD,
        slot = "Head",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [26951] =
    {
        name = "Pursuer's Doublet",
        job  = xi.job.BRD,
        slot = "Body",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [27101] =
    {
        name = "Pursuer's Cuffs",
        job  = xi.job.BRD,
        slot = "Hands",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [27286] =
    {
        name = "Pursuer's Pants",
        job  = xi.job.BRD,
        slot = "Legs",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [27461] =
    {
        name = "Pursuer's Gaiters",
        job  = xi.job.BRD,
        slot = "Feet",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },

    -----------------------------------
    -- Ranger (Herculean Set)
    -----------------------------------
    [25642] =
    {
        name = "Herculean Helm",
        job  = xi.job.RNG,
        slot = "Head",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [25718] =
    {
        name = "Herculean Vest",
        job  = xi.job.RNG,
        slot = "Body",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [27140] =
    {
        name = "Herculean Gloves",
        job  = xi.job.RNG,
        slot = "Hands",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [25842] =
    {
        name = "Herculean Trousers",
        job  = xi.job.RNG,
        slot = "Legs",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [27496] =
    {
        name = "Herculean Boots",
        job  = xi.job.RNG,
        slot = "Feet",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },

    -----------------------------------
    -- Summoner (Chironic Set)
    -----------------------------------
    [25644] =
    {
        name = "Chironic Hat",
        job  = xi.job.SMN,
        slot = "Head",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [25720] =
    {
        name = "Chironic Doublet",
        job  = xi.job.SMN,
        slot = "Body",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [27142] =
    {
        name = "Chironic Gloves",
        job  = xi.job.SMN,
        slot = "Hands",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [25844] =
    {
        name = "Chironic Hose",
        job  = xi.job.SMN,
        slot = "Legs",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [27498] =
    {
        name = "Chironic Slippers",
        job  = xi.job.SMN,
        slot = "Feet",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },

    -----------------------------------
    -- Samurai (Ryuo Set)
    -----------------------------------
    [25611] =
    {
        name = "Ryuo Somen",
        job  = xi.job.SAM,
        slot = "Head",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [25684] =
    {
        name = "Ryuo Domaru",
        job  = xi.job.SAM,
        slot = "Body",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [27115] =
    {
        name = "Ryuo Tekko",
        job  = xi.job.SAM,
        slot = "Hands",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [27300] =
    {
        name = "Ryuo Hakama",
        job  = xi.job.SAM,
        slot = "Legs",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [27471] =
    {
        name = "Ryuo Sune-Ate",
        job  = xi.job.SAM,
        slot = "Feet",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },

    -----------------------------------
    -- Ninja (Mpaca Set)
    -----------------------------------
    [23758] =
    {
        name = "Mpaca's Cap",
        job  = xi.job.NIN,
        slot = "Head",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [23765] =
    {
        name = "Mpaca's Doublet",
        job  = xi.job.NIN,
        slot = "Body",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [23772] =
    {
        name = "Mpaca's Gloves ",
        job  = xi.job.NIN,
        slot = "Hands",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [23779] =
    {
        name = "Mpaca's Hose",
        job  = xi.job.NIN,
        slot = "Legs",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [23786] =
    {
        name = "Mpaca's Boots",
        job  = xi.job.NIN,
        slot = "Feet",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },

    -----------------------------------
    -- Dragoon(Odyssean Set)
    -----------------------------------
    [25640] =
    {
        name = "Odyssean Helm",
        job  = xi.job.DRG,
        slot = "Head",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [25716] =
    {
        name = "Odyssean Chestplate",
        job  = xi.job.DRG,
        slot = "Body",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [27138] =
    {
        name = "Odyssean Gauntlets",
        job  = xi.job.DRG,
        slot = "Hands",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [25840] =
    {
        name = "Odyssean Cuisses",
        job  = xi.job.DRG,
        slot = "Legs",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [27494] =
    {
        name = "Odyssean Greaves",
        job  = xi.job.DRG,
        slot = "Feet",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },

    -----------------------------------
    -- Blue Mage (Agwu Set)
    -----------------------------------
    [23759] =
    {
        name = "Agwu's Cap",
        job  = xi.job.BLU,
        slot = "Head",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [23766] =
    {
        name = "Agwu's Robe",
        job  = xi.job.BLU,
        slot = "Body",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [23773] =
    {
        name = "Agwu's Gages",
        job  = xi.job.BLU,
        slot = "Hands",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [23780] =
    {
        name = "Agwu's Slops",
        job  = xi.job.BLU,
        slot = "Legs",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },[23787] =
    {
        name = "Agwu's Pigaches",
        job  = xi.job.BLU,
        slot = "Feet",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },

    -----------------------------------
    -- Corsair (Ikenga Set)
    -----------------------------------
    [23755] =
    {
        name = "Ikenga's Hat",
        job  = xi.job.COR,
        slot = "Head",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [23762] =
    {
        name = "Ikenga's Vest",
        job  = xi.job.COR,
        slot = "Body",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [23769] =
    {
        name = "Ikenga's Gloves",
        job  = xi.job.COR,
        slot = "Hands",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [23776] =
    {
        name = "Ikenga's Trousers",
        job  = xi.job.COR,
        slot = "Legs",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },[23783] =
    {
        name = "Ikenga's Clogs",
        job  = xi.job.COR,
        slot = "Feet",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },

    -----------------------------------
    -- Puppetmaster (Thurandaut Set)
    -----------------------------------
    [27784] =
    {
        name = "Thurandaut Chapeau",
        job  = xi.job.PUP,
        slot = "Head",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [27924] =
    {
        name = "Thurandaut Tabard",
        job  = xi.job.PUP,
        slot = "Body",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [28064] =
    {
        name = "Thurandaut Gloves",
        job  = xi.job.PUP,
        slot = "Hands",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [28204] =
    {
        name = "Thurandaut Tights",
        job  = xi.job.PUP,
        slot = "Legs",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [28344] =
    {
        name = "Thurandaut Boots",
        job  = xi.job.PUP,
        slot = "Feet",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },

    -----------------------------------
    -- Dancer (Rawhide Set)
    -----------------------------------
    [26794] =
    {
        name = "Rawhide Mask",
        job  = xi.job.DNC,
        slot = "Head",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [26950] =
    {
        name = "Rawhide Vest",
        job  = xi.job.DNC,
        slot = "Body",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [27100] =
    {
        name = "Rawhide Gloves",
        job  = xi.job.DNC,
        slot = "Hands",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [27285] =
    {
        name = "Rawhide Trousers",
        job  = xi.job.DNC,
        slot = "Legs",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [27460] =
    {
        name = "Rawhide Boots",
        job  = xi.job.DNC,
        slot = "Feet",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },

    -----------------------------------
    -- Scholar (Merlinic Set)
    -----------------------------------
    [25643] =
    {
        name = "Merlinic Hood",
        job  = xi.job.SCH,
        slot = "Head",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [25719] =
    {
        name = "Merlinic Jubbah",
        job  = xi.job.SCH,
        slot = "Body",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [27141] =
    {
        name = "Merlinic Dastanas",
        job  = xi.job.SCH,
        slot = "Hands",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [25843] =
    {
        name = "Merlinic Shalwar",
        job  = xi.job.SCH,
        slot = "Legs",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [27497] =
    {
        name = "Merlinic Crackows",
        job  = xi.job.SCH,
        slot = "Feet",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },

    -----------------------------------
    -- Geomancer (Amalric Set)
    -----------------------------------
    [25615] =
    {
        name = "Amalric Coif",
        job  = xi.job.GEO,
        slot = "Head",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [25688] =
    {
        name = "Amalric Doublet",
        job  = xi.job.GEO,
        slot = "Body",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },

    [27119] =
    {
        name = "Amalric Gages",
        job  = xi.job.GEO,
        slot = "Hands",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },

    [27304] =
    {
        name = "Amalric Slops",
        job  = xi.job.GEO,
        slot = "Legs",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [27475] =
    {
        name = "Amalric Nails",
        job  = xi.job.GEO,
        slot = "Feet",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },

    -----------------------------------
    -- Rune Fencer (Eschite Set)
    -----------------------------------
    [26791] =
    {
        name = "Eschite Helm",
        job  = xi.job.RUN,
        slot = "Head",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },

    [26947] =
    {
        name = "Eschite Breastplate",
        job  = xi.job.RUN,
        slot = "Body",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },

    [27097] =
    {
        name = "Eschite Gauntlets",
        job  = xi.job.RUN,
        slot = "Hands",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },

    [27282] =
    {
        name = "Eschite Cuisses",
        job  = xi.job.RUN,
        slot = "Legs",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
    [27457] =
    {
        name = "Eschite Greaves",
        job  = xi.job.RUN,
        slot = "Feet",
        augs =
        {
            {   1,  1 }, -- HP +1
        },
    },
}

local slots =
{
    ["Head"]  = 1,
    ["Body"]  = 2,
    ["Hands"] = 3,
    ["Legs"]  = 4,
    ["Feet"]  = 5,
}

cexi.augments.cw_jobs = {}

for itemID, itemInfo in pairs(cexi.augments.crystal_warrior) do
    local jobName = xi.jobNames[itemInfo.job][1]
    local slot    = slots[itemInfo.slot]

    cexi.augments.cw_jobs[jobName] = cexi.augments.cw_jobs[jobName] or {}
    table.insert(cexi.augments.cw_jobs[jobName], { itemInfo.name, itemID, slot })
end

for _, jobItems in pairs(cexi.augments.cw_jobs) do
    table.sort(jobItems, function(a, b)
        return a[3] < b[3]
    end)
end

cexi.augments.cwGetTier = function(itemID, itemAug)
    local tier    = 0
    local augInfo = cexi.augments.campaign_augments[itemID].augs

    for augTier = 1, 3 do
        if
            itemAug[augTier] ~= nil and
            augInfo[augTier][1] == itemAug[augTier][1] and
            augInfo[augTier][2] == itemAug[augTier][2]
        then
            tier = augTier
        end
    end

    return tier
end

cexi.augments.cwGiveTier = function(player, itemID, itemTier)
    local augs = cexi.augments.crystal_warrior[itemID].augs

    if itemTier == 1 then
        player:addItem(itemID, 1, augs[1][1], augs[1][2])
    elseif itemTier == 2 then
        player:addItem(itemID, 1, augs[1][1], augs[1][2], augs[2][1], augs[2][2])
    elseif itemTier == 3 then
        player:addItem(itemID, 1, augs[1][1], augs[1][2], augs[2][1], augs[2][2], augs[3][1], augs[3][2])
    end

    player:timer(100, function()
        player:messageSpecial(zones[player:getZoneID()].text.ITEM_OBTAINED, itemID)
    end)
end

return m
