-----------------------------------
-- Campaign Augments
-----------------------------------
local m = Module:new("base_augments_arena_augments")

cexi          = cexi or {}
cexi.augments = cexi.augments or {}

local slot =
{
    HEAD  = 1,
    BODY  = 2,
    HANDS = 3,
    LEGS  = 4,
    FEET  = 5,
}

local sets =
{
    SHINOBI    = "Shinobi",
    MYTHRIL    = "Mythril",
    CLOAK      = "W.Cloak",
    RAPTOR     = "Raptor",
    SHINOBI_P1 = "Shinobi+1",
    MYTHRIL_P1 = "Mythril+1",
    CLOAK_P1   = "W.Cloak+1",
    RAPTOR_P1  = "Raptor+1",
}

cexi.augments.arena_sets =
{
    { "Shinobi Attire",      sets.SHINOBI    },
    { "Mythril Plate Set",   sets.MYTHRIL    },
    { "White Cloak Set",     sets.CLOAK      },
    { "Raptor Attire",       sets.RAPTOR     },
    { "Shinobi+1 Attire",    sets.SHINOBI_P1 },
    { "Mythril+1 Plate Set", sets.MYTHRIL_P1 },
    { "White Cloak+1 Set",   sets.CLOAK_P1   },
    { "Dino Attire",         sets.RAPTOR_P1  },
}

cexi.augments.arena_augments =
{
    [12460] =
    {
        name = "Shinobi Hachigane",
        set  = sets.SHINOBI,
        slot = slot.HEAD,
        hq   = { 13844, "Shn. Hachigane +1", sets.SHINOBI_P1 },
        augs =
        {
            { 1,  4, 25, 5, 145, 0         }, -- HP+5,  Attack+6, Counter+1
            { 1,  9, 25, 6, 145, 1         }, -- HP+10, Attack+7, Counter+2
            { 1, 14, 25, 7,  49, 1, 145, 2 }, -- HP+15, Attack+8, Haste+2%, Counter+3
        },
    },
    [12588] =
    {
        name = "Shinobi Gi",
        set  = sets.SHINOBI,
        slot = slot.BODY,
        hq   = { 13733, "Shinobi Gi +1", sets.SHINOBI_P1 },
        augs =
        {
            { 1,  9, 25, 5, 23, 5        }, -- HP+10, Attack+6, Accuracy+6,
            { 1, 19, 25, 6, 23, 6        }, -- HP+20, Attack+7, Accuracy+7,
            { 1, 29, 25, 7, 23, 7, 55, 1 }, -- HP+30, Attack+8, Accuracy+8, Magic. dmg. taken-2%
        },
    },
    [12716] =
    {
        name = "Shinobi Tekko",
        set  = sets.SHINOBI,
        slot = slot.HANDS,
        hq   = { 13955, "Shinobi Tekko +1", sets.SHINOBI_P1 },
        augs =
        {
            { 1,  4, 25, 5, 23, 5         }, -- HP+5,  Attack+6, Accuracy+6
            { 1,  9, 25, 6, 23, 6         }, -- HP+10, Attack+7, Accuracy+7
            { 1, 14, 25, 7, 23, 7, 142, 1 }, -- HP+15, Attack+8, Accuracy+8, Store TP +2
        },
    },
    [12844] =
    {
        name = "Shinobi Hakama",
        set  = sets.SHINOBI,
        slot = slot.LEGS,
        hq   = { 12925, "Shn. Hakama +1", sets.SHINOBI_P1 },
        augs =
        {
            { 1,  9, 25, 5, 145, 0         }, -- HP+10, Attack+6, Counter+1
            { 1, 14, 25, 6, 145, 1         }, -- HP+15, Attack+7, Counter+2
            { 1, 19, 25, 7,  49, 1, 145, 2 }, -- HP+20, Attack+8, Haste+2%, Counter+3
        },
    },
    [12972] =
    {
        name = "Shinobi Kyahan",
        set  = sets.SHINOBI,
        slot = slot.FEET,
        hq   = { 14082, "Shn. Kyahan +1", sets.SHINOBI_P1 },
        augs =
        {
            { 1,  4, 23, 5, 55, 0         }, -- HP+5,  Accuracy+6, Magic. dmg. taken-1%
            { 1,  9, 23, 6, 55, 1         }, -- HP+10, Accuracy+7, Magic. dmg. taken-2%
            { 1, 14, 23, 7,  49, 1, 55, 2 }, -- HP+15, Accuracy+8, Haste+2%, Magic. dmg. taken-3%
        },
    },
    [12611] =
    {
        name = "White Cloak",
        set  = sets.CLOAK,
        slot = slot.BODY,
        hq   = { 12651, "White Cloak +1", sets.CLOAK_P1 },
        augs =
        {
            { 9,  9, 513, 3, 52, 0        }, -- MP+10, DEX+4, MP recovered while healing +1
            { 9, 19, 513, 4, 52, 1        }, -- MP+20, DEX+5, MP recovered while healing +2
            { 9, 29, 513, 5, 52, 2, 97, 5 }, -- MP+30, DEX+6, MP recovered while healing +3, Pet: Attack+6 Rng.Atk.+6
        },
    },
    [12739] =
    {
        name = "Black Mitts",
        set  = sets.CLOAK,
        slot = slot.HANDS,
        hq   = { 12794, "Mage's Mitts", sets.CLOAK_P1 },
        augs =
        {
            { 9,  4, 515, 2, 97, 3        }, -- MP+5,  AGI+3, Pet: Attack+4 Rng.Atk.+4
            { 9,  9, 515, 3, 97, 4        }, -- MP+10, AGI+4, Pet: Attack+5 Rng.Atk.+5
            { 9, 14, 515, 4, 35, 1, 97, 5 }, -- MP+15, AGI+5, Mag.Acc.+2, Pet: Attack+6 Rng.Atk.+6
        },
    },
    [12867] =
    {
        name = "White Slacks",
        set  = sets.CLOAK,
        slot = slot.LEGS,
        hq   = { 12926, "White Slacks +1", sets.CLOAK_P1 },
        augs =
        {
            { 9,  9, 515, 2, 49, 0         }, -- MP+10, AGI+3, Haste+1%
            { 9, 14, 515, 3, 49, 1         }, -- MP+15, AGI+4, Haste+2%
            { 9, 19, 515, 4, 49, 2, 137, 0 }, -- MP+20, AGI+5, Haste+3%, Regen +1
        },
    },
    [12995] =
    {
        name = "Moccasins",
        set  = sets.CLOAK,
        slot = slot.FEET,
        hq   = { 13050, "Moccasins +1", sets.CLOAK_P1 },
        augs =
        {
            { 9,  4, 513, 1, 40, 0        }, -- MP+5,  DEX+2, Enmity-1
            { 9,  9, 513, 2, 40, 1        }, -- MP+10, DEX+3, Enmity-2
            { 9, 14, 513, 3, 35, 1, 40, 2 }, -- MP+15, DEX+4, Mag.Acc.+2, Enmity-3
        },
    },
    [12417] =
    {
        name = "Mythril Sallet",
        set  = sets.MYTHRIL,
        slot = slot.HEAD,
        hq   = { 13847, "Mythril Sallet +1", sets.CLOAK_P1 },
        augs =
        {
            { 9,  4, 23, 5, 52, 0         }, -- MP+5,  Accuracy+6, MP recovered while healing +1
            { 9,  9, 23, 6, 52, 1         }, -- MP+10, Accuracy+7, MP recovered while healing +2
            { 9, 14, 23, 7, 137, 0, 52, 2 }, -- MP+15, Accuracy+8, Regen +1, MP recovered while healing +3
        },
    },
    [12545] =
    {
        name = "Mtl. Breastplate",
        set  = sets.MYTHRIL,
        slot = slot.BODY,
        hq   = { 13737, "Mtl. Breastplate +1", sets.MYTHRIL_P1 },
        augs =
        {
            { 9,  9, 25, 5, 23, 5        }, -- MP+10, Attack+6, Accuracy+6
            { 9, 19, 25, 6, 23, 6        }, -- MP+20, Attack+7, Accuracy+7
            { 9, 29, 25, 7, 23, 7, 54, 1 }, -- MP+30, Attack+8, Accuracy+8, Phys. dmg. taken -2%
        }
    },
    [12673] =
    {
        name = "Mythril Gauntlets",
        set  = sets.MYTHRIL,
        slot = slot.HANDS,
        hq   = { 13958, "Mythril Gnt. +1", sets.MYTHRIL_P1 },
        augs =
        {
            { 9,  4, 512, 1, 23, 5        }, -- MP+5,  STR+2, Accuracy+6
            { 9,  9, 512, 2, 23, 6        }, -- MP+10, STR+3, Accuracy+7
            { 9, 14, 512, 3, 23, 8, 49, 1 }, -- MP+15, STR+4, Accuracy+8, Haste+2%
        },
    },
    [12801] =
    {
        name = "Mythril Cuisses",
        set  = sets.MYTHRIL,
        slot = slot.LEGS,
        hq   = { 14211, "Mythril Cuisses +1", sets.MYTHRIL_P1 },
        augs =
        {
            { 9,  4, 516, 1, 25, 5         }, -- MP+10, INT+2, Attack+6
            { 9, 14, 516, 2, 25, 6         }, -- MP+15, INT+3, Attack+7
            { 9, 19, 512, 3, 516, 3, 25, 7 }, -- MP+20, STR+4, INT+4, Attack+8
        },
    },
    [12929] =
    {
        name = "Mythril Leggings",
        set  = sets.MYTHRIL,
        slot = slot.FEET,
        hq   = { 14086, "Mtl. Leggings +1", sets.MYTHRIL_P1 },
        augs =
        {
            { 9,  4, 516, 1, 23, 5         }, --  MP+5,  INT+2, Accuracy +6
            { 9,  9, 516, 2, 23, 6         }, --  MP+10, INT+3, Accuracy +7
            { 9, 14, 516, 3, 23, 7, 142, 1 }, --  MP+15, INT+4, Accuracy +8, Store TP +2
        },
    },

    [12444] =
    {
        name = "Raptor Helm",
        set  = sets.RAPTOR,
        slot = slot.HEAD,
        hq   = { 13835, "Dino Helm", sets.RAPTOR_P1 },
        augs =
        {
            { 1,  4, 515, 1, 25, 3         }, -- HP+5,  AGI+2, Attack+3
            { 1,  9, 515, 2, 25, 3         }, -- HP+10, AGI+3, Attack+4
            { 1, 14, 515, 3, 518, 3, 25, 3 }, -- HP+15, AGI+4, CHR+4, Attack+5
        },
    },
    [12572] =
    {
        name = "Raptor Jerkin",
        set  = sets.RAPTOR,
        slot = slot.BODY,
        hq   = { 13727, "Dino Jerkin", sets.RAPTOR_P1 },
        augs =
        {
            { 1,  9, 518, 1, 25, 5         }, -- HP+10, CHR+2, Attack+6
            { 1, 19, 518, 2, 25, 6         }, -- HP+20, CHR+3, Attack+7
            { 1, 29, 513, 3, 518, 3, 25, 7 }, -- HP+30, DEX+4, CHR+4, Attacky+8
        },
    },

    [12700] =
    {
        name = "Raptor Gloves",
        set  = sets.RAPTOR,
        slot = slot.HANDS,
        hq   = { 12795, "Dino Gloves", sets.RAPTOR_P1 },
        augs =
        {
            { 1,  4, 513, 1, 518, 1        }, -- HP+5,  DEX+2, CHR+2
            { 1,  9, 513, 2, 518, 2        }, -- HP+10, DEX+3, CHR+3
            { 1, 14, 513, 3, 518, 3, 97, 4 }, -- HP+15, DEX+4, CHR+4, Pet: Attack+5 Rng.Atk.+5
        }
    },
    [12828] =
    {
        name = "Raptor Trousers",
        set  = sets.RAPTOR,
        slot = slot.LEGS,
        hq   = { 12919, "Dino Trousers", sets.RAPTOR_P1 },
        augs =
        {
            { 1,  9, 515, 1, 23, 2         }, -- HP+10, AGI+2, Accuracy+3
            { 1, 14, 515, 2, 23, 3         }, -- HP+15, AGI+3, Accuracy+4
            { 1, 19, 514, 3, 515, 3, 23, 4 }, -- HP+20, VIT+4, AGI+4, Accuracy+5
        },
    },
    [12956] =
    {
        name = "Raptor Ledelsens",
        set  = sets.RAPTOR,
        slot = slot.FEET,
        hq   = { 13049, "Dino Ledelsens", sets.RAPTOR_P1 },
        augs =
        {
            { 1,  4, 515, 1, 518, 1        }, -- HP+5,  AGI+2, CHR+2
            { 1,  9, 515, 2, 518, 2        }, -- HP+10, AGI+3, CHR+3
            { 1, 14, 515, 3, 518, 3, 49, 1 }, -- HP+15, AGI+4, CHR+4, Haste +2%
        },
    },
}

cexi.augments.arena_info = {}
cexi.augments.arena_hq   = {}

for itemID, itemInfo in pairs(cexi.augments.arena_augments) do
    cexi.augments.arena_info[itemInfo.set] = cexi.augments.arena_info[itemInfo.set] or {}
    table.insert(cexi.augments.arena_info[itemInfo.set], { itemInfo.name, itemID, itemInfo.slot })

    cexi.augments.arena_info[itemInfo.hq[3]] = cexi.augments.arena_info[itemInfo.hq[3]] or {}
    table.insert(cexi.augments.arena_info[itemInfo.hq[3]], { itemInfo.hq[2], itemInfo.hq[1], itemInfo.hq[3] })

    cexi.augments.arena_hq[itemInfo.hq[1]] = { itemID, itemInfo.slot }
end

cexi.augments.arenaGetTier = function(itemID, itemAug)
    local tier    = 0
    local augInfo = cexi.augments.arena_augments[itemID].augs

    for augTier = 1, 3 do
        if
            itemAug[augTier] ~= nil and
            augInfo[augTier][1] == itemAug[1][1] and
            augInfo[augTier][2] == itemAug[1][2]
        then
            tier = augTier
        end
    end

    return tier
end

cexi.augments.arenaGiveTier = function(player, itemID, itemTier, highQuality)
    local augs = cexi.augments.arena_augments[itemID].augs
    local id   = itemID

    if highQuality then
        id = cexi.augments.arena_augments[itemID].hq[1]
    end

    if itemTier == 1 then
        player:addItem(id, 1, augs[1][1], augs[1][2], augs[1][3], augs[1][4], augs[1][5], augs[1][6])
    elseif itemTier == 2 then
        player:addItem(id, 1, augs[2][1], augs[2][2], augs[2][3], augs[2][4], augs[2][5], augs[2][6])
    elseif itemTier == 3 then
        player:addItem(id, 1, augs[3][1], augs[3][2], augs[3][3], augs[3][4], augs[3][5], augs[3][6], augs[3][7], augs[3][8])
    end

    player:timer(100, function()
        player:messageSpecial(zones[player:getZoneID()].text.ITEM_OBTAINED, id)
    end)
end

return m
