-----------------------------------
-- Campaign Augments
-----------------------------------
local m = Module:new("base_augments_campaign_augments")

cexi                           = cexi or {}
cexi.augments                  = cexi.augments or {}

cexi.augments.campaign_requirements =
{
    { xi.keyItem.HOLYKNIGHT_EMBLEM, "Holyknight Emblem", 10000 },
    { xi.keyItem.WINGS_OF_HONOR,    "Wings of Honor",    20000 },
    { xi.keyItem.MEDAL_OF_ALTANA,   "Medal of Altana",   30000 },
}

cexi.augments.campaign_augments =
{
    [16148] =
    {
        name = "Cobra Cap",
        augs =
        {
            {  23, 1 }, -- Accuracy +2
            { 142, 1 }, -- Store TP +2
            {  49, 2 }, -- Haste +3%
        },
    },

    [14590] =
    {
        name = "Cobra Harness",
        augs =
        {
            {  17, 31 }, -- HP/MP +32
            {  25, 10 }, -- Attack +11
            { 145,  5 }, -- Counter +6
        },
    },

    [15011] =
    {
        name = "Cobra Mittens",
        augs =
        {
            { 514,  4 }, -- VIT +5
            {  54,  1 }, -- Physical damage taken -2%
            {  49,  5 }, -- Haste +2%
        },
    },

    [16317] =
    {
        name = "Cobra Subligar",
        augs =
        {
            {  23,  3 }, -- Accuracy +4
            {  31,  5 }, -- Evasion +6
            { 142,  1 }, -- Store TP +2
        },
    },

    [15757] =
    {
        name = "Cobra Leggings",
        augs =
        {
            { 557,  3 }, -- STR/CHR +3
            {  49,  0 }, -- Haste +1%
            { 330,  1 }, -- Waltz Potency +2%
        },
    },
    [16149] =
    {
        name = "Cobra Cloche",
        augs =
        {
            { 141, 1 }, -- Conserve MP +2
            { 292, 1 }, -- Elem. magic skill +2
            { 133, 0 }, -- Mag.Atk.Bns. +1
        },
    },
    [14591] =
    {
        name = "Cobra Robe",
        augs =
        {
            { 516,  3 }, -- INT +4
            { 237, 19 }, -- Occult Acumen +20
            { 140,  1 }, -- Fast Cast +2%
        },
    },
    [15012] =
    {
        name = "Cobra Gloves",
        augs =
        {
            { 237, 14 }, -- Occult Acumen +15
            { 141,  1 }, -- Conserve MP +2
            { 133,  1 }, -- Mag.Atk.Bns. +2
        },
    },
    [16318] =
    {
        name = "Cobra Trews",
        augs =
        {
            {  35, 1 }, -- Mag.Acc. +2
            { 141, 2 }, -- Conserve MP +3
            {  57, 3 }, -- Magic crit. hit rate +4%
        },
    },
    [15758] =
    {
        name = "Cobra Crackows",
        augs =
        {
            { 329, 1 }, -- Cure potency +2%
            {  55, 1 }, -- Magic dmg. taken -2%
            {  57, 1 }, -- Magic crit. hit rate +2%
        },
    },
    [16146] =
    {
        name = "Iron Ram Sallet",
        augs =
        {
            {   1, 9 }, -- HP +10
            {  23, 2 }, -- Accuracy +3
            {  49, 2 }, -- Haste +3%
        },
    },
    [14588] =
    {
        name = "Iron Ram Hauberk",
        augs =
        {
            {   1, 14 }, -- HP +15
            {  23,  7 }, -- Accuracy +8
            { 137,  0 }, -- Regen +1
        },
    },
    [15009] =
    {
        name = "I.R. Dastanas",
        augs =
        {
            {   1, 9 }, -- HP +10
            {  23, 1 }, -- Accuracy +2
            {  49, 1 }, -- Haste +2%
        },
    },
    [16315] =
    {
        name = "Iron Ram Hose",
        augs =
        {
            {   1, 14 }, -- HP +15
            { 145,  3 }, -- Counter +4
            { 140,  1 }, -- Fast Cast +2%
        },
    },
    [15755] =
    {
        name = "Iron Ram Greaves",
        augs =
        {
            {   1, 9 }, -- HP +10
            {  23, 2 }, -- Accuracy +3
            {  49, 0 }, -- Haste +1%
        },
    },
    [16147] =
    {
        name = "Fourth Haube",
        augs =
        {
            {  17, 9 }, -- HP/MP +10
            {  25, 4 }, -- Attack +5
            {  49, 2 }, -- Haste +3%
        },
    },
    [14589] =
    {
        name = "Fourth Brunne",
        augs =
        {
            { 195, 2 }, -- Subtle Blow +3
            {  68, 7 }, -- Accuracy/Attack +8
            { 332, 1 }, -- Sklchn.dmg. +2%
        },
    },
    [15010] =
    {
        name = "Fourth Hentzes",
        augs =
        {
            { 515, 2 }, -- AGI +3
            {  25, 3 }, -- Attack +4
            {  49, 1 }, -- Haste +2%
        },
    },
    [16316] =
    {
        name = "Fourth Schoss",
        augs =
        {
            {  515, 3 }, -- AGI +4
            {   23, 3 }, -- Accuracy +4
            { 1472, 1 }, -- Parrying rate +2%
        },
    },
    [15756] =
    {
        name = "Fourth Schuhs",
        augs =
        {
            {  17, 9 }, -- HP/MP +10
            {  25, 2 }, -- Attack +3
            {  49, 0 }, -- Haste +1%
        },
    },
}

cexi.augments.campaignGetTier = function(itemID, itemAug)
    local tier    = 0
    local augInfo = cexi.augments.campaign_augments[itemID].augs

    for augTier = 1, 3 do
        if
            itemAug[augTier] ~= nil and
            augInfo[augTier][1] == itemAug[augTier][1] and
            augInfo[augTier][2] == itemAug[augTier][2]
        then
            tier = augTier
        end
    end

    return tier
end

cexi.augments.campaignGiveTier = function(player, itemID, itemTier)
    local augs = cexi.augments.campaign_augments[itemID].augs

    if itemTier == 1 then
        player:addItem(itemID, 1, augs[1][1], augs[1][2])
    elseif itemTier == 2 then
        player:addItem(itemID, 1, augs[1][1], augs[1][2], augs[2][1], augs[2][2])
    elseif itemTier == 3 then
        player:addItem(itemID, 1, augs[1][1], augs[1][2], augs[2][1], augs[2][2], augs[3][1], augs[3][2])
    end

    player:timer(100, function()
        player:messageSpecial(zones[player:getZoneID()].text.ITEM_OBTAINED, itemID)
    end)
end

return m
