-----------------------------------
-- wew_unlocks
-- Unlocks for various progression milestones
-----------------------------------
require("modules/module_utils")
require("scripts/globals/quests")
require("scripts/globals/missions")
-----------------------------------
local m = Module:new("wew_unlocks")

m.bagNames =
{
    [xi.inv.INVENTORY]  = "Inventory",
    [xi.inv.MOGSAFE]    = "Mog Safe",
    [xi.inv.STORAGE]    = "Storage",
    [xi.inv.TEMPITEMS]  = "Temp. Items",
    [xi.inv.MOGLOCKER]  = "Mog Locker",
    [xi.inv.MOGSATCHEL] = "Mog Satchel",
    [xi.inv.MOGSACK]    = "Mog Sack",
    [xi.inv.MOGCASE]    = "Mog Case",
    [xi.inv.WARDROBE]   = "Mog Wardrobe 1",
    [xi.inv.MOGSAFE2]   = "Mog Safe 2",
    [xi.inv.WARDROBE2]  = "Mog Wardrobe 2",
    [xi.inv.WARDROBE3]  = "Mog Wardrobe 3",
    [xi.inv.WARDROBE4]  = "Mog Wardrobe 4",
    [xi.inv.WARDROBE5]  = "Mog Wardrobe 5",
    [xi.inv.WARDROBE6]  = "Mog Wardrobe 6",
    [xi.inv.WARDROBE7]  = "Mog Wardrobe 7",
    [xi.inv.WARDROBE8]  = "Mog Wardrobe 8",
    [xi.inv.RECYCLEBIN] = "Recycle Bin",
}

m.wardrobeRanks =
{
    { xi.inv.WARDROBE,  0 }, -- Rank 1  ( 0)
    { xi.inv.WARDROBE, 10 }, -- Rank 2  (10)
    { xi.inv.WARDROBE, 10 }, -- Rank 3  (20)
    { xi.inv.WARDROBE, 10 }, -- Rank 4  (30)
    { xi.inv.WARDROBE, 10 }, -- Rank 5  (40)
    { xi.inv.WARDROBE, 10 }, -- Rank 6  (50)
    { xi.inv.WARDROBE, 10 }, -- Rank 7  (60)
    { xi.inv.WARDROBE,  5 }, -- Rank 8  (65)
    { xi.inv.WARDROBE,  5 }, -- Rank 9  (70)
    { xi.inv.WARDROBE, 10 }, -- Rank 10 (80)
}

m.wardrobeMissions =
{
    [xi.mission.log_id.ZILART] =
    {
        [xi.mission.id.zilart.THE_NEW_FRONTIER]            = { xi.inv.WARDROBE2,  4 },
        [xi.mission.id.zilart.WELCOME_TNORG]               = { xi.inv.WARDROBE2,  4 },
        [xi.mission.id.zilart.KAZHAMS_CHIEFTAINESS]        = { xi.inv.WARDROBE2,  4 },
        [xi.mission.id.zilart.THE_TEMPLE_OF_UGGALEPIH]     = { xi.inv.WARDROBE2,  4 },
        [xi.mission.id.zilart.HEADSTONE_PILGRIMAGE]        = { xi.inv.WARDROBE2,  4 },
        [xi.mission.id.zilart.THROUGH_THE_QUICKSAND_CAVES] = { xi.inv.WARDROBE2,  4 },
        [xi.mission.id.zilart.THE_CHAMBER_OF_ORACLES]      = { xi.inv.WARDROBE2,  4 },
        [xi.mission.id.zilart.RETURN_TO_DELKFUTTS_TOWER]   = { xi.inv.WARDROBE2,  4 },
        [xi.mission.id.zilart.ROMAEVE]                     = { xi.inv.WARDROBE2,  4 },
        [xi.mission.id.zilart.THE_TEMPLE_OF_DESOLATION]    = { xi.inv.WARDROBE2,  4 },
        [xi.mission.id.zilart.THE_HALL_OF_THE_GODS]        = { xi.inv.WARDROBE2,  4 },
        [xi.mission.id.zilart.THE_MITHRA_AND_THE_CRYSTAL]  = { xi.inv.WARDROBE2,  4 },
        [xi.mission.id.zilart.THE_GATE_OF_THE_GODS]        = { xi.inv.WARDROBE2,  4 },
        [xi.mission.id.zilart.ARK_ANGELS]                  = { xi.inv.WARDROBE2,  4 },
        [xi.mission.id.zilart.THE_SEALED_SHRINE]           = { xi.inv.WARDROBE2,  4 },
        [xi.mission.id.zilart.THE_CELESTIAL_NEXUS]         = { xi.inv.WARDROBE2,  4 },
        [xi.mission.id.zilart.AWAKENING]                   = { xi.inv.WARDROBE2, 16 },
    },

    [xi.mission.log_id.COP] =
    {
        [xi.mission.id.cop.ANCIENT_FLAMES_BECKON]       = { xi.inv.WARDROBE3, 1 },
        [xi.mission.id.cop.THE_RITES_OF_LIFE]           = { xi.inv.WARDROBE3, 1 },
        [xi.mission.id.cop.BELOW_THE_ARKS]              = { xi.inv.WARDROBE3, 1 },
        [xi.mission.id.cop.THE_MOTHERCRYSTALS]          = { xi.inv.WARDROBE3, 2 },
        [xi.mission.id.cop.AN_INVITATION_WEST]          = { xi.inv.WARDROBE3, 2 },
        [xi.mission.id.cop.THE_LOST_CITY]               = { xi.inv.WARDROBE3, 2 },
        [xi.mission.id.cop.DISTANT_BELIEFS]             = { xi.inv.WARDROBE3, 1 },
        [xi.mission.id.cop.AN_ETERNAL_MELODY]           = { xi.inv.WARDROBE3, 1 },
        [xi.mission.id.cop.ANCIENT_VOWS]                = { xi.inv.WARDROBE3, 2 },
        [xi.mission.id.cop.A_TRANSIENT_DREAM]           = { xi.inv.WARDROBE3, 1 },
        [xi.mission.id.cop.THE_CALL_OF_THE_WYRMKING]    = { xi.inv.WARDROBE3, 2 },
        [xi.mission.id.cop.A_VESSEL_WITHOUT_A_CAPTAIN]  = { xi.inv.WARDROBE3, 2 },
        [xi.mission.id.cop.DESCENDANTS_OF_A_LINE_LOST]  = { xi.inv.WARDROBE3, 2 },
        [xi.mission.id.cop.COMEDY_OF_ERRORS_ACT_I]      = { xi.inv.WARDROBE3, 2 },
        [xi.mission.id.cop.TENDING_AGED_WOUNDS]         = { xi.inv.WARDROBE3, 2 },
        [xi.mission.id.cop.DARKNESS_NAMED]              = { xi.inv.WARDROBE3, 2 },
        [xi.mission.id.cop.SHELTERING_DOUBT]            = { xi.inv.WARDROBE3, 2 },
        [xi.mission.id.cop.THE_SAVAGE]                  = { xi.inv.WARDROBE3, 2 },
        [xi.mission.id.cop.THE_SECRETS_OF_WORSHIP]      = { xi.inv.WARDROBE3, 2 },
        [xi.mission.id.cop.SLANDEROUS_UTTERINGS]        = { xi.inv.WARDROBE3, 2 },
        [xi.mission.id.cop.THE_ENDURING_TUMULT_OF_WAR]  = { xi.inv.WARDROBE3, 2 },
        [xi.mission.id.cop.DESIRES_OF_EMPTINESS]        = { xi.inv.WARDROBE3, 2 },
        [xi.mission.id.cop.THREE_PATHS]                 = { xi.inv.WARDROBE3, 2 },
        [xi.mission.id.cop.PARTNERS_WITHOUT_FAME]       = { xi.inv.WARDROBE3, 2 },
        [xi.mission.id.cop.SPIRAL]                      = { xi.inv.WARDROBE3, 2 },
        [xi.mission.id.cop.WHERE_MESSENGERS_GATHER]     = { xi.inv.WARDROBE3, 2 },
        [xi.mission.id.cop.FLAMES_FOR_THE_DEAD]         = { xi.inv.WARDROBE3, 2 },
        [xi.mission.id.cop.FOR_WHOM_THE_VERSE_IS_SUNG]  = { xi.inv.WARDROBE3, 2 },
        [xi.mission.id.cop.A_PLACE_TO_RETURN]           = { xi.inv.WARDROBE3, 2 },
        [xi.mission.id.cop.MORE_QUESTIONS_THAN_ANSWERS] = { xi.inv.WARDROBE3, 2 },
        [xi.mission.id.cop.ONE_TO_BE_FEARED]            = { xi.inv.WARDROBE3, 2 },
        [xi.mission.id.cop.CHAINS_AND_BONDS]            = { xi.inv.WARDROBE3, 2 },
        [xi.mission.id.cop.FLAMES_IN_THE_DARKNESS]      = { xi.inv.WARDROBE3, 2 },
        [xi.mission.id.cop.FIRE_IN_THE_EYES_OF_MEN]     = { xi.inv.WARDROBE3, 2 },
        [xi.mission.id.cop.CALM_BEFORE_THE_STORM]       = { xi.inv.WARDROBE3, 2 },
        [xi.mission.id.cop.THE_WARRIORS_PATH]           = { xi.inv.WARDROBE3, 2 },
        [xi.mission.id.cop.EMPTINESS_BLEEDS]            = { xi.inv.WARDROBE3, 2 },
        [xi.mission.id.cop.GARDEN_OF_ANTIQUITY]         = { xi.inv.WARDROBE3, 2 },
        [xi.mission.id.cop.A_FATE_DECIDED]              = { xi.inv.WARDROBE3, 2 },
        [xi.mission.id.cop.WHEN_ANGELS_FALL]            = { xi.inv.WARDROBE3, 2 },
        [xi.mission.id.cop.DAWN]                        = { xi.inv.WARDROBE3, 6 },
    },

    [xi.mission.log_id.TOAU] =
    {
        [xi.mission.id.toau.LAND_OF_SACRED_SERPENTS] = { xi.inv.WARDROBE4, 1 },
        [xi.mission.id.toau.IMMORTAL_SENTRIES]       = { xi.inv.WARDROBE4, 1 },
        [xi.mission.id.toau.PRESIDENT_SALAHEEM]      = { xi.inv.WARDROBE4, 1 },
        [xi.mission.id.toau.KNIGHT_OF_GOLD]          = { xi.inv.WARDROBE4, 1 },
        [xi.mission.id.toau.CONFESSIONS_OF_ROYALTY]  = { xi.inv.WARDROBE4, 1 },
        [xi.mission.id.toau.EASTERLY_WINDS]          = { xi.inv.WARDROBE4, 1 },
        [xi.mission.id.toau.WESTERLY_WINDS]          = { xi.inv.WARDROBE4, 1 },
        [xi.mission.id.toau.A_MERCENARY_LIFE]        = { xi.inv.WARDROBE4, 1 },
        [xi.mission.id.toau.UNDERSEA_SCOUTING]       = { xi.inv.WARDROBE4, 1 },
        [xi.mission.id.toau.ASTRAL_WAVES]            = { xi.inv.WARDROBE4, 1 },
        [xi.mission.id.toau.IMPERIAL_SCHEMES]        = { xi.inv.WARDROBE4, 1 },
        [xi.mission.id.toau.ROYAL_PUPPETEER]         = { xi.inv.WARDROBE4, 1 },
        [xi.mission.id.toau.LOST_KINGDOM]            = { xi.inv.WARDROBE4, 1 },
        [xi.mission.id.toau.THE_DOLPHIN_CREST]       = { xi.inv.WARDROBE4, 1 },
        [xi.mission.id.toau.THE_BLACK_COFFIN]        = { xi.inv.WARDROBE4, 5 },
        [xi.mission.id.toau.GHOSTS_OF_THE_PAST]      = { xi.inv.WARDROBE4, 1 },
        [xi.mission.id.toau.GUESTS_OF_THE_EMPIRE]    = { xi.inv.WARDROBE4, 1 },
        [xi.mission.id.toau.PASSING_GLORY]           = { xi.inv.WARDROBE4, 1 },
        [xi.mission.id.toau.SWEETS_FOR_THE_SOUL]     = { xi.inv.WARDROBE4, 1 },
        [xi.mission.id.toau.TEAHOUSE_TUMULT]         = { xi.inv.WARDROBE4, 1 },
        [xi.mission.id.toau.FINDERS_KEEPERS]         = { xi.inv.WARDROBE4, 1 },
        [xi.mission.id.toau.SHIELD_OF_DIPLOMACY]     = { xi.inv.WARDROBE4, 5 },
        [xi.mission.id.toau.SOCIAL_GRACES]           = { xi.inv.WARDROBE4, 1 },
        [xi.mission.id.toau.FOILED_AMBITION]         = { xi.inv.WARDROBE4, 1 },
        [xi.mission.id.toau.PLAYING_THE_PART]        = { xi.inv.WARDROBE4, 1 },
        [xi.mission.id.toau.SEAL_OF_THE_SERPENT]     = { xi.inv.WARDROBE4, 1 },
        [xi.mission.id.toau.MISPLACED_NOBILITY]      = { xi.inv.WARDROBE4, 1 },
        [xi.mission.id.toau.BASTION_OF_KNOWLEDGE]    = { xi.inv.WARDROBE4, 1 },
        [xi.mission.id.toau.PUPPET_IN_PERIL]         = { xi.inv.WARDROBE4, 5 },
        [xi.mission.id.toau.PREVALENCE_OF_PIRATES]   = { xi.inv.WARDROBE4, 1 },
        [xi.mission.id.toau.SHADES_OF_VENGEANCE]     = { xi.inv.WARDROBE4, 5 },
        [xi.mission.id.toau.IN_THE_BLOOD]            = { xi.inv.WARDROBE4, 1 },
        [xi.mission.id.toau.SENTINELS_HONOR]         = { xi.inv.WARDROBE4, 1 },
        [xi.mission.id.toau.TESTING_THE_WATERS]      = { xi.inv.WARDROBE4, 1 },
        [xi.mission.id.toau.LEGACY_OF_THE_LOST]      = { xi.inv.WARDROBE4, 5 },
        [xi.mission.id.toau.GAZE_OF_THE_SABOTEUR]    = { xi.inv.WARDROBE4, 1 },
        [xi.mission.id.toau.PATH_OF_BLOOD]           = { xi.inv.WARDROBE4, 1 },
        [xi.mission.id.toau.STIRRINGS_OF_WAR]        = { xi.inv.WARDROBE4, 2 },
        [xi.mission.id.toau.ALLIED_RUMBLINGS]        = { xi.inv.WARDROBE4, 2 },
        [xi.mission.id.toau.UNRAVELING_REASON]       = { xi.inv.WARDROBE4, 2 },
        [xi.mission.id.toau.LIGHT_OF_JUDGMENT]       = { xi.inv.WARDROBE4, 2 },
        [xi.mission.id.toau.PATH_OF_DARKNESS]        = { xi.inv.WARDROBE4, 5 },
        [xi.mission.id.toau.FANGS_OF_THE_LION]       = { xi.inv.WARDROBE4, 2 },
        [xi.mission.id.toau.NASHMEIRAS_PLEA]         = { xi.inv.WARDROBE4, 5 },
        [xi.mission.id.toau.RAGNAROK]                = { xi.inv.WARDROBE4, 3 },
    },

    [xi.mission.log_id.ACP] =
    {
        [xi.mission.id.acp.THE_ECHO_AWAKENS]              = { xi.inv.WARDROBE5, 2 },
        [xi.mission.id.acp.GATHERER_OF_LIGHT_II]          = { xi.inv.WARDROBE5, 2 },
        [xi.mission.id.acp.THOSE_WHO_LURK_IN_SHADOWS_III] = { xi.inv.WARDROBE5, 2 },
        [xi.mission.id.acp.BANISHING_THE_ECHO]            = { xi.inv.WARDROBE5, 2 },
        [xi.mission.id.acp.ODE_OF_LIFE_BESTOWING]         = { xi.inv.WARDROBE5, 2 },
    },

    [xi.mission.log_id.AMK] =
    {
        [xi.mission.id.amk.DRENCHED_IT_BEGAN_WITH_A_RAINDROP]  = { xi.inv.WARDROBE5, 2 },
        [xi.mission.id.amk.WELCOME_TO_MY_DECREPIT_DOMICILE]    = { xi.inv.WARDROBE5, 2 },
        [xi.mission.id.amk.AN_ERRAND_THE_PROFESSORS_PRICE]     = { xi.inv.WARDROBE5, 2 },
        [xi.mission.id.amk.ROAR_A_CAT_BURGLAR_BARES_HER_FANGS] = { xi.inv.WARDROBE5, 2 },
        [xi.mission.id.amk.SMASH_A_MALEVOLENT_MENACE]          = { xi.inv.WARDROBE5, 2 },
    },

    [xi.mission.log_id.ASA] =
    {
        [xi.mission.id.asa.THAT_WHICH_CURDLES_BLOOD] = { xi.inv.WARDROBE5, 2 },
        [xi.mission.id.asa.SUGAR_COATED_DIRECTIVE]   = { xi.inv.WARDROBE5, 2 },
        [xi.mission.id.asa.ENEMY_OF_THE_EMPIRE_II]   = { xi.inv.WARDROBE5, 2 },
        [xi.mission.id.asa.BATTARU_ROYALE]           = { xi.inv.WARDROBE5, 2 },
        [xi.mission.id.asa.AN_UNEASY_PEACE]          = { xi.inv.WARDROBE5, 2 },
    }
}

return m
