-----------------------------------------------------------------
-- Prevent WEW and CW from getting the Rhapsody Key Items
-- NOTE: Please expect to see this message in the map server log
-- ERROR: invalid keyitems parameter given to npcUtil.giveKeyItem
-----------------------------------------------------------------
require('modules/module_utils')
require('scripts/globals/utils')
--------------------------------
local m = Module:new('custom_keyitem')

local blacklistWeWCW = {
    xi.keyItem.RHAPSODY_IN_WHITE,
    xi.keyItem.RHAPSODY_IN_UMBER,
    xi.keyItem.RHAPSODY_IN_AZURE,
    xi.keyItem.RHAPSODY_IN_CRIMSON,
    xi.keyItem.RHAPSODY_IN_EMERALD,
    xi.keyItem.RHAPSODY_IN_MAUVE,
    xi.keyItem.RHAPSODY_IN_FUCHSIA,
    xi.keyItem.RHAPSODY_IN_PUCE,
    xi.keyItem.RHAPSODY_IN_OCHRE,
}

local blacklistACE = {
    xi.keyItem.RHAPSODY_IN_UMBER,
    xi.keyItem.RHAPSODY_IN_AZURE,
    xi.keyItem.RHAPSODY_IN_EMERALD,
    xi.keyItem.RHAPSODY_IN_MAUVE,
    xi.keyItem.RHAPSODY_IN_FUCHSIA,
    xi.keyItem.RHAPSODY_IN_PUCE,
    xi.keyItem.RHAPSODY_IN_OCHRE,
}

local ciphers = {
    xi.item.CIPHER_OF_LIONS_ALTER_EGO_II,
    xi.item.CIPHER_OF_ZEIDS_ALTER_EGO_II,
    xi.item.CIPHER_OF_TENZENS_ALTER_EGO_II,
    xi.item.CIPHER_OF_PRISHES_ALTER_EGO_II,
    xi.item.CIPHER_OF_NASHMEIRAS_ALTER_EGO_II,
}

local function isKeyItemInBlackList(player, blacklist)
    for _, ki in ipairs(blacklist) do
        if ki == player then
            return true
        end
    end

    return false
end

-- Prevent the distribution of Rhapsody KI's to WEW and CW.
m:addOverride("npcUtil.giveKeyItem", function(player, keyitems, msgId)
    if type(keyitems) ~= 'table' then
        -- Crystal Warriors and Wings-Era Warriors
        if player:isCrystalWarrior() or player:isClassicMode() then
            if isKeyItemInBlackList(keyitems, blacklistWeWCW) then
                return true
            end
        else
            -- Everyone else (ACE players)
            if isKeyItemInBlackList(keyitems, blacklistACE) then
                return true
            end
        end
    end

    return super(player, keyitems, msgId)
end)

-- Prevent the distribution of Trust Ciphers to WEW.
m:addOverride("npcUtil.giveItem", function(player, items, params)
    if type(items) ~= 'table' then
        -- Wings-Era Warriors
        if player:isClassicMode() then
            for _, cipher in ipairs(ciphers) do
                if cipher == items then
                    return true
                end
            end
        end
    end

    return super(player, items, params)
end)

return m
