-----------------------------------
-- Custom Mobs
-----------------------------------
require("modules/module_utils")
require("scripts/globals/utils")
-----------------------------------
local m = Module:new("custom_mob")

local camp =
{
    ["Beaucedine_Glacier"] =
    {
        {
            name        = "Frost Diremite",
            level       = 24,
            groupId     = 11,
            groupZoneId = 27,
            respawn     = utils.minutes(5),
            drops       =
            {
                { cexi.rate.VERY_COMMON, 1700 }, -- Bloodthread (24%)
                { cexi.rate.RARE,         924 }, -- Fiend Blood ( 5%)
            },
            
            spawn       =
            {
                { -201.062, -40.012, -236.237, 229 }, -- !pos -201.062 -40.012 -236.237 111
                { -187.508, -39.592, -244.336,  44 },
                { -174.402, -39.481, -244.503,   0 },
                { -154.727, -40.064, -237.331, 238 },
                { -154.731, -40.051, -204.285, 148 },
                { -176.637, -39.230, -195.791, 119 },
                { -183.290, -40.250, -226.539, 248 },
            },
        },
    },
    ["Wajaom_Woodlands"] =
    {
        {
            name        = "Toucan",
            level       = { 30, 32 },
            groupId     = 14,
            groupZoneId = 4,
            respawn     = 90,
            mobMods     =
            {
               [xi.mobMod.NO_LINK] = 1,
            },
            drops       =
            {
                { cexi.rate.UNCOMMON, xi.item.BIRD_FEATHER }, -- Bird Feather 10%
                { cexi.rate.RARE,     xi.item.BIRD_EGG     }, -- Bird Egg      5%
            },

            spawn    =
            {
                -- (M-7)
                { 668.539, -20.271, 263.981,  44 }, -- !pos 668.539 -20.271 263.981 51
                { 679.122, -20.250, 264.888,  70 },
                { 678.675, -18.165, 256.218, 152 },
                { 688.901, -17.482, 250.605, 181 },
                { 690.014, -19.384, 260.696, 105 },

                { 734.458, -19.500, 254.670,  35 },
                { 745.947, -20.250, 248.837,  67 },
                { 739.491, -19.374, 238.634, 120 },
                { 729.472, -17.262, 246.041, 190 },
                { 717.506, -18.000, 252.892, 247 },

                { 724.498, -15.921, 234.302,  49 },
                { 715.267, -15.955, 236.256, 151 },
                { 714.694, -16.097, 244.861,  92 },
                { 708.963, -17.018, 250.685, 116 },
                { 702.484, -16.503, 250.040, 165 },
            },
        },
        {
            name        = "Greater Toucan",
            level       = { 40, 42 },
            groupId     = 14,
            groupZoneId = 4,
            respawn     = 90,
            mobMods     =
            {
               [xi.mobMod.NO_LINK] = 1,
            },
            drops       =
            {
                { cexi.rate.UNCOMMON, xi.item.BIRD_FEATHER }, -- Bird Feather 10%
                { cexi.rate.RARE,     xi.item.BIRD_EGG     }, -- Bird Egg      5%
            },

            spawn    =
            {
                -- Giwahb Watchtower (F-5)
                { -360.957, -31.754, 651.968,  41 }, -- !pos -360.957 -31.754 651.968 51
                { -375.427, -34.000, 642.494,  47 },
                { -377.708, -33.717, 651.414, 199 },
                { -381.193, -35.739, 674.460,  32 },
                { -387.499, -36.127, 661.615, 239 },

                { -373.949, -34.000, 667.105, 170 },
                { -364.090, -31.518, 662.785,  24 },
                { -360.111, -31.823, 673.137, 188 },
                { -365.816, -32.233, 680.047,  32 },
                { -371.518, -33.756, 685.985, 145 },

                { -378.986, -35.500, 692.817, 214 },
                { -369.164, -34.826, 692.420,  99 },
                { -365.113, -36.250, 704.954, 107 },
                { -355.762, -36.279, 704.697, 206 },
                { -357.413, -33.103, 689.462,  24 },
            },
        },
    },
    ["Garlaige_Citadel_[S]"] =
    {
        {
            name        = "Dusk Bats",
            level       = { 55, 60 },
            groupId     = 36,
            groupZoneId = 200,
            look        = 263,
            respawn     = 60,
            mobMods     =
            {
               [xi.mobMod.NO_LINK] = 1,
            },
            drops       =
            {
                { cexi.rate.UNCOMMON, xi.item.BAT_WING }, -- Bat Wing 10%
                { cexi.rate.RARE,     xi.item.BAT_FANG }, -- Bat Fang  5%
            },

            spawn       =
            {
                { -258.009, 19.736,  38.648, 146 }, -- !pos -258.009 19.736 38.648 164
                { -255.104, 18.209,  51.485, 225 },
                { -268.568, 18.979,  52.140, 111 },
                { -278.800, 19.000,  47.669, 144 },
                { -291.628, 18.295,  52.520,  34 },
                { -280.782, 19.172,  36.559,  69 },
                { -281.766, 19.216,  30.767, 210 },
                { -283.050, 19.565,  23.177, 130 },
                { -277.315, 19.717,  18.378,  19 },
                { -291.538, 18.269,  20.299, 123 },
                { -295.119, 18.247,  35.656, 216 },
                { -290.283, 19.036,   6.644, 103 },
                { -285.913, 19.157,  -3.905,  28 },
                { -273.302, 19.250,   1.527,   2 },
                { -271.318, 18.916, -13.150, 170 },
                { -263.482, 18.137, -13.599, 156 },
                { -267.429, 19.500,  -0.590, 244 },
            },
        },
        {
            name        = "Twilight Bats",
            level       = { 70, 75 },
            groupId     = 36,
            groupZoneId = 200,
            respawn     = 60,
            mobMods     =
            {
               [xi.mobMod.NO_LINK]   = 1,
               [xi.mobMod.DETECTION] = xi.detects.HEARING,
            },
            drops       =
            {
                { cexi.rate.UNCOMMON, xi.item.BAT_WING }, -- Bat Wing 10%
                { cexi.rate.RARE,     xi.item.BAT_FANG }, -- Bat Fang  5%
            },

            spawn       =
            {
                { -86.545, 19.149,   3.927, 175 }, -- !pos -86.545 19.149 3.927 164
                { -72.172, 19.152,   8.314,  14 },
                { -66.104, 19.506,   4.228,   4 },
                { -57.042, 17.969,  15.256, 229 },
                { -39.624, 19.000,   4.781,  69 },
                { -41.730, 19.250,  -8.574,  20 },
                { -28.132, 18.298,  -9.371, 146 },
                { -32.563, 18.738, -22.535,  88 },
                { -44.199, 19.520, -25.987, 170 },
                { -41.273, 19.075, -37.344, 146 },
                { -29.580, 19.045, -44.246,  10 },
                { -48.576, 19.035, -50.366, 232 },
                { -62.215, 18.704, -38.711, 161 },
                { -67.373, 18.112, -54.348, 100 },
                { -75.121, 19.250, -40.629, 231 },
                { -83.570, 19.161, -35.435, 189 },
                { -74.455, 20.341, -24.367,  30 },
                { -85.849, 19.173, -10.192, 143 },
            },
        },
        {
            name        = "Slippery Sludge",
            level       = { 55, 60 },
            groupId     = 11,
            groupZoneId = 169,
            respawn     = 60,
            modMods     =
            {
               [xi.mobMod.NO_LINK]   = 1,
               [xi.mobMod.DETECTION] = xi.detects.HEARING,
            },
            mods        =
            {
                [xi.mod.DMGPHYS]  = -2500, -- -25% Physical Damage
                [xi.mod.DMGMAGIC] =  2500, -- +25% Magic Damage
                [xi.mod.HPP]      =   -25, --  25% Reduced HP
                [xi.mod.MP]       =  3000, -- 3000 MP
            },
            drops       =
            {
                { cexi.rate.RARE, xi.item.SLIME_OIL }, -- Slime Oil  5%
            },

            spawn       =
            {
                {  -78.481, 19.000, 88.685, 126 }, -- !pos -78.481 19.000 88.685 164
                {  -69.486, 19.048, 83.119,  11 },
                {  -77.920, 19.000, 74.720, 123 },
                {  -67.234, 18.266, 68.290,  40 },
                {  -89.815, 18.735, 81.977, 143 },
                {  -92.112, 19.165, 71.980,  73 },
                { -102.425, 19.629, 77.238, 141 },
                { -113.016, 19.396, 75.325, 100 },
                { -110.564, 18.931, 88.907, 195 },
                { -107.947, 18.263, 92.256, 247 },
                {  -98.276, 17.878, 94.539, 110 },
                {  -94.002, 19.068, 90.520,  30 },
                {  -84.237, 19.014, 91.859, 230 },
            },
        },
        {
            name        = "Pakhet",
            level       = { 75, 78 },
            groupId     = 17,
            groupZoneId = 98,
            respawn     = { 7200, 10800 }, -- 2-3 hours
            notorious   = true,
            drops       =
            {
                { cexi.rate.VERY_COMMON,  927 }, -- Coeurl Whisker (24%)
                { cexi.rate.COMMON,      5667 }, -- Lynx Meat      (15%)
                { cexi.rate.COMMON,      2512 }, -- Lynx Hide      (15%)
                { cexi.rate.VERY_RARE,   1766 }, -- Tiger Eye      ( 1%)
            },

            spawn       =
            {
                { -179.949, 17.878, -37.520, 60 }, -- !pos -179.949 17.878 -37.520 164
            },
        },
    },
}

for zoneName, bestiary in pairs(camp) do
    m:addOverride(string.format("xi.zones.%s.Zone.onInitialize", zoneName), function(zone)
        super(zone)

        for _, mobInfo in pairs(bestiary) do
            for _, pos in pairs(mobInfo.spawn) do
                local dynamicEntity =
                {
                    name        = mobInfo.name,
                    objtype     = xi.objType.MOB,
                    groupId     = mobInfo.groupId,
                    groupZoneId = mobInfo.groupZoneId,
                    x           = pos[1],
                    y           = pos[2],
                    z           = pos[3],
                    rotation    = pos[4],
                    widescan    = 1,
                }

                if mobInfo.look ~= nil then 
                    dynamicEntity.look = mobInfo.look
                end

                dynamicEntity.onMobInitialize = function(mob)
                    mob:setMobMod(xi.mobMod.DETECTION, 0x08)
                    mob:setMobMod(xi.mobMod.CHARMABLE,    0)

                    if mobInfo.notorious then
                        mob:setMobMod(xi.mobMod.CHECK_AS_NM,  1)
                    end
                end

                dynamicEntity.onMobSpawn = function(mob)
                    if type(mobInfo.level) == "table" then -- Roll level if table (random range)
                        mob:setMobLevel(math.random(mobInfo.level[1], mobInfo.level[2]))
                    else
                        mob:setMobLevel(mobInfo.level)
                    end

                    if mobInfo.mobMods ~= nil then
                        for mod, value in pairs(mobInfo.mobMods) do
                            mob:setMobMod(mod, value)
                        end
                    end

                    if mobInfo.mods ~= nil then
                        for mod, value in pairs(mobInfo.mods) do
                            mob:setMod(mod, value)
                        end
                    end

                    mob:setHP(mob:getMaxHP())
                    mob:setMP(mob:getMaxMP())
                    mob:updateHealth()
                end

                dynamicEntity.onMobDeath = function(mob, player, optParams)
                    if type(mobInfo.respawn) == "table" then -- Roll next respawn if table (random range)
                        mob:setRespawnTime(math.random(mobInfo.respawn[1], mobInfo.respawn[2]))
                    end

                    if
                        mobInfo.drops ~= nil and -- If mob has table defined drops, roll them
                        player ~= nil            -- Check the player reference so we don't crash
                    then
                        for _, v in ipairs(mobInfo.drops) do
                            player:addTreasure(v[2], mob, v[1])
                        end
                    end
                end

                local entity = zone:insertDynamicEntity(dynamicEntity)

                entity:setSpawn(pos[1], pos[2], pos[3], pos[4])

                if type(mobInfo.respawn) == "table" then
                    entity:setRespawnTime(math.random(mobInfo.respawn[1], mobInfo.respawn[2]))
                else
                    entity:setRespawnTime(mobInfo.respawn)
                end

                if mobInfo == nil and mobInfo.dropID then
                    entity:setDropID(mobInfo.dropID)
                else
                    entity:setDropID(0)
                end

                entity:spawn()
            end
        end
    end)
end

return m
