-----------------------------------
-- Zeni Chest
-----------------------------------
require("modules/module_utils")
-----------------------------------
local m = Module:new("npc_zeni_chest")

local varName = "[ZNM]Points"
local cost    = 3000
local points  =
{
    T1 = {   25,   50 },
    T2 = {  125,  150 },
    T3 = {  475,  500 },
    T4 = { 1225, 1250 },
    T5 = { 2750, 3000 },
}

local mobs =
{
    -- Tier I
    { "Vulpangue",               "Wajaom_Woodlands",        points.T1 },
    { "Brass_Borer",             "Mount_Zhayolm",           points.T1 },
    { "Velionis",                "Arrapago_Reef",           points.T1 },

    { "Chamrosh",                "Mamook",                  points.T1 },
    { "Claret",                  "Mount_Zhayolm",           points.T1 },
    { "Lil_Apkallu",             "Arrapago_Reef",           points.T1 },

    { "Cheese_Hoarder_Gigiroon", "Alzadaal_Undersea_Ruins", points.T1 },
    { "Ob",                      "Alzadaal_Undersea_Ruins", points.T1 },
    { "Chigre",                  "Aydeewa_Subterrane",      points.T1 },

    -- Tier II
    { "Iriz Ima",                "Wajaom_Woodlands",        points.T2 },
    { "Anantaboga",              "Mount_Zhayolm",           points.T2 },
    { "Verdelet",                "Caedarva_Mire",           points.T2 },

    { "Lividroot_Amooshah",      "Bhaflau_Thickets",        points.T2 },
    { "Dextrose",                "Halvung",                 points.T2 },
    { "Wulgaru",                 "Alzadaal_Undersea_Ruins", points.T2 },

    { "Iriri Samariri",          "Mamook",                  points.T2 },
    { "Reacton",                 "Halvung",                 points.T2 },
    { "Zereehkl_the_Jubilant",   "Arrapago_Reef",           points.T2 },

    -- Tier III
    { "Armed Gears",             "Alzadaal_Undersea_Ruins", points.T3 },
    { "Achamoth",                "Halvung",                 points.T3 },
    { "Experimental_Lamia",      "Caedarva_Mire",           points.T3 },

    { "Gotoh_Zha_the_Redolent",  "Wajaom_Woodlands",        points.T3 },
    { "Khromasoul_Bhurborlor",   "Mount_Zhayolm",           points.T3 },
    { "Mahjlaef_the_Paintorn",   "Caedarva_Mire",           points.T3 },

    { "Dea",                     "Bhaflau_Thickets",        points.T3 },
    { "Nosferatu",               "Aydeewa_Subterrane",      points.T3 },
    { "Nuhn",                    "Arrapago_Reef",           points.T3 },

    -- Tier IV
    { "Tinnin",                  "Wajaom_Woodlands",        points.T3 },
    { "Sarameya",                "Mount_Zhayolm",           points.T3 },
    { "Tyger",                   "Caedarva_Mire",           points.T3 },
}

local materials =
{
    { cexi.rate.VERY_COMMON, xi.item.CHUNK_OF_IRON_ORE       },
    { cexi.rate.COMMON,      xi.item.CHUNK_OF_GOLD_ORE       },
    { cexi.rate.COMMON,      xi.item.CHUNK_OF_PLATINUM_ORE   },
    { cexi.rate.UNCOMMON,    xi.item.CHUNK_OF_LUMINIUM_ORE   },
    { cexi.rate.UNCOMMON,    xi.item.CHUNK_OF_KHROMA_ORE     },

    { cexi.rate.VERY_COMMON, xi.item.ASH_LOG                 },
    { cexi.rate.COMMON,      xi.item.EBONY_LOG               },
    { cexi.rate.COMMON,      xi.item.DOGWOOD_LOG             },
    { cexi.rate.UNCOMMON,    xi.item.BLOODWOOD_LOG           },

    { cexi.rate.VERY_COMMON, xi.item.HANDFUL_OF_ALMONDS      },
    { cexi.rate.COMMON,      xi.item.DATE                    },
    { cexi.rate.COMMON,      xi.item.SLICE_OF_KARAKUL_MEAT   },
    { cexi.rate.UNCOMMON,    xi.item.SPRIG_OF_MISTLETOE      },

    { cexi.rate.VERY_COMMON, 878                             }, -- Karakul Skin
    { cexi.rate.COMMON,      849                             }, -- Undead Skin
    { cexi.rate.COMMON,      xi.item.SQUARE_OF_KARAKUL_CLOTH },
    { cexi.rate.UNCOMMON,    xi.item.SQUARE_OF_RAXA          },

    { cexi.rate.VERY_COMMON, xi.item.PUK_WING                },
    { cexi.rate.VERY_COMMON, xi.item.IMP_WING                },
    { cexi.rate.COMMON,      xi.item.IMP_HORN                },
    { cexi.rate.COMMON,      xi.item.MERROW_SCALE            },
    { cexi.rate.COMMON,      xi.item.AHRIMAN_WING            },
    { cexi.rate.COMMON,      1724                            }, -- Soulflayer Robe
    { cexi.rate.UNCOMMON,    xi.item.BUFFALO_HORN            },
    { cexi.rate.UNCOMMON,    xi.item.SOULFLAYER_STAFF        },
    { cexi.rate.UNCOMMON,    2365                            }, -- Demon Blood
    { cexi.rate.RARE,        2335                            }, -- Soulflayer Tentacle

    { cexi.rate.RARE,        xi.item.AETHER_FRAGMENT         },
    { cexi.rate.RARE,        xi.item.STAR_SAPPHIRE           },
    { cexi.rate.RARE,        2330                            }, -- Yoichi's Sash

    { cexi.rate.RARE,        5565                            }, -- Cerberus Meat
    { cexi.rate.RARE,        2169                            }, -- Cerberus Hide
    { cexi.rate.RARE,        2168                            }, -- Cerberus Claw

    { cexi.rate.RARE,        xi.item.KHIMAIRA_TAIL           },
    { cexi.rate.RARE,        2371                            }, -- Khimaira Horn
    { cexi.rate.RARE,        2372                            }, -- Khimaira Mane

    { cexi.rate.RARE,        xi.item.CHUNK_OF_HYDRA_MEAT     },
    { cexi.rate.RARE,        2158                            }, -- Hydra Fang
    { cexi.rate.RARE,        2172                            }, -- Hydra Scale

    { cexi.rate.VERY_RARE,   xi.item.LAMIA_STAFF             },
    { cexi.rate.VERY_RARE,   xi.item.QUTRUB_KNIFE            },
    { cexi.rate.VERY_RARE,   xi.item.AUTARCHS_AXE            },
    { cexi.rate.VERY_RARE,   xi.item.SOPHISTRY               },
    { cexi.rate.VERY_RARE,   14943                           }, -- Barb. Moufles
    { cexi.rate.VERY_RARE,   15617                           }, -- Barb. Zerehs
}

local rewards =
{
    -- Elemental Clusters
    {
        { cexi.rate.COMMON, { { xi.item.FIRE_CLUSTER,      12 } } },
        { cexi.rate.COMMON, { { xi.item.ICE_CLUSTER,       12 } } },
        { cexi.rate.COMMON, { { xi.item.WIND_CLUSTER,      12 } } },
        { cexi.rate.COMMON, { { xi.item.EARTH_CLUSTER,     12 } } },
        { cexi.rate.COMMON, { { xi.item.LIGHTNING_CLUSTER, 12 } } },
        { cexi.rate.COMMON, { { xi.item.WATER_CLUSTER,     12 } } },
        { cexi.rate.COMMON, { { xi.item.LIGHT_CLUSTER,     12 } } },
        { cexi.rate.COMMON, { { xi.item.DARK_CLUSTER,      12 } } },
    },

    -- Elemental Ores
    {
        { cexi.rate.COMMON, 1255 }, -- Fire Ore
        { cexi.rate.COMMON, 1256 }, -- Ice Ore
        { cexi.rate.COMMON, 1257 }, -- Wind Ore
        { cexi.rate.COMMON, 1258 }, -- Earth Ore
        { cexi.rate.COMMON, 1259 }, -- Lightning Ore
        { cexi.rate.COMMON, 1260 }, -- Water Ore
        { cexi.rate.COMMON, 1261 }, -- Light Ore
        { cexi.rate.COMMON, 1262 }, -- Dark Ore
    },

    -- Pop Items
    {
        -- Tier I
        { cexi.rate.VERY_COMMON, xi.item.HELLCAGE_BUTTERFLY            },
        { cexi.rate.VERY_COMMON, xi.item.CLUMP_OF_SHADELEAVES          },
        { cexi.rate.VERY_COMMON, xi.item.GOLDEN_TEETH                  },

        { cexi.rate.VERY_COMMON, xi.item.JUG_OF_FLORAL_NECTAR          },
        { cexi.rate.VERY_COMMON, xi.item.BEAKER_OF_PECTIN              },
        { cexi.rate.VERY_COMMON, xi.item.GREENLING                     },

        { cexi.rate.VERY_COMMON, xi.item.WEDGE_OF_RODENT_CHEESE        },
        { cexi.rate.VERY_COMMON, xi.item.FLASK_OF_COG_LUBRICANT        },
        { cexi.rate.VERY_COMMON, xi.item.BOTTLE_OF_SPOILT_BLOOD        },

        -- Tier II
        { cexi.rate.COMMON,      xi.item.BUNCH_OF_SENORITA_PAMAMAS     },
        { cexi.rate.COMMON,      xi.item.SLAB_OF_RAW_BUFFALO           },
        { cexi.rate.COMMON,      xi.item.MINT_DROP                     },

        { cexi.rate.COMMON,      xi.item.JAR_OF_OILY_BLOOD             },
        { cexi.rate.COMMON,      xi.item.PINCH_OF_GRANULATED_SUGAR     },
        { cexi.rate.COMMON,      xi.item.OPALUS_GEM                    },

        { cexi.rate.COMMON,      xi.item.STRAND_OF_SAMARIRI_CORPSEHAIR },
        { cexi.rate.COMMON,      xi.item.LUMP_OF_BONE_CHARCOAL         },
        { cexi.rate.COMMON,      xi.item.MERROW_NO_11_MOLTING          },

        -- Tier III
        { cexi.rate.UNCOMMON,    xi.item.BAR_OF_FERRITE                },
        { cexi.rate.UNCOMMON,    xi.item.JAR_OF_ROCK_JUICE             },
        { cexi.rate.UNCOMMON,    xi.item.CLUMP_OF_MYRRH                },

        { cexi.rate.UNCOMMON,    xi.item.BAGGED_SHEEP_BOTFLY           },
        { cexi.rate.UNCOMMON,    xi.item.VINEGAR_PIE                   },
        { cexi.rate.UNCOMMON,    xi.item.BOUND_EXORCISM_TREATISE       },

        { cexi.rate.UNCOMMON,    xi.item.OLZHIRYAN_CACTUS_PADDLE       },
        { cexi.rate.UNCOMMON,    xi.item.VIAL_OF_PURE_BLOOD            },
        { cexi.rate.UNCOMMON,    xi.item.WHOLE_ROSE_SCAMPI             },

        -- Tier IV
        { cexi.rate.RARE,        xi.item.JUG_OF_MONKEY_WINE            },
        { cexi.rate.RARE,        xi.item.CHUNK_OF_BUFFALO_CORPSE       },
        { cexi.rate.RARE,        xi.item.CHUNK_OF_SINGED_BUFFALO       },
    },
    materials,
    materials,
}

for _, mobInfo in pairs(mobs) do
    cexi.util.ensureMob(mobInfo[2], mobInfo[1])

    m:addOverride(fmt("xi.zones.{}.mobs.{}.onMobDeath", mobInfo[2], mobInfo[1]), function(mob, player, optParams)
        super(mob, player, optParams)

        local roll = math.random(mobInfo[3][1], mobInfo[3][2])
        player:incrementCharVar(varName, roll)
        player:sys("{} gains {} zeni battle points.", player:getName(), roll)
    end)
end

local function delaySendMenu(player, menu)
    player:timer(200, function(playerArg)
        playerArg:customMenu(menu)
    end)
end

local function openBox(player, npc)
    if player:getFreeSlotsCount() < 5 then
        player:sys("You do not have enough inventory space.")
        return
    end

    player:incrementCharVar(varName, -cost)

    npc:ceAnimationPacket(player, "open", npc)

    npc:timer(3000, function()
        npc:ceAnimationPacket(player, "clos", npc)
    end)

    for _, itemCategory in pairs(rewards) do
        local result = cexi.util.pickItem(itemCategory)
        cexi.util.giveItem(player, result[2], { multiple = true })
    end
end

local function onTrigger(player, npc)
    local balance = player:getCharVar(varName)

    if balance < cost then
        player:sys("You need at least {} zeni battle points to open the chest. ({})", cost, balance)
        return
    end

    delaySendMenu(player, {
        title   = fmt("Open the chest? ({})", balance),
        options =
        {
            {
                "Not yet",
                function()
                end,
            },
            {
                fmt("Open Chest ({})", cost),
                function()
                    openBox(player, npc)
                end,
            },
        },
    })
end

cexi.util.liveReload(m, {
    ["Aht_Urhgan_Whitegate"] =
    {
        {
            objtype      = xi.objType.NPC,
            name         = "Zeni Chest",
            look         = 969,
            x            = -124.866,
            y            = 2.000,
            z            = 21.514,
            rotation     = 95,
            widescan     = 1,
            onTrigger    = onTrigger,
        },
    },
})

return m
