-----------------------------------
-- Ventures
-- !pos -54.260 12.000 -31.180 243
-----------------------------------
require("modules/module_utils")
-----------------------------------
local m = Module:new("ventures_giftboxes")

local clusters =
{
    xi.item.FIRE_CLUSTER,
    xi.item.ICE_CLUSTER,
    xi.item.WIND_CLUSTER,
    xi.item.EARTH_CLUSTER,
    xi.item.LIGHTNING_CLUSTER,
    xi.item.WATER_CLUSTER,
    xi.item.LIGHT_CLUSTER,
    xi.item.DARK_CLUSTER,
}

local giftboxes =
{
    {
        name = "goblin_giftbox_(small)",
        loot =
        {
            { cexi.rate.VERY_COMMON,   750, { 1, 2 }        }, -- Silver Beastcoin   (24%)
            { cexi.rate.COMMON,        511                  }, -- Goblin Mask        (15%)
            { cexi.rate.COMMON,        510                  }, -- Goblin Armor       (15%)
            { cexi.rate.UNCOMMON,      749                  }, -- Mythril Beastcoin  (10%)
            { cexi.rate.UNCOMMON,      656, { 2, 4 }        }, -- Beastcoin          (10%)
            { cexi.rate.RARE,         1625                  }, -- Moblin Helm         (5%)
            { cexi.rate.RARE,         2543                  }, -- Goblin Wheel        (5%)
            { cexi.rate.RARE,         4539, { 1, 3 }        }, -- Goblin Pie          (5%)
            { cexi.rate.RARE,         9435                  }, -- Goblin Brew         (5%)
            { cexi.rate.RARE,         4035                  }, -- Goblin Commendation (5%)
            { cexi.rate.VERY_RARE,   21402                  }, -- Battle Horn         (1%)
            { cexi.rate.SUPER_RARE,  xi.item.GOBLIN_BREW_P1 }, -- Goblin Brew +1    (0.5%)
            { cexi.rate.ULTRA_RARE,  xi.item.GOBLIN_BREW_P2 }, -- Goblin Brew +2    (0.1%)
        },
        cluster = true,
        cw  =
        {
            {                 990, 0                       },
            { cexi.rate.VERY_RARE, xi.item.BEASTMAN_BANNER },
        },
    },
    {
        name = "goblin_giftbox_(medium)",
        loot =
        {
            { cexi.rate.VERY_COMMON,   749, { 1, 2 }        }, -- Mythril Beastcoin  (24%)
            { cexi.rate.COMMON,        511,                 }, -- Goblin Mask        (15%)
            { cexi.rate.COMMON,        510,                 }, -- Goblin Armor       (15%)
            { cexi.rate.UNCOMMON,      750, { 1, 3 }        }, -- Silver Beastcoin   (10%)
            { cexi.rate.UNCOMMON,      748, { 1, 2 }        }, -- Gold Beastcoin     (10%)
            { cexi.rate.UNCOMMON,     1625,                 }, -- Moblin Helm        (10%)
            { cexi.rate.RARE,         4539, { 1, 3 }        }, -- Goblin Pie          (5%)
            { cexi.rate.RARE,         9435,                 }, -- Goblin Brew         (5%)
            { cexi.rate.RARE,         4035,                 }, -- Goblin Commendation (5%)
            { cexi.rate.VERY_RARE,   28490,                 }, -- Wilderness Earring  (1%)
            { cexi.rate.SUPER_RARE,  xi.item.GOBLIN_BREW_P1 }, -- Goblin Brew +1    (0.5%)
            { cexi.rate.ULTRA_RARE,  xi.item.GOBLIN_BREW_P2 }, -- Goblin Brew +2    (0.1%)
        },
        cluster = true,
        cw  =
        {
            {                 990, 0                       },
            { cexi.rate.VERY_RARE, xi.item.BEASTMAN_BANNER },
        },
    },
    {
        name = "goblin_giftbox_(large)",
        loot =
        {
            { cexi.rate.COMMON,      2542,                 }, -- Goblin Mess Tin    (15%)
            { cexi.rate.COMMON,      1631,                 }, -- Moblin Armor       (15%)
            { cexi.rate.UNCOMMON,    1632,                 }, -- Moblin Mail        (10%)
            { cexi.rate.UNCOMMON,     748, { 1, 3 }        }, -- Gold Beastcoin     (10%)
            { cexi.rate.UNCOMMON,     749, { 2, 3 }        }, -- Mythril Beastcoin  (10%)
            { cexi.rate.UNCOMMON,     750, { 2, 3 }        }, -- Silver Beastcoin   (10%)
            { cexi.rate.RARE,         751, { 1, 3 }        }, -- Platinum Beastcoin  (5%)
            { cexi.rate.RARE,        1624,                 }, -- Bugbear Mask        (5%)
            { cexi.rate.RARE,        4325, { 1, 3 }        }, -- Hobgoblin Pie       (5%)
            { cexi.rate.RARE,         511,                 }, -- Goblin Mask         (5%)
            { cexi.rate.RARE,        9435,                 }, -- Goblin Brew         (5%)
            { cexi.rate.RARE,        4035,                 }, -- Goblin Commendation (5%)
            { cexi.rate.VERY_RARE,  27633,                 }, -- Thorin's Shield     (1%)
            { cexi.rate.SUPER_RARE, xi.item.GOBLIN_BREW_P1 }, -- Goblin Brew +1    (0.5%)
            { cexi.rate.ULTRA_RARE, xi.item.GOBLIN_BREW_P2 }, -- Goblin Brew +2    (0.1%)
        },
        cluster = true,
        cw  =
        {
            {                 990, 0                       },
            { cexi.rate.VERY_RARE, xi.item.BEASTMAN_BANNER },
        },
    },
    {
        name = "tiny_tacklebox",
        loot =
        {
            { cexi.rate.VERY_COMMON, 17396, {  5, 15 } }, -- Little Worm           (24%)
            { cexi.rate.COMMON,      17395, {  5, 15 } }, -- Lugworm               (15%)
            { cexi.rate.COMMON,      16996, {  5, 15 } }, -- Sardine Ball          (15%)
            { cexi.rate.COMMON,      16998, {  5, 15 } }, -- Insect Ball           (15%)
            { cexi.rate.UNCOMMON,    14117,            }, -- Rusty Leggings        (10%)
            { cexi.rate.UNCOMMON,    14242,            }, -- Rusty Subligar        (10%)
            { cexi.rate.RARE,         5810, {  2,  4 } }, -- Moat Carp Creel       ( 5%)
            { cexi.rate.RARE,          888, {  2,  3 } }, -- Seashell              ( 5%)
            { cexi.rate.RARE,          792,            }, -- Pearl                 ( 5%)
            { cexi.rate.RARE,         4484,            }, -- Shall Shell           ( 5%)
            { cexi.rate.RARE,        16606,            }, -- Rusty Greatsword      ( 5%)
            { cexi.rate.RARE,         4033,            }, -- Angler's Commendation ( 5%)
            { cexi.rate.ULTRA_RARE,    485,            }, -- Broken Willow Rod     (0.1%)
            { cexi.rate.ULTRA_RARE,    488,            }, -- Broken Fast Rod       (0.1%)
        },
    },
    {
        name = "titanic_tacklebox",
        loot =
        {
            { cexi.rate.VERY_COMMON, 17396, {  5, 15 } }, -- Little Worm           (15%)
            { cexi.rate.COMMON,      16999, {  5, 15 } }, -- Trout Paste           (15%)
            { cexi.rate.COMMON,      17000, {  5, 10 } }, -- Meatball              (15%)
            { cexi.rate.COMMON,      16998, {  5, 15 } }, -- Insect Ball           (15%)
            { cexi.rate.UNCOMMON,    14117,            }, -- Rusty Leggings        (10%)
            { cexi.rate.UNCOMMON,    14242,            }, -- Rusty Subligar        (10%)
            { cexi.rate.RARE,         5810, {  3,  5 } }, -- Moat Carp Creel       ( 5%)
            { cexi.rate.RARE,        16655,            }, -- Rusty Pick            ( 5%)
            { cexi.rate.RARE,          793,            }, -- Black Pearl           ( 5%)
            { cexi.rate.RARE,         4484,            }, -- Shall Shell           ( 5%)
            { cexi.rate.RARE,        19308,            }, -- Rusty Spear           ( 5%)
            { cexi.rate.RARE,         4033,            }, -- Angler's Commendation ( 5%)
            { cexi.rate.ULTRA_RARE,    473,            }, -- Broken Composite Rod  (0.1%)
            { cexi.rate.ULTRA_RARE,    483,            }, -- Broken Mithran Rod    (0.1%)
        },
    },
--[[
    {
        name = "timeworn_tacklebox",
        loot =
        {
            { cexi.rate.VERY_COMMON, 17396, {  5, 15 } }, -- Little Worm           (15%)
            { cexi.rate.COMMON,      16999, {  5, 15 } }, -- Trout Paste           (15%)
            { cexi.rate.COMMON,      17000, {  5, 10 } }, -- Meatball              (15%)
            { cexi.rate.COMMON,      16998, {  5, 15 } }, -- Insect Ball           (15%)
            { cexi.rate.UNCOMMON,     4033,            }, -- Angler's Commendation (10%)
            { cexi.rate.UNCOMMON,    12522,            }, -- Rusty Cap             (10%)
            { cexi.rate.UNCOMMON,    17335,            }, -- Rusty Bolt            (10%)
            { cexi.rate.RARE,         4197,            }, -- Rusty Bolt Case       ( 5%)
            { cexi.rate.RARE,          793,            }, -- Black Pearl           ( 5%)
            { cexi.rate.RARE,         4484,            }, -- Shall Shell           ( 5%)
            { cexi.rate.VERY_RARE,   17006, {  1,  3 } }, -- Drill Calamary        ( 1%)
            { cexi.rate.VERY_RARE,   17007, {  1,  3 } }, -- Dwarf Pugil           ( 1%)
            { cexi.rate.VERY_RARE,    5714,            }, -- Pearlscale            ( 1%)
        },
    },
]]
    {
        name = "goblin_gatherbox",
        loot =
        {
            { cexi.rate.RARE,  641, {  1,  3 } }, -- Tin Ore              ( 5%)
            { cexi.rate.RARE,  642, {  1,  2 } }, -- Zinc Ore             ( 5%)
            { cexi.rate.RARE,  689, {  1,  3 } }, -- Lauan Log            ( 5%)
            { cexi.rate.RARE,  705, {  1,  3 } }, -- Arrowwood Lumber     ( 5%)
            { cexi.rate.RARE,  833, {  1,  2 } }, -- Moko Grass           ( 5%)
            { cexi.rate.RARE,  852, {  1,  2 } }, -- Lizard Skin          ( 5%)
            { cexi.rate.RARE,  856, {  1,  2 } }, -- Rabbit Hide          ( 5%)
            { cexi.rate.RARE,  880, {  1,  3 } }, -- Bone Chip            ( 5%)
            { cexi.rate.RARE, 4378, {  1,  2 } }, -- Selbina Milk         ( 5%)
            { cexi.rate.RARE, 4509, {  1,  3 } }, -- Distilled Water      ( 5%)
            { cexi.rate.RARE,  605, {  2,  4 } }, -- Pickaxe              ( 5%)
            { cexi.rate.RARE, 1020, {  2,  4 } }, -- Sickle               ( 5%)
            { cexi.rate.RARE, 1021, {  2,  4 } }, -- Hatchet              ( 5%)
            { cexi.rate.RARE, 1657, {  2,  3 } }, -- Bundling Twine       ( 5%)
            { cexi.rate.RARE, 2128, {  2,  3 } }, -- Spindle              ( 5%)
            { cexi.rate.RARE, 2130, {  2,  3 } }, -- Shagreen File        ( 5%)
            { cexi.rate.RARE, 2143, {  2,  3 } }, -- Mandrel              ( 5%)
            { cexi.rate.RARE, 2144, {  2,  3 } }, -- Anvil                ( 5%)
            { cexi.rate.RARE, 9434,            }, -- Special Brew         ( 5%)
            { cexi.rate.RARE, 4034,            }, -- Union Commendation   ( 5%)
        },
    },
    {
        name = "hay_bale",
        loot =
        {
            { cexi.rate.COMMON,      817, {  2,  3 } }, -- Grass Thread           (15%)
            { cexi.rate.COMMON,      834, {  1,  3 } }, -- Saruta Cotton          (15%)
            { cexi.rate.COMMON,     2295, {  2,  4 } }, -- Mohbwa Grass           (15%)
            { cexi.rate.UNCOMMON,    832, {  1,  3 } }, -- Sheep Wool             (10%)
            { cexi.rate.UNCOMMON,    835, {  2,  4 } }, -- Flax Flower            (10%)
            { cexi.rate.UNCOMMON,   4034,            }, -- Union Commendation     (10%)
            { cexi.rate.RARE,        838, {  1,  3 } }, -- Spider Web             ( 5%)
            { cexi.rate.RARE,        839, {  1,  4 } }, -- Crawler Cocoon         ( 5%)
            { cexi.rate.RARE,        847, {  1,  6 } }, -- Bird Feather           ( 5%)
            { cexi.rate.RARE,       1524, {  1,  2 } }, -- Fresh Mugwort          ( 5%)
            { cexi.rate.RARE,       2315, {  1,  2 } }, -- Karakul Wool           ( 5%)
            { cexi.rate.VERY_RARE,  2173, {  1,  6 } }, -- Wamoura Cocoon         ( 1%)
            { cexi.rate.VERY_RARE,  1700, {  1,  2 } }, -- Blood Thread           ( 1%)
            { cexi.rate.VERY_RARE,   822, {  1,  3 } }, -- Silver Thread          ( 1%)
            { cexi.rate.VERY_RARE,   823, {  1,  2 } }, -- Gold Thread            ( 1%)
            { cexi.rate.VERY_RARE,  2198, {  1,  3 } }, -- W. Spider's Thread     ( 1%)
        },
    },
    {
        name = "museum_case",
        loot =
        {
            { cexi.rate.COMMON,        880, {  1,  3 } }, -- Bone Chip            (15%)
            { cexi.rate.COMMON,        882, {  1,  3 } }, -- Sheep Tooth          (15%)
            { cexi.rate.COMMON,        864, {  1,  3 } }, -- Fish Scale           (15%)
            { cexi.rate.UNCOMMON,      893, {  1,  2 } }, -- Giant Femur          (10%)
            { cexi.rate.UNCOMMON,      894, {  1,  2 } }, -- Beetle Jaw           (10%)
            { cexi.rate.UNCOMMON,     4034,            }, -- Union Commendation   (10%)
            { cexi.rate.RARE,          887, {  1,  2 } }, -- Coral Fragment       ( 5%)
            { cexi.rate.RARE,          889, {  1,  2 } }, -- Beetle Shell         ( 5%)
            { cexi.rate.RARE,          895, {  1,  2 } }, -- Ram Horn             ( 5%)
            { cexi.rate.RARE,          896, {  1,  2 } }, -- Scorpion Shell       ( 5%)
            { cexi.rate.RARE,          897, {  1,  2 } }, -- Scorpion Claw        ( 5%)
            { cexi.rate.VERY_RARE,     886, {  1,  2 } }, -- Demon Skull          ( 1%)
            { cexi.rate.VERY_RARE,     902, {  1,  2 } }, -- Demon Horn           ( 1%)
            { cexi.rate.VERY_RARE,    1616, {  1,  3 } }, -- Antlion Jaw          ( 1%)
            { cexi.rate.VERY_RARE,    2147, {  1,  3 } }, -- Marid Tusk           ( 1%)
            { cexi.rate.VERY_RARE,    2427, {  1,  3 } }, -- Wivre Maul           ( 1%)
        },
    },
    {
        name = "scrap_lumber",
        loot =
        {
            { cexi.rate.COMMON,        691, {  1,  3 } }, -- Maple Log            (15%)
            { cexi.rate.COMMON,        697, {  1,  2 } }, -- Holly Log            (15%)
            { cexi.rate.COMMON,        698, {  1,  3 } }, -- Ash Log              (15%)
            { cexi.rate.UNCOMMON,      693, {  1,  2 } }, -- Walnut Log           (10%)
            { cexi.rate.UNCOMMON,      695, {  1,  2 } }, -- Willow Log           (10%)
            { cexi.rate.UNCOMMON,     4034,            }, -- Union Commendation   (10%)
            { cexi.rate.RARE,          690, {  1,  2 } }, -- Elm Log              ( 5%)
            { cexi.rate.RARE,          694, {  1,  2 } }, -- Chestnut Log         ( 5%)
            { cexi.rate.RARE,          696, {  1,  2 } }, -- Yew Log              ( 5%)
            { cexi.rate.RARE,          699, {  1,  2 } }, -- Oak Log              ( 5%)
            { cexi.rate.RARE,          721, {  2,  4 } }, -- Rattan Lumber        ( 5%)
            { cexi.rate.VERY_RARE,     700, {  1,  2 } }, -- Mahogany Log         ( 1%)
            { cexi.rate.VERY_RARE,     701, {  1,  2 } }, -- Rosewood Log         ( 1%)
            { cexi.rate.VERY_RARE,     702, {  1,  2 } }, -- Ebony Log            ( 1%)
            { cexi.rate.VERY_RARE,     703, {  1,  2 } }, -- Petrified Log        ( 1%)
            { cexi.rate.VERY_RARE,    2532, {  1,  2 } }, -- Teak Log             ( 1%)
        },
    },
    {
        name = "box_of_rocks",
        loot =
        {
            { cexi.rate.COMMON,        640, {  2,  4 } }, -- Copper Ore           (15%)
            { cexi.rate.COMMON,        768, {  2,  4 } }, -- Flint Stone          (15%)
            { cexi.rate.COMMON,        736, {  1,  3 } }, -- Silver Ore           (15%)
            { cexi.rate.UNCOMMON,      643, {  1,  3 } }, -- Iron Ore             (10%)
            { cexi.rate.UNCOMMON,      644, {  1,  3 } }, -- Mythril Ore          (10%)
            { cexi.rate.UNCOMMON,     4034,            }, -- Union Commendation   (10%)
            { cexi.rate.RARE,         1650, {  1,  2 } }, -- Kopparnickel Ore     ( 5%)
            { cexi.rate.RARE,         2417, {  1,  2 } }, -- Aht Urhgan Brass     ( 5%)
            { cexi.rate.RARE,         2763, {  1,  2 } }, -- Swamp Ore            ( 5%)
            { cexi.rate.RARE,         1225, {  2,  6 } }, -- Gold Nugget          ( 5%)
            { cexi.rate.RARE,         1235, {  2,  6 } }, -- Steel Nugget         ( 5%)
            { cexi.rate.VERY_RARE,     646, {  1,  2 } }, -- Adaman Ore           ( 1%)
            { cexi.rate.VERY_RARE,    1227, {  3,  6 } }, -- Platinum Nugget      ( 1%)
            { cexi.rate.VERY_RARE,    1228, {  3,  6 } }, -- Darksteel Nugget     ( 1%)
            { cexi.rate.VERY_RARE,     678, {  1,  2 } }, -- Aluminum Ore         ( 1%)
            { cexi.rate.VERY_RARE,    2228, {  1,  2 } }, -- Luminium Ore         ( 1%)
        },
    },
}

for _, giftbox in pairs(giftboxes) do
    local path = string.format("xi.items.%s", giftbox.name)

    xi.module.ensureTable(path)

    m:addOverride(path .. ".onItemCheck", function(target)
        local result = 0
        local qty    = 3

        if target:isCrystalWarrior() then
            qty = 4
        end

        if giftbox.cluster then
            qty = qty + 1
        end

        if target:getFreeSlotsCount() < qty then
            result = xi.msg.basic.ITEM_NO_USE_INVENTORY
        end

        return result
    end)

    m:addOverride(path .. ".onItemUse", function(target)
        local qty = math.random(2, 3)

        local result = {}

        for i = 0, qty do
            local item = cexi.util.pickItem(giftbox.loot)

            if type(item[3]) == "table" then
                local roll = math.random(item[3][1], item[3][2])
                table.insert(result, { item[2], roll })
            else
                table.insert(result, { item[2], 1 })
            end
        end

        if
            giftbox.cw ~= nil and
            target:isCrystalWarrior()
        then
            local item = cexi.util.pickItem(giftbox.cw)

            if
                item ~= nil and
                item[2] > 0
            then
                table.insert(result, { item[2], 1 })
            end
        end

        local ID = zones[target:getZoneID()]

        for _, itemInfo in pairs(result) do
            target:addItem(itemInfo[1], itemInfo[2], true)
            target:messageSpecial(ID.text.ITEM_OBTAINED + 9, itemInfo[1], itemInfo[2])
        end

        local cluster = clusters[math.random(1, #clusters)]
        local amount  = math.random(1, 3)

        target:addItem(cluster, amount, true)
        target:messageSpecial(ID.text.ITEM_OBTAINED + 9, cluster, amount)
    end)
end

return m
