-----------------------------------
-- Quality of Life - Adventurer Coupon bonus items
-----------------------------------
require("modules/module_utils")
require("scripts/globals/npc_util")
-----------------------------------

local m = Module:new("qol_coupon")

-- These items will be given out in exchange for Adventurer Coupon
-- (You can also receive them just by speaking to the same NPC)
local qolItems =
{
    xi.item.CHOCOBO_SHIRT,
    xi.item.DESTRIER_BERET,
    xi.item.SPROUT_BERET,
}

local startingGil = 100

local standardDialog =
{
    FULL = "Come back to me when you have more space.",
    GIVE = "Here's something extra to get you started.",
}

local jackDialog =
{
    FULL = "JaCk ReQuEsTs yOu hAvE mOrE sPaCe tO tAKe tHiS.",
    GIVE = "JaCk gIvEs eXTrA rEwArD fOr yOu.",
}

local areas =
{
    {
        name   = "Windurst_Woods",
        npc    = "Jack_of_Spades",
        csid   = 10010,
        talk   = 10009,
        dialog = jackDialog,
    },
    {
        name   = "Port_Windurst",
        npc    = "Jack_of_Clubs",
        csid   = 10008,
        talk   = 10007,
        dialog = jackDialog,
    },
    {
        name   = "Windurst_Waters",
        npc    = "Jack_of_Hearts",
        csid   = 10012,
        talk   = 10011,
        dialog = jackDialog,
    },
    {
        name   = "Windurst_Walls",
        npc    = "Jack_of_Diamonds",
        csid   = 10002,
        talk   = 10001,
        dialog = jackDialog,
    },
    {
        name   = "Southern_San_dOria", -- !pos -8 1 1 230
        npc    = "Ailevia",
        csid   = 655,
        talk   = 615,
        dialog = standardDialog,
    },
    {
        name   = "Northern_San_dOria", -- !pos 7 0 62 231
        npc    = "Matildie",
        csid   = 631,
        talk   = 587,
        dialog = standardDialog,
    },
    {
        name   = "Port_San_dOria",
        npc    = "Teilsa",
        csid   = 612,
        talk   = 573,
        dialog = standardDialog,
    },
    {
        name   = "Bastok_Markets", -- !pos -237 -12 -41 235
        npc    = "Reet",
        csid   = 6,
        talk   = 5,
        dialog = standardDialog,
    },
    {
        name   = "Bastok_Mines",
        npc    = "Arva",
        csid   =  4,
        talk   =  3,
        dialog = standardDialog,
    },
    {
        name   = "Port_Bastok",
        npc    = "Dulsie",
        csid   = 8,
        talk   = 7,
        dialog = standardDialog,
    },
}

local function getMissingStarterItems(player)
    local items = {}

    for _, item in pairs(qolItems) do
        if not player:hasItem(item) then
            table.insert(items, item)
        end
    end

    return items
end

local function giveMissingStarterItems(player, npc, area)
    local missingItems = getMissingStarterItems(player)
    local ID           = zones[player:getZoneID()]

    if #missingItems > 0 then
        if player:getFreeSlotsCount() < #missingItems then
            player:printToPlayer(string.format("%s : " .. area.dialog.FULL, npc:getPacketName()), xi.msg.channel.NS_SAY)
            return false
        end

        player:printToPlayer(string.format("%s : " .. area.dialog.GIVE, npc:getPacketName()), xi.msg.channel.NS_SAY)

        for _, item in pairs(missingItems) do
            player:addUsedItem(item)
            player:messageSpecial(ID.text.ITEM_OBTAINED, item)
        end
    end

    return true
end

for _, area in pairs(areas) do
    local npcPath = string.format("xi.zones.%s.npcs.%s", area.name, area.npc)

    cexi.util.reloadOverride(m, npcPath .. ".onTrigger", function(player, npc)
        if
            not player:isCrystalWarrior() and
            not player:isClassicMode()
        then
            local missingItems = getMissingStarterItems(player)

            if #missingItems > 0 then
                giveMissingStarterItems(player, npc, area)
                return
            end
        end

        player:startEvent(area.talk)
    end)

   cexi.util.reloadOverride(m, npcPath .. ".onEventFinish", function(player, csid, option, npc)
        if csid == area.csid then
            if
                player:isCrystalWarrior() or
                player:isClassicMode()
            then
                player:tradeComplete()
                npcUtil.giveCurrency(player, 'gil', startingGil)
            elseif giveMissingStarterItems(player, npc, area) then
                player:tradeComplete()
                npcUtil.giveCurrency(player, 'gil', startingGil)
            end
        end
    end)
end

return m
