-----------------------------------
-- Crystal Warrior - Provenance System
-----------------------------------
require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local scrying = require("modules/catseyexi/lua/additive_overrides/skills/scrying")
-----------------------------------
local m = Module:new("provenance_mobs")

local BAELFYR   = "Baelfyr"
local GEFRYST   = "Gefyrst"
local UNGEWEDER = "Ungeweder"
local BYRGEN    = "Byrgen"

local baseMob =
{
    [BAELFYR]   = { { 178, 19 }, xi.item.FIRE_CRYSTAL  },
    [GEFRYST]   = { { 178, 20 }, xi.item.ICE_CRYSTAL   },
    [UNGEWEDER] = { { 178, 21 }, xi.item.WIND_CRYSTAL  },
    [BYRGEN]    = { { 178, 22 }, xi.item.EARTH_CRYSTAL },
}

local elementals =
{
    {
        level   = 30,
        respawn = utils.minutes(2),
        prefix  = "Faint",
        essence = { 3, 10 },
        spawns  =
        {
            [BAELFYR]   = { { 627.416, 39.500, -215.482, 235 }, { 678.496, 40.885, -220.790, 140 } },
            [GEFRYST]   = { { 670.795, 40.194, -205.145,  80 }, { 653.564, 40.450, -203.756, 123 } },
            [UNGEWEDER] = { { 638.522, 41.172, -194.417,  30 }, { 631.933, 40.471, -208.253, 221 } },
            [BYRGEN]    = { { 696.822, 41.104, -239.834, 188 }, { 656.106, 42.511, -187.462,  20 } },
        },
    },
    {
        level   = 35,
        large   = true,
        respawn = utils.minutes(1),
        prefix  = "Minor",
        essence = { 10, 20 },
        spawns  =
        {
           [BAELFYR]   = { { 657.392, 41.631, -195.787, 234 } },
           [GEFRYST]   = { { 641.910, 40.451, -209.341, 218 } },
           [UNGEWEDER] = { { 682.085, 40.000, -244.020,  16 } },
           [BYRGEN]    = { { 689.222, 40.048, -211.660, 140 } },
        },
    },
    {
        level   = 40,
        respawn = utils.minutes(2),
        prefix  = "Solid",
        essence = { 20, 25 },
        spawns  =
        {
            [BAELFYR]   = { { -276.554,  0.885, -804.440, 103 }, { -273.941,  0.199, -761.724,  69 } },
            [GEFRYST]   = { { -250.204,  0.528, -758.805, 225 }, { -289.081,  1.551, -787.101, 213 } },
            [UNGEWEDER] = { { -266.134, -0.553, -780.576, 184 }, { -236.238,  1.005, -755.346, 133 } },
            [BYRGEN]    = { { -281.717,  2.675, -748.015, 242 }, { -280.678,  0.116, -799.143, 155 } },
        },
    },
    {
        level   = 45,
        large   = true,
        respawn = utils.minutes(1),
        prefix  = "Large",
        essence = { 25, 35 },
        spawns  =
        {
           [BAELFYR]   = { { -258.607, -1.658, -777.616,  35 } },
           [GEFRYST]   = { { -240.411,  0.658, -770.334,  48 } },
           [UNGEWEDER] = { { -263.924,  1.651, -751.165,  10 } },
           [BYRGEN]    = { { -264.697, -0.101, -770.041, 164 } },
        },
    },
    {
        level   = 50,
        respawn = utils.minutes(2),
        prefix  = "Major",
        essence = { 35, 45 },
        spawns  =
        {
            [BAELFYR]   = { { -201.773,  0.790, -692.612,  92 }, { -160.789, -0.022, -683.612, 226 } },
            [GEFRYST]   = { { -153.952,  1.194, -714.577,  71 }, { -209.800,  2.452, -693.562, 110 } },
            [UNGEWEDER] = { { -184.445,  0.640, -695.549, 225 }, { -168.106,  0.576, -727.910,  92 } },
            [BYRGEN]    = { { -206.481,  1.593, -703.132,  46 }, { -160.062,  1.164, -674.551, 231 } },
        },
    },
    {
        level   = 55,
        large   = true,
        respawn = utils.minutes(1),
        prefix  = "Radial",
        essence = { 45, 55 },
        spawns  =
        {
           [BAELFYR]   = { { -202.311,  0.480, -684.786,  79 } },
           [GEFRYST]   = { { -172.785,  0.471, -690.263,  20 } },
           [UNGEWEDER] = { { -150.145,  1.351, -689.604,  34 } },
           [BYRGEN]    = { { -187.976,  1.104, -676.123,  97 } },
        },
    },
    {
        level   = 60,
        respawn = utils.minutes(2),
        prefix  = "Mystic",
        essence = { 55, 65 },
        spawns  =
        {
            [BAELFYR]   = { { 133.3602, 32.8280, -682.8734, 150 }, { 169.7820, 33.0140, -672.1986,  86 }, { 146.5774, 33.7336, -692.9194, 248 } },
            [GEFRYST]   = { { 145.1992, 33.8849, -672.6122, 100 }, { 165.1633, 32.3211, -686.3758, 249 }, { 124.1722, 32.9785, -684.5054, 115 } },
            [UNGEWEDER] = { { 144.0145, 34.3361, -693.0802, 249 }, { 243.5726, 33.2642, -769.4821, 136 }, { 175.5539, 32.7074, -680.1568,  40 } },
            [BYRGEN]    = { { 147.1561, 34.6155, -708.5895,  46 }, { 166.9375, 32.6420, -706.7799,  63 }, { 165.4558, 32.7534, -676.2227, 213 } },
        },
    },
    {
        level   = 65,
        respawn = utils.minutes(2),
        prefix  = "Divine",
        essence = { 65, 75 },
        spawns  =
        {
            [BAELFYR]   = { { 251.5015, 35.3789, -765.2657, 155 }, { 205.9100, 32.7655, -746.0305, 202 }, { 224.7039, 32.7005, -742.1118, 145 } },
            [GEFRYST]   = { { 254.6976, 36.4000, -773.2029, 190 }, { 205.0229, 32.5275, -750.1413, 219 }, { 245.1639, 33.1255, -720.0803,  50 } },
            [UNGEWEDER] = { { 239.1857, 33.1281, -765.4971, 178 }, { 244.4440, 34.3434, -713.4282,  89 }, { 202.6442, 32.5779, -762.6259, 133 } },
            [BYRGEN]    = { { 242.6125, 32.5883, -754.3751, 221 }, { 215.5155, 32.7871, -753.0705,  70 }, { 254.8194, 36.4000, -705.8015, 248 } },
        },
    },
}

local mobs =
{
    {
        name        = "Crystal Warden",
        groupId     = 47,
        groupZoneId = 270,
        level       = 40,
        notorious   = true,
        respawn     = { utils.minutes(40), utils.minutes(60) },
        drops       =
        {
            { cexi.rate.VERY_COMMON, 3508 },
        },
        essence     = { 400, 500 },
        spawns      =
        {   -- Island I
            { 627.105, 41.200, -196.749,  34 },
            { 688.682, 40.538, -198.105,  89 },
        },
    },
    {
        name        = "Crystal Sentry",
        groupId     = 47,
        groupZoneId = 270,
        level       = 60,
        notorious   = true,
        respawn     = { utils.minutes(40), utils.minutes(60) },
        drops       =
        {
            { cexi.rate.VERY_COMMON, 3508 },
        },
        essence     = { 600, 800 },
        spawns      =
        {   -- Island II
            { -199.100,  0.994, -675.599,  54 },
            { -159.123,  0.297, -727.557, 169 },
            { -188.481, -0.295, -771.400, 158 },
        },
    },
    {
        name        = "Crystal Watcher",
        groupId     = 47,
        groupZoneId = 270,
        level       = 70,
        notorious   = true,
        large       = true,
        respawn     = { utils.minutes(40), utils.minutes(60) },
        drops       =
        {
            { cexi.rate.VERY_COMMON, 3508 },
        },
        essence     = { 800, 999 },
        spawns      =
        {   -- Island III
            {  246.653, 33.567, -736.451, 151 },
            {  219.725, 33.535, -762.842, 145 },
            {  209.430, 33.498, -704.868, 108 },
            {  159.598, 33.106, -725.199, 195 },
        },
    },
    {
        name        = "Primal Harpyria",
        groupId     = 58,
        groupZoneId = 123,
        look        = 2110,
        level       = 80,
        notorious   = true,
        large       = true,
        essence     = { 1501, 1999 },
        respawn     = { utils.hours(9), utils.hours(12) },
        pos         =
        {   -- Island I
            { 638.939, 41.285, -193.526,  21 },
            { 658.494, 39.874, -210.785, 249 },
            { 668.236, 42.025, -190.494, 146 },
            { 624.533, 39.500, -215.632, 244 },

            -- Island II
            { -176.112,  1.101, -678.421,  46 },
            { -179.953, -1.181, -734.665, 175 },
            { -190.695,  0.334, -754.759, 126 },
            { -222.695,  1.253, -752.943, 109 },

            -- Island III
            {  189.190, 32.554, -678.834, 117 },
            {  174.957, 32.998, -726.123, 178 },
            {  193.878, 33.288, -756.586, 206 },
            {  229.652, 32.783, -713.826, 132 },
        },
    },
}

local function distributeEssence(player, essenceAmount)
    local amount  = math.random(essenceAmount[1], essenceAmount[2])
    local balance = player:getCharVar("[CW]ESSENCE")

    player:sys("{} gains {} crystal essence. (Total: {})", player:getName(), amount, balance + amount)
    player:incrementCharVar("[CW]ESSENCE", amount)
end

m:addOverride(string.format("xi.zones.Provenance.Zone.onInitialize", zoneName), function(zone)
    super(zone)

    for mobTier, mobInfo in pairs(elementals) do
        for mobType, mobSpawns in pairs(mobInfo.spawns) do
            for _, mobPos in pairs(mobSpawns) do
                local mobData =
                {
                    name        = string.format("%s %s", mobInfo.prefix, mobType),
                    groupId     = baseMob[mobType][1][2],
                    groupZoneId = baseMob[mobType][1][1],
                    x           = mobPos[1],
                    y           = mobPos[2],
                    z           = mobPos[3],
                    rotation    = mobPos[4],
                    level       = mobInfo.level,
                    respawn     = mobInfo.respawn,
                    drops       =
                    {
                        { cexi.rate.VERY_COMMON, baseMob[mobType][2] },
                    },
                    onMobDeath  = function(mobArg, player, optParams)
                        scrying.spawnShard(zone, mobTier, mobArg:getPos())
                        distributeEssence(player, mobInfo.essence)
                    end,
                }

                if mobInfo.large then
                    mobData.flags = 15
                end

                cexi.util.addDynamicMob(zone, mobData)
            end
        end
    end

    for _, mobInfo in pairs(mobs) do
        if mobInfo.pos ~= nil then
            local spawn = mobInfo.pos[math.random(1, #mobInfo.pos)]

            local mobData =
            {
                name        = mobInfo.name,
                x           = spawn[1],
                y           = spawn[2],
                z           = spawn[3],
                rotation    = spawn[4],
                groupId     = mobInfo.groupId,
                groupZoneId = mobInfo.groupZoneId,
                look        = mobInfo.look,
                level       = mobInfo.level,
                notorious   = mobInfo.notorious,
                respawn     = mobInfo.respawn,
                drops       = mobInfo.drops,
                onMobDeath  = function(mobArg, player, optParams)
                    distributeEssence(player, mobInfo.essence)
                end,
            }

            if mobInfo.large then
                mobData.flags = 15
            end

            cexi.util.addDynamicMob(zone, mobData)

        elseif mobInfo.spawns ~= nil then
            for _, spawn in pairs(mobInfo.spawns) do
                local mobData =
                {
                    name        = mobInfo.name,
                    x           = spawn[1],
                    y           = spawn[2],
                    z           = spawn[3],
                    rotation    = spawn[4],
                    groupId     = mobInfo.groupId,
                    groupZoneId = mobInfo.groupZoneId,
                    look        = mobInfo.look,
                    level       = mobInfo.level,
                    notorious   = mobInfo.notorious,
                    respawn     = mobInfo.respawn,
                    drops       = mobInfo.drops,
                    onMobDeath  = function(mobArg, player, optParams)
                        distributeEssence(player, mobInfo.essence)
                    end,
                }

                if mobInfo.large then
                    mobData.flags = 15
                end

                cexi.util.addDynamicMob(zone, mobData)
            end
        end
    end
end)

return m
