-----------------------------------
-- Crystal Warrior - Provenance System
-----------------------------------
require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local scrying  = require("modules/catseyexi/lua/additive_overrides/skills/scrying")
local lapidary = require("modules/catseyexi/lua/additive_overrides/skills/lapidary")
-----------------------------------
local m = Module:new("provenance_dailies")

local function jadeOnTrigger(player, npc)
    if not xi.settings.main.ENABLE_AOP then
        player:fmt("Nothing happens.")
        return
    end

    npc:facePlayer(player, true)
end

cexi.util.liveReload(m, {
    ["Provenance"] =
    {
        {
            objtype   = xi.objType.NPC,
            name      = "Jade",
            look      = cexi.util.look({
                race  = xi.race.HUME_F,
                face  = 5,
                body  = 441, -- Delegate's Garb
                hand  = 441, -- Delegate's Cuffs
                legs  = 230, -- Dinner Hose
                feet  = 230, -- Dinner Hose
            }),
            x         = -625.136,
            y         = -19.043,
            z         = -525.122,
            rotation  = 126,
            widescan  = 1,
            onTrigger = jadeOnTrigger,
        },
    },
})

return m
