-----------------------------------
-- Crystal Warrior - Provenance System
-----------------------------------
require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local scrying  = require("modules/catseyexi/lua/additive_overrides/skills/scrying")
local lapidary = require("modules/catseyexi/lua/additive_overrides/skills/lapidary")
-----------------------------------
local m = Module:new("provenance_crystals")

local crystal =
{
    ["Provenance_Protocrystal"] =
    {
        [17686586] = { -642.094, -19.747, -509.024, 200 },
        [17686593] = {  472.061,  28.305, -478.178,   0 },
    },
    ["Provenance_Crystal"] =
    {
        [17686585] = {  690.706,  40.288, -249.494, 172 },
        [17686587] = { -643.926, -19.859, -483.743,  30 },
        [17686588] = { -292.483,   4.400, -809.498, 222 },
        [17686589] = { -635.338, -19.879, -474.208,  45 },
        [17686590] = {  112.070,  35.818, -670.879,  27 },
        [17686591] = { -625.911, -20.408, -468.492,  84 },
    },
}

for npcName, npcInfo in pairs(crystal) do
    local path = string.format("xi.zones.Provenance.npcs.%s", npcName)

    xi.module.ensureTable(path)

    m:addOverride(path .. ".onTrigger", function(player, npc)
        if not xi.settings.main.ENABLE_AOP then
            player:fmt("Nothing happens.")
            return
        end

        player:customMenu({
            title   = "Touch the crystal?",
            options =
            {
                {
                    "No",
                    function()
                    end,
                },
                {
                    "Yes",
                    function()
                        player:injectActionPacket(player:getID(), 6, 617, 0, 0, 0, 0, 0)
                        player:injectActionPacket(player:getID(), 6, 600, 0, 0, 0, 0, 0)

                        player:timer(1250, function(playerArg)
                            player:injectActionPacket(player:getID(), 6, 602, 0, 0, 0, 0, 0)
                            player:setPos(unpack(npcInfo[npc:getID()]))
                        end)
                    end,
                },
            },
        })
    end)
end

return m
