-----------------------------------
-- Crystal Warrior (Ametrine) - Transfers NQ augments to HQ
-----------------------------------
require("modules/module_utils")
require('scripts/globals/npc_util')
require("scripts/globals/utils")
-----------------------------------
local m = Module:new("npc_ametrine")

local settings =
{
    name = "Ametrine",
    pos  = { 466.400, 28.650, -471.910, 12 }, -- !pos 466.400 28.650 -471.910 222
}

local function delaySendMenu(player, menuNext)
    local menu = menuNext

    player:timer(200, function(playerArg)
        playerArg:customMenu(menu)
    end)
end

local function onTrade(player, npc, trade)
    for _, categoryInfo in pairs(cexi.crystal_warrior.quest_rewards) do
        for _, itemInfo in pairs(categoryInfo.list) do
            if itemInfo.hq ~= nil then
                if cexi.util.tradeHasExactly(trade, itemInfo.id) then
                    cexi.util.dialog(player, {
                        fmt("Looking to upgrade that {}? First you'll need to acquire the high-quality {} and {}.", itemInfo.name, itemInfo.hq[2], itemInfo.mats[2]),
                        fmt(" Once you have all of these things, bring them to me and I'll infuse the power of that {} into the {}.", itemInfo.name, itemInfo.hq[2]),
                    }, settings.name, { npc = npc } )

                    return
                end

                if cexi.util.tradeHasExactly(trade, { { itemInfo.id, 1 }, { itemInfo.hq[1], 1 } }) then
                    cexi.util.dialog(player, {
                        fmt("Bring together {} along with those two and I'll infuse the power of that {} into the {}.", itemInfo.mats[2], itemInfo.name, itemInfo.hq[2]),
                    }, settings.name, { npc = npc } )

                    return
                end

                if cexi.util.tradeHasExactly(trade, { { itemInfo.id, 1 }, { itemInfo.hq[1], 1 }, itemInfo.mats[1] } ) then
                    delaySendMenu(player, {
                        title   = string.format("Transfer stats to %s?", itemInfo.hq[2]),
                        options =
                        {
                            {
                                "No",
                                function()
                                end,
                            },
                            {
                                "Yes",
                                function()
                                    npc:independentAnimation(player, 4, 2)
                                    cexi.util.augment.transferAugments(player, trade, itemInfo.id, itemInfo.hq[1])
                                end,
                            },
                        },
                    })

                    return
                end
            end
        end
    end
end

cexi.util.liveReload(m, {
    ["Provenance"] =
    {
        {
            objtype  = xi.objType.NPC,
            name     = settings.name,
            look     = cexi.util.look({
                race = xi.race.HUME_F,
                face = 1,
                body = 441, -- Delegate's Garb
                hand = 441, -- Delegate's Cuffs
                legs = 230, -- Dinner Hose
                feet = 230, -- Dinner Hose
            }),
            x        = settings.pos[1],
            y        = settings.pos[2],
            z        = settings.pos[3],
            rotation = settings.pos[4],
            widescan = 1,

            onTrade   = onTrade,

            onTrigger = function(player, npc)
                cexi.util.dialog(player, {
                    "Here to upgrade something?",
                    " Trade a relevant piece and I'll let you know what's required."
                }, settings.name, { npc = npc } )
            end,
        }
    }
})

return m
