----------------------------------------------------
-- Inform players when their party finder status wears off
----------------------------------------------------
require("modules/module_utils")
require("scripts/globals/player")
-----------------------------------
local m = Module:new("party_finder")

m:addOverride("xi.player.onGameIn", function(player, firstLogin, zoning)
    super(player, firstLogin, zoning)

    if
        player:getCharVar("[LFG]Prompt") == 1 and
        player:getCharVar("[LFG]SeekTime") == 0
    then
        player:setCharVar("[LFG]Prompt", 0)
        player:printToPlayer('Reminder: Your party finder status has expired.', xi.msg.channel.SYSTEM_3)
    end
end)

m:addOverride("xi.effects.leavegame.onEffectLose", function(target, effect)
    super(target, effect)

    if target:getCharVar('[LFG]SeekTime') > 0 then
        print('[PartyFinder] Removing ' .. target:getName() .. '\'s registration from the database.')
        
        target:setCharVar('[LFG]Job', 0)
        target:setCharVar('[LFG]Level', 0)
        target:setCharVar('[LFG]SeekTime', 0)

        if target ~= nil then
            target:printToPlayer('Your registration from the Party Finder has been removed.', xi.msg.channel.SYSTEM_3)
        end
    end
end)

return m
