-----------------------------------
-- Ninjutsu Enmity - Elemental Wheel Bonus
-----------------------------------
require("scripts/globals/mobskills")
-----------------------------------
local m = Module:new("ninjutsu_enmity")

local ninjutsu =
{
    { name = 'katon_ichi',  bonusVE = 150, bonusCE = 20, condition = xi.mod.FIRE_MEVA },
    { name = 'katon_ni',    bonusVE = 300, bonusCE = 40, condition = xi.mod.FIRE_MEVA },
    { name = 'katon_san',   bonusVE = 400, bonusCE = 60, condition = xi.mod.FIRE_MEVA },

    { name = 'suiton_ichi', bonusVE = 150, bonusCE = 20, condition = xi.mod.WATER_MEVA },
    { name = 'suiton_ni',   bonusVE = 300, bonusCE = 40, condition = xi.mod.WATER_MEVA },
    { name = 'suiton_san',  bonusVE = 400, bonusCE = 60, condition = xi.mod.WATER_MEVA },

    { name = 'hyoton_ichi', bonusVE = 150, bonusCE = 20, condition = xi.mod.ICE_MEVA },
    { name = 'hyoton_ni',   bonusVE = 300, bonusCE = 40, condition = xi.mod.ICE_MEVA },
    { name = 'hyoton_san',  bonusVE = 400, bonusCE = 60, condition = xi.mod.ICE_MEVA },

    { name = 'huton_ichi',  bonusVE = 150, bonusCE = 20, condition = xi.mod.WIND_MEVA },
    { name = 'huton_ni',    bonusVE = 300, bonusCE = 40, condition = xi.mod.WIND_MEVA },
    { name = 'huton_san',   bonusVE = 400, bonusCE = 60, condition = xi.mod.WIND_MEVA },

    { name = 'doton_ichi',  bonusVE = 150, bonusCE = 20, condition = xi.mod.EARTH_MEVA },
    { name = 'doton_ni',    bonusVE = 300, bonusCE = 40, condition = xi.mod.EARTH_MEVA },
    { name = 'doton_san',   bonusVE = 400, bonusCE = 60, condition = xi.mod.EARTH_MEVA },

    { name = 'raiton_ichi', bonusVE = 150, bonusCE = 20, condition = xi.mod.THUNDER_MEVA },
    { name = 'raiton_ni',   bonusVE = 300, bonusCE = 40, condition = xi.mod.THUNDER_MEVA },
    { name = 'raiton_san',  bonusVE = 400, bonusCE = 60, condition = xi.mod.THUNDER_MEVA },
}

for _, spellInfo in pairs(ninjutsu) do
    m:addOverride(fmt("xi.actions.spells.ninjutsu.{}.onSpellCast", spellInfo.name), function(caster, target, spell)

        if target:hasStatusEffect(xi.effect.NINJUTSU_ELE_DEBUFF) then
            local status   = target:getStatusEffect(xi.effect.NINJUTSU_ELE_DEBUFF)
            local subPower = status:getSubPower()

            if subPower == spellInfo.condition then
                target:addEnmity(caster, spellInfo.bonusCE, spellInfo.bonusVE)
                -- Debug
                -- caster:fmt("Enmity increased: {} CE / {} VE", spellInfo.bonusCE, spellInfo.bonusVE)
            end
        end

        return super(caster, target, spell)
    end)
end

return m
