-----------------------------------
-- Mob Groups
-----------------------------------
require("modules/module_utils")
-----------------------------------
local m = Module:new("mob_groups")

-----------------------------------
-- Regex for logs
-----------------------------------
-- Remove:
-----------------------------------
--[[

\[\d+:\d+:\d+\] 

----== SystemMessage ==----\n

\w+ : !despawnmob\n

]]

-----------------------------------
-- Replace:
-----------------------------------
--[[

Despawned ([A-Za-z_]+) (\d+)\.
            { $2, "$1" },

\w+ : ---end
        },
        {

\w+ : (\([A-Z]-\d+\))
            -- $1

]]

-----------------------------------

local settings =
{
    respawn =
    {
        ["Dynamis-San_dOria"]       = 600, --  10 mins
        ["Dynamis-Bastok"]          = 600, --  10 mins
        ["Dynamis-Windurst"]        = 600, --  10 mins
        ["Dynamis-Jeuno"]           = 600, --  10 mins
        ["Dynamis-Beaucedine"]      = 600, --  10 mins
        ["Dynamis-Xarcabard"]       = 600, --  10 mins
        ["Davoi"]                   = 330, -- 5.5 mins
        ["Monastic_Cavern"]         = 330, -- 5.5 mins
        ["Outer_Horutoto_Ruins"]    = 330, -- 5.5 mins
        ["DEFAULT"]                 = 900, --  15 mins
    },
}

local mobs =
{
    ["Dynamis-San_dOria"] =
    {
        {
            { 17534983, "Vanguard_Vexer" },
            { 17534980, "Vanguard_Footsoldier" },
            -- (M-6)
        },
        {
            { 17534982, "Vanguard_Amputator" },
            { 17534984, "Vanguard_Pillager" },
            -- (L-5)
        },
        {
            { 17534986, "Vanguard_Grappler" },
            { 17534987, "Vanguard_Neckchopper" },
            -- (L-6) fountain 1
        },
        {
            { 17534981, "Vanguard_Trooper" },
            { 17534985, "Vanguard_Mesmerizer" },
            -- (L-6) fountain 2
        },
        {
            { 17534996, "Vanguard_Dollmaster" },
            { 17535017, "Vanguard_Grappler" },
            -- (L-6) fountain 3
        },
        {
            { 17534998, "Vanguard_Vexer" },
            { 17534999, "Vanguard_Predator" },
            -- (L-6) fountain 4
        },
        {
            { 17535008, "Vanguard_Trooper" },
            { 17535001, "Vanguard_Grappler" },
            -- (L-7) fountain stairs
        },
        {
            { 17535000, "Vanguard_Footsoldier" },
            { 17535002, "Vanguard_Predator" },
            -- (L-7) fountain stairs 2
        },
        {
            { 17534990, "Vanguard_Gutslasher" },
            { 17534991, "Vanguard_Impaler" },
            -- (L-6) fountain 5
        },
        {
            { 17534989, "Vanguard_Bugler" },
            { 17534988, "Vanguard_Mesmerizer" },
            -- (L-6) fountain 6
        },
        {
            { 17535019, "Vanguard_Trooper" },
            { 17535020, "Vanguard_Neckchopper" },
            -- (M-7) 
        },
        {
            { 17535021, "Vanguard_Pillager" },
            { 17535018, "Vanguard_Amputator" },
            -- (M-8) 
        },
        {
            { 17535013, "Vanguard_Backstabber" },
            { 17535012, "Vanguard_Footsoldier" },
            -- (L-8)
        },
        {
            { 17535014, "Vanguard_Impaler" },
            { 17535009, "Vanguard_Amputator" },
            -- (K-7)
        },
        {
            { 17535027, "Vanguard_Bugler" },
            { 17535030, "Vanguard_Gutslasher" },
            -- (K-8)
        },
        {
            { 17535147, "Vanguard_Trooper" },
            { 17535152, "Vanguard_Impaler" },
            { 17535148, "Vanguard_Neckchopper" },
        },
        {
            -- (L-9) ER gate 1
            { 17535144, "Vanguard_Footsoldier" },
            { 17535151, "Vanguard_Predator" },
            -- (L-9) ER gate 2
        },
        {
            { 17535145, "Vanguard_Grappler" },
            { 17535149, "Vanguard_Hawker" },
            -- (L-9) ER gate 3
        },
        {
            { 17535159, "Vanguard_Trooper" },
            { 17535164, "Vanguard_Impaler" },
            { 17535156, "Vanguard_Footsoldier" },
            -- (K-10) ER gate 4
        },
        {
            { 17535163, "Vanguard_Predator" },
            { 17535161, "Vanguard_Hawker" },
            -- (K-10) ER gate 5
        },
        {
            { 17535160, "Vanguard_Neckchopper" },
            { 17535158, "Vanguard_Pillager" },
            -- (K-10)
            -- Gate 6
        },
        {
            { 17535034, "Vanguard_Footsoldier" },
            { 17535036, "Vanguard_Pillager" },
            -- (J-9)
        },
        {
            { 17535038, "Vanguard_Neckchopper" },
            { 17535037, "Vanguard_Trooper" },
            -- (J-9) 2
        },
        {
            { 17535042, "Vanguard_Impaler" },
            { 17535041, "Vanguard_Backstabber" },
            { 17535040, "Vanguard_Gutslasher" },
            -- (I-9) AH
        },
        {
            { 17535039, "Vanguard_Predator" },
            { 17535048, "Vanguard_Bugler" },
            -- (I-9) AH 2
        },
        {
            { 17535045, "Vanguard_Amputator" },
            { 17535046, "Vanguard_Mesmerizer" },
            -- (H-9) AH 3
        },
        {
            { 17535176, "Vanguard_Backstabber" },
            { 17535175, "Vanguard_Backstabber" },
            -- (H-10)
            -- Choboco 1
        },
        {
            { 17535177, "Vanguard_Grappler" },
            { 17535181, "Vanguard_Dollmaster" },
            -- (H-10) Chocobo 2
        },
        {
            { 17535178, "Vanguard_Trooper" },
            { 17535179, "Vanguard_Impaler" },
            -- (I-10) Chocobo 3
        },
        {
            { 17535169, "Vanguard_Gutslasher" },
            { 17535168, "Vanguard_Gutslasher" },
            -- (I-10) Chocobo 4
        },
        {
            { 17535170, "Vanguard_Footsoldier" },
            { 17535172, "Vanguard_Neckchopper" },
            -- (I-10) Chocobo 5
        },
        {
            { 17535173, "Vanguard_Hawker" },
            { 17535171, "Vanguard_Pillager" },
            -- (I-10) Chocobo 6
        },
        {
            { 17535132, "Vanguard_Vexer" },
            { 17535133, "Vanguard_Mesmerizer" },
            -- (G-9)
        },
        {
            { 17535134, "Vanguard_Footsoldier" },
            { 17535135, "Vanguard_Pillager" },
            -- (G-9) 2
        },
        {
            { 17535183, "Vanguard_Amputator" },
            { 17535184, "Vanguard_Amputator" },
            -- (G-10) WR gate 1
        },
        {
            { 17535187, "Vanguard_Vexer" },
            { 17535186, "Vanguard_Mesmerizer" },
            -- (G-10) WR gate 2
        },
        {
            { 17535185, "Vanguard_Mesmerizer" },
            { 17535188, "Vanguard_Vexer" },
            { 17535198, "Vanguard_Mesmerizer" },
            -- (G-10) WR gate 3
        },
        {
            { 17535190, "Vanguard_Bugler" },
            { 17535191, "Vanguard_Dollmaster" },
            { 17535189, "Vanguard_Bugler" },
            -- (G-9) WR gate 4
        },
        {
            { 17535202, "Vanguard_Bugler" },
            { 17535201, "Vanguard_Bugler" },
            -- (G-9) WR gate 5
        },
        {
            { 17535196, "Vanguard_Amputator" },
            { 17535195, "Vanguard_Amputator" },
            { 17535203, "Vanguard_Dollmaster" },
            -- (G-9) WR gate 6
        },
        {
            { 17535200, "Vanguard_Vexer" },
            { 17535197, "Vanguard_Mesmerizer" },
            { 17535199, "Vanguard_Vexer" },
            -- (F-9) WR gate 7
        },
        {
            { 17535100, "Vanguard_Bugler" },
            { 17535102, "Vanguard_Backstabber" },
            { 17535103, "Vanguard_Grappler" },
            -- (G-8)
        },
        {
            { 17535098, "Vanguard_Footsoldier" },
            { 17535099, "Vanguard_Amputator" },
            -- (F-8) 
        },
        {
            { 17535104, "Vanguard_Gutslasher" },
            { 17535101, "Vanguard_Predator" },
            -- (F-8) 
        },
        {
            { 17535094, "Vanguard_Hawker" },
            { 17535093, "Vanguard_Predator" },
            -- (F-8)
        },
        {
            { 17535091, "Vanguard_Grappler" },
            { 17535092, "Vanguard_Gutslasher" },
            -- (E-8) 2
        },
        {
            { 17535087, "Vanguard_Neckchopper" },
            { 17535089, "Vanguard_Predator" },
            -- (E-8) LC guild 1
        },
        {
            { 17535085, "Vanguard_Footsoldier" },
            { 17535082, "Vanguard_Gutslasher" },
            -- (D-7) LC guild 2
        },
        {
            { 17535090, "Vanguard_Backstabber" },
            { 17535088, "Vanguard_Bugler" },
            -- (D-7) LC guild 3
        },
        {
            { 17535084, "Vanguard_Trooper" },
            { 17535081, "Vanguard_Pillager" },
            -- (D-7)
        },
        {
            { 17535078, "Vanguard_Bugler" },
            { 17535079, "Vanguard_Grappler" },
            -- (D-6)
        },
        {
            { 17535076, "Vanguard_Hawker" },
            { 17535080, "Vanguard_Mesmerizer" },
            -- (D-6) 2
        },
        {
            { 17535068, "Vanguard_Bugler" },
            { 17535070, "Vanguard_Gutslasher" },
            -- (B-7) manor 1
        },
        {
            { 17535141, "Vanguard_Amputator" },
            { 17535142, "Vanguard_Trooper" },
            { 17535140, "Vanguard_Footsoldier" },
            -- (C-6) manor 2
        },
        {
            { 17535071, "Vanguard_Backstabber" },
            { 17535143, "Vanguard_Gutslasher" },
            -- (C-6) manor 3
        },
        {
            { 17535061, "Vanguard_Mesmerizer" },
            { 17535074, "Vanguard_Dollmaster" },
            { 17535062, "Vanguard_Vexer" },
            -- (C-6) manor 4
        },
        {
            { 17535060, "Vanguard_Amputator" },
            { 17535058, "Vanguard_Footsoldier" },
            { 17535063, "Vanguard_Pillager" },
            -- (C-6) manor 5
        },
        {
            { 17535065, "Vanguard_Neckchopper" },
            { 17535059, "Vanguard_Grappler" },
            -- (C-6) manor 6
        },
        {
            { 17535066, "Vanguard_Hawker" },
            { 17535064, "Vanguard_Trooper" },
            -- (C-6) manor 7
        },
        {
            { 17535112, "Vanguard_Backstabber" },
            { 17535109, "Vanguard_Neckchopper" },
            -- (E-7) well 1
        },
        {
            { 17535106, "Vanguard_Predator" },
            { 17535108, "Vanguard_Vexer" },
            -- (E-7) well 2
        },
        {
            { 17535107, "Vanguard_Mesmerizer" },
            { 17535110, "Vanguard_Dollmaster" },
            -- (E-7) well 3
        },
        {
            { 17535116, "Vanguard_Footsoldier" },
            { 17535118, "Vanguard_Bugler" },
            -- (F-6) 1
        },
        {
            { 17535117, "Vanguard_Amputator" },
            { 17535119, "Vanguard_Predator" },
            -- (F-6) 2
        },
        {
            { 17535122, "Vanguard_Neckchopper" },
            { 17535120, "Vanguard_Predator" },
            -- (G-7)
        },
    },
    ["Dynamis-Bastok"]    =
    {
        {
            { 17539083, "Vanguard_Vindicator" },
            { 17539080, "Vanguard_Purloiner" },
            { 17539078, "Vanguard_Thaumaturge" },
            { 17539081, "Vanguard_Vigilante" },
            -- (J-8)
        },
        {
            { 17539088, "Vanguard_Drakekeeper" },
            { 17539086, "Vanguard_Hatamoto" },
            { 17539076, "Vanguard_Beasttender" },
            -- (I-8)
        },
        {
            { 17539141, "Vanguard_Thaumaturge" },
            { 17539140, "Vanguard_Vigilante" },
            -- AH Stairs 1 (I-8)
        },
        {
            { 17539139, "Vanguard_Thaumaturge" },
            { 17539138, "Vanguard_Vigilante" },
            -- AH Stairs 2 (I-8)
        },
        {
            { 17539136, "Vanguard_Vigilante" },
            { 17539137, "Vanguard_Thaumaturge" },
            -- AH Stairs 3 (H-8)
        },
        {
            { 17539096, "Vanguard_Hatamoto" },
            { 17539090, "Vanguard_Vindicator" },
            { 17539093, "Vanguard_Vigilante" },
            -- (I-9)
        },
        {
            { 17539095, "Vanguard_Mason" },
            { 17539092, "Vanguard_Vigilante" },
            { 17539097, "Vanguard_Kusa" },
            -- (I-9)
        },
        {
            { 17539091, "Vanguard_Militant" },
            { 17539094, "Vanguard_Minstrel" },
            { 17539101, "Vanguard_Constable" },
            -- (H-9)
        },
        {
            { 17539102, "Vanguard_Thaumaturge" },
            { 17539109, "Vanguard_Minstrel" },
            { 17539100, "Vanguard_Protector" },
            { 17539104, "Vanguard_Defender" },
            -- (H-9)
        },
        {
            { 17539105, "Vanguard_Drakekeeper" },
            { 17539107, "Vanguard_Purloiner" },
            { 17539103, "Vanguard_Defender" },
            -- (H-8)
        },
        {
            { 17539116, "Vanguard_Vigilante" },
            { 17539108, "Vanguard_Militant" },
            { 17539110, "Vanguard_Beasttender" },
            -- (H-8)
        },
        {
            { 17539114, "Vanguard_Vindicator" },
            { 17539115, "Vanguard_Militant" },
            -- (H-8)
        },
        {
            { 17539112, "Vanguard_Drakekeeper" },
            { 17539117, "Vanguard_Mason" },
            -- (H-8)
        },
        {
            { 17539185, "Vanguard_Thaumaturge" },
            { 17539186, "Vanguard_Protector" },
            -- (H-7) upstairs behind AH
        },
        {
            { 17539182, "Vanguard_Constable" },
            { 17539181, "Vanguard_Protector" },
            -- (H-6) upstairs
        },
        {
            { 17539179, "Vanguard_Thaumaturge" },
            { 17539180, "Vanguard_Protector" },
            -- (H-6) upstairs same spot
        },
        {
            { 17539150, "Vanguard_Hatamoto" },
            { 17539152, "Vanguard_Hatamoto" },
            { 17539153, "Vanguard_Purloiner" },
            -- (H-6) upstairs
        },
        {
            { 17539151, "Vanguard_Kusa" },
            { 17539154, "Vanguard_Vindicator" },
            -- (H-6) upstairs same spot
        },
        {
            { 17539156, "Vanguard_Kusa" },
            { 17539158, "Vanguard_Vindicator" },
            { 17539155, "Vanguard_Mason" },
            -- (I-6) upstairs
        },
        {
            { 17539279, "Vanguard_Vigilante" },
            { 17539157, "Vanguard_Purloiner" },
            { 17539184, "Vanguard_Defender" },
            -- (I-6) upstairs same spot
        },
        {
            { 17539160, "Vanguard_Mason" },
            { 17539183, "Vanguard_Vigilante" },
            -- (I-7) upstairs
        },
        {
            { 17539169, "Vanguard_Vigilante" },
            { 17539278, "Vanguard_Defender" },
            -- (I-6) upstairs
        },
        {
            { 17539166, "Vanguard_Undertaker" },
            { 17539164, "Vanguard_Drakekeeper" },
            -- (J-6) upstairs
        },
        {
            { 17539174, "Vanguard_Vigilante" },
            { 17539177, "Vanguard_Beasttender" },
            -- (J-6) upstairs alchemy guild
        },
        {
            { 17539288, "Vanguard_Hatamoto" },
            { 17539175, "Vanguard_Vigilante" },
            { 17539176, "Vanguard_Defender" },
            -- (K-6) upstairs alchemy guild 2
        },
        {
            { 17539283, "Vanguard_Minstrel" },
            { 17539291, "Vanguard_Drakekeeper" },
            -- (I-6) upstairs staircase
        },
        {
            { 17539298, "Vanguard_Thaumaturge" },
            { 17539299, "Vanguard_Vigilante" },
            -- (K-7) alchemy guild downstairs
        },
        {
            { 17539297, "Vanguard_Purloiner" },
            { 17539290, "Vanguard_Minstrel" },
            { 17539295, "Vanguard_Hatamoto" },
            -- (J-7) alchemy guild downstairs 2
        },
        {
            { 17539296, "Vanguard_Minstrel" },
            { 17539289, "Vanguard_Kusa" },
            -- (J-7) downstairs
        },
        {
            { 17539282, "Vanguard_Kusa" },
            { 17539284, "Vanguard_Beasttender" },
            -- (I-7)
        },
        {
            { 17539305, "Vanguard_Minstrel" },
            { 17539300, "Vanguard_Vindicator" },
            -- (J-7) dead end downstairs
        },
        {
            { 17539303, "Vanguard_Protector" },
            { 17539302, "Vanguard_Vigilante" },
            -- (J-7) dead end downstairs 2
        },
        {
            { 17539301, "Vanguard_Militant" },
            { 17539304, "Vanguard_Constable" },
            -- (J-7) dead end downstairs 3
        },
        {
            { 17539277, "Vanguard_Purloiner" },
            { 17539270, "Vanguard_Thaumaturge" },
            -- (I-7) downstairs
        },
        {
            { 17539268, "Vanguard_Constable" },
            { 17539269, "Vanguard_Constable" },
            { 17539276, "Vanguard_Purloiner" },
            -- (I-6) downstairs
        },
        {
            { 17539271, "Vanguard_Thaumaturge" },
            { 17539272, "Vanguard_Undertaker" },
            -- (H-6) downstairs
        },
        {
            { 17539262, "Vanguard_Militant" },
            { 17539264, "Vanguard_Vigilante" },
            -- (H-6) downstairs
        },
        {
            { 17539261, "Vanguard_Militant" },
            { 17539265, "Vanguard_Protector" },
            -- (H-6) downstairs
        },
        {
            { 17539131, "Vanguard_Purloiner" },
            { 17539128, "Vanguard_Minstrel" },
            -- (G-5)
        },
        {
            { 17539127, "Vanguard_Defender" },
            { 17539129, "Vanguard_Vindicator" },
            -- (G-6)
        },
        {
            { 17539126, "Vanguard_Vigilante" },
            { 17539123, "Vanguard_Thaumaturge" },
            -- (G-6)
        },
        {
            { 17539122, "Vanguard_Minstrel" },
            { 17539121, "Vanguard_Defender" },
            -- (G-6)
        },
        {
            { 17539124, "Vanguard_Protector" },
            { 17539197, "Vanguard_Beasttender" },
            { 17539191, "Vanguard_Vindicator" },
            -- (G-6) 
        },
        {
            { 17539125, "Vanguard_Constable" },
            { 17539192, "Vanguard_Militant" },
            { 17539195, "Vanguard_Protector" },
            -- (G-7)
        },
        {
            { 17539196, "Vanguard_Defender" },
            { 17539194, "Vanguard_Thaumaturge" },
            -- (F-6)
        },
        {
            { 17539216, "Vanguard_Protector" },
            { 17539193, "Vanguard_Constable" },
            -- (F-7)
        },
        {
            { 17539199, "Vanguard_Drakekeeper" },
            { 17539203, "Vanguard_Minstrel" },
            { 17539202, "Vanguard_Vigilante" },
            -- (F-5)
        },
        {
            { 17539204, "Vanguard_Hatamoto" },
            { 17539211, "Vanguard_Undertaker" },
            { 17539201, "Vanguard_Purloiner" },
            -- (F-5)
        },
        {
            { 17539206, "Vanguard_Mason" },
            { 17539209, "Vanguard_Undertaker" },
            { 17539208, "Vanguard_Kusa" },
            -- (F-5)
        },
        {
            { 17539205, "Vanguard_Minstrel" },
            { 17539207, "Vanguard_Hatamoto" },
            -- (F-5)
        },
        {
            { 17539226, "Vanguard_Defender" },
            { 17539225, "Vanguard_Protector" },
            -- (E-6) ramp
        },
        {
            { 17539220, "Vanguard_Kusa" },
            { 17539215, "Vanguard_Vindicator" },
            -- (E-7)
        },
        {
            { 17539217, "Vanguard_Vigilante" },
            { 17539221, "Vanguard_Kusa" },
            -- (E-7)
        },
        {
            { 17539224, "Vanguard_Minstrel" },
            { 17539219, "Vanguard_Hatamoto" },
            -- (E-7)
        },
        {
            { 17539243, "Vanguard_Constable" },
            { 17539239, "Vanguard_Drakekeeper" },
            { 17539241, "Vanguard_Vindicator" },
            -- (D-7) mines
        },
        {
            { 17539232, "Vanguard_Protector" },
            { 17539242, "Vanguard_Militant" },
            { 17539237, "Vanguard_Beasttender" },
            -- (D-7) mines 2
        },
        {
            { 17539247, "Vanguard_Beasttender" },
            { 17539249, "Vanguard_Drakekeeper" },
            -- (E-7) depot
        },
        {
            { 17539245, "Vanguard_Constable" },
            { 17539244, "Vanguard_Vindicator" },
            -- (E-7) depot 2
        },
        {
            { 17539259, "Vanguard_Militant" },
            { 17539254, "Vanguard_Vindicator" },
            { 17539260, "Vanguard_Protector" },
            -- (G-8) 
        },
        {
            { 17539258, "Vanguard_Vigilante" },
            { 17539256, "Vanguard_Defender" },
            -- (G-8) 2
        },
        {
            { 17539257, "Vanguard_Purloiner" },
            { 17539255, "Vanguard_Vindicator" },
            -- (G-8) 3
        },
    },
    ["Dynamis-Windurst"]  =
    {
        {
            { 17543172, "Vanguard_Skirmisher" },
            { 17543175, "Vanguard_Chanter" },
            -- (D-13)
        },
        {
            { 17543177, "Vanguard_Priest" },
            { 17543174, "Vanguard_Prelate" },
            -- (D-13) 2
        },
        {
            { 17543176, "Vanguard_Sentinel" },
            { 17543179, "Vanguard_Chanter" },
            -- (D-13)
        },
        {
            { 17543182, "Vanguard_Inciter" },
            { 17543178, "Vanguard_Visionary" },
            -- (D-13)
        },
        {
            { 17543180, "Vanguard_Liberator" },
            { 17543181, "Vanguard_Sentinel" },
            -- (D-13)
        },
        {
            { 17543184, "Vanguard_Salvager" },
            { 17543173, "Vanguard_Priest" },
            -- (E-13)
        },
        {
            { 17543183, "Vanguard_Exemplar" },
            { 17543185, "Vanguard_Inciter" },
            -- (E-13)
        },
        {
            { 17543191, "Vanguard_Assassin" },
            { 17543189, "Vanguard_Assassin" },
            -- (E-13)
        },
        {
            { 17543198, "Vanguard_Skirmisher" },
            { 17543201, "Vanguard_Visionary" },
            -- (G-13)
        },
        {
            { 17543196, "Vanguard_Oracle" },
            { 17543199, "Vanguard_Priest" },
            -- (G-13) 2
        },
        {
            { 17543194, "Vanguard_Chanter" },
            { 17543202, "Vanguard_Liberator" },
            -- (G-12)
        },
        {
            { 17543266, "Vanguard_Partisan" },
            { 17543261, "Vanguard_Sentinel" },
            -- (H-11)
        },
        {
            { 17543265, "Vanguard_Liberator" },
            { 17543264, "Vanguard_Visionary" },
            -- (H-12)
        },
        {
            { 17543271, "Vanguard_Persecutor" },
            { 17543274, "Vanguard_Ogresoother" },
            { 17543270, "Vanguard_Salvager" },
            -- (H-12)
        },
        {
            { 17543272, "Vanguard_Oracle" },
            { 17543279, "Vanguard_Assassin" },
            -- (I-12) AH
        },
        {
            { 17543276, "Vanguard_Skirmisher" },
            { 17543280, "Vanguard_Prelate" },
            { 17543277, "Vanguard_Chanter" },
            -- (I-12) AH 2
        },
        {
            { 17543282, "Vanguard_Exemplar" },
            { 17543281, "Vanguard_Exemplar" },
            -- (I-12) AH 3
        },
        {
            { 17543207, "Vanguard_Persecutor" },
            { 17543205, "Vanguard_Chanter" },
            -- (J-14)
        },
        {
            { 17543297, "Vanguard_Inciter" },
            { 17543296, "Vanguard_Exemplar" },
            -- (J-11) on AH
        },
        {
            { 17543293, "Vanguard_Liberator" },
            { 17543292, "Vanguard_Visionary" },
            -- (I-11) on AH 2
        },
        {
            { 17543291, "Vanguard_Sentinel" },
            { 17543290, "Vanguard_Skirmisher" },
            -- (I-11) on AH 3
        },
        {
            { 17543288, "Vanguard_Inciter" },
            { 17543289, "Vanguard_Exemplar" },
            -- (I-11) near top of AH
        },
        {
            { 17543285, "Vanguard_Prelate" },
            { 17543299, "Vanguard_Oracle" },
            -- (H-11) hill near AH
        },
        {
            { 17543313, "Vanguard_Skirmisher" },
            { 17543304, "Vanguard_Priest" },
            { 17543312, "Vanguard_Skirmisher" },
            -- (H-10)
        },
        {
            { 17543309, "Vanguard_Assassin" },
            { 17543303, "Vanguard_Assassin" },
            -- (H-10) 2
        },
        {
            { 17543210, "Vanguard_Skirmisher" },
            { 17543298, "Vanguard_Prelate" },
            -- (H-10) 3
        },
        {
            { 17543308, "Vanguard_Exemplar" },
            { 17543314, "Vanguard_Persecutor" },
            -- (H-10) 4
        },
        {
            { 17543307, "Vanguard_Liberator" },
            { 17543302, "Vanguard_Chanter" },
            { 17543310, "Vanguard_Ogresoother" },
            -- (H-10) 5
        },
        {
            { 17543301, "Vanguard_Salvager" },
            { 17543209, "Vanguard_Salvager" },
            -- (I-10)
        },
        {
            { 17543211, "Vanguard_Exemplar" },
            { 17543212, "Vanguard_Skirmisher" },
            -- (I-10) 2
        },
        {
            { 17543358, "Vanguard_Sentinel" },
            { 17543319, "Vanguard_Sentinel" },
            { 17543318, "Vanguard_Prelate" },
            -- (I-9)
        },
        {
            { 17543320, "Vanguard_Liberator" },
            { 17543315, "Vanguard_Skirmisher" },
            -- (I-9) 2
        },
        {
            { 17543316, "Vanguard_Priest" },
            { 17543317, "Vanguard_Visionary" },
            -- (I-9) 3
        },
        {
            { 17543321, "Vanguard_Priest" },
            { 17543322, "Vanguard_Visionary" },
            -- (J-9)
        },
        {
            { 17543325, "Vanguard_Sentinel" },
            { 17543327, "Vanguard_Liberator" },
            -- (J-9) 2
        },
        {
            { 17543323, "Vanguard_Prelate" },
            { 17543328, "Vanguard_Visionary" },
            { 17543324, "Vanguard_Skirmisher" },
            -- (J-9) 3
        },
        {
            { 17543213, "Vanguard_Salvager" },
            { 17543331, "Vanguard_Inciter" },
            -- (J-8) tiny bridge
        },
        {
            { 17543329, "Vanguard_Exemplar" },
            { 17543332, "Vanguard_Ogresoother" },
            -- (J-8)
        },
        {
            { 17543330, "Vanguard_Inciter" },
            { 17543334, "Vanguard_Assassin" },
            -- (J-7)
        },
        {
            { 17543337, "Vanguard_Oracle" },
            { 17543335, "Vanguard_Persecutor" },
            { 17543339, "Vanguard_Partisan" },
            -- (J-7)
        },
        {
            { 17543344, "Vanguard_Chanter" },
            { 17543343, "Vanguard_Priest" },
            -- (K-7) on house
        },
        {
            { 17543348, "Vanguard_Persecutor" },
            { 17543346, "Vanguard_Exemplar" },
            -- (J-6)
        },
        {
            { 17543359, "Vanguard_Persecutor" },
            { 17543360, "Vanguard_Partisan" },
            -- (K-6)
        },
        {
            { 17543349, "Vanguard_Skirmisher" },
            { 17543351, "Vanguard_Oracle" },
            { 17543356, "Vanguard_Chanter" },
            -- (K-6) 2
        },
        {
            { 17543355, "Vanguard_Priest" },
            { 17543350, "Vanguard_Visionary" },
            -- (K-6) 3
        },
        {
            { 17543365, "Vanguard_Liberator" },
            { 17543366, "Vanguard_Inciter" },
            -- (J-5)
        },
        {
            { 17543373, "Vanguard_Priest" },
            { 17543374, "Vanguard_Chanter" },
            -- (K-5) on house
        },
        {
            { 17543427, "Vanguard_Persecutor" },
            { 17543428, "Vanguard_Assassin" },
            -- (H-4)
        },
        {
            { 17543441, "Vanguard_Persecutor" },
            { 17543434, "Vanguard_Chanter" },
            { 17543438, "Vanguard_Assassin" },
            -- (I-4) under the bridge
        },
        {
            { 17543439, "Vanguard_Assassin" },
            { 17543440, "Vanguard_Chanter" },
            -- (I-3)
        },
        {
            { 17543430, "Vanguard_Salvager" },
            { 17543429, "Vanguard_Salvager" },
            -- (H-3) over {Toraimarai Canal}
        },
        {
            { 17543424, "Vanguard_Oracle" },
            { 17543426, "Vanguard_Chanter" },
            -- (H-4)
        },
        {
            { 17543415, "Vanguard_Partisan" },
            { 17543417, "Vanguard_Chanter" },
            -- (H-4)
        },
        {
            { 17543413, "Vanguard_Persecutor" },
            { 17543414, "Vanguard_Chanter" },
            -- (G-4) 2
        },
        {
            { 17543223, "Vanguard_Visionary" },
            { 17543221, "Vanguard_Assassin" },
            { 17543220, "Vanguard_Salvager" },
            -- (G-4) bridge
        },
        {
            { 17543401, "Vanguard_Visionary" },
            { 17543397, "Vanguard_Priest" },
            { 17543400, "Vanguard_Visionary" },
            -- (F-5)
        },
        {
            { 17543399, "Vanguard_Prelate" },
            { 17543398, "Vanguard_Prelate" },
            -- (F-5) 2
        },
        {
            { 17543405, "Vanguard_Liberator" },
            { 17543226, "Vanguard_Liberator" },
            { 17543402, "Vanguard_Skirmisher" },
            -- (F-5) 3
        },
        {
            { 17543403, "Vanguard_Sentinel" },
            { 17543404, "Vanguard_Liberator" },
            -- (F-5) 4
        },
        {
            { 17543381, "Vanguard_Visionary" },
            { 17543388, "Vanguard_Liberator" },
            -- (F-6)
        },
        {
            { 17543383, "Vanguard_Sentinel" },
            { 17543382, "Vanguard_Sentinel" },
            -- (F-7)
        },
        {
            { 17543245, "Vanguard_Assassin" },
            { 17543246, "Vanguard_Persecutor" },
            -- (D-6)
        },
        {
            { 17543255, "Vanguard_Chanter" },
            { 17543256, "Vanguard_Partisan" },
            -- (D-6) 
        },
        {
            { 17543254, "Vanguard_Prelate" },
            { 17543253, "Vanguard_Priest" },
            -- (D-6) 2
        },
        {
            { 17543252, "Vanguard_Sentinel" },
            { 17543251, "Vanguard_Skirmisher" },
            -- (D-6) 3
        },
        {
            { 17543389, "Vanguard_Priest" },
            { 17543379, "Vanguard_Priest" },
            -- (F-7)
        },
        {
            { 17543378, "Vanguard_Skirmisher" },
            { 17543377, "Vanguard_Skirmisher" },
            -- (F-7) 2
        },
        {
            { 17543376, "Vanguard_Salvager" },
            { 17543380, "Vanguard_Prelate" },
            -- (F-8)
        },
        {
            { 17543228, "Vanguard_Sentinel" },
            { 17543206, "Vanguard_Sentinel" },
            -- (F-9) 
        },
        {
            { 17543227, "Vanguard_Liberator" },
            { 17543229, "Vanguard_Partisan" },
            { 17543231, "Vanguard_Exemplar" },
            -- (F-9) 2
        },
        {
            { 17543234, "Vanguard_Inciter" },
            { 17543232, "Vanguard_Inciter" },
            -- (F-9)
        },
        {
            { 17543233, "Vanguard_Exemplar" },
            { 17543239, "Vanguard_Ogresoother" },
            -- (G-10)
        },
        {
            { 17543241, "Vanguard_Partisan" },
            { 17543237, "Vanguard_Partisan" },
            -- (G-10) 2
        },
        {
            { 17543249, "Vanguard_Assassin" },
            { 17543250, "Vanguard_Persecutor" },
            -- (G-7)
        },
        {
            { 17543452, "Vanguard_Liberator" },
            { 17543450, "Vanguard_Prelate" },
            -- (H-5)
        },
    },
    ["Dynamis-Jeuno"]     =
    {
        {
            { 17547266, "Vanguard_Smithy" },
            { 17547268, "Vanguard_Pathfinder" },
            -- (I-9) near MH
        },
        {
            { 17547270, "Vanguard_Shaman" },
            { 17547293, "Vanguard_Hitman" },
            -- (I-9) near MH under bridge
        },
        {
            { 17547278, "Vanguard_Pitfighter" },
            { 17547274, "Vanguard_Tinkerer" },
            -- (H-9) fountain 1
        },
        {
            { 17547267, "Vanguard_Welldigger" },
            { 17547275, "Vanguard_Armorer" },
            -- (H-9) fountain 2
        },
        {
            { 17547281, "Vanguard_Tinkerer" },
            { 17547280, "Vanguard_Maestro" },
            -- (H-9) fountain 3
        },
        {
            { 17547289, "Vanguard_Armorer" },
            { 17547286, "Vanguard_Necromancer" },
            { 17547285, "Vanguard_Ambusher" },
            -- (H-9) fountain 4
        },
        {
            { 17547288, "Vanguard_Ronin" },
            { 17547290, "Vanguard_Hitman" },
            -- (H-9) fountain 5
        },
        {
            { 17547282, "Vanguard_Dragontamer" },
            { 17547284, "Vanguard_Enchanter" },
            -- (H-9) fountain 6
        },
        {
            { 17547279, "Vanguard_Alchemist" },
            { 17547292, "Vanguard_Armorer" },
            -- (H-9) fountain 7
        },
        {
            { 17547271, "Vanguard_Enchanter" },
            { 17547320, "Vanguard_Shaman" },
            { 17547319, "Vanguard_Alchemist" },
            -- (H-8) in front of palace 1
        },
        {
            { 17547325, "Vanguard_Welldigger" },
            { 17547315, "Vanguard_Pitfighter" },
            { 17547321, "Vanguard_Enchanter" },
            -- (H-8) in front of palace 2
        },
        {
            { 17547326, "Vanguard_Maestro" },
            { 17547327, "Vanguard_Necromancer" },
            -- (H-8) in front of palace 3
        },
        {
            { 17547314, "Vanguard_Smithy" },
            { 17547316, "Vanguard_Ronin" },
            -- (I-8)
        },
        {
            { 17547309, "Vanguard_Welldigger" },
            { 17547304, "Vanguard_Smithy" },
            -- (I-8) 2
        },
        {
            { 17547307, "Vanguard_Armorer" },
            { 17547310, "Vanguard_Enchanter" },
            -- (I-8) 3
        },
        {
            { 17547317, "Vanguard_Necromancer" },
            { 17547308, "Vanguard_Alchemist" },
            -- (I-8) 4
        },
        {
            { 17547383, "Vanguard_Ronin" },
            { 17547385, "Vanguard_Alchemist" },
            -- (I-9)
        },
        {
            { 17547386, "Vanguard_Maestro" },
            { 17547380, "Vanguard_Alchemist" },
            -- (I-9) on bridge
        },
        {
            { 17547379, "Vanguard_Smithy" },
            { 17547376, "Vanguard_Tinkerer" },
            -- (I-9) on bridge 2
        },
        {
            { 17547384, "Vanguard_Hitman" },
            { 17547375, "Vanguard_Pitfighter" },
            -- (I-9) on bridge 3
        },
        {
            { 17547372, "Vanguard_Shaman" },
            { 17547373, "Vanguard_Necromancer" },
            -- (I-10) upstairs 1
        },
        {
            { 17547369, "Vanguard_Pathfinder" },
            { 17547368, "Vanguard_Hitman" },
            -- (I-10) upstairs 2
        },
        {
            { 17547371, "Vanguard_Armorer" },
            { 17547367, "Vanguard_Ronin" },
            -- (I-10) upstairs 3
        },
        {
            { 17547364, "Vanguard_Armorer" },
            { 17547363, "Vanguard_Smithy" },
            -- (H-10) near UJ 1
        },
        {
            { 17547365, "Vanguard_Pathfinder" },
            { 17547361, "Vanguard_Tinkerer" },
            -- (H-10) near UJ 2
        },
        {
            { 17547357, "Vanguard_Smithy" },
            { 17547360, "Vanguard_Welldigger" },
            { 17547362, "Vanguard_Ambusher" },
            -- (G-10)
        },
        {
            { 17547352, "Vanguard_Tinkerer" },
            { 17547350, "Vanguard_Pitfighter" },
            -- (G-10) 2
        },
        {
            { 17547359, "Vanguard_Maestro" },
            { 17547358, "Vanguard_Shaman" },
            -- (G-10) 3
        },
        {
            { 17547353, "Vanguard_Armorer" },
            { 17547354, "Vanguard_Hitman" },
            { 17547348, "Vanguard_Dragontamer" },
            -- (G-9)
        },
        {
            { 17547347, "Vanguard_Ambusher" },
            { 17547346, "Vanguard_Ambusher" },
            -- (G-9) 2
        },
        {
            { 17547345, "Vanguard_Maestro" },
            { 17547344, "Vanguard_Enchanter" },
            -- (G-9) 3
        },
        {
            { 17547340, "Vanguard_Ambusher" },
            { 17547343, "Vanguard_Pitfighter" },
            -- (G-9) 4
        },
        {
            { 17547339, "Vanguard_Welldigger" },
            { 17547341, "Vanguard_Pathfinder" },
            -- (G-8)
        },
        {
            { 17547335, "Vanguard_Shaman" },
            { 17547331, "Vanguard_Maestro" },
            { 17547332, "Vanguard_Dragontamer" },
            -- (H-8) 2
        },
        {
            { 17547334, "Vanguard_Alchemist" },
            { 17547336, "Vanguard_Enchanter" },
            -- (H-8)
        },
        {
            { 17547405, "Vanguard_Welldigger" },
            { 17547400, "Vanguard_Welldigger" },
            { 17547410, "Vanguard_Welldigger" },
            -- (G-8) AH 1
        },
        {
            { 17547399, "Vanguard_Pitfighter" },
            { 17547404, "Vanguard_Pitfighter" },
            { 17547409, "Vanguard_Pitfighter" },
            -- (G-8) AH 2
        },
        {
            { 17547401, "Vanguard_Alchemist" },
            { 17547412, "Vanguard_Alchemist" },
            -- (G-8) AH 3
        },
        {
            { 17547403, "Vanguard_Smithy" },
            { 17547408, "Vanguard_Smithy" },
            { 17547398, "Vanguard_Smithy" },
            -- (G-8) AH 4
        },
        {
            { 17547406, "Vanguard_Shaman" },
            { 17547411, "Vanguard_Enchanter" },
            { 17547413, "Vanguard_Shaman" },
            -- (G-8) AH 5
        },
        {
            { 17547419, "Vanguard_Welldigger" },
            { 17547418, "Vanguard_Enchanter" },
            { 17547414, "Vanguard_Smithy" },
            -- (G-9) downstairs AH 1
        },
        {
            { 17547417, "Vanguard_Shaman" },
            { 17547416, "Vanguard_Alchemist" },
            -- (G-9) downstairs AH 2
        },
        {
            { 17547425, "Vanguard_Tinkerer" },
            { 17547449, "Vanguard_Tinkerer" },
            -- (H-7) palace 1
        },
        {
            { 17547450, "Vanguard_Pathfinder" },
            { 17547442, "Vanguard_Ronin" },
            { 17547452, "Vanguard_Dragontamer" },
            -- (H-7) palace 2
        },
        {
            { 17547426, "Vanguard_Dragontamer" },
            { 17547428, "Vanguard_Pathfinder" },
            -- (H-7) palace 3
        },
        {
            { 17547433, "Vanguard_Maestro" },
            { 17547430, "Vanguard_Maestro" },
            -- (H-7) palace 4
        },
        {
            { 17547431, "Vanguard_Ronin" },
            { 17547432, "Vanguard_Armorer" },
            -- (H-7) palace 5
        },
        {
            { 17547434, "Vanguard_Tinkerer" },
            { 17547435, "Vanguard_Ronin" },
            -- (H-6) palace 6
        },
        {
            { 17547447, "Vanguard_Armorer" },
            { 17547446, "Vanguard_Ronin" },
            -- (H-7) palace 7
        },
        {
            { 17547448, "Vanguard_Maestro" },
            { 17547445, "Vanguard_Maestro" },
            -- (H-7) palace 8
        },
        {
            { 17547443, "Vanguard_Necromancer" },
            { 17547441, "Vanguard_Tinkerer" },
            -- (H-6) palace 9
        },
        {
            { 17547469, "Vanguard_Smithy" },
            { 17547471, "Vanguard_Welldigger" },
            { 17547483, "Vanguard_Pathfinder" },
            -- (H-5)  Maat 1
        },
        {
            { 17547475, "Vanguard_Alchemist" },
            { 17547470, "Vanguard_Pitfighter" },
            { 17547481, "Vanguard_Armorer" },
            -- (H-5) Maat 2
        },
        {
            { 17547489, "Vanguard_Ambusher" },
            { 17547477, "Vanguard_Enchanter" },
            { 17547476, "Vanguard_Shaman" },
            { 17547482, "Vanguard_Tinkerer" },
            -- (H-5) Maat 3
        },
        {
            { 17547465, "Vanguard_Ambusher" },
            { 17547464, "Vanguard_Hitman" },
            { 17547466, "Vanguard_Hitman" },
            -- (H-7) upstairs 1
        },
        {
            { 17547463, "Vanguard_Ambusher" },
            { 17547461, "Vanguard_Ambusher" },
            { 17547462, "Vanguard_Hitman" },
            -- (H-7) upstairs 2
        },
        {
            { 17547414, "Vanguard_Smithy" },
            { 17547415, "Vanguard_Pitfighter" },
        },
        {
            { 17547315, "Vanguard_Pitfighter" },
            { 17547276, "Vanguard_Hitman" },
        },
        {
            { 17547354, "Vanguard_Hitman" },
            { 17547351, "Vanguard_Alchemist" },
        },
        {
            { 17547354, "Vanguard_Hitman" },
            { 17547351, "Vanguard_Alchemist" },
        },
    },
    ["Dynamis-Beaucedine"] =
    {
        {
            { 17326396, "Vanguard_Shaman" },
            { 17326395, "Vanguard_Shaman" },
        },
        {
            { 17326399, "Vanguard_Enchanter" },
            { 17326400, "Vanguard_Enchanter" },
        },
        {
            { 17326408, "Vanguard_Welldigger" },
            { 17326409, "Vanguard_Welldigger" },
        },
        {
            { 17326413, "Vanguard_Armorer" },
            { 17326414, "Vanguard_Armorer" },
        },
        {
            { 17326425, "Vanguard_Tinkerer" },
            { 17326426, "Vanguard_Tinkerer" },
        },
        {
            { 17326430, "Vanguard_Pitfighter" },
            { 17326429, "Vanguard_Pitfighter" },
        },
        {
            { 17326431, "Vanguard_Alchemist" },
            { 17326432, "Vanguard_Alchemist" },
        },
        {
            { 17326434, "Vanguard_Maestro" },
            { 17326435, "Vanguard_Dragontamer" },
        },
        {
            { 17326441, "Vanguard_Armorer" },
            { 17326442, "Vanguard_Shaman" },
        },
        {
            { 17326451, "Vanguard_Maestro" },
            { 17326450, "Vanguard_Maestro" },
        },
        {
            { 17326461, "Vanguard_Ronin" },
            { 17326462, "Vanguard_Ronin" },
        },
        {
            { 17326417, "Vanguard_Pathfinder" },
            { 17326419, "Vanguard_Dragontamer" },
        },
        {
            { 17326338, "Vanguard_Salvager" },
            { 17326339, "Vanguard_Salvager" },
        },
        {
            { 17326334, "Vanguard_Chanter" },
            { 17326333, "Vanguard_Chanter" },
        },
        {
            { 17326321, "Vanguard_Inciter" },
            { 17326322, "Vanguard_Inciter" },
        },
        {
            { 17326294, "Vanguard_Priest" },
            { 17326293, "Vanguard_Priest" },
        },
        {
            { 17326312, "Vanguard_Liberator" },
            { 17326301, "Vanguard_Skirmisher" },
        },
        {
            { 17326303, "Vanguard_Visionary" },
            { 17326305, "Vanguard_Partisan" },
        },
        {
            { 17326288, "Vanguard_Sentinel" },
            { 17326287, "Vanguard_Sentinel" },
        },
        {
            { 17326283, "Vanguard_Skirmisher" },
            { 17326282, "Vanguard_Skirmisher" },
        },
        {
            { 17326518, "Hydra_Red_Mage" },
            { 17326523, "Hydra_Red_Mage" },
        },
        {
            { 17326511, "Hydra_Samurai" },
            { 17326513, "Hydra_Samurai" },
        },
        {
            { 17326537, "Hydra_Paladin" },
            { 17326538, "Hydra_Warrior" },
        },
        {
            { 17326101, "Vanguard_Protector" },
            { 17326102, "Vanguard_Protector" },
        },
        {
            { 17326100, "Vanguard_Vindicator" },
            { 17326111, "Vanguard_Drakekeeper" },
        },
        {
            { 17326117, "Vanguard_Protector" },
            { 17326115, "Vanguard_Constable" },
        },
        {
            { 17326488, "Hydra_Samurai" },
            { 17326489, "Hydra_Samurai" },
        },
        {
            { 17326498, "Hydra_Ninja" },
            { 17326497, "Hydra_Ninja" },
        },
        {
            { 17326492, "Hydra_Dragoon" },
            { 17326503, "Hydra_Dragoon" },
        },
        {
            { 17326495, "Hydra_Samurai" },
            { 17326496, "Hydra_Samurai" },
        },
        {
            { 17326122, "Vanguard_Mason" },
            { 17326123, "Vanguard_Mason" },
        },
        {
            { 17326127, "Vanguard_Militant" },
            { 17326155, "Vanguard_Protector" },
        },
        {
            { 17326141, "Vanguard_Constable" },
            { 17326142, "Vanguard_Constable" },
        },
        {
            { 17326169, "Vanguard_Vindicator" },
            { 17326149, "Vanguard_Vindicator" },
        },
        {
            { 17326171, "Vanguard_Defender" },
            { 17326172, "Vanguard_Defender" },
        },
        {
            { 17326167, "Vanguard_Militant" },
            { 17326166, "Vanguard_Militant" },
        },
        {
            { 17326160, "Vanguard_Hatamoto" },
            { 17326159, "Vanguard_Hatamoto" },
        },
        {
            { 17326132, "Vanguard_Vindicator" },
            { 17326131, "Vanguard_Vindicator" },
        },
        {
            { 17326175, "Vanguard_Purloiner" },
            { 17326174, "Vanguard_Purloiner" },
        },
        {
            { 17326183, "Vanguard_Mason" },
            { 17326184, "Vanguard_Mason" },
        },
        {
            { 17326182, "Vanguard_Hatamoto" },
            { 17326188, "Vanguard_Hatamoto" },
        },
        {
            { 17326189, "Vanguard_Hatamoto" },
            { 17326186, "Vanguard_Constable" },
        },
        {
            { 17326187, "Vanguard_Thaumaturge" },
            { 17326196, "Vanguard_Thaumaturge" },
        },
        {
            { 17326194, "Vanguard_Kusa" },
            { 17326192, "Vanguard_Militant" },
        },
        {
            { 17326211, "Vanguard_Footsoldier" },
            { 17326210, "Vanguard_Footsoldier" },
        },
        {
            { 17326214, "Vanguard_Vexer" },
            { 17326213, "Vanguard_Vexer" },
        },
        {
            { 17326222, "Vanguard_Amputator" },
            { 17326221, "Vanguard_Amputator" },
        },
        {
            { 17326228, "Vanguard_Predator" },
            { 17326227, "Vanguard_Predator" },
        },
        {
            { 17326235, "Vanguard_Vexer" },
            { 17326236, "Vanguard_Vexer" },
        },
        {
            { 17326241, "Vanguard_Pillager" },
            { 17326244, "Vanguard_Pillager" },
        },
        {
            { 17326246, "Vanguard_Trooper" },
            { 17326247, "Vanguard_Trooper" },
        },
        {
            { 17326249, "Vanguard_Neckchopper" },
            { 17326256, "Vanguard_Neckchopper" },
        },
        {
            { 17326252, "Vanguard_Dollmaster" },
            { 17326251, "Vanguard_Bugler" },
        },
        {
            { 17326267, "Vanguard_Bugler" },
            { 17326268, "Vanguard_Bugler" },
        },
        {
            { 17326261, "Vanguard_Mesmerizer" },
            { 17326260, "Vanguard_Mesmerizer" },
        },
        {
            { 17326562, "Hydra_Warrior" },
            { 17326559, "Hydra_Warrior" },
        },
        {
            { 17326560, "Hydra_White_Mage" },
            { 17326563, "Hydra_White_Mage" },
        },
        {
            { 17326571, "Hydra_Monk" },
            { 17326568, "Hydra_Monk" },
        },
        {
            { 17326570, "Hydra_Ninja" },
            { 17326567, "Hydra_Ninja" },
        },
        {
            { 17326574, "Hydra_Black_Mage" },
            { 17326577, "Hydra_Black_Mage" },
        },
        {
            { 17326576, "Hydra_White_Mage" },
            { 17326573, "Hydra_White_Mage" },
        },
        {
            { 17326599, "Hydra_Thief" },
            { 17326597, "Hydra_Thief" },
        },
        {
            { 17326592, "Hydra_Ranger" },
            { 17326590, "Hydra_Ranger" },
        },
        {
            { 17326581, "Hydra_Dark_Knight" },
            { 17326583, "Hydra_Dark_Knight" },
        },
        {
            { 17326598, "Hydra_Paladin" },
            { 17326596, "Hydra_Paladin" },
        },
        {
            { 17326385, "Vanguard_Alchemist" },
            { 17326386, "Vanguard_Alchemist" },
        },
        {
            { 17326378, "Vanguard_Pitfighter" },
            { 17326377, "Vanguard_Pitfighter" },
        },
        {
            { 17326372, "Vanguard_Smithy" },
            { 17326373, "Vanguard_Smithy" },
        },
        {
            { 17326362, "Vanguard_Welldigger" },
            { 17326367, "Vanguard_Ambusher" },
        },
        {
            { 17326361, "Vanguard_Enchanter" },
            { 17326357, "Vanguard_Enchanter" },
        },
        {
            { 17326608, "Hydra_Warrior" },
            { 17326609, "Hydra_Warrior" },
        },
        {
            { 17326603, "Hydra_Beastmaster" },
            { 17326601, "Hydra_Beastmaster" },
        },
        {
            { 17326619, "Hydra_Monk" },
            { 17326618, "Hydra_Monk" },
        },
        {
            { 17326613, "Hydra_White_Mage" },
            { 17326614, "Hydra_White_Mage" },
        },
        {
            { 17326625, "Hydra_Black_Mage" },
            { 17326624, "Hydra_Black_Mage" },
        },
        {
            { 17326631, "Hydra_Red_Mage" },
            { 17326630, "Hydra_Red_Mage" },
        },
        {
            { 17326635, "Hydra_Thief" },
            { 17326636, "Hydra_Thief" },
        },
        {
            { 17326648, "Hydra_Paladin" },
            { 17326647, "Hydra_Paladin" },
        },
        {
            { 17326642, "Hydra_Dragoon" },
            { 17326640, "Hydra_Dragoon" },
        },
        {
            { 17326653, "Hydra_Dark_Knight" },
            { 17326652, "Hydra_Dark_Knight" },
        },
        {
            { 17326674, "Hydra_Samurai" },
            { 17326675, "Hydra_Samurai" },
        },
        {
            { 17326680, "Hydra_Ninja" },
            { 17326679, "Hydra_Ninja" },
        },
        {
            { 17326669, "Hydra_Ranger" },
            { 17326670, "Hydra_Ranger" },
        },
        {
            { 17326768, "Hydra_Ninja" },
            { 17326766, "Hydra_Warrior" },
        },
    },
    ["Dynamis-Xarcabard"]  =
    {
        {
            { 17330218, "Kindred_Dark_Knight" },
            { 17330217, "Kindred_Dark_Knight" },
        },
        {
            { 17330234, "Kindred_Dragoon" },
            { 17330232, "Kindred_Dragoon" },
        },
        {
            { 17330226, "Kindred_Ninja" },
            { 17330227, "Kindred_Ninja" },
        },
        {
            { 17330239, "Kindred_Bard" },
            { 17330236, "Kindred_White_Mage" },
        },
        {
            { 17330258, "Kindred_Dark_Knight" },
            { 17330259, "Kindred_Dark_Knight" },
        },
        {
            { 17330278, "Kindred_Black_Mage" },
            { 17330277, "Kindred_Black_Mage" },
        },
        {
            { 17330281, "Kindred_Summoner" },
            { 17330283, "Kindred_Summoner" },
        },
        {
            { 17330270, "Kindred_Ninja" },
            { 17330269, "Kindred_Ninja" },
        },
        {
            { 17330272, "Kindred_Thief" },
            { 17330271, "Kindred_Thief" },
        },
        {
            { 17330266, "Kindred_Ranger" },
            { 17330265, "Kindred_Ranger" },
        },
        {
            { 17330225, "Kindred_Samurai" },
            { 17330252, "Kindred_Samurai" },
        },
        {
            { 17330251, "Kindred_Paladin" },
            { 17330250, "Kindred_Paladin" },
        },
        {
            { 17330279, "Kindred_Red_Mage" },
            { 17330280, "Kindred_Red_Mage" },
        },
        {
            { 17330538, "Kindred_White_Mage" },
            { 17330539, "Kindred_White_Mage" },
        },
        {
            { 17330548, "Kindred_Thief" },
            { 17330547, "Kindred_Thief" },
        },
        {
            { 17330541, "Kindred_Red_Mage" },
            { 17330540, "Kindred_Red_Mage" },
        },
        {
            { 17330536, "Kindred_Warrior" },
            { 17330537, "Kindred_Warrior" },
        },
        {
            { 17330552, "Kindred_Dark_Knight" },
            { 17330553, "Kindred_Dark_Knight" },
        },
        {
            { 17330551, "Kindred_Paladin" },
            { 17330550, "Kindred_Paladin" },
        },
        {
            { 17330556, "Kindred_Bard" },
            { 17330557, "Kindred_Bard" },
        },
        {
            { 17330563, "Kindred_White_Mage" },
            { 17330565, "Kindred_Black_Mage" },
        },
        {
            { 17330559, "Kindred_Ranger" },
            { 17330558, "Kindred_Ranger" },
        },
        {
            { 17330568, "Kindred_Samurai" },
            { 17330569, "Kindred_Samurai" },
        },
        {
            { 17330571, "Kindred_Ninja" },
            { 17330570, "Kindred_Ninja" },
        },
        {
            { 17330579, "Kindred_Bard" },
            { 17330576, "Kindred_White_Mage" },
        },
        {
            { 17330577, "Kindred_Paladin" },
            { 17330578, "Kindred_Dark_Knight" },
        },
        {
            { 17330585, "Kindred_Ninja" },
            { 17330582, "Kindred_Thief" },
        },
        {
            { 17330601, "Kindred_Bard" },
            { 17330602, "Kindred_Ranger" },
        },
        {
            { 17330592, "Kindred_White_Mage" },
            { 17330599, "Kindred_Beastmaster" },
        },
        {
            { 17330596, "Kindred_Summoner" },
            { 17330593, "Kindred_Black_Mage" },
        },
        {
            { 17330587, "Kindred_Warrior" },
            { 17330589, "Kindred_Dark_Knight" },
        },
        {
            { 17330588, "Kindred_Monk" },
            { 17330591, "Kindred_Ninja" },
        },
        {
            { 17330605, "Kindred_Bard" },
            { 17330604, "Kindred_Bard" },
        },
        {
            { 17330608, "Kindred_Dragoon" },
            { 17330606, "Kindred_Samurai" },
        },
        {
            { 17330603, "Kindred_Samurai" },
            { 17330598, "Kindred_Paladin" },
        },
        {
            { 17330613, "Kindred_Ninja" },
            { 17330614, "Kindred_Ninja" },
        },
        {
            { 17330611, "Kindred_Ranger" },
            { 17330612, "Kindred_Ranger" },
        },
        {
            { 17330500, "Kindred_Bard" },
            { 17330491, "Kindred_Bard" },
        },
        {
            { 17330328, "Kindred_Dark_Knight" },
            { 17330326, "Kindred_White_Mage" },
        },
        {
            { 17330327, "Kindred_Black_Mage" },
            { 17330325, "Kindred_Ranger" },
        },
        {
            { 17330296, "Kindred_Beastmaster" },
            { 17330298, "Kindred_Black_Mage" },
        },
        {
            { 17330466, "Kindred_Thief" },
            { 17330462, "Kindred_Monk" },
        },
        {
            { 17330469, "Kindred_Beastmaster" },
            { 17330467, "Kindred_Paladin" },
        },
        {
            { 17330468, "Kindred_Dark_Knight" },
            { 17330461, "Kindred_Warrior" },
        },
        {
            { 17330463, "Kindred_White_Mage" },
            { 17330464, "Kindred_Black_Mage" },
        },
        {
            { 17330473, "Kindred_Bard" },
            { 17330477, "Kindred_Dragoon" },
        },
        {
            { 17330475, "Kindred_Samurai" },
            { 17330476, "Kindred_Ninja" },
        },
        {
            { 17330474, "Kindred_Ranger" },
            { 17330479, "Kindred_Summoner" },
        },
        {
            { 17330642, "Kindred_Ninja" },
            { 17330645, "Kindred_Summoner" },
        },
        {
            { 17330643, "Kindred_Dragoon" },
            { 17330641, "Kindred_Samurai" },
        },
        {
            { 17330638, "Kindred_Ranger" },
            { 17330639, "Kindred_Dragoon" },
        },
        {
            { 17330632, "Kindred_Paladin" },
            { 17330634, "Kindred_Beastmaster" },
        },
        {
            { 17330628, "Kindred_Black_Mage" },
            { 17330629, "Kindred_Red_Mage" },
        },
        {
            { 17330626, "Kindred_Monk" },
            { 17330630, "Kindred_Thief" },
        },
        {
            { 17330624, "Kindred_Black_Mage" },
            { 17330625, "Kindred_Red_Mage" },
        },
        {
            { 17330623, "Kindred_Monk" },
            { 17330622, "Kindred_Warrior" },
        },
        {
            { 17330620, "Kindred_Black_Mage" },
            { 17330619, "Kindred_White_Mage" },
        },
        {
            { 17330618, "Kindred_Warrior" },
            { 17330621, "Kindred_Thief" },
        },
        {
            { 17330627, "Kindred_White_Mage" },
            { 17330633, "Kindred_Dark_Knight" },
        },
        {
            { 17330763, "Kindred_Ranger" },
            { 17330764, "Kindred_Samurai" },
        },
        {
            { 17330768, "Kindred_Summoner" },
            { 17330765, "Kindred_Ninja" },
        },
        {
            { 17330753, "Kindred_Black_Mage" },
            { 17330754, "Kindred_Red_Mage" },
        },
        {
            { 17330751, "Kindred_Monk" },
            { 17330750, "Kindred_Warrior" },
        },
        {
            { 17330761, "Kindred_Bard" },
            { 17330757, "Kindred_Paladin" },
        },
        {
            { 17330755, "Kindred_Thief" },
            { 17330752, "Kindred_White_Mage" },
        },
        {
            { 17330747, "Kindred_Thief" },
            { 17330748, "Kindred_Ranger" },
        },
        {
            { 17330743, "Kindred_Ranger" },
            { 17330742, "Kindred_Thief" },
        },
        {
            { 17330740, "Kindred_Ninja" },
            { 17330741, "Kindred_Ninja" },
        },
        {
            { 17330738, "Kindred_Bard" },
            { 17330739, "Kindred_Samurai" },
        },
        {
            { 17330734, "Kindred_Beastmaster" },
            { 17330736, "Kindred_Beastmaster" },
        },
        {
            { 17330732, "Kindred_Warrior" },
            { 17330733, "Kindred_White_Mage" },
        },
        {
            { 17330730, "Kindred_Thief" },
            { 17330729, "Kindred_Thief" },
        },
        {
            { 17330714, "Kindred_Summoner" },
            { 17330726, "Kindred_Bard" },
        },
        {
            { 17330727, "Kindred_Bard" },
            { 17330728, "Kindred_Red_Mage" },
        },
        {
            { 17330721, "Kindred_Warrior" },
            { 17330725, "Kindred_Samurai" },
        },
        {
            { 17330724, "Kindred_Samurai" },
            { 17330723, "Kindred_Monk" },
        },
        {
            { 17330720, "Kindred_Ranger" },
            { 17330722, "Kindred_Monk" },
        },
        {
            { 17330713, "Kindred_Black_Mage" },
            { 17330712, "Kindred_Dark_Knight" },
        },
        {
            { 17330716, "Kindred_Summoner" },
            { 17330709, "Kindred_Ninja" },
        },
        {
            { 17330710, "Kindred_Dragoon" },
            { 17330708, "Kindred_Ninja" },
        },
        {
            { 17330705, "Kindred_Dark_Knight" },
            { 17330707, "Kindred_Bard" },
        },
        {
            { 17330703, "Kindred_Paladin" },
            { 17330706, "Kindred_Dark_Knight" },
        },
        {
            { 17330684, "Kindred_Ranger" },
            { 17330704, "Kindred_Paladin" },
        },
        {
            { 17330681, "Kindred_Thief" },
            { 17330686, "Kindred_White_Mage" },
        },
        {
            { 17330679, "Kindred_Warrior" },
            { 17330683, "Kindred_Dark_Knight" },
        },
        {
            { 17330689, "Kindred_Bard" },
            { 17330688, "Kindred_Red_Mage" },
        },
        {
            { 17330680, "Kindred_Monk" },
            { 17330682, "Kindred_Paladin" },
        },
        {
            { 17330673, "Kindred_Samurai" },
            { 17330675, "Kindred_Ninja" },
        },
        {
            { 17330677, "Kindred_Summoner" },
            { 17330676, "Kindred_Ninja" },
        },
        {
            { 17330658, "Kindred_White_Mage" },
            { 17330661, "Kindred_Red_Mage" },
        },
        {
            { 17330660, "Kindred_Black_Mage" },
            { 17330657, "Kindred_White_Mage" },
        },
        {
            { 17330663, "Kindred_Warrior" },
            { 17330659, "Kindred_Black_Mage" },
        },
        {
            { 17330667, "Kindred_Paladin" },
            { 17330664, "Kindred_Thief" },
        },
        {
            { 17330665, "Kindred_Thief" },
            { 17330666, "Kindred_Paladin" },
        },
        {
            { 17330670, "Kindred_Beastmaster" },
            { 17330669, "Kindred_Dark_Knight" },
        },
        {
            { 17330655, "Kindred_Red_Mage" },
            { 17330656, "Kindred_Paladin" },
        },
        {
            { 17330652, "Kindred_Samurai" },
            { 17330651, "Kindred_Dark_Knight" },
        },
        {
            { 17330653, "Kindred_Dragoon" },
            { 17330647, "Kindred_Thief" },
        },
        {
            { 17330649, "Kindred_Ranger" },
            { 17330648, "Kindred_Bard" },
        },
        {
            { 17330691, "Kindred_Samurai" },
            { 17330695, "Kindred_Summoner" },
        },
        {
            { 17330693, "Kindred_Dragoon" },
            { 17330692, "Kindred_Ninja" },
        },
        {
            { 17330701, "Kindred_Summoner" },
            { 17330698, "Kindred_Ninja" },
        },
        {
            { 17330697, "Kindred_Samurai" },
            { 17330699, "Kindred_Dragoon" },
        },
        {
            { 17330400, "Kindred_Ninja" },
            { 17330401, "Kindred_Ranger" },
        },
        {
            { 17330403, "Kindred_Ninja" },
            { 17330402, "Kindred_Thief" },
        },
        {
            { 17330411, "Kindred_Dark_Knight" },
            { 17330405, "Kindred_Warrior" },
        },
        {
            { 17330408, "Kindred_Black_Mage" },
            { 17330409, "Kindred_Red_Mage" },
        },
        {
            { 17330410, "Kindred_Paladin" },
            { 17330406, "Kindred_Monk" },
        },
        {
            { 17330412, "Kindred_Thief" },
            { 17330414, "Kindred_Ranger" },
        },
    },
    ["Davoi"]              =
    {
        {
            { 17387848, "Orcish_Impaler" },
            { 17387849, "Orcish_Beastrider" },
        },
        {
            { 17387853, "Orcish_Beastrider" },
            { 17387854, "Orcish_Nightraider" },
        },
        {
            { 17387855, "Orcish_Brawler" },
            { 17387850, "Orcish_Nightraider" },
        },
        {
            { 17387841, "Orcish_Brawler" },
            { 17387843, "Orcish_Beastrider" },
        },
        {
            { 17387840, "Orcish_Nightraider" },
            { 17387838, "Orcish_Impaler" },
        },
        {
            { 17387827, "Orcish_Trooper" },
            { 17387825, "Orcish_Footsoldier" },
        },
        {
            { 17387824, "Orcish_Bowshooter" },
            { 17387826, "Orcish_Gladiator" },
        },
        {
            { 17387834, "Orcish_Bowshooter" },
            { 17387832, "Orcish_Gladiator" },
        },
        {
            { 17387837, "Orcish_Trooper" },
            { 17387836, "Orcish_Gladiator" },
        },
        {
            { 17387830, "Orcish_Bowshooter" },
            { 17387833, "Orcish_Trooper" },
        },
        {
            { 17387821, "Orcish_Trooper" },
            { 17387814, "Orcish_Bowshooter" },
        },
        {
            { 17387816, "Orcish_Gladiator" },
            { 17387817, "Orcish_Trooper" },
        },
        {
            { 17387805, "Orcish_Trooper" },
            { 17387798, "Orcish_Bowshooter" },
        },
        {
            { 17387811, "Orcish_Trooper" },
            { 17387810, "Orcish_Gladiator" },
        },
        {
            { 17387808, "Orcish_Bowshooter" },
            { 17387809, "Orcish_Footsoldier" },
        },
        {
            { 17387802, "Orcish_Bowshooter" },
            { 17387799, "Orcish_Footsoldier" },
        },
        {
            { 17387800, "Orcish_Gladiator" },
            { 17387801, "Orcish_Trooper" },
        },
        {
            { 17387803, "Orcish_Footsoldier" },
            { 17387804, "Orcish_Gladiator" },
        },
        {
            { 17387792, "Orcish_Predator" },
            { 17387793, "Orcish_Zerker" },
        },
        {
            { 17387783, "Orcish_Zerker" },
            { 17387781, "Orcish_Veteran" },
        },
        {
            { 17387777, "Orcish_Veteran" },
            { 17387760, "Orcish_Zerker" },
        },
        {
            { 17387779, "Orcish_Zerker" },
            { 17387782, "Orcish_Predator" },
        },
        {
            { 17387743, "Orcish_Trooper" },
            { 17387749, "Orcish_Warchief" },
        },
        {
            { 17387929, "Orcish_Nightraider" },
            { 17387930, "Orcish_Brawler" },
            { 17387751, "Orcish_Predator" },
            { 17387927, "Orcish_Impaler" },
        },
        {
            { 17387922, "Orcish_Beastrider" },
            { 17387923, "Orcish_Nightraider" },
        },
        {
            { 17387924, "Orcish_Brawler" },
            { 17387928, "Orcish_Beastrider" },
        },
        {
            { 17387908, "Orcish_Brawler" },
            { 17387911, "Orcish_Nightraider" },
        },
        {
            { 17387907, "Orcish_Nightraider" },
            { 17387912, "Orcish_Brawler" },
        },
        {
            { 17387740, "Orcish_Bowshooter" },
            { 17387741, "Orcish_Footsoldier" },
        },
        {
            { 17387737, "Orcish_Footsoldier" },
            { 17387736, "Orcish_Bowshooter" },
        },
        {
            { 17387739, "Orcish_Trooper" },
            { 17387742, "Orcish_Gladiator" },
        },
        {
            { 17387733, "Orcish_Gladiator" },
            { 17387732, "Orcish_Footsoldier" },
            { 17387731, "Orcish_Bowshooter" },
        },
        {
            { 17387728, "Orcish_Trooper" },
            { 17387726, "Orcish_Footsoldier" },
        },
        {
            { 17387725, "Orcish_Bowshooter" },
            { 17387727, "Orcish_Gladiator" },
        },
        {
            { 17387716, "Orcish_Trooper" },
            { 17387714, "Orcish_Footsoldier" },
        },
        {
            { 17387705, "Orcish_Gladiator" },
            { 17387704, "Orcish_Footsoldier" },
        },
        {
            { 17387709, "Orcish_Gladiator" },
            { 17387707, "Orcish_Bowshooter" },
        },
        {
            { 17387706, "Orcish_Trooper" },
            { 17387703, "Orcish_Bowshooter" },
        },
        {
            { 17387645, "Orcish_Impaler" },
            { 17387647, "Orcish_Nightraider" },
        },
        {
            { 17387648, "Orcish_Brawler" },
            { 17387646, "Orcish_Beastrider" },
        },
        {
            { 17387748, "Orcish_Zerker" },
            { 17387713, "Orcish_Bowshooter" },
            { 17387722, "Orcish_Trooper" },
        },
        {
            { 17387618, "Orcish_Impaler" },
            { 17387621, "Orcish_Brawler" },
        },
        {
            { 17387634, "Orcish_Impaler" },
            { 17387635, "Orcish_Beastrider" },
            { 17387636, "Orcish_Nightraider" },
            { 17387637, "Orcish_Brawler" },
            { 17387638, "Orcish_Impaler" },
            { 17387639, "Orcish_Beastrider" },
            { 17387640, "Orcish_Nightraider" },
        },
        {
            { 17387624, "Orcish_Nightraider" },
            { 17387622, "Orcish_Impaler" },
        },
        {
            { 17387623, "Orcish_Beastrider" },
            { 17387620, "Orcish_Nightraider" },
            { 17387625, "Orcish_Brawler" },
        },
        {
            { 17387631, "Orcish_Trooper" },
            { 17387630, "Orcish_Gladiator" },
        },
        {
            { 17387628, "Orcish_Bowshooter" },
            { 17387629, "Orcish_Footsoldier" },
        },
        {
            { 17387611, "Orcish_Beastrider" },
            { 17387613, "Orcish_Brawler" },
        },
        {
            { 17387610, "Orcish_Impaler" },
            { 17387616, "Orcish_Nightraider" },
        },
        {
            { 17387612, "Orcish_Nightraider" },
            { 17387617, "Orcish_Brawler" },
        },
        {
            { 17387651, "Orcish_Bowshooter" },
            { 17387656, "Orcish_Footsoldier" },
        },
        {
            { 17387654, "Orcish_Trooper" },
            { 17387657, "Orcish_Gladiator" },
        },
        {
            { 17387664, "Orcish_Gladiator" },
            { 17387662, "Orcish_Bowshooter" },
        },
        {
            { 17387668, "Orcish_Gladiator" },
            { 17387665, "Orcish_Trooper" },
        },
        {
            { 17387667, "Orcish_Footsoldier" },
            { 17387666, "Orcish_Bowshooter" },
        },
        {
            { 17387653, "Orcish_Gladiator" },
            { 17387669, "Orcish_Trooper" },
        },
        {
            { 17387686, "Orcish_Trooper" },
            { 17387677, "Orcish_Bowshooter" },
        },
        {
            { 17387679, "Orcish_Gladiator" },
            { 17387673, "Orcish_Bowshooter" },
        },
        {
            { 17387676, "Orcish_Trooper" },
            { 17387678, "Orcish_Footsoldier" },
        },
        {
            { 17387680, "Orcish_Trooper" },
            { 17387674, "Orcish_Footsoldier" },
        },
        {
            { 17387687, "Orcish_Bowshooter" },
            { 17387684, "Orcish_Footsoldier" },
        },
        {
            { 17387685, "Orcish_Gladiator" },
            { 17387683, "Orcish_Bowshooter" },
        },
        {
            { 17387695, "Orcish_Gladiator" },
            { 17387693, "Orcish_Bowshooter" },
        },
        {
            { 17387675, "Orcish_Gladiator" },
            { 17387658, "Orcish_Trooper" },
        },
    },
    ["Monastic_Cavern"]    =
    {
        {
            { 17391620, "Orcish_Trooper" },
            { 17391617, "Orcish_Bowshooter" },
            { 17391623, "Orcish_Gladiator" },
            { 17391639, "Orcish_Zerker" },
            { 17391621, "Orcish_Bowshooter" },
            { 17391631, "Orcish_Zerker" },
            { 17391640, "Orcish_Warchief" },
        },
        {
            { 17391622, "Orcish_Footsoldier" },
            { 17391619, "Orcish_Gladiator" },
            { 17391618, "Orcish_Footsoldier" },
            { 17391624, "Orcish_Trooper" },
            { 17391632, "Orcish_Warchief" },
            { 17391630, "Orcish_Predator" },
        },
        {
            { 17391643, "Orcish_Zerker" },
            { 17391651, "Orcish_Zerker" },
            { 17391649, "Orcish_Veteran" },
            { 17391655, "Orcish_Zerker" },
        },
        {
            { 17391650, "Orcish_Predator" },
            { 17391654, "Orcish_Predator" },
        },
        {
            { 17391653, "Orcish_Veteran" },
            { 17391652, "Orcish_Warchief" },
        },
        {
            { 17391646, "Orcish_Predator" },
            { 17391642, "Orcish_Predator" },
        },
        {
            { 17391647, "Orcish_Zerker" },
            { 17391641, "Orcish_Veteran" },
            { 17391635, "Orcish_Gladiator" },
        },
        {
            { 17391682, "Orcish_Warchief" },
            { 17391678, "Orcish_Warchief" },
            { 17391680, "Orcish_Predator" },
        },
        {
            { 17391687, "Orcish_Veteran" },
            { 17391692, "Orcish_Dreadnought" },
            { 17391691, "Orcish_Farkiller" },
            { 17391690, "Orcish_Warchief" },
        },
        {
            { 17391685, "Orcish_Zerker" },
            { 17391686, "Orcish_Warchief" },
            { 17391683, "Orcish_Veteran" },
            { 17391695, "Orcish_Zerker" },
        },
        {
            { 17391644, "Orcish_Warchief" },
            { 17391645, "Orcish_Veteran" },
            { 17391659, "Orcish_Zerker" },
            { 17391648, "Orcish_Warchief" },
        },
        {
            { 17391661, "Orcish_Veteran" },
            { 17391657, "Orcish_Veteran" },
            { 17391658, "Orcish_Predator" },
            { 17391663, "Orcish_Zerker" },
        },
        {
            { 17391674, "Orcish_Warchief" },
            { 17391673, "Orcish_Zerker" },
            { 17391676, "Orcish_Predator" },
            { 17391671, "Orcish_Veteran" },
            { 17391677, "Orcish_Zerker" },
            { 17391672, "Orcish_Predator" },
            { 17391675, "Orcish_Veteran" },
        },
        {
            { 17391669, "Orcish_Farkiller" },
            { 17391665, "Orcish_Veteran" },
            { 17391666, "Orcish_Predator" },
            { 17391664, "Orcish_Warchief" },
        },
        {
            { 17391668, "Orcish_Warchief" },
            { 17391670, "Orcish_Dreadnought" },
            { 17391667, "Orcish_Zerker" },
        },
        {
            { 17391697, "Orcish_Veteran" },
            { 17391688, "Orcish_Predator" },
        },
        {
            { 17391693, "Orcish_Veteran" },
            { 17391696, "Orcish_Warchief" },
        },
        {
            { 17391700, "Orcish_Warchief" },
            { 17391689, "Orcish_Zerker" },
            { 17391679, "Orcish_Veteran" },
            { 17391703, "Orcish_Zerker" },
        },
        {
            { 17391694, "Orcish_Predator" },
            { 17391705, "Orcish_Champion" },
            { 17391711, "Orcish_Predator" },
            { 17391709, "Orcish_Warchief" },
        },
        {
            { 17391708, "Orcish_Zerker" },
            { 17391704, "Orcish_Warchief" },
            { 17391706, "Orcish_Veteran" },
        },
        {
            { 17391715, "Orcish_Dreadnought" },
            { 17391717, "Orcish_Dragoon" },
        },
        {
            { 17391714, "Orcish_Farkiller" },
            { 17391716, "Orcish_Champion" },
        },
        {
            { 17391719, "Orcish_Dreadnought" },
            { 17391720, "Orcish_Champion" },
            { 17391718, "Orcish_Farkiller" },
        },
        {
            { 17391731, "Orcish_Dragoon" },
            { 17391723, "Orcish_Dreadnought" },
            { 17391725, "Orcish_Dragoon" },
        },
        {
            { 17391722, "Orcish_Farkiller" },
            { 17391721, "Orcish_Dragoon" },
            { 17391724, "Orcish_Champion" },
        },
        {
            { 17391728, "Orcish_Farkiller" },
            { 17391729, "Orcish_Dreadnought" },
            { 17391735, "Orcish_Dragoon" },
        },
        {
            { 17391733, "Orcish_Dreadnought" },
            { 17391734, "Orcish_Champion" },
            { 17391730, "Orcish_Champion" },
        },
        {
            { 17391739, "Orcish_Dragoon" },
            { 17391736, "Orcish_Farkiller" },
            { 17391738, "Orcish_Champion" },
            { 17391737, "Orcish_Dreadnought" },
            { 17391743, "Orcish_Dragoon" },
        },
        {
            { 17391742, "Orcish_Champion" },
            { 17391741, "Orcish_Dreadnought" },
        },
        {
            { 17391750, "Orcish_Champion" },
            { 17391755, "Orcish_Dragoon" },
            { 17391740, "Orcish_Farkiller" },
            { 17391748, "Orcish_Farkiller" },
            { 17391759, "Orcish_Dragoon" },
            { 17391746, "Orcish_Champion" },
            { 17391757, "Orcish_Dreadnought" },
            { 17391744, "Orcish_Farkiller" },
            { 17391749, "Orcish_Dreadnought" },
            { 17391747, "Orcish_Dragoon" },
        },
        {
            { 17391753, "Orcish_Dreadnought" },
            { 17391756, "Orcish_Farkiller" },
            { 17391754, "Orcish_Champion" },
        },
        {
            { 17391762, "Orcish_Dreadnought" },
            { 17391758, "Orcish_Champion" },
            { 17391752, "Orcish_Farkiller" },
        },
        {
            { 17391760, "Orcish_Protector" },
            { 17391764, "Orcish_Dragoon" },
        },
        {
            { 17391775, "Orcish_Champion" },
            { 17391776, "Orcish_Dragoon" },
        },
        {
            { 17391772, "Orcish_Protector" },
            { 17391774, "Orcish_Dreadnought" },
        },
        {
            { 17391780, "Orcish_Champion" },
            { 17391779, "Orcish_Dreadnought" },
        },
        {
            { 17391778, "Orcish_Farkiller" },
            { 17391781, "Orcish_Dragoon" },
        },
        {
            { 17391777, "Orcish_Protector" },
            { 17391773, "Orcish_Farkiller" },
        },
        {
            { 17391767, "Orcish_Protector" },
            { 17391769, "Orcish_Dreadnought" },
        },
        {
            { 17391783, "Orcish_Warchief" },
            { 17391713, "Orcish_Warchief" },
        },
        {
            { 17391710, "Orcish_Veteran" },
            { 17391782, "Orcish_Veteran" },
        },
        {
            { 17391792, "Orcish_Predator" },
            { 17391788, "Orcish_Bowshooter" },
            { 17391791, "Orcish_Trooper" },
        },
        {
            { 17391785, "Orcish_Footsoldier" },
            { 17391707, "Orcish_Predator" },
            { 17391790, "Orcish_Gladiator" },
        },
        {
            { 17391786, "Orcish_Gladiator" },
            { 17391712, "Orcish_Zerker" },
            { 17391789, "Orcish_Footsoldier" },
        },
        {
            { 17391787, "Orcish_Trooper" },
            { 17391793, "Orcish_Zerker" },
            { 17391784, "Orcish_Bowshooter" },
        },
        {
            { 17391798, "Orcish_Bowshooter" },
            { 17391797, "Orcish_Trooper" },
            { 17391796, "Orcish_Gladiator" },
        },
        {
            { 17391799, "Orcish_Footsoldier" },
            { 17391794, "Orcish_Bowshooter" },
            { 17391801, "Orcish_Trooper" },
        },
    },
    ["Outer_Horutoto_Ruins"]              =
    {
        {
            { 17572168, "Goblin_Thug" },
            { 17572166, "Goblin_Weaver" },
        },
        {
            { 17572182, "Goblin_Weaver" },
            { 17572167, "Goblin_Thug" },
        },
        {
            { 17572173, "Goblin_Thug" },
            { 17572172, "Goblin_Weaver" },
        },
        {
            { 17572194, "Goblin_Weaver" },
            { 17572196, "Goblin_Weaver" },
            { 17572192, "Goblin_Weaver" },
        },
        {
            { 17572169, "Goblin_Weaver" },
            { 17572164, "Goblin_Thug" },
        },        
        {
            { 17572178, "Goblin_Weaver" },
            { 17572181, "Goblin_Thug" },
        },
    },
    ["Giddeus"] =
    {
        {
            { 17371144, "Yagudo_Initiate" },
            { 17371160, "Yagudo_Acolyte" },
        },
        {
            { 17371147, "Yagudo_Scribe" },
            { 17371146, "Yagudo_Acolyte" },
        },
        {
            { 17371167, "Yagudo_Scribe" },
            { 17371165, "Yagudo_Initiate" },
        },
        {
            { 17371166, "Yagudo_Acolyte" },
            { 17371145, "Yagudo_Initiate" },
        },
        {
            { 17371187, "Yagudo_Acolyte" },
            { 17371186, "Yagudo_Initiate" },
        },
        {
            { 17371180, "Yagudo_Scribe" },
            { 17371188, "Yagudo_Scribe" },
        },
        {
            { 17371185, "Yagudo_Scribe" },
            { 17371175, "Yagudo_Initiate" },
            { 17371179, "Yagudo_Acolyte" },
        },
        {
            { 17371183, "Yagudo_Initiate" },
            { 17371177, "Yagudo_Scribe" },
            { 17371184, "Yagudo_Acolyte" },
        },
        {
            { 17371213, "Yagudo_Initiate" },
            { 17371215, "Yagudo_Scribe" },
            { 17371214, "Yagudo_Acolyte" },
        },
        {
            { 17371225, "Yagudo_Acolyte" },
            { 17371226, "Yagudo_Scribe" },
            { 17371224, "Yagudo_Initiate" },
        },
        {
            { 17371220, "Yagudo_Acolyte" },
            { 17371221, "Yagudo_Scribe" },
            { 17371219, "Yagudo_Initiate" },
        },
        {
            { 17371231, "Yagudo_Scribe" },
            { 17371230, "Yagudo_Acolyte" },
        },
        {
            { 17371234, "Yagudo_Acolyte" },
            { 17371233, "Yagudo_Initiate" },
        },
        {
            { 17371235, "Yagudo_Scribe" },
            { 17371329, "Yagudo_Scribe" },
        },
        {
            { 17371236, "Yagudo_Initiate" },
            { 17371332, "Yagudo_Scribe" },
            { 17371238, "Yagudo_Scribe" },
        },
        {
            { 17371328, "Yagudo_Acolyte" },
            { 17371327, "Yagudo_Initiate" },
        },
        {
            { 17371330, "Yagudo_Initiate" },
            { 17371331, "Yagudo_Acolyte" },
        },
        {
            { 17371352, "Yagudo_Piper" },
            { 17371353, "Yagudo_Persecutor" },
        },
        {
            { 17371347, "Yagudo_Initiate" },
            { 17371346, "Yagudo_Scribe" },
        },
        {
            { 17371348, "Yagudo_Acolyte" },
            { 17371345, "Yagudo_Acolyte" },
        },
        {
            { 17371363, "Yagudo_Persecutor" },
            { 17371362, "Yagudo_Piper" },
            { 17371360, "Yagudo_Mendicant" },
        },
        {
            { 17371357, "Yagudo_Initiate" },
            { 17371359, "Yagudo_Scribe" },
            { 17371356, "Yagudo_Scribe" },
        },
        {
            { 17371358, "Yagudo_Acolyte" },
            { 17371355, "Yagudo_Acolyte" },
        },
        {
            { 17371339, "Yagudo_Piper" },
            { 17371337, "Yagudo_Mendicant" },
        },
        {
            { 17371333, "Yagudo_Mendicant" },
            { 17371335, "Yagudo_Piper" },
        },
        {
            { 17371340, "Yagudo_Persecutor" },
            { 17371349, "Yagudo_Scribe" },
        },
        {
            { 17371364, "Yagudo_Mendicant" },
            { 17371366, "Yagudo_Piper" },
            { 17371367, "Yagudo_Persecutor" },
        },
        {
            { 17371370, "Yagudo_Mendicant" },
            { 17371374, "Yagudo_Mendicant" },
        },
        {
            { 17371377, "Yagudo_Persecutor" },
            { 17371373, "Yagudo_Persecutor" },
        },
        {
            { 17371382, "Yagudo_Piper" },
            { 17371383, "Yagudo_Persecutor" },
        },
        {
            { 17371386, "Yagudo_Piper" },
            { 17371372, "Yagudo_Piper" },
        },
        {
            { 17371384, "Yagudo_Mendicant" },
            { 17371387, "Yagudo_Persecutor" },
        },
        {
            { 17371396, "Yagudo_Piper" },
            { 17371397, "Yagudo_Persecutor" },
        },
        {
            { 17371390, "Yagudo_Mendicant" },
            { 17371392, "Yagudo_Piper" },
        },
        {
            { 17371404, "Yagudo_Mendicant" },
            { 17371407, "Yagudo_Persecutor" },
        },
        {
            { 17371406, "Yagudo_Piper" },
            { 17371403, "Yagudo_Persecutor" },
        },
        {
            { 17371400, "Yagudo_Mendicant" },
            { 17371402, "Yagudo_Piper" },
        },
        {
            { 17371393, "Yagudo_Persecutor" },
            { 17371394, "Yagudo_Mendicant" },
        },
        {
            { 17371411, "Yagudo_Piper" },
            { 17371409, "Yagudo_Mendicant" },
        },
        {
            { 17371419, "Yagudo_Persecutor" },
            { 17371423, "Yagudo_Persecutor" },
        },
        {
            { 17371420, "Yagudo_Mendicant" },
            { 17371416, "Yagudo_Mendicant" },
        },
        {
            { 17371424, "Yagudo_Mendicant" },
            { 17371427, "Yagudo_Persecutor" },
            { 17371426, "Yagudo_Piper" },
        },
        {
            { 17371433, "Yagudo_Persecutor" },
            { 17371436, "Yagudo_Piper" },
        },
        {
            { 17371432, "Yagudo_Piper" },
            { 17371434, "Yagudo_Mendicant" },
        },
        {
            { 17371440, "Yagudo_Mendicant" },
            { 17371443, "Yagudo_Persecutor" },
            { 17371442, "Yagudo_Piper" },
        },
        {
            { 17371447, "Yagudo_Mendicant" },
            { 17371461, "Yagudo_Mendicant" },
        },
        {
            { 17371464, "Yagudo_Persecutor" },
            { 17371465, "Yagudo_Mendicant" },
            { 17371468, "Yagudo_Persecutor" },
        },
        {
            { 17371471, "Yagudo_Piper" },
            { 17371469, "Yagudo_Mendicant" },
        },
        {
            { 17371467, "Yagudo_Piper" },
            { 17371472, "Yagudo_Persecutor" },
        },
        {
            { 17371459, "Yagudo_Piper" },
            { 17371460, "Yagudo_Persecutor" },
        },
        {
            { 17371453, "Yagudo_Mendicant" },
            { 17371457, "Yagudo_Mendicant" },
        },
        {
            { 17371456, "Yagudo_Persecutor" },
            { 17371455, "Yagudo_Piper" },
        },
        {
            { 17371250, "Yagudo_Scribe" },
            { 17371248, "Yagudo_Initiate" },
            { 17371249, "Yagudo_Acolyte" },
        },
        {
            { 17371255, "Yagudo_Scribe" },
            { 17371253, "Yagudo_Initiate" },
        },
        {
            { 17371257, "Yagudo_Initiate" },
            { 17371262, "Yagudo_Scribe" },
        },
        {
            { 17371260, "Yagudo_Initiate" },
            { 17371261, "Yagudo_Acolyte" },
        },
        {
            { 17371259, "Yagudo_Scribe" },
            { 17371258, "Yagudo_Acolyte" },
        },
        {
            { 17371244, "Yagudo_Scribe" },
            { 17371243, "Yagudo_Acolyte" },
        },
        {
            { 17371199, "Yagudo_Scribe" },
            { 17371198, "Yagudo_Acolyte" },
        },
        {
            { 17371196, "Yagudo_Scribe" },
            { 17371195, "Yagudo_Acolyte" },
            { 17371202, "Yagudo_Initiate" },
        },
        {
            { 17371194, "Yagudo_Initiate" },
            { 17371203, "Yagudo_Acolyte" },
            { 17371204, "Yagudo_Scribe" },
        },
        {
            { 17371197, "Yagudo_Initiate" },
            { 17371206, "Yagudo_Acolyte" },
        },
        {
            { 17371207, "Yagudo_Scribe" },
            { 17371205, "Yagudo_Initiate" },
        },
        {
            { 17371170, "Yagudo_Initiate" },
            { 17371172, "Yagudo_Scribe" },
        },
        {
            { 17371199, "Yagudo_Scribe" },
            { 17371198, "Yagudo_Acolyte" },
        },
        {
            { 17371155, "Yagudo_Scribe" },
            { 17371152, "Yagudo_Initiate" },
        },
        {
            { 17371270, "Yagudo_Scribe" },
            { 17371267, "Yagudo_Scribe" },
        },
        {
            { 17371269, "Yagudo_Acolyte" },
            { 17371271, "Yagudo_Initiate" },
        },
        {
            { 17371268, "Yagudo_Initiate" },
            { 17371265, "Yagudo_Initiate" },
        },
        {
            { 17371275, "Yagudo_Acolyte" },
            { 17371266, "Yagudo_Acolyte" },
        },
        {
            { 17371277, "Yagudo_Mendicant" },
            { 17371280, "Yagudo_Persecutor" },
            { 17371279, "Yagudo_Piper" },
        },
        {
            { 17371272, "Yagudo_Acolyte" },
            { 17371274, "Yagudo_Initiate" },
        },
        {
            { 17371276, "Yagudo_Scribe" },
            { 17371273, "Yagudo_Scribe" },
        },
        {
            { 17371304, "Yagudo_Piper" },
            { 17371309, "Yagudo_Persecutor" },
        },
        {
            { 17371306, "Yagudo_Mendicant" },
            { 17371308, "Yagudo_Piper" },
        },
        {
            { 17371305, "Yagudo_Persecutor" },
            { 17371302, "Yagudo_Mendicant" },
        },
        {
            { 17371317, "Yagudo_Piper" },
            { 17371315, "Yagudo_Mendicant" },
            { 17371318, "Yagudo_Persecutor" },
        },
        {
            { 17371313, "Yagudo_Piper" },
            { 17371314, "Yagudo_Persecutor" },
        },
        {
            { 17371311, "Yagudo_Mendicant" },
            { 17371325, "Yagudo_Piper" },
        },
        {
            { 17371295, "Yagudo_Piper" },
            { 17371297, "Yagudo_Piper" },
        },
        {
            { 17371290, "Yagudo_Piper" },
            { 17371296, "Yagudo_Persecutor" },
        },
        {
            { 17371288, "Yagudo_Mendicant" },
            { 17371286, "Yagudo_Piper" },
            { 17371287, "Yagudo_Persecutor" },
        },
        {
            { 17371475, "Yagudo_Mendicant" },
            { 17371477, "Yagudo_Piper" },
        },
        {
            { 17371488, "Yagudo_Piper" },
            { 17371485, "Yagudo_Persecutor" },
        },
        {
            { 17371484, "Yagudo_Piper" },
            { 17371482, "Yagudo_Mendicant" },
            { 17371489, "Yagudo_Persecutor" },
        },
        {
            { 17371510, "Yagudo_Piper" },
            { 17371493, "Yagudo_Persecutor" },
        },
        {
            { 17371492, "Yagudo_Piper" },
            { 17371495, "Yagudo_Persecutor" },
        },
        {
            { 17371501, "Yagudo_Persecutor" },
            { 17371500, "Yagudo_Piper" },
            { 17371507, "Yagudo_Persecutor" },
        },
        {
            { 17371486, "Yagudo_Mendicant" },
            { 17371504, "Yagudo_Mendicant" },
        },
        {
            { 17371506, "Yagudo_Piper" },
            { 17371508, "Yagudo_Mendicant" },
        },
        {
            { 17371518, "Yagudo_Piper" },
            { 17371524, "Yagudo_Piper" },
        },
        {
            { 17371528, "Yagudo_Piper" },
            { 17371532, "Yagudo_Piper" },
            { 17371526, "Yagudo_Mendicant" },
        },
        {
            { 17371522, "Yagudo_Mendicant" },
            { 17371534, "Yagudo_Piper" },
        },
        {
            { 17371298, "Yagudo_Persecutor" },
            { 17371530, "Yagudo_Mendicant" },
        },
        {
            { 17371539, "Yagudo_Theologist" },
            { 17371538, "Yagudo_Votary" },
        },
        {
            { 17371563, "Yagudo_Votary" },
            { 17371554, "Yagudo_Priest" },
            { 17371564, "Yagudo_Theologist" },
        },
        {
            { 17371559, "Yagudo_Votary" },
            { 17371567, "Yagudo_Theologist" },
        },
        {
            { 17371570, "Yagudo_Votary" },
            { 17371552, "Yagudo_Votary" },
        },
        {
            { 17371557, "Yagudo_Theologist" },
            { 17371561, "Yagudo_Priest" },
            { 17371574, "Yagudo_Theologist" },
        },
        {
            { 17371553, "Yagudo_Theologist" },
            { 17371556, "Yagudo_Votary" },
        },
        {
            { 17371550, "Yagudo_Theologist" },
            { 17371560, "Yagudo_Theologist" },
        },
        {
            { 17371571, "Yagudo_Theologist" },
            { 17371572, "Yagudo_Priest" },
        },
    },
}

local function rollGroup(zoneName, groupID)
    local group = mobs[zoneName][groupID]
    local ids   = {}

    -- Set m_AllowRespawn to false on all mobs in this group
    -- Add each mobID to table, to randomly select one for respawn
    for _, mobInfo in pairs(group) do
        local mobID = mobInfo[1]

        DisallowRespawn(mobID, true)
        table.insert(ids, mobID)
    end

    local respawnID  = ids[math.random(#ids)]
    local mobRespawn = GetMobByID(respawnID)

    if mobRespawn == nil then
        print(string.format("[mob_groups] Mob not found %u", respawnID))
    end

    -- Allow the select mob to respawn
    -- setRespawnTime sets m_AllowRespawn to true
    if settings.respawn[zoneName] == nil then
        mobRespawn:setRespawnTime(settings.respawn.DEFAULT)
    else
        mobRespawn:setRespawnTime(settings.respawn[zoneName])
    end
end

local mobOverride = {}

-- Store the groupIDs associated with each mob so we can use this in onMobDeath
for zoneName, groups in pairs(mobs) do
    mobOverride[zoneName] = {}

    for groupID, group in pairs(groups) do
        for _, mobInfo in pairs(group) do
            local mobID   = mobInfo[1]
            local mobName = mobInfo[2]

            if mobOverride[zoneName][mobName] == nil then
                mobOverride[zoneName][mobName] = {}
            end

            -- Create a mapping so we know which groupID to roll for this mobID
            mobOverride[zoneName][mobName][mobID] = groupID
        end
    end
end

for zoneName, groups in pairs(mobs) do
    -- Initial setup - Despawn all except 1 mob from each group
    m:addOverride(string.format("xi.zones.%s.Zone.onInitialize", zoneName), function(zone)
        super(zone)

        for groupID, group in pairs(groups) do
            local selected = math.random(#group)

            for mobIndex, mobInfo in pairs(group) do
                -- Apply this to all grouped mobs, so they can't respawn normally
                DisallowRespawn(mobInfo[1], true)

                -- If this isn't the randomly selected mob for that group, then despawn it
                if mobIndex ~= selected then
                    DespawnMob(mobInfo[1])
                end
            end
        end
    end)

    -- Add override to roll new mob on death
    for mobName, groupIDs in pairs(mobOverride[zoneName]) do
        m:addOverride(string.format("xi.zones.%s.mobs.%s.onMobDeath", zoneName, mobName), function(mob, player, optParams)
            super(mob, player, optParams)

            local mobID   = mob:getID()
            local groupID = mobOverride[zoneName][mobName][mobID]

            -- Check this mobID has an associated groupID because
            -- this override is also called on ungrouped mobs with the same name
            if groupID ~= nil then
                rollGroup(zoneName, groupID)
            end
        end)
    end
end

return m
