-----------------------------------
--Allows custom quests to contribute to the 15 required to obtain Maat trust
-----------------------------------
require("modules/module_utils")
-----------------------------------
local m = Module:new("maat_custom_lb5_tally")

local customLB5 =
{
    ["[LB]IMMORTAL_KOMBAT"] = 6,
    ["[LB]MISSING_RUM"]     = 6,
    ["[LB]MASTER_PUPPETS"]  = 6,
    ["[LB]DADDY_ISSUES"]    = 6,
    ["[LB]REVENGE_NERDS"]   = 6,
}

m:addOverride('xi.server.onServerStart', function()
    super()

    xi.module.modifyInteractionEntry('scripts/quests/hiddenQuests/Trust_Maat', function(quest)
        quest.sections[1][xi.zone.RULUDE_GARDENS].Maat.onTrigger = function(player, npc)
            -- Classic Mode players shouldn't be able to unlock RUN and GEO (Or obtain Maat trust)
            if player:isClassicMode() then
                return quest:event(10242)
            end

            local totalLB5 = utils.mask.countBits(player:getCharVar("maatsCap"), 16)

            for varName, progressVal in pairs(customLB5) do
                if player:getCharVar(varName) >= progressVal then
                    totalLB5 = totalLB5 + 1
                end
            end

            if totalLB5 >= 6 then
                return quest:event(10241)
            else
                return quest:event(10242)
            end
        end
    end)
end)

return m
