-----------------------------------
-- Immunity
-----------------------------------
-- Light Sleep immunity does not work
-- Remove once fixed upstream...
-----------------------------------
require("modules/module_utils")
-----------------------------------
local m = Module:new("immunity")

local sleeps =
{
    songs =
    {
        "foe_lullaby",
        "foe_lullaby_ii",
        "horde_lullaby",
        "horde_lullaby_ii"
    },

    blue =
    {
        { "sheep_song",    xi.element.LIGHT },
        { "soporific",     xi.element.DARK  },
        { "pinecone_bomb", xi.element.DARK  },
        { "yawn",          xi.element.LIGHT },
    },

    abilities =
    {
        "light_shot",
    },
}

for _, spellName in pairs(sleeps.songs) do
    m:addOverride(fmt("xi.actions.spells.songs.{}.onSpellCast", spellName), function(caster, target, spell)
        if target:hasImmunity(xi.immunity.LIGHT_SLEEP) then
            spell:setMsg(xi.msg.basic.MAGIC_RESIST) -- resist message
            return xi.effect.SLEEP_I
        else
            return super(caster, target, spell)
        end
    end)
end

for _, spellInfo in pairs(sleeps.blue) do
    m:addOverride(fmt("xi.actions.spells.blue.{}.onSpellCast", spellInfo[1]), function(caster, target, spell)
        if
            (spellInfo[2] == xi.element.LIGHT and target:hasImmunity(xi.immunity.LIGHT_SLEEP)) or
            (spellInfo[2] == xi.element.DARK  and target:hasImmunity(xi.immunity.DARK_SLEEP))
        then
            spell:setMsg(xi.msg.basic.MAGIC_RESIST) -- resist message
            return xi.effect.SLEEP_II
        else
            return super(caster, target, spell)
        end
    end)
end

for _, abilityName in pairs(sleeps.abilities) do
    m:addOverride(fmt("xi.actions.abilities.{}.onUseAbility", abilityName), function(player, target, ability, action)
        if target:hasImmunity(xi.immunity.LIGHT_SLEEP) then
            ability:setMsg(xi.msg.basic.JA_MISS_2) -- resist message
            return xi.effect.SLEEP_I
        else
            return super(player, target, ability, action)
        end
    end)
end

return m
