require("modules/module_utils")
require('scripts/globals/npc_util')
require("scripts/globals/gobbie_mystery_box")
-----------------------------------
--       Gobbie Key Event        --
-----------------------------------

local m = Module:new("gobbie_key_event")

m:addOverride("xi.gobbieMysteryBox.onTrigger", function(player, npc, events)
    local zones  = player:getZone()
    local zoneId = player:getZoneID()

    if
        player:isCrystalWarrior() or
        player:isClassicMode()
    then
        player:printToPlayer("Your character type cannot use this feature.", xi.msg.channel.SYSTEM_3)
        return
    end

    if xi.settings.main.FREE_DIAL_KEY == 1 then
        player:printToPlayer(string.format("I am rewarding players with a Gobbiedial key once a day!"), xi.msg.channel.SYSTEM_3)

        if player:getFreeSlotsCount() > 0 and player:getCharVar("dialKeyEvent") <= os.time() then
            npcUtil.giveItem(player, xi.item.SPECIAL_GOBBIEDIAL_KEY)
            player:setCharVar("dialKeyEvent", getMidnight())
        elseif player:getCharVar("dialKeyEvent") >= os.time() then
            player:printToPlayer(string.format("You have redeemed your reward for the day!"), xi.msg.channel.SYSTEM_3)
        else
            player:printToPlayer(string.format("Make some room! I have a reward for you!"), xi.msg.channel.SYSTEM_3)
            return
        end
    end

    super(player, npc, events)

end)

return m
