-----------------------------------
-- Garrison Rewards
-----------------------------------
require("modules/module_utils")
-----------------------------------
local m = Module:new("garrison_rewards")

local settings =
{
    name = "Garret",
    pos  = { -6.915, 9.000, -32.578, 52 }, -- !pos -6.915 9.000 -32.578 243
    area = "RuLude_Gardens",
    look = cexi.util.look({
        race = xi.race.HUME_M,
        face = cexi.face.A2,
        head = cexi.model.PLATE_ARMOR,
        body = cexi.model.PLATE_ARMOR,
        hand = cexi.model.PLATE_ARMOR,
        legs = cexi.model.PLATE_ARMOR,
        feet = cexi.model.PLATE_ARMOR,
        main = 72, -- Greatsword
    }),
    pointsVar = "[GARRISON]POINTS",
    dailyVar  = "[GARRISON]DAILY",
    rewardVar = "[GARRISON]DAILY_REWARD",
    dialog    =
    {
        START   = { "If you've been awarded points for defending a Garrison, you can spend them here." },
        DECLINE = { "You don't have enough points for that transaction." },
    },
}

local upgrades =
{
    {
        name = "garrison sallet",
        nq   = xi.item.GARRISON_SALLET,
        hq   = xi.item.GARRISON_SALLET_P1,
        cost = 3000,
        mats = { { xi.item.GARRISON_SALLET, 1 }, { xi.item.ORCISH_LEATHER, 6 }, { xi.item.QUADAV_THREAD, 2 } },
        desc = "6 squares of orcish leather and 2 spools of quadav thread",
    },
    {
        name = "garrison tunica",
        nq   = xi.item.GARRISON_TUNICA,
        hq   = xi.item.GARRISON_TUNICA_P1,
        cost = 5000,
        mats = { { xi.item.GARRISON_TUNICA, 1 }, { xi.item.YAGUDO_CLOTH, 8 }, { xi.item.QUADAV_THREAD, 4 } },
        desc = "8 squares of yagudo cloth and 4 spools of quadav thread",
    },
    {
        name = "pair of garrison gloves",
        nq   = xi.item.GARRISON_GLOVES,
        hq   = xi.item.GARRISON_GLOVES_P1,
        cost = 2000,
        mats = { { xi.item.GARRISON_GLOVES, 1 }, { xi.item.ORCISH_LEATHER, 4 }, { xi.item.QUADAV_THREAD, 2 } },
        desc = "4 squares of orcish leather and 2 spools of quadav thread",
    },
    {
        name = "pair of garrison hose",
        nq   = xi.item.GARRISON_HOSE,
        hq   = xi.item.GARRISON_HOSE_P1,
        cost = 4000,
        mats = { { xi.item.GARRISON_HOSE, 1 }, { xi.item.YAGUDO_CLOTH, 6 }, { xi.item.QUADAV_THREAD, 4 } },
        desc = "6 squares of yagudo cloth and 4 spools of quadav thread",
    },
    {
        name = "pair of garrison boots",
        nq   = xi.item.GARRISON_BOOTS,
        hq   = xi.item.GARRISON_BOOTS_P1,
        cost = 2000,
        mats = { { xi.item.GARRISON_BOOTS, 1 }, { xi.item.ORCISH_LEATHER, 4 }, { xi.item.QUADAV_THREAD, 2 } },
        desc = "4 squares of orcish leather and 2 spools of quadav thread",
    },
}

local cost  = { 2000, 3000, 4000 }
local extra =
{
    -----------------------------------
    -- Fort Ghelsba
    -----------------------------------
    {
        name = "druid's robe",
        id   = xi.item.DRUIDS_ROBE,
        tier =
        {
            { augs = { 9, 0,        }, mats = { { xi.item.DRUIDS_ROBE, 1 }, { xi.item.ORCISH_STEEL, 4 }, { 12616, 1 } }, desc = "4 sheets of orcish steel and a tunic +1"       }, -- MP+1
            { augs = { 9, 1,        }, mats = { { xi.item.DRUIDS_ROBE, 1 }, { xi.item.ORCISH_STEEL, 6 }, { 12626, 1 } }, desc = "6 sheets of orcish steel and a linen robe +1"  }, -- MP+2
            { augs = { 9, 2, 516, 0 }, mats = { { xi.item.DRUIDS_ROBE, 1 }, { xi.item.ORCISH_STEEL, 8 }, { 13729, 1 } }, desc = "8 sheets of orcish steel and a priests's robe" }, -- MP+3 INT+1
        },
    },
    {
        name = "tribal earring",
        id   = xi.item.TRIBAL_EARRING,
        tier =
        {
            { augs = { 1, 2,        }, mats = { { xi.item.TRIBAL_EARRING, 1 }, { xi.item.ORCISH_STEEL,  8 }, { 13326, 1 } }, desc = "8 sheets of orcish steel and a beetle earring +1"  }, -- HP+3
            { augs = { 1, 3,        }, mats = { { xi.item.TRIBAL_EARRING, 1 }, { xi.item.ORCISH_STEEL, 10 }, { 11043, 1 } }, desc = "10 sheets of orcish steel and a giant's earring"   }, -- HP+4
            { augs = { 1, 4, 512, 0 }, mats = { { xi.item.TRIBAL_EARRING, 1 }, { xi.item.ORCISH_STEEL, 12 }, { 13382, 1 } }, desc = "12 sheets of orcish steel and a puissance earring" }, -- HP+5 STR+1
        },
    },
    {
        name = "orcish axegrip",
        id   = xi.item.ORCISH_AXEGRIP,
        tier =
        {
            { augs = { 33, 1, 23, 0        }, mats = { { xi.item.ORCISH_AXEGRIP, 1 }, { xi.item.ORCISH_LEATHER, 2 }, { 19043, 1 } }, desc = "2 squares of orcish leather and a tenax strap"     }, -- DEF+2 Accuracy+1
            { augs = { 33, 2, 23, 1        }, mats = { { xi.item.ORCISH_AXEGRIP, 1 }, { xi.item.ORCISH_LEATHER, 3 }, { 19044, 1 } }, desc = "3 squares of orcish leather and a disciple grip"   }, -- DEF+3 Accuracy+2
            { augs = { 33, 3, 23, 2, 39, 1 }, mats = { { xi.item.ORCISH_AXEGRIP, 1 }, { xi.item.ORCISH_LEATHER, 4 }, { 19012, 1 } }, desc = "4 squares of orcish leather and a lizard strap +1" }, -- DEF+4 Accuracy+3 Enmity+2
        },
    },

    -----------------------------------
    -- Palborough Mines
    -----------------------------------
    {
        name = "coarse breastplate",
        id   = xi.item.COARSE_BREASTPLATE,
        tier =
        {
            { augs = { 1,  7,        }, mats = { { xi.item.COARSE_BREASTPLATE, 1 }, { xi.item.QUADAV_BRASS, 4 }, { 12599, 1 } }, desc = "4 sheets of quadav brass and a leather vest +1" }, -- HP+8
            { augs = { 1,  9,        }, mats = { { xi.item.COARSE_BREASTPLATE, 1 }, { xi.item.QUADAV_BRASS, 6 }, { 12661, 1 } }, desc = "6 sheets of quadav brass and a solid mail"      }, -- HP+10
            { augs = { 1, 11, 512, 0 }, mats = { { xi.item.COARSE_BREASTPLATE, 1 }, { xi.item.QUADAV_BRASS, 8 }, { 13697, 1 } }, desc = "8 sheets of quadav brass and a fine jerkin"     }, -- HP+12 STR+1
        },
    },
    {
        name = "terrapin traitor",
        id   = xi.item.TERRAPIN_TRAITOR,
        tier =
        {
            { augs = { 25, 0,       }, mats = { { xi.item.TERRAPIN_TRAITOR, 1 }, { xi.item.QUADAV_BRASS,  8 }, { 16748, 1 } }, desc = "8 sheets of quadav brass and a kukri +1"          }, -- Attack+1
            { augs = { 25, 1,       }, mats = { { xi.item.TERRAPIN_TRAITOR, 1 }, { xi.item.QUADAV_BRASS, 10 }, { 19127, 1 } }, desc = "10 sheets of quadav brass and a ranging knife +1" }, -- Attack+2
            { augs = { 25, 2, 45, 0 }, mats = { { xi.item.TERRAPIN_TRAITOR, 1 }, { xi.item.QUADAV_BRASS, 12 }, { 19106, 1 } }, desc = "12 sheets of quadav brass and a thug's jambiya"   }, -- Attack+3 DMG+1
        },
    },
    {
        name = "pixie shield",
        id   = xi.item.PIXIE_SHIELD,
        tier =
        {
            { augs = { 25, 1, 23, 1         }, mats = { { xi.item.PIXIE_SHIELD, 1 }, { xi.item.QUADAV_THREAD, 2 }, { 16185, 1 } }, desc = "2 spools of quadav thread and a pelte"          }, -- Attack+2 Accuracy+2
            { augs = { 25, 2, 23, 2         }, mats = { { xi.item.PIXIE_SHIELD, 1 }, { xi.item.QUADAV_THREAD, 3 }, { 12342, 1 } }, desc = "3 spools of quadav thread and a lantern shield" }, -- Attack+3 Accuracy+3
            { augs = { 25, 3, 23, 3, 329, 1 }, mats = { { xi.item.PIXIE_SHIELD, 1 }, { xi.item.QUADAV_THREAD, 4 }, { 12343, 1 } }, desc = "4 spools of quadav thread and a faerie shield"  }, -- Attack+4 Accuracy+4 Cure Potency +2%
        },
    },

    -----------------------------------
    -- Giddeus
    -----------------------------------
    {
        name = "sniper's shroud",
        id   = xi.item.SNIPERS_SHROUD,
        tier =
        {
            { augs = { 1, 3,        }, mats = { { xi.item.SNIPERS_SHROUD, 1 }, { xi.item.YAGUDO_SILVER, 4 }, { 13599, 1 } }, desc = "4 sheets of yagudo silver and a rabbit mantle +1"  }, -- HP+4
            { augs = { 1, 5,        }, mats = { { xi.item.SNIPERS_SHROUD, 1 }, { xi.item.YAGUDO_SILVER, 6 }, { 13613, 1 } }, desc = "6 sheets of yagudo silver and a traveler's mantle" }, -- HP+6
            { augs = { 1, 7, 515, 0 }, mats = { { xi.item.SNIPERS_SHROUD, 1 }, { xi.item.YAGUDO_SILVER, 8 }, { 13600, 1 } }, desc = "8 sheets of yagudo silver and a dhalmel mantle +1" }, -- HP+8 AGI+1
        },
    },
    {
        name = "gambler's chapeau",
        id   = xi.item.GAMBLERS_CHAPEAU,
        tier =
        {
            { augs = { 23, 0,        }, mats = { { xi.item.GAMBLERS_CHAPEAU, 1 }, { xi.item.YAGUDO_SILVER,  8 }, { 12531, 1 } }, desc = "8 sheets of yagudo silver and a silver hairpin +1" }, -- Accuracy+1
            { augs = { 23, 1,        }, mats = { { xi.item.GAMBLERS_CHAPEAU, 1 }, { xi.item.YAGUDO_SILVER, 10 }, { 15208, 1 } }, desc = "10 sheets of yagudo silver and a baron's chapeau"  }, -- Accuracy+2
            { augs = { 23, 2, 133, 0 }, mats = { { xi.item.GAMBLERS_CHAPEAU, 1 }, { xi.item.YAGUDO_SILVER, 12 }, { 15166, 1 } }, desc = "12 sheets of yagudo silver and a seer's crown +1"  }, -- Accuracy+3 Magic Atk. Bonus+1
        },
    },
    {
        name = "pegasus collar",
        id   = xi.item.PEGASUS_COLLAR,
        tier =
        {
            { augs = { 25, 2, 29, 2        }, mats = { { xi.item.PEGASUS_COLLAR, 1 },{ xi.item.YAGUDO_CLOTH, 2 }, { 13060, 1 } }, desc = "2 squares of yagudo cloth and a feather collar +1" }, -- Attack+3 Ranged Attack+3
            { augs = { 25, 3, 29, 3        }, mats = { { xi.item.PEGASUS_COLLAR, 1 },{ xi.item.YAGUDO_CLOTH, 3 }, { 13072, 1 } }, desc = "3 squares of yagudo cloth and a bird whistle"      }, -- Attack+4 Ranged Attack+4
            { augs = { 25, 4, 29, 4, 35, 1 }, mats = { { xi.item.PEGASUS_COLLAR, 1 },{ xi.item.YAGUDO_CLOTH, 4 }, { 13057, 1 } }, desc = "4 squares of yagudo cloth and a buburimu gorget"   }, -- Attack+5 Ranged Attack+5 Magic Accuracy+2
        },
    },
}

local weapons =
{
    xi.item.WORN_KNUCKLES,
    xi.item.WORN_SWORD,
    xi.item.WORN_AXE,
    xi.item.WORN_CHOPPER,
    xi.item.WORN_LANCE,
    xi.item.WORN_SHIELD,
    xi.item.WORN_RAPIER,
    xi.item.WORN_BLADE,
    xi.item.WORN_SCYTHE,
    xi.item.WORN_HAMMER,
    xi.item.WORN_STAFF,
    xi.item.WORN_MUSKET,
    xi.item.WORN_KNIFE,
    xi.item.WORN_KATANA,
    xi.item.WORN_TACHI,
    xi.item.WORN_POLE,
    xi.item.WORN_LONGBOW,
    xi.item.WORN_FIFE,
}

local rewards =
{
    { "Aged Box (Bayld)",   6267,                                  1000 },
    { "10K Conq. Points",   "conquest_points",                     3000 },
    { "Prismatic Cluster",  xi.item.PRISMATIC_CLUSTER,             4000 },
    { "Fire Cluster x12",   { { xi.item.FIRE_CLUSTER,      12 } },  500 },
    { "Ice Cluster x12",    { { xi.item.ICE_CLUSTER,       12 } },  500 },
    { "Wind Cluster x12",   { { xi.item.WIND_CLUSTER,      12 } },  500 },
    { "Earth Cluster x12",  { { xi.item.EARTH_CLUSTER,     12 } },  500 },
    { "Ltng. Cluster x12",  { { xi.item.LIGHTNING_CLUSTER, 12 } },  500 },
    { "Water Cluster x12",  { { xi.item.WATER_CLUSTER,     12 } },  500 },
    { "Light Cluster x12",  { { xi.item.LIGHT_CLUSTER,     12 } },  500 },
    { "Dark Cluster x12",   { { xi.item.DARK_CLUSTER,      12 } },  500 },
    { "Cherry Macaron x12", { { 5779,                      12 } },  500 }, -- Crafting skillup rate
    { "Saltena x12",        { { 5885,                      12 } },  500 }, -- Combat skillup rate
    { "Stuffed Pitaru x12", { { 5889,                      12 } },  500 }, -- Magic skillup rate
}

local rewardFunctions =
{
    ["conquest_points"] = function(player)
        cexi.util.conquest.addPoints(player, 10000)
        player:sys("{} gains 10,000 conquest points.", player:getName())

        return true
    end,

    ["incursion_expansion"] = function(player)
        player:setCharVar("[EB]INCURSION", 1)
        player:sys("You have unlocked the Incursion expansion for the Ephemeral Box!")

        return true
    end,

    ["MOGW"] = function(player, cost, balance)
        local oldSize = player:getContainerSize(xi.inv.WARDROBE8)

        -- Give Wardrobe 8 slots up to 80
        if oldSize < 80 then
            player:changeContainerSize(xi.inv.WARDROBE8, 1)

            local newSize = player:getContainerSize(xi.inv.WARDROBE8)
            player:sys("\129\154 Your Mog Wardrobe 8 capacity has been increased by 1 from {} to {}! \129\154", oldSize, newSize)

            return true
        else
            oldSize = player:getContainerSize(xi.inv.WARDROBE7)

            -- Give Wardrobe 7 slots up to 80
            if oldSize < 80 then
                player:changeContainerSize(xi.inv.WARDROBE7, 1)

                local newSize = player:getContainerSize(xi.inv.WARDROBE7)
                player:sys("\129\154 Your Mog Wardrobe 7 capacity has been increased by 1 from {} to {}! \129\154", oldSize, newSize)

                return true
            else
                player:sys("You have already reached maximum capacity with Mog Wardrobe 7/8.")
            end
        end

        return false
    end,
}

local function delaySendMenu(player, menu)
    player:timer(100, function(playerArg)
        playerArg:customMenu(menu)
    end)
end

local function getAugTier(itemInfo, itemAug)
    local tier = 0

    for augTier = 1, #itemInfo.tier do
        if
            itemInfo.tier[augTier].augs[1] == itemAug[1][1] and
            itemInfo.tier[augTier].augs[2] == itemAug[1][2] and
            itemInfo.tier[augTier].augs[3] == itemAug[2][1] and
            itemInfo.tier[augTier].augs[4] == itemAug[2][2]
        then
            tier = augTier
        end
    end

    return tier
end

local function onTrade(player, npc, trade)
    for _, itemInfo in pairs(upgrades) do
        if cexi.util.tradeHasExactly(trade, itemInfo.nq) then
            cexi.util.dialog(player, {
                fmt("To upgrade that {} you're going to need a few materials:", itemInfo.name),
                itemInfo.desc,
                fmt("It will also cost {} garrison points to authorize this procedure.", itemInfo.cost),
            }, npc:getPacketName(), { npc = npc })
        end

        if cexi.util.tradeHasExactly(trade, itemInfo.mats) then
            local balance = player:getCharVar(settings.pointsVar)

            if balance < itemInfo.cost then
                cexi.util.dialog(player, {
                    fmt("Unfortunately, you don't yet have enough garrison points for me to authorize this upgrade. You have {} points but you need {} points.", balance, itemInfo.cost),
                }, npc:getPacketName(), { npc = npc })

                return
            end

            cexi.util.dialog(player, {
                "You have done well in aiding our defenses.\n May this new piece of armor serve you well.",
            }, npc:getPacketName(), { npc = npc })

            player:tradeComplete()
            player:incrementCharVar(settings.pointsVar, -itemInfo.cost)
            player:addItem(itemInfo.hq, 1)
            player:timer(1000, function()
                npc:independentAnimation(player, 24, 2)
                player:messageSpecial(zones[player:getZoneID()].text.ITEM_OBTAINED, itemInfo.hq)
            end)
        end
    end

    for _, itemID in pairs(weapons) do
        if cexi.util.tradeHasExactly(trade, itemID) then
            cexi.util.dialog(player, {
                "Unfortunately I lack the skills to repair this fine piece.",
                " However, I heard about a Goblin in Oldton Movalpolos that can repair such equipment.",
            }, npc:getPacketName(), { npc = npc })
        end
    end

    for _, item in pairs(extra) do
        if npcUtil.tradeHas(trade, item.id, false) then
            local obj  = cexi.util.augment.getTradedItem(trade, item.id)
            local augs = cexi.util.augment.getAugments(player, obj)
            local tier = 0

            if #augs > 0 then
                tier = getAugTier(item, augs)
            end

            if tier == #cost then
                cexi.util.dialog(player, { fmt("I can't upgrade that {} any further.", item.name) }, settings.name, { npc = npc })
                return
            end

            local tierInfo = item.tier[tier + 1]

            if cexi.util.tradeHasExactly(trade, item.id) then
                local tbl =
                {
                    fmt("I see you've obtained a legendary {}. There's a few adjustments I could make to increase its power even further.", item.name),
                    fmt(" Bring it back to me with {} and I'll see what I can do.", tierInfo.desc),
                    fmt("It will cost {} garrison points to perform the upgrade.", cost[tier + 1]),
                }

                cexi.util.dialog(player, tbl, settings.name, { npc = npc })
                return
            end

            if cexi.util.tradeHasExactly(trade, tierInfo.mats) then
                if player:getCharVar(settings.pointsVar) < cost[tier +1] then
                    cexi.util.dialog(player, {
                        fmt("Unfortunately you don't have enough garrison points yet. This upgrade would cost {} garrison points.", cost[tier + 1])
                    }, settings.name, { npc = npc })

                    return
                end

                player:tradeComplete()
                player:incrementCharVar(settings.pointsVar, -cost[tier + 1])

                cexi.util.dialog(player, {
                    "Let's see here...",
                }, settings.name, { npc = npc })

                player:addItem(item.id, 1, tierInfo.augs[1], tierInfo.augs[2], tierInfo.augs[3], tierInfo.augs[4], tierInfo.augs[5], tierInfo.augs[6])
                player:timer(1000, function()
                    npc:independentAnimation(player, 24, 2)
                    player:messageSpecial(zones[player:getZoneID()].text.ITEM_OBTAINED, item.id)
                end)
            end
        end
    end
end

local function purchaseItem(player, npc, item)
    delaySendMenu(player, {
        title   = string.format("Buy %s for %u GP?", item[1], item[3] ),
        options =
        {
            {
                "No",
                function()
                end,
            },
            {
                "Yes",
                function()
                    local points = player:getCharVar(settings.pointsVar)
                    npc:facePlayer(player, true)

                    if item[3] > points then
                        player:printToPlayer(settings.name .. " : " .. settings.dialog.DECLINE[1], xi.msg.channel.NS_SAY)
                        return
                    end

                    if type(item[2]) == "string" then
                        if rewardFunctions[item[2]](player) then
                            player:setCharVar(settings.pointsVar, points - item[3])
                        end
                    else
                        if npcUtil.giveItem(player, item[2]) then
                            player:setCharVar(settings.pointsVar, points - item[3])
                        end
                    end
                end,
            },
        },
    })
end

local function openShop(player, npc)
    local points = player:getCharVar(settings.pointsVar)
    local title  = string.format("Garrison Points (%u):", points)

    npc:facePlayer(player, true)
    player:printToPlayer(settings.name .. " : " .. settings.dialog.START[1], xi.msg.channel.NS_SAY)

    local rewardsList = {}

    for _, rewardInfo in pairs(rewards) do
        table.insert(rewardsList, rewardInfo)
    end

    if player:isCrystalWarrior() then
        if player:getCharVar("[EB]INCURSION") == 0 then
            table.insert(rewardsList, { "Incursion Expansion", "incursion_expansion", 5000 })
        end
    end

    if player:isClassicMode() then
        table.insert(rewardsList, 2, { "Wardrobe 7/8 Slot", "MOGW", 1000 })
    end

    cexi.util.simpleShop(player, npc, rewardsList, purchaseItem, title)
end

local currencies =
{
    { var = fmt("[INC]MISSED_{}", xi.item.ORCISH_STEEL), itemID = xi.item.ORCISH_STEEL },
    { var = fmt("[INC]MISSED_{}", xi.item.QUADAV_BRASS), itemID = xi.item.QUADAV_BRASS },
    { var = fmt("[INC]MISSED_{}", xi.item.YAGUDO_CLOTH), itemID = xi.item.YAGUDO_CLOTH },
}

local dailyRewards =
{
    { item = xi.item.DRAGON_CHRONICLES, required = 3 },
    { item = xi.item.BEASTMAN_BANNER,   required = 6 },
    { item = { { 5780, 12 } },          required = 9 }, -- Coffee Macaron x12
}

local supplies =
{
    xi.ki.RONFAURE_SUPPLIES,
    xi.ki.ZULKHEIM_SUPPLIES,
    xi.ki.NORVALLEN_SUPPLIES,
    xi.ki.GUSTABERG_SUPPLIES,
    xi.ki.DERFLAND_SUPPLIES,
    xi.ki.SARUTABARUTA_SUPPLIES,
    xi.ki.KOLSHUSHU_SUPPLIES,
    xi.ki.ARAGONEU_SUPPLIES,
    xi.ki.FAUREGANDI_SUPPLIES,
    xi.ki.VALDEAUNIA_SUPPLIES,
    xi.ki.LITELOR_SUPPLIES,
    xi.ki.KUZOTZ_SUPPLIES,
    xi.ki.VOLLBOW_SUPPLIES,
}

local function hasSupplies(player)
    for _, keyItem in pairs(supplies) do
        if player:hasKeyItem(keyItem) then
            return true
        end
    end

    return false
end

local function onTrigger(player, npc)
    local options =
    {
         {
            "Spend Garrison Points",
            function()
                openShop(player, npc)
            end,
        },
    }

    if player:isCrystalWarrior() then
        -- Crystal Warrior
        for rewardIndex, dailyReward in pairs(dailyRewards) do
            local dailyProg     = player:getCharVar(settings.dailyVar)
            local dailyBonus    = utils.mask.countBits(dailyProg)
            local rewardClaimed = player:getCharVar(settings.rewardVar)

            if
                dailyBonus >= dailyReward.required and
                not utils.mask.getBit(rewardClaimed, rewardIndex - 1)
            then
                if npcUtil.giveItem(player, dailyReward.item) then
                    local updated = utils.mask.setBit(rewardClaimed, rewardIndex - 1, true)
                    player:setCharVar(settings.rewardVar, updated, JstMidnight())
                end

                cexi.util.dialog(player, { fmt("I'd like to give you this in recognition of clearing {} Garrisons today.", dailyReward.required) }, settings.name, { npc = npc } )

                return
            end
        end

        for _, currencyInfo in pairs(currencies) do
            local currencyQty = player:getCharVar(currencyInfo.var)

            if currencyQty > 0 then
                if npcUtil.giveItem(player, { { currencyInfo.itemID, currencyQty } }) then
                    player:setCharVar(currencyInfo.var, 0)
                end

                cexi.util.dialog(player, { "Our forces have collected these missing items from your recent Incursion." }, settings.name, { npc = npc } )

                return
            end
        end

        table.insert(options, {
            "Upgrade Equipment",
            function()
                cexi.util.dialog(player, {
                    "Found some pieces of the garrison tunica set?",
                    " If you bring them together with some rare materials, I can exchange them for high-quality versions.",
                    "Trade me a piece of the set and I'll tell you what you need.",
                }, npc:getPacketName(), { npc = npc })
            end,
        })

        table.insert(options, {
            "Undertake Allied Incursion",
            function()
                cexi.util.dialog(player, {
                    "To undertake an Allied Incursion, you'll need to collect a Beastman Banner and plant it in one of the following areas:",
                    " Fort Ghelsba (F-8), Palborough Mines (I-8), Giddeus (H-5)",
                    { delay = 1000 },
                    " Planting such a banner is sure to enrage the beastmen and force them to empty their ranks.",
                    " Beastman Banners are occasionally left behind after an assault on our Garrisons. Take a banner and bring the fight to them!",
                    { delay = 2000 },
                    "Please be aware that all intended participants must be present from the beginning of the battle.",
                    " To prevent the beastmen learning too much about our strategy, we must limit our incursions by area to once per conquest tally.",
                }, npc:getPacketName(), { npc = npc })
            end,
        })
    end

    cexi.util.dialog(player, { "How can I help you?" }, settings.name, { npc = npc } )

    if hasSupplies(player) then
        table.insert(options, {
            "Discard Supplies",
            function()
                cexi.util.dialog(player, {
                    "You want me to discard your unused outpost supplies?",
                    " Let me take care of that for you.",
                    " ...",
                    "Ok. Everything should be in order now.",
                }, npc:getPacketName(), { npc = npc })

                for _, keyItem in pairs(supplies) do
                    player:delKeyItem(keyItem)
                end
            end,
        })
    end

    delaySendMenu(player, {
        title   = "How can I help you?",
        options = options,
    })
end

cexi.util.liveReload(m, {
    [settings.area] =
    {
        {
            name      = settings.name,
            objtype   = xi.objType.NPC,
            look      = settings.look,
            x         = settings.pos[1],
            y         = settings.pos[2],
            z         = settings.pos[3],
            rotation  = settings.pos[4],
            onTrade   = onTrade,
            onTrigger = onTrigger,
        },
    },
})

return m
