-----------------------------------
-- Garrison CatsEye
-----------------------------------
require("modules/module_utils")
-----------------------------------
local m = Module:new("garrison_catseye")

local settings =
{
    pointsVar = "[GARRISON]POINTS",
    dailyVar  = "[GARRISON]DAILY",
}

local customEXP =
{
    [20] = 2000,
    [30] = 3000,
    [40] = 4000,
    [50] = 5000,
    [99] = 7000,
}

local garrisonPoints =
{
    [20] = 250,
    [30] = 300,
    [40] = 400,
    [50] = 500,
    [99] = 600,
}

-- Adds additional HP for each player present
local scalingHP =
{
    [20] = 8,
    [30] = 5,
    [40] = 3,
    [50] = 2,
    [99] = 0,
}

local customLoot =
{
    [20] =
    {
        { cexi.rate.COMMON,    656 }, -- Beastcoin
        { cexi.rate.COMMON,    750 }, -- Silver Beastcoin

        { cexi.rate.RARE,      640 }, -- Copper Ore
        { cexi.rate.RARE,      641 }, -- Tin Ore
        { cexi.rate.RARE,      643 }, -- Iron Ore

        { cexi.rate.RARE,      768 }, -- Flint Stone
        { cexi.rate.RARE,      642 }, -- Zinc Ore
        { cexi.rate.RARE,      736 }, -- Silver Ore

        { cexi.rate.RARE,      505 }, -- Sheepskin
        { cexi.rate.RARE,      852 }, -- Lizard Skin
        { cexi.rate.RARE,      856 }, -- Rabbit Hide

        { cexi.rate.RARE,      833 }, -- Moko Grass
        { cexi.rate.RARE,      834 }, -- Saruta Cotton
        { cexi.rate.RARE,      835 }, -- Flax Flower

        { cexi.rate.RARE,      880 }, -- Bone Chip
        { cexi.rate.RARE,      889 }, -- Beetle Shell
        { cexi.rate.RARE,      894 }, -- Beetle Jaw

        { cexi.rate.RARE,      689 }, -- Lauan Log
        { cexi.rate.RARE,      688 }, -- Arrowwood Log
        { cexi.rate.RARE,      691 }, -- Maple Log

        { cexi.rate.RARE,    16536 }, -- Iron Sword
        { cexi.rate.RARE,    16589 }, -- Two-handed Sword
        { cexi.rate.RARE,    17044 }, -- Warhammer

        { cexi.rate.RARE,    12449 }, -- Brass Cap
        { cexi.rate.RARE,    12577 }, -- Brass Harness
        { cexi.rate.RARE,    12705 }, -- Brass Mittens
        { cexi.rate.RARE,    12833 }, -- Brass Subligar
        { cexi.rate.RARE,    12961 }, -- Brass Leggings

        { cexi.rate.RARE,    12473 }, -- Poet's Circlet
        { cexi.rate.RARE,    12601 }, -- Linen Robe
        { cexi.rate.RARE,    12729 }, -- Linen Cuffs
        { cexi.rate.RARE,    12857 }, -- Linen Slops
        { cexi.rate.RARE,    12985 }, -- Holly Clogs

        { cexi.rate.RARE,    12457 }, -- Cotton Hachimaki
        { cexi.rate.RARE,    12585 }, -- Cotton Dogi
        { cexi.rate.RARE,    12713 }, -- Cotton Tekko
        { cexi.rate.RARE,    12841 }, -- Cotton Sitabaki
        { cexi.rate.RARE,    12969 }, -- Cotton Kyahan

        { cexi.rate.RARE,    12441 }, -- Lizard Helm
        { cexi.rate.RARE,    12569 }, -- Lizard Jerkin
        { cexi.rate.RARE,    12697 }, -- Lizard Gloves
        { cexi.rate.RARE,    12825 }, -- Lizard Trousers
        { cexi.rate.RARE,    12953 }, -- Lizard Ledelsens
    },
    [30] =
    {
        { cexi.rate.COMMON,    750 }, -- Silver Beastcoin
        { cexi.rate.COMMON,    749 }, -- Mtl. Beastcoin

        { cexi.rate.RARE,      641 }, -- Tin Ore
        { cexi.rate.RARE,      643 }, -- Iron Ore
        { cexi.rate.RARE,      645 }, -- Darksteel Ore

        { cexi.rate.RARE,      642 }, -- Zinc Ore
        { cexi.rate.RARE,      736 }, -- Silver Ore
        { cexi.rate.RARE,      644 }, -- Mythril Ore

        { cexi.rate.RARE,      857 }, -- Dhalmel Hide
        { cexi.rate.RARE,      858 }, -- Wolf Hide
        { cexi.rate.RARE,      859 }, -- Ram Skin

        { cexi.rate.RARE,      834 }, -- Saruta Cotton
        { cexi.rate.RARE,      835 }, -- Flax Flower
        { cexi.rate.RARE,      839 }, -- Crawler Cocoon

        { cexi.rate.RARE,      893 }, -- Giant Femur
        { cexi.rate.RARE,      898 }, -- Chicken Bone
        { cexi.rate.RARE,      881 }, -- Crab Shell

        { cexi.rate.RARE,      697 }, -- Holly Log
        { cexi.rate.RARE,      698 }, -- Ash Log
        { cexi.rate.RARE,      690 }, -- Elm Log

        { cexi.rate.RARE,    17218 }, -- Zamburak
        { cexi.rate.RARE,    16988 }, -- Kotetsu
        { cexi.rate.RARE,    17942 }, -- Tomahawk

        { cexi.rate.RARE,    12465 }, -- Cotton Headgear
        { cexi.rate.RARE,    12593 }, -- Cotton Doublet
        { cexi.rate.RARE,    12721 }, -- Cotton Gloves
        { cexi.rate.RARE,    12849 }, -- Cotton Brais
        { cexi.rate.RARE,    12977 }, -- Cotton Gaiters

        { cexi.rate.RARE,    12424 }, -- Iron Mask
        { cexi.rate.RARE,    12552 }, -- Chainmail
        { cexi.rate.RARE,    12680 }, -- Chain Mittens
        { cexi.rate.RARE,    12808 }, -- Chain Hose
        { cexi.rate.RARE,    12936 }, -- Greaves

        { cexi.rate.RARE,    12458 }, -- Soil Hachimaki
        { cexi.rate.RARE,    12586 }, -- Soil Gi
        { cexi.rate.RARE,    12714 }, -- Soil Tekko
        { cexi.rate.RARE,    12842 }, -- Soil Sitabaki
        { cexi.rate.RARE,    12970 }, -- Soil Kyahan

        { cexi.rate.RARE,    12474 }, -- Wool Hat
        { cexi.rate.RARE,    12602 }, -- Wool Robe
        { cexi.rate.RARE,    12730 }, -- Wool Cuffs
        { cexi.rate.RARE,    12858 }, -- Wool Slops
        { cexi.rate.RARE,    12986 }, -- Chestnut Sabots
    },
    [40] =
    {
        { cexi.rate.COMMON,    749 }, -- Mtl. Beastcoin
        { cexi.rate.COMMON,    748 }, -- Gold Beastcoin

        { cexi.rate.RARE,      643 }, -- Iron Ore
        { cexi.rate.RARE,      645 }, -- Darksteel Ore
        { cexi.rate.RARE,     1155 }, -- Iron Sand

        { cexi.rate.RARE,      736 }, -- Silver Ore
        { cexi.rate.RARE,      644 }, -- Mythril Ore
        { cexi.rate.RARE,      737 }, -- Gold Ore

        { cexi.rate.RARE,      861 }, -- Tiger Hide
        { cexi.rate.RARE,      863 }, -- Coeurl Hide
        { cexi.rate.RARE,      853 }, -- Raptor Skin

        { cexi.rate.RARE,      839 }, -- Crawler Cocoon
        { cexi.rate.RARE,      838 }, -- Spider Web
        { cexi.rate.RARE,      845 }, -- Giant Bird Feather

        { cexi.rate.RARE,      884 }, -- Blk. Tiger Fang
        { cexi.rate.RARE,      896 }, -- Scorpion Shell
        { cexi.rate.RARE,      895 }, -- Ram Horn

        { cexi.rate.RARE,      694 }, -- Chestnut Log
        { cexi.rate.RARE,      701 }, -- Rosewood Log
        { cexi.rate.RARE,      702 }, -- Ebony Log

        { cexi.rate.RARE,    16459 }, -- Acid Baselard
        { cexi.rate.RARE,    16403 }, -- Mythril Knuckles
        { cexi.rate.RARE,    17163 }, -- Battle Bow

        { cexi.rate.RARE,    12466 }, -- Red Cap
        { cexi.rate.RARE,    12594 }, -- Gambison
        { cexi.rate.RARE,    12722 }, -- Bracers
        { cexi.rate.RARE,    12850 }, -- Hose
        { cexi.rate.RARE,    12978 }, -- Socks

        { cexi.rate.RARE,    12443 }, -- Cuir Bandana
        { cexi.rate.RARE,    12571 }, -- Cuir Bouilli
        { cexi.rate.RARE,    12699 }, -- Cuir Gloves
        { cexi.rate.RARE,    12827 }, -- Cuir Trousers
        { cexi.rate.RARE,    12955 }, -- Cuir Highboots

        { cexi.rate.RARE,    12475 }, -- Velvet Hat
        { cexi.rate.RARE,    12603 }, -- Velvet Robe
        { cexi.rate.RARE,    12731 }, -- Velvet Cuffs
        { cexi.rate.RARE,    12859 }, -- Velvet Slops
        { cexi.rate.RARE,    12987 }, -- Ebony Sabots

        { cexi.rate.RARE,    13871 }, -- Iron Visor
        { cexi.rate.RARE,    13783 }, -- Icon Scale Mail
        { cexi.rate.RARE,    14001 }, -- Iron Finger Gauntlets
        { cexi.rate.RARE,    14243 }, -- Iron Cuisses
        { cexi.rate.RARE,    14118 }, -- Iron Greaves
    },
    [50] =
    {
        { cexi.rate.COMMON,    748 }, -- Gold Beastcoin
        { cexi.rate.COMMON,    751 }, -- Plt. Beastcoin

        { cexi.rate.RARE,      645 }, -- Darksteel Ore
        { cexi.rate.RARE,      657 }, -- Tama-Hagane
        { cexi.rate.RARE,      646 }, -- Adaman Ore

        { cexi.rate.RARE,      737 }, -- Gold Ore
        { cexi.rate.RARE,      738 }, -- Platinum Ore
        { cexi.rate.RARE,      739 }, -- Orichalcum Ore

        { cexi.rate.RARE,      838 }, -- Spider Web
        { cexi.rate.RARE,      816 }, -- Silk Thread
        { cexi.rate.RARE,      823 }, -- Gold Thread

        { cexi.rate.RARE,      849 }, -- Undead Skin
        { cexi.rate.RARE,     1116 }, -- Manticore Hide
        { cexi.rate.RARE,     1640 }, -- Bugard Skin

        { cexi.rate.RARE,      887 }, -- Coral Fragment
        { cexi.rate.RARE,     1193 }, -- H.Q. Crab Shell
        { cexi.rate.RARE,     1473 }, -- H.Q. Scp. Shell

        { cexi.rate.RARE,      702 }, -- Ebony Log
        { cexi.rate.RARE,      700 }, -- Mahogany Log
        { cexi.rate.RARE,      703 }, -- Petrified Log

        { cexi.rate.RARE,    13711 }, -- Carapace Mask
        { cexi.rate.RARE,    13712 }, -- Carapace Harness
        { cexi.rate.RARE,    13713 }, -- Carapace Mittens
        { cexi.rate.RARE,    12837 }, -- Carapace Subligar
        { cexi.rate.RARE,    13715 }, -- Cpc. Leggings

        { cexi.rate.RARE,    12426 }, -- Banded Helm
        { cexi.rate.RARE,    12554 }, -- Banded Mail
        { cexi.rate.RARE,    12682 }, -- Mufflers
        { cexi.rate.RARE,    12810 }, -- Breeches
        { cexi.rate.RARE,    12938 }, -- Sollerets

        { cexi.rate.RARE,    12467 }, -- Wool Cap
        { cexi.rate.RARE,    12595 }, -- Wool Gambison
        { cexi.rate.RARE,    12723 }, -- Wool Bracers
        { cexi.rate.RARE,    12851 }, -- Wool Hose
        { cexi.rate.RARE,    12979 }, -- Wool Socks

        { cexi.rate.RARE,    15205 }, -- Alumine Salade
        { cexi.rate.RARE,    14444 }, -- Alumine Haubert
        { cexi.rate.RARE,    14051 }, -- Alumine Moufles
        { cexi.rate.RARE,    15402 }, -- Alumine Brayettes
        { cexi.rate.RARE,    15341 }, -- Alumine Sollerets
    },
    [99] =
    {
        { cexi.rate.COMMON,    748 }, -- Gold Beastcoin
        { cexi.rate.COMMON,    751 }, -- Plt. Beastcoin

        { cexi.rate.RARE,      645 }, -- Darksteel Ore
        { cexi.rate.RARE,      646 }, -- Adaman Ore
        { cexi.rate.RARE,     1469 }, -- Wootz Ore

        { cexi.rate.RARE,      678 }, -- Aluminium Ore
        { cexi.rate.RARE,      738 }, -- Platinum Ore
        { cexi.rate.RARE,     2228 }, -- Luminium Ore

        { cexi.rate.RARE,      838 }, -- Spider Web
        { cexi.rate.RARE,      843 }, -- Giant Bird Plume
        { cexi.rate.RARE,      844 }, -- Phoenix Feather

        { cexi.rate.RARE,     1122 }, -- Wyvern Skin
        { cexi.rate.RARE,     1124 }, -- Wyvern Wing
        { cexi.rate.RARE,     1628 }, -- Buffalo Hide

        { cexi.rate.RARE,     1616 }, -- Antlion Jaw
        { cexi.rate.RARE,     1311 }, -- Oxblood
        { cexi.rate.RARE,      902 }, -- Demon Horn

        { cexi.rate.RARE,      700 }, -- Mahogany Log
        { cexi.rate.RARE,     1446 }, -- Lacquer Tree Log
        { cexi.rate.RARE,     1464 }, -- Lancewood Log

        { cexi.rate.RARE,    12612 }, -- Silk Cloak
        { cexi.rate.RARE,    12740 }, -- Silk Mitts
        { cexi.rate.RARE,    12868 }, -- Silk Slacks
        { cexi.rate.RARE,    12996 }, -- Silk Pumps

        { cexi.rate.RARE,    12468 }, -- Green Beret
        { cexi.rate.RARE,    12596 }, -- Battle Jupon
        { cexi.rate.RARE,    12724 }, -- Battle Bracers
        { cexi.rate.RARE,    12852 }, -- Battle Hose
        { cexi.rate.RARE,    12980 }, -- Battle Boots

        { cexi.rate.RARE,    12446 }, -- Tiger Helm
        { cexi.rate.RARE,    12574 }, -- Tiger Jerkin
        { cexi.rate.RARE,    12702 }, -- Tiger Gloves
        { cexi.rate.RARE,    12830 }, -- Tiger Trousers
        { cexi.rate.RARE,    12958 }, -- Tiger Ledelsens

        { cexi.rate.RARE,    12453 }, -- Coral Cap
        { cexi.rate.RARE,    12581 }, -- Coral Harness
        { cexi.rate.RARE,    12709 }, -- Coral Mittens
        { cexi.rate.RARE,    12878 }, -- Coral Subligar
        { cexi.rate.RARE,    12965 }, -- Coral Leggings
    },
}

local catseyeLooks =
{
    {
        "Una Mhiga R.C",
        cexi.util.look({
            race = xi.race.MITHRA,
            face = A1,
            head = 459, -- Byakko Masque
            body = 309, -- Chocobo Shirt
            hand = cexi.model.SHINOBI,
            legs = cexi.model.SHINOBI,
            feet = cexi.model.SHINOBI,
            main = 315,  -- Kunai
            sub  = 315,  -- Kunai
        }),
        "Friends are here to help each other out!",
    },

    {
        "Sharara",
        cexi.util.look({
            race = xi.race.TARU_F,
            face = 13,
            head = 0,
            body = cexi.model.TUNIC,
            hand = cexi.model.TUNIC,
            legs = cexi.model.CLOAK,
            feet = cexi.model.TUNIC,
            main = 291, -- Oak Staff
        }),
        "Time for Sharara to save the day!",
    },

    {
        "Reisle",
        cexi.util.look({
            race = xi.race.HUME_M,
            face = 5,
            head = 0,
            body = cexi.model.BRIGANDINE,
            hand = cexi.model.BRONZE_HARNESS,
            legs = cexi.model.TIGER_JERKIN,
            feet = cexi.model.BRONZE_HARNESS,
            main = 268, -- Wax Sword
        }),
        "I'm not sure if I'm ready for this yet!",
    },

    {
        "Keenajaques",
        cexi.util.look({
            race = xi.race.ELVAAN_M,
            face = cexi.face.B1,
            head = cexi.model.TRADERS_SAIO_BLACK,
            body = cexi.model.TRADERS_SAIO_BLACK,
            hand = cexi.model.TUNIC,
            legs = cexi.model.TUNIC,
            feet = cexi.model.TUNIC,
            main = 270,
        }),
        "We must find purpose within this endless conflict.",
    },

    {
        "Passing Sunrise",
        cexi.util.look({
            race = xi.race.GALKA,
            face = cexi.face.A8,
            head = cexi.model.LEATHER_VEST,
            body = 0,
            hand = cexi.model.DOUBLET,
            legs = cexi.model.LIZARD_JERKIN,
            feet = cexi.model.LEATHER_VEST,
            main = 131,
            offh = 131,
        }),
        "Glad to see you've moved beyond the Wadi.",
    },

    {
        "Iron Wolf",
        cexi.util.look({
            race = xi.race.GALKA,
            face = cexi.face.A1,
            head = cexi.model.PLATE_ARMOR,
            body = cexi.model.PLATE_ARMOR,
            hand = cexi.model.PLATE_ARMOR,
            legs = cexi.model.PLATE_ARMOR,
            feet = cexi.model.PLATE_ARMOR,
            main = 270, -- Iron Sword
            offh = 25,  -- Kite Shield
        }),
        "So hungry... Those beastmen carrying anything to eat?",
    },

    {
        "Robineaux",
        cexi.util.look({
            race = xi.race.ELVAAN_M,
            face = cexi.face.B5,
            head = cexi.model.LEATHER_VEST,
            body = cexi.model.LEATHER_VEST,
            hand = cexi.model.LEATHER_VEST,
            legs = cexi.model.LEATHER_VEST,
            feet = cexi.model.LEATHER_VEST,
            main = 159, -- Onion Knife
        }),
        "Not a great time to be without my bow...",
    },

    {
        "Erudu-Faludu",
        cexi.util.look({
            race = xi.race.TARU_M,
            face = cexi.face.A6,
            head = cexi.model.TUNIC,
            body = cexi.model.TUNIC,
            hand = cexi.model.TUNIC,
            legs = cexi.model.TUNIC,
            feet = cexi.model.TUNIC,
            main = 220, -- Onion Rod
        }),
        "W-What are you d-doing here? Uhh... I mean help!!",
    },

    {
        "Raving Fist",
        cexi.util.look({
            race = xi.race.GALKA,
            face = cexi.face.A6,
            head = cexi.model.BRONZE_HARNESS,
            body = cexi.model.KENPOGI,
            hand = cexi.model.KENPOGI,
            legs = cexi.model.BRONZE_HARNESS,
            feet = cexi.model.KENPOGI,
            main = 126, -- Fruit Punches
            offh = 4222,
        }),
        "You think you're tough huh?",
    },

    {
        "Manusiel",
        cexi.util.look({
            race = xi.race.ELVAAN_M,
            face = cexi.face.A1,
            head = cexi.model.LIZARD_JERKIN,
            body = cexi.model.LIZARD_JERKIN,
            hand = cexi.model.KENPOGI,
            legs = cexi.model.HARA_ATE,
            feet = cexi.model.KENPOGI,
            main = 154, -- Uchigatana
        }),
        "Quite fascinating how these beastmen organize...",
    },

    {
        "Nefari",
        cexi.util.look({
            race = xi.race.HUME_F,
            face = 1,
            head = 0,
            body = cexi.model.ROYAL_SQUIRE,
            hand = cexi.model.ROYAL_SQUIRE,
            legs = cexi.model.ROYAL_SQUIRE,
            feet = cexi.model.ROYAL_SQUIRE,
            main = 72, -- Greatsword
        }),
        "Time to prove you're capable in battle.",
    }
}

local catseyeHealer =
{
    {
        "Garrison Healer",
        cexi.util.look({
            race = xi.race.HUME_M,
            face = A6,
            head = cexi.model.TUNIC,
            body = cexi.model.TUNIC,
            hand = cexi.model.TUNIC,
            legs = cexi.model.TUNIC,
            feet = cexi.model.TUNIC,
            main = 292, -- Ash Staff
        }),
    },
    {
        "Garrison Healer",
        cexi.util.look({
            race = xi.race.MITHRA,
            face = A2,
            head = cexi.model.SEERS_TUNIC,
            body = cexi.model.SEERS_TUNIC,
            hand = cexi.model.SEERS_TUNIC,
            legs = cexi.model.SEERS_TUNIC,
            feet = cexi.model.SEERS_TUNIC,
            main = 113, -- Oak Staff
        }),
    },
    {
        "Garrison Healer",
        cexi.util.look({
            race = xi.race.HUME_F,
            face = A2,
            head = cexi.model.WHITE_MAGE_ARTIFACT,
            body = cexi.model.WHITE_MAGE_ARTIFACT,
            hand = cexi.model.WHITE_MAGE_ARTIFACT,
            legs = cexi.model.WHITE_MAGE_ARTIFACT,
            feet = cexi.model.WHITE_MAGE_ARTIFACT,
            main = 115, -- Time Hammer
        }),
    },
    {
        "Garrison Healer",
        cexi.util.look({
            race = xi.race.GALKA,
            face = B2,
            head = cexi.model.WHITE_MAGE_RELIC,
            body = cexi.model.WHITE_MAGE_RELIC,
            hand = cexi.model.WHITE_MAGE_RELIC,
            legs = cexi.model.WHITE_MAGE_RELIC,
            feet = cexi.model.WHITE_MAGE_RELIC,
            main = 330, -- Light Staff
        }),
    },
    {
        "Garrison Healer",
        cexi.util.look({
            race = xi.race.ELVAAN_M,
            face = B2,
            head = cexi.model.RED_MAGE_RELIC,
            body = cexi.model.RED_MAGE_RELIC,
            hand = cexi.model.RED_MAGE_RELIC,
            legs = cexi.model.RED_MAGE_RELIC,
            feet = cexi.model.RED_MAGE_RELIC,
            main = 270, -- Iron Sword
        }),
    },
    {
        "Garrison Healer",
        cexi.util.look({
            race = xi.race.ELVAAN_F,
            face = B2,
            head = cexi.model.RED_MAGE_ARTIFACT,
            body = cexi.model.RED_MAGE_ARTIFACT,
            hand = cexi.model.RED_MAGE_ARTIFACT,
            legs = cexi.model.RED_MAGE_ARTIFACT,
            feet = cexi.model.RED_MAGE_ARTIFACT,
            main = 185, -- Joyeuse
        }),
    },
    {
        "Garrison Healer",
        cexi.util.look({
            race = xi.race.HUME_M,
            face = B2,
            head = cexi.model.SCHOLAR_ARTIFACT,
            body = cexi.model.SCHOLAR_ARTIFACT,
            hand = cexi.model.SCHOLAR_ARTIFACT,
            legs = cexi.model.SCHOLAR_ARTIFACT,
            feet = cexi.model.SCHOLAR_ARTIFACT,
            main = 291, -- Oak Staff
        }),
    },
    {
        "Garrison Healer",
        cexi.util.look({
            race = xi.race.HUME_F,
            face = B2,
            head = cexi.model.SCHOLAR_RELIC,
            body = cexi.model.SCHOLAR_RELIC,
            hand = cexi.model.SCHOLAR_RELIC,
            legs = cexi.model.SCHOLAR_RELIC,
            feet = cexi.model.SCHOLAR_RELIC,
            main = 303, -- Mythic Pole
        }),
    },
}

local temps =
{
    TIER_1 =
    {
        5436, -- Dusty Reraise
        5824, -- Lucid Potion I
        5827, -- Lucid Ether I
    },

    TIER_2 =
    {
        5433, -- Dusty Elixir
        5440, -- Dusty Wing
    },

    TIER_3 =
    {
        4206, -- Catholicon
        4147, -- Body Boost
        4200, -- Mana Boost
    },
}

local function addTemps(player, tempList)
    local ID = zones[player:getZoneID()]

    for _, itemID in pairs(tempList) do
        if player:addTempItem(itemID) then
            player:messageSpecial(ID.text.ITEM_OBTAINED + 9, itemID, 1)
        end
    end
end

m:addOverride("xi.garrison.addLevelCap", function(entity, definedCap)
    super(entity, definedCap)

    if not entity:isPC() then
        return
    end

    --- Allow Unbreakable to be shattered in Garrison
    if entity:isUnbreakable() then
        entity:timer(3000, function()
            entity:setLocalVar("[CW]No_Delevel", 0)
        end)
    end

    local dailyProg  = entity:getCharVar(settings.dailyVar)
    local dailyBonus = utils.mask.countBits(dailyProg)

    -- Give temps if 3+ daily garrisons completed
    if dailyBonus >= 3 then
        addTemps(entity, temps.TIER_1)
    end

    -- Give extra temps if 6+ daily garrisons completed
    if dailyBonus >= 6 then
        addTemps(entity, temps.TIER_2)
    end

    -- Give extra temps if 9+ daily garrisons completed
    if dailyBonus >= 9 then
        addTemps(entity, temps.TIER_3)
    end

    -- Level cap the pets
    local pet = entity:getPet()

    if pet ~= nil then
        local cap = definedCap

        -- If this Garrison is uncapped, use the server max.
        if definedCap == 99 then
            cap = xi.settings.main.MAX_LEVEL
        end

        -- Note the level restriction does not wear on death.
        pet:addStatusEffectEx(xi.effect.LEVEL_RESTRICTION, xi.effect.LEVEL_RESTRICTION, cap, 0, 0, 0, 0, 0, xi.effectFlag.ON_ZONE + xi.effectFlag.CONFRONTATION)
    end
end)


local function nextPos(zoneData, allyInfo, xPos, zPos)
    local xNext = xPos
    local zNext = zPos

    if i == 6 then
        xNext = allyInfo.pos[1] - zoneData.xSecondLine
        zNext = allyInfo.pos[3] - zoneData.zSecondLine
    elseif i == 12 then
        xNext = allyInfo.pos[1] - zoneData.xThirdLine
        zNext = allyInfo.pos[3] - zoneData.zThirdLine
    else
        xNext = xNext - zoneData.xChange
        zNext = zNext - zoneData.zChange
    end

    return xNext, zNext
end

m:addOverride("xi.garrison.rollNPCs", function(zone, allyInfo, quantity)
    local npcs     = {}
    local xPos     = allyInfo.pos[1]
    local yPos     = allyInfo.pos[2]
    local zPos     = allyInfo.pos[3]
    local rot      = allyInfo.pos[4]
    local zoneID   = zone:getID()
    local zoneData = xi.garrison.zoneData[zoneID]

    local spawnQty  = quantity
    local healerQty = math.floor(spawnQty / 4)

    -- Make each healer take the place of a regular NPC
    spawnQty = spawnQty - healerQty

    if spawnQty > 11 then
        spawnQty = 11
    end

    for i = 1, spawnQty do
        table.insert(npcs, {
            name = allyInfo.name,
            look = utils.randomEntry(allyInfo.looks),
            pos  = { xPos, yPos, zPos, rot },
        })

        xPos, zPos = nextPos(zoneData, allyInfo, xPos, zPos)
    end

    local catseyeNPC = catseyeLooks[math.random(#catseyeLooks)]

    table.insert(npcs, {
        name    = catseyeNPC[1],
        look    = catseyeNPC[2],
        pos     = { xPos, yPos, zPos, rot },
        effects =
        {
            [xi.effect.REGEN] = { 5, 3, 0 }
        },
    })

    xPos, zPos = nextPos(zoneData, allyInfo, xPos, zPos)

    local players = zone:getPlayers()

    for _, player in pairs(players) do
        if player:hasStatusEffect(xi.effect.LEVEL_RESTRICTION) then
            player:timer(3000, function(playerArg)
                player:printToPlayer(string.format("%s : %s", catseyeNPC[1], catseyeNPC[3]), xi.msg.channel.NS_SAY)
            end)
        end
    end

    local healerQty = math.floor(spawnQty / 4)

    for i = 0, healerQty do
        local healer = catseyeHealer[math.random(#catseyeHealer)]

        table.insert(npcs, {
            name    = healer[1],
            look    = healer[2],
            pos     = { xPos, yPos, zPos, rot },
            healer  = true,
            effects =
            {
                [xi.effect.REFRESH] = { 5, 3, 0 }
            },
        })

        xPos, zPos = nextPos(zoneData, allyInfo, xPos, zPos)
    end

    return npcs
end)

m:addOverride("xi.garrison.spawnNPCs", function(zone, zoneData)
    local zoneID   = zone:getID()
    local nationID = GetRegionOwner(zone:getRegionID())

    if nationID > 2 then
        return false
    end

    local allyInfo = xi.garrison.getAllyInfo(zoneID, zoneData, nationID)

    -- If info is missing, a debug message will be logged and NPCs will not be spawned
    if allyInfo == nil then
        return false
    end

    -- Spawn 1 npc per player in alliance
    local npcs = xi.garrison.rollNPCs(zone, allyInfo, #zoneData.players)

    if #npcs == 0 then
        return false
    end

    for _, npcData in pairs(npcs) do
        local groupID = allyInfo.groupId

        if npcData.healer then
            groupID = groupID + 5
        end

        local mob = xi.garrison.spawnNPC(zone, zoneData, npcData.pos, npcData.name, groupID, npcData.look)

        if npcData.healer then
            mob:setMagicCastingEnabled(true)
            mob:setMobMod(xi.mobMod.MAGIC_COOL, 12)
        end

        if npcData.effects ~= nil then
            for effectID, effectInfo in pairs(npcData.effects) do
                mob:addStatusEffect(effectID, unpack(effectInfo))
            end
        end
        -- Note: This does change the mob level because ally npcs are of type mob, and
        -- level_restriction is only applied to PCs. However, we need the status to validate that the
        -- npcs are part of the garrison.
        -- Because the npcs are not level capped, group ids should be used to define min / max level.
        xi.garrison.addLevelCap(mob, zoneData.levelCap)
        table.insert(zoneData.npcs, mob:getID())
    end

    return true
end)

m:addOverride("xi.garrison.spawnMob", function(mobID, zoneData)
    local mob = SpawnMob(mobID)
    if mob == nil then
        return nil
    end

    xi.garrison.addLevelCap(mob, zoneData.levelCap)
    mob:setRoamFlags(xi.roamFlag.SCRIPTED)

    if
        zoneData.players ~= nil and
        #zoneData.players > 0
    then
        mob:setMod(xi.mod.HPP, math.ceil(scalingHP[zoneData.levelCap] * #zoneData.players))
        mob:updateHealth()
        mob:setHP(mob:getMaxHP())
    end

    table.insert(zoneData.mobs, mobID)

    -- Death listener for tracking win/lose condition
    mob:addListener('DEATH', 'GARRISON_MOB_DEATH', function(mobArg)
        zoneData.deadMobCount = zoneData.deadMobCount + 1
    end)

    -- A wave is considered complete when all mobs are done despawning
    -- and not just dead. This matters a lot because of spawn timings.
    -- I.e: If mob A dies on wave 1, and another instance of mob A is supposed
    -- to spawn on wave 2, it will not spawn as long as the previous mob is still
    -- despawning
    -- For this reason, we track both death and despawn as separate events
    mob:addListener('DESPAWN', 'GARRISON_MOB_DESPAWN', function(mobArg)
        zoneData.despawnedMobCount = zoneData.despawnedMobCount + 1
    end)

    return mob
end)

local zonesCompleted =
{
    [xi.zone.WEST_RONFAURE] =           0,
    [xi.zone.NORTH_GUSTABERG] =         1,
    [xi.zone.WEST_SARUTABARUTA] =       2,
    [xi.zone.VALKURM_DUNES] =           3,
    [xi.zone.JUGNER_FOREST] =           4,
    [xi.zone.PASHHOW_MARSHLANDS] =      5,
    [xi.zone.BUBURIMU_PENINSULA] =      6,
    [xi.zone.MERIPHATAUD_MOUNTAINS] =   7,
    [xi.zone.QUFIM_ISLAND] =            8,
    [xi.zone.BEAUCEDINE_GLACIER] =      9,
    [xi.zone.THE_SANCTUARY_OF_ZITAH] = 10,
    [xi.zone.YUHTUNGA_JUNGLE] =        11,
    [xi.zone.XARCABARD] =              12,
    [xi.zone.EASTERN_ALTEPA_DESERT] =  13,
    [xi.zone.YHOATOR_JUNGLE] =         14,
    [xi.zone.CAPE_TERIGGAN] =          15,
}

-- We override this to add additional rewards
m:addOverride("xi.garrison.handleGilPayout", function(levelCap, players)
    super(levelCap, players)

    for _, player in pairs(players) do
        if player ~= nil then
            local rewardEXP = customEXP[levelCap] * xi.settings.main.EXP_RATE

            if player:getJobLevel(player:getMainJob()) >= 75 then
                rewardEXP = rewardEXP * 4
            end

            player:addExp(rewardEXP)
            player:incrementCharVar(settings.pointsVar, garrisonPoints[levelCap])
            player:printToPlayer(string.format("%s gains %u garrison points.", player:getName(), garrisonPoints[levelCap]), xi.msg.channel.SYSTEM_3)

            local nation = player:getNation()
            local region = player:getCurrentRegion() + 5

            if not player:hasTeleport(nation, region) then
                player:addTeleport(nation, region)
                player:sys("You have unlocked a new outpost!")
            end

            -- Player's nation gains 10% equivalent influence over the region
            -- Players usually gain influence as 5% of normal EXP received
            player:addInfluencePoints(customEXP[levelCap] / 10)

            local zoneID        = player:getZoneID()
            local zoneCompleted = zonesCompleted[zoneID]
            local current       = player:getCharVar(settings.dailyVar)

            if
                zoneCompleted ~= nil and
                not utils.mask.getBit(current, zoneCompleted)
            then
                local updated = utils.mask.setBit(current, zoneCompleted, true)
                player:setCharVar(settings.dailyVar, updated, getMidnight())

                local dailyBonus = utils.mask.countBits(updated)

                if
                    dailyBonus == 3 or
                    dailyBonus == 6 or
                    dailyBonus == 9
                then
                    player:sys("You have unlocked new temporary items for today's Garrisons!")
                end

                cexi.util.helperScroll(player, 1)
            end
        end
    end
end)

m:addOverride("xi.garrison.handleLootRolls", function(levelCap, players)
    super(levelCap, players)

    for _, player in ipairs(players) do
        if player ~= nil then
            for i = 1, 3 do
                local result = cexi.util.pickItem(customLoot[levelCap])
                player:addTreasure(result[2])
            end

            if
                player:isCrystalWarrior() and
                math.random(0, 100) < 15
            then
                player:addTreasure(xi.item.BEASTMAN_BANNER)
            end

            return
        end
    end
end)

-- Garrison Pass System
m:addOverride("xi.garrison.onTrade", function(player, npc, trade, guardNation)
    if not xi.settings.main.ENABLE_GARRISON then
        return false
    end

    -- Get zone information
    local zone     = player:getZone()
    local zoneID   = zone:getID()
    local zoneData = xi.garrison.zoneData[zoneID]

    -- If called outside of Garrison areas
    if not zoneData then
        return
    end

    local nationID = GetRegionOwner(zone:getRegionID())

    -- If info is missing, a debug message will be logged and Garrison will not begin
    if xi.garrison.getAllyInfo(zoneID, zoneData, nationID) == nil then
        player:printToPlayer('Garrison is currently unavailable for this region.', xi.msg.channel.SYSTEM_3)

        return false
    end

    if
        npcUtil.tradeHasExactly(trade, zoneData.itemReq) or
        (cexi.util.tradeHasExactly(trade, xi.item.GARRISON_PASS) and cexi.bundle.hasPass(player, zoneData.itemReq)) -- Intentionally non-locking so pass is not consumed
    then
        if not xi.garrison.validateEntry(zoneData, player, npc, guardNation) then
            return false
        end

        -- Consume charge on the pass if used
        if cexi.util.tradeHasExactly(trade, xi.item.GARRISON_PASS) then
            cexi.bundle.usePass(player, zoneData.itemReq)
        end

        -- Start CS
        player:startEvent(32753 + player:getNation())
        player:setLocalVar('GARRISON_NPC', npc:getID())

        return true
    end

    return false
end)

return m
