-----------------------------------
-- Fishing Fatigue
-----------------------------------
require("modules/module_utils")
-----------------------------------
local m      = Module:new("fishing_fatigue")
local caught = "[FISHING]CAUGHT";

local catchTypes =
{
    SMALL_FISH = 1,
    BIG_FISH   = 2,
    ITEM       = 3,
}

m:addOverride("xi.player.onPlayerFishingResult", function(player, catchType, itemID, itemQty, weight)
    super(player, catchType, itemID, itemQty, weight)

    if itemID == 0 then
        return
    end

    if
        catchType == catchTypes.SMALL_FISH or
        catchType == catchTypes.BIG_FISH or
        catchType == catchTypes.ITEM
    then
        local currCaught = player:getCharVar(caught)
        if currCaught == 0 then
            -- cpp module only messages them once
            player:setLocalVar('FishingFatigueMessage', 0)
        end

        player:setCharVar(caught, currCaught + 1, getMidnight())
    end
end)

return m
