-----------------------------------
-- Sahagin - Fishing quests
-----------------------------------
require("modules/module_utils")
require('scripts/globals/npc_util')
require("scripts/globals/shop")
require("scripts/globals/utils")
-----------------------------------
local m = Module:new("npc_sahagin")

local settings =
{
    vars   =
    {
        PROGRESS     = "[FISHING]SAHAGIN",
        SILVER       = "[FISHING]SILVER",
    },

    enabled = false
}

local function onTriggerCargo(player, npc)
end

local function onTradeCargo(player, npc, trade)
end

if settings.enabled then
    cexi.util.liveReload(m, {
        ["Sea_Serpent_Grotto"] =
        {
            {
                objtype   = xi.objType.NPC,
                name      = "Slippery Sam", -- !pos -105.021 8.992 -311.431 176
                look      = 1306,
                x         = -105.021,
                y         = 8.992,
                z         = -311.431,
                rotation  = 198,
                flags     = 1153,
                widescan  = 1,
                onTrigger = function(player, npc)

                end,
            },
            {
                objtype   = xi.objType.NPC,
                name      = "Hungry Horace",
                look      = 1299,
                x         = -91.937,
                y         = 9.342,
                z         = -297.914,
                rotation  = 125,
                flags     = 1153,
                widescan  = 1,
                onTrigger = function(player, npc)
                    cexi.util.dialog(player, {
                        "So hungry... Has you fish? Me pay s~silver!",
                        " Today eats~s %s, %s, %s, quickly go! Fish catch!",
                    }, "Hungry Horace", { npc = npc, [1] = fish1, [2] = fish2, [3] = fish3 })
                end,
            },
            {
                objtype   = xi.objType.NPC,
                name      = "Crafty Collie",
                look      = 1338,
                x         = -92.131,
                y         = 10.071,
                z         = -303.295,
                rotation  = 135,
                widescan  = 1,
                onTrigger = function(player, npc)
                    --[[]
                    cexi.util.dialog(player, {
                        "No no no... waits~ss tomorrow.",
                    }, "Crafty Collie", { npc = npc })
                    ]]

                    cexi.util.dialog(player, {
                        "S~Shiny so shiny... Gets~s Eastern Gem x12, friend~ly makes.",
                    }, "Crafty Colin", { npc = npc })
                end,
            },
            {
                objtype   = xi.objType.NPC,
                name      = "Jumping Jonah",
                look      = 1323,
                x         = -109.218,
                y         = 9.387,
                z         = -298.451,
                rotation  = 24,
                widescan  = 1,
                onTrigger = function(player, npc)
                end,
            },
        }
    })
end

return m
