-----------------------------------
-- Buccaneer's Chart
-----------------------------------
require("modules/module_utils")
require('scripts/globals/npc_util')
-----------------------------------
local m = Module:new("fising_buccaneers_chart")

local settings = 
{
    itemID   = xi.item.BUCCANEERS_CHART,
    itemName = "buccaneer's chart",
    zoneName = "Cape_Teriggan",
    boxName  = "Barnacled Box",
    qmName   = "Unsettled Sand",
    pos      = { 34.166, 4.000, -159.581, 61 },

    mobs     =
    {
        {
            name        = "Aur the Defiant",
            level       = 75,
            pos         = { 34.432, 4.000, -164.516, 190 },
            groupZoneId = 176, -- Ocean Sahagin (SSG)
            groupId     = 57,
            look        = 1310,
            special     = true,
        },

        {
            name        = "Cape Monk",
            level       = 75,
            pos         = { 37.225, 4.000, -165.113, 160 },
            groupZoneId = 176, -- Devil Manta (SSG)
            groupId     = 49,
            look        = 353,
            special     = true,
        },

        {
            name        = "Heiji Crab",
            level       = 75,
            pos         = { 31.211, 4.000, -165.565, 210 },
            groupZoneId = 153, -- Steelshell (TBT)
            groupId     = 21,
            look        = 2965,
            special     = true,
        },
    },

    loot =
    {
        {
            { cexi.rate.VERY_COMMON,    4484 }, -- Shall Shell       (24%)
            { cexi.rate.COMMON,          624 }, -- Pamtam Kelp       (15%)
            { cexi.rate.COMMON,        17006 }, -- Drill Calamary    (15%)
            { cexi.rate.UNCOMMON,      17007 }, -- Dwarf Pugil       (10%)
            { cexi.rate.UNCOMMON,       1893 }, -- Salinator         (10%)
            { cexi.rate.UNCOMMON,       4304 }, -- Grimmonite        (10%)
            { cexi.rate.RARE,           1193 }, -- H.Q. Crab Shell.  ( 5%)
            { cexi.rate.RARE,            887 }, -- Coral Fragment    ( 5%)
            { cexi.rate.RARE,           1311 }, -- Oxblood           ( 5%)
            { cexi.rate.VERY_RARE,      1312 }, -- Angel Skin        ( 1%)
        },
        {
            { cexi.rate.VERY_COMMON,    4484 }, -- Shall Shell       (24%)
            { cexi.rate.COMMON,         1446 }, -- Lacquer Tree Log  (15%)
            { cexi.rate.COMMON,        17006 }, -- Drill Calamary    (15%)
            { cexi.rate.COMMON,        17007 }, -- Dwarf Pugil       (15%)
            { cexi.rate.UNCOMMON,       4383 }, -- Gold Lobster      (10%)
            { cexi.rate.UNCOMMON,       4361 }, -- Nebimonite        (10%)
            { cexi.rate.RARE,            887 }, -- Coral Fragment    ( 5%)
            { cexi.rate.RARE,           1312 }, -- Angel Skin        ( 5%)
            { cexi.rate.VERY_RARE,       722 }, -- Divine Log        ( 1%)
        },
        {
            { 950, 19283 }, -- Rusty Kunai     (95%)
            {  50, 20717 }, -- Mercurial Kunai ( 5%)
        },
        {
            { cexi.rate.GUARANTEED,    15555 }, -- Albatross Ring    (24%) (50%)
            { cexi.rate.GUARANTEED,    15556 }, -- Penguin Ring      (24%) (50%)
        },
    },
}

-----------------------------------
-- Utilities
-----------------------------------
local function spawnChest(player, loc)
    local zone   = player:getZone()
    local entity =
    {
        name        = "Barnacled Box",
        objtype     = xi.objType.NPC,
        look        = 961,
        x           = loc[1],
        y           = loc[2],
        z           = loc[3],
        rotation    = loc[4],
        widescan    = 1,

        onTrigger   = function(playerArg, npcArg)
           if playerArg:getLocalVar("[CHART]Finished") == 0 then
                playerArg:fmt("It's locked.")
                return
            end

            if npcArg:getLocalVar("opened") == 0 then
                npcArg:setLocalVar("opened", 1)
                npcArg:entityAnimationPacket('openH')

                local party = playerArg:getParty()

                for _, member in pairs(party) do
                    member:setLocalVar("[CHART]Finished", 0)
                end

                for _, itemInfo in pairs(settings.loot) do
                    local pick = cexi.util.pickItem(itemInfo)
                    playerArg:addTreasure(pick[2], npcArg)
                end

                npcArg:timer(16000, function(npcArg2)
                    cexi.util.removeNPC(npcArg2)
                end)
            end
        end,

        releaseIdOnDisappear = true,
    }

    local npc = zone:insertDynamicEntity(entity)

    npc:hideName(true)
    npc:hideHP(true)

    npc:timer(120000, function(npcArg)
        if npcArg ~= nil then
            cexi.util.removeNPC(npcArg)
        end
    end)
end

local function onTrigger(player, npc)
    player:fmt("There is nothing out of the ordinary here.")
end

local function onTrade(player, npc, trade)
    if player:getPartySize() > 3 then
        player:fmt("Nothing happens. Your party exceeds the maximum number of 3 members.")
        return
    elseif player:checkSoloPartyAlliance() == 2 then
        player:fmt("Nothing happens. You must dissolve your alliance.")
        return
    end

    if npcUtil.tradeHasExactly(trade, settings.itemID) then
        player:fmt("You return the {} to the sea.", settings.itemName)
        player:confirmTrade(player)

        local party = player:getParty()

        for _, member in pairs(party) do
            cexi.util.setMusic(member, 136)
            member:delStatusEffectsByFlag(xi.effectFlag.DISPELABLE)
        end

        cexi.util.spawnEncounter(player, npc, {
            capped = 70,
            mobs   = settings.mobs,
            after  = function(mob, playerArg)
                if playerArg == nil then
                    return
                end

                local party = playerArg:getParty()

                for _, member in pairs(party) do
                    cexi.util.setMusic(member, { 0, 0, 101, 102 })
                    member:setLocalVar("[CHART]Finished", 1)
                end

                spawnChest(player, { mob:getXPos(), mob:getYPos(), mob:getZPos() })
            end,
        })
    end
end

cexi.util.liveReload(m, {
    [settings.zoneName] =
    {
        {
            objtype   = xi.objType.NPC,
            name      = settings.qmName,
            look      = 52,
            x         = settings.pos[1],
            y         = settings.pos[2],
            z         = settings.pos[3],
            rotation  = settings.pos[4],
            widescan  = 1,
            onTrigger = onTrigger,
            onTrade   = onTrade,
        }
    }
})

return m
