-----------------------------------
-- Escha Ru'Aun NM Deck
-----------------------------------
-- Creates portals and spawners for Sky 2.0
-----------------------------------
require("modules/module_utils")
-----------------------------------
local m = Module:new("escha_ruaun_spawners")

local mobs =
{
    {
        name   = "Suzaku",
        pos    = { -521.813, -70.220, -270.628, 239 },
        portal =
        {
            name = "Suzaku Portal",
            pos  = { -359.060, -40.105, -255.183,  28 },
            dest = { -453.837, -71.552, -308.441, 102 },
        },
        beacon =
        {
            name = "Fire Beacon",
            pos  = { -492.100, -70.020, -253.984,  0 },
        },
    },
    {
        name   = "Byakko",
        pos    = { -415.262, -70.280, 408.908, 26 },
        portal =
        {
            name = "Byakko Portal",
            pos  = { -353.819, -40.105, 262.473,  28 },
            dest = { -432.945, -71.552, 336.247, 156 },
        },
        beacon =
        {
            name = "Light Beacon",
            pos  = { -393.230, -70.020, 390.329, 0 },
        },
    },
    {
        name   = "Genbu",
        pos    = { -415.262, -70.280, 408.908, 26 },
        portal =
        {
            name = "Genbu Portal",
            pos  = { 140.386, -40.147, 417.497,  28 },
            dest = { 185.649, -71.552, 515.620, 211 },
        },
        beacon =
        {
            name = "Water Beacon",
            pos  = { 261.906, -70.219, 526.206, 78 },
        },
    },
    {
        name   = "Seiryu",
        pos    = { -415.262, -70.280, 408.908, 26 },
        portal =
        {
            name = "Seiryu Portal",
            pos  = { 440.573, -40.106, -4.610, 28 },
            dest = { 548, -71, -17, 0 },
        },
        beacon =
        {
            name = "Wind Beacon",
            pos  = { 578.687, -70.220, -87.668, 130 },
        },
    },
    {
        name   = "Kirin",
        pos    = { -0.769, -54.040, -600.119, 67 },
        beacon =
        {
            name = "Avatar Beacon",
            pos  = { -1.216, -55.240, -632.844, 0 },
        },
    },
}

local entities = {}

for _, mobInfo in pairs(mobs) do
    if mobInfo.portal ~= nil then
        table.insert(entities, {
            name      = mobInfo.portal.name,
            objtype   = xi.objType.NPC,
            look      = 2492,
            x         = mobInfo.portal.pos[1],
            y         = mobInfo.portal.pos[2],
            z         = mobInfo.portal.pos[3],
            rotation  = mobInfo.portal.pos[4],

            onTrigger = function(player, npc)
                player:injectActionPacket(player:getID(), 6, 600, 0, 0, 0, 0, 0)

                player:timer(2000, function()
                    player:setPos(unpack(mobInfo.portal.dest))
                end)

                player:timer(2750, function()
                    player:injectActionPacket(player:getID(), 6, 602, 0, 0, 0, 0, 0)
                end)
            end,
        })
    end

    table.insert(entities, {
        name      = mobInfo.beacon.name,
        objtype   = xi.objType.NPC,
        look      = 2824,
        x         = mobInfo.beacon.pos[1],
        y         = mobInfo.beacon.pos[2],
        z         = mobInfo.beacon.pos[3],
        rotation  = mobInfo.beacon.pos[4],

        onTrigger = function(player, npc)
            local varName  = fmt("[SKY2]{}_POP",   mobInfo.name)
            local varFight = fmt("[SKY2]{}_FIGHT", mobInfo.name)

            if player:getCharVar(varName) == 0 then
                player:fmt("You are unable to use this right now.")
                return
            end

            local zone   = player:getZone()
            local result = zone:queryEntitiesByName(mobInfo.name)

            if
                result == nil or
                result[1] == nil or
                result[1]:isAlive()
            then
                player:fmt("You are unable to use this right now.")
                return
            end

            player:customMenu({
                title   = fmt("Ready to battle {}?", mobInfo.name),
                options =
                {
                    {
                        "No, not yet.",
                        function()
                            player:fmt("I'll be waiting...")
                        end,
                    },
                    {
                        "Yes, I'm ready!",
                        function()
                            local timeStamp = os.time()

                            player:setCharVar(varName, 0)
                            player:setCharVar(varFight, timeStamp)
                            SetServerVariable(varFight, timeStamp)

                            cexi.util.forAlliance(player, function(member)
                                member:fmt("You can feel a thunderous force culminating beneath you...")
                            end)

                            player:timer(3000, function()
                                result[1]:setSpawn(unpack(mobInfo.pos))
                                result[1]:spawn()
                                result[1]:updateClaim(player)
                            end)
                        end,
                    },
                },
                onStart = function()
                    player:fmt("By confirming \"Yes\", your {} key item will be consumed and the fight will begin right away.", mobInfo.name)
                end,
            })
        end,
    })
end

cexi.util.liveReload(m, {
    ["Escha_RuAun"] = entities
})

return m
