-------------------------------------------
-- Escha RuAun Portal NPCs
-------------------------------------------
-- !pos -8.698 -34.000 -460.195 289
-------------------------------------------
require("modules/module_utils")
require("scripts/globals/npc_util")
require("scripts/globals/utils")
-------------------------------------------
local ID = require("scripts/zones/Escha_RuAun/IDs")

local m = Module:new("escha_ruaun_portals")

local function returnMenu(player)
    local menu =
    {
        title = "Return to Entrance?",
        options =
        {
            {
                "Yes, take me back.",
                function(playerarg)
                    player:injectActionPacket(player:getID(), 6, 600, 0, 0, 0, 0, 0)
        
                    player:timer(2000, function(playerArg)
                       player:setPos(-0.371, -34.278, -466.980, 192)
                    end)
        
                    player:timer(2750, function(playerArg)
                        player:injectActionPacket(player:getID(), 6, 602, 0, 0, 0, 0, 0)
                    end)
                end,
            },
            {
                "No, I'm not finished yet!",
                function(playerArg)
                end,
            },
        },
    }

    player:customMenu(menu)
end

local popInfo =
{
    {
        scraps   = { 3277, 25 },
        mobName  = "Seiryu",
        varName  = "[SKY2]Seiryu_POP",
        location = "Seiryu's Shadows",
        pos      = { 451.753, -3.790, -146.248, 141 },
    },
    {
        scraps   = { 3276, 25 },
        mobName  = "Suzaku",
        varName  = "[SKY2]Suzaku_POP",
        location = "Suzaku's Nest",
        pos      = { -454.030, -3.626, -147.184, 0 },
    },
    {
        scraps   = { 3278, 25 },
        mobName  = "Byakko",
        varName  = "[SKY2]Byakko_POP",
        location = "Byakko's Pride",
        pos      = { -280.484, -3.626, 386.104, 36 },
    },
    {
        scraps   = { 3275, 25 },
        mobName  = "Genbu",
        varName  = "[SKY2]Genbu_POP",
        location = "Genbu's Cove",
        pos      = { 278.092, -3.998, 382.416, 88 },
    },
}

xi.module.ensureTable("xi.zones.Escha_RuAun.npcs.Dremi")

cexi.util.reloadOverride(m, "xi.zones.Escha_RuAun.npcs.Dremi.onTrade", function(player, npc, trade)
    if
        not player:hasKeyItem(xi.keyItem.CERULEAN_CRYSTAL) or
        not (
            player:getRank(xi.nation.SANDORIA) >= 10 or
            player:getRank(xi.nation.BASTOK) >= 10 or
            player:getRank(xi.nation.WINDURST) >= 10
        )
    then
        player:printToPlayer("Dremi : You are not yet prepared to tackle these challenges!", xi.msg.channel.NS_SAY)
        return
    end

    for _, pop in pairs(popInfo) do
        if npcUtil.tradeHas(trade, { pop.scraps }) then
            if player:getCharVar(pop.varName) > 0 then
                player:printToPlayer(string.format("Dremi : Hmm.... it looks like you're already ready to face %s.", pop.mobName), xi.msg.channel.NS_SAY)
                return
            else
                player:tradeComplete()
                player:setCharVar(pop.varName, 1)
                player:printToPlayer(string.format("Dremi : Here you are! You're now ready to take on %s... Make your way to %s!", pop.mobName, pop.location), xi.msg.channel.NS_SAY)
            end
        end
    end
end)

cexi.util.reloadOverride(m, "xi.zones.Escha_RuAun.npcs.Dremi.onTrigger", function(player, npc)
    if
        not player:hasKeyItem(xi.keyItem.CERULEAN_CRYSTAL) or
        not (
            player:getRank(xi.nation.SANDORIA) >= 10 or
            player:getRank(xi.nation.BASTOK) >= 10 or
            player:getRank(xi.nation.WINDURST) >= 10
        )
    then
        player:printToPlayer("Dremi : You are not yet prepared to tackle these challenges!", xi.msg.channel.NS_SAY)
        return
    end

    if
        player:hasKeyItem(xi.ki.BYAKKOS_PRIDE) and player:hasKeyItem(xi.ki.GENBUS_HONOR) and
        player:hasKeyItem(xi.ki.SEIRYUS_NOBILITY) and player:hasKeyItem(xi.ki.SUZAKUS_BENEFACTION)
    then
        for i = 2948, 2951 do
            player:delKeyItem(i)
            player:messageSpecial(ID.text.KEYITEM_OBTAINED + 1, i)
        end

        player:setCharVar("[SKY2]Seiryu_POP", 0)
        player:setCharVar("[SKY2]Suzaku_POP", 0)
        player:setCharVar("[SKY2]Byakko_POP", 0)
        player:setCharVar("[SKY2]Genbu_POP", 0)
        player:setCharVar("[SKY2]Kirin_POP", 1)

        player:timer(2000, function(playerArg)
            player:printToPlayer("Dremi : Ready to face the big guy, are we? Don't worry! You're gonna do great!", xi.msg.channel.NS_SAY)
        end)

        player:timer(4000, function(playerArg)
            player:printToPlayer("Dremi rolls her eyes at you ...", xi.msg.channel.UNKNOWN_32)
        end)

        player:timer(6000, function(playerArg)
            player:printToPlayer("Dremi : Well, head on over to the Eschan Portal behind you and beam on up. Good luck!", xi.msg.channel.NS_SAY)
        end)
    else
        player:printToPlayer("Dremi : My, oh my! Look at those muscles...", xi.msg.channel.NS_SAY)
    
        player:timer(1000, function(playerArg)
            player:printToPlayer("You begin feeling like a piece of meat as Dremi looks you up and down...", xi.msg.channel.UNKNOWN_32)
        end)
        
        player:timer(4000, function(playerArg)
            player:printToPlayer("Dremi : You're going to do just fine here, darling... Trade me 25 scraps to get started.", xi.msg.channel.NS_SAY)
        end)
    end
end)

cexi.util.reloadOverride(m, "xi.zones.Misareaux_Coast.npcs.Undulating_Confluence.onTrigger", function(player, npc)
    if
        -- Dynamis Lord defeated
        player:hasTitle(xi.title.LIFTER_OF_SHADOWS) or
        player:hasKeyItem(xi.keyItem.HYDRA_CORPS_BATTLE_STANDARD)
    then
        player:startEvent(14)
    else
        player:printToPlayer("You do not meet the requirements to enter this area yet.")
    end
end)

local function getLocation(player, name, pos)
    return {
        name,
        function()
            player:printToPlayer("Electricity begins surging through your body!!", xi.msg.channel.NS_SAY)
            player:injectActionPacket(player:getID(), 6, 600, 0, 0, 0, 0, 0)

            player:timer(2000, function(playerArg)
                playerArg:setPos(unpack(pos))
            end)

            player:timer(2750, function(playerArg)
                playerArg:injectActionPacket(player:getID(), 6, 602, 0, 0, 0, 0, 0)
            end)
        end,
    }
end

cexi.util.reloadOverride(m, "xi.zones.Escha_RuAun.npcs.Eschan_Portal_#1.onTrigger", function(player, npc)
    local options = {}

    for _, info in pairs(popInfo) do
        table.insert(options, getLocation(player, info.mobName, info.pos))
    end

    table.insert(options, getLocation(player, "???", { -1.626, -52.365, -583.528, 65 }))

    local menu =
    {
        title   = "Choose your destination",
        options = options,
    }

    player:customMenu(menu)
end)

local portals =
{
    "Eschan_Portal_#2",
    "Eschan_Portal_#3",
    "Eschan_Portal_#4",
    "Eschan_Portal_#5",
    "Eschan_Portal_#6",
    "Eschan_Portal_#7",
    "Eschan_Portal_#8",
    "Eschan_Portal_#9",
    "Eschan_Portal_#10",
    "Eschan_Portal_#11",
    "Eschan_Portal_#12",
    "Eschan_Portal_#13",
    "Eschan_Portal_#15",
}

for _, portal in pairs(portals) do
    cexi.util.reloadOverride(m, string.format("xi.zones.Escha_RuAun.npcs.%s.onTrigger", portal), function(player, npc)
        returnMenu(player)
    end)
end

return m
