-----------------------------------
-- NPC: Freya (Dynamis currency storage)
-----------------------------------
require("modules/module_utils")
local cq = require('modules/catseyexi/lua/additive_overrides/utils/custom_quest')
-----------------------------------
local m = Module:new("freya")

local currencyTable =
{
    { currency = xi.item.TUKUKU_WHITESHELL,     var = '[NEO]STORED_1449', name = 'tukuku whiteshell'     },
    { currency = xi.item.LUNGO_NANGO_JADESHELL, var = '[NEO]STORED_1450', name = 'lungo-nango jadeshell' },
    { currency = xi.item.ORDELLE_BRONZEPIECE,   var = '[NEO]STORED_1452', name = 'ordelle bronzepiece'   },
    { currency = xi.item.MONTIONT_SILVERPIECE,  var = '[NEO]STORED_1453', name = 'montiont silverpiece'  },
    { currency = xi.item.ONE_BYNE_BILL,         var = '[NEO]STORED_1455', name = 'one byne bill'         },
    { currency = xi.item.ONE_HUNDRED_BYNE_BILL, var = '[NEO]STORED_1456', name = 'one hundred byne bill' },
    { currency = xi.item.FORGOTTEN_THOUGHT,     var = '[NEO]STORED_3493', name = 'forgotten thought'     },
    { currency = xi.item.FORGOTTEN_HOPE,        var = '[NEO]STORED_3494', name = 'forgotten hope'        },
    { currency = xi.item.FORGOTTEN_TOUCH,       var = '[NEO]STORED_3495', name = 'forgotten touch'       },
    { currency = xi.item.FORGOTTEN_JOURNEY,     var = '[NEO]STORED_3496', name = 'forgotten journey'     },
    { currency = xi.item.FORGOTTEN_STEP,        var = '[NEO]STORED_3497', name = 'forgotten step'        },
}

local function delaySendMenu(player, menu)
    player:timer(100, function(playerArg)
        playerArg:customMenu(menu)
    end)
end

local function confirmTrade(player, item)
    local storedBronzepiece = player:getCharVar('[NEO]STORED_1452')
    local storedSilverpiece = player:getCharVar('[NEO]STORED_1453')
    local storedWhiteshells = player:getCharVar('[NEO]STORED_1449')
    local storedJadeshells  = player:getCharVar('[NEO]STORED_1450')
    local storedBynebills   = player:getCharVar('[NEO]STORED_1455')
    local storedHundredByne = player:getCharVar('[NEO]STORED_1456')
    local storedThought     = player:getCharVar('[NEO]STORED_3493')
    local storedHope        = player:getCharVar('[NEO]STORED_3494')
    local storedTouch       = player:getCharVar('[NEO]STORED_3495')
    local storedJourney     = player:getCharVar('[NEO]STORED_3496')
    local storedStep        = player:getCharVar('[NEO]STORED_3497')
    local withdrawalItem    = player:getCharVar('[NEO]STORED_' .. item)

    if withdrawalItem < 1 then
        player:printToPlayer('Freya : Please bank additional currency before continuing.', xi.msg.channel.NS_SAY)
        return
    end

    local confirmMenu =
    {
        title   = string.format('Withdraw (%i) from banked currency?', withdrawalItem),
        options =
        {
            {
                'No',
                function(playerArg)
                    return
                end,
            },
            {
                'Yes',
                function(playerArg)
                    if withdrawalItem > 99 then
                        withdrawalItem = 99
                        if npcUtil.giveItem(player, {{ item, withdrawalItem }}) then
                            -- Only remove one stack at a time since npcUtil.giveItem only checks for one inventory slot
                            player:setCharVar('[NEO]STORED_' .. item, player:getCharVar('[NEO]STORED_' .. item) - 99)
                            player:printToPlayer('Freya : Please be aware that I can only return one stack of currency per transaction.', xi.msg.channel.NS_SAY)
                            player:printToPlayer('Freya : I\'ve returned your currency, as requested. Have a pleasant day!', xi.msg.channel.NS_SAY)
                            return
                        end
                    elseif npcUtil.giveItem(player, {{ item, withdrawalItem }}) then
                        player:setCharVar('[NEO]STORED_' .. item, 0)
                        player:printToPlayer('Freya : I\'ve returned your currency, as requested. Have a pleasant day!', xi.msg.channel.NS_SAY)
                        return
                    else
                        player:printToPlayer('Freya : Please return after sorting your inventory.', xi.msg.channel.NS_SAY)
                    end
                end,
            },
        },
    }

    delaySendMenu(player, confirmMenu)
end

m:addOverride("xi.zones.Tavnazian_Safehold.Zone.onInitialize", function(zone)
    -- Call the zone's original function for onInitialize
    super(zone)

    local teodor = zone:insertDynamicEntity({
        objtype  = xi.objType.NPC,
        name     = string.char(0xAA) .. 'Freya Q.M.',
        look = cexi.util.look({
            race = xi.race.HUME_F,
            face = cexi.face.B3,
            head = 111,
            body = 302,
            hand = 120,
            legs = 208,
            feet = 208,
            main = 424,
        }),
        x        = -5.442,
        y        = -24.998,
        z        = 54.385,
        rotation = 255,
        widescan = 1,

        onTrade = function(player, npc, trade)
            local currencyTraded   = 0
            local currenctQuantity = 0
            local currencyBalance  = 0
            local completeTrade    = false

            for _, v in pairs(currencyTable) do
                currencyTraded   = v.currency
                currenctQuantity = trade:getItemQty(currencyTraded)
                currencyBalance  = player:getCharVar(v.var)

                if currenctQuantity > 0 then
                    trade:confirmItem(currencyTraded, currenctQuantity)
                    player:setCharVar(v.var, currencyBalance + currenctQuantity)
                    player:printToPlayer(string.format('Your new balance of %s is %i.', v.name, currencyBalance + currenctQuantity), xi.msg.channel.SYSTEM_3)
                    completeTrade = true
                end
            end

            if completeTrade then
                player:confirmTrade()
            end
        end,

        onTrigger = function(player, npc)
            local storedBronzepiece = player:getCharVar('[NEO]STORED_1452')
            local storedSilverpiece = player:getCharVar('[NEO]STORED_1453')
            local storedWhiteshells = player:getCharVar('[NEO]STORED_1449')
            local storedJadeshells  = player:getCharVar('[NEO]STORED_1450')
            local storedBynebills   = player:getCharVar('[NEO]STORED_1455')
            local storedHundredByne = player:getCharVar('[NEO]STORED_1456')
            local storedThought     = player:getCharVar('[NEO]STORED_3493')
            local storedHope        = player:getCharVar('[NEO]STORED_3494')
            local storedTouch       = player:getCharVar('[NEO]STORED_3495')
            local storedJourney     = player:getCharVar('[NEO]STORED_3496')
            local storedStep        = player:getCharVar('[NEO]STORED_3497')
            local item              = 0

            -- Forward declarations (required)
            local menu  = {}
            local page1 = {}
            local page2 = {}
            local page3 = {}

            local delaySendMenu = function(playerArg)
                player:timer(100, function(playerArgMenu)
                    playerArgMenu:customMenu(menu)
                end)
            end

            menu =
            {
                title = "Choose a reward",
                options = {},
            }

            page1 =
            {
                {
                    string.format('O. bronzepiece (%i)', storedBronzepiece),
                    function(playerArg)
                        item = 1452
                        confirmTrade(player, item)
                    end,
                },
                {
                    string.format('M. silverpiece (%i)', storedSilverpiece),
                    function(playerArg)
                        item = 1453
                        confirmTrade(player, item)
                    end,
                },
                {
                    string.format('T. whiteshell (%i)', storedWhiteshells),
                    function(playerArg)
                        item = 1449
                        confirmTrade(player, item)
                    end,
                },
                {
                    string.format('L. jadeshell (%i)', storedJadeshells),
                    function(playerArg)
                        item = 1450
                        confirmTrade(player, item)
                    end,
                },
                {
                    string.format('Byne bills (%i)', storedBynebills),
                    function(playerArg)
                        item = 1455
                        confirmTrade(player, item)
                    end,
                },
                {
                    string.format('Hundred byne (%i)', storedHundredByne),
                    function(playerArg)
                        item = 1456
                        confirmTrade(player, item)
                    end,
                },
                {
                    "Next Page",
                    function(playerArg)
                        menu.options = page2
                        delaySendMenu(playerArg)
                    end,
                },
            }

            page2 =
            {
                {
                    string.format('Forgotten thought (%i)', storedThought),
                    function(playerArg)
                        item = 3493
                        confirmTrade(player, item)
                    end,
                },
                {
                    string.format('Forgotten hope (%i)', storedHope),
                    function(playerArg)
                        item = 3494
                        confirmTrade(player, item)
                    end,
                },
                {
                    string.format('Forgotten touch (%i)', storedTouch),
                    function(playerArg)
                        item = 3495
                        confirmTrade(player, item)
                    end,
                },
                {
                    string.format('Forgotten journey (%i)', storedJourney),
                    function(playerArg)
                        item = 3496
                        confirmTrade(player, item)
                    end,
                },
                {
                    string.format('Forgotten step (%i)', storedStep),
                    function(playerArg)
                        item = 3497
                        confirmTrade(player, item)
                    end,
                },
            }

            npc:facePlayer(player, true)
            menu.options = page1
            delaySendMenu(player)
        end,
    })
end)

return m
