-----------------------------------
-- NPC: Franz (Relic armor augmentation)
-----------------------------------
require('modules/module_utils')
local cq = require('modules/catseyexi/lua/additive_overrides/utils/custom_quest')
-----------------------------------
local m = Module:new('franz')

local ARCH_ORC_ESSENCE     =   1
local ARCH_QUADAV_ESSENCE  =   2
local ARCH_YAGUDO_ESSENCE  =   4
local ARCH_GOBLIN_ESSENCE  =   8

local ARCH_AHRIMAN_ESSENCE =  16
local ARCH_LORD_ESSENCE    =  32

local ARCH_MORBOL_ESSENCE  =  64
local ARCH_DRAGON_ESSENCE  = 128
local ARCH_GIGAS_ESSENCE   = 256
local ARCH_AVATAR_ESSENCE  = 512

local ARCH_CITIES          =   7

local FORGOTTEN_THOUGHT = 3493
local FORGOTTEN_HOPE    = 3494
local FORGOTTEN_TOUCH   = 3495
local FORGOTTEN_JOURNEY = 3496
local FORGOTTEN_STEP    = 3497
local FORGOTTEN_ANY     = 'ANY'

local rankTable =
{
    [0] = {  300,   6,   9 }, -- Rank 1 (RP, Currency, Forgottens)
    [1] = {  750,  13,  22 }, -- Rank 2
    [2] = { 1170,  23,  38 }, -- Rank 3
    [3] = { 1680,  33,  55 }, -- Rank 4
    [4] = { 2250,  45,  75 }, -- Rank 5
    [5] = { 2880,  63, 105 }, -- Rank 6
    [6] = { 3675,  85, 140 }, -- Rank 7
    [7] = { 4425, 122, 198 }, -- Rank 8
    [8] = { 5670, 160, 263 }, -- Rank 9
    [9] = { 7200, 200, 345 }, -- Rank 10 Total per any single piece: 30,000 RP, 750 currency, 1,250 forgottens.
}

local function completeTransaction(player, npc, item, forgottenId, tradeInfo)
    -- Open menu dialog
    local itemVar   = string.format('[NEO]RANK_%i', item)
    local itemRank  = player:getCharVar(itemVar)
    local rpBalance = player:getCharVar('[NEO]RP_BALANCE')
    local rpNeeded  = rankTable[itemRank][1]
    local currencyNeeded    = rankTable[tradeInfo.itemRank][2]
    local forgottenNeeded   = rankTable[tradeInfo.itemRank][3]
    local selectedCurrency  = player:getLocalVar('[NEO]SELECTED_CURRENCY')
    local selectedForgotten = player:getLocalVar('[NEO]SELECTED_FORGOTTEN')

    -- Augment Variables
    local aug0 = cexi.augments.dynamis_augments[item].augs[1][1]
    local aug1 = cexi.augments.dynamis_augments[item].augs[2][1]
    local aug2 = cexi.augments.dynamis_augments[item].augs[3][1]
    local pow0 = cexi.augments.dynamis_augments[item].augs[1][tradeInfo.itemRank + 2]
    local pow1 = cexi.augments.dynamis_augments[item].augs[2][tradeInfo.itemRank + 2]
    local pow2 = cexi.augments.dynamis_augments[item].augs[3][tradeInfo.itemRank + 2]

    -- Set augment ID's to 0 if we are not increasing it's power at this rank
    if pow0 == nil then
        aug0 = 0
    end

    if pow1 == nil then
        aug1 = 0
    end

    if pow2 == nil then
        aug2 = 0
    end

    local finalMenu =
    {
        title = 'Confirm transaction',

        options =
        {
            {
                'No, I change my mind.',
                function(player)
                    npc:facePlayer(player, true)
                    player:printToPlayer(string.format('Franz : Returning your %s, unchanged.', tradeInfo.itemName), xi.msg.channel.NS_SAY)
                end,
            },
            {
                'Confirm.',
                function(player)
                    -- Level up item.
                    player:setCharVar(itemVar, itemRank + 1)

                    -- Substract currencies.
                    player:setCharVar('[NEO]RP_BALANCE', rpBalance - rpNeeded)
                    player:setCharVar('[NEO]STORED_' .. selectedCurrency, player:getCharVar('[NEO]STORED_' .. selectedCurrency) - currencyNeeded)
                    player:setCharVar('[NEO]STORED_' .. selectedForgotten, player:getCharVar('[NEO]STORED_' .. selectedForgotten) - forgottenNeeded)

                    npc:facePlayer(player, true)

                    player:printToPlayer(string.format('Franz : You\'ve spent %i rank points, %i relic currency and %i forgotten items to upgrade your %s.', rpNeeded, currencyNeeded, forgottenNeeded, tradeInfo.itemName), xi.msg.channel.NS_SAY)
                    player:tradeComplete()

                    -- DEBUG
                    -- print(string.format('Item: %i Rank: %i aug0: %i pow0: %i aug1: %i pow1: %i aug2: %i pow2: %i', item, itemRank, aug0, pow0, aug1, pow1, aug2, pow2))
                    player:addItem(item, 1, aug0, pow0, aug1, pow1, aug2, pow2)
                    player:messageSpecial(zones[player:getZoneID()].text.ITEM_OBTAINED, item)
                end,
            },
        },
    }

    player:timer(150, function(playerArg)
        playerArg:customMenu(finalMenu)
    end)
end

local function selectForgotten(player, npc, item, currencyId, tradeInfo)
    local hasMinimumCurrency = false
    local forgottenNeeded    = rankTable[tradeInfo.itemRank][3]
    local forgottenItems     =
    {
        ['frgtn. thought'] = { itemId = 3493 },
        ['frgtn. hope']    = { itemId = 3494 },
        ['frgtn. touch']   = { itemId = 3495 },
        ['frgtn. journey'] = { itemId = 3496 },
        ['frgtn. step']    = { itemId = 3497 },
    }

    local options = {}

    for forgottenName, forgottenId in pairs(forgottenItems) do
        if player:getCharVar('[NEO]STORED_' .. forgottenId.itemId) >= forgottenNeeded then
            hasMinimumCurrency = true
            table.insert(options, {
                string.format('%d: %s', player:getCharVar('[NEO]STORED_' .. forgottenId.itemId), forgottenName),
                function()
                    player:setLocalVar('[NEO]SELECTED_FORGOTTEN', forgottenId.itemId)
                    print('Player has selected forgotten item: ' .. forgottenId.itemId)
                    completeTransaction(player, npc, item, forgottenId.itemId, tradeInfo)
                end,
            })
        end
    end

    if hasMinimumCurrency == false then
        player:printToPlayer('Franz : You have insufficient currency stored to complete the transaction', xi.msg.channel.NS_SAY)
        return
    end

    player:timer(150, function(playerArg)
        playerArg:customMenu({
            title   = 'Select forgotten items to consume:',
            options = options,
        })
    end)
end

local function selectCurrency(player, npc, item, tradeInfo)
    local hasMinimumCurrency = false
    local currencyNeeded     = rankTable[tradeInfo.itemRank][2]
    local relicCurrency      =
    {
        ['ordelle bronzepieces'] = { itemId = 1452 },
        ['one byne bills']       = { itemId = 1455 },
        ['tukuku whiteshells']   = { itemId = 1449 },
    }

    local options = {}

    for currencyName, currencyId in pairs(relicCurrency) do
        if player:getCharVar('[NEO]STORED_' .. currencyId.itemId) >= currencyNeeded then
            hasMinimumCurrency = true
            table.insert(options, {
                string.format('(%d) %s', player:getCharVar('[NEO]STORED_' .. currencyId.itemId), currencyName),
                function()
                    player:setLocalVar('[NEO]SELECTED_CURRENCY', currencyId.itemId)
                    print('Player has selected currency .' .. currencyId.itemId)
                    selectForgotten(player, npc, item, currencyId, tradeInfo)
                end,
            })
        end
    end

    if hasMinimumCurrency == false then
        player:printToPlayer('Franz : You have insufficient currency stored to complete the transaction', xi.msg.channel.NS_SAY)
        return
    end

    player:timer(150, function(playerArg)
        playerArg:customMenu({
            title   = 'Select relic currency to consume:',
            options = options,
        })
    end)
end

local function applyRankPoints(player, npc, item)
    -- Get item rank.
    local itemVar   = string.format('[NEO]RANK_%i', item)
    local itemRank  = player:getCharVar(itemVar)
    local tradeInfo =
    {
        itemName         = cexi.augments.dynamis_augments[item].name,
        itemVar          = itemVar,
        itemRank         = itemRank,
    }

    -- Item rank point info
    local rpBalance = player:getCharVar('[NEO]RP_BALANCE')
    local rpNeeded  = rankTable[itemRank][1]

    if rpBalance < rpNeeded then
        player:printToPlayer('Franz : You lack the required amount of Rank Points to begin the augmentation process.', xi.msg.channel.NS_SAY)
        return
    end

    -- Item currency info
    local currencyBalance = player:getCharVar('[NEO]CURRENCY_BALANCE')

    -- Open menu dialog
    local menu =
    {
        title = string.format('R%i: %s (RP: %i Cur: %i)', tradeInfo.itemRank, tradeInfo.itemName, rpBalance, currencyBalance),

        options =
        {
            {
                'Apply Rank Points.',
                function(player)
                    selectCurrency(player, npc, item, tradeInfo)
                end,
            },
            {
                'No, I change my mind.',
                function(player)
                    npc:facePlayer(player, true)
                    player:printToPlayer(string.format('Franz : Returning your %s, unchanged.', tradeInfo.itemName), xi.msg.channel.NS_SAY)
                end,
            },
        },
    }

    player:timer(150, function(playerArg)
        playerArg:customMenu(menu)
    end)
end

local function readItem(player, npc, item)
    -- Process begins.
    local itemName = cexi.augments.dynamis_augments[item].name
    player:printToPlayer(string.format('Now analyzing your %s ...', itemName), xi.msg.channel.SYSTEM_3)

    local progVar = player:getCharVar('[NEO]PROGRESS')

    if bit.band(progVar, cexi.augments.dynamis_augments[item].reqs) == 0 then
        player:printToPlayer('Franz : You lack the required essences to begin this augmentation process.', xi.msg.channel.NS_SAY)
        return
    end

    -- Get item rank.
    local itemVar  = string.format('[NEO]RANK_%i', item)
    local itemRank = player:getCharVar(itemVar)

    if itemRank >= 10 then
         player:printToPlayer(string.format('Franz : This %s is already rank 10 and cannot receive any additional upgrades.', itemName), xi.msg.channel.NS_SAY)
         return
    end

    local tradeInfo =
    {
        itemName         = cexi.augments.dynamis_augments[item].name,
        itemVar          = itemVar,
        itemRank         = itemRank,
        rpBalance        = rpBalance,
        rpNeeded         = rpNeeded,
        currencyBalance  = currencyBalance,
        currencyNeeded   = currencyNeeded,
    }

    applyRankPoints(player, npc, item)
end

local function onTrade(player, npc, trade)
    -- If traded item matches our table, send player the augment menu
    for k, v in pairs(cexi.augments.dynamis_augments) do
        if npcUtil.tradeHasExactly(trade, k) then
            -- Initialize these vars for every interaction.
            player:setLocalVar('[NEO]SELECTED_CURRENCY',  0)
            player:setLocalVar('[NEO]SELECTED_FORGOTTEN', 0)
            readItem(player, npc, k)
            break
        end
    end
end

local function onTrigger(player, npc)
    local name            = player:getName()
    local rpBalance       = player:getCharVar('[NEO]RP_BALANCE')
    local currencyBalance = player:getCharVar('[NEO]CURRENCY_BALANCE')

    npc:facePlayer(player, true)

    if rpBalance == 0 then
        player:printToPlayer(string.format('Franz : Greetings %s! My name is Franz and I\'ve got an exquisite deal for you, but first you must acquire some rank points.', name), xi.msg.channel.NS_SAY)
    else
        player:printToPlayer(string.format('Franz : Greetings %s! You have %i rank points available to spend. I\'ll reforge your items with the currency Freya is holding.', name, rpBalance), xi.msg.channel.NS_SAY)
    end
end

cexi.util.liveReload(m, {
    ['Tavnazian_Safehold'] =
    {
        {
            objtype   = xi.objType.NPC,
            name      = 'Franz',
            look = cexi.util.look({
                race = xi.race.HUME_M,
                face = cexi.face.B3,
                head = 111,
                body = 302,
                hand = 120,
                legs = 208,
                feet = 208,
                main = 424,
            }),
            x        = -5.410,
            y        = -24.980,
            z        = 51.757,
            rotation = 255,
            onTrigger = onTrigger,
            onTrade   = onTrade,
        },
    },
})

return m
