-----------------------------------
-- CatsEyeXI Dynamis 2.0
-- Dynamis 2.0 MobSkills
-----------------------------------
require("modules/module_utils")
require("scripts/globals/mobskills")
require("scripts/globals/utils")
-----------------------------------
local m = Module:new("neo_dyna_skills")

-- Shuffle function for the effects table
local function shuffleTable(t)
    for i = #t, 2, -1 do
        local j = math.random(i)
        t[i], t[j] = t[j], t[i]
    end
end

local skills =
{
    ["attractant"] =
    {
        onMobSkillCheck = function(target, mob, skill)
            if mob:isInDynamis() and mob:isMobType(xi.mobType.NOTORIOUS) then
                return 0
            end

            return 1
        end,

        onMobWeaponSkill = function(target, mob, skill)
            local typeEffect = xi.effect.CHARM_I
            local power = 0
            local duration = math.random(20, 30)

            if not target:isPC() then
                skill:setMsg(xi.msg.basic.SKILL_MISS)
                return typeEffect
            end

            local msg = xi.mobskills.mobStatusEffectMove(mob, target, typeEffect, power, 3, duration)
            if msg == xi.msg.basic.SKILL_ENFEEB_IS then
                mob:charm(target)
            end

            skill:setMsg(msg)

            return typeEffect
        end,
    },

    ["the_wrath_of_gudha"] = function(target, mob, skill)
        local typeEffect = xi.effect.WEIGHT

        local numhits = 1
        local accmod = 2
        local dmgmod = 1.5
        local info = xi.mobskills.mobPhysicalMove(mob, target, skill, numhits, accmod, dmgmod, 0, 1, 2, 3)
        local dmg = xi.mobskills.mobFinalAdjustments(info.dmg, mob, skill, target, xi.attackType.PHYSICAL, xi.damageType.NONE, info.hitslanded)

            xi.mobskills.mobStatusEffectMove(mob, target, typeEffect, 40, 0, 10)

        target:takeDamage(dmg, mob, xi.attackType.PHYSICAL, xi.damageType.NONE)
        return dmg
    end,

    ["seismostomp"] = function(target, mob, skill)
        if
            mob:getPool() == 2284 or    -- Arch_GuDha_Effigy
            mob:getPool() == 6087 or    -- Arch_Overlord_Tombstone
            mob:getPool() == 6092 or    -- Arch_Tzee_Xicu_Idol
            mob:getPool() == 4844       -- Arch_Goblin_Golem
        then
            local numhits = 1
            local accmod  = 1
            local dmgmod  = 2.1

            if mob:isMobType(xi.mobType.NOTORIOUS) then
                dmgmod = dmgmod + math.random()
            end

            local info           = xi.mobskills.mobPhysicalMove(mob, target, skill, numhits, accmod, dmgmod, xi.mobskills.physicalTpBonus.DMG_VARIES)
            local shadowsRemoved = math.random(1, 2)
            local dmg            = xi.mobskills.mobFinalAdjustments(info.dmg, mob, skill, target, xi.attackType.PHYSICAL, xi.damageType.BLUNT, shadowsRemoved)
            local typeEffect     = xi.effect.STUN

            xi.mobskills.mobPhysicalStatusEffectMove(mob, target, skill, typeEffect, 1, 0, 4)
            target:takeDamage(dmg, mob, xi.attackType.PHYSICAL, xi.damageType.BLUNT)

            return dmg
        else    -- all other statues
            local numhits = 1
            local accmod  = 1
            local dmgmod  = 1.5

            if mob:isMobType(xi.mobType.NOTORIOUS) then
                dmgmod = dmgmod + math.random()
            end

            local info           = xi.mobskills.mobPhysicalMove(mob, target, skill, numhits, accmod, dmgmod, xi.mobskills.physicalTpBonus.DMG_VARIES)
            local shadowsRemoved = math.random(1, 2)
            local dmg            = xi.mobskills.mobFinalAdjustments(info.dmg, mob, skill, target, xi.attackType.PHYSICAL, xi.damageType.BLUNT, shadowsRemoved)
            local typeEffect     = xi.effect.STUN

            xi.mobskills.mobPhysicalStatusEffectMove(mob, target, skill, typeEffect, 1, 0, 4)
            target:takeDamage(dmg, mob, xi.attackType.PHYSICAL, xi.damageType.BLUNT)

            return dmg
        end
    end,

    ["miasmic_breath"] = function(target, mob, skill)
        local power    = math.random(225, 325)
        local dotPower = math.random(15, 60)
        local duration = math.random(15, 45)
        xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.POISON, dotPower, 0, duration)

        local dmgmod = xi.mobskills.mobBreathMove(mob, target, skill, 0.15, 3, xi.element.WATER, power)
        local dmg = xi.mobskills.mobFinalAdjustments(dmgmod, mob, skill, target, xi.attackType.BREATH, xi.damageType.WATER, xi.mobskills.shadowBehavior.IGNORE_SHADOWS)
        target:takeDamage(dmg, mob, xi.attackType.BREATH, xi.damageType.WATER)

        return dmg
    end,

    ["fragrant_breath"] =
    {
        onMobSkillCheck = function(target, mob, skill)
            if mob:isInDynamis() and mob:isMobType(xi.mobType.NOTORIOUS) then
                return 0
            end

            return 1
        end,

        onMobWeaponSkill = function(target, mob, skill)
            local typeEffect = xi.effect.CHARM_I
            local power = 0
            local duration = math.random(20, 30)

            if not target:isPC() then
                skill:setMsg(xi.msg.basic.SKILL_MISS)
                return typeEffect
            end

            local msg = xi.mobskills.mobStatusEffectMove(mob, target, typeEffect, power, 3, duration)
            if msg == xi.msg.basic.SKILL_ENFEEB_IS then
                mob:charm(target)
            end

            skill:setMsg(msg)

            return typeEffect
        end,
    },


    ["putrid_breath"] = function(target, mob, skill)
        local power = math.random(225, 325)

        local dmgmod = xi.mobskills.mobBreathMove(mob, target, skill, 0.25, 2.5, xi.element.WATER, power)
        local dmg    = xi.mobskills.mobFinalAdjustments(dmgmod, mob, skill, target, xi.attackType.BREATH, xi.damageType.WATER, xi.mobskills.shadowBehavior.WIPE_SHADOWS)

        target:takeDamage(dmg, mob, xi.attackType.BREATH, xi.damageType.WATER)

        return dmg
    end,

    ["marrow_drain"] =
    {
        onMobSkillCheck = function(target, mob, skill)
            if mob:isMobType(xi.mobType.NOTORIOUS) then
                return 0
            elseif mob:getPool() == 3791 or mob:getPool() == 5118 then  -- Stringes and Lost_Stringes
                return 1
            else
                return 1
            end
        end,

        onMobWeaponSkill = function(target, mob, skill)
            if mob:getPool() == 3791 or mob:getPool() == 5118 then  -- Stringes and Lost_Stringes
                local power = math.random(225, 325)
                local dmg = xi.mobskills.mobFinalAdjustments(power, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.DARK, xi.mobskills.shadowBehavior.IGNORE_SHADOWS)

                skill:setMsg(xi.mobskills.mobPhysicalDrainMove(mob, target, skill, xi.mobskills.drainType.HP, dmg))

                return dmg
            else
                local dmgmod = 1
                local info = xi.mobskills.mobMagicalMove(mob, target, skill, mob:getWeaponDmg() * 2.3, xi.element.DARK, dmgmod, xi.mobskills.magicalTpBonus.MAB_BONUS, 1)
                local dmg = xi.mobskills.mobFinalAdjustments(info, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.DARK, xi.mobskills.shadowBehavior.IGNORE_SHADOWS)

                skill:setMsg(xi.mobskills.mobPhysicalDrainMove(mob, target, skill, xi.mobskills.drainType.MP, dmg))

                return dmg
            end
        end,
    },

    ["lodesong"] = function(target, mob, skill)
        local typeEffect = xi.effect.WEIGHT
        local duration = math.random(20, 40)

        skill:setMsg(xi.mobskills.mobStatusEffectMove(mob, target, typeEffect, 50, 0, duration))

        return typeEffect
    end,

    ["poison_breath"] = function(target, mob, skill)
        local typeEffect  = xi.effect.POISON
        local power       = math.ceil(mob:getMainLvl() / 5)
        local damageLimit = 200

        if mob:getName() == "Lost_Stihi" then
            power       = math.ceil(mob:getMainLvl() / 2)
            damageLimit = math.random(400, 700)
        end

        xi.mobskills.mobStatusEffectMove(mob, target, typeEffect, power, 3, 60)

        local dmgmod = xi.mobskills.mobBreathMove(mob, target, skill, 0.1, 1.25, xi.element.WATER, damageLimit)

        local dmg = xi.mobskills.mobFinalAdjustments(dmgmod, mob, skill, target, xi.attackType.BREATH, xi.damageType.WATER, xi.mobskills.shadowBehavior.IGNORE_SHADOWS)
        target:takeDamage(dmg, mob, xi.attackType.BREATH, xi.damageType.WATER)

        return dmg
    end,

    ["flame_breath"] = function(target, mob, skill)
        local damageLimit = 600
        local dmgmod = xi.mobskills.mobBreathMove(mob, target, skill, 0.2, 0.75, xi.element.FIRE, damageLimit)

        if mob:getName() == "Lost_Stihi" then
            damageLimit = math.random(750, 1000)
            dmgmod = xi.mobskills.mobBreathMove(mob, target, skill, 0.2, 0.75, xi.element.FIRE, damageLimit)
        end

        local dmg = xi.mobskills.mobFinalAdjustments(dmgmod, mob, skill, target, xi.attackType.BREATH, xi.damageType.FIRE, xi.mobskills.shadowBehavior.IGNORE_SHADOWS)
        target:takeDamage(dmg, mob, xi.attackType.BREATH, xi.damageType.FIRE)
        return dmg
    end,

    ["wind_breath"] = function(target, mob, skill)
        local damageLimit = 460
        local dmgmod = xi.mobskills.mobBreathMove(mob, target, skill, 0.3, 0.75, xi.element.WIND, damageLimit)

        if mob:getName() == "Lost_Stihi" then
            damageLimit = math.random(650, 850)
            dmgmod = xi.mobskills.mobBreathMove(mob, target, skill, 0.1, 0.75, xi.element.WIND, damageLimit)
        end

        local dmg = xi.mobskills.mobFinalAdjustments(dmgmod, mob, skill, target, xi.attackType.BREATH, xi.damageType.WIND, xi.mobskills.shadowBehavior.IGNORE_SHADOWS)
        target:takeDamage(dmg, mob, xi.attackType.BREATH, xi.damageType.WIND)
        return dmg
    end,

    ["foxfire"] = function(target, mob, skill)
        local numhits = 1
        local accmod = 1
        local dmgmod = 1.3
        local info = xi.mobskills.mobPhysicalMove(mob, target, skill, numhits, accmod, dmgmod, xi.mobskills.physicalTpBonus.DMG_VARIES, 1, 2, 3)
        local dmg = xi.mobskills.mobFinalAdjustments(info.dmg, mob, skill, target, xi.attackType.PHYSICAL, xi.damageType.BLUNT, info.hitslanded)

        local typeEffect = xi.effect.STUN

        xi.mobskills.mobPhysicalStatusEffectMove(mob, target, skill, typeEffect, 1, 0, 6)

        target:takeDamage(dmg, mob, xi.attackType.PHYSICAL, xi.damageType.BLUNT)
        return dmg
    end,

    ["shackled_fists"] = function(target, mob, skill)
        local numhits = 5
        local accmod = 1
        local dmgmod = .7
        local info = xi.mobskills.mobPhysicalMove(mob, target, skill, numhits, accmod, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT)
        local dmg = xi.mobskills.mobFinalAdjustments(info.dmg, mob, skill, target, xi.attackType.PHYSICAL, xi.damageType.H2H, info.hitslanded)

        target:takeDamage(dmg, mob, xi.attackType.PHYSICAL, xi.damageType.H2H)

        return dmg
    end,

    ["barbed_crescent"] = function(target, mob, skill)
        local numhits = 1
        local accmod = 1
        local dmgmod = 1
        local info = xi.mobskills.mobPhysicalMove(mob, target, skill, numhits, accmod, dmgmod, xi.mobskills.physicalTpBonus.DMG_VARIES, 1, 2, 3)
        local dmg = xi.mobskills.mobFinalAdjustments(info.dmg, mob, skill, target, xi.attackType.PHYSICAL, xi.damageType.SLASHING, info.hitslanded)
        local typeEffect = xi.effect.ACCURACY_DOWN

        xi.mobskills.mobPhysicalStatusEffectMove(mob, target, skill, typeEffect, 50, 0, 120)

        target:takeDamage(dmg, mob, xi.attackType.PHYSICAL, xi.damageType.SLASHING)
        return dmg
    end,

    ["aegis_schism"] = function(target, mob, skill)
        local numhits  = 1
        local accmod   = 1
        local dmgmod   = 1.5
        local info     = xi.mobskills.mobPhysicalMove(mob, target, skill, numhits, accmod, dmgmod, xi.mobskills.physicalTpBonus.DMG_VARIES, 1, 2, 3)
        local dmg      = xi.mobskills.mobFinalAdjustments(info.dmg, mob, skill, target, xi.attackType.PHYSICAL, xi.damageType.BLUNT, info.hitslanded)
        local power    = 75
        local duration = 120

        xi.mobskills.mobPhysicalStatusEffectMove(mob, target, skill, xi.effect.DEFENSE_DOWN, power, 0, duration)
        target:takeDamage(dmg, mob, xi.attackType.PHYSICAL, xi.damageType.BLUNT)

        return dmg
    end,

    ["lightning_roar"] = function(target, mob, skill)
        if mob:getPool() == 5117 then -- Arch_Antaeus
            local typeEffect = xi.effect.STUN
            local duration = math.random(3, 8)

            xi.mobskills.mobStatusEffectMove(mob, target, typeEffect, 1, 0, duration)

            local dmgmod = 1
            local info = xi.mobskills.mobMagicalMove(mob, target, skill, mob:getWeaponDmg() * math.random(4, 6), xi.element.THUNDER, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT)
            local dmg = xi.mobskills.mobFinalAdjustments(info, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.THUNDER, xi.mobskills.shadowBehavior.IGNORE_SHADOWS)
            target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.THUNDER)
            return dmg
        else
            local dmgmod = 1
            local info = xi.mobskills.mobMagicalMove(mob, target, skill, mob:getWeaponDmg() * math.random(4, 6), xi.element.THUNDER, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT)
            local dmg = xi.mobskills.mobFinalAdjustments(info, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.THUNDER, xi.mobskills.shadowBehavior.IGNORE_SHADOWS)
            target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.THUNDER)
            return dmg
        end
    end,

    ["dice_heal"] = function(target, mob, skill)
        if mob:getPool() == 4241 or  -- Quicktrix_Hexhands
            mob:getPool() == 4653 or -- Feralox_Honeylips
            mob:getPool() == 3843 or -- Wilywox_Tenderpalm
            mob:getPool() == 2846    -- Scourquix_Scaleskin
        then
            local heal = math.random(10000, 20000)

            skill:setMsg(xi.msg.basic.SELF_HEAL)

            target:addHP(heal)
            target:wakeUp()

            return heal
        else
            local heal = target:getMaxHP() - target:getHP()

            skill:setMsg(xi.msg.basic.SELF_HEAL)

            target:addHP(heal)
            target:wakeUp()

            return heal
        end
    end,

    ["cacodemonia"] = function(target, mob, skill)
        local typeEffect = xi.effect.CURSE_I
        local power = 40
        if mob:getZoneID() == xi.zone.DYNAMIS_TAVNAZIA then -- Diabolos Dynamis Tavnazia - 48%
            power = 48
        end

        skill:setMsg(xi.mobskills.mobStatusEffectMove(mob, target, typeEffect, power, 0, 360))

        return typeEffect
    end,

    ["camisado"] = function(target, mob, skill)
        local numhits = 1
        local accmod = 1
        local dmgmod = 1

        -- Diabolos Dynamis Tavnazia - covering skill IDs: single target 656 and AoE 1903
        if mob:getZoneID() == xi.zone.DYNAMIS_TAVNAZIA then
            accmod = 4
            dmgmod = 3
        end

        local info = xi.mobskills.mobPhysicalMove(mob, target, skill, numhits, accmod, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT)

        local shadows = info.hitslanded
        if
            mob:getZoneID() == xi.zone.DYNAMIS_TAVNAZIA and
            skill:getID() == 1903
        then
            shadows = xi.mobskills.shadowBehavior.WIPE_SHADOWS
        end

        local dmg = xi.mobskills.mobFinalAdjustments(info.dmg, mob, skill, target, xi.attackType.PHYSICAL, xi.damageType.BLUNT, shadows)

        if not skill:hasMissMsg() then
            target:takeDamage(dmg, mob, xi.attackType.PHYSICAL, xi.damageType.BLUNT)
        end

        return dmg
    end,

    ["dream_shroud"] = function(target, mob, skill)
        local duration = 180
        local hour = VanadielHour()
        local buffvalue = 0
        local multiplier = 1

        -- Diabolos Dynamis Tavnazia
        if mob:getZoneID() == xi.zone.DYNAMIS_TAVNAZIA then
            multiplier = 2
        end

        buffvalue = math.abs(12 - hour) + 1
        target:delStatusEffect(xi.effect.MAGIC_ATK_BOOST)
        target:delStatusEffect(xi.effect.MAGIC_DEF_BOOST)
        target:addStatusEffect(xi.effect.MAGIC_ATK_BOOST, buffvalue * multiplier, 0, duration)
        target:addStatusEffect(xi.effect.MAGIC_DEF_BOOST, (14 - buffvalue) * multiplier, 0, duration)
        skill:setMsg(xi.msg.basic.NONE)
        return 0
    end,

    ["nether_blast"] = function(target, mob, skill)
        local multiplier = 5
        -- Diabolos Dynamis Tavnazia tosses nether blast for ~1k
        if mob:getZoneID() == xi.zone.DYNAMIS_TAVNAZIA then
            if mob:getHPP() <= 30 then
                multiplier = 8
            end
            multiplier = 6
        end

        local dmg = mob:getMainLvl() * multiplier + 10 -- http://wiki.ffo.jp/html/4045.html
        local dmgmod = 1
        local ignoreres = true

        local info = xi.mobskills.mobMagicalMove(mob, target, skill, dmg, xi.element.DARK, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT, ignoreres)

        dmg = xi.mobskills.mobFinalAdjustments(info, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.DARK, xi.mobskills.shadowBehavior.IGNORE_SHADOWS)

        target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.DARK)
        return dmg
    end,

    ["nether_tempest"] = function(target, mob, skill)
        -- Diabolos Dynamis Tavnazia tosses nether tempest for a reported 661 dmg
        -- Diabolos are lvl 85.   A multiplier of 7.77 hits 661
        local multiplier = 3
        local dmg = mob:getMainLvl() * multiplier -- http://wiki.ffo.jp/html/4045.html
        local dmgmod = 1
        local ignoreres = true

        local info = xi.mobskills.mobMagicalMove(mob, target, skill, dmg, xi.element.DARK, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT, ignoreres)

        dmg = xi.mobskills.mobFinalAdjustments(info, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.DARK, xi.mobskills.shadowBehavior.IGNORE_SHADOWS)

        target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.DARK)
        return dmg
    end,

    ["noctoshield"] = function(target, mob, skill)
        local power = 13
        -- Diabolos Dynamis Tavnazia
        if mob:getZoneID() == xi.zone.DYNAMIS_TAVNAZIA then
            power = 35
        end

        skill:setMsg(xi.mobskills.mobBuffMove(mob, xi.effect.PHALANX, power, 0, 120))
        return xi.effect.PHALANX
    end,

    ["ruinous_omen"] = function(target, mob, skill)
        local dINT = math.floor(mob:getStat(xi.mod.INT) - target:getStat(xi.mod.INT))
        -- Target HPP decrease seems to be about 66% unresisted.
        -- Maximum observed 72% (weakness to darkness?)
        -- Minimum observed 44% (high resist)
        local hppTarget = 66
        local hppMin    = 44
        local hppMax    = 75
        local dmgmod    = 0.7   -- Estimated from keeping with a max of ~72% reduction
        local ratio     = 4

        -- Diabolos Dynamis Tavnazia - Observed 60%-95%, with most being above 80%
        if mob:getZoneID() == xi.zone.DYNAMIS_TAVNAZIA then
            hppTarget = 80
            hppMax = 95
            hppMin = 60
        end

        if dINT >= 0 then
            ratio = 6
        end  -- Tilt the curve so that a small dINT doesn't tip too far in Diabolos' favour.

        hppTarget = hppTarget + (dINT / ratio)    -- A wild estimate.  Diabolos INT is 131 in Waking Dreams.

        -- hpp and damage do not correlate, but we can use the system to scale damage numbers
        hppTarget = xi.mobskills.mobMagicalMove(mob, target, skill, hppTarget, xi.element.DARK, dmgmod, xi.mobskills.magicalTpBonus, 0)
        hppTarget = xi.mobskills.mobAddBonuses(mob, target, hppTarget.dmg, xi.element.DARK)
        hppTarget = xi.mobskills.mobFinalAdjustments(hppTarget, mob, skill, target, xi.attackType.SPECIAL, xi.damageType.DARK, xi.mobskills.shadowBehavior.IGNORE_SHADOWS)

        -- Clamp the HPP reduction to a 75% total cap and a 40% total Minimum
        hppTarget = utils.clamp(hppTarget, hppMin, hppMax)

        -- Convert the reduction into a player-specific amount based on their current HP
        local damage = target:getHP() * hppTarget / 100

        target:takeDamage(damage, mob, xi.attackType.MAGICAL, xi.damageType.DARK)
        return damage
    end,

    ["ultimate_terror"] = function(target, mob, skill)
        -- Diabolos Dynamis Tavnazia -- adds TERROR
        if mob:getZoneID() == xi.zone.DYNAMIS_TAVNAZIA then
            xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.TERROR, 1, 0, 30)
        end

        -- Determine the number of debuffs to apply: 2-4
        local numDebuffs = math.random(2, 4)
        local drained = 0

        local effects = {
            xi.effect.STR_DOWN,
            xi.effect.DEX_DOWN,
            xi.effect.VIT_DOWN,
            xi.effect.AGI_DOWN,
            xi.effect.INT_DOWN,
            xi.effect.MND_DOWN,
            xi.effect.CHR_DOWN
        }

        -- Dain 2-4 random stats
        shuffleTable(effects) -- Shuffle the table so we get random stats
        for i = 1, numDebuffs do
            local effect = effects[i]
            if effect then -- Ensuring effect is valid before attempting to apply
                skill:setMsg(xi.mobskills.mobDrainAttribute(mob, target, effect, 10, 10, 180))
                drained = drained + 1
            end
        end

        return drained
    end,

    ["daydream"] = function(target, mob, skill)
        -- Diabolos Dynamis Tavnazia charm
        local typeEffect  = xi.effect.CHARM_I
        local power       = 0
        local charmChance = math.random(1, 100)
        local charmResist = target:getMod(xi.mod.CHARMRES) + charmChance

        if not target:isPC() then
            skill:setMsg(xi.msg.basic.SKILL_MISS)
            return typeEffect
        end

        if charmResist >= 90 then -- 10% chance to resist + charmres modifier
            skill:setMsg(xi.msg.basic.SKILL_MISS)
            return typeEffect
        else
            local msg = xi.mobskills.mobStatusEffectMove(mob, target, typeEffect, power, 3, 60)
            if msg == xi.msg.basic.SKILL_ENFEEB_IS then
                mob:charm(target)
                target:delStatusEffect(xi.effect.STUN) -- this is really sleep, but we're using stun to keep them asleep
            end

            skill:setMsg(msg)

            return typeEffect
        end
    end,

    ["sweeping_somnolence"] = function(target, mob, skill)
        local numhits = 1
        local accmod = 1
        local dmgmod = 1
        local power = math.random(15, 35)
        local duration = math.random(15, 60)

        if mob:getZoneID() == xi.zone.DYNAMIS_TAVNAZIA then
            accmod = 2
            dmgmod = 1.5
        end

        local info = xi.mobskills.mobPhysicalMove(mob, target, skill, numhits, accmod, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT)
        local dmg = xi.mobskills.mobFinalAdjustments(info.dmg, mob, skill, target, xi.attackType.PHYSICAL, xi.damageType.BLUNT, xi.mobskills.shadowBehavior.IGNORE_SHADOWS, info.hitslanded)

        xi.mobskills.mobPhysicalStatusEffectMove(mob, target, skill, xi.effect.WEIGHT, power, 0, duration)

        target:takeDamage(dmg, mob, xi.attackType.PHYSICAL, xi.damageType.BLUNT)

        return dmg
    end,

    ["hypnogenesis"] = function(target, mob, skill)
        local numhits = 1
        local accmod = 1
        local dmgmod = 1

        if mob:getZoneID() == xi.zone.DYNAMIS_TAVNAZIA then
            accmod = 4
            dmgmod = 3
        end

        if
            target:isFacing(mob) and
            mob:isInfront(target)
        then
            local info = xi.mobskills.mobPhysicalMove(mob, target, skill, numhits, accmod, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT)

            local shadows = info.hitslanded
            if mob:getZoneID() == xi.zone.DYNAMIS_TAVNAZIA then
                shadows = xi.mobskills.shadowBehavior.WIPE_SHADOWS
            end

            local dmg = xi.mobskills.mobFinalAdjustments(info.dmg, mob, skill, target, xi.attackType.PHYSICAL, xi.damageType.BLUNT, shadows)

            if not skill:hasMissMsg() then
                target:takeDamage(dmg, mob, xi.attackType.PHYSICAL, xi.damageType.BLUNT)
                return dmg
            end
        else
            skill:setMsg(xi.msg.basic.SKILL_MISS)
        end
        return 0
    end,
}

for skillName, skillFunc in pairs(skills) do
    local skillPath = string.format("xi.actions.mobskills.%s", skillName)
    xi.module.ensureTable(skillPath)

    if type(skillFunc) == "table" then
        m:addOverride(skillPath .. ".onMobWeaponSkill", skillFunc.onMobWeaponSkill)
        m:addOverride(skillPath .. ".onMobSkillCheck",  skillFunc.onMobSkillCheck)

    else
        m:addOverride(skillPath .. ".onMobWeaponSkill", skillFunc)
        m:addOverride(skillPath .. ".onMobSkillCheck", function(target, mob, skill)
            return 0
        end)
    end
end

return m
