-----------------------------------
-- Neo-Dynamis (Custom Module)
-- Coded with love by Carver
-- 2023, CatsEyeXI (http://catseyexi.com) / --server server.catseyexi.com
-----------------------------------
require("modules/module_utils")
require("scripts/globals/dynamis")
require("scripts/globals/utils")
local req = require("modules/catseyexi/lua/additive_overrides/systems/dynamis_2_0/neo_dyna_requirements")
-----------------------------------
local m = Module:new("neo_dyna_mobs")

local RP_EVENT  = 1.15
local bossTable =
{
--    Zone                  Mob Name                  RP Value
    { "Dynamis-Bastok",     "GuDha_Effigy",              50 },
    { "Dynamis-Bastok",     "ZoPha_Forgesoul",           75 },
    { "Dynamis-Bastok",     "RaGho_Darkfount",           75 },
    { "Dynamis-Bastok",     "VaZhe_Pummelsong",          75 },
    { "Dynamis-Bastok",     "BuBho_Truesteel",           75 },
    { "Dynamis-Bastok",     "Arch_GuDha_Effigy",       1500 },
    { "Dynamis-San_dOria",  "Overlords_Tombstone",       50 },
    { "Dynamis-San_dOria",  "Bladeburner_Rokgevok",      75 },
    { "Dynamis-San_dOria",  "Steelshank_Kratzvatz",      75 },
    { "Dynamis-San_dOria",  "Bloodfist_Voshgrosh",       75 },
    { "Dynamis-San_dOria",  "Spellspear_Djokvukk",       75 },
    { "Dynamis-San_dOria",  "Arch_Overlord_Tombstone", 1500 },
    { "Dynamis-Windurst",   "Tzee_Xicu_Idol",            50 },
    { "Dynamis-Windurst",   "Xuu_Bhoqa_the_Enigma",      75 },
    { "Dynamis-Windurst",   "Fuu_Tzapo_the_Blessed",     75 },
    { "Dynamis-Windurst",   "Naa_Yixo_the_Stillrage",    75 },
    { "Dynamis-Windurst",   "Tee_Zaksa_the_Ceaseless",   75 },
    { "Dynamis-Windurst",   "Arch_Tzee_Xicu_Idol",     1500 },
    { "Dynamis-Jeuno",      "Goblin_Golem",              50 },
    { "Dynamis-Jeuno",      "Quicktrix_Hexhands",        75 },
    { "Dynamis-Jeuno",      "Feralox_Honeylips",         75 },
    { "Dynamis-Jeuno",      "Scourquix_Scaleskin",       75 },
    { "Dynamis-Jeuno",      "Wilywox_Tenderpalm",        75 },
    { "Dynamis-Jeuno",      "Arch_Goblin_Golem",       1500 },
    { "Dynamis-Beaucedine", "Angra_Mainyu",             100 },
    { "Dynamis-Beaucedine", "Taquede",                  125 },
    { "Dynamis-Beaucedine", "Pignonpausard",            125 },
    { "Dynamis-Beaucedine", "Hitaume",                  125 },
    { "Dynamis-Beaucedine", "Cavanneche",               125 },
    { "Dynamis-Beaucedine", "Arch_Angra_Mainyu",       2750 },
    { "Dynamis-Xarcabard",  "Dynamis_Lord",             200 },
    { "Dynamis-Xarcabard",  "Duke_Haures",              175 },
    { "Dynamis-Xarcabard",  "Marquis_Caim",             175 },
    { "Dynamis-Xarcabard",  "Baron_Avnas",              175 },
    { "Dynamis-Xarcabard",  "Count_Haagenti",           175 },
    { "Dynamis-Xarcabard",  "Arch_Dynamis_Lord",       5250 },
    { "Dynamis-Valkurm",    "Cirrate_Christelle",        75 },
    { "Dynamis-Valkurm",    "Lost_Fairy_Ring",          125 },
    { "Dynamis-Valkurm",    "Lost_Nantina",             125 },
    { "Dynamis-Valkurm",    "Lost_Stcemqestcint",       125 },
    { "Dynamis-Valkurm",    "Arch_Christelle",         2500 },
    { "Dynamis-Buburimu",   "Apocalyptic_Beast",         75 },
    { "Dynamis-Buburimu",   "Lost_Barong",              125 },
    { "Dynamis-Buburimu",   "Lost_Alklha",              125 },
    { "Dynamis-Buburimu",   "Lost_Aitvaras",            125 },
    { "Dynamis-Buburimu",   "Lost_Stihi",               125 },
    { "Dynamis-Buburimu",   "Arch_Apocalyptic_Beast",  2500 },
    { "Dynamis-Qufim",      "Antaeus",                   75 },
    { "Dynamis-Qufim",      "Lost_Stringes",            125 },
    { "Dynamis-Qufim",      "Lost_Scolopendra",         125 },
    { "Dynamis-Qufim",      "Lost_Suttung",             125 },
    { "Dynamis-Qufim",      "Arch_Antaeus",            2500 },
    { "Dynamis-Tavnazia",   "Diabolos_Heart",           100 },
    { "Dynamis-Tavnazia",   "Diabolos_Diamond",         100 },
    { "Dynamis-Tavnazia",   "Diabolos_Club",            100 },
    { "Dynamis-Tavnazia",   "Diabolos_Spade",           100 },
    { "Dynamis-Tavnazia",   "Diabolos_Nox",            3250 },
    { "Dynamis-Tavnazia",   "Diabolos_Umbra",          3250 },
    { "Dynamis-Tavnazia",   "Diabolos_Somnus",         3250 },
    { "Dynamis-Tavnazia",   "Diabolos_Letum",          3250 },
}

local pathWithFilename = io.popen("cd"):read'*all'

-- Checks to validate that the file exists before trying to override it
for _, entry in pairs(bossTable) do
    local zoneName    = entry[1]
    local mobName     = entry[2]

    local filename = pathWithFilename:sub(1, -2) .. string.format("\\scripts\\zones\\%s\\mobs\\%s", zoneName, mobName) .. ".lua"
    local exists = io.open(filename,"r")
    if exists ~= nil then
        io.close(exists)
    else
        xi.module.ensureTable(string.format("xi.zones.%s.mobs.%s", zoneName, mobName))
    end
end

local function updatePlayer(mobName, player)
    local progVar = player:getCharVar("[NEO]PROGRESS")

    if not utils.mask.getBit(progVar, req.requirements[mobName].id) then
        player:printToPlayer(string.format("%s absorbs an %s.", player:getName(), req.requirements[mobName].item), xi.msg.channel.SYSTEM_3)
        player:setCharVar("[NEO]PROGRESS", utils.mask.setBit(progVar, req.requirements[mobName].id, true))
    end
end

local function updateProgress(mobName, player)
    if req.requirements[mobName] == nil then
        return
    end

    local alliance = player:getAlliance()
    local zoneID   = player:getZoneID()

    for _, member in pairs(alliance) do
        if
            member ~= nil and
            member:isPC() and
            member:getZoneID() == zoneID
        then
            updatePlayer(mobName, member)
        end
    end
end

-- Apply the override to each NM's onMobDeath logic
for _, entry in pairs(bossTable) do
    local zoneName = entry[1]
    local mobName  = entry[2]
    local rpValue  = entry[3]

    if xi.settings.main.DYNAMIS_CAMPAIGN then
        rpValue  = math.floor(rpValue * RP_EVENT)
    end

    local mobLuaFile  = string.format("xi.zones.%s.mobs.%s.onMobDeath", zoneName, mobName)

    -- Do the override thingy
    m:addOverride(mobLuaFile, function(mob, player, optParams)
        super(mob, player, optParams)

        -- NMs drop Timeless Sand during Campaign
        if xi.settings.main.DYNAMIS_CAMPAIGN then
            -- 100% chance for sand x1
            player:addTreasure(xi.item.TIMELESS_SAND, mob)

            local roll = math.random(0, 100)

            -- 40% chance for sand x2
            if roll > 60 then
                player:addTreasure(xi.item.TIMELESS_SAND, mob)
            end

            -- 10% chance for sand x3
            if roll > 90 then
                player:addTreasure(xi.item.TIMELESS_SAND, mob)
            end
        end

        local zoneID   = player:getZoneID()

        if player ~= nil and
           player:isPC() and
           player:getZoneID() == zoneID
        then
            local playerRP   = player:getCharVar("[NEO]RP_BALANCE")
            local playerName = player:getName()

            player:setCharVar("[NEO]RP_BALANCE", playerRP + rpValue)
            player:printToPlayer(string.format("%s gains %s rank points! (Total: %s)", playerName, rpValue, playerRP + rpValue), xi.msg.channel.SYSTEM_3)

            updateProgress(mobName, player)
        end
    end)
end

m.setWinMusic = function(player)
    local zoneID   = player:getZoneID()
    local alliance = player:getAlliance()

    for _, member in pairs(alliance) do
        if
            member:getZoneID() == zoneID and
            member:isPC() and
            member:getLocalVar("Starlight") ~= 1
        then
            member:setLocalVar("Starlight", 1)
            -- Loop through each music type and set to Starlight Celebration Music
            for i = 0, 3 do
                member:changeMusic(i, 239)
            end
        end
    end
end

return m
