-----------------------------------
-- Neo-Dynamis Lockout (Custom Module)
-- Coded with love by Carver
-- 2023, CatsEyeXI (http://catseyexi.com) / --server server.catseyexi.com
-----------------------------------
require("modules/module_utils")
require("scripts/globals/dynamis")

local m = Module:new("neo_dyna_lockout")

local LOCKOUT_TIMER = utils.minutes(60)

local dynaZones =
{
    [xi.zone.DYNAMIS_BASTOK]     = { "Dynamis-Bastok",     "Bastok_Mines",       "Trail_Markings" },
    [xi.zone.DYNAMIS_SAN_DORIA]  = { "Dynamis-San_dOria",  "Southern_San_dOria", "Trail_Markings" },
    [xi.zone.DYNAMIS_WINDURST]   = { "Dynamis-Windurst",   "Windurst_Walls",     "Trail_Markings" },
    [xi.zone.DYNAMIS_JEUNO]      = { "Dynamis-Jeuno",      "RuLude_Gardens",     "Trail_Markings" },
    [xi.zone.DYNAMIS_BEAUCEDINE] = { "Dynamis-Beaucedine", "Beaucedine_Glacier", "Trail_Markings" },
    [xi.zone.DYNAMIS_XARCABARD]  = { "Dynamis-Xarcabard",  "Xarcabard",          "Trail_Markings" },
    [xi.zone.DYNAMIS_VALKURM]    = { "Dynamis-Valkurm",    "Valkurm_Dunes",      "Hieroglyphics"  },
    [xi.zone.DYNAMIS_BUBURIMU]   = { "Dynamis-Buburimu",   "Buburimu_Peninsula", "Hieroglyphics"  },
    [xi.zone.DYNAMIS_QUFIM]      = { "Dynamis-Qufim",      "Qufim_Island",       "Hieroglyphics"  },
    [xi.zone.DYNAMIS_TAVNAZIA]   = { "Dynamis-Tavnazia",   "Tavnazian_Safehold", "Hieroglyphics"  },
}

-----------------------------------
-- Apply lockout
-----------------------------------
-- We use onGameIn rather than onZoneOut, so players can receive the message
m:addOverride("xi.player.onGameIn", function(player, firstLogin, zoning)
    super(player, firstLogin, zoning)

    if
        player and
        player:isPC() and
        zoning -- only take these actions if the player isn't freshly logging in
    then
        local prev = player:getPreviousZone()

        if
            dynaZones[prev] == nil or
            player:getCurrentRegion() == xi.region.DYNAMIS
        then
            return
        end

        local varName = fmt("[NEO]{}", dynaZones[prev][1])

        -- Set a var on players when they zone out of Dynamis to lock them out
        if os.time() < player:getCharVar(varName) + LOCKOUT_TIMER then
            player:setCharVar(varName, os.time())
            print(fmt("{} has left {} and is locked out for {} seconds.", player:getName(), dynaZones[prev][1], LOCKOUT_TIMER))

            player:timer(2500, function(playerArg)
                player:sys("You are locked out of {} for {} minutes.", dynaZones[prev][1], math.ceil(LOCKOUT_TIMER / 60))
            end)

            player:delKeyItem(xi.ki.CRIMSON_GRANULES_OF_TIME)
            player:delKeyItem(xi.ki.AZURE_GRANULES_OF_TIME)
            player:delKeyItem(xi.ki.AMBER_GRANULES_OF_TIME)
            player:delKeyItem(xi.ki.ALABASTER_GRANULES_OF_TIME)
            player:delKeyItem(xi.ki.OBSIDIAN_GRANULES_OF_TIME)

            -- Crystal Warriors lose any accumulated bonuses
            if player:isCrystalWarrior() then
                player:setCharVar("[VENTURE]DYNAMIS_BOSS", 0)
                player:setCharVar("[VENTURE]DYNAMIS_TE",   0)
            end
        end
    end
end)

-----------------------------------
-- Trail Markings
-----------------------------------
for _, zoneInfo in pairs(dynaZones) do
    local zoneName = zoneInfo[1]
    local npcPath = fmt("xi.zones.{}.npcs.{}", zoneInfo[2], zoneInfo[3])

    m:addOverride(npcPath .. ".onTrigger", function(player, npc)
        -- DEBUG
        print(fmt("{} is triggering the entrance for {}.", player:getName(), zoneName))

        local lockOutVar    = player:getCharVar(fmt("[NEO]{}", zoneName))
        local timeRemaining = os.time() - lockOutVar

        -- If the lockout expired, just use the regular function
        if timeRemaining > LOCKOUT_TIMER then
            super(player, npc)
            return
        end

        -----------------------------------
        -- Provide menu to reset lockout
        -----------------------------------
        player:sys("{} is still locked out of {} for {} minutes.", player:getName(), zoneName, math.ceil((LOCKOUT_TIMER - timeRemaining) / 60))

        if player:isCrystalWarrior() then
            return
        end

        local resetCost = math.ceil(100000 * (LOCKOUT_TIMER - timeRemaining) / LOCKOUT_TIMER)

        player:customMenu({
            title   = "Pay gil to reset lockout?",
            options =
            {
                {
                    "No thanks.",
                    function()
                    end,
                },
                {
                    fmt("Pay {} gil.", resetCost),
                    function()
                        if player:getGil() < resetCost then
                            player:sys("You do not have enough gil to reset your Dynamis lockout.")
                            return
                        end

                        player:delGil(resetCost)
                        player:setCharVar(fmt("[NEO]{}", zoneName), 0)
                    end,
                },
            },
        })
    end)
end

return m
