-----------------------------------
-- CatsEyeXI Dynamis 2.0
-----------------------------------
require("modules/module_utils")
local cms  = require("modules/catseyexi/lua/additive_overrides/utils/custom_mob_scaler")
-----------------------------------
local m = Module:new("dyna_2_0_scaling_nms")

local scalingNM =
{
   {"Dynamis-San_dOria", "Overlords_Tombstone"},
   {"Dynamis-Windurst",  "Tzee_Xicu_Idol"     },
   {"Dynamis-Bastok",    "GuDha_Effigy"       },
   {"Dynamis-Jeuno",     "Goblin_Golem"       },
}

for _, pair in ipairs(scalingNM) do
    local zone     = pair[1]
    local mobName  = pair[2]

    xi.module.ensureTable("xi.zones.%s.mobs.%s.onMobFight", zone, mobName)

    local module_path = string.format("xi.zones.%s.mobs.%s.onMobFight", zone, mobName)
    m:addOverride(module_path, function(mob, target)
        cms.mobScalerPercentage(mob, target,
        {
            minplayers = 6,
            maxplayers = 18,
            HP         = 3000
        })
    end)
end

return m