-----------------------------------
-- Domain Officier
-----------------------------------
-- !pos -9 -6 -26 245
-----------------------------------
require("modules/module_utils")
require('scripts/globals/npc_util')
require("scripts/globals/utils")
-----------------------------------
local m = Module:new("npc_domain_officer")

local vars =
{
    progress = "PaidForMeritWs"
}

local nationCurrency =
{
    [xi.nation.SANDORIA] = "sandoria_cp",
    [xi.nation.BASTOK]   = "bastok_cp",
    [xi.nation.WINDURST] = "windurst_cp",
}

local currencyList =
{
    { "Conquest Points",   "conquest_points"   },
    { "Imperial Standing", "imperial_standing" },
    { "Allied Notes",      "allied_notes"      },
}

local wsTable =
{
-- [index] = { "varName", ws unlock ID, defined in database },
    [2]  = { "hasShijinSpiralUnlock", 60, "Shijin Spiral" },
    [3]  = { "hasExenteratorUnlock",  53, "Exenterator"   },
    [4]  = { "hasRequiescatUnlock",   56, "Requiescat"    },
    [5]  = { "hasResolutionUnlock",   57, "Resolution"    },
    [6]  = { "hasRuinatorUnlock",     58, "Ruinator"      },
    [7]  = { "hasUpheavalUnlock",     63, "Upheaval"      },
    [8]  = { "hasEntropyUnlock",      52, "Entropy"       },
    [9]  = { "hasStardiverUnlock",    61, "Stardiver"     },
    [10] = { "hasBladeShunUnlock",    51, "Blade Shun"    },
    [11] = { "hasTachiShohaUnlock",   62, "Tachi Shoha"   },
    [12] = { "hasRealmrazerUnlock",   55, "Realmrazer"    },
    [13] = { "hasShattersoulUnlock",  59, "Shattersoul"   },
    [14] = { "hasApexArrowUnlock",    50, "Apex Arrow"    },
    [15] = { "hasLastStandUnlock",    54, "Last Stand"    },
}

local itemNames =
{
    [1464] = "lancewood logs",
    [1466] = "relic irons",
    [1469] = "wootz ores",
    [1470] = "sparkling stones",
    [1474] = "infinity cores",
    [1516] = "griffon hides",
    [1517] = "giant frozen heads",
    [1518] = "colossal skulls",
    [1519] = "fresh orc livers",
    [1520] = "goblin grease",
    [1521] = "slime juice",
}

local materials =
{
    { "Shijin Spiral", { { 1464, 10 }, { 1474, 10 } }, xi.wsUnlock.SHIJIN_SPIRAL }, -- lancewood log,     infinity core
    { "Exenterator",   { { 1521, 10 }, { 1474, 10 } }, xi.wsUnlock.EXENTERATOR   }, -- slime juice,       infinity core
    { "Requiescat",    { { 1518, 10 }, { 1474, 10 } }, xi.wsUnlock.REQUIESCAT    }, -- colossal skull,    infinity core
    { "Resolution",    { { 1520, 10 }, { 1474, 10 } }, xi.wsUnlock.RESOLUTION    }, -- goblin grease,     infinity core
    { "Ruinator",      { { 1516, 10 }, { 1474, 10 } }, xi.wsUnlock.RUINATOR      }, -- griffon hide,      infinity core
    { "Upheaval",      { { 1517, 10 }, { 1474, 10 } }, xi.wsUnlock.UPHEAVAL      }, -- giant frozen head, infinity core
    { "Entropy",       { { 1466, 10 }, { 1474, 10 } }, xi.wsUnlock.ENTROPY       }, -- relic iron,        infinity core
    { "Stardiver",     { { 1519, 10 }, { 1474, 10 } }, xi.wsUnlock.STARDIVER     }, -- fresh orc liver,   infinity core
    { "Blade Shun",    { { 1469, 10 }, { 1474, 10 } }, xi.wsUnlock.BLADE_SHUN    }, -- wootz ore,         infinity core
    { "Tachi Shoha",   { { 1470, 10 }, { 1474, 10 } }, xi.wsUnlock.TACHI_SHOHA   }, -- sparkling stone,   infinity core
    { "Realmrazer",    { { 1517, 10 }, { 1518, 10 } }, xi.wsUnlock.REALMRAZER    }, -- giant frozen head, colossal skull
    { "Shattersoul",   { { 1521, 10 }, { 1519, 10 } }, xi.wsUnlock.SHATTERSOUL   }, -- slime juice,       fresh orc liver
    { "Apex Arrow",    { { 1516, 10 }, { 1464, 10 } }, xi.wsUnlock.APEX_ARROW    }, -- griffon hide,      lancewood log
    { "Last Stand",    { { 1520, 10 }, { 1466, 10 } }, xi.wsUnlock.LAST_STAND    }, -- goblin grease,     relic iron
}

local refunds =
{
    { name = "Uk'uxkaj Cap",     id = 27766, value = 30000 },
    { name = "Uk'uxkaj Boots",   id = 28331, value = 30000 },
    { name = "Floral Gauntlets", id = 27137, value = 30000 },
    { name = "Vampirism",        id = 20706, value = 60000 },
    { name = "Taming Sari",      id = 20596, value = 60000 },

    { name = "Samnuha Tights",   id = 27295, value = 30000 },
    { name = "Samnuha Coat",     id = 26973, value = 30000 },
    { name = "Mediums Sabots",   id = 27493, value = 30000 },
    { name = "Merovingian",      id = 20796, value = 60000 },
    { name = "Ochu",             id = 20978, value = 60000 },

    { name = "Jumalik Helm",     id = 25603, value = 30000 },
    { name = "Jumalik Mail",     id = 26972, value = 30000 },
    { name = "Dampening Tam",    id = 25630, value = 30000 },
    { name = "Divinity",         id = 21088, value = 60000 },
    { name = "Malevolence",      id = 20595, value = 60000 },
}

local items =
{
    {
        "Consumables & Materials",
        {
            { "Pearlscale (grants Elvorseal)",    5714,   250 },
            { "Aged Box (Bayld)",                 6267,  2000 },
            { "Teleport Ring: Holla",            14661,  5000 },
            { "Teleport Ring: Dem",              14662,  5000 },
            { "Teleport Ring: Mea",              14663,  5000 },
            { "Siren's Hair",                     1313,  5000 },
            { "Scintillant Ingot",                2275,  5000 },
            { "Beech Log",                         692, 10000 },
            { "Khimaira Horn",                    2371, 15000 },
            { "Aether Dust",                      9470, 15000 },
            { "Aged Box (Bayld) x12", { { 6267, 12 } }, 24000 },
            { "Gabbrath Horn",                    3977, 30000 },
            { "Rockfin Tooth",                    3979, 30000 },
            { "Bztavian stinger",                 3980, 30000 },
            { "Waktza Rostrum",                   4012, 30000 },
            { "Yggdreant Bole",                   4014, 30000 },
            { "Cehuetzi Claw",                    8752, 30000 },
            { "Cipher: Mayakov",                 10151, 50000 },
        },
    },
    {
        "Weapons & Armor",
        {
            { "Barkborer",                     17964, 20000 },
            { "Ermine's Tail",                 19113, 20000 },
            { "Eventreuse",                    18504, 20000 },
            { "Koggelmander",                  17759, 20000 },
            { "Onishibari",                    19273, 20000 },
            { "Scheherazade",                  19158, 20000 },
            { "Zaide",                         18131, 20000 },
            { "Zonure",                        18865, 20000 },
            { "Narmar Boomerang",              21348, 25000 },
            { "Cloud Hairpin",                 28350, 25000 },
            { "Gnole Crown",                   11483, 15000 },
            { "Adsilio Boots",                 28271, 10000 },
            { "Adsilio Boots +1",              28272, 15000 },
        },
    },
    {
        "Accessories",
        {
            { "Antica Ring",                   15839, 15000 },
            { "Antica Band",                   11484, 15000 },
            { "Gnole Torque",                  16283, 15000 },
            { "Lycopodium Earring",            16011, 20000 },
            { "Lycopodium Sash",               15928, 20000 },
            { "Mamool Ja Earring",             16012, 20000 },
            { "Mamool Ja Mantle",              16250, 20000 },
            { "Crested Torque",                28349, 25000 },
            { "Setae Ring",                    28529, 15000 },
            { "Megasco Earring",               28488, 15000 },
            { "Salire Belt",                   28425, 25000 },
            { "Charitoni Sling",               21347, 20000 },
            { "Dew Silk Cape",                 27598, 10000 },
            { "Dew Silk Cape +1",              27599, 15000 },
            { "Emico Mantle",                  27597, 15000 },
            { "Fylgja Torque",                 11579, 15000 },
            { "Fylgja Torque +1",              11580, 25000 },
            { "Incubus Earring",               16052, 15000 },
            { "Incubus Earring +1",            16053, 25000 },
            { "Ire Torque",                    11581, 15000 },
            { "Ire Torque +1",                 11582, 25000 },
            { "Lmg. Medallion",                11583, 15000 },
            { "Lmg. Medallion +1",             11584, 25000 },
            { "Pythia Sash",                   15949, 15000 },
            { "Pythia Sash +1",                15950, 25000 },
            { "Toxon Belt",                    15951, 15000 },
            { "Toxon Belt +1",                 15952, 25000 },
        },
    },
    {
        "Crafting & Hobbies",
        {
            { "Carver's Torque",               10948, 15000 },
            { "Tanner's Torque",               10952, 15000 },
            { "Smithy's Torque",               10949, 15000 },
            { "Goldsmith's Torque",            10950, 15000 },
            { "Boneworker's Torque",           10953, 15000 },
            { "Weaver's Torque",               10951, 15000 },
            { "Alchemist's Torque",            10954, 15000 },
            { "Culinarian Torque",             10955, 15000 },
            { "Fisher's Torque",               10925, 15000 },
            { "Field Torque",                  10926, 15000 },
            { "Field Rope",                    11769, 15000 },
        },
    },
    {
        "Battlefields",
        {
            { "Domain NM", "[CQ]DOMAIN_NM", 200000 },
        },
    },
}

local upgrades =
{
    {
        nq   = { "Adsilio Boots",    28271 },
        hq   = { "Adsilio Boots +1", 28272 },
        desc = "a pair of adsilio boots",
        cost = 5000,
    },
    {
        nq   = { "Dew Silk Cape",    27598 },
        hq   = { "Dew Silk Cape +1", 27599 },
        desc = "a dew silk cape",
        cost = 5000,
    },
    {
        nq   = { "Fylgja Torque",    11579 },
        hq   = { "Fylgja Torque +1", 11580 },
        desc = "a fylgja torque",
        cost = 10000,
    },
    {
        nq   = { "Incubus Earring",    16052 },
        hq   = { "Incubus Earring +1", 16053 },
        desc = "an incubus earring",
        cost = 10000,
    },
    {
        nq   = { "Ire Torque",    11581 },
        hq   = { "Ire Torque +1", 11582 },
        desc = "an ire torque",
        cost = 10000,
    },
    {
        nq   = { "Lmg. Medallion",    11583 },
        hq   = { "Lmg. Medallion +1", 11584 },
        desc = "a lemegeton medallion",
        cost = 10000,
    },
    {
        nq   = { "Pythia Sash",    15949 },
        hq   = { "Pythia Sash +1", 15950 },
        desc = "a pythia sash",
        cost = 10000,
    },
    {
        nq   = { "Toxon Belt",    15951 },
        hq   = { "Toxon Belt +1", 15952 },
        desc = "a toxon belt",
        cost = 10000,
    },
}

-- reduced cost after completing an aeonic unlock
local function getCost(player)
    if
        player:isCrystalWarrior() or
        player:isClassicMode()
    then
        if player:getCharVar("Afterglow") > 0 then
            return { 75000, "75,000" }
        else
            return { 100000, "100,000" }
        end
    else
        if player:getCharVar("Afterglow") > 0 then
            return { 200000, "200,000" }
        else
            return { 300000, "300,000" }
        end
    end
end

local function reLearnWeaponSkill(player)
    for i = 2, 15 do
        if
            player:getCharVar(wsTable[i][1]) == 1 and
            not player:hasLearnedWeaponskill(wsTable[i][2])
        then
            player:addLearnedWeaponskill(wsTable[i][2])
        end
    end
end

local function delaySendMenu(player, menu)
    player:timer(100, function(playerArg)
        playerArg:customMenu(menu)
    end)
end

local function unlockWs(player, npc, wsInfo)
    local wsName       = wsInfo[3]
    local wsID         = wsInfo[2]
    local wsCost       = 50000
    local balance      = player:getCharVar("[Domain]Shards")

    local menu =
    {
        title   = string.format("Spend %i shards? (%i available)", wsCost, balance),
        options =
        {
            {
                "Not yet.",
                function()
                end,
            },
            {
                string.format("Unlock: %s", wsName),
                function(playerArg)
                    player:incrementCharVar("[Domain]Shards", -wsCost)
                    player:setCharVar("PaidForMeritWs", 0)
                    player:setCharVar("Afterglow", 1)
                    player:setCharVar(wsInfo[1], 1)

                    player:addLearnedWeaponskill(wsID)

                    player:timer(1000, function()
                        cexi.util.dialog(player, {
                            { message = "\129\154 Aeonic Phase 3 Complete \129\154" },
                            "You've unlocked a new weaponskill!",
                        })
                    end)
                end,
            },
        },
    }

    delaySendMenu(player, menu)
end

local function completeUpgrade(player, npc, itemInfo)
    local balance      = player:getCharVar("[Domain]Shards")
    local confirmMenu  =
    {
        title   = fmt("Upgrade {} to {}?", itemInfo.nq[1], itemInfo.hq[1]),
        options =
        {
            {
                "No thanks",
                function()
                end,
            },
            {
                fmt("Upgrade for {} shards", itemInfo.cost),
                function(playerArg)
                    if balance < itemInfo.cost then
                        cexi.util.dialog(player, {
                            "You can't afford that yet.",
                        }, npc:getPacketName(), { npc = npc })

                        return
                    end

                    player:tradeComplete()

                    cexi.util.dialog(player, {
                        fmt("Okay, I've upgraded your {} and deducted {} shards from your balance.", itemInfo.nq[1], itemInfo.cost),
                    }, npc:getPacketName(), { npc = npc })

                    player:timer(2000, function()
                        if npcUtil.giveItem(player, itemInfo.hq[2]) then
                            player:incrementCharVar("[Domain]Shards", -itemCost)
                        end
                    end)
                end,
            },
        },
    }

    delaySendMenu(player, confirmMenu)
end

local function completeTransaction(player, npc, item)
    local balance      = player:getCharVar("[Domain]Shards")
    local itemName     = item[1]
    local itemID       = item[2]
    local itemCost     = item[3]
    local confirmMenu  =
    {
        title   = string.format("Spend %i shards? (%i available)", itemCost, balance),
        options =
        {
            {
                "No, I've changed my mind.",
                function()
                end,
            },
            {
                string.format("Purchase: %s", itemName),
                function(playerArg)
                    if balance >= itemCost and itemID ~= nil then
                        if type(itemID) == "string" then
                            if player:getCharVar(itemID) > 0 then
                                cexi.util.dialog(player, {
                                    "You have already been authorized to initiate a Domain NM battle."
                                }, npc:getPacketName(), { npc = npc })
                                return
                            else
                                player:setCharVar(itemID, 1)
                                player:incrementCharVar("[Domain]Shards", -itemCost)
                                player:sys("You've been authorized to initiate a Domain NM battle!")
                                cexi.util.dialog(player, {
                                    "To commence the battle, approach a Domain Seal in La Theine Plateau, Konschtat Highlands, or Tahrongi Canyon.",
                                }, npc:getPacketName(), { npc = npc })
                            end
                        else
                            if npcUtil.giveItem(player, itemID) then
                                player:incrementCharVar("[Domain]Shards", -itemCost)
                            else
                                cexi.util.dialog(player, {
                                    "Come back when you're able to hold that."
                                }, npc:getPacketName(), { npc = npc })
                            end
                        end
                    else
                        cexi.util.dialog(player, {
                            "You can't afford this item yet.",
                        }, npc:getPacketName(), { npc = npc })
                    end
                end,
            },
        },
    }

    delaySendMenu(player, confirmMenu)
end

local function confirmPurchase(player, npc, item)
    if item[3] == 0 then
        unlockWs(player, npc, item)
    else
        completeTransaction(player, npc, item)
    end
end

local function purchaseMaterials(player, npc)
    npc:facePlayer(player, true)

    xi.shop.general(player, {
        1464, 500000,  -- Lancewood Log
        1474, 500000,  -- Infinity Core
        1521, 500000,  -- Slime Juice
        1518, 500000,  -- Colossal Skull
        1520, 500000,  -- Goblin Grease
        1516, 500000,  -- Griffon Hide
        1517, 500000,  -- Giant Frozen Head
        1466, 500000,  -- Relic Iron
        1519, 500000,  -- Fresh Orc Liver
        1469, 500000,  -- Wootz Ore
        1470, 500000,  -- Sparkling Stone
        1553, 3000000, -- Themis Orb 
        1180, 3000000, -- Atropos Orb
        1178, 3000000, -- Lachesis Orb
        1175, 3000000, -- Clotho Orb
        1130, 3000000, -- Moon Orb
    })
end

local function spendCurrency(player, npc, row)
    local currency = row[2]
    local cost     = row[3]
    local points   = row[4]

    if currency == "conquest_points" then
        currency = nationCurrency[player:getNation()]
    end

    local currencyName = string.gsub(row[2], "_", " ")

    player:timer(1000, function()
        if points >= cost then
            player:delCurrency(currency, cost)
            player:setCharVar("PaidForMeritWs", 1)
            player:tradeComplete()

            cexi.util.dialog(player, {
                { message = "\129\154 Aeonic Phase 1 Complete \129\154" },
                "Talk to me again for the next steps.",
            }, npc:getPacketName(), { npc = npc })
        else

            cexi.util.dialog(player, {
                fmt("You will need more {} before you can do that.", currencyName)
            }, npc:getPacketName(), { npc = npc })
        end
    end)
end

local function listMaterial(player, npc, row)
    local mat1 = row[2][1][1]
    local mat2 = row[2][2][1]

    cexi.util.dialog(player, {
        fmt("For {}, you'll need 10 {} and 10 {}.", row[1], itemNames[mat1], itemNames[mat2])
    }, npc:getPacketName(), { npc = npc })
end

local function aeonicUnlock(player, npc)
    local progress  = player:getCharVar(vars.progress)

    if progress == 0 then
        local pointsCost = getCost(player)

        cexi.util.dialog(player, {
            fmt("Up for a challenge? How about a new weaponskill?\nFirst, you'll need {} conquest points, imperial standing, or allied notes.", pointsCost[2]),
        }, npc:getPacketName(), { npc = npc });

        local tbl = {}

        for _, v in pairs(currencyList) do
            local points = 0

            if v[2] == "conquest_points" then
                points = player:getCurrency(nationCurrency[player:getNation()])
            else
                points = player:getCurrency(v[2])
            end

            table.insert(tbl, { fmt("{} ({})", v[1], points), v[2], pointsCost[1], points })
        end

        cexi.util.simpleMenu(player, npc, tbl, spendCurrency, "Choose a currency:")

    elseif progress == 1 then
        cexi.util.dialog(player, { "For the next step, please bring the requisite items for the aeonic weaponskill you'd like to unlock." }, npc:getPacketName(), { npc = npc })

        local wsList = {}

        for _, wsInfo in pairs(materials) do
            if not player:hasLearnedWeaponskill(wsInfo[3]) then
                table.insert(wsList, wsInfo)
            end
        end

        cexi.util.simpleMenu(player, npc, wsList, listMaterial, "Choose a Weaponskill:")

    elseif progress > 1 then
        local balance = player:getCharVar("[Domain]Shards")

        if balance < 50000 then
            cexi.util.dialog(player, {
                fmt("Completing the process and unlocking {} will cost 50,000 domain shards. However, you currently only have {} domain shards", wsTable[progress][3], balance)
            }, npc:getPacketName(), { npc = npc })
        else
            cexi.util.dialog(player, { fmt("To complete the process and unlock {} will cost 50,000 domain shards.", wsTable[progress][3]) }, npc:getPacketName(), { npc = npc })
            unlockWs(player, npc, wsTable[progress])
        end
    end
end

local qtyList =
{
    {  "x1",  1 },
    {  "x2",  2 },
    {  "x3",  3 },
    {  "x6",  6 },
    { "x12", 12 },
    { "x24", 24 },
    { "x36", 36 },
    { "x99", 99 },
}

local function selectQty(player, npc)
    local balance = player:getCharVar("[Domain]Bayld")
    local tbl     = {}

    for _, qtyInfo in pairs(qtyList) do
        if qtyInfo[2] <= balance then
            table.insert(tbl, {
                qtyInfo[1],
                function()
                    if npcUtil.giveItem(player, { { 8798, qtyInfo[2] } }) then
                        player:incrementCharVar("[Domain]Bayld", -qtyInfo[2])

                        if balance - qtyInfo[2] > 0 then
                            selectQty(player, npc)
                        end
                    end
                end,
            })
        end
    end

    delaySendMenu(player, {
        title   = fmt("Withdraw H-P Bayld ({}):", balance),
        options = tbl,
    })
end

local function onTrigger(player, npc)
    -- First thing: Let's convert Weaponskills to the proper unlock system.
    reLearnWeaponSkill(player)

    local options =
    {
        {
            "Spend Domain Shards",
            function()
                local balance = player:getCharVar("[Domain]Shards")
                local title   = string.format("Current balance: %u", balance)

                cexi.util.dialog(player, {
                    fmt("You have {} domain shards available to spend. Choose wisely.", balance),
                }, npc:getPacketName(), { npc = npc })

                cexi.util.categoryMenu(player, npc, items, confirmPurchase, title)
            end,
        },
        {
            "Unlock Weaponskill",
            function()
                aeonicUnlock(player, npc)
            end,
        },
        {
            "Purchase Materials",
            function()
                purchaseMaterials(player, npc)
            end,
        },
        {
            "Withdraw Bayld",
            function()
                local balance = player:getCharVar("[Domain]Bayld")

                if balance > 0 then
                    selectQty(player, npc)
                else
                    cexi.util.dialog(player, {
                        "Hey, you don't have any H-P Bayld stored yet!"
                    }, npc:getPacketName(), { npc = npc })
                end
            end,
        },
    }

    if player:getCharVar("[Domain]Bayld") >= 3000 then
        table.insert(options, {
            "Purchase Bayld Crystal",
            function()
                delaySendMenu(player, {
                    title   = "Are you sure?",
                    options =
                    {
                        {
                            "Not now",
                            function()
                            end,
                        },
                        {
                            "Purchase Bayld Crystal (3000)",
                            function()
                                if npcUtil.giveItem(player, xi.item.BAYLD_CRYSTAL) then
                                    player:incrementCharVar("[Domain]Bayld", -3000)
                                end
                            end,
                        },
                    },
                })
            end,
        })
    end

    delaySendMenu(player, {
        title   = "What do you want?",
        options = options,
    })
end

local function onTrade(player, npc, trade)
    for index, ws in pairs(materials) do
        if
            npcUtil.tradeHasExactly(trade, ws[2]) and
            not player:hasLearnedWeaponskill(ws[3])
        then
            player:tradeComplete()
            player:setCharVar("PaidForMeritWs", index + 1)

            cexi.util.dialog(player, {
                { message = "\129\154 Aeonic Phase 2 Complete \129\154" },
                "Well done. Speak to me when you're ready to complete the final phase.",
            }, npc:getPacketName(), { npc = npc })

            return
        end
    end

    for _, itemInfo in pairs(upgrades) do
        if cexi.util.tradeHasExactly(trade, itemInfo.nq[2]) then
            cexi.util.dialog(player, {
                fmt("I see you've got your hands on {}.", itemInfo.desc),
            }, npc:getPacketName(), { npc = npc })

            completeUpgrade(player, npc, itemInfo)
        end
    end

    for _, itemInfo in pairs(refunds) do
        if cexi.util.tradeHasExactly(trade, itemInfo.id) then
            cexi.util.dialog(player, {
                fmt("If you don't want to keep your {}, you can exchange it here for {} Domain Shards.", itemInfo.name, itemInfo.value),
            }, npc:getPacketName(), { npc = npc })

            delaySendMenu(player, {
                title   = fmt("Sell {}?", itemInfo.name),
                options =
                {
                    {
                        "No way!",
                        function()
                        end,
                    },
                    {
                        fmt("Sell for {} shards", itemInfo.value),
                        function()
                            player:tradeComplete()
                            player:incrementCharVar("[Domain]Shards", itemInfo.value)
                            player:sys("{} obtains {} domain shards.", player:getName(), itemInfo.value)
                        end,
                    },
                },
            })
        end
    end

    if npcUtil.tradeHasOnly(trade, 8798) then
        local qty     = trade:getItemCount(8798)
        local balance = player:getCharVar("[Domain]Bayld")
        player:tradeComplete()

        player:setCharVar("[Domain]Bayld", balance + qty)
        cexi.util.dialog(player, {
            fmt("I've added the {} H-P Bayld to your account.\n That brings your total to {}.", qty, balance + qty)
        }, npc:getPacketName(), { npc = npc })
    end
end

cexi.util.liveReload(m, {
    ["Upper_Jeuno"] =
    {
        {
            objtype   = xi.objType.NPC,
            name      = "Domain Officer",
            look      = cexi.util.look({
                race = xi.race.GALKA,
                face = cexi.face.A8,
                head = 125, -- Shaded Spectacles
                body = 401, -- Samnuha Coat
                hand =  99, -- Seiryu's Kote
                legs = 306, -- Savant's Pants
                feet = 306, -- Savant's Loafers
                main = 305, -- Rune Staff
            }),
            x         = -61.948,
            y         = -0.199,
            z         = 27.454,
            rotation  = 42,
            onTrade   = onTrade,
            onTrigger = onTrigger,
        },
    },
})

return m
