-----------------------------------
-- Domain Invasion Skills
-----------------------------------
require("modules/module_utils")
require("scripts/globals/mobskills")
require("scripts/globals/utils")
-----------------------------------
local m = Module:new("domain_invasion_skills")

local skills =
{
    -- modeled after Sable Breath
    ["aquatic_lance"] = function(target, mob, skill)
        local power = math.random(225, 425)
        local dmgmod = xi.mobskills.mobBreathMove(mob, target, skill, 0.2, 1.25, xi.element.WATER, power)
        dmgmod = utils.conalDamageAdjustment(mob, target, skill, dmgmod, 0.9)

        local dmg = xi.mobskills.mobFinalAdjustments(dmgmod, mob, skill, target, xi.attackType.BREATH, xi.damageType.WATER, xi.mobskills.shadowBehavior.IGNORE_SHADOWS)

        target:takeDamage(dmg, mob, xi.attackType.BREATH, xi.damageType.WATER)

        xi.mobskills.mobPhysicalStatusEffectMove(mob, target, skill, xi.effect.MAGIC_DEF_DOWN, 30, 0, 60)
        xi.mobskills.mobPhysicalStatusEffectMove(mob, target, skill, xi.effect.DEFENSE_DOWN, 30, 0, 60)

        return dmg
    end,

    -- modeled after Venom Spray
    ["aqua_fortis"] = function(target, mob, skill)
        local typeEffect = xi.effect.POISON
        local power = mob:getMainLvl() / 8 + 10

        xi.mobskills.mobStatusEffectMove(mob, target, typeEffect, power, 3, 60)

        local dmgmod   = 1
        local magicDmg = xi.mobskills.mobMagicalMove(mob, target, skill, mob:getWeaponDmg() * 1.8, xi.element.WATER, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT)
        local dmg      = xi.mobskills.mobFinalAdjustments(magicDmg, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.WATER, xi.mobskills.shadowBehavior.IGNORE_SHADOWS)
        target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.WATER)
        return dmg
    end,

    -- modeled after throat stab
    ["barreling_smash"] = function(target, mob, skill)
        local currentHP = target:getHP()
        -- remove all by 5%
        local damage = 0

        -- if have more hp then 30%, then reduce to 5%
        if currentHP / target:getMaxHP() > 0.2 then
            damage = currentHP * .95
        else
            -- else you die
            damage = currentHP
        end

        local dmg = xi.mobskills.mobFinalAdjustments(damage, mob, skill, target, xi.attackType.PHYSICAL, xi.damageType.BLUNT, xi.mobskills.shadowBehavior.IGNORE_SHADOWS)

        target:takeDamage(dmg, mob, xi.attackType.PHYSICAL, xi.damageType.BLUNT)
        mob:resetEnmity(target)
        return dmg
    end,

    -- modeled after -
    ["batholithic_shell"] = function(target, mob, skill)
        local duration = math.random(30, 60)

        xi.mobskills.mobBuffMove(mob, xi.effect.BLAZE_SPIKES, math.random(1, 10), 0, duration)
        xi.mobskills.mobBuffMove(mob, xi.effect.STONESKIN, math.random(1000, 1500), 0, duration)
        xi.mobskills.mobBuffMove(mob, xi.effect.HASTE, 2500, 0, duration)
        xi.mobskills.mobBuffMove(mob, xi.effect.ATTACK_BOOST, 15, 0, duration)
        xi.mobskills.mobBuffMove(mob, xi.effect.MAGIC_ATK_BOOST, 20, 0, duration)
        skill:setMsg(xi.msg.basic.NONE)
        return 0
    end,

    -- modeled after -
    ["biting_abrogation"] = function(target, mob, skill)
    -- KNOCKBACK
        xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.PARALYSIS, 50, 0, math.random(15, 30))

        local dmgmod    = 1
        local magicDmg  = xi.mobskills.mobMagicalMove(mob, target, skill, mob:getWeaponDmg() * 5, xi.element.ICE, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT)
        local dmg       = xi.mobskills.mobFinalAdjustments(magicDmg, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.ICE, xi.mobskills.shadowBehavior.IGNORE_SHADOWS)
        local dispelled = math.random(2, 4)

        for i = 1, dispelled do
            target:dispelStatusEffect()
        end

        target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.ICE)

        return dmg
    end,

    -- modeled after vortex
    ["blistering_roar"] = function(target, mob, skill)
        local numhits = 1
        local accmod = 1
        local dmgmod = 2
        local info = xi.mobskills.mobPhysicalMove(mob, target, skill, numhits, accmod, dmgmod, xi.mobskills.physicalTpBonus.DMG_VARIES, 1, 2, 3)
        local dmg = xi.mobskills.mobFinalAdjustments(info.dmg, mob, skill, target, xi.attackType.PHYSICAL, xi.damageType.SLASHING, xi.mobskills.shadowBehavior.NUMSHADOWS_3)
        xi.mobskills.mobPhysicalStatusEffectMove(mob, target, skill, xi.effect.TERROR, 1, 0, 3)
        xi.mobskills.mobBuffMove(mob, xi.effect.DEFENSE_BOOST, 100, 0, 60)
        target:takeDamage(dmg, mob, xi.attackType.PHYSICAL, xi.damageType.SLASHING)
        mob:resetEnmity(target)

        return dmg
    end,

    -- modeled after -
    ["brain_freeze"] = function(target, mob, skill)
        xi.mobskills.mobPhysicalStatusEffectMove(mob, target, skill, xi.effect.INT_DOWN, 30, 0, 60)
        local power = math.random(225, 325)
        local dmgmod = xi.mobskills.mobBreathMove(mob, target, skill, 0.25, 2.5, xi.element.ICE, power)
        local dmg    = xi.mobskills.mobFinalAdjustments(dmgmod, mob, skill, target, xi.attackType.BREATH, xi.damageType.ICE, xi.mobskills.shadowBehavior.IGNORE_SHADOWS)

        target:takeDamage(dmg, mob, xi.attackType.BREATH, xi.damageType.ICE)

        return dmg
    end,

    -- modeled after brownout
    ["brownout"] = function(target, mob, skill)
        local power = math.random(225, 425)
        local duration = math.random(15, 30)
        xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.BLINDNESS, 25, 0, duration)
        xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.SLOW, 1250, 0, duration)

        local dmgmod = xi.mobskills.mobBreathMove(mob, target, skill, 0.25, 2.5, xi.element.THUNDER, power)
        local dmg    = xi.mobskills.mobFinalAdjustments(dmgmod, mob, skill, target, xi.attackType.BREATH, xi.damageType.THUNDER, xi.mobskills.shadowBehavior.IGNORE_SHADOWS)

        target:takeDamage(dmg, mob, xi.attackType.BREATH, xi.damageType.THUNDER)

        return dmg
    end,

    -- modeled after tebbad_wing
    ["canopierce"] = function(target, mob, skill)
        local typeEffect = xi.effect.RASP

        xi.mobskills.mobStatusEffectMove(mob, target, typeEffect, 10, 0, math.random(15, 30))

        local dmgmod   = 1.5
        local magicDmg = xi.mobskills.mobMagicalMove(mob, target, skill, mob:getWeaponDmg() * 5, xi.element.EARTH, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT)
        local dmg      = xi.mobskills.mobFinalAdjustments(magicDmg, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.EARTH, xi.mobskills.shadowBehavior.WIPE_SHADOWS)
        target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.EARTH)

        return dmg
    end,

    -- modeled after Bonebreaking Barrage
    ["cranial_thrust"] = function(target, mob, skill)
        local numhits = 1
        local accmod = 1
        local dmgmod = 2.0
        local info = xi.mobskills.mobPhysicalMove(mob, target, skill, numhits, accmod, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT)
        local dmg = xi.mobskills.mobFinalAdjustments(info.dmg, mob, skill, target, xi.attackType.PHYSICAL, xi.damageType.BLUNT, xi.mobskills.shadowBehavior.IGNORE_SHADOWS, info.hitslanded)

        xi.mobskills.mobPhysicalStatusEffectMove(mob, target, skill, xi.effect.MAX_HP_DOWN, 25, 0, 60)

        target:takeDamage(dmg, mob, xi.attackType.PHYSICAL, xi.damageType.BLUNT)

        return dmg
    end,

    -- modeled after cursed_sphere
    ["crashing_thunder"] = function(target, mob, skill)
        local dmgmod   = 1
        local magicDmg = xi.mobskills.mobMagicalMove(mob, target, skill, mob:getWeaponDmg() * 4, xi.element.THUNDER, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT)
        local dmg      = xi.mobskills.mobFinalAdjustments(magicDmg, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.THUNDER, xi.mobskills.shadowBehavior.WIPE_SHADOWS)

        xi.mobskills.mobPhysicalStatusEffectMove(mob, target, skill, xi.effect.STUN, 1, 0, 2)
        target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.THUNDER)
        return dmg
    end,

    -- modeled after Aeolian Void
    ["crushing_gaze"] = function(target, mob, skill)
        local power = math.random(225, 325)
        local duration = math.random(15, 30)
        xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.WEIGHT, 25, 0, duration)
        xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.SLOW, 1250, 0, duration)

        local dmgmod = xi.mobskills.mobBreathMove(mob, target, skill, 0.25, 2.5, xi.element.EARTH, power)
        local dmg    = xi.mobskills.mobFinalAdjustments(dmgmod, mob, skill, target, xi.attackType.BREATH, xi.damageType.EARTH, xi.mobskills.shadowBehavior.IGNORE_SHADOWS)

        target:takeDamage(dmg, mob, xi.attackType.BREATH, xi.damageType.EARTH)

        return dmg
    end,

    -- modeled after winter_breeze
    ["droning_whirlwind"] = function(target, mob, skill)
        local dmgmod = .5
        local magicDmg  = xi.mobskills.mobMagicalMove(mob, target, skill, mob:getWeaponDmg() * 9, xi.element.WIND, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT, 1)
        local dmg       = xi.mobskills.mobFinalAdjustments(magicDmg, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.WIND, xi.mobskills.shadowBehavior.WIPE_SHADOWS)
        local dispelled = math.random(2, 3)

        for i = 1, dispelled do
            target:dispelStatusEffect()
        end

        xi.mobskills.mobBuffMove(mob, xi.effect.MAGIC_DEF_BOOST, 30, 0, 60)

        target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.WIND)
        return dmg
    end,

    -- modeled after Bai Wing
    ["embalming_earth"] = function(target, mob, skill)
        local dmgmod   = 1
        local magicDmg = xi.mobskills.mobMagicalMove(mob, target, skill, mob:getWeaponDmg() * 5, xi.element.EARTH, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT)
        local dmg      = xi.mobskills.mobFinalAdjustments(magicDmg, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.EARTH, xi.mobskills.shadowBehavior.WIPE_SHADOWS)

        xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.SLOW, 3000, 0, 120)

        target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.EARTH)
        return dmg
    end,

    -- modeled after floodlight
    ["firefly_fandango"] = function(target, mob, skill)
        local dmgmod   = 2
        local magicDmg = xi.mobskills.mobMagicalMove(mob, target, skill, mob:getWeaponDmg() * 3, xi.element.LIGHT, dmgmod, xi.mobskills.magicalTpBonus.MAB_BONUS, 1)
        local dmg      = xi.mobskills.mobFinalAdjustments(magicDmg, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.LIGHT, xi.mobskills.shadowBehavior.IGNORE_SHADOWS)
        xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.PARALYSIS, 50, 0, 15)
        xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.FLASH, 200, 3, 3)
        xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.MAX_MP_DOWN, 42, 0, 120)

        target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.LIGHT)
        return dmg
    end,

    -- modeled after -
    ["foul_breath"] = function(target, mob, skill)
        xi.mobskills.mobPhysicalStatusEffectMove(mob, target, skill, xi.effect.DISEASE, 1, 0, math.random(15, 30))
        local power = math.random(175, 225)
        local dmgmod = xi.mobskills.mobBreathMove(mob, target, skill, 0.25, 2.5, xi.element.FIRE, power)
        local dmg    = xi.mobskills.mobFinalAdjustments(dmgmod, mob, skill, target, xi.attackType.BREATH, xi.damageType.FIRE, xi.mobskills.shadowBehavior.IGNORE_SHADOWS)

        target:takeDamage(dmg, mob, xi.attackType.BREATH, xi.damageType.FIRE)

        return dmg
    end,

    -- modeled after -
    ["glacial_tomb"] = function(target, mob, skill)
        -- TODO: Encumberance seems to do nothing?
        local typeEffect = xi.effect.ENCUMBRANCE_I
        local duration = math.random(5, 15)

        xi.mobskills.mobStatusEffectMove(mob, target, typeEffect, 0xFFFF, 0, duration)

        local dmgmod     = 1.75
        local baseDamage = mob:getWeaponDmg() * 3.7
        local magicDmg   = xi.mobskills.mobMagicalMove(mob, target, skill, baseDamage, xi.element.ICE, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT)
        local dmg        = xi.mobskills.mobFinalAdjustments(magicDmg, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.ICE, xi.mobskills.shadowBehavior.IGNORE_SHADOWS)
        target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.ICE)

        return dmg
    end,

    -- modeled after rime_spray
    ["glassy_nova"] = function(target, mob, skill)
        xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.FROST, 15, 3, 120)
        xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.STR_DOWN, 20, 3, 60)
        xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.VIT_DOWN, 20, 3, 60)
        xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.DEX_DOWN, 20, 3, 60)
        xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.AGI_DOWN, 20, 3, 60)
        xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.MND_DOWN, 20, 3, 60)
        xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.INT_DOWN, 20, 3, 60)
        xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.CHR_DOWN, 20, 3, 60)

        local dmgmod    = 1
        local magicDmg  = xi.mobskills.mobMagicalMove(mob, target, skill, mob:getWeaponDmg() * 5, xi.element.ICE, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT)
        local dmg       = xi.mobskills.mobFinalAdjustments(magicDmg, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.ICE, xi.mobskills.shadowBehavior.IGNORE_SHADOWS)
        local dispelled = math.random(2, 3)

        if dmg > 0 then
            for i = 1, dispelled do
                target:dispelStatusEffect()
            end
        end

        target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.ICE)

        return dmg
    end,

    -- modeled after Throat Stab
    ["gnash"] = function(target, mob, skill)
        local currentHP = target:getHP()
        -- remove all by 5%
        local damage = 0

        -- if have more hp then 30%, then reduce to 5%
        if currentHP / target:getMaxHP() > 0.2 then
            damage = currentHP * .50
        else
            -- else you die
            damage = currentHP
        end

        local dmg = xi.mobskills.mobFinalAdjustments(damage, mob, skill, target, xi.attackType.PHYSICAL, xi.damageType.PIERCING, xi.mobskills.shadowBehavior.IGNORE_SHADOWS)

        target:takeDamage(dmg, mob, xi.attackType.PHYSICAL, xi.damageType.PIERCING)
        return dmg
    end,

    -- modeled after dream flower
    ["hypnic_lamp"] = function(target, mob, skill)
        local typeEffect = xi.effect.SLEEP_I

        skill:setMsg(xi.mobskills.mobStatusEffectMove(mob, target, typeEffect, 1, 0, math.random(15, 20)))

        return typeEffect
    end,

    -- modeled after barrier tusk
    ["impenetrable_carapace"] = function(target, mob, skill)
        xi.mobskills.mobBuffMove(mob, xi.effect.MAGIC_DEF_BOOST, 30, 0, 90)
        skill:setMsg(xi.mobskills.mobBuffMove(mob, xi.effect.DEFENSE_BOOST, 30, 0, 90))

        return xi.effect.DEFENSE_BOOST
    end,

    -- modeled after -
    ["incinerating_lahar"] = function(target, mob, skill)
        local typeEffect = xi.effect.WEAKNESS

        local dmgmod   = 1.5
        local magicDmg = xi.mobskills.mobMagicalMove(mob, target, skill, mob:getWeaponDmg() * 2.6, xi.element.FIRE, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT)
        local dmg      = xi.mobskills.mobFinalAdjustments(magicDmg, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.FIRE, xi.mobskills.shadowBehavior.IGNORE_SHADOWS)
        target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.FIRE)
        xi.mobskills.mobPhysicalStatusEffectMove(mob, target, skill, typeEffect, 1, 0, math.random(3, 5))

        return dmg
    end,

    -- modeled after hoof_volley
    ["incisive_apotheosis"] =
    {
        onMobSkillCheck = function(target, mob, skill)
            local mobhp = mob:getHPP()

            if mobhp < 26 or mob:getLocalVar("aura") == 0 then
                return 0
            else
                return 1
            end
        end,

        onMobWeaponSkill = function(target, mob, skill)
            local typeEffect = xi.effect.WEAKNESS

            -- The dmg amounts and duration are guesstimated based on wiki info.
            skill:setMsg(xi.mobskills.mobStatusEffectMove(mob, target, typeEffect, 1, 0, math.random(5, 10)))
            mob:resetEnmity(target)

            return typeEffect
        end,
    },

    -- modeled after target_analysis
    ["incisive_denouement"] =
    {
        onMobSkillCheck = function(target, mob, skill)
            if mob:getHPP() < 50 then
                return 0
            else
                return 1
            end
        end,

        onMobWeaponSkill = function(target, mob, skill)
            local numhits = 1
            local accmod = 1
            local dmgmod = 4.5
            local info = xi.mobskills.mobPhysicalMove(mob, target, skill, numhits, accmod, dmgmod, xi.mobskills.physicalTpBonus.CRIT_VARIES, 1, 1, 1)
            local dmg = xi.mobskills.mobFinalAdjustments(info.dmg, mob, skill, target, xi.attackType.PHYSICAL, xi.damageType.BLUNT, info.hitslanded)

            mob:resetEnmity(target)
            target:takeDamage(dmg, mob, xi.attackType.PHYSICAL, xi.damageType.BLUNT)

            return dmg
        end,
    },

    -- modeled after tackle
    ["mandibular_lashing"] = function(target, mob, skill)
        local numhits = 1
        local accmod = 1
        local dmgmod = 3.5
        local info = xi.mobskills.mobPhysicalMove(mob, target, skill, numhits, accmod, dmgmod, xi.mobskills.physicalTpBonus.DMG_VARIES, 1, 2, 3)
        local dmg = xi.mobskills.mobFinalAdjustments(info.dmg, mob, skill, target, xi.attackType.PHYSICAL, xi.damageType.BLUNT, info.hitslanded)
        local typeEffectOne = xi.effect.STUN
        local typeEffectTwo = xi.effect.POISON

        xi.mobskills.mobPhysicalStatusEffectMove(mob, target, skill, typeEffectOne, 1, 0, math.random(1, 3))
        xi.mobskills.mobPhysicalStatusEffectMove(mob, target, skill, typeEffectTwo, math.random(5, 15), 0, math.random(15, 30))
        target:takeDamage(dmg, mob, xi.attackType.PHYSICAL, xi.damageType.BLUNT)

        return dmg
    end,

    -- modeled after -
    ["marine_mayhem"] = function(target, mob, skill)
        local typeEffectOne = xi.effect.DROWN
        local typeEffectTwo = xi.effect.ATTACK_DOWN
        local duration = math.random(15, 45)

        xi.mobskills.mobStatusEffectMove(mob, target, typeEffectOne, math.random(5, 15), 0, duration)
        xi.mobskills.mobStatusEffectMove(mob, target, typeEffectTwo, math.random(15, 25), 0, duration)

        local dmgmod     = 1
        local baseDamage = mob:getWeaponDmg() * 4.2
        local magicDmg   = xi.mobskills.mobMagicalMove(mob, target, skill, baseDamage, xi.element.WATER, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT)
        local dmg        = xi.mobskills.mobFinalAdjustments(magicDmg, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.WATER, xi.mobskills.shadowBehavior.IGNORE_SHADOWS)
        target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.WATER)
        return dmg
    end,

    -- modeled after volcanic_stasis
    ["molting_plumage"] = function(target, mob, skill)
        local power = math.random(225, 425)
        local numhits = 1
        local accmod = 1
        local dmgmod = xi.mobskills.mobBreathMove(mob, target, skill, 0.2, 1.25, xi.element.WIND, power)
        dmgmod = utils.conalDamageAdjustment(mob, target, skill, dmgmod, 0.9)

        local dmg = xi.mobskills.mobFinalAdjustments(dmgmod, mob, skill, target, xi.attackType.BREATH, xi.damageType.WIND, xi.mobskills.shadowBehavior.IGNORE_SHADOWS)
        local info = xi.mobskills.mobPhysicalMove(mob, target, skill, numhits, accmod, dmgmod, xi.mobskills.physicalTpBonus.DMG_VARIES, 1, 2, 3)
        local dispelled = math.random(2, 3)

        if info.hitslanded ~= 0 then
            for i = 1, dispelled do
                target:dispelStatusEffect()
            end
        end

        target:takeDamage(dmg, mob, xi.attackType.BREATH, xi.damageType.WIND)
        return dmg
    end,

    -- modeled after -
    ["nectarous_deluge"] = function(target, mob, skill)
        local power = math.random(225, 325)
        local duration = math.random(15, 30)
        xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.POISON, math.random(10, 20), 0, duration)

        local dmgmod = xi.mobskills.mobBreathMove(mob, target, skill, 0.25, 2.5, xi.element.WATER, power)
        local dmg    = xi.mobskills.mobFinalAdjustments(dmgmod, mob, skill, target, xi.attackType.BREATH, xi.damageType.WATER, xi.mobskills.shadowBehavior.WIPE_SHADOWS)

        target:takeDamage(dmg, mob, xi.attackType.BREATH, xi.damageType.WATER)

        return dmg
    end,

    -- modeled after -
    ["nepenthic_plunge"] = function(target, mob, skill)
        local power = math.random(225, 325)
        local duration = math.random(15, 30)
        xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.WEIGHT, 25, 0, duration)
        xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.DROWN, math.random(10, 20), 0, duration)

        local dmgmod = xi.mobskills.mobBreathMove(mob, target, skill, 0.25, 2.5, xi.element.WATER, power)
        local dmg    = xi.mobskills.mobFinalAdjustments(dmgmod, mob, skill, target, xi.attackType.BREATH, xi.damageType.WATER, xi.mobskills.shadowBehavior.WIPE_SHADOWS)

        target:takeDamage(dmg, mob, xi.attackType.BREATH, xi.damageType.WATER)

        return dmg
    end,

    -- modeled after drill_claw
    ["pelagic_cleaver"] = function(target, mob, skill)
    local numhits = 1
    local accmod = 1
    local dmgmod = 2.0
    local info = xi.mobskills.mobPhysicalMove(mob, target, skill, numhits, accmod, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT)
    local dmg = xi.mobskills.mobFinalAdjustments(info.dmg, mob, skill, target, xi.attackType.PHYSICAL, xi.damageType.PIERCING, info.hitslanded)

    xi.mobskills.mobPhysicalStatusEffectMove(mob, target, skill, xi.effect.MAX_HP_DOWN, 25, 0, 60)

    target:takeDamage(dmg, mob, xi.attackType.PHYSICAL, xi.damageType.PIERCING)

    return dmg
    end,

    -- modeled after -
    ["pentapeck"] = function(target, mob, skill)
    local numhits = 3
    local accmod = 1
    local dmgmod = .8
    local info = xi.mobskills.mobPhysicalMove(mob, target, skill, numhits, accmod, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT)
    local dmg = xi.mobskills.mobFinalAdjustments(info.dmg, mob, skill, target, xi.attackType.PHYSICAL, xi.damageType.SLASHING, info.hitslanded)
    local typeEffect = xi.effect.AMNESIA

    xi.mobskills.mobPhysicalStatusEffectMove(mob, target, skill, typeEffect, 1, 0, 60)

    target:takeDamage(dmg, mob, xi.attackType.PHYSICAL, xi.damageType.SLASHING)
    return dmg
    end,

    -- modeled after thundris_shriek
    ["permafrost_requiem"] = function(target, mob, skill)
        local typeEffect = xi.effect.TERROR

        xi.mobskills.mobStatusEffectMove(mob, target, typeEffect, 1, 0, math.random(3, 5))

        local dmgmod   = 1
        local magicDmg = xi.mobskills.mobMagicalMove(mob, target, skill, mob:getWeaponDmg() * 5, xi.element.ICE, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT)
        local dmg      = xi.mobskills.mobFinalAdjustments(magicDmg, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.ICE, xi.mobskills.shadowBehavior.WIPE_SHADOWS)

        target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.ICE)

        return dmg
    end,

    -- modeled after ice_roar
    ["polar_roar"] = function(target, mob, skill)
        local dmgmod   = 1
        local magicDmg = xi.mobskills.mobMagicalMove(mob, target, skill, mob:getWeaponDmg() * 4, xi.element.ICE, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT)
        local dmg      = xi.mobskills.mobFinalAdjustments(magicDmg, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.ICE, xi.mobskills.shadowBehavior.IGNORE_SHADOWS)

        target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.ICE)
        xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.BIND, 15, 0, math.random(5, 10))
        return dmg
    end,

    -- modeled after Meeble Warble
    ["potted_plant"] = function(target, mob, skill)
        local dmgmod   = .5
        local magicDmg = xi.mobskills.mobMagicalMove(mob, target, skill, mob:getWeaponDmg() * 9, xi.element.EARTH, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT, 1)
        local dmg      = xi.mobskills.mobFinalAdjustments(magicDmg, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.EARTH, xi.mobskills.shadowBehavior.WIPE_SHADOWS)
        target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.EARTH)
        xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.BIND, 15, 0, 5)
        xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.SLOW, 1250, 0, 30)
        return dmg
    end,

    -- modeled after throat stab
    ["protolithic_puncture"] = function(target, mob, skill)
        local currentHP = target:getHP()
        -- remove all by 5%
        local damage = 0

        -- if have more hp then 30%, then reduce to 5%
        if currentHP / target:getMaxHP() > 0.2 then
            damage = currentHP * .50
        else
            -- else you die
            damage = currentHP
        end

        local dmg = xi.mobskills.mobFinalAdjustments(damage, mob, skill, target, xi.attackType.PHYSICAL, xi.damageType.PIERCING, xi.mobskills.shadowBehavior.IGNORE_SHADOWS)

        target:takeDamage(dmg, mob, xi.attackType.PHYSICAL, xi.damageType.PIERCING)
        mob:resetEnmity(target)
        return dmg
    end,

    -- modeled after vitrolic_barrage
    ["pyroclastic_surge"] = function(target, mob, skill)
        local typeEffect = xi.effect.ADDLE
        xi.mobskills.mobPhysicalStatusEffectMove(mob, target, skill, typeEffect, 50, 3, 30)

        local dmgmod   = 2
        local magicDmg = xi.mobskills.mobMagicalMove(mob, target, skill, mob:getWeaponDmg() * 2.6, xi.element.FIRE, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT)
        local dmg      = xi.mobskills.mobFinalAdjustments(magicDmg, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.FIRE, xi.mobskills.shadowBehavior.IGNORE_SHADOWS)
        target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.FIRE)

        return dmg
    end,

    -- modeled after Ill Wind
    ["rending_deluge"] = function(target, mob, skill)
        local dmgmod   = 1
        local magicDmg = xi.mobskills.mobMagicalMove(mob, target, skill, mob:getWeaponDmg() * 2.5, xi.element.WATER, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT)
        local dmg      = xi.mobskills.mobFinalAdjustments(magicDmg, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.WATER, xi.mobskills.shadowBehavior.WIPE_SHADOWS)

        target:dispelStatusEffect()
        target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.WATER)

        return dmg
    end,

    -- modeled after Aeolian Void
    ["retinal_glare"] = function(target, mob, skill)
        local power = math.random(225, 325)
        xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.FLASH, 200, 0, math.random(3, 5))

        local dmgmod = xi.mobskills.mobBreathMove(mob, target, skill, 0.25, 2.5, xi.element.LIGHT, power)
        local dmg    = xi.mobskills.mobFinalAdjustments(dmgmod, mob, skill, target, xi.attackType.BREATH, xi.damageType.LIGHT, xi.mobskills.shadowBehavior.WIPE_SHADOWS)

        target:takeDamage(dmg, mob, xi.attackType.BREATH, xi.damageType.LIGHT)

        return dmg
    end,

    -- modeled after blitzstrahl
    ["reverse_current"] = function(target, mob, skill)
        local typeEffect = xi.effect.STUN

        xi.mobskills.mobStatusEffectMove(mob, target, typeEffect, 1, 0, 3)

        local dmgmod   = 1
        local magicDmg = xi.mobskills.mobMagicalMove(mob, target, skill, mob:getWeaponDmg() * 6, xi.element.THUNDER, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT)
        local dmg      = xi.mobskills.mobFinalAdjustments(magicDmg, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.THUNDER, xi.mobskills.shadowBehavior.IGNORE_SHADOWS)
        target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.THUNDER)

        return dmg
    end,

    -- modeled after benthic_typhoon
    ["reverberating_cry"] = function(target, mob, skill)
        local numhits = 1
        local accmod = 1
        local dmgmod = 4
        local info = xi.mobskills.mobPhysicalMove(mob, target, skill, numhits, accmod, dmgmod, xi.mobskills.physicalTpBonus.DMG_VARIES, 1, 2, 3)
        local dmg = xi.mobskills.mobFinalAdjustments(info.dmg, mob, skill, target, xi.attackType.PHYSICAL, xi.damageType.PIERCING, info.hitslanded)
        target:takeDamage(dmg, mob, xi.attackType.PHYSICAL, xi.damageType.PIERCING)

        xi.mobskills.mobPhysicalStatusEffectMove(mob, target, skill, xi.effect.MAGIC_DEF_DOWN, 30, 0, 60)
        xi.mobskills.mobPhysicalStatusEffectMove(mob, target, skill, xi.effect.DEFENSE_DOWN, 30, 0, 60)

        return dmg
    end,

    -- modeled after Corrosive Ooze
    ["riptide_eupnea"] = function(target, mob, skill)
        local typeEffectOne = xi.effect.MAX_HP_DOWN
        local typeEffectTwo = xi.effect.ENCUMBRANCE_I
        local typeEffectThree = xi.effect.BIND
        local duration = 120

        xi.mobskills.mobStatusEffectMove(mob, target, typeEffectOne, 15, 0, duration)
        xi.mobskills.mobStatusEffectMove(mob, target, typeEffectTwo, 0xFFFF, 0, duration)
        xi.mobskills.mobStatusEffectMove(mob, target, typeEffectThree, 15, 0, duration)

        local dmgmod     = 1
        local baseDamage = mob:getWeaponDmg() * 4.2
        local magicDmg   = xi.mobskills.mobMagicalMove(mob, target, skill, baseDamage, xi.element.WATER, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT)
        local dmg        = xi.mobskills.mobFinalAdjustments(magicDmg, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.WATER, xi.mobskills.shadowBehavior.IGNORE_SHADOWS)
        target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.WATER)
        return dmg
    end,

    -- modeled after binary_tap
    ["root_of_the_problem"] = function(target, mob, skill)
        -- try to drain buff
        local effectFirst = mob:stealStatusEffect(target, xi.effectFlag.DISPELABLE)
        local effectSecond = mob:stealStatusEffect(target, xi.effectFlag.DISPELABLE)
        local dmg = 0
        target:setTP(target:getTP() * 0.5)
        if effectFirst ~= 0 then
            local count = 1

            if effectSecond ~= 0 then
                count = count + 1
            end

            skill:setMsg(xi.msg.basic.EFFECT_DRAINED)

            return count
        else
            -- time to drain HP. 400-650
            local power = math.random(400, 650)
            dmg = xi.mobskills.mobFinalAdjustments(power, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.EARTH, xi.mobskills.shadowBehavior.IGNORE_SHADOWS)

            skill:setMsg(xi.mobskills.mobPhysicalDrainMove(mob, target, skill, xi.mobskills.drainType.HP, dmg))

            return dmg
        end
    end,

    -- modeled after Fire Meeble Warble
    ["scalding_breath"] = function(target, mob, skill)
        local dmgmod   = 1
        local magicDmg = xi.mobskills.mobMagicalMove(mob, target, skill, mob:getWeaponDmg() * 9, xi.element.WATER, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT, 1)
        local dmg      = xi.mobskills.mobFinalAdjustments(magicDmg, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.WATER, xi.mobskills.shadowBehavior.WIPE_SHADOWS)

        target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.WATER)

        xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.BURN, 30, 3, 60)
        return dmg
    end,

    -- modeled after rushing_stab
    ["searing_serration"] = function(target, mob, skill)
        local numhits = 4
        local accmod = 1
        local dmgmod = .6
        local info = xi.mobskills.mobPhysicalMove(mob, target, skill, numhits, accmod, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT)
        local dmg = xi.mobskills.mobFinalAdjustments(info.dmg, mob, skill, target, xi.attackType.PHYSICAL, xi.damageType.PIERCING, info.hitslanded)

        target:takeDamage(dmg, mob, xi.attackType.PHYSICAL, xi.damageType.PIERCING)

        return dmg
    end,

    -- modeled after
    ["seaspray"] = function(target, mob, skill)
        local power = math.random(225, 325)
        xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.SLOW, 1250, 0, math.random(15, 30))

        local dmgmod = xi.mobskills.mobBreathMove(mob, target, skill, 0.25, 2.5, xi.element.WATER, power)
        local dmg    = xi.mobskills.mobFinalAdjustments(dmgmod, mob, skill, target, xi.attackType.BREATH, xi.damageType.WATER, xi.mobskills.shadowBehavior.IGNORE_SHADOWS)

        target:takeDamage(dmg, mob, xi.attackType.BREATH, xi.damageType.WATER)

        return dmg
    end,

    -- modeled after giga slash
    ["seismic_tail"] = function(target, mob, skill)
        local numhits = 1
        local accmod = 1
        local dmgmod = 1.5
        local info = xi.mobskills.mobPhysicalMove(mob, target, skill, numhits, accmod, dmgmod, xi.mobskills.physicalTpBonus.CRIT_VARIES, 1, 2, 3)
        local dmg = xi.mobskills.mobFinalAdjustments(info.dmg, mob, skill, target, xi.attackType.PHYSICAL, xi.damageType.SLASHING, info.hitslanded)
        target:takeDamage(dmg, mob, xi.attackType.PHYSICAL, xi.damageType.SLASHING)
        return dmg
    end,

    -- modeled after electromagnetic_field
    ["sparkstorm"] = function(target, mob, skill)
        local dmgmod   = 3
        local magicDmg = xi.mobskills.mobMagicalMove(mob, target, skill, mob:getWeaponDmg() * 2.6, xi.element.THUNDER, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT)
        local dmg      = xi.mobskills.mobFinalAdjustments(magicDmg, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.THUNDER, xi.mobskills.shadowBehavior.IGNORE_SHADOWS)

        target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.THUNDER)

        return dmg
    end,

    -- modeled after thunder_meeble_warble
    ["static_prison"] = function(target, mob, skill)
        local dmgmod   = .6
        local magicDmg = xi.mobskills.mobMagicalMove(mob, target, skill, mob:getWeaponDmg() * 9, xi.element.THUNDER, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT, 1)
        local dmg      = xi.mobskills.mobFinalAdjustments(magicDmg, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.THUNDER, xi.mobskills.shadowBehavior.WIPE_SHADOWS)

        target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.THUNDER)

        xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.STUN, 1, 0, math.random(1, 3))
        xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.SHOCK, 15, 3, 30)

        return dmg
    end,

    -- modeled after howling
    ["stinger_volley"] = function(target, mob, skill)
        local power = math.random(225, 325)
        xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.CURSE_II, 1, 0, math.random(5, 10))
        xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.PARALYSIS, 50, 0, 60)

        local dmgmod = xi.mobskills.mobBreathMove(mob, target, skill, 0.25, 2.5, xi.element.WIND, power)
        local dmg    = xi.mobskills.mobFinalAdjustments(dmgmod, mob, skill, target, xi.attackType.BREATH, xi.damageType.WIND, xi.mobskills.shadowBehavior.IGNORE_SHADOWS)

        target:takeDamage(dmg, mob, xi.attackType.BREATH, xi.damageType.WIND)

        return dmg
    end,

    -- modeled after Stone Meeble Warble
    ["stink_bomb"] = function(target, mob, skill)
        local dmgmod = 1
        local duration = math.random(15, 30)
        local magicDmg = xi.mobskills.mobMagicalMove(mob, target, skill, mob:getWeaponDmg() * 9, xi.element.EARTH, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT, 1)
        local dmg      = xi.mobskills.mobFinalAdjustments(magicDmg, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.EARTH, xi.mobskills.shadowBehavior.WIPE_SHADOWS)
        target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.EARTH)
        xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.BLINDNESS, 30, 0, duration)
        xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.PARALYSIS, 30, 0, duration)
        return dmg
    end,

    -- modeled Cursed Sphere
    ["sundering_snip"] = function(target, mob, skill)
        local dmgmod   = 1
        local magicDmg = xi.mobskills.mobMagicalMove(mob, target, skill, mob:getWeaponDmg() * 2.6, xi.element.WATER, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT)
        local dmg      = xi.mobskills.mobFinalAdjustments(magicDmg, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.WATER, xi.mobskills.shadowBehavior.IGNORE_SHADOWS)
        target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.WATER)
        return dmg
    end,

    -- modeled after Aegis Schism
    ["sweeping_gouge"] = function(target, mob, skill)
        local numhits  = 1
        local accmod   = 1
        local dmgmod   = 2
        local info     = xi.mobskills.mobPhysicalMove(mob, target, skill, numhits, accmod, dmgmod, xi.mobskills.physicalTpBonus.DMG_VARIES, 1, 2, 3)
        local dmg      = xi.mobskills.mobFinalAdjustments(info.dmg, mob, skill, target, xi.attackType.PHYSICAL, xi.damageType.BLUNT, info.hitslanded)
        local power    = 25
        local duration = 120

        xi.mobskills.mobPhysicalStatusEffectMove(mob, target, skill, xi.effect.DEFENSE_DOWN, power, 0, duration)
        target:takeDamage(dmg, mob, xi.attackType.PHYSICAL, xi.damageType.BLUNT)

        return dmg
    end,

    -- modeled after -
    ["swooping_frenzy"] = function(target, mob, skill)
        local power = math.random(225, 325)
        local numhits = 1
        local accmod = 1
        local dmgmod = xi.mobskills.mobBreathMove(mob, target, skill, 0.2, 1.25, xi.element.WIND, power)
        dmgmod = utils.conalDamageAdjustment(mob, target, skill, dmgmod, 0.9)

        local dmg = xi.mobskills.mobFinalAdjustments(dmgmod, mob, skill, target, xi.attackType.BREATH, xi.damageType.WIND, xi.mobskills.shadowBehavior.IGNORE_SHADOWS)
        local info = xi.mobskills.mobPhysicalMove(mob, target, skill, numhits, accmod, dmgmod, xi.mobskills.physicalTpBonus.DMG_VARIES, 1, 2, 3)

        xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.MAGIC_DEF_DOWN, 20, 0, 60)
        xi.mobskills.mobPhysicalStatusEffectMove(mob, target, skill, xi.effect.DEFENSE_DOWN, 30, 0, 60)
        target:takeDamage(dmg, mob, xi.attackType.BREATH, xi.damageType.WIND)
        return dmg
    end,

    -- modeled after - Dream Flower
    ["sylvan_slumber"] = function(target, mob, skill)
        local typeEffect = xi.effect.SLEEP_I

        skill:setMsg(xi.mobskills.mobStatusEffectMove(mob, target, typeEffect, 1, 0, math.random(20, 30)))

        return typeEffect
    end,

    -- modeled after Aegis Schism
    ["tail_thwack"] = function(target, mob, skill)
        local numhits = 2
        local accmod = 1
        local dmgmod = 1.5
        local info = xi.mobskills.mobPhysicalMove(mob, target, skill, numhits, accmod, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT)
        local dmg = xi.mobskills.mobFinalAdjustments(info.dmg, mob, skill, target, xi.attackType.PHYSICAL, xi.damageType.BLUNT, info.hitslanded)

        xi.mobskills.mobPhysicalStatusEffectMove(mob, target, skill, xi.effect.DEFENSE_DOWN, 30, 0, 60)

        target:takeDamage(dmg, mob, xi.attackType.PHYSICAL, xi.damageType.BLUNT)
        return dmg
    end,

    -- modeled after Condemnation
    ["tickling_tendrils"] = function(target, mob, skill)
        local numhits = 5
        local accmod = 1
        local dmgmod = 1
        local info = xi.mobskills.mobPhysicalMove(mob, target, skill, numhits, accmod, dmgmod, xi.mobskills.physicalTpBonus.DMG_VARIES, 1, 1.2, 1.5)
        local dmg = xi.mobskills.mobFinalAdjustments(info.dmg, mob, skill, target, xi.attackType.PHYSICAL, xi.damageType.SLASHING, info.hitslanded)
        local typeEffect = xi.effect.STUN

        xi.mobskills.mobPhysicalStatusEffectMove(mob, target, skill, typeEffect, 1, 0, math.random(1, 3))

        target:takeDamage(dmg, mob, xi.attackType.PHYSICAL, xi.damageType.SLASHING)
        return dmg
    end,

    -- modeled after Gravitic Horn
    ["tidal_guillotine"] = function(target, mob, skill)
    local currentHP = target:getHP()
    -- remove all by 5%
    local baseDamage = 0

    -- estimation based on "Throat Stab-like damage"
        if currentHP / target:getMaxHP() > 0.2 then
            baseDamage = currentHP * .50
        else
            baseDamage = currentHP
        end

        -- Because shell matters, but we don't want to calculate damage normally via xi.mobskills.mobMagicalMove since this is a % attack
        local damage = baseDamage * getElementalDamageReduction(target, xi.element.WATER)
        -- we still need final adjustments to handle stoneskin etc though
        damage = xi.mobskills.mobFinalAdjustments(damage, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.WATER, xi.mobskills.shadowBehavior.WIPE_SHADOWS)

        target:takeDamage(damage, mob, xi.attackType.MAGICAL, xi.damageType.WATER)
        return damage
    end,

    -- modeled after plague_breath
    ["tiiimbeeer"] = function(target, mob, skill)
        local numhits = 1
        local accmod = 10
        local dmgmod = 3
        local info = xi.mobskills.mobPhysicalMove(mob, target, skill, numhits, accmod, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT)
        local dmg = xi.mobskills.mobFinalAdjustments(info.dmg, mob, skill, target, xi.attackType.PHYSICAL, xi.damageType.BLUNT, info.hitslanded)

        target:takeDamage(dmg, mob, xi.attackType.PHYSICAL, xi.damageType.BLUNT)
        xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.BIND, 15, 0, 30)
        xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.CURSE_I, 25, 0, 20)
        return dmg
    end,

    -- modeled after Roar
    ["torpefying_charge"] = function(target, mob, skill)
        local typeEffect = xi.effect.PARALYSIS
        skill:setMsg(xi.mobskills.mobStatusEffectMove(mob, target, typeEffect, 35, 0, 25))

        return typeEffect
    end,

    -- modeled after flame_thrower
    ["tyrannical_blow"] = function(target, mob, skill)
        local typeEffect = xi.effect.PLAGUE
        xi.mobskills.mobPhysicalStatusEffectMove(mob, target, skill, typeEffect, 5, 3, 20)

        local dmgmod   = 1.5
        local magicDmg = xi.mobskills.mobMagicalMove(mob, target, skill, mob:getWeaponDmg() * 3, xi.element.FIRE, dmgmod, xi.mobskills.magicalTpBonus.MAB_BONUS, 1)
        local dmg      = xi.mobskills.mobFinalAdjustments(magicDmg, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.FIRE, xi.mobskills.shadowBehavior.IGNORE_SHADOWS)

        target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.FIRE)
        if target:hasStatusEffect(xi.effect.ELEMENTALRES_DOWN) then
            target:delStatusEffectSilent(xi.effect.ELEMENTALRES_DOWN)
        end

        return dmg
    end,

    -- modeled after cursed_sphere
    ["uproot"] = function(target, mob, skill)
        local dmgmod   = 3
        local magicDmg = xi.mobskills.mobMagicalMove(mob, target, skill, mob:getWeaponDmg() * 2.6, xi.element.LIGHT, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT)
        local dmg      = xi.mobskills.mobFinalAdjustments(magicDmg, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.LIGHT, xi.mobskills.shadowBehavior.IGNORE_SHADOWS)

        target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.LIGHT)

        return dmg
    end,

    -- modeled after nerve_gas
    ["vespine_hurricane"] = function(target, mob, skill)
        local power = math.random(225, 325)
        xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.MAGIC_DEF_DOWN, 20, 0, 60)
        xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.ATTACK_DOWN, 25, 0, 60)

        local dmgmod = xi.mobskills.mobBreathMove(mob, target, skill, 0.25, 2.5, xi.element.WIND, power)
        local dmg    = xi.mobskills.mobFinalAdjustments(dmgmod, mob, skill, target, xi.attackType.BREATH, xi.damageType.WIND, xi.mobskills.shadowBehavior.IGNORE_SHADOWS)

        target:takeDamage(dmg, mob, xi.attackType.BREATH, xi.damageType.WIND)

        return dmg
    end,

    -- modeled after -
    ["vile_belch"] = function(target, mob, skill)
        local dmgmod = .6
        local duration = math.random(15, 30)
        local magicDmg = xi.mobskills.mobMagicalMove(mob, target, skill, mob:getWeaponDmg() * 9, xi.element.WATER, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT, 1)
        local dmg      = xi.mobskills.mobFinalAdjustments(magicDmg, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.WATER, xi.mobskills.shadowBehavior.WIPE_SHADOWS)

        target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.WATER)

        xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.SILENCE, 1, 0, duration)
        xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.PLAGUE, 5, 3, duration)

        return dmg
    end,

    -- modeled after Corrosive Ooze
    ["viscid_spindrift"] = function(target, mob, skill)
        local typeEffectOne = xi.effect.ATTACK_DOWN
        local typeEffectTwo = xi.effect.MAGIC_ACC_DOWN
        local typeEffectThree = xi.effect.WEIGHT
        local duration = 30

        xi.mobskills.mobStatusEffectMove(mob, target, typeEffectOne, 15, 0, duration)
        xi.mobskills.mobStatusEffectMove(mob, target, typeEffectTwo, 15, 0, duration)
        xi.mobskills.mobStatusEffectMove(mob, target, typeEffectThree, 15, 0, duration)

        local dmgmod     = 1
        local baseDamage = mob:getWeaponDmg() * 4.2
        local magicDmg   = xi.mobskills.mobMagicalMove(mob, target, skill, baseDamage, xi.element.WATER, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT)
        local dmg        = xi.mobskills.mobFinalAdjustments(magicDmg, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.WATER, xi.mobskills.shadowBehavior.IGNORE_SHADOWS)
        target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.WATER)
        return dmg
    end,

    -- modeled after Dragon Breath
    ["volcanic_stasis"] = function(target, mob, skill)
        local power = math.random(225, 425)
        local numhits = 1
        local accmod = 1
        local dmgmod = xi.mobskills.mobBreathMove(mob, target, skill, 0.2, 1.25, xi.element.FIRE, power)
        dmgmod = utils.conalDamageAdjustment(mob, target, skill, dmgmod, 0.9)

        local dmg = xi.mobskills.mobFinalAdjustments(dmgmod, mob, skill, target, xi.attackType.BREATH, xi.damageType.FIRE, xi.mobskills.shadowBehavior.IGNORE_SHADOWS)
        local info = xi.mobskills.mobPhysicalMove(mob, target, skill, numhits, accmod, dmgmod, xi.mobskills.physicalTpBonus.DMG_VARIES, 1, 2, 3)
        local dispelled = math.random(2, 3)

        if info.hitslanded ~= 0 then
            for i = 1, dispelled do
                target:dispelStatusEffect()
            end
        end

        xi.mobskills.mobPhysicalStatusEffectMove(mob, target, skill, xi.effect.STUN, 1, 0, 3)
        target:takeDamage(dmg, mob, xi.attackType.BREATH, xi.damageType.FIRE)
        return dmg
    end,

    -- modeled after Boiling Blood
    ["zealous_snort"] = function(target, mob, skill)
        xi.mobskills.mobBuffMove(mob, xi.effect.HASTE, 2500, 0, 60)
        xi.mobskills.mobBuffMove(mob, xi.effect.MAGIC_DEF_BOOST, 30, 0, 60)
        xi.mobskills.mobBuffMove(mob, xi.effect.COUNTERSTANCE, 10, 0, 60)
        skill:setMsg(xi.msg.basic.NONE)
        return 0
    end,

    -- modeled after cyclone_wing
    ["atropine_spore"] = function(target, mob, skill)
        local dmgmod   = 1
        local magicDmg = xi.mobskills.mobMagicalMove(mob, target, skill, mob:getWeaponDmg() * 5, xi.element.DARK, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT)
        local dmg      = xi.mobskills.mobFinalAdjustments(magicDmg, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.DARK, xi.mobskills.shadowBehavior.WIPE_SHADOWS)
        target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.DARK)
        xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.SLEEP_I, 1, 0, math.random(15, 30))
        return dmg
    end,

    -- modeled after poison_pick
    ["night_stalker"] = function(target, mob, skill)
        local numhits = 1
        local accmod = 1
        local dmgmod = 1
        local info = xi.mobskills.mobPhysicalMove(mob, target, skill, numhits, accmod, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT)
        local dmg = xi.mobskills.mobFinalAdjustments(info.dmg, mob, skill, target, xi.attackType.PHYSICAL, xi.damageType.PIERCING, xi.mobskills.shadowBehavior.WIPE_SHADOWS)
        local typeEffect = xi.effect.BIO
        xi.mobskills.mobPhysicalStatusEffectMove(mob, target, skill, typeEffect, 15, 3, math.random(20, 40))
        target:takeDamage(dmg, mob, xi.attackType.PHYSICAL, xi.damageType.PIERCING)
        target:setTP(0)
        return dmg
    end,

    -- modeled after black cloud
    ["deracinator"] = function(target, mob, skill)
        local typeEffect = xi.effect.BLINDNESS
        xi.mobskills.mobStatusEffectMove(mob, target, typeEffect, 18, 0, math.random(10, 15))
        local dmgmod   = 1
        local magicDmg = xi.mobskills.mobMagicalMove(mob, target, skill, mob:getWeaponDmg() * 3, xi.element.DARK, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT)
        local dmg      = xi.mobskills.mobFinalAdjustments(magicDmg, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.DARK, xi.mobskills.shadowBehavior.WIPE_SHADOWS)
        target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.DARK)
        return dmg
    end,

    -- modeled after metallic_body
    ["full_bloom"] = function(target, mob, skill)
        skill:setMsg(xi.mobskills.mobBuffMove(mob, xi.effect.STONESKIN, math.random(1000, 2000), 0, 300))
        return xi.effect.STONESKIN
    end,
}

for skillName, skillFunc in pairs(skills) do
    local skillPath = string.format("xi.actions.mobskills.%s", skillName)
    xi.module.ensureTable(skillPath)

    if type(skillFunc) == "table" then
        m:addOverride(skillPath .. ".onMobWeaponSkill", skillFunc.onMobWeaponSkill)
        m:addOverride(skillPath .. ".onMobSkillCheck",  skillFunc.onMobSkillCheck)

    else
        m:addOverride(skillPath .. ".onMobWeaponSkill", skillFunc)
        m:addOverride(skillPath .. ".onMobSkillCheck", function(target, mob, skill)
            return 0
        end)
    end
end

return m
