-----------------------------------
-- Daily Quest : Secret Chests
-- Spawns Secret Treasure Chests in certain zones
-----------------------------------
require("modules/module_utils")
-----------------------------------
local m = Module:new("daily_quest_secretchests")

-- Handles the functionality of the "daily reset" at midnight
local handleMidnight = function(player)
    local questMidnight = player:getCharVar("[DQ]Midnight")
    local currentMidnight = getMidnight()

    -- handle first time quest midnight
    if questMidnight == 0 then
        player:setCharVar("[DQ]Midnight", currentMidnight)
        player:setCharVar("[DQ]Completed", 0)
        player:setCharVar("[DQ]Reset", 0)
        player:setCharVar("[DQ]Fishstix", 0)
        player:setCharVar("[DQ]Fishstix_Z", 0)
        player:setCharVar("[DQ]Murdoc", 0)
        player:setCharVar("[DQ]Murdoc_Z", 0)
        player:setCharVar("[DQ]Murdoc_MT", 0)
        player:setCharVar("[DQ]Murdoc_KA", 0)
        player:setCharVar("[DQ]Mistrix", 0)
        player:setCharVar("[DQ]Mistrix_I", 0)
        player:setCharVar("[DQ]Saltlik", 0)
        player:setCharVar("[DQ]Saltlik_Z", 0)
        player:setCharVar("[DQ]Saltlik_NM", 0)
        player:setCharVar("[DQ]Beetrix", 0)
        player:setCharVar("[DQ]Beetrix_Z", 0)
        player:setCharVar("[DQ]Beetrix_RE", 0)
    end
    
    -- handle midnight reset
    if currentMidnight ~= questMidnight then
        player:setCharVar("[DQ]Midnight", currentMidnight)
        player:setCharVar("[DQ]Completed", 0)
        player:setCharVar("[DQ]Reset", 0)
        player:setCharVar("[DQ]Fishstix", 0)
        player:setCharVar("[DQ]Fishstix_Z", 0)
        player:setCharVar("[DQ]Murdoc", 0)
        player:setCharVar("[DQ]Murdoc_Z", 0)
        player:setCharVar("[DQ]Murdoc_MT", 0)
        player:setCharVar("[DQ]Murdoc_KA", 0)
        player:setCharVar("[DQ]Mistrix", 0)
        player:setCharVar("[DQ]Mistrix_I", 0)
        player:setCharVar("[DQ]Saltlik", 0)
        player:setCharVar("[DQ]Saltlik_Z", 0)
        player:setCharVar("[DQ]Saltlik_NM", 0)
        player:setCharVar("[DQ]Beetrix", 0)
        player:setCharVar("[DQ]Beetrix_Z", 0)
        player:setCharVar("[DQ]Beetrix_RE", 0)
    end
end

-- look for the Secret Chest
local treasureCostumeID = 267

-- The table contains all the zones and locations (pos's) for the Secret Treasure Chests
local treasurePositions =
{
    -- Zone Num | Zone Name | Zone ID | POS Locations
    {1,"West_Ronfaure",                 100,{{-29,-60,219,87},{-178,-60,317,128},{-547.2,-59.6,517.5,158},{-483.5,-46.7,226.7,8},{-236,-40,63,243},{-294.65,-32.33,-26.1,132},{-454.77,-32.33,14.25,121},{-614.63,-24.57,-151.53,242},{-521.7,0,-438.05,166},{-289.07,0.5,-521.45,97},{-181.4,0,-501.3,98},{-68.55,-0.16,-538.55,193},{-50.54,-9.5,-398.48,0}}},
    {2,"East_Ronfaure",                 101,{{220.486,0,-538.182,190},{249.895,0,-538.190,190},{289.832,0,-501.681,60},{263.351,0,-501.572,60},{330.044,0,-538.601,190},{321.404,-60,522.386,61},{420.042,-65.732,445.202,99},{498.765,-60.038,469.305,192},{507.972,-60.011,458.204,1},{767.483,-61.362,400.100,130}}},
    {3,"South_Gustaberg",               107,{{-493.839,40,-482.177,202},{-423.172,43.698,-461.885,174},{-289.327,21.262,-382.687,252},{-264.201,18.452,-313.208,84},{-191.268,17.982,-427.840,128},{-123.347,18.781,-483.586,222},{70.422,-5.777,-463.857,98},{363.695,-1.236,-684.129,158},{520.142,-2.924,-736.791,189}}},
    {4,"North_Gustaberg",               106,{{-589.808,40,54.876,222},{-437.971,40,479.694,0},{506.035,0.301,428.598,5},{441.289,0,405.997,43},{320.726,-2.797,329.384,58},{200.299,0.055,324.101,94},{150.093,-5.715,336.141,83},{129.516,-2.763,399.964,115},{86.767,0.459,527.733,122},{-74.624,-0.077,599.272,4}}},
    {5,"West_Sarutabaruta",             115,{{-370.861,-22.244,216.441,252},{-411.797,-17.725,327.605,1},{-258.004,-17.250,660.441,254},{-189.890,-26.054,496.843,128},{-5.394,-12.484,308.276,64},{238.214,-9.900,40.014,0},{-1.329,0,-156.606,39},{-61.796,-6.163,-250.548,191},{-121.292,-4.941,-287.890,188},{104.838,-0.931,-203.319,122}}},
    {6,"East_Sarutabaruta",             116,{{233.289,-24.662,560.574,6},{-59.756,-37.250,734.799,63},{-273.952,-22.770,662.066,255},{286.569,-2.700,261.747,255},{446.820,-2.500,298.321,127},{378.862,-13.250,99.907,128},{446.889,9.343,-139.345,255},{485.318,9.500,-140.142,121},{-246.174,-3.735,-160.158,34},{-351.037,-3.057,-130.521,117}}},
    {7,"La_Theine_Plateau",             102,{{-266.886,4.334,291.993,114},{-441.370,6.356,229.318,66},{-449.020,-8.029,293.092,135},{-607.264,0.083,474.459,100},{-561.724,0,637.696,177},{-180.001,8.820,254.831,36},{338.781,19.104,-63.751,144},{434.970,24,22.074,198},{748.774,29.002,-16.079,242},{563.891,41.371,-427.724,124}}},
    {8,"Konschtat_Highlands",           108,{{563.063,30.777,635.960,154},{458.349,31.260,464.815,152},{233.449,24,300.122,187},{142.523,19.104,223.923,93},{402.982,-1.207,-3.363,154},{-233.059,16.361,199.887,7},{-328.557,16.044,195.746,124},{-705.982,2.818,103.857,237},{-263.467,-49.471,-466.454,206},{94.111,-69.003,-577.422,119}}},
    {9,"Tahrongi_Canyon",               117,{{361.894,-8.946,-87.874,160},{200.877,-24.986,-168.091,188},{-42.281,46.931,-672.194,19},{207.646,15.117,-680.856,118},{90.488,1.173,-109.851,59},{78.790,15.712,114.882,220},{176.975,35.150,262.554,63},{117.653,40,355.244,129},{450.495,46.388,495.988,78},{-152.077,47.044,641.737,129}}},
    {10,"Valkurm_Dunes",                103,{{93.458,-2.327,-112.212,110},{124.903,-7.349,92.950,214},{325.594,-8.250,76.057,153},{368.845,-0.533,-127.749,156},{-269.074,1.901,-158.253,231},{-361.166,0.303,-12.603,10},{-306.172,-11.030,252.209,93},{-468.335,-18.286,366.880,82},{-628.852,-10.691,211.435,95},{-797.904,-6.050,51.110,220}}},
    {11,"Jugner_Forest",                104,{{243.2674,0.0000,-1.9098,162},{332.7855,-1.3893,-218.1996,152},{59.7847,0.5666,-30.2552,52},{-135.6859,0.7641,-160.2753,213},{-122.1466,-8.0000,-522.7593,251},{-62.4835,-20.8025,-659.9227,235},{-20.8877,-4.0700,302.5906,212},{92.4609,0.4849,475.6379,44},{262.9796,0.8255,555.8021,34},{562.7896,0.0971,325.9646,106}}},
    {12,"Batallia_Downs",               105,{{-684.6698,-12.2000,164.7846,30},{-516.8535,-4.2000,-38.3124,98},{-236.4650,-20.2000,-76.6095,99},{-197.8350,-4.2000,38.1056,161},{-61.5022,0.9237,439.5493,7},{-15.2355,3.8000,295.1584,31},{64.4709,-14.5332,140.3338,129},{195.0482,11.8000,-44.7756,226},{338.6655,3.3601,63.3932,149},{145.3150,11.8000,-384.2086,33}}},
    {13,"Pashhow_Marshlands",           109,{{534.9106,24.4139,693.1660,193},{470.0331,24.6623,412.1792,165},{269.0648,25.0000,415.1863,38},{53.6186,24.3043,365.3375,53},{208.8063,25.0000,148.1856,91},{458.2511,24.5071,-10.8369,136},{295.6585,25.2500,-95.0222,52},{243.6703,24.9892,-296.4225,195},{-35.0967,25.0000,-147.0363,84},{-416.9833,24.0898,-228.9177,61}}},
    {14,"Rolanberry_Fields",            110,{{-342.0245,-23.7784,-670.3920,252},{-395.1242,-8.5000,-443.1851,232},{-432.5514,-15.5754,-316.0685,6},{-632.1749,-23.6895,-271.2613,189},{-436.2982,-7.7233,17.4652,230},{-481.7202,0.0000,157.5170,251},{-202.3049,8.0000,362.4264,225},{314.3024,16.0837,321.3084,59},{520.2621,-8.0000,42.1197,85},{242.8125,-31.0329,-259.3657,131}}},
    {15,"Sauromugue_Champaign",         120,{{-129.1338,-25.1600,-400.0967,245},{-117.8947,16.2659,30.6597,61},{-268.8352,8.2690,54.3324,216},{-243.4174,8.0000,243.7835,130},{-205.8423,15.8831,283.7137,115},{-239.8076,15.0635,447.8749,87},{202.6848,31.2921,193.5551,54},{353.3181,23.8305,-3.2562,100},{366.5192,14.9162,-215.2834,184},{421.7435,16.3432,-149.5891,54}}},
    {16,"Beaucedine_Glacier",           111,{{-228.8481,-80.8019,258.8343,167},{-24.6721,-59.6147,-76.0180,63},{-176.8972,-40.2500,-219.7463,255},{99.9957,-20.2500,136.7716,65},{59.2686,-0.2500,-335.2778,191},{-87.6468,0.0165,-369.4749,222},{265.1904,-0.2500,-19.8082,2},{154.1081,-0.0958,120.1986,4},{250.4337,-0.2000,208.6171,101},{271.8987,20.0449,527.1563,89}}},
    {17,"Xarcabard",                    112,{{-139.5488,-21.3258,129.0947,62},{-103.9603,-39.8249,41.4914,155},{-255.0679,-14.9442,-147.0284,187},{-292.9190,-22.7128,147.0915,64},{-411.4244,-44.0000,32.8717,245},{119.3985,-28.7700,-123.1243,156},{57.2033,-28.5111,-193.1673,68},{-23.4988,-24.2179,-496.3124,204},{195.7353,-23.9879,-202.0951,111},{577.5774,-0.4375,-14.1310,198}}},
    {18,"Cape_Teriggan",                113,{{254.8981,2.9751,56.3916,66},{146.7516,2.3398,-195.8009,151},{-188.2556,8.0516,-69.4246,253},{-187.9107,1.5278,-303.2005,233},{-176.0762,3.0037,54.7913,9},{-275.5800,-15.7296,139.2300,15},{116.6077,0.0000,285.1415,57},{176.8529,2.9547,145.2006,134},{16.4720,-5.0054,105.3912,132}}},
    {19,"Eastern_Altepa_Desert",        114,{{225.2773,-11.3020,260.1861,196},{45.0305,-7.9499,398.5899,16},{-55.3194,3.9492,226.3541,134},{-151.4631,-7.5547,345.3339,49},{-307.2764,0.4666,116.3732,97},{-170.6364,8.3949,-170.7187,218},{-258.1786,8.4535,-252.7911,246},{25.9434,10.1992,-264.3477,147},{474.2984,-0.6997,-60.4492,147},{499.9066,2.1992,148.9513,59}}},
    {20,"Western_Altepa_Desert",        125,{{-90.0854,-2.4527,449.0002,36},{146.2338,0.5714,243.5722,186},{-151.8872,-16.7349,20.0748,253},{-145.5451,-15.0902,-12.2120,23},{-212.1482,-14.8574,-15.1000,81},{-332.7083,0.4771,-114.4276,143},{-275.5997,-4.4492,63.7249,104},{-462.1591,-0.0612,261.0957,87},{-201.1693,-2.3585,373.1492,61},{-215.4306,-11.7883,102.5631,172}}},
    {21,"Meriphataud_Mountains",        119,{{728.4697,-33.0483,40.2009,129},{688.9405,-25.1270,161.2462,141},{603.6194,-32.0000,279.9139,87},{121.6685,-8.9222,607.8154,44},{-285.2278,15.6881,600.7204,7},{-289.8122,16.3845,417.9721,100},{-528.8677,-9.1157,198.4571,252},{719.4794,-32.9382,-87.8839,193},{354.2725,-8.0052,-118.2133,172},{202.5027,0.0000,-522.2034,188}}},
    {22,"Buburimu_Peninsula",           118,{{-272.7763,18.2141,-325.9178,26},{33.2192,-0.0064,-196.1049,40},{81.4943,0.0907,-194.1635,155},{357.2985,0.0000,-240.4695,208},{442.1010,0.0000,-318.7705,194},{445.5502,18.2740,193.4318,37},{194.4682,-16.8663,245.2752,25},{-38.0914,-24.0000,279.7069,55},{-345.3481,-24.5464,50.8134,16},{-476.5060,-32.2202,47.6595,196}}},
    {23,"The_Sanctuary_of_ZiTah",       121,{{465.6945,-0.0102,-566.2515,4},{489.0155,0.1602,-278.6891,132},{606.3391,0.4293,-128.9220,77},{337.1624,-0.7646,-140.3643,169},{132.8560,-0.7000,-141.9269,151},{-35.6515,0.2126,-150.7413,193},{-432.3432,0.1817,121.5100,99},{-370.2611,-0.0354,290.9156,145},{-340.1540,0.4012,418.0867,73},{-284.5505,0.0264,523.3145,89}}},
    {24,"RoMaeve",                      122,{{-0.0487,-29.3984,82.5825,192},{-0.2824,-29.3241,60.3875,56},{182.3899,-5.0000,11.6407,96},{221.0516,-6.5400,-97.3868,186},{101.3497,-5.2000,4.1336,84},{161.1452,-6.0000,-114.5502,191},{-116.8099,-4.0708,-114.8103,223},{-95.5379,-1.0000,-83.1229,214},{-147.9766,0.9016,-108.0093,196},{-103.0063,-5.2000,2.6364,36},{-66.1635,-5.2000,23.8956,48}}},
    {25,"Yuhtunga_Jungle",              123,{{-223.5197,-0.1635,498.5134,150},{-261.2157,5.4071,454.5269,253},{-74.6055,-0.2211,445.9792,102},{-308.9467,2.6639,223.0647,1},{-417.5992,8.7174,213.2710,217},{-373.5449,13.0000,-96.8053,158},{-301.0068,4.0596,-102.7879,194},{-417.5006,10.6672,-265.7918,178},{-649.7037,-0.0129,44.0973,28},{-609.2664,0.0000,-121.4595,247}}},
    {26,"Yhoator_Jungle",               124,{{250.3906,0.1698,-532.5775,184},{277.1335,0,-399.6764,192},{215.8089,0.0787,32.6307,194},{91.3226,0,196.0168,150},{-101.8786,-1.4944,52.0368,213},{-253.4885,6.6471,28.4988,93},{-498.4855,8.8406,-188.6802,222},{-459.4060,1.5500,-331.7365,164},{-256.4169,0.0316,-458.8336,195},{1.6,0.1,-347.2178,128}}},
    {27,"Qufim_Island",                 126,{{-267.7306,-19.5779,402.3297,240},{-340.6172,-12.1026,539.2167,9},{-130.7917,-21.4513,413.4923,6},{-111.9717,-19.6915,229.8066,198},{45.2582,-20.0641,283.0483,233},{181.1417,-22.3171,135.8035,221},{167.4396,-21.9135,28.6876,167},{93.4568,-21.5034,-51.1449,32},{-35.4559,-21.7744,-53.7631,110},{173.5320,-21.9593,-28.5420,65},{96.5474,17.9617,-263.3933,19}}},
    {28,"Temple_of_Uggalepih",          159,{{76.4836,0,-39.3,191},{66.4732,1.4603,-60.2844,78},{-210.9982,0,-13.6968,105},{-132.7098,0,-67.8487,64},{-20.5119,0.5,-82.6116,0},{-27.2094,-24.9999,37.7444,96},{-27.4638,-17,-147.8486,65},{267.8488,0,112.7122,1},{347.3,-0.0009,222.8087,127},{425.5971,5.2471,223.3,64}}},
    {29,"Valley_of_Sorrows",            128,{{141.0560,-5.8524,-58.5018,92},{101.4715,-0.3392,-11.4836,199},{-57.2116,-5.0907,55.0726,5},{-104.8795,-5.0855,17.0616,80},{-176.1701,-11.4837,13.2509,120},{-130.4733,-2.4491,-25.5167,15},{-18.7014,-1.5429,-55.3335,155},{36.4795,-0.6639,49.9907,46},{106.1917,-3.9239,-49.5341,216},{99.5238,-9.0230,-103.0284,197}}},
    {30,"Bibiki_Bay",                     4,{{649.2197,-21.1735,838.9446,126},{569.2031,-19.9828,753.0187,119},{477.8183,-5,777.5853,26},{454.0760,-3.0024,729.1177,2},{241.0836,-37.1751,849.2199,63},{146.7451,-37.9250,613.5005,177},{273.1945,-20.7964,602.9559,54},{337.7320,-22.3767,330.3999,55},{335.1253,-16.1852,234.6558,22},{65.3972,-28.7474,221.8518,83},{266.7132,-0.8388,180.6371,110}}},
    {31,"Carpenters_Landing",             2,{{94.1544,0,-790.9814,23},{141.2996,-8.0359,-698.9128,21},{34.6015,-6.5839,-557.3453,146},{121.0843,-1.4081,-383.1139,157},{214.2950,-2.1647,-514.6212,2},{-195.6206,-15.2777,-566.9509,74},{-132.6079,-6.6585,-451.9542,205},{-401.6357,0,-288.0172,118},{-246.4470,-10.4654,-228.2930,45},{-225.8413,-5.4578,124.1906,210}}},
    {32,"Uleguerand_Range",               5,{{180.7980,-1.6623,-266.3570,224},{486.8345,-5.7689,-170.5013,183},{597.3609,-35.7136,110.2478,217},{378.8505,-69.6670,254.3159,187},{194.3984,-116.0813,401.5267,105},{-349.3824,-157.3457,373.4465,161},{-244.6164,-183.5350,450.3989,164},{-487.6442,-21.8272,-90.8194,192},{-610.6097,-42.0747,33.0965,187},{-124.5585,-40,-297.4514,233}}},
    {33,"Attohwa_Chasm",                  7,{{-476.7557,-5.3073,329.1645,76},{-395.6605,-4.3026,233.6366,25},{-491.1745,-4.8206,93.5350,51},{-313.9382,-4,-115.1834,35},{-241.9957,4,-121.9367,63},{150.8976,10.7240,-276.7079,17},{300.7929,20,-220.9313,107},{215.1473,19.6599,101.1930,13},{405.7065,20.0584,127.6551,223},{475.3159,19.9023,-2.4294,111},{507.9641,19.6712,-190.9994,140},{384.6779,19.6660,-221.9128,133}}},
    {34,"Oldton_Movalpolos",             11,{{-10.4422,7.9728,65.6544,89},{8.0447,8,-50.4424,17},{-75.3075,20,-88.0158,57},{-221.6054,8,-28.8232,60},{-263.2505,-0.0062,148.9118,0},{-114.7858,22.8342,-100.4284,128},{-154.5961,8,-252.4370,27},{-229.2527,11.7840,-267.1378,190},{73.0363,16,-107.9818,128},{191.3546,20,-69.1934,191}}},
    {35,"Newton_Movalpolos",             12,{{341.8169,26.0657,0.3749,254},{228.6841,16,33.2716,90},{-64.9006,12.7273,23.8257,127},{-152.3001,16.0007,-94.8652,191},{-307.0733,11.9728,-187.5821,64},{18.4422,16.7868,226.8321,182},{-183.1646,16,193.1616,63},{-96.7979,16,43.7363,127},{-23.3782,16.8373,15.8695,192},{51.1889,16,-191.3059,197}}},
    {36,"Wajaom_Woodlands",              51,{{712.7916,-15.5000,223.5268,1},{387.0656,-27.6859,30.9463,48},{108.7740,-16.6048,-182.4820,105},{-68.8220,-15.7500,-563.3460,67},{-442.4357,-15.9362,-634.9500,127},{-746.1202,-12.1665,-504.9829,23},{-580.4454,-18.3097,-186.8004,14},{-776.5496,-23.5000,125.2074,63},{-444.4756,-28.2676,427.5665,25},{-336.7426,-31.5000,676.4467,185},{197.0583,-28.2500,252.7048,74}}},
    {37,"Bhaflau_Thickets",              52,{{-64.0502,-18.4411,-630.1198,190},{-486.6855,-24.4467,-50.5360,62},{-595.5871,-3.5590,19.1493,71},{252.1351,-12.5859,167.6621,58},{583.6663,-7.8957,127.3840,62},{291.3737,-28.4495,509.0387,116},{105.9162,-35.8753,628.0790,179},{-46.6950,-36.4469,450.5360,194},{144.7336,-16.9880,367.9151,46},{-34.9598,-23.5000,136.5606,126}}},
    {38,"Arrapago_Reef",                 54,{{-469.6715,-3.5444,-495.3701,167},{-210.2438,-3.5320,-464.6281,24},{-74.5344,-7.9204,-374.6465,5},{-103.2985,-4.2688,-182.9001,114},{55.7160,-16.4418,-87.7795,247},{52.6403,-8.6325,180.5163,239},{-74.5766,-10.0483,205.4029,215},{-128.1362,-10,440.5055,95},{66.3453,-9.1715,467.1918,163},{152.2564,-7.7257,534.8816,10},{219.0674,-3.5022,267.1868,137},{404.8217,-10.0887,34.0573,248},{236.1203,-8.9707,351.3483,70},{542.7513,-13.9328,244.9393,163}}},
    {39,"Mount_Zhayolm",                 61,{{-547.6975,-14.1605,-215.0474,214},{-701.5394,-9.9064,-108.1099,21},{-560.7676,-13.6528,308.7409,199},{-295.0697,-16.1663,212.3312,225},{-27.7815,-16.1420,134.9503,28},{95.2751,-18.1956,149.6865,2},{245.2578,-32,33.7430,200},{379.5495,-32,71.2807,124},{663.1000,-27,333.6458,0},{907.7633,-16.1523,335.0270,70},{768.7491,-14.2841,12.2236,78},{427.7138,-16.1565,-224.9781,94},{103.7725,-16.1898,-100.6816,78}}},
    {40,"Halvung",                       62,{{205.6580,-6.0681,150.5163,199},{56.7985,-13.6049,261.3592,210},{-39.6444,9.7610,307.0240,249},{346.8824,-0.1725,308.6879,87},{429.6626,-0.2196,107.3776,97},{114.3881,13.9184,49.5346,77},{64.8308,-0.4264,-247.3707,79},{-30.8628,9.8143,-273.1687,234},{15.0121,7.8585,-395.0004,3},{-221.6034,19.7500,-168.6798,64},{-334.8384,19.7086,131.6238,192}}},
    {41,"Mamook",                        65,{{-153.4018,14.4886,-141.5767,93},{-237.2765,14.7534,-84.7889,4},{-131.0357,10.0441,-107.3815,203},{126.8682,-4.0122,-61.1005,90},{73.4568,14.5539,-258.1375,220},{261.2603,16.4031,-180.4453,92},{345.0163,-7.6214,-249.7541,144},{286.2139,11.0540,-420.1168,126},{22.1100,18.1843,-405.7432,182},{-219.0995,19.4032,-421.5558,217}}},
    {42,"Aydeewa_Subterrane",            68,{{336.7431,35.3734,-10.7546,8},{264.5390,33.0990,-178.7696,148},{95.1916,33.1860,-178.0741,248},{85.8564,33.1017,-219.4400,119},{-145.6629,12.3779,-499.4544,240},{-101.1248,8.6465,-247.7591,19},{-414.9314,13.7228,-453.4945,249},{-389.2336,14.2274,-307.5736,99},{-349.6526,7.9261,-218.1423,169},{-324.4470,-7.4380,-246.5837,90},{-326.9941,36.6386,-132.2034,86}}},
    {43,"Alzadaal_Undersea_Ruins",       72,{{83.6345,0,157.3002,62},{2.6999,-4,43.5929,255},{-196.3704,-8,-37.2999,192},{-57.8000,-4.4000,-142.0534,1},{482.6999,0,443.5392,255},{682.7003,0,436.2940,1},{337.7999,-0.4000,617.8787,127},{517.3001,0,-163.6280,127},{402.7001,-0.4000,-573.2168,0},{-19.9723,-4.4000,235.2881,65}}},
    {44,"Caedarva_Mire",                 79,{{172.7489,-4.6598,-750.5190,171},{248.7499,-4.6782,-648.2476,55},{173.0958,-12.6619,-430.3198,175},{307.7208,-15.8634,-325.7191,68},{546.1207,-20.3160,-314.2608,122},{509.2331,-24.7533,-58.8106,217},{475.89,-31.69,73.5,100},{179.4053,-17.0561,-48.6642,66},{125.6690,-7.8389,-186.9813,244},{-292.3069,4.2908,-448.6812,54},{-406.9695,8.1837,-558.8198,198},{-306.1786,-4.2500,-747.4673,172},{-452.2873,-7.7089,-88.6871,52},{-632.0689,10.3400,-189.9703,231},}},
    {45,"Yughott_Grotto",               142,{{406.8389,-40.0621,153.7282,204},{345.8037,-40.3372,188.8921,138},{422.7217,-40.0391,67.4153,246},{350.7582,-40.3536,85.7197,69},{313.6848,-39.7874,154.4831,134},{313.6602,-23.7796,165.6070,231},{336.9407,-23.9687,252.1086,127},{110.4359,-12.8959,109.9284,147},{-14.2609,-0.3245,-61.5101,67},{-114.3103,0.1478,-29.8941,131},{-204.5477,-0.9373,-118.8511,179}}},
    {46,"Fort_Ghelsba",                 141,{{184.2812,-86.3594,17.3266,60},{126.6502,-60,-20.9796,39},{8.7021,-48,0.8855,99},{151.9822,-32.0603,172.3534,215},{-67.7530,-24,127.8998,126},{-21.2281,-20,-119.4283,64},{-21.1648,-28,-60.8699,112},{21.7144,-52,-79.5667,84},{143.4167,-45.5840,-114.4458,179},{-67.7130,-24,8.0813,127}}},
    {47,"Palborough_Mines",             143,{{90.7779,-32,-69.3000,192},{27.2804,-32.3231,-91.9886,106},{20.7538,-31.8550,81.0149,180},{111.7792,-32,58.7041,190},{266.6291,-32.2355,188.1947,88},{251.9413,-32.3306,-52.7297,39},{211.5083,-32.1733,-54.0068,24},{176.8038,-36.4081,-59.6943,215},{287.1752,-16.1999,104.2349,236},{259.5063,-16.3441,230.3738,62},{-46.5366,-15.5103,219.9616,190},{200.9813,-0.6052,97.6505,173},{167.2410,-15.2185,30.7395,19}}},
    {48,"Giddeus",                      145,{{-254.1483,-2.3445,-267.5351,180},{-146.6053,0.8244,-225.4620,99},{-84.3711,0.8568,-146.0622,126},{-104.6367,0,162.0070,134},{-174.3399,5,336.4589,41},{-58.2249,3.8455,312.9622,24},{-56.8746,0.6550,177.2354,25},{-146.9191,16.7600,51.4309,231},{-69.0319,16.7477,93.2061,222},{62.5438,0.9736,-224.1075,67},{224.8490,-3.0182,-287.7898,92},{-8.4942,0.4513,-425.0740,68}}},
    {49,"Beadeaux",                     147,{{371.7138,23.2631,49.5229,218},{380.0883,23.8897,146.8442,190},{186.8813,39.3319,29.0127,88},{-214.1564,23.7232,90.9070,160},{-227.2785,-2.8660,138.4095,171},{-246.3223,-3.0228,56.3356,128},{-281.4202,-3.2500,-242.1554,56},{-39.0060,-3.2500,-79.3917,75},{23.3425,-2.9741,81.6847,193},{283.0561,-3.2500,118.1628,23},{58.0839,1,4.2436,183},{-53.7995,0.8992,-185.2127,96}}},
    {50,"Davoi",                        149,{{309.6557,0.7500,-27.2965,172},{336.8633,-0.3127,-241.4209,243},{142.8628,2.8092,-217.0146,97},{97.2068,-5.1509,-163.2906,78},{-28.6921,4,-240.6752,21},{-152.3295,3.9513,-226.2940,126},{-223.4417,2.8479,-297.3326,84},{-272.2968,3.7411,-61.2071,17},{-227.6305,-0.2060,61.7344,16},{-133.5475,4.0493,22.3536,146},{170.0060,1.3697,-27.8083,166},{309.6668,0.7500,-27.3666,145}}},
    {51,"Monastic_Cavern",              150,{{0.1293,-0.1618,-301.1267,113},{-33.1878,-0.5411,-255.7653,59},{-67.6115,-0.8801,-187.8190,7},{-26.5311,-0.2247,-132.7375,46},{-19.3517,-0.2403,-222.8974,248},{20.4176,-0.7881,-140.0915,127},{23.5158,-0.4103,-91.1282,95},{65.8044,-0.1612,-143.8335,120},{101.7536,-0.0767,-105.8807,145},{110.7024,-1.7746,-137.7667,123}}},
    {52,"Castle_Oztroja",               151,{{-180.5632,24.2439,-98.4342,130},{-165.1574,-16.2884,196.4935,47},{-148.8153,-15.9350,0.6963,194},{-52.0476,-39.7822,-51.2533,102},{-139.9038,-71.7500,-67.8839,66},{-100.9158,-62.9662,50.6714,66},{-100.1979,-72.0000,91.4760,195},{112.6917,-0.0999,-176.3323,126},{-272.8281,-0.3059,101.7105,255},{19.8447,40.2500,-34.7070,64}}},
    {53,"The_Boyahda_Tree",             153,{{-165.1780,5.5051,144.8183,64},{-170.8430,4.9967,145.6296,69},{-141.7045,7.8584,31.0328,213},{-135.5213,6.7297,-139.4276,144},{-206.9850,8.9036,-280.5123,120},{31.1401,-21.3442,-59.4019,30},{-106.9478,6.4834,107.3291,253},{11.0126,6.5098,98.1216,114},{181.3377,8.8697,45.6626,63},{348.5599,7.7166,12.8638,140},{295.3991,2.3090,55.4167,155}}},
    {54,"Lower_Delkfutts_Tower",        184,{{360.4221,0.5591,-44.2391,189},{399.6852,-31.4998,85.1239,126},{466.0039,-31.9655,-72.7357,176},{459.9390,-16.0000,-42.9644,66},{527.6997,0.0277,12.7875,235},{359.4749,0.5758,82.4810,70},{459.7217,-16.0000,-26.2430,188},{348.4902,-16.0276,82.9238,197},{459.7663,0.0000,63.6653,65},{367.9029,0.0000,99.0109,255}}},
    {55,"Middle_Delkfutts_Tower",       157,{{-54.5295,-48.0084,-42.0423,234},{100.2628,-48.0000,-4.6934,64},{-17.3277,-47.9863,55.3433,209},{38.4057,-72.0000,-60.0457,248},{77.7654,-63.9844,91.1187,111},{-40.7980,-80.0443,-52.0305,213},{82.1201,-80.0062,-55.0528,174},{-482.4958,-96.0112,-54.1921,205},{-404.6997,-96.0000,102.4623,101},{-481.4698,-111.4242,-36.8426,47},{-356.2247,-111.4242,80.5308,123}}},
    {56,"Upper_Delkfutts_Tower",        158,{{-258.3428,-176.0000,10.1438,149},{-228.2905,-176.0278,81.5794,183},{-301.8639,-175.4242,5.7690,183},{-240.6325,-143.4242,-40.1424,235},{-228.9368,-175.9982,-43.5653,102},{-276.4350,-144.0115,-14.6419,184},{-361.2282,-143.4242,-38.9347,147},{-357.2389,-160.0281,-51.4814,237},{-362.0944,-176.0080,-54.6272,211},{-324.1459,-159.4351,22.6793,220}}},
    {57,"Den_of_Rancor",                160,{{114.0417,36.1652,-81.8869,255},{95.0703,26.6905,-181.4833,215},{210.8864,35.9670,-280.4506,124},{39.6902,37.0000,-138.2990,175},{39.6872,36.0000,-39.3037,176},{-90.4879,45.2015,20.4406,1},{-26.6238,37.0000,-359.8845,126},{37.9955,27.2611,-299.4645,125},{-136.9945,5.9957,-170.6702,128},{-159.0517,16.0000,-119.7278,156}}},
    {58,"Castle_Zvahl_Baileys",         161,{{-129.0887,-7.9835,129.0698,162},{-59.7772,0.2904,9.1114,65},{-102.4891,18.9490,8.1501,0},{89.4828,-8.0000,-129.0905,29},{72.0743,-8.0000,170.0028,193},{185.6606,-24.0526,107.0430,130},{100.8312,-20.0587,-72.0091,131},{19.6689,-20.0000,60.4308,254},{-152.3969,-20.0000,-112.9670,195},{-59.9118,3.9832,175.7226,189}}},
    {59,"Castle_Zvahl_Keep",            162,{{-553.7137,-70.1000,54.9083,193},{-85.6022,-15.3845,-105.4055,62},{-94.4375,-15.4000,68.6692,1},{-310.7035,-52.0000,23.7316,66},{-289.8198,-52.0000,-32.3111,63},{-179.5156,-43.9703,-22.2805,192},{-59.4031,0.0759,-23.0987,67},{-90.0299,0.0000,-68.1695,193},{-30.0002,0.6000,-98.4989,190},{-32.9832,0.6000,-150.1409,3}}},
    {60,"Ranguemont_Pass",              166,{{298.3195,-67.1551,262.5242,68},{48.4201,-28.0344,110.6770,45},{-1.7892,-36.0000,161.7355,157},{-211.9483,-36.0171,79.6728,1},{-280.0272,-46.0000,198.7241,27},{-119.1669,-6.1961,-92.6281,188},{-157.2923,3.0000,-228.7205,186},{-177.1718,4.0000,-163.3712,64},{-307.5015,3.0193,-155.6370,20},{-251.9046,5.5000,-180.0350,127}}},
    {61,"Bostaunieux_Oubliette",        167,{{131.8818,-24.6637,72.2520,127},{100.9223,-24.0509,-58.0408,190},{112.0071,-24.6673,-12.0697,189},{46.2103,-24.6636,7.7375,1},{-167.1700,-0.0488,-96.8668,127},{-62.8173,16.0484,-149.1987,255},{-95.2951,16.0000,-302.7074,131},{60.3325,16.0000,-224.5182,189},{101.4095,0.0740,-271.5230,99},{-22.5037,-0.1951,-168.1994,253}}},
    {62,"Toraimarai_Canal",             169,{{-321.6191,24.0000,60.1778,1},{-319.9644,18.0009,-19.9785,190},{-320.5796,21.9085,-20.0826,128},{-134.9776,20.5000,-68.0909,190},{-60.0885,16.0003,196.4886,63},{100.0535,17.0000,-260.4910,192},{254.0135,20.5000,-12.5141,63},{180.0172,10.0020,30.6727,62},{60.7144,22.5000,145.4103,194},{93.9743,21.5000,-53.9583,159}}},
    {63,"Zeruhn_Mines",                 172,{{-56.9556,-0.9790,62.2201,65},{-15.8248,0.0000,46.2322,253},{16.6039,8.0062,-55.5079,89},{61.2164,8.5595,-145.7456,55},{58.4656,8.8766,-259.8273,193},{140.0030,7.1299,-215.7125,189},{-85.7783,8.3685,-216.7150,64},{-62.2976,8.5820,-335.3267,216},{-60.8201,8.1071,-278.6888,19},{14.8747,8.0079,-295.9182,92}}},
    {64,"Korroloka_Tunnel",             173,{{-470.2575,-9.7612,55.9364,56},{-252.9641,-4.7258,-59.5941,139},{-376.6563,-4.9093,68.7422,75},{-364.0408,-10.0000,280.2376,30},{-419.1556,-12.2225,310.5780,107},{55.5400,1.0527,-26.9132,41},{-144.9778,-0.5000,-80.6097,144},{-254.6197,-6.5000,79.9378,1},{224.6727,-5.4708,60.0278,107},{139.8875,-4.8000,79.6882,61}}},
    {65,"Kuftal_Tunnel",                174,{{103.9535,-11.3440,209.8927,131},{133.6894,-11.7386,106.7736,159},{160.0658,-8.7500,-60.2572,136},{-26.5609,-10.7787,-127.2607,252},{36.3045,30.0000,-211.5494,222},{156.8821,21.1611,-139.6120,134},{-19.1876,21.2500,80.2771,57},{84.8634,29.7636,106.4919,210},{-79.9258,0.0000,-2.5086,120},{-20.3947,-8.7500,-159.6221,63}}},
    {66,"The_Eldieme_Necropolis",       195,{{-514.9988,-8.0000,493.1587,191},{-344.4348,-0.0273,334.1879,163},{50.0650,-15.0457,306.2322,160},{62.2473,-0.2500,21.5309,169},{140.0904,-15.9140,302.6079,30},{414.2991,0.0000,120.5832,7},{186.9919,-0.0330,-90.3276,157},{345.4731,-32.0000,-130.1238,190},{39.6398,-28.0000,-0.5984,227},{235.6163,-34.0000,20.1628,255}}},
    {67,"Sea_Serpent_Grotto",           176,{{-49.7852,9.3371,300.4230,252},{-181.3981,26.9500,240.5701,64},{104.603,11,-39.73,179},{412.2541,8.9767,-59.8945,122},{333.0956,18.7209,19.2820,134},{260.4375,28.7174,173.0341,69},{-60.4687,18.8213,92.7341,58},{-353.4253,15.4750,-104.0196,253},{-126.6788,47.7736,-337.0138,127},{-254.1207,46.9878,-329.9707,21}}},
    {68,"Dangruf_Wadi",                 191,{{-26.3513,3.4840,-256.6883,176},{-216.5136,3.9698,-104.5177,70},{-511.8706,-4.2490,-96.7599,10},{-403.9844,3.9615,-44.8214,78},{-424.3855,4.0272,135.4528,181},{-419.6935,3.9115,335.9777,192},{-310.7466,3.9808,186.2562,181},{-73.1989,4.0207,387.4006,220},{-223.0821,3.7764,576.4811,200},{-63.0291,3.9234,465.8748,147}}},
    {69,"Inner_Horutoto_Ruins",         192,{{-306.9073,0.0000,171.6782,190},{-223.7273,-0.0063,99.7954,126},{468.8547,0.0000,99.6906,130},{337.5092,-0.0046,-19.8553,255},{-178.0458,0.0000,-221.8702,127},{168.2725,0.5000,59.8630,1},{-180.2966,-4.2500,-22.5415,189},{-256.7086,0.0001,-102.9122,225},{-0.5791,0.7422,14.8963,180},{380.4043,0.0000,38.9694,63}}},
    {70,"Outer_Horutoto_Ruins",         194,{{294.5619,-0.0673,740.0033,255},{-371.2507,0.0000,733.0035,127},{492.7487,0.0000,-588.6573,192},{-507.5537,0.0000,-628.9791,191},{-360.0031,0.0000,-616.9225,64},{-586.8853,0.4000,740.2007,130},{-414.1780,-2.2456,561.6266,195},{-291.5462,0.0000,-667.3172,128},{571.4915,0.0000,-653.2990,254},{500.0185,0.0141,775.6358,64}}},
    {71,"Ordelles_Caves",               193,{{-100.3655,8.5000,517.8835,193},{-5.3012,32.3617,271.6234,29},{-88.9702,31.9921,210.9054,32},{48.8327,31.9945,-11.2427,161},{-307.0069,28.4000,-100.2006,130},{-20.1343,27.5993,-46.8776,146},{-127.3890,0.0008,9.7468,52},{-88.4063,-28.1316,-288.8236,49},{-174.5000,-0.5000,279.9546,6},{29.2927,11.9939,470.8494,225}}},
    {72,"Gusgen_Mines",                 196,{{-65.9622,-62.0249,-225.4178,222},{-127.1710,-59.8031,-104.6204,252},{162.0873,-39.7500,-19.0666,127},{220.2289,-39.6000,267.4822,194},{-69.3456,-39.0000,240.7841,254},{105.8540,-19.6532,438.2143,252},{-78.2281,-27.0221,435.9902,105},{-116.5643,-38.4798,216.2243,87},{-139.8406,-27.5472,332.5792,189},{19.6500,-40.1000,192.3982,65}}},
    {73,"Crawlers_Nest",                197,{{200.9444,-32.1940,-171.7276,62},{-135.7900,-32.3920,34.2687,108},{-94.4377,-8.5892,85.0730,245},{-255.6773,-0.9933,252.6217,15},{-154.9438,-0.1692,366.7758,113},{26.3796,-0.7927,367.3437,141},{43.1365,-0.2210,-312.6742,25},{226.6807,0.4000,-340.0851,254},{103.4576,-0.5426,-413.4364,71},{-20.8774,-0.3192,-234.6284,161}}},
    {74,"Maze_of_Shakhrami",            198,{{-22.1467,-12.4385,179.6012,66},{-101.3492,-2.2936,-151.2039,248},{111.1700,-2.2611,-101.0926,189},{40.4040,20.4790,209.9708,66},{-196.3385,20.0000,10.4712,96},{60.3722,20.2062,-3.2300,198},{229.5484,19.9512,-67.1508,42},{232.5771,20.0000,-205.2077,14},{415.3548,-9.9440,-184.4230,153},{-97.1204,18.2890,-108.5104,127}}},
    {75,"Garlaige_Citadel",             200,{{-365.8472,0.0000,300.2241,1},{-340.4023,0.0000,196.7555,192},{-124.0672,19.5765,222.6125,254},{-146.8343,18.2547,307.7125,154},{-194.1149,-0.1097,299.7060,130},{-139.7103,0.0000,284.7077,61},{-84.1453,5.4468,138.1573,227},{-246.7601,0.0000,140.0049,0},{-197.6972,0.0000,327.6736,2},{-177.4922,-3.2500,60.6888,2},{40.9083,6.2607,135.8539,66},{137.0954,-6.0000,125.9596,51}}},
    {76,"FeiYin",                       204,{{-12.9088,-16.3494,-139.9272,253},{-10.0176,-15.8810,-31.6278,192},{223.8396,-23.6000,105.7288,218},{210.3261,-24.0000,151.6191,129},{-114.7430,-16.0000,220.1557,255},{-140.1059,-0.0000,166.5623,191},{-169.3447,0.0784,130.0214,129},{-110.0723,0.1202,88.3124,192},{30.0419,0.1222,111.7285,62},{-70.0603,0.1102,8.5731,188}}},
    {77,"Ifrits_Cauldron",              205,{{-19.3617,40.7404,26.0566,180},{-24.2422,20.6175,29.8477,191},{133.0659,19.0700,155.2385,123},{-56.6237,3.9649,296.6199,30},{-110.3765,-0.1749,209.4199,227},{-136.9634,3.9219,176.5262,36},{-94.6846,4.0888,-255.5473,213},{23.0352,3.8593,-217.5256,232},{186.7148,-0.4515,-11.3746,88},{-381.4852,28.4726,257.1818,202}}},
    {78,"Quicksand_Caves",              208,{{-40.2796,0.0000,-136.9789,67},{786.7136,-16.0000,-820.2549,129},{-856.9301,8.9868,-282.1165,68},{-853.9247,-0.7500,-391.3641,193},{-546.1545,-0.7500,-408.6346,61},{-163.0495,1.3647,302.1419,203},{-284.7585,2.1898,349.4622,63},{-466.6154,0.0000,620.1907,0},{-261.2475,-0.0000,679.7233,125},{-141.3792,1.9009,-266.1046,196}}},
    {79,"Gustav_Tunnel",                212,{{-87.1208,-11.2973,-209.6032,196},{-319.7408,-10.0000,-5.0519,249},{-175.4860,-0.4037,63.3391,130},{-233.7384,0.4243,146.2218,202},{-191.9278,0.5000,159.4674,126},{-122.2223,-0.0064,242.7728,149},{131.5850,0.0000,157.2582,153},{50.6715,0.0000,195.4354,218},{193.4221,10.0000,127.6815,62},{148.2214,9.7636,24.9960,202}}},
    {80,"Labyrinth_of_Onzozo",          213,{{168.1135,0.4692,-139.2111,133},{51.3078,3.6483,-27.2745,19},{140.7937,12.7799,71.4512,122},{139.4156,13.9356,143.0494,158},{128.8025,15.3145,215.1590,34},{43.6869,5.1283,289.1085,222},{-140.7666,0.4465,166.0279,60},{-169.1171,7.7613,-100.9293,184},{-15.3340,-9.9208,-262.9232,237},{-34.0274,4.9932,87.9367,80}}},
    {81,"Dynamis-Bastok",               186,{{55.4106,0.8720,-95.6280,123},{-32.6989,-1.0008,-128.0520,191},{0.0599,-3.0000,-57.6476,194},{-93.0332,8.0000,38.5617,128},{-137.9110,-11.9159,29.3083,250},{-189.9616,-8.6633,-21.0935,3},{-56.0307,-8.0000,-80.7188,187},{-0.3724,7.0000,-17.4583,196},{86.4775,7.0000,-32.5052,128},{60.4365,0.0000,-23.0208,191}}},
    {82,"Dynamis-San_dOria",            185,{{103.0156,0.8000,118.7534,33},{143.5971,-6.8000,17.3938,158},{55.6503,-8.6001,-31.3656,65},{64.6761,2.0000,-44.1444,17},{-19.8277,2.0000,-102.1705,194},{-0.9250,-3.3000,-37.6500,191},{-55.6349,-8.6000,-30.0746,65},{-150.7960,-2.0000,69.1858,64},{-138.5018,-10.8000,65.9260,30},{-280.5915,-4.0000,85.2179,1}}},
    {83,"Dynamis-Windurst",             187,{{29.6160,-7.5000,-53.9603,187},{87.7369,-2.5017,-129.3057,138},{129.9473,-7.5000,119.7235,137},{121.8708,-12.5000,202.9820,99},{22.1207,0.1068,243.3883,23},{-36.3368,-17.5000,282.3102,62},{-118.0073,-17.5000,204.1988,30},{-188.3368,-2.6144,152.8898,38},{-120.7844,-10.0000,113.0271,244},{30.7092,-16.0000,191.4375,95}}},
    {84,"Dynamis-Jeuno",                188,{{3.9050,9.0000,-66.3434,190},{-22.0025,9.0008,-49.9627,1},{-74.2725,5.5910,6.8162,2},{-62.7634,12.0000,-20.7677,254},{-37.5843,0.0016,-66.7192,191},{0.0260,3.0000,-6.0343,63},{0.4990,-5.0000,39.6504,45},{-21.0733,2.0000,67.9064,63},{0.1355,3.1000,108.3929,65},{3.8093,2.0000,126.5364,128}}},
    {85,"Dynamis-Beaucedine",           134,{{-196.5416,-33.0500,-219.8202,255},{-20.0111,-53.0500,-42.6936,62},{96.7535,-60.0000,240.0012,10},{-250.5012,-80.0807,259.5664,3},{100.0046,-13.0500,157.2966,61},{59.7561,6.9500,-357.2619,193},{449.4378,-0.5782,-207.8512,163},{242.5766,6.9500,-19.7210,0},{410.6616,-0.2846,382.5064,89},{155.1331,20.0000,520.9545,2}}},
    {86,"Dynamis-Xarcabard",            135,{{412.6093,-1.5000,-66.7298,139},{578.6130,-1.0229,-11.2431,199},{580.9446,-7.8227,299.1699,65},{342.0964,-27.8110,378.6551,66},{-103.1798,-16.0525,138.4671,131},{-419.2323,-44.0000,20.9226,255},{-22.7446,-23.9444,-497.6245,199},{338.0615,0.0480,-380.8414,189},{154.1199,-20.9415,-41.5231,96},{21.1789,-15.0600,40.2604,29}}},
    {87,"RuAun_Gardens",                130,{{391.7545,-40.2001,-256.2975,10},{367.0729,-8.0000,-119.0818,145},{448.4474,-36.0001,70.9872,117},{157.3788,-40.1998,448.0293,211},{-229.4140,-36.0001,389.2449,238},{-250.2982,-1.9997,383.1220,155},{-267.7208,-40.2002,245.4245,227},{-404.7607,-36.0002,207.3420,81},{-321.7044,-36.0001,-321.3355,30},{-20.0202,-43.6000,-236.4222,183}}},
    {88,"VeLugannon_Palace",            177,{{-288.4925,16.1138,330.0392,125},{-190.0155,16.1187,471.8792,67},{-169.9009,16.1163,368.4082,194},{169.9810,16.1052,368.7043,192},{391.4496,16.1112,329.9302,126},{-368.4095,16.1173,10.0326,125},{-430.9133,16.0891,-209.9608,1},{-328.3102,16.1216,-210.0214,128},{390.0662,16.0518,-270.0253,195}}},
    {89,"The_Shrine_of_RuAvitau",       178,{{0.8681,48.5758,-2.9191,174},{-5.0929,32.0000,-64.5456,142},{805.0850,-100.0000,-495.5064,13},{793.9081,-100.0000,-493.0049,107},{766.1418,0.0000,-66.5823,234},{834.4679,0.0000,55.5499,135},{734.3245,99.9914,721.8654,112},{877.5511,99.9924,465.2931,204},{10.4034,-0.5496,125.4356,233},{-147.3324,0.0000,33.6624,43}}},
    {90,"AlTaieu",                       33,{{-348.7621,-1.1157,-665.2139,181},{579.8798,-0.8725,-517.4087,117},{641.2814,-1.0054,-381.5023,189},{454.2005,-1.1451,52.3742,6},{662.3531,-0.8880,410.5736,99},{-70.1684,-0.9437,416.8428,172},{-288.1770,-1.1066,502.4862,212},{-543.6359,-0.9769,269.5271,238},{-706.3284,-1.0000,17.3196,223},{-583.6053,-0.9748,-489.8207,234}}},
    {91,"Grand_Palace_of_HuXzoi",        34,{{379.9800,0.0000,651.4335,192},{393.7602,-0.1250,705.2527,64},{95.1326,-0.1250,426.1952,1},{95.2099,-0.1250,487.1930,255},{225.5858,-0.1250,95.0963,194},{288.0449,-0.1250,104.8875,65},{553.7176,-0.1250,105.0635,66},{613.3165,-0.1250,95.1290,192},{745.0815,-0.1250,434.1974,126},{735.1116,-0.1250,486.1783,2}}},
    {92,"The_Garden_of_RuHmet",          35,{{100.1017,-4.1250,-347.6276,62},{252.6878,-4.1250,-699.9825,128},{573.0311,-4.1250,-700.0314,128},{740.1202,-4.1250,-346.9416,64},{426.8797,-4.1250,-99.9659,2},{420.0563,-6.0000,689.8992,64},{89.7061,-6.0000,459.9406,128},{260.0789,-6.0000,89.9785,64},{590.2084,-6.0000,99.9287,253},{729.8458,-6.0000,459.9905,127}}},
    {93,"Lufaise_Meadows",               24,{{-423.4090,-24.0624,156.0880,245},{-200.4877,-16.2849,309.1966,129},{-111.6645,-16.3483,75.7291,128},{-130.7443,-24.1938,0.3849,13},{-103.398,-16.912,36.529,120},{507.0544,0.9702,169.7554,113},{518.9730,-0.1650,-197.3863,92},{-40.2487,-8.3719,-286.8897,157},{42.1305,-0.1348,-278.9424,69},{-282.8755,-5.2988,-290.0927,208}}},
    {94,"Misareaux_Coast",               25,{{397.1268,-8.1813,41.1139,254},{250.9816,-15.5302,155.9226,189},{123.4985,-16.2761,35.2730,27},{-3.7053,-16.0249,3.6808,156},{106.8796,-7.4638,-106.6569,30},{-310.9839,-32.4416,184.5105,63},{-38.8966,-16.5233,609.1386,31},{158.7925,-24.1229,281.7050,17},{749.8550,-7.2655,-488.0176,228},{436.1713,23.3464,-327.3370,191}}},
    {95,"Phomiuna_Aqueducts",            27,{{137.4034,0.0000,-256.0573,1},{182.4849,0.0000,-163.3985,124},{132.3905,0.0038,-141.3404,138},{11.2723,-6.0209,-12.9673,0},{-210.9843,-7.0000,59.8655,127},{-53.4093,-6.0000,-22.4449,190},{-26.9825,0.0000,91.3175,192},{54.8076,0.0000,291.5337,194},{188.4187,-0.0794,186.1365,129},{187.5722,0.0493,54.2544,128}}},
    {96,"Sacrarium",                     28,{{9.0052,-2.0000,-99.1973,64},{53.1358,-2.0000,-126.9785,63},{111.0480,-2.0000,-99.5779,64},{13.0829,-2.0000,126.8658,190},{66.9986,-2.0000,127.0917,194},{107.0905,-2.0000,127.0974,194},{182.7079,-4.0004,61.6170 ,131},{263.2378,0.0000,0.0872,128},{146.7861,0.0184,-69.0562,128},{179.8529,-7.7043,-97.3232,191}}},
    {97,"Riverne-Site_A01",              30,{{716.5038,48.3542,-883.9803,206},{401.2469,41.1097,-823.4564,63},{183.6497,96.7433,-845.3622,89},{320.6746,-0.0439,522.6558,248},{-200.6940,48.0000,-840.1556,124},{-616.1078,21.1359,-558.9189,1},{-732.6922,-43.6000,-305.2765,62},{397.7758,-0.2250,483.1411,22},{311.0520,0.2463,521.2983,224},{160.2137,1.1546,464.6533,187}}},                                            
    {98,"Riverne-Site_B01",              29,{{-770.6180,2.9280,568.9237,44},{-884.0439,-31.6567,315.9933,242},{-824.9858,-43.8000,149.4034,255},{-551.6124,0.3694,672.3312,63},{-249.6885,34.8543,669.8384,219},{185.0282,15.2871,693.7538,8},{494.9591,39.2698,786.4960,130},{729.3719,22.5995,591.3603,154},{244.7128,88.4269,866.5482,193},{468.6223,-0.6073,-812.4379,154}}},
    {99,"Escha_ZiTah",                  288,{{-239.7929,0.1509,647.0380,65},{-515.2065,-0.0749,141.7643,203},{-251.2292,0.0278,22.8264,25},{76.5026,6.9768,230.2899,120},{407.4255,0.2319,-166.1425,184},{647.8585,0.1919,-197.4257,77},{469.0533,-0.0772,-566.3897,235},{43.0593,0.0517,-450.5480,176},{-269.3002,0.0573,239.5998,127},{12.9831,-0.1135,49.2848,105}}},
    {100,"Escha_RuAun",                 289,{{-120.8190,-32.0003,-209.8615,173},{120.2881,-32.0000,-210.9376,220},{432.0908,-2.0001,-159.6223,17},{250.9842,-2.0001,380.8788,237},{-250.8417,-1.9996,382.6036,161},{-427.5572,-1.9999,-161.3538,114},{350.9904,-68.8199,473.0785,162},{559.4196,-68.6200,-192.7737,205},{-561.4968,-68.8200,-176.4938,87},{-342.7774,-68.6200,483.4805,105}}}
}

-- This loops through each zones and handles creating the dynamic entities for the chests
for _, entry in pairs(treasurePositions) do
    local questZoneNum         = entry[1]
    local questZoneName        = entry[2]
    local questZoneID          = entry[3]
    local positionsLength      = #(entry[4])
    local randChestNum = math.random(1,positionsLength)
    local positionX = entry[4][randChestNum][1]
    local positionY = entry[4][randChestNum][2]
    local positionZ = entry[4][randChestNum][3]
    local positionR = entry[4][randChestNum][4]

    -- Create the override for the zone
    m:addOverride(string.format("xi.zones.%s.Zone.onInitialize",questZoneName), function(zone)

        super(zone)

        -- Create the dynamic Chest entity in the zone
        local dailyQuestChest = zone:insertDynamicEntity({

            objtype = xi.objType.NPC,
            name = "Secret Chest",
            look = treasureCostumeID,
            x = positionX,
            y = positionY,
            z = positionZ,
            rotation = positionR,
            widescan = 0,

            -- No trades needed
            onTrade = function(player, npc, trade)
                player:printToPlayer("I don't require any items from you.", 0, npc:getPacketName())
            end,
    
            -- When a player clicks the chest
            onTrigger = function(player, npc)
                -- Check to see if daily reset needs to happen first
                handleMidnight(player)
                local dailyQuestActive = player:getCharVar("[DQ]Fishstix")
                local dailyQuestZone = player:getCharVar("[DQ]Fishstix_Z")
                local chestOpened = npc:getLocalVar("opened")

                -- If their quest is active and actually FOR this zone
                if dailyQuestActive == 1 and dailyQuestZone == questZoneNum and chestOpened == 0 then
                    -- Create a mutex-type lock so players can't try and open it at the same exact time
                    npc:setLocalVar("opened", 1)
                    -- Advance the quest and have them return to the NPC for their reward
                    player:setCharVar("[DQ]Fishstix",2)
                    player:printToPlayer("You found the Secret Treasure Chest, please return to Fishstix to claim your reward!", 17)
                    -- Disappear the chest and send to a new location
                    npc:setAnimation(1)
                    npc:timer(1500, function(npcArg)
                        npcArg:setStatus(xi.status.DISAPPEAR)
                        local otherPositions = {}
                        local currX = npcArg:getXPos()
                        local currZ = npcArg:getZPos()
                        for _, position in pairs(entry[4]) do
                            if
                                math.abs(position[1] - currX) > 1 and
                                math.abs(position[3] - currZ) > 1
                            then
                                table.insert(otherPositions, position)
                            end
                        end

                        local newPosition = otherPositions[math.random(#otherPositions)]
                        npcArg:setPos(newPosition[1], newPosition[2], newPosition[3], newPosition[4])
                        npcArg:setAnimation(0)
                        npcArg:setStatus(xi.status.NORMAL)
                        npcArg:setLocalVar("opened", 0)
                    end)
                else
                    player:printToPlayer("This is not for you.", 0, npc:getPacketName())    
                end
            end,
        })

        utils.unused(dailyQuestChest)
    end)
end

m:addOverride("xi.player.onPlayerEmote", function(player, emoteId)
    super(player, emoteId)

    -- player's DQ zone metadata, compare zone name to player's current zone name
    local playerZone = player:getZone()
    local playerDQZone = treasurePositions[player:getCharVar("[DQ]Fishstix_Z")]
    if
        emoteId == xi.emote.HUH and
        getMidnight() == player:getCharVar("[DQ]Midnight") and
        player:getCharVar("[DQ]Fishstix") == 1 and
        playerDQZone ~= nil and
        playerZone:getName() == playerDQZone[2]
    then
        local npcName = "Secret Chest"
        local npcTable = playerZone:queryEntitiesByName("DE_" .. npcName)
        local npcObj = nil

        for _, npc in pairs(npcTable) do
            if
                npc:getLocalVar("opened") == 0 and
                npc:getStatus() ~= xi.status.DISAPPEAR
            then
                npcObj = npc
                break
            end
        end

        if npcObj ~= nil then
            -- similar logic to AMK digging minigame
            local targetPos = npcObj:getPos()
            local targetX = targetPos.x
            local targetZ = targetPos.z
            local playerPos = player:getPos()

            local distance = player:checkDistance(targetX, playerPos.y, targetZ)

            -- Angle between points
            -- NOTE: This is mapped to 0-255
            local angle = player:getWorldAngle(targetX, playerPos.y, targetZ)

            -- Map angle from 0-255 to 0-7 for the messageSpecial arg, with a small offset for cardinal direction
            local offset = 255 / 8
            local direction = math.floor(((7 - 0) / (255 - 0)) * ((angle + offset) - 0))

            local directionTable = {
                [0] = "east",
                [1] = "southeast",
                [2] = "south",
                [3] = "southwest",
                [4] = "west",
                [5] = "northwest",
                [6] = "north",
                [7] = "northeast",
            }
            local messageText = "You sense a secret chest is %s in the %s direction!"
            local directionText = directionTable[direction]
            if directionText == nil then
                directionText = "unknown"
            end

            local distanceText = "unknown"
            if distance > 200 then
                distanceText = "distant"
            elseif distance > 100 then
                distanceText = "far"
            elseif distance > 50 then
                distanceText = "close"
            elseif distance > 25 then
                distanceText = "very close"
            else
                distanceText = "right next to you"
            end

            player:printToPlayer(
                string.format(
                    messageText,
                    distanceText,
                    directionText
                ),
                xi.msg.channel.NS_SAY
            )
        end
    end
end)

return m
