-----------------------------------
-- Daily Quest : Saltlix
-- Kill a certain NM
-----------------------------------
require("modules/module_utils")
require("scripts/zones/Lower_Jeuno/Zone")
local ID = require("scripts/zones/Lower_Jeuno/IDs")
-----------------------------------
local m = Module:new("daily_quest_saltlix")

m:addOverride("xi.zones.Lower_Jeuno.Zone.onInitialize", function(zone)

    super(zone)

    -- This table contains all the zones and NMs in those zones in printable format for displaying to the player
    local questLocations =
    {
        -- [index] | Zone Name | NM Name
        {"West Ronfaure",            {"Amanita","Fungus Beetle"}},
        {"East Ronfaure",            {"Bigmouth Billy","Swamfisk","Rambukk"}},
        {"South Gustaberg",          {"Tococo","Leaping Lizzy","Carnero"}},
        {"North Gustaberg",          {"Stinging Sophie","Maighdean Uaine","Bedrock Barry"}},
        {"West Sarutabaruta",        {"Numbing Norman","Nunyenunc","Tom Tit Tat"}},
        {"East Sarutabaruta",        {"Duke Decapod","Spiny Spipi","Sharp-Eared Ropipi"}},
        {"La Theine Plateau",        {"Nihniknoovi","Slumbering Samwell","Tumbling Truffle","Lumbering Lambert"}},
        {"Konschtat Highlands",      {"Ghillie Dhu","Highlander Lizard","Rampaging Ram","Stray Mary"}},
        {"Tahrongi Canyon",          {"Yara Ma Yha Who","Habrok","Serpopard Ishtar","Herbage Hunter"}},
        {"Valkurm Dunes",            {"Metal Shears","Golden Bat","Hippomaritimus"}},
        {"Jugner Forest",            {"Panzer Percival","Fraelissa","Meteormauler Zhagtegg","Sappy Sycamore","Supplespine Mujwuj"}},
        {"Batallia Downs",           {"Tottering Toby","Weeping Willow","Eyegouger","Ahtu","Prankster Maverix","Skirling Liger"}},
        {"Pashhow Marshlands",       {"Bloodpool Vorax","Bo'Who Warmonger","Jolly Green","Toxic Tamlyn","Ni'Zho Bladebender"}},
        {"Rolanberry Fields",        {"Drooling Daisy","Silk Caterpillar","Ravenous Crawler","Eldritch Edge"}},
        {"Sauromugue Champaign",     {"Bashe","Thunderclaw Thuban","Blighting Brand"}},
        {"Beaucedine Glacier",       {"Calcabrina","Gargantua","Humbaba","Kirata"}},
        {"Xarcabard",                {"Barbaric Weapon","Duke Focalor","Ereshkigal","Shadow Eye","Timeworn Warrior"}},
        {"Cape Teriggan",            {"Frostmane","Killer Jonny","Tegmine","Zmey Gorynych"}},
        {"Eastern Altepa Desert",    {"Centurio XII-I","Donnergugi","Dune Widow","Nandi"}},
        {"Western Altepa Desert",    {"Cactuar Cantautor","Calchas","Celphie","Dahu","Picolaton"}},
        {"Meriphataud Mountains",    {"Daggerclaw Dracos","Patripatan","Chonchon","Naa Zeku the Unwaiting"}},
        {"Buburimu Peninsula",       {"Backoo","Buburimboo","Helldiver","Wake Warder Wanda"}},
        {"The Sanctuary of Zi'Tah",  {"Elusive Edwin","Huwasi","Keeper of Halidom","Bastet"}},
        {"Ro'Maeve",                 {"Nightmare Vase","Martinet","Nargun","Rogue Receptacle"}},
        {"Yuhtunga Jungle",          {"Koropokkur","Meww the Turtlerider","Mischievous Micholas","Pyuu the Spatemaker"}},
        {"Yhoator Jungle",           {"Acolnahuacatl","Bisque-heeled Sunberry","Bright-handed Kunberry","Edacious Opo-opo","Hoar-knuckled Rimberry","Powderer Penny"}},
        {"Qufim Island",             {"Dosetsu Tree","Slippery Sucker","Trickster Kinetix","Atkorkamuy","Qoofim"}},
        {"Temple of Uggalepih",      {"Bonze Marberry","Death from Above","Flauros","Habetrot","Manipulator","Sacrificial Goblet","Sozu Terberry","Tonberry Kinq"}},
        {"Bibiki Bay",               {"Intulo","Splacknuck","Shankha","Serra"}},
        {"Carpenter's Landing",      {"Hercules Beetle","Mycophile","Orctrap","Tempest Tigon"}},
        {"Uleguerand Range",         {"Bonnacon","Father Frost","Geush Urvan","Magnotaur","Mountain Worm","Skvader","Snow Maiden"}},
        {"Attohwa Chasm",            {"Ambusher Antlion","Citipati","Sargas","Sekhmet"}},
        {"Oldton Movalpolos",        {"Bugbear Strongman","Goblin Wolfman","Bugbear Muscleman"}},
        {"Newton Movalpolos",        {"Bugbear Matman","Goblin Collector","Sword Sorcerer Solisoq","Swashstox Beadblinker"}},
        {"Wajaom Woodlands",         {"Gharial","Jaded Jody","Zoraal Ja's Pkuucha"}},
        {"Bhaflau Thickets",         {"Emergent Elm","Harvestman","Mahishasura","Nis Puk"}},
        {"Arrapago Reef",            {"Bloody Bones","Euryale","Lamie No.7","Lamie No.8","Lamie No.9","Lamia No.19"}},
        {"Mount Zhayolm",            {"Chary Apkallu","Energetic Eruca","Fahrafahr the Bloodied","Ignamoth"}},
        {"Halvung",                  {"Copper Borer","Dorgerwor the Astute","Farlarder the Shrewd","Flammeri","Kirlirger the Abhorrent","Mythril Mouth Monamaq"}},
        {"Mamook",                   {"Darting Kachaal Ja","Devout Radol Ja","Dragonscaled Bugaal Ja","Firedance Magmaal Ja","Hundredfaced Hapool Ja","Venomfang","Zizzy Zillah"}},
        {"Aydeewa Subterrane",       {"Bluestreak Gyugyuroon","Lizardtrap"}},
        {"Alzadaal Undersea Ruins",  {"Boompadu","Cookieduster Lipiroon","Oupire"}},
        {"Caedarva Mire",            {"Aynu-kaysey","Peallaidh","Zikko"}},
        {"Yughott Grotto",           {"Ashmaker Gotblut"}},
        {"Fort Ghelsba",             {"Hundredscar Hajwaj","Orcish Panzer","Kegpaunch Doshgnosh"}},
        {"Palborough Mines",         {"Bu'Ghi Howlblade","No'Mho Crimsonarmor","Zi'Ghi Boneeater","Be'Hya Hundredwall","Qu'Vho Deathhurler"}},
        {"Giddeus",                  {"Eyy Mon the Ironbreaker","Hoo Mjuu the Torrent","Juu Duzu the Whirlwind","Quu Xijo the Illusory","Vuu Puqu the Beguiler","Zhuu Buxu the Silent"}},
        {"Beadeaux",                 {"Bi'Gho Headtaker","Da'Dha Hundredmask","De'Vyu Headhunter","Ga'Bhu Unvanquished","Ge'Dha Evileye","Go'Bhu Gascon","Zo'Khu Blackcloud"}},
        {"Davoi",                    {"Blubbery Bulge","Dirtyhanded Gochakzuk","Hawkeyed Dnatbat","Poisonhand Gnadgad","Steelbiter Gudrud","Tigerbane Bakdak"}},
        {"Monastic Cavern",          {"Orcish Hexspinner","Orcish Overlord","Orcish Warlord"}},
        {"Castle Oztroja",           {"Moo Ouzi the Swiftblade","Mee Deggi the Punisher","Quu Domi the Gallant","Saa Doyi the Fervid","Yaa Haqa the Profane","Yagudo High Priest","Yagudo Templar","Lii Jixa the Somnolist"}},
        {"The Boyahda Tree",         {"Ancient Goobbue","Aquarius","Ellyllon","Leshonki","Unut","Voluptuous Vivian"}},
        {"Lower Delkfutt's Tower",   {"Epialtes","Eurymedon","Hippolytos","Tyrant"}},
        {"Middle Delkfutt's Tower",  {"Eurytos","Ogygos","Ophion","Polybotes","Rhoikos","Rhoitos"}},
        {"Upper Delkfutt's Tower",   {"Alkyoneus","Enkelados","Ixtab","Mimas","Pallas","Porphyrion","Autarch"}},
        {"Den of Rancor",            {"Bistre-hearted Malberry","Carmine-tailed Janberry","Celeste-eyed Tozberry","Friar Rush","Ogama","Sozu Bliberry","Tawny-fingered Mugberry","Tonberry Decapitator","Tonberry Pontifex","Tonberry Tracker"}},
        {"Castle Zvahl Baileys",     {"Duke Haborym","Grand Duke Batym","Likho","Marquis Allocen","Marquis Naberius","Marquis Sabnock"}},
        {"Castle Zvahl Keep",        {"Baron Vapula","Baronet Romwe","Count Bifrons","Viscount Morax"}},
        {"Ranguemont Pass",          {"Mucoid Mass","Gloom Eye","Hyakume"}},
        {"Bostaunieux Oubliette",    {"Arioch","Bloodsucker","Manes","Sewer Syrup","Shii"}},
        {"Toraimarai Canal",         {"Canal Moocher","Brazen Bones","Konjac"}},
        {"Korroloka Tunnel",         {"Cargo Crab Colin","Dame Blanche","Falcatus Aranei","Morion Worm","Thoon"}},
        {"Kuftal Tunnel",            {"Amemet","Arachne","Bloodthirster Madkix","Cancer","Guivre","Pelican","Phantom Worm","Sabotender Mariachi","Yowie"}},
        {"The Eldieme Necropolis",   {"Cwn Cyrff","Skull of Envy","Skull of Gluttony","Skull of Greed","Skull of Lust","Skull of Pride","Skull of Sloth","Skull of Wrath"}},
        {"Sea Serpent Grotto",       {"Abyss Sahagin","Coral Sahagin","Denn the Orcavoiced","Fyuu the Seabellow","Masan","Mouu the Waverider","Namtar","Novv the Whitehearted","Ocean Sahagin","Pahh the Gullcaller","Qull the Shellbuster","Seww the Squidlimbed","Voll the Sharkfinned","Worr the Clawfisted","Wuur the Sandcomber","Yarr the Pearleyed","Zuug the Shoreleaper"}},
        {"Dangruf Wadi",             {"Chocoboleech","Geyser Lizard","Teporingo"}},
        {"Inner Horutoto Ruins",     {"Maltha","Nocuous Weapon","Slendlix Spindlethumb"}},
        {"Outer Horutoto Ruins",     {"Bomb King","Doppelganger Dio","Doppelganger Gog","Legalox Heftyhind","Ah Puch","Desmodont"}},
        {"Ordelle's Caves",          {"Bombast","Donggu","Agar Agar"}},
        {"Gusgen Mines",             {"Asphyxiated Amsel","Burned Bergmann","Crushed Krause","Juggler Hecatomb","Pulverized Pfeffer","Smothered Schmidt","Wounded Wurfel"}},
        {"Crawler's Nest",           {"Aqrabuamelu","Awd Goggie","Demonic Tiphia","Drone Crawler","Dynast Beetle","Guardian Crawler","Matron Crawler"}},
        {"Maze of Shakhrami",        {"Lesath","Gloombound Lurker","Trembler Tabitha"}},
        {"Garlaige Citadel",         {"Frogamander","Hazmat","Old Two-Wings","Hovering Hotpot"}},
        {"Fei'Yin",                  {"Eastern Shadow","Goliath","Jenglot","Mind Hoarder","Northern Shadow","Sluagh","Southern Shadow","Western Shadow"}},
        {"Ifrit's Cauldron",         {"Bomb Queen","Foreseer Oramix","Lindwurm","Tarasque","Tyrannic Tunnok","Vouivre"}},
        {"Quicksand Caves",          {"Antican Consul","Antican Legatus","Antican Magister","Antican Praefectus","Antican Praetor","Antican Proconsul","Antican Tribunus","Centurio X-I","Diamond Daig","Hastatus XI-XII","Nussknacker","Proconsul XII","Sabotender Bailarin","Sabotender Bailarina","Sagittarius X-XIII","Triarius X-XV","Tribunus VII-I"}},
        {"Gustav Tunnel",            {"Amikiri","Baobhan Sith","Bune","Goblinsavior Heronox","Taxim","Ungur","Wyvernpoacher Drachlox"}},
        {"Labyrinth of Onzozo",      {"Hellion","Mysticmaker Profblix","Narasimha","Ose","Peg Powler","Soulstealer Skullnix"}},
        {"Al'Taieu",                 {"Om'yovra","Ul'yovra"}},
        {"Lufaise Meadows",          {"Amaltheia","Megalobugard","Flockbock","Sengann","Yal-un Eke"}},
        {"Misareaux Coast",          {"Goaftrap","Gration","Odqan","Okyupete","Upyri","Ziphius"}},

        -- Level capped areas for CW and WEW
        -- {"Phomiuna Aqueducts",       {"Tres Duendes","Eba","Mahisha"}},
        -- {"Sacrarium",                {"Elel"}},
        -- {"Riverne Site-A01",         {"Aiatar","Heliodromos","Shieldtrap"}},
        -- {"Riverne Site-B01",         {"Boroka","Imdugud","Unstable Cluster"}}
    }

    -- Handles the functionality of the "daily reset" at midnight
    local handleMidnight = function(player)
        local questMidnight = player:getCharVar("[DQ]Midnight")
        local currentMidnight = getMidnight()

        -- handle first time quest midnight
        if questMidnight == 0 then
            player:setCharVar("[DQ]Midnight", currentMidnight)
            player:setCharVar("[DQ]Completed", 0)
            player:setCharVar("[DQ]Reset", 0)
            player:setCharVar("[DQ]Fishstix", 0)
            player:setCharVar("[DQ]Fishstix_Z", 0)
            player:setCharVar("[DQ]Murdoc", 0)
            player:setCharVar("[DQ]Murdoc_Z", 0)
            player:setCharVar("[DQ]Murdoc_MT", 0)
            player:setCharVar("[DQ]Murdoc_KA", 0)
            player:setCharVar("[DQ]Mistrix", 0)
            player:setCharVar("[DQ]Mistrix_I", 0)
            player:setCharVar("[DQ]Saltlik", 0)
            player:setCharVar("[DQ]Saltlik_Z", 0)
            player:setCharVar("[DQ]Saltlik_NM", 0)
            player:setCharVar("[DQ]Beetrix", 0)
            player:setCharVar("[DQ]Beetrix_Z", 0)
            player:setCharVar("[DQ]Beetrix_RE", 0)
        end
        
        -- handle midnight reset
        if currentMidnight ~= questMidnight then
            player:setCharVar("[DQ]Midnight", currentMidnight)
            player:setCharVar("[DQ]Completed", 0)
            player:setCharVar("[DQ]Reset", 0)
            player:setCharVar("[DQ]Fishstix", 0)
            player:setCharVar("[DQ]Fishstix_Z", 0)
            player:setCharVar("[DQ]Murdoc", 0)
            player:setCharVar("[DQ]Murdoc_Z", 0)
            player:setCharVar("[DQ]Murdoc_MT", 0)
            player:setCharVar("[DQ]Murdoc_KA", 0)
            player:setCharVar("[DQ]Mistrix", 0)
            player:setCharVar("[DQ]Mistrix_I", 0)
            player:setCharVar("[DQ]Saltlik", 0)
            player:setCharVar("[DQ]Saltlik_Z", 0)
            player:setCharVar("[DQ]Saltlik_NM", 0)
            player:setCharVar("[DQ]Beetrix", 0)
            player:setCharVar("[DQ]Beetrix_Z", 0)
            player:setCharVar("[DQ]Beetrix_RE", 0)
        end
    end

    -- Adds the NPC into Lower Jeuno
    local saltlik = zone:insertDynamicEntity({

        objtype = xi.objType.NPC,
        name = "Saltlix",
        look = 492,
        x = -51.7539,
        y = 0.000,
        z = -58.3718,
        rotation = 19,
        widescan = 1,

        -- Handles the ability to reset daily quest for 50k gil
        onTrade = function(player, npc, trade)
            -- Check to see if daily reset needs to happen first
            handleMidnight(player)
            npc:facePlayer(player, true)

            local gil = trade:getGil()
            local questStage = player:getCharVar("[DQ]Saltlik")
            local resetCount = player:getCharVar("[DQ]Reset")
            local cost = 50000

            if player:isCrystalWarrior() then
                cost = 15000
            end

            -- If the player makes a trade with 50k gil
            if gil == cost then
                -- If they trade something else besides gil
                if trade:getItemCount() ~= 1 then
                    player:printToPlayer("I only accept gil as payment.", 0, npc:getPacketName())
                else
                    -- If the daily is already not given out, no need to reset
                    if questStage == 0 then
                        player:printToPlayer("You don't need to reset this daily, the quest has not been given yet.", 0, npc:getPacketName())
                    -- If the daily is already completed, no reset allowed
                    elseif questStage == 3 then
                        player:printToPlayer("You can't reset a completed daily. Come back tomorrow for more.", 0, npc:getPacketName())
                    else
                        -- If they've already done their 3 resets a day, no more reset allowed
                        if resetCount >= 3 then
                            player:printToPlayer("You can only reset a daily quest a max of 3 times per day across ALL dailies. Come back tomorrow for more.", 0, npc:getPacketName())
                        else
                            -- If it's a valid reset, reset the daily
                            player:tradeComplete()
                            player:setCharVar("[DQ]Reset", resetCount + 1)
                            player:setCharVar("[DQ]Saltlik", 0)
                            player:setCharVar("[DQ]Saltlik_Z", 0)
                            player:setCharVar("[DQ]Saltlik_NM", 0)
                            player:printToPlayer(string.format("You have successfully reset my daily quest. Resets remaining today: %d.",(3 - (resetCount + 1))), 0, npc:getPacketName())
                        end
                    end
                end
            else
                player:printToPlayer(string.format("You can trade me %u gil to reset this daily quest (3 resets a day max across all dailies).", cost), 0, npc:getPacketName())
            end
        end,

        -- This handles assigning the quest and handling setting the reward for quest completion
        onTrigger = function(player, npc)
            -- Check to see if daily reset needs to happen first
            handleMidnight(player)
            -- What "stage" of the quest they're on
            local questStage = player:getCharVar("[DQ]Saltlik")
            -- Used later to keep a count of how many completed quests a day
            local completedDailyQuests = player:getCharVar("[DQ]Completed")

            npc:facePlayer(player, true)

            -- Handle quest stages
            -- Quest hasn't been started yet, assign a random zone an random NM to go kill
            if questStage == 0 then
                local randNum = math.random(1, #questLocations)
                local questZoneName = questLocations[randNum][1]
                local nmListLength = table.getn(questLocations[randNum][2])
                local randNM = math.random(1,nmListLength)
                local questNMName = questLocations[randNum][2][randNM]
                player:setCharVar("[DQ]Saltlik",1)
                player:setCharVar("[DQ]Saltlik_Z",randNum)
                player:setCharVar("[DQ]Saltlik_NM",randNM)
                player:printToPlayer(string.format("Go to %s and kill %s!",questZoneName, questNMName), 0, npc:getPacketName())
                return
            -- Quest has been started already, just reiterate their quest to them
            elseif questStage == 1 then
                local questZone = player:getCharVar("[DQ]Saltlik_Z")
                local questNM = player:getCharVar("[DQ]Saltlik_NM")
                local questZoneName = questLocations[questZone][1]
                local questNMName = questLocations[questZone][2][questNM]
                player:printToPlayer(string.format("Go to %s and kill %s!",questZoneName, questNMName), 0, npc:getPacketName())
                return
            -- They have killed all the required mobs, handle the reward
            elseif questStage == 2 then
                player:incrementCharVar("[DQ]Saltlix_complete", 1)
                player:setCharVar("[DQ]Saltlik",3)
                player:setCharVar("[DQ]Completed", completedDailyQuests + 1, getMidnight())
                player:printToPlayer("Congratulations! You've completed my quest for today, here's your reward!", 0, npc:getPacketName())
                player:addCurrency('obsidian_fragment', 400)
                player:printToPlayer("You have obtained 400 Obsidian Fragments!", 17)
                return
            -- The quest as already been completed
            elseif questStage == 3 then
                player:printToPlayer("You've already completed this quest today! Come back tomorrow for more.", 0, npc:getPacketName())
                return
            end
        end,
    })

    utils.unused(saltlik)

end)

-- This table contains the zones and ACTUAL NM names for each NM, this is formatted for filenames
local dailyNMs =
{
    { 1, 1, "West_Ronfaure", "Amanita" },
    { 1, 2, "West_Ronfaure", "Fungus_Beetle" },
    { 2, 1, "East_Ronfaure", "Bigmouth_Billy" },
    { 2, 2, "East_Ronfaure", "Swamfisk" },
    { 2, 3, "East_Ronfaure", "Rambukk" },
    { 3, 1, "South_Gustaberg", "Tococo" },
    { 3, 2, "South_Gustaberg", "Leaping_Lizzy" },
    { 3, 3, "South_Gustaberg", "Carnero" },
    { 4, 1, "North_Gustaberg", "Stinging_Sophie" },
    { 4, 2, "North_Gustaberg", "Maighdean_Uaine" },
    { 4, 3, "North_Gustaberg", "Bedrock_Barry" },
    { 5, 1, "West_Sarutabaruta", "Numbing_Norman" },
    { 5, 2, "West_Sarutabaruta", "Nunyenunc" },
    { 5, 3, "West_Sarutabaruta", "Tom_Tit_Tat" },
    { 6, 1, "East_Sarutabaruta", "Duke_Decapod" },
    { 6, 2, "East_Sarutabaruta", "Spiny_Spipi" },
    { 6, 3, "East_Sarutabaruta", "Sharp-Eared_Ropipi" },
    { 7, 1, "La_Theine_Plateau", "Nihniknoovi" },
    { 7, 2, "La_Theine_Plateau", "Slumbering_Samwell" },
    { 7, 3, "La_Theine_Plateau", "Tumbling_Truffle" },
    { 7, 4, "La_Theine_Plateau", "Lumbering_Lambert" },
    { 8, 1, "Konschtat_Highlands", "Ghillie_Dhu" },
    { 8, 2, "Konschtat_Highlands", "Highlander_Lizard" },
    { 8, 3, "Konschtat_Highlands", "Rampaging_Ram" },
    { 8, 4, "Konschtat_Highlands", "Stray_Mary" },
    { 9, 1, "Tahrongi_Canyon", "Yara_Ma_Yha_Who" },
    { 9, 2, "Tahrongi_Canyon", "Habrok" },
    { 9, 3, "Tahrongi_Canyon", "Serpopard_Ishtar" },
    { 9, 4, "Tahrongi_Canyon", "Herbage_Hunter" },
    { 10, 1, "Valkurm_Dunes", "Metal_Shears" },
    { 10, 2, "Valkurm_Dunes", "Golden_Bat" },
    { 10, 3, "Valkurm_Dunes", "Hippomaritimus" },
    { 11, 1, "Jugner_Forest", "Panzer_Percival" },
    { 11, 2, "Jugner_Forest", "Fraelissa" },
    { 11, 3, "Jugner_Forest", "Meteormauler_Zhagtegg" },
    { 11, 4, "Jugner_Forest", "Sappy_Sycamore" },
    { 11, 5, "Jugner_Forest", "Supplespine_Mujwuj" },
    { 12, 1, "Batallia_Downs", "Tottering_Toby" },
    { 12, 2, "Batallia_Downs", "Weeping_Willow" },
    { 12, 3, "Batallia_Downs", "Eyegouger" },
    { 12, 4, "Batallia_Downs", "Ahtu" },
    { 12, 5, "Batallia_Downs", "Prankster_Maverix" },
    { 12, 6, "Batallia_Downs", "Skirling_Liger" },
    { 13, 1, "Pashhow_Marshlands", "Bloodpool_Vorax" },
    { 13, 2, "Pashhow_Marshlands", "BoWho_Warmonger" },
    { 13, 3, "Pashhow_Marshlands", "Jolly_Green" },
    { 13, 4, "Pashhow_Marshlands", "Toxic_Tamlyn" },
    { 13, 5, "Pashhow_Marshlands", "NiZho_Bladebender" },
    { 14, 1, "Rolanberry_Fields", "Drooling_Daisy" },
    { 14, 2, "Rolanberry_Fields", "Silk_Caterpillar" },
    { 14, 3, "Rolanberry_Fields", "Ravenous_Crawler" },
    { 14, 4, "Rolanberry_Fields", "Eldritch_Edge" },
    { 15, 1, "Sauromugue_Champaign", "Bashe" },
    { 15, 2, "Sauromugue_Champaign", "Thunderclaw_Thuban" },
    { 15, 3, "Sauromugue_Champaign", "Blighting_Brand" },
    { 16, 1, "Beaucedine_Glacier", "Calcabrina" },
    { 16, 2, "Beaucedine_Glacier", "Gargantua" },
    { 16, 3, "Beaucedine_Glacier", "Humbaba" },
    { 16, 4, "Beaucedine_Glacier", "Kirata" },
    { 17, 1, "Xarcabard", "Barbaric_Weapon" },
    { 17, 2, "Xarcabard", "Duke_Focalor" },
    { 17, 3, "Xarcabard", "Ereshkigal" },
    { 17, 4, "Xarcabard", "Shadow_Eye" },
    { 17, 5, "Xarcabard", "Timeworn_Warrior" },
    { 18, 1, "Cape_Teriggan", "Frostmane" },
    { 18, 2, "Cape_Teriggan", "Killer_Jonny" },
    { 18, 3, "Cape_Teriggan", "Tegmine" },
    { 18, 4, "Cape_Teriggan", "Zmey_Gorynych" },
    { 19, 1, "Eastern_Altepa_Desert", "Centurio_XII-I" },
    { 19, 2, "Eastern_Altepa_Desert", "Donnergugi" },
    { 19, 3, "Eastern_Altepa_Desert", "Dune_Widow" },
    { 19, 4, "Eastern_Altepa_Desert", "Nandi" },
    { 20, 1, "Western_Altepa_Desert", "Cactuar_Cantautor" },
    { 20, 2, "Western_Altepa_Desert", "Calchas" },
    { 20, 3, "Western_Altepa_Desert", "Celphie" },
    { 20, 4, "Western_Altepa_Desert", "Dahu" },
    { 20, 5, "Western_Altepa_Desert", "Picolaton" },
    { 21, 1, "Meriphataud_Mountains", "Daggerclaw_Dracos" },
    { 21, 2, "Meriphataud_Mountains", "Patripatan" },
    { 21, 3, "Meriphataud_Mountains", "Chonchon" },
    { 21, 4, "Meriphataud_Mountains", "Naa_Zeku_the_Unwaiting" },
    { 22, 1, "Buburimu_Peninsula", "Backoo" },
    { 22, 2, "Buburimu_Peninsula", "Buburimboo" },
    { 22, 3, "Buburimu_Peninsula", "Helldiver" },
    { 22, 4, "Buburimu_Peninsula", "Wake_Warder_Wanda" },
    { 23, 1, "The_Sanctuary_of_ZiTah", "Elusive_Edwin" },
    { 23, 2, "The_Sanctuary_of_ZiTah", "Huwasi" },
    { 23, 3, "The_Sanctuary_of_ZiTah", "Keeper_of_Halidom" },
    { 23, 4, "The_Sanctuary_of_ZiTah", "Bastet" },
    { 24, 1, "RoMaeve", "Nightmare_Vase" },
    { 24, 2, "RoMaeve", "Martinet" },
    { 24, 3, "RoMaeve", "Nargun" },
    { 24, 4, "RoMaeve", "Rogue_Receptacle" },
    { 25, 1, "Yuhtunga_Jungle", "Koropokkur" },
    { 25, 2, "Yuhtunga_Jungle", "Meww_the_Turtlerider" },
    { 25, 3, "Yuhtunga_Jungle", "Mischievous_Micholas" },
    { 25, 4, "Yuhtunga_Jungle", "Pyuu_the_Spatemaker" },
    { 26, 1, "Yhoator_Jungle", "Acolnahuacatl" },
    { 26, 2, "Yhoator_Jungle", "Bisque-heeled_Sunberry" },
    { 26, 3, "Yhoator_Jungle", "Bright-handed_Kunberry" },
    { 26, 4, "Yhoator_Jungle", "Edacious_Opo-opo" },
    { 26, 5, "Yhoator_Jungle", "Hoar-knuckled_Rimberry" },
    { 26, 6, "Yhoator_Jungle", "Powderer_Penny" },
    { 27, 1, "Qufim_Island", "Dosetsu_Tree" },
    { 27, 2, "Qufim_Island", "Slippery_Sucker" },
    { 27, 3, "Qufim_Island", "Trickster_Kinetix" },
    { 27, 4, "Qufim_Island", "Atkorkamuy" },
    { 27, 5, "Qufim_Island", "Qoofim" },
    { 28, 1, "Temple_of_Uggalepih", "Bonze_Marberry" },
    { 28, 2, "Temple_of_Uggalepih", "Death_from_Above" },
    { 28, 3, "Temple_of_Uggalepih", "Flauros" },
    { 28, 4, "Temple_of_Uggalepih", "Habetrot" },
    { 28, 5, "Temple_of_Uggalepih", "Manipulator" },
    { 28, 6, "Temple_of_Uggalepih", "Sacrificial_Goblet" },
    { 28, 7, "Temple_of_Uggalepih", "Sozu_Terberry" },
    { 28, 8, "Temple_of_Uggalepih", "Tonberry_Kinq" },
    { 29, 1, "Bibiki_Bay", "Intulo" },
    { 29, 2, "Bibiki_Bay", "Splacknuck" },
    { 29, 3, "Bibiki_Bay", "Shankha" },
    { 29, 4, "Bibiki_Bay", "Serra" },
    { 30, 1, "Carpenters_Landing", "Hercules_Beetle" },
    { 30, 2, "Carpenters_Landing", "Mycophile" },
    { 30, 3, "Carpenters_Landing", "Orctrap" },
    { 30, 4, "Carpenters_Landing", "Tempest_Tigon" },
    { 31, 1, "Uleguerand_Range", "Bonnacon" },
    { 31, 2, "Uleguerand_Range", "Father_Frost" },
    { 31, 3, "Uleguerand_Range", "Geush_Urvan" },
    { 31, 4, "Uleguerand_Range", "Magnotaur" },
    { 31, 5, "Uleguerand_Range", "Mountain_Worm" },
    { 31, 6, "Uleguerand_Range", "Skvader" },
    { 31, 7, "Uleguerand_Range", "Snow_Maiden" },
    { 32, 1, "Attohwa_Chasm", "Ambusher_Antlion" },
    { 32, 2, "Attohwa_Chasm", "Citipati" },
    { 32, 3, "Attohwa_Chasm", "Sargas" },
    { 32, 4, "Attohwa_Chasm", "Sekhmet" },
    { 33, 1, "Oldton_Movalpolos", "Bugbear_Strongman" },
    { 33, 2, "Oldton_Movalpolos", "Goblin_Wolfman" },
    { 33, 3, "Oldton_Movalpolos", "Bugbear_Muscleman" },
    { 34, 1, "Newton_Movalpolos", "Bugbear_Matman" },
    { 34, 2, "Newton_Movalpolos", "Goblin_Collector" },
    { 34, 3, "Newton_Movalpolos", "Sword_Sorcerer_Solisoq" },
    { 34, 4, "Newton_Movalpolos", "Swashstox_Beadblinker" },
    { 35, 1, "Wajaom_Woodlands", "Gharial" },
    { 35, 2, "Wajaom_Woodlands", "Jaded_Jody" },
    { 35, 3, "Wajaom_Woodlands", "Zoraal_Jas_Pkuucha" },
    { 36, 1, "Bhaflau_Thickets", "Emergent_Elm" },
    { 36, 2, "Bhaflau_Thickets", "Harvestman" },
    { 36, 3, "Bhaflau_Thickets", "Mahishasura" },
    { 36, 4, "Bhaflau_Thickets", "Nis_Puk" },
    { 37, 1, "Arrapago_Reef", "Bloody_Bones" },
    { 37, 2, "Arrapago_Reef", "Euryale" },
    { 37, 3, "Arrapago_Reef", "Lamie_No7" },
    { 37, 4, "Arrapago_Reef", "Lamie_No8" },
    { 37, 5, "Arrapago_Reef", "Lamie_No9" },
    { 37, 6, "Arrapago_Reef", "Lamia_No19" },
    { 38, 1, "Mount_Zhayolm", "Chary_Apkallu" },
    { 38, 2, "Mount_Zhayolm", "Energetic_Eruca" },
    { 38, 3, "Mount_Zhayolm", "Fahrafahr_the_Bloodied" },
    { 38, 7, "Mount_Zhayolm", "Ignamoth" },
    { 39, 1, "Halvung", "Copper_Borer" },
    { 39, 2, "Halvung", "Dorgerwor_the_Astute" },
    { 39, 3, "Halvung", "Farlarder_the_Shrewd" },
    { 39, 4, "Halvung", "Flammeri" },
    { 39, 5, "Halvung", "Kirlirger_the_Abhorrent" },
    { 39, 6, "Halvung", "Mythril_Mouth_Monamaq" },
    { 40, 1, "Mamook", "Darting_Kachaal_Ja" },
    { 40, 2, "Mamook", "Devout_Radol_Ja" },
    { 40, 3, "Mamook", "Dragonscaled_Bugaal_Ja" },
    { 40, 4, "Mamook", "Firedance_Magmaal_Ja" },
    { 40, 5, "Mamook", "Hundredfaced_Hapool_Ja" },
    { 40, 6, "Mamook", "Venomfang" },
    { 40, 7, "Mamook", "Zizzy_Zillah" },
    { 41, 1, "Aydeewa_Subterrane", "Bluestreak_Gyugyuroon" },
    { 41, 2, "Aydeewa_Subterrane", "Lizardtrap" },
    { 42, 1, "Alzadaal_Undersea_Ruins", "Boompadu" },
    { 42, 2, "Alzadaal_Undersea_Ruins", "Cookieduster_Lipiroon" },
    { 42, 3, "Alzadaal_Undersea_Ruins", "Oupire" },
    { 43, 1, "Caedarva_Mire", "Aynu-kaysey" },
    { 43, 2, "Caedarva_Mire", "Peallaidh" },
    { 43, 3, "Caedarva_Mire", "Zikko" },
    { 44, 1, "Yughott_Grotto", "Ashmaker_Gotblut" },
    { 45, 1, "Fort_Ghelsba", "Hundredscar_Hajwaj" },
    { 45, 2, "Fort_Ghelsba", "Orcish_Panzer" },
    { 45, 3, "Fort_Ghelsba", "Kegpaunch_Doshgnosh" },
    { 46, 1, "Palborough_Mines", "BuGhi_Howlblade" },
    { 46, 2, "Palborough_Mines", "NoMho_Crimsonarmor" },
    { 46, 3, "Palborough_Mines", "ZiGhi_Boneeater" },
    { 46, 4, "Palborough_Mines", "BeHya_Hundredwall" },
    { 46, 5, "Palborough_Mines", "QuVho_Deathhurler" },
    { 47, 1, "Giddeus", "Eyy_Mon_the_Ironbreaker" },
    { 47, 2, "Giddeus", "Hoo_Mjuu_the_Torrent" },
    { 47, 3, "Giddeus", "Juu_Duzu_the_Whirlwind" },
    { 47, 4, "Giddeus", "Quu_Xijo_the_Illusory" },
    { 47, 5, "Giddeus", "Vuu_Puqu_the_Beguiler" },
    { 47, 6, "Giddeus", "Zhuu_Buxu_the_Silent" },
    { 48, 1, "Beadeaux", "BiGho_Headtaker" },
    { 48, 2, "Beadeaux", "DaDha_Hundredmask" },
    { 48, 3, "Beadeaux", "DeVyu_Headhunter" },
    { 48, 4, "Beadeaux", "GaBhu_Unvanquished" },
    { 48, 5, "Beadeaux", "GeDha_Evileye" },
    { 48, 6, "Beadeaux", "GoBhu_Gascon" },
    { 48, 7, "Beadeaux", "ZoKhu_Blackcloud" },
    { 49, 1, "Davoi", "Blubbery_Bulge" },
    { 49, 2, "Davoi", "Dirtyhanded_Gochakzuk" },
    { 49, 3, "Davoi", "Hawkeyed_Dnatbat" },
    { 49, 4, "Davoi", "Poisonhand_Gnadgad" },
    { 49, 5, "Davoi", "Steelbiter_Gudrud" },
    { 49, 6, "Davoi", "Tigerbane_Bakdak" },
    { 50, 1, "Monastic_Cavern", "Orcish_Hexspinner" },
    { 50, 2, "Monastic_Cavern", "Orcish_Overlord" },
    { 50, 3, "Monastic_Cavern", "Orcish_Warlord" },
    { 50, 4, "Monastic_Cavern", "Overlord_Bakgodek" },
    { 51, 1, "Castle_Oztroja", "Moo_Ouzi_the_Swiftblade" },
    { 51, 2, "Castle_Oztroja", "Mee_Deggi_the_Punisher" },
    { 51, 3, "Castle_Oztroja", "Quu_Domi_the_Gallant" },
    { 51, 4, "Castle_Oztroja", "Saa_Doyi_the_Fervid" },
    { 51, 5, "Castle_Oztroja", "Yaa_Haqa_the_Profane" },
    { 51, 6, "Castle_Oztroja", "Yagudo_High_Priest" },
    { 51, 7, "Castle_Oztroja", "Yagudo_Templar" },
    { 51, 8, "Castle_Oztroja", "Lii_Jixa_the_Somnolist" },
    { 52, 1, "The_Boyahda_Tree", "Ancient_Goobbue" },
    { 52, 2, "The_Boyahda_Tree", "Aquarius" },
    { 52, 3, "The_Boyahda_Tree", "Ellyllon" },
    { 52, 4, "The_Boyahda_Tree", "Leshonki" },
    { 52, 5, "The_Boyahda_Tree", "Unut" },
    { 52, 6, "The_Boyahda_Tree", "Voluptuous_Vivian" },
    { 53, 1, "Lower_Delkfutts_Tower", "Epialtes" },
    { 53, 2, "Lower_Delkfutts_Tower", "Eurymedon" },
    { 53, 3, "Lower_Delkfutts_Tower", "Hippolytos" },
    { 53, 4, "Lower_Delkfutts_Tower", "Tyrant" },
    { 54, 1, "Middle_Delkfutts_Tower", "Eurytos" },
    { 54, 2, "Middle_Delkfutts_Tower", "Ogygos" },
    { 54, 3, "Middle_Delkfutts_Tower", "Ophion" },
    { 54, 4, "Middle_Delkfutts_Tower", "Polybotes" },
    { 54, 5, "Middle_Delkfutts_Tower", "Rhoikos" },
    { 54, 6, "Middle_Delkfutts_Tower", "Rhoitos" },
    { 55, 1, "Upper_Delkfutts_Tower", "Alkyoneus" },
    { 55, 2, "Upper_Delkfutts_Tower", "Enkelados" },
    { 55, 3, "Upper_Delkfutts_Tower", "Ixtab" },
    { 55, 4, "Upper_Delkfutts_Tower", "Mimas" },
    { 55, 5, "Upper_Delkfutts_Tower", "Pallas" },
    { 55, 6, "Upper_Delkfutts_Tower", "Porphyrion" },
    { 55, 7, "Upper_Delkfutts_Tower", "Autarch" },
    { 56, 1, "Den_of_Rancor", "Bistre-hearted_Malberry" },
    { 56, 2, "Den_of_Rancor", "Carmine-tailed_Janberry" },
    { 56, 3, "Den_of_Rancor", "Celeste-eyed_Tozberry" },
    { 56, 4, "Den_of_Rancor", "Friar_Rush" },
    { 56, 5, "Den_of_Rancor", "Ogama" },
    { 56, 6, "Den_of_Rancor", "Sozu_Bliberry" },
    { 56, 7, "Den_of_Rancor", "Tawny-fingered_Mugberry" },
    { 56, 8, "Den_of_Rancor", "Tonberry_Decapitator" },
    { 56, 9, "Den_of_Rancor", "Tonberry_Pontifex" },
    { 56, 10, "Den_of_Rancor", "Tonberry_Tracker" },
    { 57, 1, "Castle_Zvahl_Baileys", "Duke_Haborym" },
    { 57, 2, "Castle_Zvahl_Baileys", "Grand_Duke_Batym" },
    { 57, 3, "Castle_Zvahl_Baileys", "Likho" },
    { 57, 4, "Castle_Zvahl_Baileys", "Marquis_Allocen" },
    { 57, 5, "Castle_Zvahl_Baileys", "Marquis_Naberius" },
    { 57, 6, "Castle_Zvahl_Baileys", "Marquis_Sabnock" },
    { 58, 1, "Castle_Zvahl_Keep", "Baron_Vapula" },
    { 58, 2, "Castle_Zvahl_Keep", "Baronet_Romwe" },
    { 58, 3, "Castle_Zvahl_Keep", "Count_Bifrons" },
    { 58, 4, "Castle_Zvahl_Keep", "Viscount_Morax" },
    { 59, 1, "Ranguemont_Pass", "Mucoid_Mass" },
    { 59, 2, "Ranguemont_Pass", "Gloom_Eye" },
    { 59, 3, "Ranguemont_Pass", "Hyakume" },
    { 60, 1, "Bostaunieux_Oubliette", "Arioch" },
    { 60, 2, "Bostaunieux_Oubliette", "Bloodsucker" },
    { 60, 3, "Bostaunieux_Oubliette", "Manes" },
    { 60, 4, "Bostaunieux_Oubliette", "Sewer_Syrup" },
    { 60, 5, "Bostaunieux_Oubliette", "Shii" },
    { 61, 1, "Toraimarai_Canal", "Canal_Moocher" },
    { 61, 2, "Toraimarai_Canal", "Brazen_Bones" },
    { 61, 3, "Toraimarai_Canal", "Konjac" },
    { 62, 1, "Korroloka_Tunnel", "Cargo_Crab_Colin" },
    { 62, 2, "Korroloka_Tunnel", "Dame_Blanche" },
    { 62, 3, "Korroloka_Tunnel", "Falcatus_Aranei" },
    { 62, 4, "Korroloka_Tunnel", "Morion_Worm" },
    { 62, 5, "Korroloka_Tunnel", "Thoon" },
    { 63, 1, "Kuftal_Tunnel", "Amemet" },
    { 63, 2, "Kuftal_Tunnel", "Arachne" },
    { 63, 3, "Kuftal_Tunnel", "Bloodthirster_Madkix" },
    { 63, 4, "Kuftal_Tunnel", "Cancer" },
    { 63, 5, "Kuftal_Tunnel", "Guivre" },
    { 63, 6, "Kuftal_Tunnel", "Pelican" },
    { 63, 7, "Kuftal_Tunnel", "Phantom_Worm" },
    { 63, 8, "Kuftal_Tunnel", "Sabotender_Mariachi" },
    { 63, 9, "Kuftal_Tunnel", "Yowie" },
    { 64, 1, "The_Eldieme_Necropolis", "Cwn_Cyrff" },
    { 64, 2, "The_Eldieme_Necropolis", "Skull_of_Envy" },
    { 64, 3, "The_Eldieme_Necropolis", "Skull_of_Gluttony" },
    { 64, 4, "The_Eldieme_Necropolis", "Skull_of_Greed" },
    { 64, 5, "The_Eldieme_Necropolis", "Skull_of_Lust" },
    { 64, 6, "The_Eldieme_Necropolis", "Skull_of_Pride" },
    { 64, 7, "The_Eldieme_Necropolis", "Skull_of_Sloth" },
    { 64, 8, "The_Eldieme_Necropolis", "Skull_of_Wrath" },
    { 65, 1, "Sea_Serpent_Grotto", "Abyss_Sahagin" },
    { 65, 2, "Sea_Serpent_Grotto", "Coral_Sahagin" },
    { 65, 3, "Sea_Serpent_Grotto", "Denn_the_Orcavoiced" },
    { 65, 4, "Sea_Serpent_Grotto", "Fyuu_the_Seabellow" },
    { 65, 5, "Sea_Serpent_Grotto", "Masan" },
    { 65, 6, "Sea_Serpent_Grotto", "Mouu_the_Waverider" },
    { 65, 7, "Sea_Serpent_Grotto", "Namtar" },
    { 65, 8, "Sea_Serpent_Grotto", "Novv_the_Whitehearted" },
    { 65, 9, "Sea_Serpent_Grotto", "Ocean_Sahagin" },
    { 65, 10, "Sea_Serpent_Grotto", "Pahh_the_Gullcaller" },
    { 65, 11, "Sea_Serpent_Grotto", "Qull_the_Shellbuster" },
    { 65, 12, "Sea_Serpent_Grotto", "Seww_the_Squidlimbed" },
    { 65, 13, "Sea_Serpent_Grotto", "Voll_the_Sharkfinned" },
    { 65, 14, "Sea_Serpent_Grotto", "Worr_the_Clawfisted" },
    { 65, 15, "Sea_Serpent_Grotto", "Wuur_the_Sandcomber" },
    { 65, 16, "Sea_Serpent_Grotto", "Yarr_the_Pearleyed" },
    { 65, 17, "Sea_Serpent_Grotto", "Zuug_the_Shoreleaper" },
    { 66, 1, "Dangruf_Wadi", "Chocoboleech" },
    { 66, 2, "Dangruf_Wadi", "Geyser_Lizard" },
    { 66, 3, "Dangruf_Wadi", "Teporingo" },
    { 67, 1, "Inner_Horutoto_Ruins", "Maltha" },
    { 67, 2, "Inner_Horutoto_Ruins", "Nocuous_Weapon" },
    { 67, 3, "Inner_Horutoto_Ruins", "Slendlix_Spindlethumb" },
    { 68, 1, "Outer_Horutoto_Ruins", "Bomb_King" },
    { 68, 2, "Outer_Horutoto_Ruins", "Doppelganger_Dio" },
    { 68, 3, "Outer_Horutoto_Ruins", "Doppelganger_Gog" },
    { 68, 4, "Outer_Horutoto_Ruins", "Legalox_Heftyhind" },
    { 68, 5, "Outer_Horutoto_Ruins", "Ah_Puch" },
    { 68, 6, "Outer_Horutoto_Ruins", "Desmodont" },
    { 69, 1, "Ordelles_Caves", "Bombast" },
    { 69, 2, "Ordelles_Caves", "Donggu" },
    { 69, 3, "Ordelles_Caves", "Agar_Agar" },
    { 70, 1, "Gusgen_Mines", "Asphyxiated_Amsel" },
    { 70, 2, "Gusgen_Mines", "Burned_Bergmann" },
    { 70, 3, "Gusgen_Mines", "Crushed_Krause" },
    { 70, 4, "Gusgen_Mines", "Juggler_Hecatomb" },
    { 70, 5, "Gusgen_Mines", "Pulverized_Pfeffer" },
    { 70, 6, "Gusgen_Mines", "Smothered_Schmidt" },
    { 70, 7, "Gusgen_Mines", "Wounded_Wurfel" },
    { 71, 1, "Crawlers_Nest", "Aqrabuamelu" },
    { 71, 2, "Crawlers_Nest", "Awd_Goggie" },
    { 71, 3, "Crawlers_Nest", "Demonic_Tiphia" },
    { 71, 4, "Crawlers_Nest", "Drone_Crawler" },
    { 71, 5, "Crawlers_Nest", "Dynast_Beetle" },
    { 71, 6, "Crawlers_Nest", "Guardian_Crawler" },
    { 71, 7, "Crawlers_Nest", "Matron_Crawler" },
    { 72, 1, "Maze_of_Shakhrami", "Lesath" },
    { 72, 2, "Maze_of_Shakhrami", "Gloombound_Lurker" },
    { 72, 3, "Maze_of_Shakhrami", "Trembler_Tabitha" },
    { 73, 1, "Garlaige_Citadel", "Frogamander" },
    { 73, 2, "Garlaige_Citadel", "Hazmat" },
    { 73, 3, "Garlaige_Citadel", "Old_Two-Wings" },
    { 73, 4, "Garlaige_Citadel", "Hovering_Hotpot" },
    { 74, 1, "FeiYin", "Eastern_Shadow" },
    { 74, 2, "FeiYin", "Goliath" },
    { 74, 3, "FeiYin", "Jenglot" },
    { 74, 4, "FeiYin", "Mind_Hoarder" },
    { 74, 5, "FeiYin", "Northern_Shadow" },
    { 74, 6, "FeiYin", "Sluagh" },
    { 74, 7, "FeiYin", "Southern_Shadow" },
    { 74, 8, "FeiYin", "Western_Shadow" },
    { 75, 1, "Ifrits_Cauldron", "Bomb_Queen" },
    { 75, 2, "Ifrits_Cauldron", "Foreseer_Oramix" },
    { 75, 3, "Ifrits_Cauldron", "Lindwurm" },
    { 75, 4, "Ifrits_Cauldron", "Tarasque" },
    { 75, 5, "Ifrits_Cauldron", "Tyrannic_Tunnok" },
    { 75, 6, "Ifrits_Cauldron", "Vouivre" },
    { 76, 1, "Quicksand_Caves", "Antican_Consul" },
    { 76, 2, "Quicksand_Caves", "Antican_Legatus" },
    { 76, 3, "Quicksand_Caves", "Antican_Magister" },
    { 76, 4, "Quicksand_Caves", "Antican_Praefectus" },
    { 76, 5, "Quicksand_Caves", "Antican_Praetor" },
    { 76, 6, "Quicksand_Caves", "Antican_Proconsul" },
    { 76, 7, "Quicksand_Caves", "Antican_Tribunus" },
    { 76, 8, "Quicksand_Caves", "Centurio_X-I" },
    { 76, 9, "Quicksand_Caves", "Diamond_Daig" },
    { 76, 10, "Quicksand_Caves", "Hastatus_XI-XII" },
    { 76, 11, "Quicksand_Caves", "Nussknacker" },
    { 76, 12, "Quicksand_Caves", "Proconsul_XII" },
    { 76, 13, "Quicksand_Caves", "Sabotender_Bailarin" },
    { 76, 14, "Quicksand_Caves", "Sabotender_Bailarina" },
    { 76, 15, "Quicksand_Caves", "Sagittarius_X-XIII" },
    { 76, 16, "Quicksand_Caves", "Triarius_X-XV" },
    { 76, 17, "Quicksand_Caves", "Tribunus_VII-I" },
    { 77, 1, "Gustav_Tunnel", "Amikiri" },
    { 77, 2, "Gustav_Tunnel", "Baobhan_Sith" },
    { 77, 3, "Gustav_Tunnel", "Bune" },
    { 77, 4, "Gustav_Tunnel", "Goblinsavior_Heronox" },
    { 77, 5, "Gustav_Tunnel", "Taxim" },
    { 77, 6, "Gustav_Tunnel", "Ungur" },
    { 77, 7, "Gustav_Tunnel", "Wyvernpoacher_Drachlox" },
    { 78, 1, "Labyrinth_of_Onzozo", "Hellion" },
    { 78, 2, "Labyrinth_of_Onzozo", "Mysticmaker_Profblix" },
    { 78, 3, "Labyrinth_of_Onzozo", "Narasimha" },
    { 78, 4, "Labyrinth_of_Onzozo", "Ose" },
    { 78, 5, "Labyrinth_of_Onzozo", "Peg_Powler" },
    { 78, 6, "Labyrinth_of_Onzozo", "Soulstealer_Skullnix" },
    { 79, 1, "AlTaieu", "Omyovra" },
    { 79, 2, "AlTaieu", "Ulyovra" },
    { 80, 1, "Lufaise_Meadows", "Amaltheia" },
    { 80, 2, "Lufaise_Meadows", "Megalobugard" },
    { 80, 3, "Lufaise_Meadows", "Flockbock" },
    { 80, 4, "Lufaise_Meadows", "Sengann" },
    { 80, 5, "Lufaise_Meadows", "Yal-un_Eke" },
    { 81, 1, "Misareaux_Coast", "Goaftrap" },
    { 81, 2, "Misareaux_Coast", "Gration" },
    { 81, 3, "Misareaux_Coast", "Odqan" },
    { 81, 4, "Misareaux_Coast", "Okyupete" },
    { 81, 5, "Misareaux_Coast", "Upyri" },
    { 81, 6, "Misareaux_Coast", "Ziphius" },
    { 82, 1, "Phomiuna_Aqueducts", "Tres_Duendes" },
    { 82, 2, "Phomiuna_Aqueducts", "Eba" },
    { 82, 3, "Phomiuna_Aqueducts", "Mahisha" },
    { 83, 1, "Sacrarium", "Elel" },
    { 84, 1, "Riverne-Site_A01", "Aiatar" },
    { 84, 2, "Riverne-Site_A01", "Heliodromos" },
    { 84, 3, "Riverne-Site_A01", "Shieldtrap" },
    { 85, 1, "Riverne-Site_B01", "Boroka" },
    { 85, 2, "Riverne-Site_B01", "Imdugud" },
    { 85, 3, "Riverne-Site_B01", "Unstable_Cluster" }
}

local pathWithFilename = io.popen("cd"):read'*all'

-- Checks to validate that the file exists before trying to override it
for _, entry in pairs(dailyNMs) do
    local zoneName    = entry[3]
    local mobName     = entry[4]
    
    local filename = pathWithFilename:sub(1, -2) .. string.format("\\scripts\\zones\\%s\\mobs\\%s", zoneName, mobName) .. ".lua"
    local exists = io.open(filename,"r")
    if exists ~= nil then
        io.close(exists)
    else
        xi.module.ensureTable(string.format("xi.zones.%s.mobs.%s", zoneName, mobName))
    end
end

-- Apply the override to each NM's onMobDeath function
for _, entry in pairs(dailyNMs) do
    local zoneNum     = entry[1]
    local nmNum       = entry[2]
    local zoneName    = entry[3]
    local mobName     = entry[4]
    local mobLuaFile  = string.format("xi.zones.%s.mobs.%s.onMobDeath", zoneName, mobName)

    -- Create the override
    m:addOverride(mobLuaFile, function(mob, player, optParams)
        super(mob, player, optParams)
        
        if player ~= nil then
            local dailyQuestActive = player:getCharVar("[DQ]Saltlik")
            local dailyZone        = player:getCharVar("[DQ]Saltlik_Z")
            local dailyNM          = player:getCharVar("[DQ]Saltlik_NM")
        
            -- If they actual assigned assigned to kill these mobs
            if
                dailyQuestActive == 1 and
                dailyZone == zoneNum and
                dailyNM == nmNum
            then
                -- Advance the quest and tell them to return to the NPC for reward
                player:setCharVar("[DQ]Saltlik",2)
                player:printToPlayer(string.format("You've killed %s, please return to Saltlix to claim your reward!",mob:getName():gsub("_", " ")), 17)
            end
        end
    end)
end

return m
