-----------------------------------
-- Daily Quest : Murdox
-- Kill 'x' amount of 'y' types of mobs in a certain zone
-----------------------------------
require("modules/module_utils")
require("scripts/zones/Lower_Jeuno/Zone")
local ID = require("scripts/zones/Lower_Jeuno/IDs")
-----------------------------------
local m = Module:new("daily_quest_murdox")

m:addOverride("xi.zones.Lower_Jeuno.Zone.onInitialize", function(zone)

    super(zone)

    -- This table is for all the different quest zones and TYPES of mobs they will need to kill in printable format for displaying to the player
    local questLocations =
    {
        -- [index] | Zone Name | Mob Types
        {"West Ronfaure",            {"Bats", "Beetles", "Crabs", "Funguar", "Goblins", "Orcs", "Rabbits", "Sheep", "Worms"}},
        {"East Ronfaure",            {"Bats", "Beetles", "Funguar", "Goblins", "Orcs", "Pugils", "Rabbits", "Sheep", "Worms"}},
        {"South Gustaberg",          {"Bats", "Bees", "Birds", "Crabs", "Goblins", "Lizards", "Quadav", "Saplings", "Sheep", "Worms"}},
        {"North Gustaberg",          {"Bats", "Bees", "Birds", "Crabs", "Goblins", "Lizards", "Pugils", "Quadav", "Saplings", "Sheep", "Worms"}},
        {"West Sarutabaruta",        {"Bees", "Birds", "Crabs", "Crawlers", "Goblins", "Mandragora", "Rabbits", "Yagudo"}},
        {"East Sarutabaruta",        {"Bees", "Birds", "Crabs", "Crawlers", "Goblins", "Mandragora", "Pugils", "Rabbits", "Yagudo"}},
        {"La Theine Plateau",        {"Bats", "Bees", "Crabs", "Funguars", "Goblins", "Orcs", "Rabbits", "Saplings", "Worms"}},
        {"Konschtat Highlands",      {"Bees", "Goblins", "Lizards", "Quadav", "Saplings", "Sheep", "Worms"}},
        {"Tahrongi Canyon",          {"Bees", "Birds", "Crawlers", "Dhalmel", "Goblins", "Mandragora", "Rabbits", "Saplings", "Yagudo"}},
        {"Valkurm Dunes",            {"Bats", "Crabs", "Flies", "Goblins", "Leeches", "Lizards", "Pugils", "Rabbits", "Sheep"}},
        {"Jugner Forest",            {"Beetles", "Birds", "Crabs", "Evil Weapons", "Funguars", "Goblins", "Leeches", "Orcs", "Pugils", "Saplings", "Sheep", "Tigers"}},
        {"Batallia Downs",           {"Birds", "Crabs", "Flies", "Goblins", "Hounds", "Orcs", "Saplings", "Tigers"}},
        {"Pashhow Marshlands",       {"Bats", "Bees", "Crabs", "Crawlers", "Flies", "Funguars", "Goblins", "Goobbues", "Hounds", "Leeches", "Morbols", "Pugils", "Quadav", "Rabbits"}},
        {"Rolanberry Fields",        {"Bats", "Bees", "Crabs", "Crawlers", "Goblins", "Goobbues", "Leeches", "Morbols", "Quadav"}},
        {"Sauromugue Champaign",     {"Bats", "Beetles", "Cockatrice", "Coeurls", "Evil Weapons", "Goblins", "Lizards", "Raptors", "Yagudo"}},
        {"Beaucedine Glacier",       {"Ahriman", "Dolls", "Gigas", "Goblins", "Golems", "Tigers"}},
        {"Xarcabard",                {"Ahriman", "Demons", "Evil Weapons", "Ghosts", "Gigas", "Skeletons"}},
        {"Cape Teriggan",            {"Cockatrice", "Crabs", "Goblins", "Lizards", "Manticores", "Pugils", "Rabbits", "Raptors"}},
        {"Eastern Altepa Desert",    {"Antica", "Beetles", "Dhalmel", "Goblins", "Manticores", "Rocs", "Sabotenders", "Scorpions", "Spiders", "Worms"}},
        {"Western Altepa Desert",    {"Antica", "Beetles", "Dhalmel", "Manticores", "Rocs", "Sabotenders", "Scorpions", "Spiders", "Worms"}},
        {"Meriphataud Mountains",    {"Bats", "Birds", "Beetles", "Cockatrice", "Coeurls", "Evil Weapons", "Flies", "Goblins", "Lizards", "Raptors", "Saplings", "Yagudo"}},
        {"Buburimu Peninsula",       {"Birds", "Crabs", "Crawlers", "Dhalmel", "Goblins", "Leeches", "Mandragora", "Pugils", "Rabbits"}},
        {"The Sanctuary of Zi'Tah",  {"Bats", "Coeurls", "Flies", "Funguars", "Goblins", "Golems", "Goobbues", "Leeches"}},
        {"Ro'Maeve",                 {"Dolls", "Evil Weapons", "Golems", "Magic Pots"}},
        {"Yuhtunga Jungle",          {"Bees", "Crawlers", "Goblins", "Lizards", "Mandragora", "Opo-opo", "Pugils", "Sahagin"}},
        {"Yhoator Jungle",           {"Bees", "Coeurls", "Crawlers", "Goblins", "Lizards", "Mandragora", "Morbols", "Opo-opo", "Pugils", "Tonberries"}},
        {"Qufim Island",             {"Bats", "Crabs", "Evil Weapons", "Gigas", "Leeches", "Pugils", "Worms"}},
        {"Temple of Uggalepih",      {"Bees", "Coeurls", "Crawlers", "Dolls", "Magic Pots", "Opo-opo", "Tonberries"}},
        {"Valley of Sorrows",        {"Manticores", "Raptors", "Rocs"}},
        {"Bibiki Bay",               {"Birds", "Crabs", "Dhalmel", "Efts", "Goblins", "Mandragora", "Opo-opo", "Rabbits", "Slimes", "Uragnites"}},
        {"Carpenter's Landing",      {"Beetles", "Bees", "Flytraps", "Funguars", "Orcs", "Pugils", "Tigers"}},
        {"Uleguerand Range",         {"Ahriman", "Bats", "Buffalo", "Demons", "Hecteyes", "Rabbits", "Raptors", "Snolls", "Tauri", "Tigers", "Worms"}},
        {"Attohwa Chasm",            {"Antlions", "Coeurls", "Flies", "Goblins", "Hecteyes", "Lizards", "Scorpions", "Worms"}},
        {"Oldton Movalpolos",        {"Bats", "Bugbears", "Goblins", "Moblins"}},
        {"Newton Movalpolos",        {"Bats", "Bugbears", "Moblins"}},
        {"Wajaom Woodlands",         {"Bees", "Colibri", "Fomors", "Leeches", "Mamool Ja", "Marids", "Morbols", "Puks", "Saplings", "Spiders", "Tigers", "Treants"}},
        {"Bhaflau Thickets",         {"Colibri", "Fomors", "Mamool Ja", "Marids", "Puks", "Saplings", "Spiders", "Tigers", "Trolls", "Treants", "Wivre"}},
        {"Arrapago Reef",            {"Apkallu", "Bats", "Crabs", "Doomed", "Fomors", "Ghosts", "Lamiae", "Leeches", "Qutrub", "Sea Monks", "Skeletons", "Soulflayers"}},
        {"Mount Zhayolm",            {"Apkallu", "Crabs", "Crawlers", "Flans", "Flies", "Ghosts", "Pugil", "Slime", "Troll", "Wamouracampa"}},
        {"Halvung",                  {"Bombs", "Crawlers", "Flans", "Scorpions", "Trolls", "Wamouracampa"}},
        {"Mamook",                   {"Cockatrice", "Colibri", "Lizards", "Mamool Ja", "Pugils", "Puks", "Raptors", "Spiders"}},
        {"Aydeewa Subterrane",       {"Chigoes", "Crawlers", "Diremites", "Flytraps", "Leeches", "Qiqirn", "Saplings", "Slimes", "Tigers", "Worms"}},
        {"Alzadaal Undersea Ruins",  {"Qiqirn"}},
        {"Caedarva Mire",            {"Birds", "Chigoes", "Doomed", "Flies", "Imps", "Leeches", "Qutrub", "Saplings", "Soulflayers"}},
        {"Yughott Grotto",           {"Bats", "Orcs"}},
        {"Fort Ghelsba",             {"Lizards", "Orcish Warmachines", "Orcs"}},
        {"Palborough Mines",         {"Beetles", "Funguars", "Quadav", "Rabbits"}},
        {"Giddeus",                  {"Bees", "Pugils", "Worms", "Yagudo"}},
        {"Beadeaux",                 {"Crawlers", "Pugils", "Quadav", "Sheep"}},
        {"Davoi",                    {"Bees", "Bats", "Lizards", "Orcs", "Pugils"}},
        {"Monastic Cavern",          {"Orcs"}},
        {"Castle Oztroja",           {"Bats", "Yagudo"}},
        {"The Boyahda Tree",         {"Crabs", "Crawlers", "Flies", "Funguars", "Goobbues", "Mandragora", "Rabbits", "Spiders"}},
        {"Lower Delkfutt's Tower",   {"Bats", "Gigas", "Goblins"}},
        {"Middle Delkfutt's Tower",  {"Bats","Gigas", "Goblins"}},
        {"Upper Delkfutt's Tower",   {"Bats", "Gigas"}},
        {"Den of Rancor",            {"Bats", "Hecteyes", "Slimes", "Mandragora", "Tonberries", "Lizards"}},
        {"Castle Zvahl Baileys",     {"Ahriman", "Demons", "Goblins", "Orcs", "Quadav", "Yagudo"}},
        {"Castle Zvahl Keep",        {"Ahriman", "Demons", "Goblins", "Orcs", "Quadav", "Yagudo"}},
        {"Ranguemont Pass",          {"Bats", "Goblins", "Hecteyes"}},
        {"Bostaunieux Oubliette",    {"Bats", "Hounds", "Leeches", "Slimes"}},
        {"Toraimarai Canal",         {"Bats", "Crabs", "Leeches", "Pugils", "Skeletons"}},
        {"Zeruhn Mines",             {"Bats", "Crabs", "Worms"}},
        {"Korroloka Tunnel",         {"Bats", "Crabs", "Gigas", "Goblins", "Leeches", "Pugils", "Spiders", "Worms"}},
        {"Kuftal Tunnel",            {"Crabs", "Goblins", "Lizards", "Raptors", "Sabotenders", "Spiders", "Tigers", "Worms"}},
        {"The Eldieme Necropolis",   {"Ghosts", "Hounds", "Shadows", "Skeletons"}},
        {"Sea Serpent Grotto",       {"Bats", "Crabs", "Leeches", "Pugils", "Sahagin", "Sea Monks", "Skeletons"}},
        {"Dangruf Wadi",             {"Crabs", "Goblins", "Leeches", "Lizards", "Opo-opo", "Rabbits", "Worms"}},
        {"Inner Horutoto Ruins",     {"Bats", "Evil Weapons", "Goblins", "Skeletons"}},
        {"Outer Horutoto Ruins",     {"Bats", "Cardians", "Goblins"}},
        {"Ordelle's Caves",          {"Bats", "Beetles", "Funguars", "Goblins", "Leeches", "Rabbits", "Saplings"}},
        {"Gusgen Mines",             {"Flies", "Funguars", "Ghosts", "Hounds", "Skeletons", "Worms"}},
        {"Crawler's Nest",           {"Bees", "Beetles", "Crawlers", "Flies", "Funguars", "Lizards", "Saplings"}},
        {"Maze of Shakhrami",        {"Bats", "Crawlers", "Goblins", "Leeches", "Scorpions", "Skeletons", "Worms"}},
        {"Garlaige Citadel",         {"Bats", "Beetles", "Bombs", "Evil Weapons", "Ghosts", "Magic Pots", "Skeletons"}},
        {"Fei'Yin",                  {"Bats", "Dolls", "Ghosts", "Magic Pots", "Shadows"}},
        {"Ifrit's Cauldron",         {"Bats", "Bombs", "Goblins", "Opo-opo", "Raptors"}},
        {"Quicksand Caves",          {"Antica", "Beetles", "Lizards", "Sabotenders", "Spiders", "Worms"}},
        {"Gustav Tunnel",            {"Crabs", "Flies", "Goblins", "Pugils", "Skeletons", "Worms"}},
        {"Labyrinth of Onzozo",      {"Cockatrice", "Coeurls", "Goblins", "Scorpions", "Sea Monks"}},
        {"Dynamis - Bastok",         {"Quadav"}},
        {"Dynamis - San d'Oria",     {"Orc"}},
        {"Dynamis - Windurst",       {"Yagudo"}},
        {"Dynamis - Jeuno",          {"Goblin"}},
        {"Dynamis - Beaucedine",     {"Goblin", "Hydra", "Orc", "Quadav", "Yagudo"}},
        {"Dynamis - Xarcabard",      {"Demon"}},
        {"Ru'Aun Gardens",           {"Birds", "Dolls", "Magic Pots"}},
        {"Ve'Lugannon Palace",       {"Evil Weapons", "Golems", "Magic Pots", "Spheroids"}},
        {"The Shrine of Ru'Avitau",  {"Dolls", "Evil Weapons", "Golems", "Magic Pots", "Spheroids"}},
        {"Al'Taieu",                 {"Aern", "Hpemde", "Phuabo", "Xzomit"}},
        {"Grand Palace of Hu'Xzoi",  {"Aern", "Euvhi", "Ghrah", "Zdei"}},
        {"The Garden of Ru'Hmet",    {"Aern", "Euvhi", "Ghrah", "Zdei"}},
        {"Lufaise Meadows",          {"Bees", "Bugards", "Fomors", "Gigas", "Orcs", "Rocs", "Sheep"}},
        {"Misareaux Coast",          {"Bees", "Bugards", "Fomors", "Gigas", "Orcs", "Pugils", "Sheep"}},

        -- Level capped areas for CW and WEW
        -- {"Phomiuna Aqueducts",       {"Diremites", "Fomors", "Pugils", "Tauri"}},
        -- {"Sacrarium",                {"Fomors", "Skeletons", "Spiders", "Tauri"}},
        -- {"Riverne Site-A01",         {"Birds", "Clusters", "Flies", "Flytraps", "Hippogryphs", "Wyverns"}},
        -- {"Riverne Site-B01",         {"Clusters", "Hippogryphs", "Morbols", "Rocs", "Wyverns"}},

        -- Unreleased areas
        -- {"Escha - Zi'Tah",           {"Bees", "Bugards", "Coeurls", "Corses", "Crawlers", "Dhalmels", "Dragons", "Efts", "Opo-opo", "Puks"}},
        -- {"Escha - Ru'Aun",           {"Aern", "Amoeban", "Clionidae", "Euvhi", "Gargouilles", "Ghrah", "Hpemde", "Limule", "Murex", "Phuabo", "Porxies", "Xzomit", "Yovra", "Zdei"}}
    }

    -- Handles the functionality of the "daily reset" at midnight
    local handleMidnight = function(player)
        local questMidnight = player:getCharVar("[DQ]Midnight")
        local currentMidnight = getMidnight()

        -- handle first time quest midnight
        if questMidnight == 0 then
            player:setCharVar("[DQ]Midnight", currentMidnight)
            player:setCharVar("[DQ]Completed", 0)
            player:setCharVar("[DQ]Reset", 0)
            player:setCharVar("[DQ]Fishstix", 0)
            player:setCharVar("[DQ]Fishstix_Z", 0)
            player:setCharVar("[DQ]Murdoc", 0)
            player:setCharVar("[DQ]Murdoc_Z", 0)
            player:setCharVar("[DQ]Murdoc_MT", 0)
            player:setCharVar("[DQ]Murdoc_KA", 0)
            player:setCharVar("[DQ]Mistrix", 0)
            player:setCharVar("[DQ]Mistrix_I", 0)
            player:setCharVar("[DQ]Saltlik", 0)
            player:setCharVar("[DQ]Saltlik_Z", 0)
            player:setCharVar("[DQ]Saltlik_NM", 0)
            player:setCharVar("[DQ]Beetrix", 0)
            player:setCharVar("[DQ]Beetrix_Z", 0)
            player:setCharVar("[DQ]Beetrix_RE", 0)
        end
        
        -- handle midnight reset
        if currentMidnight ~= questMidnight then
            player:setCharVar("[DQ]Midnight", currentMidnight)
            player:setCharVar("[DQ]Completed", 0)
            player:setCharVar("[DQ]Reset", 0)
            player:setCharVar("[DQ]Fishstix", 0)
            player:setCharVar("[DQ]Fishstix_Z", 0)
            player:setCharVar("[DQ]Murdoc", 0)
            player:setCharVar("[DQ]Murdoc_Z", 0)
            player:setCharVar("[DQ]Murdoc_MT", 0)
            player:setCharVar("[DQ]Murdoc_KA", 0)
            player:setCharVar("[DQ]Mistrix", 0)
            player:setCharVar("[DQ]Mistrix_I", 0)
            player:setCharVar("[DQ]Saltlik", 0)
            player:setCharVar("[DQ]Saltlik_Z", 0)
            player:setCharVar("[DQ]Saltlik_NM", 0)
            player:setCharVar("[DQ]Beetrix", 0)
            player:setCharVar("[DQ]Beetrix_Z", 0)
            player:setCharVar("[DQ]Beetrix_RE", 0)
        end
    end

    -- Adds the NPC into Lower Jeuno
    local murdoc = zone:insertDynamicEntity({

        objtype = xi.objType.NPC,
        name = "Murdox",
        look = 491,
        x = -50.7539,
        y = 0.000,
        z = -61.6961,
        rotation = 213,
        widescan = 1,

        -- Handles the ability to reset daily quest for 50k gil
        onTrade = function(player, npc, trade)
            -- Check to see if daily reset needs to happen first
            handleMidnight(player)
            npc:facePlayer(player, true)

            local gil = trade:getGil()
            local questStage = player:getCharVar("[DQ]Murdoc")
            local resetCount = player:getCharVar("[DQ]Reset")
            local cost = 50000

            if player:isCrystalWarrior() then
                cost = 15000
            end

            -- If the player makes a trade with 50k gil
            if gil == cost then
                -- If they trade something else besides gil
                if trade:getItemCount() ~= 1 then
                    player:printToPlayer("I only accept gil as payment.", 0, npc:getPacketName())
                    return
                else
                    -- If the daily is already not given out, no need to reset
                    if questStage == 0 then
                        player:printToPlayer("You don't need to reset this daily, the quest has not been given yet.", 0, npc:getPacketName())
                        return
                    -- If the daily is already completed, no reset allowed
                    elseif questStage == 3 then
                        player:printToPlayer("You can't reset a completed daily. Come back tomorrow for more.", 0, npc:getPacketName())
                        return
                    else
                        -- If they've already done their 3 resets a day, no more reset allowed
                        if resetCount >= 3 then
                            player:printToPlayer("You can only reset a daily quest a max of 3 times per day across ALL dailies. Come back tomorrow for more.", 0, npc:getPacketName())
                            return
                        else
                            -- If it's a valid reset, reset the daily
                            player:tradeComplete()
                            player:setCharVar("[DQ]Reset", resetCount + 1)
                            player:setCharVar("[DQ]Murdoc", 0)
                            player:setCharVar("[DQ]Murdoc_Z", 0)
                            player:setCharVar("[DQ]Murdoc_MT", 0)
                            player:setCharVar("[DQ]Murdoc_KA", 0)
                            player:printToPlayer(string.format("You have successfully reset my daily quest. Resets remaining today: %d.",(3 - (resetCount + 1))), 0, npc:getPacketName())
                        end
                    end
                end
            else
                player:printToPlayer(string.format("You can trade me %u gil to reset this daily quest (3 resets a day max across all dailies).", cost), 0, npc:getPacketName())
            end
        end,

        -- This handles assigning the quest and handling setting the reward for quest completion
        onTrigger = function(player, npc)
            -- Check to see if daily reset needs to happen first
            handleMidnight(player)
            -- What "stage" of the quest they're on
            local questStage = player:getCharVar("[DQ]Murdoc")
            -- Used later to keep a count of how many completed quests a day
            local completedDailyQuests = player:getCharVar("[DQ]Completed")
            
            -- Handle quest stages
            -- Quest hasn't been started yet, assign a random zone an random mob type to go kill
            if questStage == 0 then
                local randNum = math.random(1, #questLocations)
                local questZoneName = questLocations[randNum][1]
                local mobListLength = table.getn(questLocations[randNum][2])
                local randMobType = math.random(1,mobListLength)
                local questZoneMobTypeName = questLocations[randNum][2][randMobType]
                local randMobKillAmt = math.random(15, 20)
                player:setCharVar("[DQ]Murdoc",1)
                player:setCharVar("[DQ]Murdoc_Z",randNum)
                player:setCharVar("[DQ]Murdoc_MT",randMobType)
                player:setCharVar("[DQ]Murdoc_KA",randMobKillAmt)
                player:printToPlayer(string.format("Go to %s and kill %i %s!",questZoneName, randMobKillAmt, questZoneMobTypeName), 0, npc:getPacketName())
                return
            -- Quest has been started already, just reiterate their quest to them
            elseif questStage == 1 then
                local questZone = player:getCharVar("[DQ]Murdoc_Z")
                local questZoneMobType = player:getCharVar("[DQ]Murdoc_MT")
                local questMobKillAmt = player:getCharVar("[DQ]Murdoc_KA")
                local questZoneName = questLocations[questZone][1]
                local questZoneMobTypeName = questLocations[questZone][2][questZoneMobType]
                player:printToPlayer(string.format("Go to %s and kill %i %s!",questZoneName, questMobKillAmt, questZoneMobTypeName), 0, npc:getPacketName())
                return
            -- They have killed all the required mobs, handle the reward
            elseif questStage == 2 then
                player:setCharVar("[DQ]Murdoc",3)
                player:setCharVar("[DQ]Completed", completedDailyQuests + 1, getMidnight())
                player:printToPlayer("Congratulations! You've completed my quest for today, here's your reward!", 0, npc:getPacketName())
                player:addCurrency('obsidian_fragment', 200)
                player:printToPlayer("You have obtained 200 Obsidian Fragments!", 17)
                return
            -- The quest as already been completed
            elseif questStage == 3 then
                player:printToPlayer("You've already completed this quest today! Come back tomorrow for more.", 0, npc:getPacketName())
                return
            end
        end,
    })

    utils.unused(murdoc)

end)

-- This table contains the zones and ACTUAL mob names for each type of mob, this is formatted for filenames
local killAmtMobs =
{
    {1, 1, "West_Ronfaure", { "Ding_Bats", "Mouse_Bat" } }, -- Bats
    {1, 2, "West_Ronfaure", { "Scarab_Beetle" } }, -- Beetles
    {1, 3, "West_Ronfaure", { "River_Crab", "Passage_Crab", "Land_Crab", "Limicoline_Crab", "Tree_Crab", "Vermivorous_Crab" } }, -- Crabs
    {1, 4, "West_Ronfaure", { "Forest_Funguar" } }, -- Funguar
    {1, 5, "West_Ronfaure", { "Goblin_Thug", "Goblin_Weaver", "Goblin_Digger", "Goblin_Fisher" } }, -- Goblins
    {1, 6, "West_Ronfaure", { "Orcish_Fodder", "Orcish_Grappler", "Orcish_Mesmerizer" } }, -- Orcs
    {1, 7, "West_Ronfaure", { "Wild_Rabbit", "Forest_Hare" } }, -- Rabbits
    {1, 8, "West_Ronfaure", { "Wild_Sheep" } }, -- Sheep
    {1, 9, "West_Ronfaure", { "Tunnel_Worm", "Carrion_Worm" } }, -- Worms
    {2, 1, "East_Ronfaure", { "Ding_Bats", "Mouse_Bat" } }, -- Bats
    {2, 2, "East_Ronfaure", { "Scarab_Beetle" } }, -- Beetles
    {2, 3, "East_Ronfaure", { "Forest_Funguar" } }, -- Funguar
    {2, 4, "East_Ronfaure", { "Goblin_Thug", "Goblin_Weaver", "Goblin_Digger", "Goblin_Fisher" } }, -- Goblins
    {2, 5, "East_Ronfaure", { "Orcish_Fodder", "Orcish_Grappler", "Orcish_Mesmerizer" } }, -- Orcs
    {2, 6, "East_Ronfaure", { "Cheval_Pugil", "Fighting_Pugil", "Mud_Pugil", "Pug_Pugil", "Pugil" } }, -- Pugils
    {2, 7, "East_Ronfaure", { "Wild_Rabbit", "Forest_Hare" } }, -- Rabbits
    {2, 8, "East_Ronfaure", { "Wild_Sheep" } }, -- Sheep
    {2, 9, "East_Ronfaure", { "Tunnel_Worm", "Carrion_Worm" } }, -- Worms
    {3,  1, "South_Gustaberg", { "Ding_Bats" } }, -- Bats
    {3,  2, "South_Gustaberg", { "Huge_Hornet", "Maneating_Hornet" } }, -- Bees
    {3,  3, "South_Gustaberg", { "Vulture" } }, -- Birds
    {3,  4, "South_Gustaberg", { "Stone_Crab", "Sand_Crab", "Land_Crab", "Mole_Crab", "Passage_Crab" } }, -- Crabs
    {3,  5, "South_Gustaberg", { "Goblin_Fisher", "Goblin_Thug", "Goblin_Weaver", "Goblin_Digger" } }, -- Goblins
    {3,  6, "South_Gustaberg", { "Rock_Lizard" } }, -- Lizards
    {3,  7, "South_Gustaberg", { "Amber_Quadav", "Amethyst_Quadav", "Young_Quadav" } }, -- Quadav
    {3,  8, "South_Gustaberg", { "Walking_Sapling" } }, -- Saplings
    {3,  9, "South_Gustaberg", { "Ornery_Sheep" } }, -- Sheep
    {3, 10, "South_Gustaberg", { "Tunnel_Worm", "Stone_Eater" } }, -- Worms
    {4,  1, "North_Gustaberg", { "Ding_Bats", "Fledermaus" } }, -- Bats
    {4,  2, "North_Gustaberg", { "Huge_Hornet", "Maneating_Hornet" } }, -- Bees
    {4,  3, "North_Gustaberg", { "Vulture" } }, -- Birds
    {4,  4, "North_Gustaberg", { "Stone_Crab", "Sand_Crab", "River_Crab" } }, -- Crabs
    {4,  5, "North_Gustaberg", { "Goblin_Fisher", "Goblin_Thug", "Goblin_Weaver", "Goblin_Digger", "Goblin_Gambler", "Goblin_Leecher", "Goblin_Mugger" } }, -- Goblins
    {4,  6, "North_Gustaberg", { "Rock_Lizard" } }, -- Lizards
    {4,  7, "North_Gustaberg", { "Sand_Pugil" } }, -- Pugils
    {4,  8, "North_Gustaberg", { "Amber_Quadav", "Amethyst_Quadav", "Young_Quadav" } }, -- Quadav
    {4,  9, "North_Gustaberg", { "Walking_Sapling" } }, -- Saplings
    {4, 10, "North_Gustaberg", { "Ornery_Sheep" } }, -- Sheep
    {4, 11, "North_Gustaberg", { "Tunnel_Worm", "Stone_Eater" } }, -- Worms
    {5,  1, "West_Sarutabaruta", { "Bumblebee", "Giant_Bee" } }, -- Bees
    {5,  2, "West_Sarutabaruta", { "Carrion_Crow" } }, -- Birds
    {5,  3, "West_Sarutabaruta", { "Palm_Crab", "Savanna_Crab", "River_Crab" } }, -- Crabs
    {5,  4, "West_Sarutabaruta", { "Crawler" } }, -- Crawlers
    {5,  5, "West_Sarutabaruta", { "Goblin_Thug", "Goblin_Weaver", "Goblin_Fisher", "Goblin_Digger" } }, -- Goblins
    {5,  6, "West_Sarutabaruta", { "Tiny_Mandragora", "Mandragora" } }, -- Mandragora
    {5,  7, "West_Sarutabaruta", { "Savanna_Rarab" } }, -- Rabbits
    {5,  8, "West_Sarutabaruta", { "Yagudo_Acolyte", "Yagudo_Initiate", "Yagudo_Scribe" } }, -- Yagudo
    {6,  1, "East_Sarutabaruta", { "Bumblebee", "Giant_Bee" } }, -- Bees
    {6,  2, "East_Sarutabaruta", { "Carrion_Crow" } }, -- Birds
    {6,  3, "East_Sarutabaruta", { "Palm_Crab", "Savanna_Crab", "River_Crab" } }, -- Crabs
    {6,  4, "East_Sarutabaruta", { "Crawler" } }, -- Crawlers
    {6,  5, "East_Sarutabaruta", { "Goblin_Thug", "Goblin_Weaver", "Goblin_Fisher", "Goblin_Digger" } }, -- Goblins
    {6,  6, "East_Sarutabaruta", { "Tiny_Mandragora", "Mandragora" } }, -- Mandragora
    {6,  7, "East_Sarutabaruta", { "Pug_Pugil", "Mud_Pugil", "Fighting_Pugil" } }, -- Pugils
    {6,  8, "East_Sarutabaruta", { "Savanna_Rarab" } }, -- Rabbits
    {6,  9, "East_Sarutabaruta", { "Yagudo_Acolyte", "Yagudo_Initiate", "Yagudo_Scribe" } }, -- Yagudo
    {7,  1, "La_Theine_Plateau", { "Gale_Bats", "Acro_Bat", "Plague_Bats", "Poison_Bat" } }, -- Bats
    {7,  2, "La_Theine_Plateau", { "Huge_Wasp" } }, -- Bees
    {7,  3, "La_Theine_Plateau", { "Coral_Crab", "Thickshell" } }, -- Crabs
    {7,  4, "La_Theine_Plateau", { "Grass_Funguar", "Poison_Funguar" } }, -- Funguars
    {7,  5, "La_Theine_Plateau", { "Goblin_Fisher", "Goblin_Thug", "Goblin_Weaver", "Goblin_Digger", "Goblin_Ambusher", "Goblin_Butcher", "Goblin_Tinkerer" } }, -- Goblins
    {7,  6, "La_Theine_Plateau", { "Orcish_Fodder", "Orcish_Grappler", "Orcish_Mesmerizer", "Orcish_Grunt", "Orcish_Neckchopper", "Orcish_Stonechucker" } }, -- Orcs
    {7,  7, "La_Theine_Plateau", { "Steppe_Hare" } }, -- Rabbits
    {7,  8, "La_Theine_Plateau", { "Strolling_Sapling" } }, -- Saplings
    {7, 10, "La_Theine_Plateau", { "Rock_Eater" } }, -- Worms
    {8,  1, "Konschtat_Highlands", { "Huge_Wasp" } }, -- Bees
    {8,  2, "Konschtat_Highlands", { "Goblin_Ambusher", "Goblin_Butcher", "Goblin_Digger", "Goblin_Thug", "Goblin_Tinkerer", "Goblin_Weaver" } }, -- Goblins
    {8,  3, "Konschtat_Highlands", { "Mist_Lizard" } }, -- Lizards
    {8,  4, "Konschtat_Highlands", { "Amber_Quadav", "Amethyst_Quadav", "Greater_Quadav", "Onyx_Quadav", "Veteran_Quadav", "Young_Quadav" } }, -- Quadav
    {8,  5, "Konschtat_Highlands", { "Strolling_Sapling" } }, -- Saplings
    {8,  6, "Konschtat_Highlands", { "Mad_Sheep" } }, -- Sheep
    {8,  7, "Konschtat_Highlands", { "Rock_Eater" } }, -- Worms
    {9,  1, "Tahrongi_Canyon", { "Killer_Bee" } }, -- Bees
    {9,  2, "Tahrongi_Canyon", { "Akbaba" } }, -- Birds
    {9,  3, "Tahrongi_Canyon", { "Canyon_Crawler" } }, -- Crawlers
    {9,  4, "Tahrongi_Canyon", { "Wild_Dhalmel" } }, -- Dhalmel
    {9,  5, "Tahrongi_Canyon", { "Goblin_Thug", "Goblin_Weaver", "Goblin_Ambusher", "Goblin_Butcher", "Goblin_Digger", "Goblin_Tinkerer" } }, -- Goblins
    {9,  6, "Tahrongi_Canyon", { "Pygmaioi" } }, -- Mandragora
    {9,  7, "Tahrongi_Canyon", { "Canyon_Rarab" } }, -- Rabbits
    {9,  8, "Tahrongi_Canyon", { "Strolling_Sapling" } }, -- Saplings
    {9,  9, "Tahrongi_Canyon", { "Yagudo_Acolyte", "Yagudo_Initiate", "Yagudo_Scribe", "Yagudo_Mendicant", "Yagudo_Persecutor", "Yagudo_Piper" } }, -- Yagudo
    {10,  1, "Valkurm_Dunes", { "Night_Bats", "Sand_Bats", "Star_Bat", "Giant_Bat" } }, -- Bats
    {10,  2, "Valkurm_Dunes", { "Stag_Crab", "Snipper", "Cutter" } }, -- Crabs
    {10,  3, "Valkurm_Dunes", { "Damselfly" } }, -- Flies
    {10,  4, "Valkurm_Dunes", { "Goblin_Ambusher", "Goblin_Butcher", "Goblin_Tinkerer", "Goblin_Bounty_Hunter", "Goblin_Digger", "Goblin_Gambler", "Goblin_Leecher", "Goblin_Mugger" } }, -- Goblins
    {10,  5, "Valkurm_Dunes", { "Thread_Leech" } }, -- Leeches
    {10,  6, "Valkurm_Dunes", { "Hill_Lizard" } }, -- Lizards
    {10,  7, "Valkurm_Dunes", { "Puffer_Pugil", "Beach_Pugil" } }, -- Pugils
    {10,  8, "Valkurm_Dunes", { "Sand_Hare" } }, -- Rabbits
    {10,  9, "Valkurm_Dunes", { "Brutal_Sheep" } }, -- Sheep
    {11,  1, "Jugner_Forest", { "Stag_Beetle" } }, -- Beetles
    {11,  2, "Jugner_Forest", { "Screamer" } }, -- Birds
    {11,  3, "Jugner_Forest", { "Knight_Crab", "Snipper", "Stag_Crab" } }, -- Crabs
    {11,  4, "Jugner_Forest", { "Boggart" } }, -- Evil Weapons
    {11,  5, "Jugner_Forest", { "Jugner_Funguar" } }, -- Funguars
    {11,  6, "Jugner_Forest", { "Goblin_Ambusher", "Goblin_Butcher", "Goblin_Digger", "Goblin_Gambler", "Goblin_Leecher", "Goblin_Mugger", "Goblin_Tinkerer" } }, -- Goblins
    {11,  7, "Jugner_Forest", { "Forest_Leech", "Huge_Leech", "Thread_Leech" } }, -- Leeches
    {11,  8, "Jugner_Forest", { "Orcish_Cursemaker", "Orcish_Fighter", "Orcish_Grunt", "Orcish_Neckchopper", "Orcish_Serjeant", "Orcish_Stonechucker" } }, -- Orcs
    {11,  9, "Jugner_Forest", { "Ferocious_Pugil", "Land_Pugil", "Spring_Pugil" } }, -- Pugils
    {11, 10, "Jugner_Forest", { "Wandering_Sapling" } }, -- Saplings
    {11, 11, "Jugner_Forest", { "Brutal_Sheep" } }, -- Sheep
    {11, 12, "Jugner_Forest", { "Forest_Tiger" } }, -- Tigers
    {12,  1, "Batallia_Downs", { "Ba" } }, -- Birds
    {12,  2, "Batallia_Downs", { "Clipper" } }, -- Crabs
    {12,  3, "Batallia_Downs", { "May_Fly" } }, -- Flies
    {12,  4, "Batallia_Downs", { "Goblin_Gambler", "Goblin_Leecher", "Goblin_Mugger", "Goblin_Pathfinder", "Goblin_Shaman", "Goblin_Smithy", "Goblin_Furrier" } }, -- Goblins
    {12,  5, "Batallia_Downs", { "Mauthe_Doog" } }, -- Hounds
    {12,  6, "Batallia_Downs", { "Orcish_Cursemaker", "Orcish_Fighter", "Orcish_Serjeant", "Orcish_Beastrider", "Orcish_Brawler", "Orcish_Impaler", "Orcish_Nightraider" } }, -- Orcs
    {12,  7, "Batallia_Downs", { "Stalking_Sapling", "Sobbing_Sapling" } }, -- Saplings
    {12,  8, "Batallia_Downs", { "Sabertooth_Tiger" } }, -- Tigers
    {13,  1, "Pashhow_Marshlands", { "Night_Bats", "Black_Bat" } }, -- Bats
    {13,  2, "Pashhow_Marshlands", { "Water_Wasp" } }, -- Bees
    {13,  3, "Pashhow_Marshlands", { "Stag_Crab", "Snipper" } }, -- Crabs
    {13,  4, "Pashhow_Marshlands", { "Carnivorous_Crawler" } }, -- Crawlers
    {13,  5, "Pashhow_Marshlands", { "Gadfly" } }, -- Flies
    {13,  6, "Pashhow_Marshlands", { "Marsh_Funguar" } }, -- Funguars
    {13,  7, "Pashhow_Marshlands", { "Goblin_Ambusher", "Goblin_Butcher", "Goblin_Tinkerer", "Goblin_Digger", "Goblin_Gambler", "Goblin_Leecher", "Goblin_Mugger" } }, -- Goblins
    {13,  8, "Pashhow_Marshlands", { "Goobbue" } }, -- Goobbues
    {13,  9, "Pashhow_Marshlands", { "Bog_Dog" } }, -- Hounds
    {13, 10, "Pashhow_Marshlands", { "Swamp_Leech", "Thread_Leech" } }, -- Leeches
    {13, 11, "Pashhow_Marshlands", { "Malboro" } }, -- Morbols
    {13, 12, "Pashhow_Marshlands", { "Land_Pugil", "Swamp_Pugil" } }, -- Pugils
    {13, 13, "Pashhow_Marshlands", { "Greater_Quadav", "Onyx_Quadav", "Veteran_Quadav", "Brass_Quadav", "Copper_Quadav", "Old_Quadav" } }, -- Quadav
    {13, 14, "Pashhow_Marshlands", { "Bog_Bunny" } }, -- Rabbits
    {14,  1, "Rolanberry_Fields", { "Midnight_Wings", "Moon_Bat" } }, -- Bats
    {14,  2, "Rolanberry_Fields", { "Death_Wasp" } }, -- Bees
    {14,  3, "Rolanberry_Fields", { "Clipper" } }, -- Crabs
    {14,  4, "Rolanberry_Fields", { "Berry_Grub" } }, -- Crawlers
    {14,  5, "Rolanberry_Fields", { "Goblin_Gambler", "Goblin_Leecher", "Goblin_Mugger", "Goblin_Digger", "Goblin_Furrier", "Goblin_Shaman", "Goblin_Smithy", "Goblin_Pathfinder" } }, -- Goblins
    {14,  6, "Rolanberry_Fields", { "Goobbue_Farmer" } }, -- Goobbues
    {14,  7, "Rolanberry_Fields", { "Poison_Leech", "Horrid_Fluke", "Big_Leech" } }, -- Leeches
    {14,  8, "Rolanberry_Fields", { "Ochu" } }, -- Morbols
    {14,  9, "Rolanberry_Fields", { "Copper_Quadav", "Brass_Quadav", "Old_Quadav", "Bronze_Quadav", "Garnet_Quadav", "Silver_Quadav", "Zircon_Quadav" } }, -- Quadav
    {15,  1, "Sauromugue_Champaign", { "Midnight_Wings", "Moon_Bat" } }, -- Bats
    {15,  2, "Sauromugue_Champaign", { "Diving_Beetle" } }, -- Beetles
    {15,  3, "Sauromugue_Champaign", { "Tabar_Beak" } }, -- Cockatrice
    {15,  4, "Sauromugue_Champaign", { "Champaign_Coeurl" } }, -- Coeurls
    {15,  5, "Sauromugue_Champaign", { "Evil_Weapon" } }, -- Evil Weapons
    {15,  6, "Sauromugue_Champaign", { "Goblin_Gambler", "Goblin_Leecher", "Goblin_Mugger", "Goblin_Digger", "Goblin_Furrier", "Goblin_Pathfinder", "Goblin_Shaman", "Goblin_Smithy", "Goblin_Bounty_Hunter" } }, -- Goblins
    {15,  7, "Sauromugue_Champaign", { "Hill_Lizard" } }, -- Lizards
    {15,  8, "Sauromugue_Champaign", { "Sauromugue_Skink" } }, -- Raptors
    {15,  9, "Sauromugue_Champaign", { "Yagudo_Priest", "Yagudo_Theologist", "Yagudo_Votary", "Yagudo_Drummer", "Yagudo_Herald", "Yagudo_Interrogator", "Yagudo_Oracle" } }, -- Yagudo
    {16,  1, "Beaucedine_Glacier", { "Bat_Eye" } }, -- Ahriman
    {16,  2, "Beaucedine_Glacier", { "Living_Statue" } }, -- Dolls
    {16,  3, "Beaucedine_Glacier", { "Cold_Gigas", "Rime_Gigas", "Sleet_Gigas", "Snow_Gigas" } }, -- Gigas
    {16,  4, "Beaucedine_Glacier", { "Goblin_Furrier", "Goblin_Pathfinder", "Goblin_Shaman", "Goblin_Smithy", "Goblin_Poacher", "Goblin_Reaper", "Goblin_Robber", "Goblin_Trader" } }, -- Goblins
    {16,  5, "Beaucedine_Glacier", { "Stone_Golem" } }, -- Golems
    {16,  6, "Beaucedine_Glacier", { "Tundra_Tiger" } }, -- Tigers
    {17,  1, "Xarcabard", { "Evil_Eye" } }, -- Ahriman
    {17,  2, "Xarcabard", { "Demon_Knight", "Demon_Pawn", "Demon_Wizard", "Demon_Warlock" } }, -- Demons
    {17,  3, "Xarcabard", { "Cursed_Weapon" } }, -- Evil Weapons
    {17,  4, "Xarcabard", { "Etemmu" } }, -- Ghosts
    {17,  5, "Xarcabard", { "Frost_Gigas", "Blizzard_Gigas", "Graupel_Gigas", "Hail_Gigas" } }, -- Gigas
    {17,  6, "Xarcabard", { "Lost_Soul" } }, -- Skeletons
    {18,  1, "Cape_Teriggan", { "Sand_Cockatrice" } }, -- Cockatrice
    {18,  2, "Cape_Teriggan", { "Robber_Crab", "Rock_Crab" } }, -- Crabs
    {18,  3, "Cape_Teriggan", { "Goblin_Alchemist", "Goblin_Bandit", "Goblin_Mercenary", "Goblin_Shepherd" } }, -- Goblins
    {18,  4, "Cape_Teriggan", { "Sand_Lizard" } }, -- Lizards
    {18,  5, "Cape_Teriggan", { "Greater_Manticore" } }, -- Manticores
    {18,  6, "Cape_Teriggan", { "Razorjaw_Pugil", "Stygian_Pugil", "Terror_Pugil" } }, -- Pugils
    {18,  7, "Cape_Teriggan", { "Beach_Bunny" } }, -- Rabbits
    {18,  8, "Cape_Teriggan", { "Velociraptor" } }, -- Raptors
    {19,  1, "Eastern_Altepa_Desert", { "Antican_Auxiliarius", "Antican_Faber", "Antican_Funditor", "Antican_Decurio", "Antican_Sagittarius", "Antican_Speculator", "Antican_Centurio", "Antican_Veles" } }, -- Antica
    {19,  2, "Eastern_Altepa_Desert", { "Sand_Beetle" } }, -- Beetles
    {19,  3, "Eastern_Altepa_Desert", { "Desert_Dhalmel" } }, -- Dhalmel
    {19,  4, "Eastern_Altepa_Desert", { "Goblin_Digger", "Goblin_Poacher", "Goblin_Reaper", "Goblin_Robber", "Goblin_Trader" } }, -- Goblins
    {19,  5, "Eastern_Altepa_Desert", { "Lesser_Manticore" } }, -- Manticores
    {19,  6, "Eastern_Altepa_Desert", { "Diatryma" } }, -- Rocs
    {19,  7, "Eastern_Altepa_Desert", { "Sabotender" } }, -- Sabotenders
    {19,  8, "Eastern_Altepa_Desert", { "Doom_Scorpion" } }, -- Scorpions
    {19,  9, "Eastern_Altepa_Desert", { "Giant_Spider" } }, -- Spiders
    {19, 10, "Eastern_Altepa_Desert", { "Flesh_Eater" } }, -- Worms
    {20,  1, "Western_Altepa_Desert", { "Antican_Eques", "Antican_Essedarius", "Antican_Hoplomachus", "Antican_Lanista", "Antican_Retiarius", "Antican_Secutor" } }, -- Antica
    {20,  2, "Western_Altepa_Desert", { "Desert_Beetle" } }, -- Beetles
    {20,  3, "Western_Altepa_Desert", { "Desert_Dhalmel" } }, -- Dhalmel
    {20,  4, "Western_Altepa_Desert", { "Desert_Manticore" } }, -- Manticores
    {20,  5, "Western_Altepa_Desert", { "Phorusrhacos" } }, -- Rocs
    {20,  6, "Western_Altepa_Desert", { "Cactuar" } }, -- Sabotenders
    {20,  7, "Western_Altepa_Desert", { "Tulwar_Scorpion" } }, -- Scorpions
    {20,  8, "Western_Altepa_Desert", { "Desert_Spider" } }, -- Spiders
    {20,  9, "Western_Altepa_Desert", { "Desert_Worm" } }, -- Worms
    {21,  1, "Meriphataud_Mountains", { "Night_Bats", "Black_Bat" } }, -- Bats
    {21,  2, "Meriphataud_Mountains", { "Jubjub" } }, -- Birds
    {21,  3, "Meriphataud_Mountains", { "Stag_Beetle" } }, -- Beetles
    {21,  4, "Meriphataud_Mountains", { "Axe_Beak" } }, -- Cockatrice
    {21,  5, "Meriphataud_Mountains", { "Coeurl" } }, -- Coeurls
    {21,  6, "Meriphataud_Mountains", { "Boggart" } }, -- Evil Weapons
    {21,  7, "Meriphataud_Mountains", { "Crane_Fly" } }, -- Flies
    {21,  8, "Meriphataud_Mountains", { "Goblin_Ambusher", "Goblin_Butcher", "Goblin_Tinkerer", "Goblin_Digger", "Goblin_Gambler", "Goblin_Leecher", "Goblin_Mugger" } }, -- Goblins
    {21,  9, "Meriphataud_Mountains", { "Hill_Lizard" } }, -- Lizards
    {21, 10, "Meriphataud_Mountains", { "Raptor" } }, -- Raptors
    {21, 11, "Meriphataud_Mountains", { "Wandering_Sapling" } }, -- Saplings
    {21, 12, "Meriphataud_Mountains", { "Yagudo_Mendicant", "Yagudo_Persecutor", "Yagudo_Piper", "Yagudo_Priest", "Yagudo_Theologist", "Yagudo_Votary" } }, -- Yagudo
    {22,  1, "Buburimu_Peninsula", { "Zu" } }, -- Birds
    {22,  2, "Buburimu_Peninsula", { "Stag_Crab", "Snipper" } }, -- Crabs
    {22,  3, "Buburimu_Peninsula", { "Carnivorous_Crawler" } }, -- Crawlers
    {22,  4, "Buburimu_Peninsula", { "Bull_Dhalmel" } }, -- Dhalmel
    {22,  5, "Buburimu_Peninsula", { "Goblin_Ambusher", "Goblin_Butcher", "Goblin_Tinkerer", "Goblin_Digger", "Goblin_Gambler", "Goblin_Leecher", "Goblin_Mugger", "Goblin_Bounty_Hunter" } }, -- Goblins
    {22,  6, "Buburimu_Peninsula", { "Poison_Leech" } }, -- Leeches
    {22,  7, "Buburimu_Peninsula", { "Sylvestre" } }, -- Mandragora
    {22,  8, "Buburimu_Peninsula", { "Puffer_Pugil", "Shoal_Pugil" } }, -- Pugils
    {22,  9, "Buburimu_Peninsula", { "Mighty_Rarab" } }, -- Rabbits
    {23,  1, "The_Sanctuary_of_ZiTah", { "Ancient_Bat", "Lesser_Gaylas" } }, -- Bats
    {23,  2, "The_Sanctuary_of_ZiTah", { "Master_Coeurl" } }, -- Coeurls
    {23,  3, "The_Sanctuary_of_ZiTah", { "Ogrefly" } }, -- Flies
    {23,  4, "The_Sanctuary_of_ZiTah", { "Myxomycete" } }, -- Funguars
    {23,  5, "The_Sanctuary_of_ZiTah", { "Goblin_Gambler", "Goblin_Leecher", "Goblin_Mugger", "Goblin_Furrier", "Goblin_Smithy", "Goblin_Poacher", "Goblin_Reaper", "Goblin_Robber", "Goblin_Trader" } }, -- Goblins
    {23,  6, "The_Sanctuary_of_ZiTah", { "Rock_Golem" } }, -- Golems
    {23,  7, "The_Sanctuary_of_ZiTah", { "Goobbue_Gardener" } }, -- Goobbues
    {23,  8, "The_Sanctuary_of_ZiTah", { "Goobbue_Parasite" } }, -- Leeches
    {24,  1, "RoMaeve", { "Cursed_Puppet" } }, -- Dolls
    {24,  2, "RoMaeve", { "Apocalyptic_Weapon", "Infernal_Weapon", "Killing_Weapon", "Ominous_Weapon" } }, -- Evil Weapons
    {24,  3, "RoMaeve", { "Darksteel_Golem", "Mythril_Golem" } }, -- Golems
    {24,  4, "RoMaeve", { "Magic_Flagon" } }, -- Magic Pots
    {25,  1, "Yuhtunga_Jungle", { "Death_Jacket" } }, -- Bees
    {25,  2, "Yuhtunga_Jungle", { "Soldier_Crawler" } }, -- Crawlers
    {25,  3, "Yuhtunga_Jungle", { "Goblin_Digger", "Goblin_Furrier", "Goblin_Poacher", "Goblin_Reaper", "Goblin_Robber", "Goblin_Smithy" } }, -- Goblins
    {25,  4, "Yuhtunga_Jungle", { "Ivory_Lizard" } }, -- Lizards
    {25,  5, "Yuhtunga_Jungle", { "Yuhtunga_Mandragora" } }, -- Mandragora
    {25,  6, "Yuhtunga_Jungle", { "Young_Opo-opo" } }, -- Opo-opo
    {25,  7, "Yuhtunga_Jungle", { "Makara" } }, -- Pugils
    {25,  8, "Yuhtunga_Jungle", { "Creek_Sahagin", "River_Sahagin", "Stream_Sahagin" } }, -- Sahagin
    {26,  1, "Yhoator_Jungle", { "Yhoator_Wasp" } }, -- Bees
    {26,  2, "Yhoator_Jungle", { "Master_Coeurl" } }, -- Coeurls
    {26,  3, "Yhoator_Jungle", { "Worker_Crawler" } }, -- Crawlers
    {26,  4, "Yhoator_Jungle", { "Goblin_Bouncer", "Goblin_Digger", "Goblin_Hunter", "Goblin_Pathfinder", "Goblin_Poacher", "Goblin_Reaper", "Goblin_Robber", "Goblin_Shaman", "Goblin_Smithy", "Goblin_Trader" } }, -- Goblins
    {26,  5, "Yhoator_Jungle", { "White_Lizard" } }, -- Lizards
    {26,  6, "Yhoator_Jungle", { "Yhoator_Mandragora" } }, -- Mandragora
    {26,  7, "Yhoator_Jungle", { "Anemone" } }, -- Morbols
    {26,  8, "Yhoator_Jungle", { "Young_Opo-opo" } }, -- Opo-opo
    {26,  9, "Yhoator_Jungle", { "Big_Jaw" } }, -- Pugils
    {26, 10, "Yhoator_Jungle", { "Tonberry_Chopper", "Tonberry_Creeper", "Tonberry_Harasser", "Tonberry_Hexer", "Tonberry_Jinxer", "Tonberry_Shadower" } }, -- Tonberries
    {27,  1, "Qufim_Island", { "Dark_Bats", "Seeker_Bats", "Ancient_Bat", "Glow_Bat" } }, -- Bats
    {27,  2, "Qufim_Island", { "Clipper" } }, -- Crabs
    {27,  3, "Qufim_Island", { "Dancing_Weapon" } }, -- Evil Weapons
    {27,  4, "Qufim_Island", { "Giant_Trapper", "Giant_Ascetic", "Giant_Hunter", "Giant_Ranger" } }, -- Gigas
    {27,  5, "Qufim_Island", { "Acrophies" } }, -- Leeches
    {27,  6, "Qufim_Island", { "Qufim_Pugil", "Greater_Pugil", "Vepar" } }, -- Pugils
    {27,  7, "Qufim_Island", { "Land_Worm" } }, -- Worms
    {28,  1, "Temple_of_Uggalepih", { "Temple_Bee", "Wespe" } }, -- Bees
    {28,  2, "Temple_of_Uggalepih", { "Torama" } }, -- Coeurls
    {28,  3, "Temple_of_Uggalepih", { "Rumble_Crawler" } }, -- Crawlers
    {28,  4, "Temple_of_Uggalepih", { "Branding_Iron", "Iron_Maiden", "Temple_Guardian" } }, -- Dolls
    {28,  5, "Temple_of_Uggalepih", { "Hover_Tank" } }, -- Magic Pots
    {28,  6, "Temple_of_Uggalepih", { "Temple_Opo-opo" } }, -- Opo-opo
    {28,  7, "Temple_of_Uggalepih", { "Tonberry_Cutter", "Tonberry_Dismayer", "Tonberry_Harrier", "Tonberry_Maledictor", "Tonberry_Pursuer", "Tonberry_Stabber", "Tonberry_Stalker" } }, -- Tonberries
    {29,  1, "Valley_of_Sorrows", { "Valley_Manticore" } }, -- Manticores
    {29,  2, "Valley_of_Sorrows", { "Velociraptor" } }, -- Raptors
    {29,  3, "Valley_of_Sorrows", { "Peryton" } }, -- Rocs
    {30,  1, "Bibiki_Bay", { "Raven", "Tragopan", "Toucan" } }, -- Birds
    {30,  2, "Bibiki_Bay", { "Grindylow", "Locus_Ghost_Crab", "Ghost_Crab" } }, -- Crabs
    {30,  3, "Bibiki_Bay", { "Catoblepas", "Locus_Camelopard", "Marine_Dhalmel" } }, -- Dhalmel
    {30,  4, "Bibiki_Bay", { "Eft", "Locus_Hypnos_Eft", "Tartarus_Eft" } }, -- Efts
    {30,  5, "Bibiki_Bay", { "Goblin_Pathfinder", "Goblin_Shaman", "Hobgoblin_Animalier", "Hobgoblin_Fascinator", "Hobgoblin_Martialist", "Hobgoblin_Venerer" } }, -- Goblins
    {30,  6, "Bibiki_Bay", { "Alraune" } }, -- Mandragora
    {30,  7, "Bibiki_Bay", { "Coastal_Opo-opo" } }, -- Opo-opo
    {30,  8, "Bibiki_Bay", { "Locus_Bight_Rarab", "Island_Rarab", "Tropical_Rarab" } }, -- Rabbits
    {30,  9, "Bibiki_Bay", { "Viscous_Clot" } }, -- Slimes
    {30, 10, "Bibiki_Bay", { "Coralline_Uragnite" } }, -- Uragnites
    {31,  1, "Carpenters_Landing", { "Beady_Beetle", "Diving_Beetle", "Stag_Beetle" } }, -- Beetles
    {31,  2, "Carpenters_Landing", { "Digger_Wasp", "Spider_Wasp" } }, -- Bees
    {31,  3, "Carpenters_Landing", { "Battrap", "Birdtrap", "Fishtrap", "Flytrap" } }, -- Flytraps
    {31,  4, "Carpenters_Landing", { "Marsh_Funguar", "Poison_Funguar", "Shrieker" } }, -- Funguars
    {31,  5, "Carpenters_Landing", { "Orcish_Cursemaker", "Orcish_Fighter", "Orcish_Grunt", "Orcish_Neckchopper", "Orcish_Serjeant", "Orcish_Stonechucker" } }, -- Orcs
    {31,  6, "Carpenters_Landing", { "Fosse_Pugil", "Greater_Pugil", "Land_Pugil", "Spinous_Pugil" } }, -- Pugils
    {31,  7, "Carpenters_Landing", { "Forest_Tiger", "Sabertooth_Tiger" } }, -- Tigers
    {32,  1, "Uleguerand_Range", { "Fachan", "Smolenkos", "Scowlenkos" } }, -- Ahriman
    {32,  2, "Uleguerand_Range", { "Esbat", "Succubus_Bats", "Nightmare_Bats" } }, -- Bats
    {32,  3, "Uleguerand_Range", { "Buffalo", "Giant_Buffalo", "King_Buffalo" } }, -- Buffalo
    {32,  4, "Uleguerand_Range", { "Gore_Demon", "Judicator_Demon", "Dread_Demon", "Stygian_Demon", "Kindred_Black_Mage", "Kindred_Dark_Knight", "Kindred_Summoner", "Kindred_Warrior" } }, -- Demons
    {32,  5, "Uleguerand_Range", { "Mindgazer" } }, -- Hecteyes
    {32,  6, "Uleguerand_Range", { "Variable_Hare", "Polar_Hare" } }, -- Rabbits
    {32,  7, "Uleguerand_Range", { "Nival_Raptor" } }, -- Raptors
    {32,  8, "Uleguerand_Range", { "Snoll", "Morozko", "Akselloak", "Agloolik" } }, -- Snolls
    {32,  9, "Uleguerand_Range", { "Brontotaur", "Tyrannotaur", "Molech" } }, -- Tauri
    {32, 10, "Uleguerand_Range", { "Uleguerand_Tiger" } }, -- Tigers
    {32, 11, "Uleguerand_Range", { "Glacier_Eater", "Mountain_Worm" } }, -- Worms
    {33,  1, "Attohwa_Chasm", { "Burrow_Antlion", "Cave_Antlion", "Hunter_Antlion", "Pit_Antlion", "Tracer_Antlion", "Tracker_Antlion", "Trench_Antlion" } }, -- Antlions
    {33,  2, "Attohwa_Chasm", { "Attohwa_Coeurl", "Master_Coeurl" } }, -- Coeurls
    {33,  3, "Attohwa_Chasm", { "Gallinipper", "Monarch_Ogrefly", "Ogrefly" } }, -- Flies
    {33,  4, "Attohwa_Chasm", { "Goblin_Furrier", "Goblin_Pathfinder", "Goblin_Poacher", "Goblin_Reaper", "Goblin_Robber", "Goblin_Shaman", "Goblin_Smithy", "Goblin_Trader" } }, -- Goblins
    {33,  5, "Attohwa_Chasm", { "Hecteyes" } }, -- Hecteyes
    {33,  6, "Attohwa_Chasm", { "Bane_Lizard", "Chasm_Lizard", "Sand_Lizard" } }, -- Lizards
    {33,  7, "Attohwa_Chasm", { "Cutlass_Scorpion", "Doom_Scorpion", "Tulwar_Scorpion" } }, -- Scorpions
    {33,  8, "Attohwa_Chasm", { "Flesh_Eater" } }, -- Worms
    {34,  1, "Oldton_Movalpolos", { "Dark_Bats", "Stirge" } }, -- Bats
    {34,  2, "Oldton_Movalpolos", { "Bugbear_Bondman", "Bugbear_Servingman" } }, -- Bugbears
    {34,  3, "Oldton_Movalpolos", { "Goblin_Craftsman", "Goblin_Doorman", "Goblin_Freelance", "Goblin_Gutterman", "Goblin_Hammerman", "Goblin_Leadman", "Goblin_Oilman", "Goblin_Shovelman", "Goblin_Tollman" } }, -- Goblins
    {34,  4, "Oldton_Movalpolos", { "Moblin_Ashman", "Moblin_Chapman", "Moblin_Coalman", "Moblin_Gasman", "Moblin_Gurneyman", "Moblin_Pickman", "Moblin_Pikeman", "Moblin_Ragman", "Moblin_Repairman", "Moblin_Rodman", "Moblin_Witchman" } }, -- Moblins
    {35,  1, "Newton_Movalpolos", { "Dire_Bat", "Nightmare_Bats", "Purgatory_Bat", "Succubus_Bats" } }, -- Bats
    {35,  2, "Newton_Movalpolos", { "Bugbear_Deathsman", "Bugbear_Trashman", "Bugbear_Watchman" } }, -- Bugbears
    {35,  3, "Newton_Movalpolos", { "Goblin_Fireman", "Goblin_Foreman", "Goblin_Hangman", "Goblin_Headman", "Goblin_Junkman", "Goblin_Lengthman", "Goblin_Marksman", "Goblin_Packman", "Goblin_Swordsman", "Moblin_Aidman", "Moblin_Draftsman", "Moblin_Engineman", "Moblin_Groundman", "Moblin_Roadman", "Moblin_Scalpelman", "Moblin_Tankman", "Moblin_Topsman", "Moblin_Workman", "Moblin_Yardman" } }, -- Moblins
    {36,  1, "Wajaom_Woodlands", { "Soldier_Pephredo", "Worker_Pephredo" } }, -- Bees
    {36,  2, "Wajaom_Woodlands", { "Lesser_Colibri" } }, -- Colibri
    {36,  3, "Wajaom_Woodlands", { "Fomor_Bard", "Fomor_Beastmaster", "Fomor_Paladin", "Fomor_Thief" } }, -- Fomors
    {36,  4, "Wajaom_Woodlands", { "Kissing_Leech", "Red_Kisser", "Red_Osculator", "Red_Smoocher" } }, -- Leeches
    {36,  5, "Wajaom_Woodlands", { "Mamool_Ja_Bounder", "Mamool_Ja_Mimicker", "Mamool_Ja_Savant", "Mamool_Ja_Sophist", "Mamool_Ja_Zenist" } }, -- Mamool Ja
    {36,  6, "Wajaom_Woodlands", { "Grand_Marid", "Marid" } }, -- Marids
    {36,  7, "Wajaom_Woodlands", { "Ameretat", "Great_Ameretat" } }, -- Morbols
    {36,  8, "Wajaom_Woodlands", { "Puk" } }, -- Puks
    {36,  9, "Wajaom_Woodlands", { "Treant_Sapling" } }, -- Saplings
    {36, 10, "Wajaom_Woodlands", { "Aht_Urhgan_Attercop" } }, -- Spiders
    {36, 11, "Wajaom_Woodlands", { "Wajaom_Tiger" } }, -- Tigers
    {36, 12, "Wajaom_Woodlands", { "Colorful_Treant", "Defoliate_Treant" } }, -- Treants
    {37,  1, "Bhaflau_Thickets", { "Colibri", "Lesser_Colibri", "Locus_Colibri" } }, -- Colibri
    {37,  2, "Bhaflau_Thickets", { "Fomor_Bard", "Fomor_Beastmaster", "Fomor_Paladin", "Fomor_Thief" } }, -- Fomors
    {37,  3, "Bhaflau_Thickets", { "Mamool_Ja_Blusterer", "Mamool_Ja_Infiltrator", "Mamool_Ja_Lurker", "Mamool_Ja_Mimer", "Mamool_Ja_Philosopher", "Mamool_Ja_Pikeman", "Mamool_Ja_Stabler" } }, -- Mamool Ja
    {37,  4, "Bhaflau_Thickets", { "Grand_Marid", "Marid" } }, -- Marids
    {37,  5, "Bhaflau_Thickets", { "Sea_Puk" } }, -- Puks
    {37,  6, "Bhaflau_Thickets", { "Treant_Sapling" } }, -- Saplings
    {37,  7, "Bhaflau_Thickets", { "Aht_Urhgan_Attercop" } }, -- Spiders
    {37,  8, "Bhaflau_Thickets", { "Wajaom_Tiger" } }, -- Tigers
    {37,  9, "Bhaflau_Thickets", { "Troll_Sabreur", "Troll_Shieldbearer", "Troll_Surveillant" } }, -- Trolls
    {37, 10, "Bhaflau_Thickets", { "Colorful_Treant", "Olden_Treant" } }, -- Treants
    {37, 11, "Bhaflau_Thickets", { "Locus_Wivre" } }, -- Wivre
    {38,  1, "Arrapago_Reef", { "Arrapago_Apkallu", "Emperor_Apkallu" } }, -- Apkallu
    {38,  2, "Arrapago_Reef", { "Naraka_Bat", "Purgatory_Bat" } }, -- Bats
    {38,  3, "Arrapago_Reef", { "Dweomershell", "Nipper", "Wootzshell" } }, -- Crabs
    {38,  4, "Arrapago_Reef", { "Jnun", "Llamhigyn_Y_Dwr" } }, -- Doomed
    {38,  5, "Arrapago_Reef", { "Ephramadian_Shade", "Fallen_Imperial_Trooper", "Fallen_Imperial_Wizard", "Fallen_Volunteer" } }, -- Fomors
    {38,  6, "Arrapago_Reef", { "Bhoot", "Phasma" } }, -- Ghosts
    {38,  7, "Arrapago_Reef", { "Lamia_Bellydancer", "Lamia_Dancer", "Lamia_Dartist", "Lamia_Deathdancer", "Lamia_Fatedealer", "Lamia_Graverobber", "Lamia_Necromancer", "Lamia_Toxophilite", "Lamia_Palace_Guard", "Lamie_Bellydancer", "Lamie_Deathdancer", "Lamie_Necromancer", "Lamie_Toxophilite", "Merrow_Bladedancer", "Merrow_Chantress", "Merrow_Icedancer", "Merrow_Kabukidancer", "Merrow_Shadowdancer", "Merrow_Songstress", "Merrow_Typhoondancer", "Merrow_Wavedancer", "Nix_Bladedancer", "Nix_Songstress", "Nix_Typhoondancer", "Nix_Wavedancer" } }, -- Lamiae
    {38,  8, "Arrapago_Reef", { "Arrapago_Leech", "Ashakku", "Nirgali" } }, -- Leeches
    {38,  9, "Arrapago_Reef", { "Lamia_Idolater", "Qutrub" } }, -- Qutrub
    {38, 10, "Arrapago_Reef", { "Lahama", "Nostokulshedra" } }, -- Sea Monks
    {38, 11, "Arrapago_Reef", { "Draugar_Servant", "Reserve_Draugar" } }, -- Skeletons
    {38, 12, "Arrapago_Reef", { "Soulflayer" } }, -- Soulflayers
    {39,  1, "Mount_Zhayolm", { "King_Apkallu", "Zhayolm_Apkallu" } }, -- Apkallu
    {39,  2, "Mount_Zhayolm", { "Wootzshell", "Sicklemoon_Crab", "Orichalcumshell" } }, -- Crabs
    {39,  3, "Mount_Zhayolm", { "Magmatic_Eruca", "Scoriaceous_Eruca" } }, -- Crawlers
    {39,  4, "Mount_Zhayolm", { "Ebony_Pudding" } }, -- Flans
    {39,  5, "Mount_Zhayolm", { "Assassin_Fly" } }, -- Flies
    {39,  6, "Mount_Zhayolm", { "Phasma" } }, -- Ghosts
    {39,  7, "Mount_Zhayolm", { "Sicklemoon_Jagil", "Sulphuric_Jagil", "Zazalda_Jagil", "Vozold_Jagil" } }, -- Pugil
    {39,  8, "Mount_Zhayolm", { "Zazalda_Clot", "Mountain_Clot", "Vozold_Clot" } }, -- Slime
    {39,  9, "Mount_Zhayolm", { "Hilltroll_Monk", "Hilltroll_Paladin", "Hilltroll_Ranger", "Hilltroll_Red_Mage", "Hilltroll_Dark_Knight", "Hilltroll_Puppetmaster", "Hilltroll_Warrior" } }, -- Troll
    {39, 10, "Mount_Zhayolm", { "Wamoura_Prince" } }, -- Wamouracampa
    {40,  1, "Halvung", { "Friars_Lantern" } }, -- Bombs
    {40,  2, "Halvung", { "Magmatic_Eruca" } }, -- Crawlers
    {40,  3, "Halvung", { "Black_Pudding", "Ebony_Pudding" } }, -- Flans
    {40,  4, "Halvung", { "Antares" } }, -- Scorpions
    {40,  5, "Halvung", { "Troll_Artilleryman", "Troll_Cameist", "Troll_Combatant", "Troll_Cuirasser", "Troll_Engraver", "Troll_Gemologist", "Troll_Grenadier", "Troll_Ironworker", "Troll_Lapidarist", "Troll_Machinist", "Troll_Scrimer", "Troll_Smelter", "Troll_Stoneworker", "Troll_Targeteer" } }, -- Trolls
    {40,  6, "Halvung", { "Wamouracampa" } }, -- Wamouracampa
    {41,  1, "Mamook", { "Ziz" } }, -- Cockatrice
    {41,  2, "Mamook", { "Colibri" } }, -- Colibri
    {41,  3, "Mamook", { "Carriage_Lizard" } }, -- Lizards
    {41,  4, "Mamook", { "Mamool_Ja_Blusterer", "Mamool_Ja_Bounder", "Mamool_Ja_Diver", "Mamool_Ja_Frogman", "Mamool_Ja_Infiltrator", "Mamool_Ja_Lurker", "Mamool_Ja_Mimer", "Mamool_Ja_Mimicker", "Mamool_Ja_Philosopher", "Mamool_Ja_Pikeman", "Mamool_Ja_Savant", "Mamool_Ja_Sophist", "Mamool_Ja_Spearman", "Mamool_Ja_Stabler", "Mamool_Ja_Strapper", "Mamool_Ja_Zenist" } }, -- Mamool Ja
    {41,  5, "Mamook", { "Suhur_Mas" } }, -- Pugils
    {41,  6, "Mamook", { "Puk", "Sea_Puk" } }, -- Puks
    {41,  7, "Mamook", { "Hunting_Raptor" } }, -- Raptors
    {41,  8, "Mamook", { "Spinner" } }, -- Spiders
    {42,  1, "Aydeewa_Subterrane", { "Fossorial_Flea" } }, -- Chigoes
    {42,  2, "Aydeewa_Subterrane", { "Defoliator", "Deforester" } }, -- Crawlers
    {42,  3, "Aydeewa_Subterrane", { "Aydeewa_Diremite" } }, -- Diremites
    {42,  4, "Aydeewa_Subterrane", { "Puktrap" } }, -- Flytraps
    {42,  5, "Aydeewa_Subterrane", { "Anautogenous_Slug", "Phlebotomic_Slug" } }, -- Leeches
    {42,  6, "Aydeewa_Subterrane", { "Qiqirn_Archaeologist", "Qiqirn_Enterpriser", "Qiqirn_Lieuter", "Qiqirn_Mosstrooper" } }, -- Qiqirn
    {42,  7, "Aydeewa_Subterrane", { "Treant_Sapling" } }, -- Saplings
    {42,  8, "Aydeewa_Subterrane", { "Cave_Mold", "Slime_Mold" } }, -- Slimes
    {42,  9, "Aydeewa_Subterrane", { "Cave_Tiger" } }, -- Tigers
    {42, 10, "Aydeewa_Subterrane", { "Mold_Eater", "Slime_Eater" } }, -- Worms
    {43,  1, "Alzadaal_Undersea_Ruins", { "Qiqirn_Goldsmith", "Qiqirn_Poulterer" } }, -- Qiqirn
    {44,  1, "Caedarva_Mire", { "Marsh_Murre", "Slough_Skua" } }, -- Birds
    {44,  2, "Caedarva_Mire", { "Chigoe" } }, -- Chigoes
    {44,  3, "Caedarva_Mire", { "Jnun", "Llamhigyn_Y_Dwr" } }, -- Doomed
    {44,  4, "Caedarva_Mire", { "Spongilla_Fly", "Vauxia_Fly" } }, -- Flies
    {44,  5, "Caedarva_Mire", { "Heraldic_Imp", "Orderly_Imp" } }, -- Imps
    {44,  6, "Caedarva_Mire", { "Caedarva_Leech" } }, -- Leeches
    {44,  7, "Caedarva_Mire", { "Lamia_Idolater" } }, -- Qutrub
    {44,  8, "Caedarva_Mire", { "Treant_Sapling" } }, -- Saplings
    {44,  9, "Caedarva_Mire", { "Soulflayer" } }, -- Soulflayers
    {45,  1, "Yughott_Grotto", { "Grotto_Bats", "Stealth_Bat" } }, -- Bats
    {45,  2, "Yughott_Grotto", { "Orcish_Cursemaker", "Orcish_Fighter", "Orcish_Grunt", "Orcish_Neckchopper", "Orcish_Serjeant", "Orcish_Stonechucker" } }, -- Orcs
    {46,  1, "Fort_Ghelsba", { "Sentry_Lizard" } }, -- Lizards
    {46,  2, "Fort_Ghelsba", { "Orcish_Flamethrower" } }, -- Orcish Warmachines
    {46,  3, "Fort_Ghelsba", { "Orcish_Cursemaker", "Orcish_Fighter", "Orcish_Fodder", "Orcish_Grappler", "Orcish_Grunt", "Orcish_Mesmerizer", "Orcish_Neckchopper", "Orcish_Serjeant", "Orcish_Stonechucker" } }, -- Orcs
    {47,  1, "Palborough_Mines", { "Copper_Beetle" } }, -- Beetles
    {47,  2, "Palborough_Mines", { "Cave_Funguar" } }, -- Funguars
    {47,  3, "Palborough_Mines", { "Amber_Quadav", "Amethyst_Quadav", "Brass_Quadav", "Copper_Quadav", "Greater_Quadav", "Old_Quadav", "Onyx_Quadav", "Veteran_Quadav", "Young_Quadav" } }, -- Quadav
    {47,  4, "Palborough_Mines", { "Pit_Hare", "Rabid_Rat" } }, -- Rabbits
    {48,  1, "Giddeus", { "Digger_Wasp", "Giddeus_Bee" } }, -- Bees
    {48,  2, "Giddeus", { "Giant_Pugil", "Giddeus_Pugil", "Land_Pugil", "Puffer_Pugil", "Pugil", "Pug_Pugil" } }, -- Pugils
    {48,  3, "Giddeus", { "Dirt_Eater", "Earth_Eater" } }, -- Worms
    {48,  4, "Giddeus", { "Yagudo_Acolyte", "Yagudo_Initiate", "Yagudo_Mendicant", "Yagudo_Persecutor", "Yagudo_Piper", "Yagudo_Priest", "Yagudo_Scribe", "Yagudo_Theologist", "Yagudo_Votary" } }, -- Yagudo
    {49,  1, "Beadeaux", { "Caterpillar", "Larva" } }, -- Crawlers
    {49,  2, "Beadeaux", { "Big_Jaw", "Land_Pugil" } }, -- Pugils
    {49,  3, "Beadeaux", { "Ancient_Quadav", "Brass_Quadav", "Bronze_Quadav", "Copper_Quadav", "Darksteel_Quadav", "Elder_Quadav", "Emerald_Quadav", "Garnet_Quadav", "Gold_Quadav", "Iron_Quadav", "Mythril_Quadav", "Old_Quadav", "Platinum_Quadav", "Sapphire_Quadav", "Silver_Quadav", "Spinel_Quadav", "Steel_Quadav", "Topaz_Quadav", "Zircon_Quadav" } }, -- Quadav
    {49,  4, "Beadeaux", { "Broo", "Charging_Sheep" } }, -- Sheep
    {50,  1, "Davoi", { "Davoi_Hornet", "Davoi_Wasp" } }, -- Bees
    {50,  2, "Davoi", { "Wolf_Bat", "Wood_Bats" } }, -- Bats
    {50,  3, "Davoi", { "Geezard", "War_Lizard" } }, -- Lizards
    {50,  4, "Davoi", { "Orcish_Beastrider", "Orcish_Bowshooter", "Orcish_Brawler", "Orcish_Champion", "Orcish_Cursemaker", "Orcish_Dragoon", "Orcish_Dreadnought", "Orcish_Farkiller", "Orcish_Fighter", "Orcish_Firebelcher", "Orcish_Footsoldier", "Orcish_Gladiator", "Orcish_Impaler", "Orcish_Nightraider", "Orcish_Predator", "Orcish_Serjeant", "Orcish_Trooper", "Orcish_Veteran", "Orcish_Warchief", "Orcish_Zerker" } }, -- Orcs
    {50,  5, "Davoi", { "Davoi_Pugil", "Ferocious_Pugil", "Greater_Pugil" } }, -- Pugils
    {51,  1, "Monastic_Cavern", { "Orcish_Bowshooter", "Orcish_Footsoldier", "Orcish_Gladiator", "Orcish_Trooper", "Orcish_Veteran", "Orcish_Predator", "Orcish_Warchief", "Orcish_Zerker", "Orcish_Farkiller", "Orcish_Champion", "Orcish_Dragoon", "Orcish_Dreadnought", "Orcish_Protector" } }, -- Orcs
    {52,  1, "Castle_Oztroja", { "Bastion_Bats", "Bulwark_Bat" } }, -- Bats
    {52,  2, "Castle_Oztroja", { "Yagudo_Votary", "Yagudo_Theologist", "Yagudo_Priest", "Yagudo_Herald", "Yagudo_Drummer", "Yagudo_Oracle", "Yagudo_Interrogator", "Yagudo_Zealot", "Yagudo_Lutenist", "Yagudo_Conquistador", "Yagudo_Prior", "Yagudo_Sentinel", "Yagudo_Chanter", "Yagudo_Abbot", "Yagudo_Inquisitor", "Yagudo_Conductor", "Yagudo_Flagellant", "Yagudo_Assassin", "Yagudo_Prelate" } }, -- Yagudo
    {53,  1, "The_Boyahda_Tree", { "Robber_Crab", "Scavenger_Crab", "Steelshell", "Viseclaw" } }, -- Crabs
    {53,  2, "The_Boyahda_Tree", { "Knight_Crawler", "Mourning_Crawler", "Processionaire" } }, -- Crawlers
    {53,  3, "The_Boyahda_Tree", { "Darter", "Skimmer" } }, -- Flies
    {53,  4, "The_Boyahda_Tree", { "Death_Cap" } }, -- Funguars
    {53,  5, "The_Boyahda_Tree", { "Elder_Goobbue", "Old_Goobbue" } }, -- Goobbues
    {53,  6, "The_Boyahda_Tree", { "Korrigan", "Mourioche" } }, -- Mandragora
    {53,  7, "The_Boyahda_Tree", { "Moss_Eater" } }, -- Rabbits
    {53,  8, "The_Boyahda_Tree", { "Bark_Spider", "Bark_Tarantula" } }, -- Spiders
    {54,  1, "Lower_Delkfutts_Tower", { "Ancient_Bat", "Seeker_Bats" } }, -- Bats
    {54,  2, "Lower_Delkfutts_Tower", { "Gigas_Butcher", "Gigas_Hallwatcher", "Gigas_Punisher", "Gigas_Sculptor", "Giant_Gatekeeper", "Giant_Guard", "Giant_Lobber", "Giant_Sentry" } }, -- Gigas
    {54,  3, "Lower_Delkfutts_Tower", { "Goblin_Gambler", "Goblin_Leecher", "Goblin_Mugger" } }, -- Goblins
    {55,  1, "Middle_Delkfutts_Tower", { "Big_Bat", "Mold_Bats", "Stirge", "Tower_Bats" } }, -- Bats
    {55,  2, "Middle_Delkfutts_Tower", { "Giant_Gatekeeper", "Giant_Guard", "Gigas_Jailer", "Gigas_Kettlemaster", "Giant_Lobber", "Gigas_Quarrier", "Giant_Sentry", "Gigas_Wallwatcher" } }, -- Gigas
    {55,  3, "Middle_Delkfutts_Tower", { "Goblin_Furrier", "Goblin_Pathfinder", "Goblin_Shaman", "Goblin_Smithy" } }, -- Goblins
    {56,  1, "Upper_Delkfutts_Tower", { "Dire_Bat", "Incubus_Bats" } }, -- Bats
    {56,  2, "Upper_Delkfutts_Tower", { "Gigas_Bonecutter", "Gigas_Spirekeeper", "Gigas_Stonemason", "Gigas_Torturer", "Jotunn_Gatekeeper", "Jotunn_Hallkeeper", "Jotunn_Wallkeeper", "Jotunn_Wildkeeper" } }, -- Gigas
    {57,  1, "Den_of_Rancor", { "Dire_Bat", "Succubus_Bats" } }, -- Bats
    {57,  2, "Den_of_Rancor", { "Million_Eyes" } }, -- Hecteyes
    {57,  3, "Den_of_Rancor", { "Mousse" } }, -- Slimes
    {57,  4, "Den_of_Rancor", { "Puck" } }, -- Mandragora
    {57,  5, "Den_of_Rancor", { "Tonberry_Beleaguerer", "Tonberry_Imprecator", "Tonberry_Slasher", "Tonberry_Trailer" } }, -- Tonberries
    {57,  6, "Den_of_Rancor", { "Tormentor" } }, -- Lizards
    {58,  1, "Castle_Zvahl_Baileys", { "Ahriman", "Evil_Eye", "Morbid_Eye" } }, -- Ahriman
    {58,  2, "Castle_Zvahl_Baileys", { "Abyssal_Demon", "Arch_Demon", "Blood_Demon", "Demon_Chancellor", "Demon_Commander", "Demon_General", "Demon_Knight", "Demon_Magistrate", "Demon_Pawn", "Demon_Warlock", "Demon_Wizard", "Doom_Demon", "Dread_Demon", "Gore_Demon", "Judicator_Demon", "Stygian_Demon" } }, -- Demons
    {58,  3, "Castle_Zvahl_Baileys", { "Goblin_Poacher", "Goblin_Reaper", "Goblin_Robber", "Goblin_Trader" } }, -- Goblins
    {58,  4, "Castle_Zvahl_Baileys", { "Orcish_Bowshooter", "Orcish_Footsoldier", "Orcish_Gladiator", "Orcish_Trooper" } }, -- Orcs
    {58,  5, "Castle_Zvahl_Baileys", { "Elder_Quadav", "Emerald_Quadav", "Iron_Quadav", "Spinel_Quadav" } }, -- Quadav
    {58,  6, "Castle_Zvahl_Baileys", { "Yagudo_Conquistador", "Yagudo_Lutenist", "Yagudo_Prior", "Yagudo_Zealot" } }, -- Yagudo
    {59,  1, "Castle_Zvahl_Keep", { "Deadly_Iris", "Evil_Eye", "Morbid_Eye" } }, -- Ahriman
    {59,  2, "Castle_Zvahl_Keep", { "Demon_Knight", "Demon_Pawn", "Demon_Warlock", "Demon_Wizard" } }, -- Demons
    {59,  3, "Castle_Zvahl_Keep", { "Goblin_Bouncer", "Goblin_Enchanter", "Goblin_Hunter", "Goblin_Poacher", "Goblin_Reaper", "Goblin_Robber", "Goblin_Trader" } }, -- Goblins
    {59,  4, "Castle_Zvahl_Keep", { "Orcish_Bowshooter", "Orcish_Footsoldier", "Orcish_Gladiator", "Orcish_Predator", "Orcish_Trooper", "Orcish_Veteran", "Orcish_Warchief", "Orcish_Zerker" } }, -- Orcs
    {59,  5, "Castle_Zvahl_Keep", { "Elder_Quadav", "Emerald_Quadav", "Gold_Quadav", "Iron_Quadav", "Mythril_Quadav", "Spinel_Quadav", "Steel_Quadav", "Topaz_Quadav" } }, -- Quadav
    {59,  6, "Castle_Zvahl_Keep", { "Yagudo_Abbot", "Yagudo_Chanter", "Yagudo_Conquistador", "Yagudo_Inquisitor", "Yagudo_Lutenist", "Yagudo_Prior", "Yagudo_Sentinel", "Yagudo_Zealot", } }, -- Yagudo
    {60,  1, "Ranguemont_Pass", { "Bilesucker", "Blade_Bat", "Wind_Bats", "Seeker_Bats", "Stirge" } }, -- Bats
    {60,  2, "Ranguemont_Pass", { "Goblin_Artificer", "Goblin_Chaser", "Goblin_Gambler", "Goblin_Hoodoo", "Goblin_Leecher", "Goblin_Mugger", "Goblin_Tanner", "Goblin_Thug", "Goblin_Weaver" } }, -- Goblins
    {60,  3, "Ranguemont_Pass", { "Hecteyes", "Taisai" } }, -- Hecteyes
    {61,  1, "Bostaunieux_Oubliette", { "Blind_Bat", "Funnel_Bats", "Werebat" } }, -- Bats
    {61,  2, "Bostaunieux_Oubliette", { "Dabilla", "Garm", "Hecatomb_Hound" } }, -- Hounds
    {61,  3, "Bostaunieux_Oubliette", { "Bloodsucker" } }, -- Leeches
    {61,  4, "Bostaunieux_Oubliette", { "Acid_Grease", "Dark_Aspic", "Mousse", "Panna_Cotta" } }, -- Slimes
    {62,  1, "Toraimarai_Canal", { "Canal_Bats", "Hell_Bat", "Impish_Bats", "Deviling_Bats", "Dire_Bat" } }, -- Bats
    {62,  2, "Toraimarai_Canal", { "Bigclaw", "Plunderer_Crab", "Rock_Crab", "Scavenger_Crab" } }, -- Crabs
    {62,  3, "Toraimarai_Canal", { "Bloodsucker", "Bouncing_Ball", "Canal_Leech" } }, -- Leeches
    {62,  4, "Toraimarai_Canal", { "Blackwater_Pugil", "Makara" } }, -- Pugils
    {62,  5, "Toraimarai_Canal", { "Doom_Mage", "Doom_Soldier", "Drowned_Bones", "Fallen_Knight", "Lich", "Fleshcraver", "Mindcraver", "Rapier_Scorpion", "Sodden_Bones" } }, -- Skeletons
    {63,  1, "Zeruhn_Mines", { "Colliery_Bat", "Ding_Bats" } }, -- Bats
    {63,  2, "Zeruhn_Mines", { "River_Crab", "Soot_Crab" } }, -- Crabs
    {63,  3, "Zeruhn_Mines", { "Burrower_Worm" } }, -- Worms
    {64,  1, "Korroloka_Tunnel", { "Combat", "Seeker_Bats" } }, -- Bats
    {64,  2, "Korroloka_Tunnel", { "Clipper", "Lacerator", "Snipper" } }, -- Crabs
    {64,  3, "Korroloka_Tunnel", { "Gigas_Foreman", "Gigas_Stonecarrier", "Gigas_Stonegrinder", "Gigas_Stonemason" } }, -- Gigas
    {64,  4, "Korroloka_Tunnel", { "Goblin_Bounty_Hunter" } }, -- Goblins
    {64,  5, "Korroloka_Tunnel", { "Spool_Leech", "Thread_Leech" } }, -- Leeches
    {64,  6, "Korroloka_Tunnel", { "Greater_Pugil" } }, -- Pugils
    {64,  7, "Korroloka_Tunnel", { "Huge_Spider" } }, -- Spiders
    {64,  8, "Korroloka_Tunnel", { "Land_Worm" } }, -- Worms
    {65,  1, "Kuftal_Tunnel", { "Robber_Crab", "Scavenger_Crab" } }, -- Crabs
    {65,  2, "Kuftal_Tunnel", { "Goblin_Alchemist", "Goblin_Bandit", "Goblin_Mercenary", "Goblin_Tamer" } }, -- Goblins
    {65,  3, "Kuftal_Tunnel", { "Sand_Lizard" } }, -- Lizards
    {65,  4, "Kuftal_Tunnel", { "Deinonychus" } }, -- Raptors
    {65,  5, "Kuftal_Tunnel", { "Sabotender_Sediendo" } }, -- Sabotenders
    {65,  6, "Kuftal_Tunnel", { "Recluse_Spider" } }, -- Spiders
    {65,  7, "Kuftal_Tunnel", { "Machairodus", "Ovinnik" } }, -- Tigers
    {65,  8, "Kuftal_Tunnel", { "Cave_Worm", "Kuftal_Delver", "Kuftal_Digger" } }, -- Worms
    {66,  1, "The_Eldieme_Necropolis", { "Blood_Soul", "Haunt", "Revenant", "Utukku" } }, -- Ghosts
    {66,  2, "The_Eldieme_Necropolis", { "Hell_Hound", "Marchosias", "Nekros_Hound", "Tomb_Wolf" } }, -- Hounds
    {66,  3, "The_Eldieme_Necropolis", { "Dark_Stalker", "Ka", "Shade", "Spriggan" } }, -- Shadows
    {66,  4, "The_Eldieme_Necropolis", { "Fallen_Knight", "Hellbound_Warlock", "Hellbound_Warrior", "Lich", "Lost_Soul", "Mummy", "Tomb_Mage", "Tomb_Warrior" } }, -- Skeletons
    {67,  1, "Sea_Serpent_Grotto", { "Dire_Bat", "Nightmare_Bats", "Undead_Bats", "Vampire_Bat" } }, -- Bats
    {67,  2, "Sea_Serpent_Grotto", { "Bigclaw", "Greatclaw", "Ironshell", "Robber_Crab", "Rock_Crab" } }, -- Crabs
    {67,  3, "Sea_Serpent_Grotto", { "Royal_Leech", "Sahagin_Parasite" } }, -- Leeches
    {67,  4, "Sea_Serpent_Grotto", { "Big_Jaw", "Grotto_Pugil", "Razorjaw_Pugil", "Stygian_Pugil" } }, -- Pugils
    {67,  5, "Sea_Serpent_Grotto", { "Bog_Sahagin", "Brook_Sahagin", "Coastal_Sahagin", "Delta_Sahagin", "Lagoon_Sahagin", "Lake_Sahagin", "Marsh_Sahagin", "Pond_Sahagin", "Riparian_Sahagin", "Rivulet_Sahagin", "Shore_Sahagin", "Spring_Sahagin", "Swamp_Sahagin" } }, -- Sahagin
    {67,  6, "Sea_Serpent_Grotto", { "Devil_Manta", "Sea_Bonze" } }, -- Sea Monks
    {67,  7, "Sea_Serpent_Grotto", { "Ghast" } }, -- Skeletons
    {68,  1, "Dangruf_Wadi", { "Coral_Crab", "Land_Crab", "Trimmer", "Wadi_Crab" } }, -- Crabs
    {68,  2, "Dangruf_Wadi", { "Goblin_Ambusher", "Goblin_Bladesmith", "Goblin_Brigand", "Goblin_Bushwhacker", "Goblin_Butcher", "Goblin_Conjurer", "Goblin_Fisher", "Goblin_Headsman", "Goblin_Healer", "Goblin_Thug", "Goblin_Tinkerer", "Goblin_Weaver" } }, -- Goblins
    {68,  3, "Dangruf_Wadi", { "Couloir_Leech", "Thread_Leech", "Wadi_Leech" } }, -- Leeches
    {68,  4, "Dangruf_Wadi", { "Fume_Lizard", "Rock_Lizard", "Steam_Lizard" } }, -- Lizards
    {68,  5, "Dangruf_Wadi", { "Natty_Gibbon" } }, -- Opo-opo
    {68,  6, "Dangruf_Wadi", { "Hoarder_Hare", "Prim_Pika", "Wadi_Hare" } }, -- Rabbits
    {68,  7, "Dangruf_Wadi", { "Stone_Eater", "Witchetty_Grub" } }, -- Worms
    {69,  1, "Inner_Horutoto_Ruins", { "Battle_Bat", "Battue_Bats", "Blade_Bat", "Covin_Bat", "Troika_Bats" } }, -- Bats
    {69,  2, "Inner_Horutoto_Ruins", { "Boggart" } }, -- Evil Weapons
    {69,  3, "Inner_Horutoto_Ruins", { "Goblin_Flesher", "Goblin_Gambler", "Goblin_Leecher", "Goblin_Lurcher", "Goblin_Metallurgist", "Goblin_Mugger", "Goblin_Thug", "Goblin_Trailblazer", "Goblin_Weaver" } }, -- Goblins
    {69,  4, "Inner_Horutoto_Ruins", { "Magicked_Bones", "Skinnymajinx", "Skinnymalinks", "Wendigo" } }, -- Skeletons
    {70,  1, "Outer_Horutoto_Ruins", { "Battue_Bats", "Blade_Bat", "Fetor_Bats", "Stink_Bats", "Thorn_Bat" } }, -- Bats
    {70,  2, "Outer_Horutoto_Ruins", { "Eight_of_Batons", "Eight_of_Coins", "Eight_of_Cups", "Eight_of_Swords", "Four_of_Batons", "Four_of_Coins", "Four_of_Cups", "Four_of_Swords", "Five_of_Batons", "Five_of_Coins", "Five_of_Cups", "Five_of_Swords", "Nine_of_Batons", "Nine_of_Coins", "Nine_of_Cups", "Nine_of_Swords", "Seven_of_Batons", "Seven_of_Coins", "Seven_of_Cups", "Seven_of_Swords", "Six_of_Batons", "Six_of_Coins", "Six_of_Cups", "Six_of_Swords", "Ten_of_Batons", "Ten_of_Coins", "Ten_of_Cups", "Ten_of_Swords", "Three_of_Batons", "Three_of_Coins", "Three_of_Cups", "Three_of_Swords", "Two_of_Batons", "Two_of_Coins", "Two_of_Cups", "Two_of_Swords" } }, -- Cardians
    {70,  3, "Outer_Horutoto_Ruins", { "Goblin_Ambusher", "Goblin_Butcher", "Goblin_Thug", "Goblin_Tinkerer", "Goblin_Weaver" } }, -- Goblins
    {71,  1, "Ordelles_Caves", { "Ancient_Bat", "Stink_Bats", "Hognosed_Bat", "Seeker_Bats" } }, -- Bats
    {71,  2, "Ordelles_Caves", { "Dung_Beetle", "Goliath_Beetle", "Targe_Beetle" } }, -- Beetles
    {71,  3, "Ordelles_Caves", { "Fly_Agaric", "Shrieker" } }, -- Funguars
    {71,  4, "Ordelles_Caves", { "Goblin_Ambusher", "Goblin_Butcher", "Goblin_Furrier", "Goblin_Gambler", "Goblin_Leecher", "Goblin_Mugger", "Goblin_Shaman", "Goblin_Smithy", "Goblin_Tinkerer", "Goblin_Pathfinder" } }, -- Goblins
    {71,  5, "Ordelles_Caves", { "Thread_Leech", "Poison_Leech" } }, -- Leeches
    {71,  6, "Ordelles_Caves", { "Blood_Bunny", "Buds_Bunny", "Vorpal_Bunny" } }, -- Rabbits
    {71,  7, "Ordelles_Caves", { "Slash_Pine", "Stalking_Sapling", "Swagger_Spruce" } }, -- Saplings
    {72,  1, "Gusgen_Mines", { "Gallinipper", "Madfly", "Sadfly" } }, -- Flies
    {72,  2, "Gusgen_Mines", { "Fly_Agaric", "Myconid" } }, -- Funguars
    {72,  3, "Gusgen_Mines", { "Bogy", "Banshee" } }, -- Ghosts
    {72,  4, "Gusgen_Mines", { "Bandersnatch", "Mauthe_Doog" } }, -- Hounds
    {72,  5, "Gusgen_Mines", { "Accursed_Soldier", "Accursed_Sorcerer", "Ghast", "Ghoul", "Skeleton_Warrior", "Wendigo", "Wight" } }, -- Skeletons
    {72,  6, "Gusgen_Mines", { "Amphisbaena", "Ore_Eater", "Rockmill" } }, -- Worms
    {73,  1, "Crawlers_Nest", { "Death_Jacket", "Soul_Stinger", "Vespo", "Wespe" } }, -- Bees
    {73,  2, "Crawlers_Nest", { "Blazer_Beetle", "Helm_Beetle", "Nest_Beetle" } }, -- Beetles
    {73,  3, "Crawlers_Nest", { "King_Crawler", "Knight_Crawler", "Rumble_Crawler", "Soldier_Crawler", "Worker_Crawler" } }, -- Crawlers
    {73,  4, "Crawlers_Nest", { "Dancing_Jewel", "Dragonfly", "Hornfly" } }, -- Flies
    {73,  5, "Crawlers_Nest", { "Exoray", "Killer_Mushroom", "Olid_Funguar" } }, -- Funguars
    {73,  6, "Crawlers_Nest", { "Labyrinth_Lizard", "Maze_Lizard" } }, -- Lizards
    {73,  7, "Crawlers_Nest", { "Caveberry", "Witch_Hazel" } }, -- Saplings
    {74,  1, "Maze_of_Shakhrami", { "Ancient_Bat", "Chaser_Bats", "Combat", "Seeker_Bats", "Stink_Bats", "Warren_Bat" } }, -- Bats
    {74,  2, "Maze_of_Shakhrami", { "Carnivorous_Crawler", "Caterchipillar", "Crypterpillar" } }, -- Crawlers
    {74,  3, "Maze_of_Shakhrami", { "Goblin_Ambusher", "Goblin_Butcher", "Goblin_Furrier", "Goblin_Gambler", "Goblin_Leecher", "Goblin_Mugger", "Goblin_Pathfinder", "Goblin_Shaman", "Goblin_Smithy", "Goblin_Tinkerer" } }, -- Goblins
    {74,  4, "Maze_of_Shakhrami", { "Bleeder_Leech", "Poison_Leech" } }, -- Leeches
    {74,  5, "Maze_of_Shakhrami", { "Labyrinth_Scorpion", "Maze_Scorpion", "Wendigo", "Wight" } }, -- Scorpions
    {74,  6, "Maze_of_Shakhrami", { "Ghoul", "Wendigo", "Wight" } }, -- Skeletons
    {74,  7, "Maze_of_Shakhrami", { "Abyss_Worm", "Maze_Maker" } }, -- Worms
    {75,  1, "Garlaige_Citadel", { "Citadel_Bats", "Donjon_Bat", "Funnel_Bats", "Wingrats", "Siege_Bat" } }, -- Bats
    {75,  2, "Garlaige_Citadel", { "Borer_Beetle", "Chamber_Beetle", "Warden_Beetle" } }, -- Beetles
    {75,  3, "Garlaige_Citadel", { "Explosure", "Hellmine", "Kaboom", "Puroboros" } }, -- Bombs
    {75,  4, "Garlaige_Citadel", { "Demonic_Weapon", "Over_Weapon", "Vault_Weapon" } }, -- Evil Weapons
    {75,  5, "Garlaige_Citadel", { "Bhuta", "Revenant", "Wraith" } }, -- Ghosts
    {75,  6, "Garlaige_Citadel", { "Clockwork_Pod", "Droma", "Magic_Jug" } }, -- Magic Pots
    {75,  7, "Garlaige_Citadel", { "Fallen_Evacuee", "Fallen_Mage", "Fallen_Major", "Fallen_Officer", "Fallen_Soldier" } }, -- Skeletons
    {76,  1, "FeiYin", { "Balayang", "Camazotz", "Undead_Bats", "Underworld_Bats", "Vampire_Bat" } }, -- Bats
    {76,  2, "FeiYin", { "Drone", "Talos" } }, -- Dolls
    {76,  3, "FeiYin", { "Revenant", "Utukku", "Wekufe" } }, -- Ghosts
    {76,  4, "FeiYin", { "Clockwork_Pod", "Droma", "Sentient_Carafe" } }, -- Magic Pots
    {76,  5, "FeiYin", { "Shadow", "Specter" } }, -- Shadows
    {77,  1, "Ifrits_Cauldron", { "Dire_Bat", "Nightmare_Bats" } }, -- Bats
    {77,  2, "Ifrits_Cauldron", { "Volcanic_Bomb", "Volcanic_Gas" } }, -- Bombs
    {77,  3, "Ifrits_Cauldron", { "Goblin_Alchemist", "Goblin_Bandit", "Goblin_Mercenary", "Goblin_Shepherd" } }, -- Goblins
    {77,  4, "Ifrits_Cauldron", { "Old_Opo-opo" } }, -- Opo-opo
    {77,  5, "Ifrits_Cauldron", { "Eotyrannus" } }, -- Raptors
    {78,  1, "Quicksand_Caves", { "Antican_Aedilis", "Antican_Antesignanus", "Antican_Hastatus", "Antican_Princeps", "Antican_Quaestor", "Antican_Signifer", "Antican_Triarius" } }, -- Antica
    {78,  2, "Quicksand_Caves", { "Helm_Beetle" } }, -- Beetles
    {78,  3, "Quicksand_Caves", { "Sand_Lizard" } }, -- Lizards
    {78,  4, "Quicksand_Caves", { "Sabotender_Bailaor", "Spelunking_Sabotender" } }, -- Sabotenders
    {78,  5, "Quicksand_Caves", { "Sand_Spider", "Sand_Tarantula" } }, -- Spiders
    {78,  6, "Quicksand_Caves", { "Sand_Digger", "Sand_Eater" } }, -- Worms
    {79,  1, "Gustav_Tunnel", { "Robber_Crab" } }, -- Crabs
    {79,  2, "Gustav_Tunnel", { "Hawker" } }, -- Flies
    {79,  3, "Gustav_Tunnel", { "Goblin_Alchemist", "Goblin_Mercenary", "Goblin_Poacher", "Goblin_Reaper", "Goblin_Robber", "Goblin_Shepherd" } }, -- Goblins
    {79,  4, "Gustav_Tunnel", { "Demonic_Pugil", "Makara" } }, -- Pugils
    {79,  5, "Gustav_Tunnel", { "Doom_Guard", "Doom_Mage", "Doom_Soldier", "Doom_Warlock" } }, -- Skeletons
    {79,  6, "Gustav_Tunnel", { "Boulder_Eater" } }, -- Worms
    {80,  1, "Labyrinth_of_Onzozo", { "Cockatrice" } }, -- Cockatrice
    {80,  2, "Labyrinth_of_Onzozo", { "Torama" } }, -- Coeurls
    {80,  3, "Labyrinth_of_Onzozo", { "Goblin_Alchemist", "Goblin_Bandit", "Goblin_Bouncer", "Goblin_Enchanter", "Goblin_Hunter", "Goblin_Mercenary", "Goblin_Miner", "Goblin_Poacher", "Goblin_Reaper", "Goblin_Robber", "Goblin_Shepherd", "Goblin_Trader" } }, -- Goblins
    {80,  4, "Labyrinth_of_Onzozo", { "Mushussu" } }, -- Scorpions
    {80,  5, "Labyrinth_of_Onzozo", { "Flying_Manta" } }, -- Sea Monks
    {81,  1, "Dynamis-Bastok", { "Vanguard_Beasttender", "Vanguard_Constable", "Vanguard_Defender", "Vanguard_Drakekeeper", "Vanguard_Hatamoto", "Vanguard_Kusa", "Vanguard_Mason", "Vanguard_Minstrel", "Vanguard_Militant", "Vanguard_Protector", "Vanguard_Purloiner", "Vanguard_Thaumaturge", "Vanguard_Undertaker", "Vanguard_Vigilante", "Vanguard_Vindicator" } }, -- Quadav
    {82,  1, "Dynamis-San_dOria", { "Vanguard_Amputator", "Vanguard_Backstabber", "Vanguard_Bugler", "Vanguard_Dollmaster", "Vanguard_Footsoldier", "Vanguard_Grappler", "Vanguard_Gutslasher", "Vanguard_Hawker", "Vanguard_Impaler", "Vanguard_Mesmerizer", "Vanguard_Neckchopper", "Vanguard_Pillager", "Vanguard_Predator", "Vanguard_Trooper", "Vanguard_Vexer" } }, -- Orc
    {83,  1, "Dynamis-Windurst", { "Vanguard_Assassin", "Vanguard_Chanter", "Vanguard_Exemplar", "Vanguard_Inciter", "Vanguard_Liberator", "Vanguard_Ogresoother", "Vanguard_Oracle", "Vanguard_Partisan", "Vanguard_Persecutor", "Vanguard_Prelate", "Vanguard_Priest", "Vanguard_Salvager", "Vanguard_Sentinel", "Vanguard_Skirmisher", "Vanguard_Visionary" } }, -- Yagudo
    {84,  1, "Dynamis-Jeuno", { "Vanguard_Alchemist", "Vanguard_Ambusher", "Vanguard_Armorer", "Vanguard_Dragontamer", "Vanguard_Enchanter", "Vanguard_Hitman", "Vanguard_Maestro", "Vanguard_Necromancer", "Vanguard_Pathfinder", "Vanguard_Pitfighter", "Vanguard_Ronin", "Vanguard_Shaman", "Vanguard_Smithy", "Vanguard_Tinkerer", "Vanguard_Welldigger" } }, -- Goblin
    {85,  1, "Dynamis-Beaucedine", { "Vanguard_Alchemist", "Vanguard_Ambusher", "Vanguard_Armorer", "Vanguard_Dragontamer", "Vanguard_Enchanter", "Vanguard_Hitman", "Vanguard_Maestro", "Vanguard_Necromancer", "Vanguard_Pathfinder", "Vanguard_Pitfighter", "Vanguard_Ronin", "Vanguard_Shaman", "Vanguard_Smithy", "Vanguard_Tinkerer", "Vanguard_Welldigger" } }, -- Goblin
    {85,  2, "Dynamis-Beaucedine", { "Hydra_Bard", "Hydra_Beastmaster", "Hydra_Black_Mage", "Hydra_Dark_Knight", "Hydra_Dragoon", "Hydra_Monk", "Hydra_Ninja", "Hydra_Paladin", "Hydra_Ranger", "Hydra_Red_Mage", "Hydra_Samurai", "Hydra_Summoner", "Hydra_Thief", "Hydra_Warrior", "Hydra_White_Mage" } }, -- Hydra
    {85,  3, "Dynamis-Beaucedine", { "Vanguard_Amputator", "Vanguard_Backstabber", "Vanguard_Bugler", "Vanguard_Dollmaster", "Vanguard_Footsoldier", "Vanguard_Grappler", "Vanguard_Gutslasher", "Vanguard_Hawker", "Vanguard_Impaler", "Vanguard_Mesmerizer", "Vanguard_Neckchopper", "Vanguard_Pillager", "Vanguard_Predator", "Vanguard_Trooper", "Vanguard_Vexer" } }, -- Orc
    {85,  4, "Dynamis-Beaucedine", { "Vanguard_Beasttender", "Vanguard_Constable", "Vanguard_Defender", "Vanguard_Drakekeeper", "Vanguard_Hatamoto", "Vanguard_Kusa", "Vanguard_Mason", "Vanguard_Minstrel", "Vanguard_Militant", "Vanguard_Protector", "Vanguard_Purloiner", "Vanguard_Thaumaturge", "Vanguard_Undertaker", "Vanguard_Vigilante", "Vanguard_Vindicator" } }, -- Quadav
    {85,  5, "Dynamis-Beaucedine", { "Vanguard_Assassin", "Vanguard_Chanter", "Vanguard_Exemplar", "Vanguard_Inciter", "Vanguard_Liberator", "Vanguard_Ogresoother", "Vanguard_Oracle", "Vanguard_Partisan", "Vanguard_Persecutor", "Vanguard_Prelate", "Vanguard_Priest", "Vanguard_Salvager", "Vanguard_Sentinel", "Vanguard_Skirmisher", "Vanguard_Visionary" } }, -- Yagudo
    {86,  1, "Dynamis-Xarcabard", { "Kindred_Bard", "Kindred_Beastmaster", "Kindred_Black_Mage", "Kindred_Dark_Knight", "Kindred_Dragoon", "Kindred_Monk", "Kindred_Ninja", "Kindred_Paladin", "Kindred_Ranger", "Kindred_Red_Mage", "Kindred_Samurai", "Kindred_Summoner", "Kindred_Thief", "Kindred_Warrior", "Kindred_White_Mage" } }, -- Demon
    {87,  1, "RuAun_Gardens", { "Flamingo" } }, -- Birds
    {87,  2, "RuAun_Gardens", { "Groundskeeper" } }, -- Dolls
    {87,  3, "RuAun_Gardens", { "Sprinkler" } }, -- Magic Pots
    {88,  1, "VeLugannon_Palace", { "Mystic_Weapon", "Ornamental_Weapon" } }, -- Evil Weapons
    {88,  2, "VeLugannon_Palace", { "Enkidu" } }, -- Golems
    {88,  3, "VeLugannon_Palace", { "Dustbuster" } }, -- Magic Pots
    {88,  4, "VeLugannon_Palace", { "Detector" } }, -- Spheroids
    {89,  1, "The_Shrine_of_RuAvitau", { "Aura_Butler", "Aura_Gear" } }, -- Dolls
    {89,  2, "The_Shrine_of_RuAvitau", { "Aura_Weapon", "Decorative_Weapon" } }, -- Evil Weapons
    {89,  3, "The_Shrine_of_RuAvitau", { "Aura_Statue", "Aura_Sculpture" } }, -- Golems
    {89,  4, "The_Shrine_of_RuAvitau", { "Aura_Pot" } }, -- Magic Pots
    {89,  5, "The_Shrine_of_RuAvitau", { "Defender" } }, -- Spheroids
    {90,  1, "AlTaieu", { "Omaern", "Ruaern", "Ulaern" } }, -- Aern
    {90,  2, "AlTaieu", { "Omhpemde", "Ulhpemde" } }, -- Hpemde
    {90,  3, "AlTaieu", { "Omphuabo", "Ulphuabo" } }, -- Phuabo
    {90,  4, "AlTaieu", { "Omxzomit", "Ulxzomit" } }, -- Xzomit
    {91,  1, "Grand_Palace_of_HuXzoi", { "Eoaern", } }, -- Aern
    {91,  2, "Grand_Palace_of_HuXzoi", { "Eoeuvhi" } }, -- Euvhi
    {91,  3, "Grand_Palace_of_HuXzoi", { "Eoghrah" } }, -- Ghrah
    {91,  4, "Grand_Palace_of_HuXzoi", { "Eozdei" } }, -- Zdei
    {92,  1, "The_Garden_of_RuHmet", { "Awaern" } }, -- Aern
    {92,  2, "The_Garden_of_RuHmet", { "Aweuvhi" } }, -- Euvhi
    {92,  3, "The_Garden_of_RuHmet", { "Awghrah" } }, -- Ghrah
    {92,  4, "The_Garden_of_RuHmet", { "Awzdei", "Awzdei_Fast", "Awzdei_Still" } }, -- Zdei
    {93,  1, "Lufaise_Meadows", { "Death_Jacket", "Miner_Bee" } }, -- Bees
    {93,  2, "Lufaise_Meadows", { "Bugard", "Gigantobugard" } }, -- Bugards
    {93,  3, "Lufaise_Meadows", { "Fomor_Bard", "Fomor_Beastmaster", "Fomor_Black_Mage", "Fomor_Dark_Knight", "Fomor_Dragoon", "Fomor_Monk", "Fomor_Ninja", "Fomor_Paladin", "Fomor_Ranger", "Fomor_Red_Mage", "Fomor_Samurai", "Fomor_Summoner", "Fomor_Thief", "Fomor_Warrior" } }, -- Fomors
    {93,  4, "Lufaise_Meadows", { "Gigas_Braver", "Gigas_Catapulter", "Gigas_Fighter", "Gigas_Martialist", "Gigas_Slinger", "Gigas_Warwolf", "Gigas_Wrestler" } }, -- Gigas
    {93,  5, "Lufaise_Meadows", { "Orcish_Beastrider", "Orcish_Bowshooter", "Orcish_Brawler", "Orcish_Footsoldier", "Orcish_Gladiator", "Orcish_Impaler", "Orcish_Nightraider", "Orcish_Trooper" } }, -- Orcs
    {93,  6, "Lufaise_Meadows", { "Abraxas" } }, -- Rocs
    {93,  7, "Lufaise_Meadows", { "Tavnazian_Sheep" } }, -- Sheep
    {94,  1, "Misareaux_Coast", { "Death_Jacket", "Miner_Bee" } }, -- Bees
    {94,  2, "Misareaux_Coast", { "Bugard", "Gigantobugard" } }, -- Bugards
    {94,  3, "Misareaux_Coast", { "Fomor_Bard", "Fomor_Black_Mage", "Fomor_Dark_Knight", "Fomor_Dragoon", "Fomor_Monk", "Fomor_Ninja", "Fomor_Paladin", "Fomor_Ranger", "Fomor_Red_Mage", "Fomor_Samurai", "Fomor_Summoner", "Fomor_Thief", "Fomor_Warrior" } }, -- Fomors
    {94,  4, "Misareaux_Coast", { "Gigas_Braver", "Gigas_Catapulter", "Gigas_Martialist", "Gigas_Warwolf" } }, -- Gigas
    {94,  5, "Misareaux_Coast", { "Orcish_Bowshooter", "Orcish_Footsoldier", "Orcish_Gladiator", "Orcish_Trooper" } }, -- Orcs
    {94,  6, "Misareaux_Coast", { "Makara" } }, -- Pugils
    {94,  7, "Misareaux_Coast", { "Tavnazian_Sheep" } }, -- Sheep
    {95,  1, "Phomiuna_Aqueducts", { "Diremite" } }, -- Diremites
    {95,  2, "Phomiuna_Aqueducts", { "Fomor_Bard", "Fomor_Beastmaster", "Fomor_Black_Mage", "Fomor_Dark_Knight", "Fomor_Dragoon", "Fomor_Monk", "Fomor_Ninja", "Fomor_Paladin", "Fomor_Ranger", "Fomor_Red_Mage", "Fomor_Samurai", "Fomor_Summoner", "Fomor_Thief", "Fomor_Warrior" } }, -- Fomors
    {95,  3, "Phomiuna_Aqueducts", { "Big_Jaw", "Makara" } }, -- Pugils
    {95,  4, "Phomiuna_Aqueducts", { "Stegotaur", "Taurus" } }, -- Tauri
    {96,  1, "Sacrarium", { "Fomor_Bard", "Fomor_Beastmaster", "Fomor_Black_Mage", "Fomor_Dark_Knight", "Fomor_Dragoon", "Fomor_Monk", "Fomor_Ninja", "Fomor_Paladin", "Fomor_Ranger", "Fomor_Red_Mage", "Fomor_Samurai", "Fomor_Summoner", "Fomor_Thief", "Fomor_Warrior" } }, -- Fomors
    {96,  2, "Sacrarium", { "Lich", "Mummy" } }, -- Skeletons
    {96,  3, "Sacrarium", { "Aqueduct_Spider" } }, -- Spiders
    {96,  4, "Sacrarium", { "Stegotaur", "Teratotaur" } }, -- Tauri
    {97,  1, "Riverne-Site_A01", { "Riverne_Vulture" } }, -- Birds
    {97,  2, "Riverne-Site_A01", { "Atomic_Cluster" } }, -- Clusters
    {97,  3, "Riverne-Site_A01", { "Darner", "Hawker" } }, -- Flies
    {97,  4, "Riverne-Site_A01", { "Hawkertrap" } }, -- Flytraps
    {97,  5, "Riverne-Site_A01", { "Cloud_Hippogryph", "Hippogryph" } }, -- Hippogryphs
    {97,  6, "Riverne-Site_A01", { "Firedrake", "Flamedrake" } }, -- Wyverns
    {98,  1, "Riverne-Site_B01", { "Nitro_Cluster" } }, -- Clusters
    {98,  2, "Riverne-Site_B01", { "Nimbus_Hippogryph", "Strato_Hippogryph" } }, -- Hippogryphs
    {98,  3, "Riverne-Site_B01", { "Lunantishee" } }, -- Morbols
    {98,  4, "Riverne-Site_B01", { "Lesser_Roc" } }, -- Rocs
    {98,  5, "Riverne-Site_B01", { "Pyrodrake", "Ignidrake", "Blazedrake" } }, -- Wyverns
--    {99,  1, "Escha_ZiTah", { "Eschan_Mosquito", "Eschan_Wasp" } }, -- Bees
--    {99,  2, "Escha_ZiTah", { "Eschan_Bugard" } }, -- Bugards
--    {99,  3, "Escha_ZiTah", { "Eschan_Coeurl" } }, -- Coeurls
--    {99,  4, "Escha_ZiTah", { "Eschan_Corse" } }, -- Corses
--    {99,  5, "Escha_ZiTah", { "Eschan_Crawler" } }, -- Crawlers
--    {99,  6, "Escha_ZiTah", { "Eschan_Dhalmel" } }, -- Dhalmels
--    {99,  7, "Escha_ZiTah", { "Eschan_Shadow_Dragon" } }, -- Dragons
--    {99,  8, "Escha_ZiTah", { "Eschan_Tarichuk" } }, -- Efts
--    {99,  9, "Escha_ZiTah", { "Eschan_Opo-opo" } }, -- Opo-opo
--    {99,  10, "Escha_ZiTah", { "Eschan_Puk" } }, -- Puks
--    {100,  1, "Escha_RuAun", { "Eschan_Ilaern" } }, -- Aern
--    {100,  2, "Escha_RuAun", { "Eschan_Amoeban" } }, -- Amoeban
--    {100,  3, "Escha_RuAun", { "Eschan_Clionid" } }, -- Clionidae
--    {100,  4, "Escha_RuAun", { "Eschan_Euvhi" } }, -- Euvhi
--    {100,  5, "Escha_RuAun", { "Eschan_Gargouille" } }, -- Gargouilles
--    {100,  6, "Escha_RuAun", { "Eschan_Ghrah" } }, -- Ghrah
--    {100,  7, "Escha_RuAun", { "Eschan_Hpemde" } }, -- Hpemde
--    {100,  8, "Escha_RuAun", { "Eschan_Limule" } }, -- Limule
--    {100,  9, "Escha_RuAun", { "Eschan_Murex" } }, -- Murex
--    {100,  10, "Escha_RuAun", { "Eschan_Phuabo" } }, -- Phuabo
--    {100,  11, "Escha_RuAun", { "Eschan_Porxie" } }, -- Porxies
--    {100,  12, "Escha_RuAun", { "Eschan_Xzomit" } }, -- Xzomit
--    {100,  13, "Escha_RuAun", { "Eschan_Yovra" } }, -- Yovra
--    {100,  14, "Escha_RuAun", { "Eschan_Zdei" } }, -- Zdei
}

local pathWithFilename = io.popen("cd"):read'*all'

-- Checks to validate that the file exists before trying to override it
for _, entry in pairs(killAmtMobs) do
    local zoneName    = entry[3]
    local mobNamesLength = #(entry[4])

    for i = 1, mobNamesLength do
        local mobName = entry[4][i]
        local filename = pathWithFilename:sub(1, -2) .. string.format("\\scripts\\zones\\%s\\mobs\\%s", zoneName, mobName) .. ".lua"
        local exists = io.open(filename,"r")
        if exists ~= nil then
            io.close(exists)
        else
            xi.module.ensureTable(string.format("xi.zones.%s.mobs.%s", zoneName, mobName))
        end
    end
end

local function showProgress(player, amount, mobNameFull, zoneNameFull)
    local mobName  = string.gsub(mobNameFull, "_", " ")
    local zoneName = string.gsub(zoneNameFull, "_", " ")

    player:printToPlayer(string.format("Daily Quest: %u kills remain. (%s in %s)", amount, mobName, zoneName), xi.msg.channel.SYSTEM_3)
end

-- Apply the override to each mob's onMobDeath function
for _, entry in pairs(killAmtMobs) do
    local zoneNum        = entry[1]
    local mobTypeNum     = entry[2]
    local zoneName       = entry[3]
    local mobNamesLength = #(entry[4])

    -- Loop through every mob
    for i = 1, mobNamesLength do
        local mobName = entry[4][i]
        local mobLuaFile = string.format("xi.zones.%s.mobs.%s.onMobDeath", zoneName, mobName)

        -- Create the override
        m:addOverride(mobLuaFile, function(mob, player, optParams)
            super(mob, player, optParams)

            if player ~= nil then
                local dailyQuestActive = player:getCharVar("[DQ]Murdoc")
                local dailyZone        = player:getCharVar("[DQ]Murdoc_Z")
                local dailyMobType     = player:getCharVar("[DQ]Murdoc_MT")
                local dailyMobKillAmt  = player:getCharVar("[DQ]Murdoc_KA")

                -- If they actual assigned assigned to kill these mobs
                if
                    dailyQuestActive == 1 and
                    dailyZone == zoneNum and
                    dailyMobType == mobTypeNum
                then
                    -- If it's not the last kill
                    if dailyMobKillAmt > 1 then
                        player:setCharVar("[DQ]Murdoc_KA",dailyMobKillAmt - 1)
                        showProgress(player, dailyMobKillAmt - 1, mobName, zoneName)
                    -- If it IS the last kill, advance the quest and tell them to return to the NPC for reward
                    elseif dailyMobKillAmt == 1 then
                        player:setCharVar("[DQ]Murdoc_KA",dailyMobKillAmt - 1)
                        player:setCharVar("[DQ]Murdoc",2)
                        player:printToPlayer( string.format("You've killed enough %ss, please return to Murdox to claim your reward!", mob:getName():gsub("_", " ")), 17)
                    end
                end
            end
        end)
    end
end

return m
