-----------------------------------
-- Daily Quest : Mistrix
-- Craft up a certain signed item
-----------------------------------
require("modules/module_utils")
require("scripts/zones/Lower_Jeuno/Zone")
local ID = require("scripts/zones/Lower_Jeuno/IDs")
-----------------------------------
local m = Module:new("daily_quest_mistrix")

m:addOverride("xi.zones.Lower_Jeuno.Zone.onInitialize", function(zone)

    super(zone)

    -- This table is for all the items that will be requested as signed items for turn in
    local craftItems = {
        { "acid kukri", 16479, 16494 },
        { "aspis", 12299, 12325 },
        { "beak jerkin", 13699, 13739 },
        { "beetle earring", 13323, 13326 },
        { "bilbo", 16512, 16632 },
        { "blind dagger", 16454, 16493 },
        { "bone hairpin", 12505, 13825 },
        { "bone knife", 17610, 17611 },
        { "bone patas", 16420, 17477 },
        { "b0ne ring", 13441, 13500 },
        { "boomerang", 17280, 17287 },
        { "bowl of pea soup", 4416, 4327 },
        { "bowl of puls", 4492, 4533 },
        { "bowl of pumpkin soup", 4430, 4522 },
        { "brass cap", 12449, 12528 },
        { "brass hammer", 17043, 17149 },
        { "brass knuckles", 16391, 16689 },
        { "brass mask", 12433, 12532 },
        { "brass ring", 13465, 13493 },
        { "brass xiphos", 16531, 16802 },
        { "bronze cap", 12448, 12463 },
        { "bronze sword", 16535, 16623 },
        { "buckler", 12301, 12327 },
        { "cape", 13583, 13605 },
        { "chain gorget", 13082, 13059 },
        { "chestnut club", 17025, 17139 },
        { "chestnut sabots", 12986, 13022 },
        { "chocobo gloves", 14072, 14073 },
        { "corsette", 13271, 13272 },
        { "crow gaiters", 15663, 15664 },
        { "cuffs", 12728, 12744 },
        { "debahocho", 21923, 21924 },
        { "ebony wand", 17054, 17427 },
        { "elm pole", 17097, 17119 },
        { "ether tank", 13682, 13682 },
        { "falchion", 16558, 16615 },
        { "flame degen", 16522, 16823 },
        { "flute", 17345, 17372, 17844 },
        { "gust claymore", 18366, 18367 },
        { "harp", 17354, 17374 },
        { "high mana wand", 18403, 18403 },
        { "himantes", 16388, 16699 },
        { "holy mace", 17041, 17411 },
        { "horn", 17352, 17371 },
        { "horn hairpin", 12507, 13828 },
        { "horn ring", 13459, 13502 },
        { "inferno axe", 16709, 16713 },
        { "inferno sword", 16594, 16928 },
        { "iron visor", 13871, 13872 },
        { "jack-o-lantern", 4488, 4488 },
        { "jar of enchanted ink", 2774, 2774 },
        { "kaman", 17156, 17182 },
        { "leather ring", 13469, 13499 },
        { "linen mitts", 12738, 12780 },
        { "lizard cesti", 16386, 16398 },
        { "lucent axe", 18481, 18481 },
        { "mace", 17035, 17145 },
        { "magic belt", 13195, 13219 },
        { "mahogany pole", 17099, 17521 },
        { "manashell ring", 15782, 15782 },
        { "mana cloak", 14491, 14491 },
        { "maple cake", 5625, 5626 },
        { "melt knife", 18011, 18011 },
        { "mist crown", 15162, 15162 },
        { "mist pumps", 15312, 15312 },
        { "mitts", 12736, 12775 },
        { "mohbwa sash", 15905, 15906 },
        { "mokuto", 16906, 16925 },
        { "mufflers", 12682, 12792 },
        { "mythril baselard", 16456, 16752 },
        { "mythril breastplate", 12545, 13737 },
        { "mythril gorget", 13084, 13067 },
        { "mythril knife", 16467, 16739 },
        { "mythril kukri", 16475, 16750 },
        { "mythril mace", 17036, 17147 },
        { "mythril ring", 13446, 13519 },
        { "nodowa", 13111, 13124 },
        { "oak cudgel", 17027, 17142 },
        { "oak pole", 17098, 17120 },
        { "orange au lait tank", 16223, 16223 },
        { "passaddhi staff", 18606, 18615 },
        { "patas", 16419, 16696 },
        { "pepperoni pizza", 5697, 5698 },
        { "plate of ic pilav", 5584, 5585 },
        { "poets circlet", 12473, 12530 },
        { "poison dagger", 16496, 16741 },
        { "potion tank", 13684, 13684 },
        { "powder boots", 15320, 15320 },
        { "raptor jerkin", 12572, 13727 },
        { "robe", 12600, 12615 },
        { "rod", 17060, 17146 },
        { "rose harp", 17355, 17376 },
        { "rose wand", 17053, 17143 },
        { "sacred sword", 17682, 17682 },
        { "sandals", 12993, 13048 },
        { "seito", 17797, 17797 },
        { "serving of bavarois", 5729, 5730 },
        { "serving of bison steak", 5142, 5157 },
        { "serving of goblin stir-fry", 5143, 5143 },
        { "serving of mont blanc", 5557, 5558 },
        { "shell hairpin", 12506, 13836 },
        { "shock subligar", 15650, 15650 },
        { "shoes", 12994, 13040 },
        { "silence dagger", 16495, 16508 },
        { "silk coat", 12604, 12652 },
        { "silver ring", 13456, 13518 },
        { "slacks", 12864, 12898 },
        { "slice of roast mutton", 4437, 4335 },
        { "slice of salted hare", 5737, 5737 },
        { "smilodon ring", 15836, 15837 },
        { "steel greaves", 14120, 14121 },
        { "stone bangles", 14988, 14988 },
        { "thunder mittens", 14987, 14987 },
        { "tough belt", 15864, 15864 },
        { "traders saio", 14446, 14447 },
        { "traversiere", 17348, 17375 },
        { "vagabond's gloves", 14068, 14069 },
        { "vagabond's hose", 14290, 14291 },
        { "vulcan claymore", 18379, 18379 },
        { "warp cudgel", 17040, 17040 },
        { "white mitts", 12737, 13953 },
        { "windurstian kukri", 17978, 17979 },
        { "windurst salad", 4555, 4321 },
        { "wolf mantle", 13571, 13609 },
        { "wool doublet", 13752, 13753 },
        { "wool hose", 12851, 12907 },
    }

    -- Handles the functionality of the "daily reset" at midnight
    local handleMidnight = function(player)
        local questMidnight = player:getCharVar("[DQ]Midnight")
        local currentMidnight = getMidnight()

        -- handle first time quest midnight
        if questMidnight == 0 then
            player:setCharVar("[DQ]Midnight", currentMidnight)
            player:setCharVar("[DQ]Completed", 0)
            player:setCharVar("[DQ]Reset", 0)
            player:setCharVar("[DQ]Fishstix", 0)
            player:setCharVar("[DQ]Fishstix_Z", 0)
            player:setCharVar("[DQ]Murdoc", 0)
            player:setCharVar("[DQ]Murdoc_Z", 0)
            player:setCharVar("[DQ]Murdoc_MT", 0)
            player:setCharVar("[DQ]Murdoc_KA", 0)
            player:setCharVar("[DQ]Mistrix", 0)
            player:setCharVar("[DQ]Mistrix_I", 0)
            player:setCharVar("[DQ]Saltlik", 0)
            player:setCharVar("[DQ]Saltlik_Z", 0)
            player:setCharVar("[DQ]Saltlik_NM", 0)
            player:setCharVar("[DQ]Beetrix", 0)
            player:setCharVar("[DQ]Beetrix_Z", 0)
            player:setCharVar("[DQ]Beetrix_RE", 0)
        end
        
        -- handle midnight reset
        if currentMidnight ~= questMidnight then
            player:setCharVar("[DQ]Midnight", currentMidnight)
            player:setCharVar("[DQ]Completed", 0)
            player:setCharVar("[DQ]Reset", 0)
            player:setCharVar("[DQ]Fishstix", 0)
            player:setCharVar("[DQ]Fishstix_Z", 0)
            player:setCharVar("[DQ]Murdoc", 0)
            player:setCharVar("[DQ]Murdoc_Z", 0)
            player:setCharVar("[DQ]Murdoc_MT", 0)
            player:setCharVar("[DQ]Murdoc_KA", 0)
            player:setCharVar("[DQ]Mistrix", 0)
            player:setCharVar("[DQ]Mistrix_I", 0)
            player:setCharVar("[DQ]Saltlik", 0)
            player:setCharVar("[DQ]Saltlik_Z", 0)
            player:setCharVar("[DQ]Saltlik_NM", 0)
            player:setCharVar("[DQ]Beetrix", 0)
            player:setCharVar("[DQ]Beetrix_Z", 0)
            player:setCharVar("[DQ]Beetrix_RE", 0)
        end
    end

    -- Adds the NPC into Lower Jeuno
    local mistrix = zone:insertDynamicEntity({

        objtype = xi.objType.NPC,
        name = "Mistrix",
        look = 493,
        x = -52.7539,
        y = 0.000,
        z = -60.3718,
        rotation = 246,
        widescan = 1,

        -- Handles the ability to reset daily quest for 50k gil
        onTrade = function(player, npc, trade)
            -- Check to see if daily reset needs to happen first
            handleMidnight(player)
            npc:facePlayer(player, true)

            local questStage = player:getCharVar("[DQ]Mistrix")
            local completedDailyQuests = player:getCharVar("[DQ]Completed")
            local resetCount = player:getCharVar("[DQ]Reset")
            local gil = trade:getGil()
            local cost = 50000

            if player:isCrystalWarrior() then
                cost = 15000
            end

            -- If the player makes a trade with 50k gil
            if gil == cost then
                -- If they trade something else besides gil
                if trade:getItemCount() ~= 1 then
                    player:printToPlayer("I only accept gil as payment.", 0, npc:getPacketName())
                    return
                else
                    -- If the daily is already not given out, no need to reset
                    if questStage == 0 then
                        player:printToPlayer("You don't need to reset this daily, the quest has not been given yet.", 0, npc:getPacketName())
                        return
                    -- If the daily is already completed, no reset allowed
                    elseif questStage == 2 then
                        player:printToPlayer("You can't reset a completed daily. Come back tomorrow for more.", 0, npc:getPacketName())
                        return
                    else
                        -- If they've already done their 3 resets a day, no more reset allowed
                        if resetCount >= 3 then
                            player:printToPlayer("You can only reset a daily quest a max of 3 times per day across ALL dailies. Come back tomorrow for more.", 0, npc:getPacketName())
                            return
                        else
                            -- If it's a valid reset, reset the daily
                            player:tradeComplete()
                            player:setCharVar("[DQ]Reset", resetCount + 1)
                            player:setCharVar("[DQ]Mistrix", 0)
                            player:setCharVar("[DQ]Mistrix_I", 0)
                            player:printToPlayer(string.format("You have successfully reset my daily quest. Resets remaining today: %d.",(3 - (resetCount + 1))), 0, npc:getPacketName())
                        end
                    end
                end
            -- If they are trading in the items for the quest, NOT for the reset
            else
                -- This handles assigned the quest and handling setting the reward for quest completion
                if questStage == 1 then
                    -- Check to see if daily reset needs to happen first
                    handleMidnight(player)
                    local questItem = player:getCharVar("[DQ]Mistrix_I")
                    local questCraftItemTable = craftItems[questItem]
                    local questCraftItemName = questCraftItemTable[1]
                    local tradeValid = false
                    for i, item in ipairs(questCraftItemTable) do
                        if i > 1 and npcUtil.tradeHasExactly(trade, item) then
                            tradeValid = true
                            break
                        end
                    end

                    if
                        tradeValid
                    then
                        local signature = trade:getItem():getSignature()
                        -- Check to make sure that the signed item is properly signed (can't get from AH)
                        local signCheck = string.len(signature) > 0 and
                                            (player:isClassicMode() or
                                            signature == player:getName())
                        if signCheck then
                            -- Handle the reward
                            player:tradeComplete()
                            player:setCharVar("[DQ]Mistrix",2)
                            player:setCharVar("[DQ]Completed", completedDailyQuests + 1, getMidnight())
                            player:printToPlayer("Congratulations! You've completed my quest for today, here's your reward!", 0, npc:getPacketName())
                            player:addCurrency('obsidian_fragment', 300)
                            player:printToPlayer("You have obtained 300 Obsidian Fragments!", 17)
                        else
                            player:tradeRelease()
                            player:printToPlayer(string.format("I said I need a SIGNED %s, please use a HQ crystal and try again!",questCraftItemName), 0, npc:getPacketName())
                        end
                    else
                        player:printToPlayer(string.format("I said I need a signed %s, and only a signed %s, please try again!",string.upper(questCraftItemName),string.upper(questCraftItemName)), 0, npc:getPacketName())
                    end
                else
                    player:printToPlayer(string.format("You can trade me %u gil to reset this daily quest (3 resets a day max across all dailies).", cost), 0, npc:getPacketName())
                end
            end
        end,

        -- This handles assigning the quest
        onTrigger = function(player, npc)
            -- Check to see if daily reset needs to happen first
            handleMidnight(player)
            local questStage = player:getCharVar("[DQ]Mistrix")
            local questDesc = "Craft me up a signed {} and trade it to me!"
            if player:isClassicMode() then
                questDesc = "Find someone to craft a signed {} and trade it to me!"
            end
            
            -- Handle quest stages
            -- Quest hasn't been started yet, assign a random signed item to craft
            if questStage == 0 then
                local randNum = math.random(1, #craftItems)
                local questCraftItemName = craftItems[randNum][1]
                player:setCharVar("[DQ]Mistrix",1)
                player:setCharVar("[DQ]Mistrix_I",randNum)
                player:printToPlayer(fmt(questDesc,questCraftItemName), 0, npc:getPacketName())
                return
            -- Quest has been started already, just reiterate their quest to them
            elseif questStage == 1 then
                local questItem = player:getCharVar("[DQ]Mistrix_I")
                local questCraftItemName = craftItems[questItem][1]
                player:printToPlayer(fmt(questDesc,questCraftItemName), 0, npc:getPacketName())
                return
            -- The quest as already been completed
            elseif questStage == 2 then
                player:printToPlayer("You've already completed this quest today! Come back tomorrow for more.", 0, npc:getPacketName())
                return
            end
        end,
    })

    utils.unused(mistrix)

end)

return m
