-----------------------------------
-- Daily Quest : Goldilox
-- Daily Quest Reward NPC
-----------------------------------
require("modules/module_utils")
require("scripts/globals/npc_util")
require("scripts/globals/shop")
require("scripts/globals/utils")
require("scripts/zones/Lower_Jeuno/Zone")
local ID = require("scripts/zones/Lower_Jeuno/IDs")
-----------------------------------
local m = Module:new("npc_dq_goldilox")

local dailyBonus =
{
    {  100,  200 },
    {  200,  400 },
    {  400,  600 },
    {  600,  800 },
    {  800, 1200 },
}

local dailyRewards =
{
    -- 1 DQ Completed
    {
        coin = 656,-- Beastcoin
        rock =
        {
            769, -- Red Rock
            770, -- Blue Rock
            771, -- Yellow Rock
            772, -- Green Rock
            773, -- Translucent Rock
            774, -- Purple Rock
            775, -- Black Rock
            776, -- White Rock
        },
        mats =
        {
            { cexi.rate.VERY_RARE, xi.item.GOBLIN_STONE }, -- Goblin Stone (1%)

            -- Alchemy
            { cexi.rate.VERY_COMMON, 912 }, -- Beehive Chip      (24%)
            { cexi.rate.COMMON,      926 }, -- Lizard Tail       (15%)
            { cexi.rate.RARE,        940 }, -- Revival Tree Root ( 5%)

            -- Bonecraft
            { cexi.rate.VERY_COMMON, 888 }, -- Seashell  (24%)
            { cexi.rate.COMMON,      880 }, -- Bone Chip (15%)
            { cexi.rate.RARE,        891 }, -- Bat Fang  ( 5%)

            -- Clothcraft
            { cexi.rate.VERY_COMMON, 833 }, -- Moko Grass      (24%)
            { cexi.rate.COMMON,      840 }, -- Chocobo Feather (15%)
            { cexi.rate.RARE,        834 }, -- Saruta Cotton   ( 5%)

            -- Cooking
            { cexi.rate.VERY_COMMON,  936 }, -- Rock Salt   (24%)
            { cexi.rate.COMMON,       629 }, -- Millioncorn (15%)
            { cexi.rate.RARE,        4358 }, -- Hare Meat   ( 5%)

            -- Goldsmithing
            { cexi.rate.VERY_COMMON, 768 }, -- Flint Stone (24%)
            { cexi.rate.COMMON,      642 }, -- Zinc Ore    (15%)
            { cexi.rate.RARE,        736 }, -- Silver Ore  ( 5%)

            -- Leathercraft
            { cexi.rate.VERY_COMMON, 856 }, -- Rabbit Hide (24%)
            { cexi.rate.COMMON,      852 }, -- Lizard Skin (15%)
            { cexi.rate.RARE,        505 }, -- Sheepskin   ( 5%)

            -- Smithing
            { cexi.rate.VERY_COMMON, 640 }, -- Copper Ore (24%)
            { cexi.rate.COMMON,      541 }, -- Tin Ore    (15%)
            { cexi.rate.RARE,        643 }, -- Iron Ore   ( 5%)

            -- Woodworking
            { cexi.rate.VERY_COMMON, 689 }, -- Lauan Log (24%)
            { cexi.rate.COMMON,      691 }, -- Maple Log (15%)
            { cexi.rate.RARE,        698 }, -- Ash Log   ( 5%)
        },
    },

    -- 2 DQs Completed
    {
        coin = 750, -- Silver Beastcoin
        rock =
        {
            3297, -- Flame Geode
            3298, -- Snow Geode
            3299, -- Breeze Geode
            3300, -- Soil Geode
            3301, -- Thunder Geode
            3302, -- Aqua Geode
            3303, -- Light Geode
            3304, -- Shadow Geode
        },
        mats =
        {
            { cexi.rate.VERY_RARE, xi.item.GOBLIN_STONE }, -- Goblin Stone (1%)
            { cexi.rate.VERY_RARE, xi.item.GOBLIN_STONE }, -- Goblin Stone (1%)

            -- Alchemy
            { cexi.rate.VERY_COMMON, 925 }, -- Giant Stinger (24%)
            { cexi.rate.COMMON,      637 }, -- Slime Oil     (15%)
            { cexi.rate.RARE,        920 }, -- Malboro Vine  ( 5%)

            -- Bonecraft
            { cexi.rate.VERY_COMMON, 882 }, -- Sheep Tooth  (24%)
            { cexi.rate.COMMON,      881 }, -- Crab Shell   (15%)
            { cexi.rate.RARE,        894 }, -- Beetle Jaw   ( 5%)

            -- Clothcraft
            { cexi.rate.VERY_COMMON, 835 }, -- Flax Flower     (24%)
            { cexi.rate.COMMON,      847 }, -- Bird Feather    (15%)
            { cexi.rate.RARE,        839 }, -- Crawler Cocoon  ( 5%)

            -- Cooking
            { cexi.rate.VERY_COMMON, 4387 }, -- Wild Onion   (24%)
            { cexi.rate.COMMON,      4359 }, -- Dhalmel Meat (15%)
            { cexi.rate.RARE,        4362 }, -- Lizard Egg   ( 5%)

            -- Goldsmithing
            { cexi.rate.VERY_COMMON, 736 }, -- Silver Ore  (24%)
            { cexi.rate.COMMON,      644 }, -- Mythril Ore (15%)
            { cexi.rate.RARE,        737 }, -- Gold Ore    ( 5%)

            -- Leathercraft
            { cexi.rate.VERY_COMMON, 857 }, -- Dhalmel Hide (24%)
            { cexi.rate.COMMON,      854 }, -- Wolf Skin    (15%)
            { cexi.rate.RARE,        859 }, -- Ram Skin     ( 5%)

            -- Smithing
            { cexi.rate.VERY_COMMON,  643 }, -- Iron Ore      (24%)
            { cexi.rate.COMMON,      1155 }, -- Iron Sand     (15%)
            { cexi.rate.RARE,         645 }, -- Darksteel Ore ( 5%)

            -- Woodworking
            { cexi.rate.VERY_COMMON, 696 }, -- Yew Log      (24%)
            { cexi.rate.COMMON,      694 }, -- Chestnut Log (15%)
            { cexi.rate.RARE,        690 }, -- Elm Log      ( 5%)
        },
    },

    -- 3 DQs Completed
    {
        coin = 749, -- Mtl. Beastcoin
        rock =
        {
            3520, -- Ifritite
            3521, -- Shivite
            3522, -- Garudite
            3523, -- Titanite
            3524, -- Ramuite
            3525, -- Leviatite
            3526, -- Carbite
            3527, -- Fenrite
        },
        mats =
        {
            { cexi.rate.RARE, xi.item.GOBLIN_STONE }, -- Goblin Stone (5%)
            { cexi.rate.RARE, xi.item.GOBLIN_STONE }, -- Goblin Stone (5%)

            -- Alchemy
            { cexi.rate.VERY_COMMON, 919 }, -- Boyahda Moss  (24%)
            { cexi.rate.COMMON,      939 }, -- Hecteyes Eye  (15%)
            { cexi.rate.RARE,        923 }, -- Dryad Root    ( 5%)

            -- Bonecraft
            { cexi.rate.VERY_COMMON, 893 }, -- Giant Femur     (24%)
            { cexi.rate.COMMON,      884 }, -- Blk. Tiger Fang (15%)
            { cexi.rate.RARE,        895 }, -- Ram Horn        ( 5%)

            -- Clothcraft
            { cexi.rate.VERY_COMMON, 1845 }, -- Red Moko Grass     (24%)
            { cexi.rate.COMMON,       842 }, -- Giant Bird Feather (15%)
            { cexi.rate.RARE,         838 }, -- Spider Web         ( 5%)

            -- Cooking
            { cexi.rate.VERY_COMMON, 4387 }, -- Wild Onion   (24%)
            { cexi.rate.COMMON,      4359 }, -- Dhalmel Meat (15%)
            { cexi.rate.RARE,        4362 }, -- Lizard Egg   ( 5%)

            -- Goldsmithing
            { cexi.rate.VERY_COMMON, 644 }, -- Mythril Ore  (24%)
            { cexi.rate.COMMON,      737 }, -- Gold Ore     (15%)
            { cexi.rate.RARE,        738 }, -- Platinum Ore ( 5%)

            -- Leathercraft
            { cexi.rate.VERY_COMMON, 854 }, -- Cockatrice Skin (24%)
            { cexi.rate.COMMON,      863 }, -- Coeurl Hide     (15%)
            { cexi.rate.RARE,        853 }, -- Raptor Skin     ( 5%)

            -- Smithing
            { cexi.rate.VERY_COMMON, 1155 }, -- Iron Sand     (24%)
            { cexi.rate.COMMON,       645 }, -- Darksteel Ore (15%)
            { cexi.rate.RARE,         657 }, -- Tama-Hagane   ( 5%)

            -- Woodworking
            { cexi.rate.VERY_COMMON, 693 }, -- Walnut Log   (24%)
            { cexi.rate.COMMON,      701 }, -- Rosewood Log (15%)
            { cexi.rate.RARE,        699 }, -- Oak Log      ( 5%)
        },
    },

    -- 4 DQs Completed
    {
        coin = 748, -- Gold Beastcoin
        rock =
        {
            1255, -- Fire Ore
            1256, -- Ice Ore
            1257, -- Wind Ore
            1258, -- Earth Ore
            1259, -- Lightning Ore
            1260, -- Water Ore
            1261, -- Light Ore
            1262, -- Dark Ore
        },
        mats =
        {
            { cexi.rate.COMMON, xi.item.GOBLIN_STONE }, -- Goblin Stone (15%)
            { cexi.rate.COMMON, xi.item.GOBLIN_STONE }, -- Goblin Stone (15%)

            -- Alchemy
            { cexi.rate.VERY_COMMON,  954 }, -- Giant Pot Shard (24%)
            { cexi.rate.COMMON,       955 }, -- Golem Shard     (15%)
            { cexi.rate.RARE,        1165 }, -- Doll Shard      ( 5%)

            -- Bonecraft
            { cexi.rate.VERY_COMMON,  897 }, -- Scorpion Claw   (24%)
            { cexi.rate.COMMON,       887 }, -- Coral Fragment  (15%)
            { cexi.rate.RARE,        1193 }, -- H.Q. Crab Shell ( 5%)

            -- Clothcraft
            { cexi.rate.VERY_COMMON,  838 }, -- Spider Web       (24%)
            { cexi.rate.COMMON,       843 }, -- Giant Bird Plume (15%)
            { cexi.rate.RARE,        1163 }, -- Manticore Hair   ( 5%)

            -- Cooking
            { cexi.rate.VERY_COMMON,  619 }, -- Popoto         (24%)
            { cexi.rate.COMMON,      4400 }, -- Land Crab Meat (15%)
            { cexi.rate.RARE,        4273 }, -- Kitron         ( 5%)

            -- Goldsmithing
            { cexi.rate.VERY_COMMON, 737 }, -- Gold Ore      (24%)
            { cexi.rate.COMMON,      738 }, -- Platinum Ore  (15%)
            { cexi.rate.RARE,        678 }, -- Aluminium Ore ( 5%)

            -- Leathercraft
            { cexi.rate.VERY_COMMON, 1623 }, -- Eft Skin    (24%)
            { cexi.rate.COMMON,       861 }, -- Tiger Hide  (15%)
            { cexi.rate.RARE,        1640 }, -- Bugard Skin ( 5%)

            -- Smithing
            { cexi.rate.VERY_COMMON,  645 }, -- Darksteel Ore (24%)
            { cexi.rate.COMMON,       657 }, -- Tama-Hagane   (15%)
            { cexi.rate.RARE,         646 }, -- Adaman Ore    ( 5%)

            -- Woodworking
            { cexi.rate.VERY_COMMON, 700 }, -- Mahogany Log  (24%)
            { cexi.rate.COMMON,      702 }, -- Ebony Log     (15%)
            { cexi.rate.RARE,        703 }, -- Petrified Log ( 5%)
        },
    },

    -- 5 DQs Completed
    {
        coin = 751, -- Plt. Beastcoin
        rock =
        {
            1255, -- Fire Ore
            1256, -- Ice Ore
            1257, -- Wind Ore
            1258, -- Earth Ore
            1259, -- Lightning Ore
            1260, -- Water Ore
            1261, -- Light Ore
            1262, -- Dark Ore
        },
        mats =
        {
            { cexi.rate.VERY_COMMON, xi.item.GOBLIN_STONE }, -- Goblin Stone (24%)
            { cexi.rate.VERY_COMMON, xi.item.GOBLIN_STONE }, -- Goblin Stone (24%)

            -- Alchemy
            { cexi.rate.VERY_COMMON,  916 }, -- Cactuar Needle (24%)
            { cexi.rate.COMMON,       935 }, -- Ahriman Wing   (15%)
            { cexi.rate.RARE,        1133 }, -- Dragon Blood   ( 5%)

            -- Bonecraft
            { cexi.rate.VERY_COMMON,  902 }, -- Demon Horn        (24%)
            { cexi.rate.COMMON,       866 }, -- Wyvern Scales     (15%)
            { cexi.rate.RARE,         908 }, -- Adamantoise Shell ( 5%)

            -- Clothcraft
            { cexi.rate.VERY_COMMON, 2198 }, -- W. Spider's Web  (24%)
            { cexi.rate.COMMON,       845 }, -- Black C. Feather (15%)
            { cexi.rate.RARE,        1132 }, -- Raxa             ( 5%)

            -- Cooking
            { cexi.rate.VERY_COMMON, 4357 }, -- Crawler Egg     (24%)
            { cexi.rate.COMMON,      4435 }, -- Cockatrice Meat (15%)
            { cexi.rate.RARE,        4274 }, -- Persikos        ( 5%)

            -- Goldsmithing
            { cexi.rate.VERY_COMMON, 738 }, -- Platinum Ore   (24%)
            { cexi.rate.COMMON,      678 }, -- Aluminium Ore  (15%)
            { cexi.rate.RARE,        739 }, -- Orichalcum Ore ( 5%)

            -- Leathercraft
            { cexi.rate.VERY_COMMON,  876 }, -- Manta Skin   (24%)
            { cexi.rate.COMMON,      1628 }, -- Buffalo Hide (15%)
            { cexi.rate.RARE,        1122 }, -- Wyvern Skin  ( 5%)

            -- Smithing
            { cexi.rate.VERY_COMMON,  646 }, -- Adaman Ore    (24%)
            { cexi.rate.COMMON,      1469 }, -- Wootz Ore     (15%)
            { cexi.rate.RARE,         685 }, -- Khroma Ore    ( 5%)

            -- Woodworking
            { cexi.rate.VERY_COMMON,  727 }, -- Dogwood Log      (24%)
            { cexi.rate.COMMON,       729 }, -- Bloodwood Log    (15%)
            { cexi.rate.RARE,        1446 }, -- Lacquer Tree Log ( 5%)
        },
        extra =
        {
            { cexi.rate.COMMON,  722 }, -- Divine Log
            { cexi.rate.COMMON,  860 }, -- Behemoth Hide
            { cexi.rate.COMMON,  886 }, -- Demon Skull
            { cexi.rate.COMMON,  867 }, -- Dragon Scales
            { cexi.rate.COMMON,  837 }, -- Malboro Fiber
            { cexi.rate.COMMON, 1110 }, -- Beetle Blood
            { cexi.rate.COMMON,  836 }, -- Damascene Cloth
            { cexi.rate.COMMON,  901 }, -- Venomous Claw
            { cexi.rate.COMMON, 1313 }, -- Siren's Hair
            { cexi.rate.COMMON, 1311 }, -- Oxblood
            { cexi.rate.COMMON, 2228 }, -- Luminium Ore
            { cexi.rate.COMMON,  734 }, -- Thokcha Ore
            { cexi.rate.COMMON,  741 }, -- P. Brass Ore
            { cexi.rate.COMMON,  740 }, -- Phrygian Ore
            { cexi.rate.COMMON, 1771 }, -- Dragon Bone
            { cexi.rate.COMMON, 1767 }, -- Eltoro Leather
            { cexi.rate.COMMON, 1769 }, -- Galateia
            { cexi.rate.COMMON, 1763 }, -- Viridian Urushi
        },
    },
}

local aceItems =
{
    {
        "    1 -  999 O.F.",
        {
            { "Battledore",  18846, 800  },
            { "Chocobo Wand", 17074, 800 },
            { "Dream Bell",   18863, 800 },
            { "Lotus Katana", 18436, 800 },

            { "Shinai",               18441, 800 },
            { "Purple Spriggan Club", 21113, 900 },
            { "Spelunker's Helm",     11485, 900 },
            { "Corolla",              26729, 900 },

            { "Celeste Cap",      26730, 900 },
            { "Slime Cap",        27756, 900 },
        },
    },
    {
        "1000 - 2499 O.F.",
        {
            { "Slime Shield", 28655, 1000 },
            { "Vile Elixir",   4174, 1500 },
            { "Cloudy Orb",    1551, 1500 },
            { "Ark Tachi",    18464, 1500 },

            { "Ark Tabar",  18545, 1500 },
            { "Ark Scythe", 18563, 1500 },
            { "Ark Saber",  18912, 1500 },
            { "Ark Sword",  18913, 1500 },

            { "Ark Shield",          26490, 1500 },
            { "Burning Hakutaku Eye", 1289, 1500 },
            { "Damp Hakutaku Eye",    1292, 1500 },
            { "Earthen Hakutaku Eye", 1290, 1500 },

            { "Golden Hakutaku Eye",  1291, 1500 },
            { "Wooden Hakutaku Eye",  1288, 1500 },
            { "Eyepatch",            11482, 2000 },
            { "Vile Elixir +1",       4175, 2000 },

            { "Purple Spriggan Coat", 27872, 2000 },
        },
    },
    {
        "2500 - 4999 O.F.",
        {
            { "Sandogasa",     23753, 3000 },
            { "Sky Orb",        1552, 3000 },
            { "Dinner Hose",   16378, 3000 },
            { "Dinner Jacket", 11355, 3000 },

            { "F. Pouch (Head)",  6541, 3000 },
            { "F. Pouch (Body)",  6542, 3000 },
            { "F. Pouch (Hands)", 6543, 3000 },
            { "F. Pouch (Legs)",  6544, 3000 },

            { "F. Pouch (Feet)",     6545, 3000 },
            { "Cobalt Ore",          2859, 3000 },
            { "Wolfram Steel",       2858, 3000 },
            { "Amir Puggaree",      16062, 4500 },

            { "Amir Korazin", 14525, 4500 },
            { "Amir Kolluks", 14933, 4500 },
            { "Amir Dirs",    15604, 4500 },
            { "Amir Boots",   15688, 4500 },

            { "Pahluwan Qalansuwa", 16069, 4500 },
            { "Pahluwan Khazagand", 14530, 4500 },
            { "Pahluwan Dastanas",  14940, 4500 },
            { "Pahluwan Seraweels", 15609, 4500 },

            { "Pahluwan Crackows", 15695, 4500 },
            { "Yigit Turban",      16064, 4500 },
            { "Yigit Gomlek",      14527, 4500 },
            { "Yigit Gages",       14935, 4500 },

            { "Yigit Seraweels", 15606, 4500 },
            { "Yigit Crackows",  15690, 4500 },
            { "Star Orb",         1131, 4500 },
            { "Behemoth Suit",   26954, 4500 },

            { "Behemoth Masque", 26798, 4500 },
            { "Wyrmking Suit",   25756, 4500 },
            { "Wyrmking Masque", 25657, 4500 },
        },
    },
    {
        "5000 - 9999 O.F.",
        {
            { "Comet Orb",      1177, 5000 },
            { "Nomad Cap",     16119, 5000 },
            { "Silver Voucher", 9277, 5000 },
            { "Moon Orb",       1130, 6000 },

            { "Moogle Trust",       10127, 7000 },
            { "Sakura Trust",       10123, 7000 },
            { "Redeyes",            16120, 6000 },
            { "Red Crab Companion", 10052, 8000 },

            { "Askar Zucchetto", 16106, 9000 },
            { "Askar Korazin",   14568, 9000 },
            { "Askar Manopolas", 14983, 9000 },
            { "Askar Dirs",      15647, 9000 },

            { "Askar Gambieras",   15733, 9000 },
            { "Denali Bonnet",     16107, 9000 },
            { "Denali Jacket",     14569, 9000 },
            { "Denali Wristbands", 14984, 9000 },

            { "Denali Kecks",    15648, 9000 },
            { "Denali Gamashes", 15734, 9000 },
            { "Goliard Chapeau", 16108, 9000 },
            { "Goliard Saio",    14570, 9000 },

            { "Goliard Cuffs", 14985, 9000 },
            { "Goliard Trews", 15649, 9000 },
            { "Goliard Clogs", 15735, 9000 },
        },
    },
    {
        "10000+ O.F.",
        {
            { "Mandragora Sprout",     4017, 10000 },
            { "Red Raptor Companion", 10075, 10000 },
            { "Sweet Tea",             3340, 10500 },
            { "Savory Shank",          3342, 10500 },

            { "Red Pondweed",      3344, 10500 },
            { "Decennial Tights", 10593, 15000 },
            { "Decennial Hose",   10594, 15000 },
            { "Decennial Tiara",  10431, 15000 },

            { "Decennial Crown",       10430, 15000 },
            { "Decennial Dress",       10252, 15000 },
            { "Decennial Coat",        10251, 15000 },
            { "Golden Bomb Companion", 10076, 15000 },

            { "Cornelia Trust",   10141, 20000 },
            { "Tidal Talisman",   11290, 30000 },
            { "Ixion Companion",  10082, 30000 },
            { "Byakko Companion", 10080, 50000 },

        },
    },
}

local cwItems =
{
    {
        "    1 -  999 O.F.",
        {
            { "Silent Oil   x1",      4165, 300 },
            { "Prism Powder x1",      4164, 300 },
            { "Battledore",          18846, 800 },
            { "Toolbag (Shihei) x1",  5314, 800 },

            { "Toolbag (Shino)  x1",  5319, 800 },
            { "Toolbag (Sanja)  x1",  5417, 800 },
        },
    },
    {
        "1000 - 2499 O.F.",
        {
            { "Kunwu Ore",      1703, 1150 },
            { "Trumpet Shell",  5466, 1500 },
            { "Cloudy Orb",     1551, 2000 },
            { "Vile Elixir",    4174, 2500 },
            { "Warp Cudgel",   17040, 2500 },
        },
    },
    {
        "2500 - 4999 O.F.",
        {
            { "Sandogasa",       23753, 3000 },
            { "Sky Orb",          1552, 3000 },
            { "Dinner Hose",     16378, 3000 },
            { "Dinner Jacket",   11355, 3000 },

            { "F. Pouch (Head)",  6541, 3000 },
            { "F. Pouch (Body)",  6542, 3000 },
            { "F. Pouch (Hands)", 6543, 3000 },
            { "F. Pouch (Legs)",  6544, 3000 },

            { "F. Pouch (Feet)",  6545, 3000 },
            { "Cobalt Ore",       2859, 3000 },
            { "Wolfram Steel",    2858, 3000 },
            { "Cassia Lumber",    1762, 3500 },

            { "Dragon Bone",      1771, 3500 },
            { "Eltoro Leather",   1767, 3500 },
            { "Galateia",         1769, 3500 },
            { "Kejusu Satin",     1764, 3500 },

            { "Viridian Urushi ", 1763, 3500 },
            { "Star Orb",         1131, 4000 },
        },
    },
    {
        "5000 - 9999 O.F.",
        {
            { "Comet Orb",        1177, 5000 },
            { "Moon Orb",         1130, 6000 },
            { "Sakura Trust",    10123, 7000 },
            { "Moogle Trust",    10127, 7000 },

            { "Novennial Boots", 11957, 8000 },
            { "Novennial Hose",  11956, 8000 },
            { "Novennial Dress", 11854, 8000 },
            { "Novennial Coat",  11853, 8000 },
        },
    },
    {
        "10000+ O.F.",
        {
            { "Mandragora Sprout", 4017, 10000 },
            { "Decennial Tights", 10593, 10000 },
            { "Decennial Hose",   10594, 10000 },
            { "Decennial Tiara",  10431, 10000 },

            { "Decennial Crown", 10430, 10000 },
            { "Decennial Dress", 10252, 10000 },
            { "Decennial Coat",  10251, 10000 },
            { "Cornelia Trust",  10141, 15000 },

            { "Tidal Talisman",  11290, 30000 },
        },
    },
}

local wewItems =
{
    {
        "    1 -  999 O.F.",
        {
            -- Lv20 Garrison
            { "Red Cryptex",    1528, 100 },
            { "Dst. Engraving", 1529, 100 },
            { "7-Knot Quipu",   1530, 100 },

            -- Lv30 Garrison
            { "Galka Fang Sack",    1531, 200 },
            { "Jade Cryptex",       1532, 200 },
            { "Silver Engraving",   1533, 200 },
            { "Mithra Fang Sack",   1534, 200 },
            { "13-Knot Quipu",      1535, 200 },
            { "R. Leather Missive", 1538, 200 },

            -- Lv40 Garrison
            { "T. Leather Missive", 1536, 300 },
            { "Hound Fang Sack",    1539, 300 },
            { "S. Leather Missive", 1542, 300 },

            -- Lv50 Garrison
            { "B. Leather Missive", 1537, 400 },
            { "D. Leather Missive", 1540, 400 },
            { "C. Leather Missive", 1543, 400 },

            -- Lv75 Garrison
            { "Bunny Fang Sack",    1541, 500 },

            { "Toolbag (Shihei) x1", 5314, 600 },
            { "Toolbag (Shino)  x1", 5319, 600 },
            { "Toolbag (Sanja)  x1", 5417, 600 },

            { "Battledore", 18846, 800 },
        },
    },
    {
        "1000 - 2499 O.F.",
        {
            { "Hi-potion",       4116, 1000 },
            { "Hi-ether",        4132, 1000 },
            { "Silent Oil   x4", 4165, 1200 },
            { "Prism Powder x4", 4164, 1200 },
            { "Vile Elixir",     4174, 2000 },
            { "Decen. Ring",    10796, 2000 },
            { "Anni. Ring",     15793, 2000 },
        },
    },
    {
        "2500 - 4999 O.F.",
        {
            { "Wardr. 7/8 Slot", "MOGW", 3000 },

            { "Crusade",       5103, 3000 },
            { "Cobalt Ore",    2859, 3000 },
            { "Wolfram Steel", 2858, 3000 },

            { "Dinner Jacket", 11355, 3000 },
            { "Dinner Hose",   16378, 3000 },
            { "Silver Voucher", 9277, 3000 },
            { "Warp Cudgel",   17040, 4500 },
        },
    },
    {
        "5000 - 9999 O.F.",
        {
            { "Reraise Earring", 14790, 6000 },
            { "Reraise Hairpin", 15211, 7000 },
            { "Novennial Boots", 11957, 8000 },

            { "Novennial Hose",  11956, 8000 },
            { "Novennial Dress", 11854, 8000 },
            { "Novennial Coat",  11853, 8000 },

        },
    },
    {
        "10000+ O.F.",
        {
            { "Mandragora Sprout", 4017, 10000 },
            { "Decennial Tights", 10593, 15000 },
            { "Decennial Hose",   10594, 15000 },
            { "Decennial Tiara",  10431, 15000 },

            { "Decennial Crown", 10430, 15000 },
            { "Decennial Dress", 10252, 15000 },
            { "Decennial Coat",  10251, 15000 },
        },
    },
}

local rewardFunctions =
{
    ["MOGW"] = function(player)
        local oldSize = player:getContainerSize(xi.inv.WARDROBE8)

        -- Give Wardrobe 8 slots up to 80
        if oldSize < 80 then
            player:changeContainerSize(xi.inv.WARDROBE8, 1)

            local newSize = player:getContainerSize(xi.inv.WARDROBE8)
            player:sys("\129\154 Your Mog Wardrobe 8 capacity has been increased by 1 from {} to {}! \129\154", oldSize, newSize)

            return true
        else
            oldSize = player:getContainerSize(xi.inv.WARDROBE7)

            -- Give Wardrobe 7 slots up to 80
            if oldSize < 80 then
                player:changeContainerSize(xi.inv.WARDROBE7, 1)

                local newSize = player:getContainerSize(xi.inv.WARDROBE7)
                player:sys("\129\154 Your Mog Wardrobe 7 capacity has been increased by 1 from {} to {}! \129\154", oldSize, newSize)

                return true
            else
                player:sys("You have already reached maximum capacity with Mog Wardrobe 7/8.")
            end
        end

        return false
    end,
}

local function delaySendMenu(player, menu)
    player:timer(200, function(playerArg)
        playerArg:customMenu(menu)
    end)
end

local function openBox(player)
    local zone   = player:getZone()
    local result = zone:queryEntitiesByName("DE_Goldilox Box")

    if result == nil then
        return
    end

    for _, de in pairs(result) do
        de:ceAnimationPacket(player, "open", de)

        de:timer(3000, function(npcArg)
            de:ceAnimationPacket(player, "clos", de)
        end)
    end
end

local function confirmPurchase(player, npc, item)
    local balance = player:getCurrency('obsidian_fragment')

    if item[3] > balance then
        player:printToPlayer("Goldilox : Woah! Hey buddy, you can't afford that!", xi.msg.channel.NS_SAY)
        return
    end

    delaySendMenu(player, {
        title = string.format("Buy %s (%i)?", item[1], item[3]),
        options =
        {
            {
                "No, I've changed my mind.",
                function()
                end,
            },
            {
                "Yes, I'm sure!",
                function()
                    if type(item[2]) == "string" then
                        if rewardFunctions[item[2]](player) then
                            player:setCurrency("obsidian_fragment", balance - item[3])
                        end
                    else
                        if npcUtil.giveItem(player, item[2]) then
                            player:setCurrency("obsidian_fragment", balance - item[3])
                            openBox(player)
                        end
                    end
                end,
            },
        },
    })
end

local tiers =
{
    "Bronze Tier",
    "Silver Tier",
    "Gold Tier",
    "Platinum Tier",
    "Jackpot!",
}

local qtyTiers =
{
    { 1, 2 },
    { 1, 3 },
    { 2, 3 },
    { 2, 4 },
    { 3, 4 },
}

local function giveWEWPerks(player, completed, roll)
    local gilMult = player:getCharVar('[WEW]WEEKLY_GIL_MULTIPLIER') + 20
    -- increase max gil from exp-to-gil by 10k per completed DQ and 'crit' if roll was over 750/950
    local capIncIncrease = 10000 * completed
    if roll > 950 then
        capIncIncrease = capIncIncrease * 3
    elseif roll > 750 then
        capIncIncrease = capIncIncrease * 2
    end

    local gilCapInc = player:getCharVar('[WEW]WEEKLY_GIL_MAX_INCREASE') + capIncIncrease

    player:setCharVar('[WEW]WEEKLY_GIL_MULTIPLIER', gilMult, NextConquestTally())
    player:setCharVar('[WEW]WEEKLY_GIL_MAX_INCREASE', gilCapInc, NextConquestTally())

    player:sys(fmt("Weekly Exp-to-Gil multiplier increased to {} and gil max increased to {}K!",
            1 + gilMult / 100,
            math.floor(math.max(0, 500000 + gilCapInc) / 1000)
        )
    )
end

local function openDaily(player, npc)
    local opened = player:getCharVar("[CQ]Opened")

    if opened ~= 0 then
        cexi.util.dialog(player, {
            "Hey! You've already collected a prize today!"
        }, npc:getPacketName(), { npc = npc })
        return
    end

    if player:getFreeSlotsCount() < 5 then
        cexi.util.dialog(player, {
            "Hey! You don't have enough to hold all that!"
        }, npc:getPacketName(), { npc = npc })
        return
    end

    local completed = player:getCharVar("[DQ]Completed")

    if completed == 0 then
        cexi.util.dialog(player, {
            "Woah, hold up! You can't just take this stuff for free.",
            " You haven't even completed any daily quests yet!",
        }, npc:getPacketName(), { npc = npc })
        return
    end

    local tbl =
    {
        fmt("Hmm... looks like you've completed {} quests today.", completed),
        " Remember, more quests means more prizes. You wanna open it already?",
    }

    if completed == 1 then
        tbl =
        {
            "Huh, you've only completed 1 quest today.",
            " If you want the good stuff, you're gonna have to try a bit harder than that.",
            "  But if you really want this junk, I ain't gonna stop ya.",
        }
    end

    if completed == 5 then
        tbl =
        {
            "Woah, looks like you've completed all of today's quests!",
            " That means you get exclusive access to the very best!",
        }
    end

    local delay = cexi.util.dialogDelay(tbl)
    cexi.util.dialog(player, tbl, npc:getPacketName(), { npc = npc })

    player:timer(delay, function()
        delaySendMenu(player, {
            title   = "Open your daily chest?",
            options =
            {
                {
                    "Not yet",
                    function()
                    end,
                },
                {
                    "Open it!",
                    function()
                        openBox(player)

                        local roll = math.random(0, 999)
                        local tier = 1

                        if roll > 800 then
                            tier = 5
                        elseif roll > 700 then
                            tier = 4
                        elseif roll > 500 then
                            tier = 3
                        elseif roll > 300 then
                            tier = 2
                        end

                        player:sys(fmt("Dice roll! {} rolls {}! (\129\154 {} \129\154)", player:getName(), roll, tiers[tier]))

                        local items = {}
                        table.insert(items, { dailyRewards[completed].coin, tier })

                        local qtyRocks = math.random(qtyTiers[tier][1], qtyTiers[tier][2])
                        local qtyMats  = math.random(qtyTiers[tier][1], qtyTiers[tier][2])
                        table.insert(items, { dailyRewards[completed].rock[math.random(1, 8)], qtyRocks })

                        for i = 1, qtyMats do
                            local result = cexi.util.pickItem(dailyRewards[completed].mats)
                            table.insert(items, result[2])
                        end

                        if
                            tier      == 5 and
                            completed == 5
                        then
                            local result = cexi.util.pickItem(dailyRewards[completed].extra)
                            table.insert(items, { result[2], 1 })
                        end

                        if cexi.util.giveItem(player, items, { multiple = true }) then
                            openBox(player)
                            local amount = math.random(dailyBonus[completed][1], dailyBonus[completed][2])
                            player:addCurrency("obsidian_fragment", amount)
                            player:sys("You have obtained {} Obsidian Fragments!", amount)
                            player:setCharVar("[CQ]Opened", 1, JstMidnight())

                            if player:isClassicMode() then
                                giveWEWPerks(player, completed, roll)
                            end
                        end
                    end,
                }
            }
        })
    end)
end

local function onTrigger(player, npc)
    delaySendMenu(player, {
        title   = "What'll it be?",
        options =
        {
            {
                "Nothing",
                function()
                end,
            },
            {
                "Spend Obsidian Fragments",
                function()
                    local balance = player:getCurrency('obsidian_fragment')
                    npc:facePlayer(player, true)

                    local items = aceItems

                    if player:isCrystalWarrior() then
                        items = cwItems
                    elseif player:isClassicMode() then
                        items = wewItems
                    end

                    cexi.util.categoryMenu(player, npc, items, confirmPurchase, string.format("Ob. Frags (%u):", balance))
                end,
            },
            {
                "Buy HQ Crystals",
                function()
                    xi.shop.general(player, {
                        4238, 3000, -- Inferno Crystal
                        4239, 3000, -- Glacier Crystal
                        4240, 3000, -- Cyclone Crystal
                        4241, 3000, -- Terra Crystal
                        4242, 3000, -- Plasma Crystal
                        4243, 3000, -- Torrent Crystal
                        4244, 3000, -- Aurora Crystal
                        4245, 3000, -- Twilight Crystal
                    })
                end,
            },
            {
                "Open Daily Chest",
                function()
                    openDaily(player, npc)
                end,
            },
        },
    })
end

cexi.util.liveReload(m, {
    ["Lower_Jeuno"] =
    {
        {
            objtype  = xi.objType.NPC,
            name     = "Goldilox",
            look     = 702,
            x        = -49.7539,
            y        = 0.000,
            z        = -54.3718,
            rotation = 19,
            widescan = 1,
            onTrigger = onTrigger,
        },
        {
            objtype      = xi.objType.NPC,
            name         = "Goldilox Box",
            look         = 969,
            untargetable = true,
            x            = -49.300,
            y            = 0.000,
            z            = -53.447,
            rotation     = 21,
            widescan     = 1,
        },
    },
})

return m
