-----------------------------------
-- Daily Quest : Fishstix
-- Find/open a secret Treasure Chest in a certain zone
-----------------------------------
require("modules/module_utils")
require("scripts/zones/Lower_Jeuno/Zone")
local ID = require("scripts/zones/Lower_Jeuno/IDs")
-----------------------------------
local m = Module:new("daily_quest_fishstix")

m:addOverride("xi.zones.Lower_Jeuno.Zone.onInitialize", function(zone)

    super(zone)

    -- Creates a table of quest locations by index and zone name
    local questLocations =
    {
        -- [index] | Zone Name
        {"West Ronfaure"},
        {"East Ronfaure"},
        {"South Gustaberg"},
        {"North Gustaberg"},
        {"West Sarutabaruta"},
        {"East Sarutabaruta"},
        {"La Theine Plateau"},
        {"Konschtat Highlands"},
        {"Tahrongi Canyon"},
        {"Valkurm Dunes"},
        {"Jugner Forest"},
        {"Batallia Downs"},
        {"Pashhow Marshlands"},
        {"Rolanberry Fields"},
        {"Sauromugue Champaign"},
        {"Beaucedine Glacier"},
        {"Xarcabard"},
        {"Cape Teriggan"},
        {"Eastern Altepa Desert"},
        {"Western Altepa Desert"},
        {"Meriphataud Mountains"},
        {"Buburimu Peninsula"},
        {"The Sanctuary of Zi'Tah"},
        {"Ro'Maeve"},
        {"Yuhtunga Jungle"},
        {"Yhoator Jungle"},
        {"Qufim Island"},
        {"Temple of Uggalepih"},
        {"Valley of Sorrows"},
        {"Bibiki Bay"},
        {"Carpenter's Landing"},
        {"Uleguerand Range"},
        {"Attohwa Chasm"},
        {"Oldton Movalpolos"},
        {"Newton Movalpolos"},
        {"Wajaom Woodlands"},
        {"Bhaflau Thickets"},
        {"Arrapago Reef"},
        {"Mount Zhayolm"},
        {"Halvung"},
        {"Mamook"},
        {"Aydeewa Subterrane"},
        {"Alzadaal Undersea Ruins"},
        {"Caedarva Mire"},
        {"Yughott Grotto"},
        {"Fort Ghelsba"},
        {"Palborough Mines"},
        {"Giddeus"},
        {"Beadeaux"},
        {"Davoi"},
        {"Monastic Cavern"},
        {"Castle Oztroja"},
        {"The Boyahda Tree"},
        {"Lower Delkfutt's Tower"},
        {"Middle Delkfutt's Tower"},
        {"Upper Delkfutt's Tower"},
        {"Den of Rancor"},
        {"Castle Zvahl Baileys"},
        {"Castle Zvahl Keep"},
        {"Ranguemont Pass"},
        {"Bostaunieux Oubliette"},
        {"Toraimarai Canal"},
        {"Zeruhn Mines"},
        {"Korroloka Tunnel"},
        {"Kuftal Tunnel"},
        {"The Eldieme Necropolis"},
        {"Sea Serpent Grotto"},
        {"Dangruf Wadi"},
        {"Inner Horutoto Ruins"},
        {"Outer Horutoto Ruins"},
        {"Ordelle's Caves"},
        {"Gusgen Mines"},
        {"Crawler's Nest"},
        {"Maze of Shakhrami"},
        {"Garlaige Citadel"},
        {"Fei'Yin"},
        {"Ifrit's Cauldron"},
        {"Quicksand Caves"},
        {"Gustav Tunnel"},
        {"Labyrinth of Onzozo"},
        {"Dynamis - Bastok"},
        {"Dynamis - San d'Oria"},
        {"Dynamis - Windurst"},
        {"Dynamis - Jeuno"},
        {"Dynamis - Beaucedine"},
        {"Dynamis - Xarcabard"},
        {"Ru'Aun Gardens"},
        {"Ve'Lugannon Palace"},
        {"The Shrine of Ru'Avitau"},
        {"Al'Taieu"},
        {"Grand Palace of Hu'Xzoi"},
        {"The Garden of Ru'Hmet"},
        {"Lufaise Meadows"},
        {"Misareaux Coast"},

        -- Level capped areas for CW and WEW
        -- {"Phomiuna Aqueducts"},
        -- {"Sacrarium"},
        -- {"Riverne Site-A01"},
        -- {"Riverne Site-B01"},

        -- Unreleased areas
--        [99] = {"Escha - Zi'Tah"},
--        [100] = {"Escha - Ru'Aun"}
    }

    -- Handles the functionality of the "daily reset" at midnight
    local handleMidnight = function(player)
        local questMidnight = player:getCharVar("[DQ]Midnight")
        local currentMidnight = getMidnight()

        -- handle first time quest midnight
        if questMidnight == 0 then
            player:setCharVar("[DQ]Midnight", currentMidnight)
            player:setCharVar("[DQ]Completed", 0)
            player:setCharVar("[DQ]Reset", 0)
            player:setCharVar("[DQ]Fishstix", 0)
            player:setCharVar("[DQ]Fishstix_Z", 0)
            player:setCharVar("[DQ]Murdoc", 0)
            player:setCharVar("[DQ]Murdoc_Z", 0)
            player:setCharVar("[DQ]Murdoc_MT", 0)
            player:setCharVar("[DQ]Murdoc_KA", 0)
            player:setCharVar("[DQ]Mistrix", 0)
            player:setCharVar("[DQ]Mistrix_I", 0)
            player:setCharVar("[DQ]Saltlik", 0)
            player:setCharVar("[DQ]Saltlik_Z", 0)
            player:setCharVar("[DQ]Saltlik_NM", 0)
            player:setCharVar("[DQ]Beetrix", 0)
            player:setCharVar("[DQ]Beetrix_Z", 0)
            player:setCharVar("[DQ]Beetrix_RE", 0)
        end
        
        -- handle midnight reset
        if currentMidnight ~= questMidnight then
            player:setCharVar("[DQ]Midnight", currentMidnight)
            player:setCharVar("[DQ]Completed", 0)
            player:setCharVar("[DQ]Reset", 0)
            player:setCharVar("[DQ]Fishstix", 0)
            player:setCharVar("[DQ]Fishstix_Z", 0)
            player:setCharVar("[DQ]Murdoc", 0)
            player:setCharVar("[DQ]Murdoc_Z", 0)
            player:setCharVar("[DQ]Murdoc_MT", 0)
            player:setCharVar("[DQ]Murdoc_KA", 0)
            player:setCharVar("[DQ]Mistrix", 0)
            player:setCharVar("[DQ]Mistrix_I", 0)
            player:setCharVar("[DQ]Saltlik", 0)
            player:setCharVar("[DQ]Saltlik_Z", 0)
            player:setCharVar("[DQ]Saltlik_NM", 0)
            player:setCharVar("[DQ]Beetrix", 0)
            player:setCharVar("[DQ]Beetrix_Z", 0)
            player:setCharVar("[DQ]Beetrix_RE", 0)
        end
    end

    -- Adds the NPC into Lower Jeuno
    local fishstix = zone:insertDynamicEntity({

        objtype = xi.objType.NPC,
        name = "Fishstix",
        look = 490,
        x = -48.7539,
        y = 0.000,
        z = -63.0204,
        rotation = 213,
        widescan = 1,

        -- Handles the ability to reset daily quest for 50k gil
        onTrade = function(player, npc, trade)
            -- Check to see if daily reset needs to happen first
            handleMidnight(player)
            npc:facePlayer(player, true)

            local gil = trade:getGil()
            local questStage = player:getCharVar("[DQ]Fishstix")
            local resetCount = player:getCharVar("[DQ]Reset")
            local cost = 50000

            if player:isCrystalWarrior() then
                cost = 15000
            end

            -- If the player makes a trade with 50k gil
            if gil == cost then
                -- If they trade something else besides gil
                if trade:getItemCount() ~= 1 then
                    player:printToPlayer("I only accept gil as payment.", 0, npc:getPacketName())
                    return
                else
                    -- If the daily is already not given out, no need to reset
                    if questStage == 0 then
                        player:printToPlayer("You don't need to reset this daily, the quest has not been given yet.", 0, npc:getPacketName())
                        return
                    -- If the daily is already completed, no reset allowed
                    elseif questStage == 3 then
                        player:printToPlayer("You can't reset a completed daily. Come back tomorrow for more.", 0, npc:getPacketName())
                        return
                    else
                        -- If they've already done their 3 resets a day, no more reset allowed
                        if resetCount >= 3 then
                            player:printToPlayer("You can only reset a daily quest a max of 3 times per day across ALL dailies. Come back tomorrow for more.", 0, npc:getPacketName())
                            return
                        else
                            -- If it's a valid reset, reset the daily
                            player:tradeComplete()
                            player:setCharVar("[DQ]Reset", resetCount + 1)
                            player:setCharVar("[DQ]Fishstix", 0)
                            player:setCharVar("[DQ]Fishstix_Z", 0)
                            player:printToPlayer(string.format("You have successfully reset my daily quest. Resets remaining today: %d.",(3 - (resetCount + 1))), 0, npc:getPacketName())
                        end
                    end
                end
            else
                player:printToPlayer(string.format("You can trade me %u gil to reset this daily quest (3 resets a day max across all dailies).", cost), 0, npc:getPacketName())
            end
        end,

        -- This handles assigning the quest and handling setting the reward for quest completion
        onTrigger = function(player, npc)
            -- Check to see if daily reset needs to happen first
            handleMidnight(player)
            -- What "stage" of the quest they're on
            local questStage = player:getCharVar("[DQ]Fishstix")
            -- Used later to keep a count of how many completed quests a day
            local completedDailyQuests = player:getCharVar("[DQ]Completed")

            npc:facePlayer(player, true)

            -- Handle quest stages
            -- Quest hasn't been started yet, assign a random zone to go find the chest in
            if questStage == 0 then
                local randNum = math.random(1, #questLocations)
                local questZoneName = questLocations[randNum][1]
                player:setCharVar("[DQ]Fishstix",1)
                player:setCharVar("[DQ]Fishstix_Z",randNum)
                player:printToPlayer(string.format("Go to %s, find and open my Secret Treasure Chest! If you're confused, just try showing some emotion in the area.",questZoneName), 0, npc:getPacketName())
                return
            -- Quest has been started already, just reiterate their quest to them
            elseif questStage == 1 then
                local questZone = player:getCharVar("[DQ]Fishstix_Z")
                local questZoneName = questLocations[questZone][1]
                player:printToPlayer(string.format("Go to %s, find and open my Secret Treasure Chest!",questZoneName), 0, npc:getPacketName())
                return
            -- They have opened the chest and got sent back to the NPC, handle giving out the reward
            elseif questStage == 2 then
                player:incrementCharVar("[DQ]Fishstix_complete", 1)
                player:setCharVar("[DQ]Fishstix",3)
                player:setCharVar("[DQ]Completed", completedDailyQuests + 1, getMidnight())
                player:printToPlayer("Congratulations! You've completed my quest for today, here's your reward!", 0, npc:getPacketName())
                player:addCurrency('obsidian_fragment', 100)
                player:printToPlayer("You have obtained 100 Obsidian Fragments!", 17)
                return
            -- The quest as already been completed
            elseif questStage == 3 then
                player:printToPlayer("You've already completed this quest today! Come back tomorrow for more.", 0, npc:getPacketName())
                return
            end
        end,
    })

    utils.unused(fishstix)

end)

return m
