-----------------------------------
-- Daily Quest : Beetrix
-- Turn in a certain 'R/Ex' item
-----------------------------------
require("modules/module_utils")
require("scripts/zones/Lower_Jeuno/Zone")
local ID = require("scripts/zones/Lower_Jeuno/IDs")
-----------------------------------
local m = Module:new("daily_quest_beetrix")

m:addOverride("xi.zones.Lower_Jeuno.Zone.onInitialize", function(zone)

    super(zone)

    -- This table contains the zones and R/Ex items they will need to go collect from those zones to turn in for the reward
    local questLocations =
    {
        -- [index] | Zone Name | R/Ex | R/Ex Item ID
        {"West Ronfaure",            {"Chunk Of Lufet Salt"},                                                                                                                                                {1019}},
        {"East Ronfaure",            {"Bukktooth"},                                                                                                                                                          {2851}},
        {"South Gustaberg",          {"Armiger's Lace"},                                                                                                                                                     {16296}},
        {"North Gustaberg",          {"Dog Collar","Flawed Garnet"},                                                                                                                                         {13096,2842}},
        {"West Sarutabaruta",        {"Torn Epistle","Meteorite","Two-Leaf Mandragora Bud","Four-Leaf Mandragora Bud"},                                                                                      {584,582,4368,4369}},
        {"East Sarutabaruta",        {"Crawler Calculus","Remi Shell","Muddy Bar Tab","Smooth Stone"},                                                                                                       {1156,1016,585,583}},
        {"La Theine Plateau",        {"Orcish Axe","Lanolin Cube"},                                                                                                                                          {16656,531}},
        {"Konschtat Highlands",      {"Immortal Molt"},                                                                                                                                                      {2834}},
        {"Tahrongi Canyon",          {"Fasting Ring","Damp Envelope","Odd Postcard"},                                                                                                                        {15546,587,586}},
        {"Valkurm Dunes",            {"Stately Crab Shell","Channeling Robe","Crab Apron","Damselfly Worm","Valkurm Sunsand"},                                                                               {2854,11339,539,537,503}},
        {"Jugner Forest",            {"Seedspall Lux","Seeker Earring"},                                                                                                                                     {2740,16027}},
        {"Batallia Downs",           {"Stormer Earring","Engraved Key","Counterfeit Gil","Nyumomo Doll"},                                                                                                    {16014,535,1708,1706}},
        {"Pashhow Marshlands",       {"Seedspall Luna"},                                                                                                                                                     {2741}},
        {"Rolanberry Fields",        {"Silkworm Egg","Naphille Pochette"},                                                                                                                                   {4526,1709}},
        {"Sauromugue Champaign",     {"Copy Of \"Fernan's Diaries\""},                                                                                                                                       {1710}},
        {"Beaucedine Glacier",       {"Malebolge Mandrel","Ahriman Lens","Magnolia Lumber"},                                                                                                                 {2853,557,724}},
        {"Xarcabard",                {"Tenebrium","Hickory Lumber","Behemoth Leather Missive","Bruised Starfruit"},                                                                                          {2852,725,1537,551}},
        {"Cape Teriggan",            {"Cold Bone","White Mage's Testimony"},                                                                                                                                 {907,1428}},
        {"Eastern Altepa Desert",    {"Desert Venom"},                                                                                                                                                       {1209}},
        {"Western Altepa Desert",    {"Xhifhut Bow","Dhalmel Leather Missive","Arnica Root","Southern Mummy"},                                                                                               {1478,1540,1663,1201}},
        {"Meriphataud Mountains",    {"Seedspall Astrum","Twinstone Earring"},                                                                                                                               {2742,13360}},
        {"Buburimu Peninsula",       {"Wild Rabbit Tail","Yuhtunga Sulfur","Dhalmel Saliva"},                                                                                                                {542,934,541}},
        {"The Sanctuary of Zi'Tah",  {"Imperial Topaz","Hound Fang Sack","Sack of Fish Bait"},                                                                                                               {2840,1539,1168}},
        {"Ro'Maeve",                 {"Illuminink"},                                                                                                                                                         {1408}},
        {"Yuhtunga Jungle",          {"Elshimo Marble","Wild Pineapple"},                                                                                                                                    {1146,4598}},
        {"Yhoator Jungle",           {"Three-Leaf Mandragora Bud","Rancor Handle","Chary Earring","Warm Egg","Wild Melon","Rancor Tank"},                                                                    {1154,1487,16016,4602,4597,1486}},
        {"Qufim Island",             {"Mystique Earring","Sylph Earring","Kaiser Sword"},                                                                                                                    {16023,16033,16631}},
        {"Temple of Uggalepih",      {"Cursed Key","Hard Shield","Summoner's Testimony","Uggalepih Coffer Key","White Steel","Coeurl Leather Missive","Giant Fish Bones","Prelate Key","Bee Larvae"},        {1143,12378,1440,1049,677,1543,904,1137,1267}},
        {"Valley of Sorrows",        {"Giant Bird Plume","Adamantoise Shell","Manticore Fang"},                                                                                                              {843,908,1123}},
        {"Bibiki Bay",               {"White Sand","Clot Plasma"},                                                                                                                                           {1889,1633}},
        {"Carpenter's Landing",      {"Elan Earring","Garhada Teak Lumber","Flytrap Leaf"},                                                                                                                  {16026,1727,1617}},
        {"Uleguerand Range",         {"Snow Lily","Chunk Of Zincite","Taurus Wing"},                                                                                                                         {1725,1885,1621}},
        {"Attohwa Chasm",            {"Corse Bracelet","Attohwa Ginseng","High-Quality Antlion Jaw","High-Quality Scorpion Shell","Scarlet Stone"},                                                          {1614,1683,1864,1473,1649}},
        {"Oldton Movalpolos",        {"Spool Of Rugged Gold Thread","Magicked Steel","Moblin Hotrok","Oldton Chest Key","Moblumin Ingot","Moblin Sheepskin","Hoary Bomb Ash"},                               {2827,1696,1729,1062,1858,1861,1669}},
        {"Newton Movalpolos",        {"Igneous Rock","Sylvan Stone","Gold Key","Bugbear Mask","Newton Coffer Key"},                                                                                          {1654,1781,1684,1624,1063}},
        {"Wajaom Woodlands",         {"Frayed Arrow","Mamook Tanscale Key","Rusty Medal","Mamool Ja Collar"},                                                                                                {2462,2225,2461,2227}},
        {"Bhaflau Thickets",         {"Jody's Acid","Tariqah -1","Wivre Hide","Wivre Horn","Wivre Maul"},                                                                                                    {2307,16167,2428,2426,2427}},
        {"Arrapago Reef",            {"Lamian Fang Key","Lamia Skin","Lamian Armlet","Lamian Kaman -1","Merrow Scale","Corsair's Testimony"},                                                                {2219,1869,2167,18688,2146,2332}},
        {"Mount Zhayolm",            {"Khroma Nugget","Wamoura Hair","Slab of Plumbago","Januwiyah -1","Troll Vambrace"},                                                                                    {2711,2337,2860,16166,2161}},
        {"Halvung",                  {"Halvung Shakudo Key","Halvung Bronze Key","Halvung Brass Key","Jadagna -1","Puppetmaster's Testimony"},                                                               {2221,2222,2223,18409,2333}},
        {"Mamook",                   {"Mamool Ja Helmet","Macuahuitl -1","Mamook Blackscale Key","Tariqah -1","Mamook Silverscale Key","Blue Mage's Testimony","Poroggo Hat"},                               {2162,17716,2226,16167,2224,2331,2334}},
        {"Aydeewa Subterrane",       {"Colorful Hair"},                                                                                                                                                      {2463}},
        {"Alzadaal Undersea Ruins",  {"Qiqirn Sandbag","Qiqirn Cape"},                                                                                                                                       {2153,1196}},
        {"Caedarva Mire",            {"Qutrub Bandage","Soulflayer Robe","Soulflayer Tentacle","Soulflayer Staff","Timeworn Talisman"},                                                                      {2159,1724,2335,2336,2861}},
        {"Yughott Grotto",           {"Cathedral Tapestry","Red Cryptex","Castle Floor Plans","Shaman Garlic"},                                                                                              {1662,1528,530,1018}},
        {"Fort Ghelsba",             {"Orcish Armor Plate"},                                                                                                                                                 {2757}},
        {"Palborough Mines",         {"Darksteel Engraving","Quadav Backscale"},                                                                                                                             {1529,2758}},
        {"Giddeus",                  {"Yagudo Caulk","Seven-Knot Quipu"},                                                                                                                                    {2759,1530}},
        {"Beadeaux",                 {"Warding Oil","Silver Engraving","Quadav Mage Blood","Beadeaux Coffer Key","Black Mage's Testimony","Paladin's Testimony"},                                            {1685,1533,1114,1043,1429,1432}},
        {"Davoi",                    {"Curse Wand","Jade Cryptex","Davoi Coffer Key","Gold Orcmask","Dragoon's Testimony"},                                                                                  {17437,1532,1042,554,1439}},
        {"Monastic Cavern",          {"Ranger's Testimony","Monk's Testimony"},                                                                                                                              {1436,1427}},
        {"Castle Oztroja",           {"Thirteen-Knot Quipu","Yagudo Holy Water","Judgment Key","Oztroja Coffer Key","Ninja's Testimony","Bard's Testimony"},                                                 {1535,1097,1142,1044,1438,1435}},
        {"The Boyahda Tree",         {"Boyahda Coffer Key","Snobby Letter","Lucky Egg","Wisteria Lumber"},                                                                                                   {1052,1150,4600,1414}},
        {"Lower Delkfutt's Tower",   {"Northern Fur"},                                                                                                                                                       {1199}},
        {"Qufim Island",             {"Ram Leather Missive"},                                                                                                                                                {1538}},
        {"Upper Delkfutt's Tower",   {"Delkfutt Key","Hoary Battle Horn","Moldy Buckler","Warrior's Testimony"},                                                                                             {549,2386,2385,1426}},
        {"Den of Rancor",            {"Rancor Den Coffer Key","Unlit Lantern","Wooden Hakutaku Eye"},                                                                                                        {1050,1138,1288}},
        {"Castle Zvahl Baileys",     {"Samurai's Testimony","Whine Cellar Key","Demon Pen"},                                                                                                                 {1437,1106,1653}},
        {"Castle Zvahl Keep",        {"Soiled Letter"},                                                                                                                                                      {1686}},
        {"Ranguemont Pass",          {"Glittersand"},                                                                                                                                                        {1107}},
        {"Bostaunieux Oubliette",    {"Carbuncle's Ruby"},                                                                                                                                                   {1125}},
        {"Toraimarai Canal",         {"Toraimarai Coffer Key","Starmite Shell"},                                                                                                                             {1057,906}},
        {"Zeruhn Mines",             {"Zeruhn Soot"},                                                                                                                                                        {560}},
        {"Korroloka Tunnel",         {"Impetus Earring","Marble"},                                                                                                                                           {16024,1836}},
        {"Kuftal Tunnel",            {"Bunny Fang Sack","Shoalweed","Kuftal Coffer Key","Cactuar Needle","Spectral Goldenrod"},                                                                              {1541,1148,1051,916,1844}},
        {"The Eldieme Necropolis",   {"Eldieme Coffer Key","Tavnazia Bell","Ancient Papyrus"},                                                                                                               {1046,1098,1088}},
        {"Sea Serpent Grotto",       {"Norg Shell","Sheep Leather Missive","Eastern Gem","Grotto Coffer Key","Leech Saliva"},                                                                                {1135,1542,1664,1059,1979}},
        {"Dangruf Wadi",             {"Dangruf Chest Key"},                                                                                                                                                  {1028}},
        {"Inner Horutoto Ruins",     {"Test Answers"},                                                                                                                                                       {544}},
        {"Outer Horutoto Ruins",     {"Asbestos Mitts"},                                                                                                                                                     {12796}},
        {"Ordelle's Caves",          {"Magicked Blood","Galka Fang Sack"},                                                                                                                                   {2777,1531}},
        {"Gusgen Mines",             {"Magicked Skull","Bloody Robe","Gusgen Clay","Pumice Stone"},                                                                                                          {538,540,569,2776}},
        {"Crawler's Nest",           {"Dasra's Ring","Exoray Mold","Royal Jelly","Derfland Humus","Loam"},                                                                                                   {15853,1089,4508,533,2016}},
        {"Maze of Shakhrami",        {"Burnite Shell","Mithra Fang Sack","Rusty Key","Inferior Cocoon"},                                                                                                     {16511,1534,543,2778}},
        {"Garlaige Citadel",         {"Bomb Coal","Garlaige Coffer Key"},                                                                                                                                    {1090,1047}},
        {"Fei'Yin",                  {"Eastern Pottery","Treasury Gold","Wandering Bulb"},                                                                                                                   {1200,1682,1158}},
        {"Ifrit's Cauldron",         {"Rattling Egg","Cauldron Coffer Key","Bomb Queen Core","Damp Hakutaku Eye"},                                                                                           {1189,1053,1186,1292}},
        {"Quicksand Caves",          {"Quicksand Coffer Key","Star Spinel"},                                                                                                                                 {1054,1149}},
        {"Gustav Tunnel",            {"Dark Knight's Testimony"},                                                                                                                                            {1433}},
        {"Labyrinth of Onzozo",      {"Beastmaster's Testimony","High-Quality Coeurl Hide"},                                                                                                                 {1434,1591}},
        {"Dynamis - Bastok",         {"Relic Axe","Relic Blade","Relic Scythe","Ito"},                                                                                                                       {18284,18278,18302,18314}},
        {"Dynamis - San d'Oria",     {"Ihintanto","Relic Bhuj","Relic Gun","Relic Lance"},                                                                                                                   {18308,18290,18332,18296}},
        {"Dynamis - Windurst",       {"Relic Dagger","Relic Knuckles","Relic Maul","Relic Sword"},                                                                                                           {18266,18260,18320,18272}},
        {"Dynamis - Jeuno",          {"Relic Bow","Relic Horn","Relic Shield","Relic Staff"},                                                                                                                {18344,18338,15066,18326}},
        {"Ru'Aun Gardens",           {"Ru'aun Coffer Key","Red Mage's Testimony"},                                                                                                                           {1058,1430}},
        {"Ve'Lugannon Palace",       {"Ve'Lugannon Coffer Key"},                                                                                                                                             {1060}},
        {"Al'Taieu",                 {"Aern Organ","Luminian Tissue","Hpemde Organ","Phuabo Organ","Xzomit Organ","Yovra Organ"},                                                                            {1786,1783,1787,1784,1785,1788}},
        {"Grand Palace of Hu'Xzoi",  {"Luminion Chip","Ghrah M Chip"},                                                                                                                                       {1819,1872}},
        {"The Garden of Ru'Hmet",    {"Euvhi Organ"},                                                                                                                                                        {1818}},
        {"Lufaise Meadows",          {"Extra-Fine File","Chameleon Diamond","Tavnazian Liver"},                                                                                                              {1698,1666,5154}},
        {"Misareaux Coast",          {"Silica","Misareaux Garlic"},                                                                                                                                          {1888,1661}},
        {"North Gustaberg [S]",      {"Obsidian"},                                                                                                                                                           {2531}},
        {"Grauberg [S]",             {"Dancer's Testimony","Red Oven Mitt","Grauberg Lettuce","Stygian Ash"},                                                                                                {2556,2527,5688,19210}},
        {"Pashhow Marshlands [S]",   {"Heavy Quadav Chestplate","Heavy Quadav Backplate"},                                                                                                                   {2504,2505}},
        {"Rolanberry Fields [S]",    {"Slug Eye","Goblin Weel"},                                                                                                                                             {2509,2543}},
        {"Vunkerl Inlet [S]",        {"Djinn Arm","Gigas Helm","Gigas Gauntlets"},                                                                                                                           {18729,2652,2653}},
        {"Jugner Forest [S]",       {"Gnole Claw","Cernunnos Bulb"},                                                                                                                                        {2521,2728}},
        {"Batllia Downs [S]",       {"Smilodon Liver","Goblin Mess Tin"},                                                                                                                                   {5668,2542}},
        {"Beaucedine Glacier [S]",  {"Iridium Ingot","Gargouille Eye","Gargouille Horn"},                                                                                                                   {2823,2749,2747}},
        {"Xarcabard [S]",           {"Cambric","Shagreen","Ruszor Meat","Ruszor Fang","Ruszor Hide"},                                                                                                       {2825,2824,5755,2754,2755}},
        {"East Ronfaure [S]",       {"Scholar's Testimony","Orc Pauldron"," Orc Helmet"},                                                                                                                   {2557,2511,2510}},
        {"Sauromugue Champaign [S]", {"108-knot Quipu","Yagudo Kote"},                                                                                                                                      {2562,2520}},
        {"Meriphataud Mountains [S]", {"Dorter Key","Bottled Pixie"},                                                                                                                                       {2567,2525}},
        {"Fort Karugo-Narugo [S]",  {"Rafflesia Vine"},                                                                                                                                                     {2513}},
        {"West Sarutabaruta [S]",   {"Lycopodium Flower","Dhalmel Hair"},                                                                                                                                   {2507,2539}},
        {"Castle Oztroja [S]",      {"Gnat Pellets","Yagudo Glue"},                                                                                                                                         {2566,2558}}

        -- Level capped areas for CW and WEW
        -- {"Phomiuna Aqueducts",       {"Taurus Horn","Bronze Key","Fomor Codex"},                                                                                                                             {1620,1660,1877}},
        -- {"Sacrarium",                {"Coral Crest Key","Sealion Crest Key","Sacrarium Chest Key"},                                                                                                          {1659,1658,1061}},
        -- {"Riverne Site-A01",         {"Giant Scale","Copper Key","Cluster Ash"},                                                                                                                             {1691,1665,1630}},
        -- {"Riverne Site-B01",         {"Clustered Tar","Giant Scale"},                                                                                                                                        {1880,1691}},
    }

    -- Handles the functionality of the "daily reset" at midnight
    local handleMidnight = function(player)
        local questMidnight = player:getCharVar("[DQ]Midnight")
        local currentMidnight = getMidnight()

        -- handle first time quest midnight
        if questMidnight == 0 then
            player:setCharVar("[DQ]Midnight", currentMidnight)
            player:setCharVar("[DQ]Completed", 0)
            player:setCharVar("[DQ]Reset", 0)
            player:setCharVar("[DQ]Fishstix", 0)
            player:setCharVar("[DQ]Fishstix_Z", 0)
            player:setCharVar("[DQ]Murdoc", 0)
            player:setCharVar("[DQ]Murdoc_Z", 0)
            player:setCharVar("[DQ]Murdoc_MT", 0)
            player:setCharVar("[DQ]Murdoc_KA", 0)
            player:setCharVar("[DQ]Mistrix", 0)
            player:setCharVar("[DQ]Mistrix_I", 0)
            player:setCharVar("[DQ]Saltlik", 0)
            player:setCharVar("[DQ]Saltlik_Z", 0)
            player:setCharVar("[DQ]Saltlik_NM", 0)
            player:setCharVar("[DQ]Beetrix", 0)
            player:setCharVar("[DQ]Beetrix_Z", 0)
            player:setCharVar("[DQ]Beetrix_RE", 0)
        end
        
        -- handle midnight reset
        if currentMidnight ~= questMidnight then
            player:setCharVar("[DQ]Midnight", currentMidnight)
            player:setCharVar("[DQ]Completed", 0)
            player:setCharVar("[DQ]Reset", 0)
            player:setCharVar("[DQ]Fishstix", 0)
            player:setCharVar("[DQ]Fishstix_Z", 0)
            player:setCharVar("[DQ]Murdoc", 0)
            player:setCharVar("[DQ]Murdoc_Z", 0)
            player:setCharVar("[DQ]Murdoc_MT", 0)
            player:setCharVar("[DQ]Murdoc_KA", 0)
            player:setCharVar("[DQ]Mistrix", 0)
            player:setCharVar("[DQ]Mistrix_I", 0)
            player:setCharVar("[DQ]Saltlik", 0)
            player:setCharVar("[DQ]Saltlik_Z", 0)
            player:setCharVar("[DQ]Saltlik_NM", 0)
            player:setCharVar("[DQ]Beetrix", 0)
            player:setCharVar("[DQ]Beetrix_Z", 0)
            player:setCharVar("[DQ]Beetrix_RE", 0)
        end
    end

    -- Adds the NPC into Lower Jeuno
    local beetrix = zone:insertDynamicEntity({

        objtype = xi.objType.NPC,
        name = "Beetrix",
        look = 494,
        x = -50.7539,
        y = 0.000,
        z = -56.3718,
        rotation = 19,
        widescan = 1,

        -- Handles the ability to reset daily quest for 50k gil
        onTrade = function(player, npc, trade)
            -- Check to see if daily reset needs to happen first
            handleMidnight(player)
            npc:facePlayer(player, true)

            local questStage = player:getCharVar("[DQ]Beetrix")
            local completedDailyQuests = player:getCharVar("[DQ]Completed")
            local resetCount = player:getCharVar("[DQ]Reset")
            local gil = trade:getGil()
            local cost = 50000

            if player:isCrystalWarrior() then
                cost = 15000
            end

            -- If the player makes a trade with 50k gil
            if gil == cost then
                -- If they trade something else besides gil
                if trade:getItemCount() ~= 1 then
                    player:printToPlayer("I only accept gil as payment.", 0, npc:getPacketName())
                    return
                else
                    -- If the daily is already not given out, no need to reset
                    if questStage == 0 then
                        player:printToPlayer("You don't need to reset this daily, the quest has not been given yet.", 0, npc:getPacketName())
                        return
                    -- If the daily is already completed, no reset allowed
                    elseif questStage == 2 then
                        player:printToPlayer("You can't reset a completed daily. Come back tomorrow for more.", 0, npc:getPacketName())
                        return
                    else
                        -- If they've already done their 3 resets a day, no more reset allowed
                        if resetCount >= 3 then
                            player:printToPlayer("You can only reset a daily quest a max of 3 times per day across ALL dailies. Come back tomorrow for more.", 0, npc:getPacketName())
                            return
                        else
                            -- If it's a valid reset, reset the daily
                            player:tradeComplete()
                            player:setCharVar("[DQ]Reset", resetCount + 1)
                            player:setCharVar("[DQ]Beetrix", 0)
                            player:setCharVar("[DQ]Beetrix_Z", 0)
                            player:setCharVar("[DQ]Beetrix_RE", 0)
                            player:printToPlayer(string.format("You have successfully reset my daily quest. Resets remaining today: %d.",(3 - (resetCount + 1))), 0, npc:getPacketName())
                        end
                    end
                end
            -- If they are trading in the items for the quest, NOT for the reset
            else
                -- This handles assigned the quest and handling setting the reward for quest completion
                if questStage == 1 then
                    -- Check to see if daily reset needs to happen first
                    handleMidnight(player)
                    local questZone = player:getCharVar("[DQ]Beetrix_Z")
                    local randrExItem = player:getCharVar("[DQ]Beetrix_RE")
                    local questRExItemName = questLocations[questZone][2][randrExItem]
                    local questRExItemID = questLocations[questZone][3][randrExItem]
                    -- Check to see if the traded right item and ONLY the right item
                    if npcUtil.tradeHasExactly(trade, questRExItemID) then
                        -- Handle the reward
                        player:tradeComplete()
                        player:incrementCharVar("[DQ]Beetrix_complete", 1)
                        player:setCharVar("[DQ]Beetrix",2)
                        player:setCharVar("[DQ]Completed", completedDailyQuests + 1, getMidnight())
                        player:printToPlayer("Congratulations! You've completed my quest for today, here's your reward!", 0, npc:getPacketName())
                        player:addCurrency('obsidian_fragment', 500)
                        player:printToPlayer("You have obtained 500 Obsidian Fragments!", 17)
                        return
                    else
                        player:printToPlayer(string.format("I said I need a %s, please try again!",string.upper(questRExItemName)), 0, npc:getPacketName())
                        return
                    end
                    return
                else
                    player:printToPlayer(string.format("You can trade me %u gil to reset this daily quest (3 resets a day max across all dailies).", cost), 0, npc:getPacketName())
                    return
                end
            end
        end,

        -- This handles assigning the quest
        onTrigger = function(player, npc)
            -- Check to see if daily reset needs to happen first
            handleMidnight(player)
            local questStage = player:getCharVar("[DQ]Beetrix")

            npc:facePlayer(player, true)

            -- Handle quest stages
            -- Quest hasn't been started yet, assign a random R/Ex item to go find
            if questStage == 0 then
                local randNum = math.random(1, #questLocations)
                local questZoneName = questLocations[randNum][1]
                local rExItemListLength = table.getn(questLocations[randNum][2])
                local randrExItem = math.random(1,rExItemListLength)
                local questRExItemName = questLocations[randNum][2][randrExItem]
                player:setCharVar("[DQ]Beetrix",1)
                player:setCharVar("[DQ]Beetrix_Z",randNum)
                player:setCharVar("[DQ]Beetrix_RE",randrExItem)
                player:printToPlayer(string.format("Go to %s, get a %s and trade it to me!",questZoneName, questRExItemName), 0, npc:getPacketName())
                return
            -- Quest has been started already, just reiterate their quest to them
            elseif questStage == 1 then
                local questZone = player:getCharVar("[DQ]Beetrix_Z")
                local randrExItem = player:getCharVar("[DQ]Beetrix_RE")
                local questZoneName = questLocations[questZone][1]
                local questRExItemName = questLocations[questZone][2][randrExItem]
                player:printToPlayer(string.format("Go to %s, get a %s and trade it to me!",questZoneName, questRExItemName), 0, npc:getPacketName())
                return
            -- The quest as already been completed
            elseif questStage == 2 then
                player:printToPlayer("You've already completed this quest today! Come back tomorrow for more.", 0, npc:getPacketName())
                return
            end
        end,
    })

    utils.unused(beetrix)
end)

return m
