-----------------------------------
-- CW-Trust Permits
-----------------------------------
require("modules/module_utils")
require("scripts/globals/npc_util")
require("scripts/globals/utils")
-----------------------------------
local m = Module:new("cw_trust_permits")

-- Trust Permit Quests
local blockTrustMessage = "Crystal Warriors must complete their quests to unlock Trusts."
local blockTrustClassic = "Your character type cannot unlock Trusts."

------------------------------------------
-- BASTOK
------------------------------------------
--[[  HANDLED IN BASTOK TRUST LUA 
m:addOverride("xi.zones.Port_Bastok.npcs.Clarion_Star.onTrigger", function(player, npc)
    local ID = require("scripts/zones/Port_Bastok/IDs")

    if
        player:isCrystalWarrior() and
        player:hasKeyItem(xi.keyItem.BASTOK_TRUST_PERMIT) == false
    then
        player:printToPlayer(blockTrustMessage, xi.msg.channel.SYSTEM_3)
        return
    else
        super(player, npc)
    end
end)
]]--
m:addOverride("xi.zones.Port_Bastok.npcs.Clarion_Star.onTrade", function(player, npc, trade)
    local ID = require("scripts/zones/Port_Bastok/IDs")

    if player:isClassicMode() then
        player:printToPlayer(blockTrustClassic, xi.msg.channel.SYSTEM_3)
        return
    end

    if
        player:isCrystalWarrior() and
        not player:hasKeyItem(xi.keyItem.BASTOK_TRUST_PERMIT)
    then
        player:printToPlayer(blockTrustMessage, xi.msg.channel.SYSTEM_3)
        return
    else
        super(player, npc, trade)
    end
end)

m:addOverride("xi.zones.Port_Bastok.npcs.Clarion_Star.onEventUpdate", function(player, csid, option)
    local ID = require("scripts/zones/Port_Bastok/IDs")

    if player:isClassicMode() then
        player:printToPlayer(blockTrustClassic, xi.msg.channel.SYSTEM_3)
        return
    end

    if
        player:isCrystalWarrior() and
        not player:hasKeyItem(xi.keyItem.BASTOK_TRUST_PERMIT)
    then
        player:printToPlayer(blockTrustMessage, xi.msg.channel.SYSTEM_3)
        return
    else
        super(player, csid, option)
    end
end)

------------------------------------------
-- SANDORIA
------------------------------------------
m:addOverride("xi.zones.Southern_San_dOria.npcs.Gondebaud.onTrigger", function(player, npc)
    local ID = require("scripts/zones/Southern_San_dOria/IDs")

    if player:isClassicMode() then
        player:printToPlayer(blockTrustClassic, xi.msg.channel.SYSTEM_3)
        return
    end

    if player:isCrystalWarrior() and
        not player:hasKeyItem(xi.keyItem.SAN_DORIA_TRUST_PERMIT)
    then
        player:printToPlayer(blockTrustMessage, xi.msg.channel.SYSTEM_3)
        return
    else
        super(player, npc)
    end
end)

m:addOverride("xi.zones.Southern_San_dOria.npcs.Gondebaud.onTrade", function(player, npc, trade)
    local ID = require("scripts/zones/Southern_San_dOria/IDs")

    if player:isClassicMode() then
        player:printToPlayer(blockTrustClassic, xi.msg.channel.SYSTEM_3)
        return
    end

    if
        player:isCrystalWarrior() and
        not player:hasKeyItem(xi.keyItem.SAN_DORIA_TRUST_PERMIT)
    then
        player:printToPlayer(blockTrustMessage, xi.msg.channel.SYSTEM_3)
        return
    else
        super(player, npc, trade)
    end
end)

m:addOverride("xi.zones.Southern_San_dOria.npcs.Gondebaud.onEventUpdate", function(player, csid, option)
    local ID = require("scripts/zones/Southern_San_dOria/IDs")

    if player:isClassicMode() then
        player:printToPlayer(blockTrustClassic, xi.msg.channel.SYSTEM_3)
        return
    end

    if
        player:isCrystalWarrior() and
        not player:hasKeyItem(xi.keyItem.SAN_DORIA_TRUST_PERMIT)
    then
        player:printToPlayer(blockTrustMessage, xi.msg.channel.SYSTEM_3)
        return
    else
        super(player, csid, option)
    end
end)

------------------------------------------
-- WINDURST
------------------------------------------
m:addOverride("xi.zones.Windurst_Woods.npcs.Wetata.onTrigger", function(player, npc)
    local ID = require("scripts/zones/Windurst_Woods/IDs")

    if player:isClassicMode() then
        player:printToPlayer(blockTrustClassic, xi.msg.channel.SYSTEM_3)
        return
    end

    if player:isCrystalWarrior() and
        not player:hasKeyItem(xi.keyItem.WINDURST_TRUST_PERMIT)
    then
        player:printToPlayer(blockTrustMessage, xi.msg.channel.SYSTEM_3)
        return
    else
        super(player, npc)
    end
end)

m:addOverride("xi.zones.Windurst_Woods.npcs.Wetata.onTrade", function(player, npc, trade)
    local ID = require("scripts/zones/Port_Bastok/IDs")

    if player:isClassicMode() then
        player:printToPlayer(blockTrustClassic, xi.msg.channel.SYSTEM_3)
        return
    end

    if
        player:isCrystalWarrior() and
        not player:hasKeyItem(xi.keyItem.WINDURST_TRUST_PERMIT)
    then
        player:printToPlayer(blockTrustMessage, xi.msg.channel.SYSTEM_3)
        return
    else
        super(player, npc, trade)
    end
end)

m:addOverride("xi.zones.Windurst_Woods.npcs.Wetata.onEventUpdate", function(player, csid, option)
    local ID = require("scripts/zones/Windurst_Woods/IDs")

    if player:isClassicMode() then
        player:printToPlayer(blockTrustClassic, xi.msg.channel.SYSTEM_3)
        return
    end

    if
        player:isCrystalWarrior() and
        not player:hasKeyItem(xi.keyItem.WINDURST_TRUST_PERMIT)
    then
        player:printToPlayer(blockTrustMessage, xi.msg.channel.SYSTEM_3)
        return
    else
        super(player, csid, option)
    end
end)


return m
