-----------------------------------
-- Skillup unlocks
-----------------------------------
require("modules/module_utils")
require("scripts/globals/utils")
-----------------------------------
local m = Module:new("cw_skillup")

local skillName =
{
    [xi.skill.WOODWORKING]  = "WOODWORKING",
    [xi.skill.SMITHING]     = "SMITHING",
    [xi.skill.GOLDSMITHING] = "GOLDSMITHING",
    [xi.skill.CLOTHCRAFT]   = "CLOTHCRAFT",
    [xi.skill.LEATHERCRAFT] = "LEATHERCRAFT",
    [xi.skill.BONECRAFT]    = "BONECRAFT",
    [xi.skill.ALCHEMY]      = "ALCHEMY",
    [xi.skill.COOKING]      = "COOKING",
}

m:addOverride("xi.player.onPlayerSkillUp", function(player, skillID, origLevel, skillUpAmount)
    super(player, skillID, origLevel, skillUpAmount)

    local level = player:getCharSkillLevel(skillID)
    if
        not player:isCrystalWarrior() or
        math.floor(level / 10) == math.floor(origLevel / 10)
    then
        return
    end

    local progVar  = string.format("[CW]SKILL_%s", skillName[skillID])
    local received = player:getCharVar(progVar)
    local rank     = level / 100

    if not utils.mask.getBit(received, rank) then
        local result = utils.mask.setBit(received, rank, true)
        player:setCharVar(progVar, result)

        local currSize = player:getContainerSize(xi.inv.MOGCASE)

        if currSize < 80 then
            local str = string.format(
                "\129\154 Your %s capacity has been increased by %i from %i to %i! \129\154",
                "Mog Case", 1, currSize, currSize + 1)

            player:printToPlayer(str, xi.msg.channel.SYSTEM_3)
            player:changeContainerSize(xi.inv.MOGCASE, 1)
        end
    end
end)

return m
