-----------------------------------
-- Crystal Warrior - Prestige system
-----------------------------------
require("modules/module_utils")
require("scripts/globals/player")
-----------------------------------
local m = Module:new("cw_prestige")

m:addOverride("xi.player.onGameIn", function(player, firstLogin, zoning)
    super(player, firstLogin, zoning)

    if
        not player:isCrystalWarrior() or
        player:getCharVar("[CW]MASTER") == 0
    then
        return
    end

    for jobID = xi.job.WAR, xi.job.RUN do
        if cexi.prestige[jobID] ~= nil then
            local tier = player:getCharVar(fmt("[CW]PRESTIGE_{}", xi.jobNames[jobID][1]))

            if
                tier > 0 and
                type(cexi.prestige[jobID][1]) == "number"
            then
                player:addMod(cexi.prestige[jobID][1], cexi.prestige[jobID][2][tier])
            end
        end
    end

    local corValue = player:getCharVar("[CW]PRESTIGE_COR")

    if corValue > 0 then
        player:addListener("EXPERIENCE_POINTS", "CW_EXP_GIL", function(player, mob, exp)
            local totalGil = 1 + math.floor((exp / 10) * corValue)
            local ID       = zones[player:getZoneID()]
            player:addGil(totalGil)
            player:messageSpecial(ID.text.GIL_OBTAINED, totalGil)
        end)
    end


    local thfValue = player:getCharVar("[CW]PRESTIGE_THF")

    if thfValue > 0 then
        if player:getMainJob() ~= xi.job.THF then
            player:addMod(xi.mod.TREASURE_HUNTER, thfValue)
        end
    end
end)

return m
