-----------------------------------
-- Unlock Mog Wardrobe slots as you defeat important NMs
-----------------------------------
require("modules/module_utils")
require("scripts/globals/missions")
require("scripts/globals/utils")
local unlocks = require("modules/catseyexi/lua/additive_overrides/utils/custom_unlocks")
-----------------------------------
local m = Module:new("cw_nm_unlocks")

local function awardIncrease(player, unlock, index)
    local current = player:getCharVar("[CW]NM_UNLOCK")

    -- If player already gained this unlock, just skip
    if utils.mask.getBit(current, index) then
        return
    end

    local bag = unlock[1]
    local bagName = unlocks.bagNames[bag]
    local bagIncrease = unlock[2]

    local oldSize = player:getContainerSize(bag)
    player:changeContainerSize(bag, bagIncrease)
    local newSize = player:getContainerSize(bag)

    -- Update bitmask
    player:setCharVar("[CW]NM_UNLOCK", utils.mask.setBit(current, index, true))

    local str = string.format(
        "\129\154 Your %s capacity has been increased by %i from %i to %i! \129\154",
        bagName, bagIncrease, oldSize, newSize)

    player:printToPlayer(str, xi.msg.channel.SYSTEM_3)
end

for index, nmInfo in pairs(unlocks.nmKills) do
    local area = nmInfo[1]
    local name = nmInfo[2]

    if nmInfo[4] then
        xi.module.ensureTable(string.format("xi.zones.%s.mobs.%s", area, name))
    end

    m:addOverride(string.format("xi.zones.%s.mobs.%s.onMobDeath", area, name), function(mob, player, optParams)
        super(mob, player, optParams)

        local alliance = player:getAlliance()

        for _, member in pairs(alliance) do
            if
                member:isPC() and
                member:isCrystalWarrior()
            then
                awardIncrease(member, nmInfo[3], index)
            end
        end
    end)
end

return m
