-----------------------------------
-- Crystal Warrior Extra
-- For use with crystal_base.cpp and crystal_util.cpp
-----------------------------------
require("modules/module_utils")

require("scripts/globals/trust")
require('scripts/globals/player')
require("scripts/globals/caskets")
require("scripts/globals/artisan")
require("scripts/globals/homepoint")
require("scripts/events/login_campaign")

-- Load NPCs for override
require("scripts/zones/Port_Bastok/npcs/Clarion_Star")
require("scripts/zones/Windurst_Woods/npcs/Wetata")
require("scripts/zones/Southern_San_dOria/npcs/Gondebaud")
-----------------------------------
local m = Module:new("cw_extra")

local vars =
{
    CW_TRUST = "[CW]TRUST",
}

-- Restrict outside assistance
-- Handled here to avoid core changes and give flexibility
local helpfulSpell =
{
    "white.cure",
    "white.cure_ii",
    "white.cure_iii",
    "white.cure_iv",
    "white.cure_v",
    "white.cure_vi",

    "white.blindna",
    "white.cursna",
    "white.paralyna",
    "white.poisona",
    "white.silena",
    "white.stona",
    "white.viruna",

    "white.haste",
    "white.protect",
    "white.protect_ii",
    "white.protect_iii",
    "white.protect_iv",
    "white.protect_v",
    "white.shell",
    "white.shell_ii",
    "white.shell_iii",
    "white.shell_iv",
    "white.shell_v",

    "blue.wild_carrot",
    -- TODO
}

for _, spell in pairs(helpfulSpell) do
    m:addOverride(string.format("xi.actions.spells.%s.onMagicCastingCheck", spell), function(caster, target, spell)
        if
            not caster:hasStatusEffect(xi.effect.ELVORSEAL) and
            caster:isPC() and
            not caster:isCrystalWarrior() and
            target:isCrystalWarrior()
        then
            return xi.msg.basic.CANNOT_PERFORM_TARG
        else
            return super(caster, target, spell)
        end
    end)
end

m:addOverride("xi.artisan.moogleOnTrigger", function(player, npc)
    if player:isCrystalWarrior() then
        player:printToPlayer("Crystal Warriors cannot use Artisan Moogles.", xi.msg.channel.SYSTEM_3)
    else
        super(player, npc)
    end
end)

m:addOverride("xi.artisan.onEventFinish", function(player, csid, option)
    if player:isCrystalWarrior() then
        player:printToPlayer("Crystal Warriors cannot use Artisan Moogles.", xi.msg.channel.SYSTEM_3)
    else
        super(player, csid, option)
    end
end)

-----------------------------------
-- Rank Renouncement functions
-----------------------------------
m:addOverride("xi.crafting.guildMasterOnEventFinish", function(player, csid, option, npc)
    if
        player:isCrystalWarrior() and
        option >= xi.skill.WOODWORKING and
        option <= xi.skill.COOKING
    then
        player:printToPlayer("Crystal Warriors cannot renounce their rank and have no need to, as all crafts can be maxed.", xi.msg.channel.SYSTEM_3)
    else
        super(player, csid, option, npc)
    end
end)

m:addOverride("xi.caskets.spawnCasket", function(player, mob, x, y, z, r)
    if mob:getLocalVar("NO_CASKET") == 1 then
        return
    else
        super(player, mob, x, y, z, r)
    end
end)

return m
