-----------------------------------
-- Crystal Warrior Dynamis Time Extension
-----------------------------------
-- CWs do not receive time extensions but gain +20% Venture Points per TE
-----------------------------------
require("modules/module_utils")
-----------------------------------
local m = Module:new("cw_dynamis_ventures")

-----------------------------------
-- Dynamis Effect Bonuses
-----------------------------------
m:addOverride("xi.effects.dynamis.onEffectGain", function(player, effect)
    super(player, effect)

    if not player:isCrystalWarrior() then
        return
    end

    -- Player isn't fully loaded when effect applies
    player:timer(3000, function()
        local dynamisCurrent = player:getCharVar("[VENTURE]DYNAMIS_CURRENT")

        if
            cexi.ventures.dynamis.ventures[1][dynamisCurrent] ~= nil and
            cexi.ventures.dynamis.ventures[1][dynamisCurrent].area == player:getZoneName()
        then
            -- TE Bonus Buffs
            cexi.crystal_warrior.dynamis.applyBonus(player)

            -- Boss Bonus Buffs
            if cexi.ventures.dynamis.ventures[1][dynamisCurrent].boss ~= nil then
                local progress = player:getCharVar("[VENTURE]DYNAMIS_BOSS")

                for index, mobInfo in pairs(cexi.ventures.dynamis.ventures[1][dynamisCurrent].boss) do
                    if utils.mask.getBit(progress, index) then
                        player:setMod(mobInfo.mods[1], mobInfo.mods[2])
                        effect:addMod(mobInfo.mods[1], mobInfo.mods[2])
                    end
                end
            end
        end
    end)
end)

-----------------------------------
-- Dynamis Time Extensions
-----------------------------------
for _, ventureInfo in pairs(cexi.ventures.dynamis.ventures[1]) do
    if ventureInfo.boss ~= nil then
        for index, mobInfo in pairs(ventureInfo.boss) do
            m:addOverride(fmt("xi.zones.{}.mobs.{}.onMobDeath", ventureInfo.area, mobInfo.name), function(mob, player, optParams)
                super(mob, player, optParams)

                if
                    player == nil or
                    not player:isCrystalWarrior()
                then
                    return
                end

                local progress = player:getCharVar("[VENTURE]DYNAMIS_BOSS")

                if not utils.mask.getBit(progress, index) then
                    local effect = player:getStatusEffect(xi.effect.DYNAMIS)

                    progress = utils.mask.setBit(progress, index, true)
                    player:setCharVar("[VENTURE]DYNAMIS_BOSS", progress)

                    player:fmt("Dynamis Prowess Increased! {}", mobInfo.desc)

                    player:setMod(mobInfo.mods[1], mobInfo.mods[2])
                    effect:addMod(mobInfo.mods[1], mobInfo.mods[2])
                end
            end)
        end
    end
end

m:addOverride("xi.dynamis.timeExtensionOnDeath", function(mob, player, optParams)
    if
        player == nil or
        not player:isCrystalWarrior()
    then
        return super(mob, player, optParams)
    end

    local dynamisCurrent = player:getCharVar("[VENTURE]DYNAMIS_CURRENT")

    if
        cexi.ventures.dynamis.ventures[1][dynamisCurrent] == nil or
        cexi.ventures.dynamis.ventures[1][dynamisCurrent].area ~= player:getZoneName()
    then
        return super(mob, player, optParams)
    end

    local mobId             = mob:getID()
    local zoneId            = mob:getZoneID()
    local ID                = zones[zoneId]
    local timeExtensionMobs = ID.mob.TIME_EXTENSION

    if timeExtensionMobs == nil then
        return
    end

    local found = false
    local te    = nil
    local group = {}

    -- find this TE's group
    for _, t in pairs(timeExtensionMobs) do
        if type(t.mob) == 'number' then
            group = { t.mob }
        elseif type(t.mob) == 'table' then
            group = { unpack(t.mob) }
        end

        for _, g in pairs(group) do
            if g == mobId then
                found = true
                te    = t
                break
            end
        end

        if found then
            break
        end
    end

    if found and te then
        -- award KI to those who have not yet received it
        local effect = player:getStatusEffect(xi.effect.DYNAMIS)

        if
            effect and
            not player:hasKeyItem(te.ki) and
            npcUtil.giveKeyItem(player, te.ki)
        then
            local current = player:getCharVar("[VENTURE]DYNAMIS_TE")

            if not utils.mask.getBit(current, cexi.crystal_warrior.dynamis.timeExtensions[te.ki]) then
                local bonus = cexi.crystal_warrior.dynamis.applyBonus(player, te.ki)
                bonus = utils.clamp(bonus, 1, 5)
                player:fmt("Dynamis Prowess Increased ({}/5)! Venture Rewards +{}% / Stats +{}%", bonus, 20 * bonus, 5 * bonus)
            end
        end

        -- spawn a new mob in this group
        if optParams.isKiller then
            local teId = group[math.random(1, #group)]
            if teId ~= mobId then
                DisallowRespawn(mobId, true)
                DisallowRespawn(teId, false)
            end

            GetMobByID(teId):setRespawnTime(85)
        end
    end
end)

return m
